# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ConnectionInterfacePrivacy(dbus.service.Interface):
    """\
      An interface to support getting and setting privacy modes to configure
    situations such as not being contactable by people who are not on your
    subscribe list. If this interface is not implemented, the default can be
    presumed to be allow-all (as defined in GetPrivacyModes).
    """

    def __init__(self):
        self._interfaces.add('org.freedesktop.Telepathy.Connection.Interface.Privacy')

    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Privacy', in_signature='', out_signature='s')
    def GetPrivacyMode(self):
        """
        Return the current privacy mode, which must be one of the values
        returned by GetPrivacyModes.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Privacy', in_signature='', out_signature='as')
    def GetPrivacyModes(self):
        """
        Returns the privacy modes available on this connection. The following
        well-known names should be used where appropriate:
        
          allow-allany contact may initiate communication
          allow-specifiedonly contacts on your 'allow' list may initiate communication
          allow-subscribedonly contacts on your subscription list may initiate communication
         
       
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Privacy', in_signature='s', out_signature='')
    def SetPrivacyMode(self, mode):
        """
        Request that the privacy mode be changed to the given value, which
        must be one of the values returned by GetPrivacyModes. Success is
        indicated by the method returning and the PrivacyModeChanged
        signal being emitted.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Connection.Interface.Privacy', signature='s')
    def PrivacyModeChanged(self, mode):
        """
        Emitted when the privacy mode is changed or the value has been
        initially received from the server.
      
        """
        pass
  