/*  $Id: gui_tracer.pl,v 1.12 2006/08/04 14:24:01 jan Exp $

    Part of XPCE --- The SWI-Prolog GUI toolkit

    Author:        Jan Wielemaker and Anjo Anjewierden
    E-mail:        jan@swi.psy.uva.nl
    WWW:           http://www.swi.psy.uva.nl/projects/xpce/
    Copyright (C): 1985-2002, University of Amsterdam

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    As a special exception, if you link this library with other files,
    compiled with a Free Software compiler, to produce an executable, this
    library does not by itself cause the resulting executable to be covered
    by the GNU General Public License. This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
*/

:- module(gui_tracer,
	  [ guitracer/0,
	    noguitracer/0,		% Switch it off
	    prolog_break_at/3,		% +File, +Line, +Pos
	    gtrace/0,			% Start tracer and trace
	    gspy/1,			% Start tracer and set spypoint
	    gdebug/0			% Start tracer and debug
	  ]).

:- module_transparent
	gspy/1.

guitracer :-
	current_prolog_flag(gui_tracer, true), !.
guitracer :-
	current_prolog_flag(gui_tracer, _), !,
	set_prolog_flag(gui_tracer, true),
	visible(+cut_call),
	print_message(informational, gui_tracer(true)).
guitracer :-
	load_files([library('trace/trace')],
		   [ silent(true),
		     if(not_loaded)
		   ]),
	set_prolog_flag(gui_tracer, true),
	visible(+cut_call),
	print_message(informational, gui_tracer(true)).

noguitracer :-
	current_prolog_flag(gui_tracer, true), !,
	set_prolog_flag(gui_tracer, false),
	visible(-cut_call),
	print_message(informational, gui_tracer(false)).
noguitracer.

%	gtrace/0
%	
%	Like trace/0, but uses the graphical tracer.

:- '$hide'(gtrace,0).			% don't trace it

gtrace :-
	guitracer,
	trace.

%%	gspy(+Spec)
%	
%	Like spy/1, but uses the graphical tracer.

gspy(Predicate) :-
	guitracer,
	spy(Predicate).

%	gdebug
%	
%	Like debug/0, but uses the graphical tracer.

gdebug :-
	guitracer,
	debug.

%%	prolog_break_at(+File, +Line, +Pos)
%
%	Set a Prolog break-point.  Used to set break-points from PceEmacs.

prolog_break_at(File, Line, Pos) :-
	guitracer,
	prolog_break:break_at(File, Line, Pos).


		 /*******************************
		 *	      MESSAGES		*
		 *******************************/

:- multifile
	prolog:message/3.

prolog:message(gui_tracer(true)) -->
	['The graphical front-end will be used for subsequent tracing'].
prolog:message(gui_tracer(false)) -->
	['Subsequent tracing uses the commandline tracer'].
