/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/12 21:13:17 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/paragui_types.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.8 $
    Status:           $State: Exp $
*/

#ifndef PARAGUI_TYPES_H
#define PARAGUI_TYPES_H

#ifdef SWIG
%include "swigcommon.h"
%module paragui_types
%{
#include "paragui_types.h"
%}
#endif

// Forward declarations

class PG_MessageObject;
class PG_Widget;
class PG_EventObject;
class PG_Rect;

#ifdef __cplusplus
extern "C" {
#endif

// PG_Point

typedef struct {
	int x;
	int y;
}
PG_Point;


// PG_Gradient

typedef struct {
	SDL_Color colors[4];
}
PG_Gradient;

#ifndef DOXYGEN_SKIP
typedef unsigned long MSG_ID;
typedef unsigned long MSG_DATA;
#endif

typedef enum {
	MSG_BUTTONCLICK,
	MSG_SCROLLPOS,
	MSG_SLIDEEND = MSG_SCROLLPOS,
	MSG_SCROLLTRACK,
	MSG_SLIDE = MSG_SCROLLTRACK,
	MSG_THREAD_SIGNAL,
	MSG_SIGNAL,
	MSG_QUIT,
	MSG_EDITBEGIN,
	MSG_EDITEND,
	MSG_APPIDLE,
	MSG_SELECTITEM,
	MSG_VIDEORESIZE,
	MSG_SPINNER_CHANGE,
	MSG_WINDOWCLOSE,
	MSG_WINDOWMINIMIZE,
	MSG_WINDOWRESTORE,
	MSG_USER_1 = 10001,
	MSG_USER_2 = 10002,
	MSG_USER_3 = 10003,
	MSG_USER_4 = 10004,
	MSG_USER_5 = 10005,
	MSG_USER_6 = 10006,
	MSG_USER_7 = 10007,
	MSG_USER_8 = 10008,
	MSG_USER_9 = 10009,
	MSG_USER_10 = 10010
} PG_MSG_TYPE;

typedef enum {
	PG_ACT_ACTIVATE,
	PG_ACT_DEACTIVATE,
	PG_ACT_OK,
	PG_ACT_CANCEL,
	PG_ACT_LEFT,
	PG_ACT_RIGHT,
	PG_ACT_UP,
	PG_ACT_DOWN
} PG_ACTION;

#define PG_BlitSurface(srf_src, rect_src, srf_dst, rect_dst) \
PG_Application::LockScreen(); \
SDL_BlitSurface(srf_src, (PG_Rect*)&rect_src, srf_dst, (PG_Rect*)&rect_dst); \
PG_Application::UnlockScreen()

#define PG_UpdateRects(surface, count, rect) \
PG_Application::LockScreen(); \
SDL_UpdateRects(surface, count, rect); \
PG_Application::UnlockScreen()

#define PARAGUI_CALLBACK(funcname) \
bool funcname (int id, PG_Widget* widget, unsigned long data, void *clientdata)

typedef bool (*MSG_CALLBACK)(int id, PG_Widget* widget, unsigned long data, void *clientdata);

#ifndef SWIG
typedef bool (PG_EventObject::*MSG_CALLBACK_OBJ)(int id, PG_Widget* widget, unsigned long data, void* clientdata);
#endif

// MSG_MESSAGE

#ifndef DOXYGEN_SKIP
typedef struct {
	PG_MSG_TYPE	type;
	PG_MessageObject* from;
	PG_MessageObject* to;
	unsigned long widget_id;
	unsigned long data;
	PG_Point pt;
}
MSG_MESSAGE;
#endif

#ifdef __cplusplus
}
#endif

#endif // PARAGUI_TYPES_H
