/*  cssed (c) Iago Rubio, 2003-2004 - A tiny CSS editor.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/** @file cssdialogs-class.h
 *  @brief Header file for cssed dialog classes used by auto completion. 
 */
 
/** @typedef CssDialogClass.  
 *  @brief An utility data type for ::_cssdialog_class structures.
 */
 
 /** A convenient structure to pass data to callbacks when using ::CssDialogClass functions.  
 *	It's used to pass data to callbacks. You've got no need to use it
 *	if you don't like it.
 */	
typedef struct _CssedCssDialogsData {
	/** A pointer to the main ::CssedWindow object */
	CssedWindow* main_window;
	/** A pointer to a null terminated char array or NULL */
	gchar* previous_string;
	/** A boolean telling us if we must write down the string in ::previous_string */
	gboolean add_property_string;
} CssedCssDialogsData;

/** @struct _cssdialog_class.
 *  @brief This structure implements a dialog to be used by auto completion.
 */
typedef struct _CssDialogClass {
	/** The keyword. This will be freed with g_free so you must allocate it ( you can use g_strdup for this ) */
	gchar* keyword;	
	/** The dialog creation function. It must return a dialog widget to be shown on screen */
	GtkWidget* (*create_function) ( CssedWindow*, gchar *, gboolean, gboolean);
	/** The dialog get_string function. All those dialog only does one thing, to build a string to be added to the document,
		this function must return this string when the dialog is closed using the OK button. The string will be freed with 
		g_free, so it must be allocated	*/
	gchar* (*get_string_function) ( CssedWindow*, gpointer );
} CssDialogClass;

/** Returns a pointer to a new CssDialogClass. 
 *	It will reserve the memory for you, and this memory will be disposed by cssed so you don't need to release it.
 *  @return A pointer to reserved memory enough for a CssDialogClass structure.
 */
CssDialogClass*
css_dialog_class_new();

