<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"categorize" => "categorizar",
"Set prefs" => "Definir prefs",
"creation date" => "data de criação",
"last modification time" => "data da última modificação",
"Articles listing configuration" => "Configuração da listagem de artigos",
"PHPOpenTracker" => "PHPOpenTracker",
"Update" => "Atualizar",
"Set home forum" => "Definir o fórum inicial",
"Feed" => "Campo",
"enable/disable" => "habilita/desabilita",
"Max number of items" => "Número máximo de itens",
"Set feeds" => "Definir fontes",
"Create TAR dump" => "Criar exportação TAR",
"Create HTML dump" => "Criar exportação HTML",
"Download last TAR dump" => "Baixar a última exportação TAR",
"Access HTML dump" => "Acessar a exportação HTML",
"Wiki Page Names" => "Nomes de páginas Wiki",
"strict" => "restrito",
"Cache wiki pages" => "Realizar cache de páginas Wiki",
"\n for rows" => "\n para linhas",
"Enable watch by default for author" => "Habilitar notificação padrão para o autor",
"Enable watches when I am the editor" => "Habilitar notificações quando eu for o editor",
"assign_perms" => "definir_perms",
"assign group" => "definir grupo",
"view info" => "ver informações",
"Users can vote only one item from this chart per period" => "Usuários só podem votar em um item deste gráfico por período",
"Prevent users from voting same item more than one time" => "Evitar que os usuários votem mais de uma vez no mesmo item",
"half a second" => "meio segundo",
"Forward messages to this forum to this email" => "Enviar as mensagens destinadas a este fórum para o seguinte e-mail",
"Admin HTML page dynamic zones" => "Administrar zonas dinâmicas da página HTML",
"use dynamic content" => "usar conteúdo dinâmico",
"Users can subscribe any email addresss" => "Usuários podem assinar de qualquer endereço de email",
"create new empty structure" => "Criar uma nova estrutura vazia",
"Create structure from tree" => "Criar estrutura da cidade",
"Options (separated by commas used in dropdowns only)" => "Opções (separadas por vírgula, apenas em caixas de seleção)",
"Click here to create a new backup" => "Clique aqui para criar um novo backup",
"Note: if you want to use images please save the post first and you will be able to edit/post images. Use the snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor." => "Nota: se você deseja usar imagens, por favor salve a mensagem antes e você poderá editar/alterar imagens. Use o código para incluir imagens carregadas no editar de texto ou use o endereço da imagem para incluir imagens usando o editor WYSIWYG.",
"Click to enlarge" => "Clique para aumentar",
"Navigation Panel" => "Painel de Navegação",
"Hide Panels" => "Esconder Painéis",
"hide from display" => "esconder",
"Tiki Calendars" => "Calendários Tiki",
"browse by" => "visualizar por",
"If you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)." => "Se você alterar a seleção de calendário, por favor atualize a página para obter a lista apropriada de categorias, locais e pessoas (se for o caso para o calendário selecionado).",
"from the list" => "da lista",
"choose" => "escolher",
"with role" => "com perfil",
"Url" => "Endereço",
"You should first ask that a calendar is created, so you can create events attached to it." => "Você deve antes criar um calendário, para poder criar ventos anexados a ele.",
"Use (:name:) for smileys" => "Utilize (:nome:) para emoticons",
"Type help to get list of available commands" => "Digite ajuda para obter uma lista de comandos",
"Publish/Event Date" => "Data de Publicação/Evento",
"Displays preformated text/code; no Wiki processing is done inside these sections" => "Exibe texto/código-fonte pré-formatado; nenhum processamento wiki é efetuado dentro destas seções",
"wiki link" => "link Wiki",
"heading" => "cabeçalho",
"horizontal ruler" => "linha horizontal",
"center" => "centralizar",
"img nc" => "img nc",
"In parent page" => "Na página-pai",
"Newss from" => "News de",
"Assign permissions to this page" => "Definir permissões para esta página",
"You can include the image in an HTML/Tiki page using" => "Você pode incluir a imagem em uma página HTML/Tiki usando",
"Tiki forums" => "Fóruns do Tiki",
"Show Post Form" => "Exibir Formulário de Envio",
"Hide Post Form" => "Esconder Formulário de Envio",
"Your message has been queued for approval, the message will be posted after a moderator approves it." => "Sua mensagem está aguardando aprovação. A mensagem será postada após aprovação por um moderador.",
"smileys" => "emoticons",
"mot" => "mot",
"Mark as Flagged" => "Marcar como Selecionada",
"Wiki Import dump" => "Importar arq. exp. Wiki",
"Up" => "Acima",
"Down" => "Abaixo",
"Top Files" => "Arquivos mais populares",
"xx" => "xx",
"xxx" => "xxx",
"No such forum" => "Fórum inexistente",
"No image uploaded" => "Nenhuma imagem foi carregada",
"Permission denied you cannot browse this gallery" => "Permissão negada: você não pode visualizar esta galeria",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory" => "Endereço não pode ser acessado e adicionado ao diretório: URL incorreta ou site off-line",
"Anonymous users cannot edit pages" => "Usuários anônimos não podem editar páginas",
"Invalid password. You current password is required to change your email address." => "Senha inválida. Sua senha atual é necessária para alterar seu endereço de e-mail.",
"Current page:" => "Página atual:",
"version %s" => "versão %s",
"last modified on %s" => "última modificação em %s",
"by %s" => "por %s",
"Archived page:" => "Página arquivada:",
"Diff of %s." => "Diferenças de %s.",
"Displays a snippet of code.\nSet optional paramater -+ln+- to 1 if you need line numbering feature." => "Exibe um trecho de código-fonte.\nDefina o parâmetro opcional -+ln+- com o valor 1 se desejar numeração de linhas.",
"Split a page into columns" => "Dividir a página em colunas",
"column" => "coluna",
"Renders a graph" => "Desenha um gráfico",
"There is an error in the plugin data" => "Há um erro nos dados do plug-in",
"Insert articles into a wikipage" => "Incluir artigos numa página wiki",
"the space beetween nodes\n" => "o espaço entre nós\n",
"Quiz time limit excedeed quiz cannot be computed" => "Tempo do teste excedeu o limite e não pode ser computado",
"Unexistant link" => "Link Inexistente",
"Unexistant gallery" => "Galeria inexistente",
"Unexistant version" => "Versão inexistente",
"Unexistant user" => "Usuário inexistente",
"The user has choosen to make his information private" => "O usuário escolheu deixar suas informações privadas",
"Are you sure you want to delete this directory?" => "Você tem certeza que deseja remover este diretório?",
"Are you sure you want to delete this file?" => "Você tem certeza que deseja remover este arquivo?",
"You can view the page following this link:" => "Você pode ver a página pelo seguinte link:",
"Are you sure you want to delete this repository?" => "Você tem certeza que deseja remover este repositório?",
"Click here to delete this repository" => "Clique aqui para remover este repositório",
"Are you sure you want to delete this forum?" => "Você tem certeza que deseja remover este fórum?",
"Reduce area width" => "Reduzir a largura de área",
"Enlarge area width" => "Ampliar a largura de área",
"Delete item from category?" => "Remover item da categoria?",
"Are you sure you want to delete this category?" => "Você tem certeza que deseja remover esta categoria?",
"Are you sure you want to delete this tracker?" => "Você tem certeza que deseja remover este acompanhamento?",
"Click here to delete this tracker" => "Clique aqui para remover este acompanhamento",
"Are you sure you want to delete this contact?" => "Você tem certeza que deseja remover este contato?",
"Click here to delete this contact" => "Clique aqui para remover este contato",
"Are you sure you want to delete this attachment?" => "Você tem certeza que deseja remover este anexo?",
"Click here to delete this attachment" => "Clique aqui para remover este anexo",
"Click here to unassign this module" => "Clique aqui para desabilitar este módulo",
"Click here to edit this menu" => "Clique aqui para editar este menu",
"Click here to edit this comment" => "Clique aqui para editar este comentário",
"Are you sure you want to delete this comment?" => "Você tem certeza que deseja remover este comentário?",
"Click here to delete this comment" => "Clique aqui para remover este comentário",
"Are you sure you want to delete this rule?" => "Você tem certeza que deseja remover esta regra?",
"Click here to delete this rule" => "Clique aqui para remover esta regra",
"(Dropdown options : list of items separated with commas)" => "(Opções de dropdown : lista de itens separada por vírgulas)",
"(Image options : xSize,ySize indicated in pixels)" => "(Opções de imagens : xTamanho,yTamanho indicados em pixels)",
"Are you sure you want to delete this drawing?" => "Você tem certeza que deseja remover este desenho?",
"Click here to delete this drawing" => "Clique aqui para remover este desenho",
"Are you sure you want to delete this HTML page?" => "Você tem certeza que deseja remover esta página HTML?",
"Are you sure you want to delete this copyright?" => "Você tem certeza que deseja remover este copyright?",
"Click here to delete this copyright" => "Clique aqui para remover este copyright",
"Are you sure you want to delete this template?" => "Você tem certeza que deseja remover este modelo?",
"Click here to delete this template" => "Clique aqui para remover este modelo",
"Are you sure you want to delete this menu?" => "Você tem certeza que deseja remover este menu?",
"Click here to delete this menu" => "Clique aqui para remover este menu",
"Are you sure you want to delete this group?" => "Você tem certeza que deseja remover este grupo?",
"Are you sure you want to delete this external wiki?" => "Você tem certeza que deseja remover este wiki externo?",
"Thankyou for installing Tikiwiki" => "Obrigado por instalar o Tikiwiki",
"Click here to configure this menu" => "Clique aqui para configurar este menu",
"Are you sure you want to delete this dsn?" => "Você tem certeza que deseja remover este dsn?",
"Are you sure you want to delete this cookie?" => "Você tem certeza que deseja remover este cookie?",
"Click here to delete this cookie" => "Clique aqui para remover este cookie",
"Events Panel" => "Painel de Eventos",
"Hide" => "Esconder",
"Klick to enlarge" => "Clique para ampliar",
"Are you sure you want to delete this hotword?" => "Você tem certeza que deseja remover esta palavra-chave?",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appeareance of the page, no versions are stored for this page." => "A Caixa de Areia é a página onde você pode praticar suas edições. Use a funcionalidade de preview para ver a aparência da página editada. Nenhuma versão da página é armazenada.",
"Are you sure you want to delete this channel?" => "Você tem certeza que deseja remover este canal?",
"Click here to delete this channel" => "Clique aqui para remover este canal",
"LDAP Group Atribute" => "Atributo de Grupo LDAP",
"Email Encoding" => "Codificação do E-mail",
"Are you sure you want to delete this calendar?" => "Você tem certeza que deseja remover este calendário?",
"New message arrived from " => "Nova mensagem de ",
"Welcome to " => "Bem-vindo(a) a ",
" at " => " em ",
"Bye bye from " => "Saudações de ",
"New article submitted at " => "Novo artigo enviado em ",
"Your Tiki account information for" => "Informações da sua conta Tiki para",
" new topic:" => " novo tópico:",
"topic:" => "tópico:",
"You can edit the page following this link:" => "Você pode editar a página seguindo este link:",
"Diff:" => "Difer:",
"The new page content is:" => "O conteúdo da nova página é:",
"Threads can be voted" => "Seqüências podem ser votadas",
"Directory (include trailing slash)" => "Diretório (incluir barra invertida final)",
"Filters" => "Filtros",
"checked" => "marcado",
"unchecked" => "desmarcado",
"Show status when listing tracker items?" => "Exibir estado na lista de itens de acompanhamento?",
"remove bookmark" => "remover bookmark",
"Control by Object" => "Controlar por objeto",
"use square brackets for an" => "utilize colchetes para um",
"link_description" => "descricao_do_link",
"Prevents parsing data" => "Evita a interpretação de dados",
"In blog listing show user as" => "Na listagem de Blog mostrar o usuário como",
"Add New Group" => "Adicionar Novo Grupo",
"Edit this group:" => "Editar este grupo:",
"Return to messages" => "Retornar para mensagens",
"Unflagg" => "Desmarcar",
"Calendars Panel" => "Painel de Calendários",
"parent" => "pai",
"reply to this" => "responder",
"Control by category" => "Controlar por categoria",
"Select available themes:" => "Escolha os temas disponíveis:",
"Admin structures" => "Administrar estruturas",
"FAQ Questions" => "Perguntas do FAQ",
"FAQ Answers" => "Respostas do FAQ",
"Show suggested questions/suggest a question" => "Exibir perguntas sugeridas/sugerir uma pergunta",
"Hide suggested questions" => "Esconder perguntas sugeridas",
"save a custom copy" => "salvar uma cópia personalizada",
"Add users" => "Adicionar usuários",
"Reuse question" => "Reutilizar a pergunta",
"WebMail accounts" => "Contas de WebMail",
"Create New Survey:" => "Criar uma Nova Pesquisa:",
"Ranking" => "Ranking",
"The cord" => "The cord",
"Comm" => "Comm",
"Cms" => "Cms",
"AdminDSN" => "AdminDSN",
"ChatAdmin" => "ChatAdmin",
"op" => "op",
"ver" => "ver",
"note: those parameters are exclusive" => "nota: estes parâmetros são exclusivos",
"Renders a graph, with linked pages navigation visually figured.\n" => "Renderizar um gráfico, com links de navegação de páginas figurados.\n",
"the number of hops the graph follows\n" => "o número de degraus no gráfico seguem\n",
"the title of the map\n" => "o título do mapa\n",
"Left to Right, the direction of graph\n" => "Esquerda para a Direita, a direção do gráfico\n",
"the background color, use #rrvvbb color types.\n" => "a cor de fundo, use tipos de cor RGB.\n",
"nothing there, unlimited size. use 5,3 type sizes in inches\n" => "nada aqui, tamanho ilimitado. usar tipo 5,3 em polegadas\n",
"the font size in pts presumably\n" => "o tamanho da fonte presumível em pontos\n",
"the name of the font used for labels\n" => "o nome da fonte usada para rótulos\n",
"the shape of a node. can be " => "o formato de um nó pode ser ",
"plaintext ellipse circle egg triangle box diamond trapezium parallelogram house hexagon octagon\n" => "texto plano elipse circular ovo triângulo caixa diamante trapézio paralelogramo casa hexagonal octagonal\n",
"style for drawing nodes.\n" => "estilo para desenhar nós.\n",
"color of the border\n" => "cor da borda\n",
"background color of the node\n" => "cor de fundo do nó\n",
"sortof relative width ??\n" => "ordenar largura relativa ??\n",
"same mystery as above\n" => "mesmo mistério com acima\n",
"color for links (called edges here)\n" => "cor para links (chamar bordas aqui)\n",
"shape of the arrow that come with the link\n" => "formato da seta que vem com o link\n",
"Upload was not successful (maybe a duplicate file)" => "Carga interrompida com falha (possivelmente arquivo duplicado)",
"Security check failed!" => "Verificação de segurança falhou!",
"Warn on edit" => "Avisar na edição",
"Wiki page" => "Página Wiki",
"A password reminder email has been sent " => "Um lembrete da senha foi enviado",
"A new password has been sent " => "Uma nova senha foi enviada ",
"pageviews" => "visitas",
"Only an admin can remove a thread." => "Somente um administrador pode remover uma sequência.",
"forum topic" => "tópico do fórum",
"updated by the phpwiki import process" => "atualizada pelo processo de importação do phpwiki",
"created from phpwiki import" => "criada pela importação phpwiki",
"someone from" => "alguém de",
"You can include the image in an HTML or Tiki page using" => "Você pode incluir a imagem em uma página HTML ou Tiki usando",
"Received Pages" => "Páginas Recebidas",
"Tracker Items" => "itens do acompanhamento",
"For more information, please see WikiSyntax\non Tikiwiki.org." => "Para maiores informações, por favor veja WikiSyntax\nno Tikiwiki.org.",
"File gals" => "Gal. Arquivos",
"Image gals" => "Gal. Imagens",
"Content Templates" => "Padrões de Conteúdo",
"ExtWikis" => "WikisExternos",
"assgn" => "definir",
"CMS settings" => "Configuração de CMS",
"admin HtmlPages" => "administrar PáginasHtml",
"All tasks" => "Todas as tarefas",
"mark as done" => "marcar como realizada",
"open tasks" => "tarefas em aberto",
"Add or edit a task" => "Adicionar ou editar uma tarefa",
"Start date" => "Data de início",
"Completed" => "Realizada",
"admin ExternalWiki" => "administrar WikiExterno",
"MyTiki (click!)" => "MeuTiki (clique!)",
"Admin (click!)" => "Administração (clique!)",
"More info about" => "Mais informação sobre",
"idle" => "ocioso",
"MyTikiDoc" => "MeuTikiDoc",
"Posted comments" => "Comentários enviados",
"Reply to parent comment" => "Responder ao comentário pai",
"use filename" => "use o nome do arquivo",
"Go \r\n back" => "Ir \r\n voltar",
"Return to home \r\n page" => "Retornar para home \r\n página",
"Confirmation required" => "Confirmação requerida",
"Add scaled images size X x Y" => "Adicionar imagens em escala X por Y",
"Show chart for the last " => "Exibir o gráfico para os últimos ",
"days (0=all)" => "dias (0=todos)",
"Time Zone" => "Fuso horário",
"Server time zone" => "Fuso horário do servidor",
"Time Zone Map" => "Mapa de fuso horário",
"this post was reported" => "esta mensagem foi enviada",
"report this post" => "enviar esta mensagem",
"Import pages from a PHPWiki Dump" => "Importar páginas de uma exportação PHPWiki",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Caminho para os arquivos de dados (relativo ao diretório-base Tiki, com barra terminadora; ex: dump/)",
"Use dbl click to edit pages" => "Usar duplo clique para editar páginas",
"Change your email" => "Alterar seu endereço de email",
"change email" => "alterar endereço",
"Change your password" => "Alterar sua senha",
"change password" => "alterar senha",
"Configure this page" => "Configurar esta página",
"Send Objects" => "Enviar Objetos",
"stat" => "status",
"You can view the page by following this link:\n {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Você pode ver a página pelo seguinte link:\n {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Você pode editar a página pelo seguinte link:\n {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Você pode ver as diferenças de uma versão anterior pelo link\n:\n {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Create a group for each user\n(with the same\nname as the user)" => "Criar um grupo para cada usuário\n(com o mesmo \nnome do usuário)",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax ((page name))." => "Controlar reconhecimento de links Wiki usando dois parênteses como sintaxe Wiki ((nome da página)).",
"\nNote 1: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.\n\nNote 2: If you assign modules to groups make sure that you\nhave turned off the option 'módulos acessíveis por todos os gruposdisplay modules to all groups always'\nfrom Admin->General\n" => "\nNota 1: Se você permitir aos usuários configurar módulos, os módulos configurados não serão\natualizados na tela até que você os configure\nem MeuTiki->módulos.\n\nNota 2: Se você atribuir módulos a grupos certifique-se de ter desligado\na opção 'Módulos acessíveis por todos grupos'\nem Admin->Geral.\n",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the <img> snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Nota: Se você deseja usar imagens, por favor, salve a postagem antes e você\npoderá editar/postar imagens. Use a tag <img> para incluir imagens carregadas na área de texto\nou use a URL da imagem para incluir imagens usando o editor WYSIWYG. ",
"Invalid password.  You current password is required to change your email address." => "Senha inválida.  Sua senha atual é necessária para alterar seu endereço de e-mail.",
"For more information, please see <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>." => "Para maiores informações, por favor veja <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\nno <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>.",
"Go \r\n                    back" => "Ir \r\n                    voltar",
"Return to home \r\n                    page" => "Retornar para home \r\n                    página",
"no attachment on this page." => "sem anexos nessa página.",
"Displays the output of a tracker content" => "Mostra a saída do conteúdo de um acompanhamento",
"the space between nodes\n" => "O espaço entre os nós\n",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be display before the field append wil be display just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opções numéricas: 1,tamanho,anexar no início,anexar com o tamanho em caracteres, anexar no início será mostrado antes do campo anexar será mostrado imediatamente após, e 1 inicial para fazer com que o próximo campo de texto ou <i>checkbox</i> sejam na mesma linha. Se você indicar somente 1 isto significa que o próximo campo está na mesma linha também.",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be display before the field append wil be display just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opções de texto: 1,tamanho,anexar no início,anexar,max com o tamanho em caracteres, anexar no início será mostrado antes do campo anexar será mostrado imediatamente após, max é o número máximo de caracteres que podem ser salvos, e 1 inicial para fazer com que o próximo campo de texto ou <i>checkbox</i> sejam na mesma linha. Se você indicar somente 1 isto significa que o próximo campo está na mesma linha também.",
"E-Mail address options: MakeLink (0,1 or 2), 0 shows the address as a normal text field. 1 Does an obfuscated mailto: link when viewing item. 2 Does a normal href mailto: when viewing items." => "Opções de endereço de e-mail: MakeLink (0,1 ou 2), 0 mostra o endereço como um campo de texto normal. 1 Gera um email ofuscado. 2 Faz um href de envio normal.",
"Remove selected packages" => "Remove os pacotes selecionados",
"Manage attachement preferences" => "Manipular preferências dos anexos",
"permission." => "permissão.",
"Image options: xSize,ySize indicated in pixels." => "Opções da imagem: xTamanho,yTamanho indicado em pixels.",
"Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field." => "Opções dos itens do link: trackerId,fieldId conecta ao item vindo de trackerId onde fieldId coincide com o conteúdo desse campo.",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere." => "Lista de opções dos itens: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere mostra a lista de displayFieldIdThere desde o item no acompanhamento trackerId onde fieldIdThere coincide fieldIdHere.",
"To the event:" => "Para o evento:",
"Event:" => "Evento:",
"Welcome to our event!" => "Bem vindo ao nosso evento!",
"Projects Menu" => "Menu de projetos",
"Register New Project" => "Registrar novo projeto",
"to add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "para adicionar/remover blogs, vá para \"Create/Edit blog\" em \"Blogs\" no menu de aplicações, ou",
"Users see and add events in their timezone" => "Usuários visualizam e adicionam eventos no horário local",
"look under \"Articles\" on the application menu for links to" => "olhe em \"Articles\" no menu de aplicações para links para",
"Friendship network" => "Rede de amigos",
"Allow permissions for friendship network" => "Habilitar permissões para a rede de amigos",
"Max friendship distance" => "Distância máxima da amizade",
"to configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "para configurar seu diretória, ache \"Admin directory\" em \"Directory\" na menu de aplicações, ou",
"Tiki Projects" => "Projetos do Tiki",
"to add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "para adicionar/remover galerias de arquivos, vá em \"File Galleries\" no menu de aplicações, ou",
"to add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "para adicionar/remover fóruns, procure por \"Admin forums\" em \"Forums\" no menu de aplicações, ou",
"to add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "para adicionar/remover galerias de imagens, vá em \"Image Galleries\" no menu de aplicações, ou",
"Create New Group" => "Criar novo grupo",
"<b>Title</b>" => "<b>Título</b>",
"<b>Description</b>" => "<b>Descrição</b>",
"you can see users rank by score in the module users_rank, for that go to" => "você pode ver o raking de usuários por pontos no módulo users_rank, para isso vá para",
"list events" => "listar eventos",
"admin events" => "eventos do administrador",
"send events" => "enviar eventos",
"Add all users" => "Adicionar todos os usuários",
"Create/edit events" => "Criar/editar eventos",
"send event" => "enviar evento",
"Event ID" => "ID do evento",
"make a line break" => "criar quebra de linha",
"Project Name:" => "Nome do projeto:",
"Project Description:" => "Descrição do projeto:",
"Project Active" => "Projeto ativo",
"Add a File Gallery" => "Adicionar arquivo na galeria",
"Permission" => "Permissão",
"Project Admin" => "Administrador do projeto",
"Project Members" => "Membros do projeto",
"First Name:" => "Primeiro nome:",
"Last Name:" => "Último nome:",
"Company:" => "Empresa:",
"create new user" => "criar novo usuário",
"Project Created:" => "Projeto criado:",
"Project Info" => "Informações do projeto",
"Project Admins:" => "Administradores do projeto:",
"Project Members:" => "Membros do projeto:",
"View Details" => "Ver detalhes",
"Edit Project" => "Editar projeto",
"Add Blog" => "Adicionar Blog",
"Add Articles" => "Adicionar artigo",
"Add Calendar" => "Adicionar calendário",
"Add FAQ" => "Adicionar FAQ",
"Add File Gallery" => "Adicionar galeria de arquivos",
"Add Forum" => "Adicionar Fórum",
"Add Image Gallery" => "Adicionar galeria de imagens",
"Add Newsletter" => "Adicionar comunicados",
"Add URL" => "Adicionar URL",
"Project Registration" => "Registrar projeto",
"List all projects" => "Listar todos os projetos",
"Edit a task" => "Editar tarefa",
"move to trash" => "mover para a lixeira",
"show version" => "mostrar versão",
"move marked to trash" => "mover selecionadas para a lixeira",
"You must be logged in to subscribe to events" => "Você precisa estar logado para adicionar eventos",
"Frienship request sent to %s" => "Pedido enviado para %s",
"Individual Order" => "Ordem individual",
"No assignment indicated" => "Nenhuma associação indicada",
"Error: Assignment not found." => "Erro: associação não encontrada.",
"No entries available yet!" => "Nenhum entrada disponível por enquanto!",
"Error: No assignment indicated." => "Erro: nenhuma associação indicada.",
"Error: assignment not found." => "Erro: associação não encontrada.",
"You must be a student to view this page." => "Você precisa ser um estudante para visualizar essa página.",
" is not a student." => " não é um estudante.",
"specified." => "especificado.",
"Assignment not found" => "Associação não encontrada",
"No homework page indicated!" => "Nenhuma página de tarefa de casa indicada!",
"You must be a student to view this page!" => "Você precisa ser um estudante para visualizar essa página!",
"Students may only view their own work!" => "Estudantes podem ver apenas seu próprio trabalho!",
"No hw page indicated" => "Nenhuma página de tarefa de casa indicada",
"You must be a student to view homework assignments." => "Você precisa ser um estudante para ver as associações das tarefas de casa.",
"Permission denied you must be a student to view assignments." => "Permissão negada, você precisa ser um estudante para visualizar as associações.",
"Sorry, \"\$page\" has not been created." => "Desculpe, \"\$page\" não foi criada.",
"You must provide a project name" => "Você precisa colocar um nome para o projeto",
"You must provide a project description" => "Você precisa colocar uma descrição para o projeto",
"A project with that name already exists" => "Um projeto com esse nome já existe",
"A new password and your IP address has been sent " => "Uma nova senha e seu endereço de IP foi enviado ",
"File update was succesful" => "Arquivo atualizado com sucesso",
"changes at:" => "mudanças em:",
"start date" => "data de início",
"end date" => "data de término",
"The tile must have at lease three characters!" => "O título precisa ter pelo menos três caracteres!",
"The end date must be after the start date!" => "A data de término precisa ser depois da data de início!",
"Sorry the task user has no right to recive tasks" => "Desculpe, o usuária da tarefa não tem permissão para receber tarefas",
"Sorry the creator has no right to send tasks" => "Desculpe, o criador não tem permissão para enviar tarefas",
"Publisher" => "Publisher",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"+1m" => "+1m",
"perm" => "perm",
" line " => " linha ",
"Error: No" => "Erro: Nro",
"Error: Invalid" => "Erro: Inválido",
"Error: Call to hw_page_fetch_by_id failed!" => "Erro: Chamada para hw_page_fetch_by_id falhou!",
"Textarea options: options,width,height,max with option is 1 or 0, rest is size indicated in chars and lines, max is the maximum number of characters that can be saved." => "Opções da área do texto: opções,largura,altura,max com opções 1 ou 0, tamanho indicado em caracteres e linhas, max é o número máximo de caracteres que podem ser salvos.",
"User \$a_user can not receive messages" => "User usuário \$a_user não pode receber mensagens",
"Invalid user: \$a_user" => "Usuário Inválido: \$a_user",
"requested a reminder of the password for the" => "requisitar um lembrete da senha para a",
"since this is your registered email address we inform that the" => "uma vez que este é o seu endereço de email registrado informamos que a",
"password for this account is" => "senha para esta conta é",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "A página {\$mail_page} foi alterada por {\$mail_user} em\n{\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Você pode ver a página pelo seguinte link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Você pode editar a página pelo seguinte link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Você pode ver as diferenças de uma versão anterior pelo link\n:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Click the :: option on the menu for more options." => "Clique na opção :: no menu para mais opções.",
"Please also see" => "Por favor, veja também",
"Admin->Modules" => "Admin->Módulos",
"Blog settings" => "Configurações do Blog",
"FAQs settings" => "Configurações de FAQs",
"FAQ comments" => "Comentários de FAQ",
"Remind passwords by email" => "Lembrar de senhas por e-mail",
"Poll settings" => "Configurações de enquetes",
"Append CSS file to feed urls" => "Adicionar arquivo CSS para o campo de urls",
"Create a tag for the current wiki" => "Criar uma tag para o Wiki atual",
"Tag Name" => "Nome da tag",
"Restore the wiki" => "Restaurar o Wiki",
"Remove a tag" => "Remover uma tag",
"Wiki comments settings" => "Configurações de comentários Wiki",
"Wiki page list configuration" => "Configuração de lista de páginas Wiki",
"Wiki 3D browser configuration" => "Configurações do navegador wiki 3D",
"Set" => "Definir",
"List Calendars" => "Listar Calendários",
"admin Drawings" => "administrar Desenhos",
"Add all your site users to this newsletter (broadcast)" => "Adicionar todos usuários do seu site a este comunicado (comunicado geral)",
"Batch upload (CSV file)" => "Carga em lote (arquivo CSV)",
"today" => "hoje",
"Add Calendar Item" => "Adicionar Item ao Calendário",
"Edit Submissions" => "Editar Submissões",
"act status" => "estado da ativ",
"running" => "em execução",
"Wiki quick help" => "Auxílio rápido Wiki",
"Quicklinks" => "Links Rápidos",
"Comparing versions" => "Comparando versões",
"Actual_version" => "Versão_real",
"Diff to version" => "Diferença para a versão",
"admin DynamicContent" => "administrar DynamicContent",
"Editing tracker item" => "Editando item de acompanhamento",
"You must be a student to edit homework pages." => "Você precisa ser um estudante para editar as páginas de Tarefa de casa.",
"Error: Invalid id for hw_pages table." => "Erro: Id inválido para tabela hw_pages.",
"Error: This page is being edited by another user." => "Erro: Esta página está sendo editada por outro usuário.",
"Permission denied: Students may only view or edit their own work." => "Permissão negada: Estudantes só podem ver ou editar suas tarefas.",
"Permission denied: Students may NOT edit their work after the due date." => "Permissão negada: Estudantes NÃO podem editar seus próprios trabalhos depois da data da entrega.",
"Permission denied: The teacher must wait until the due date to edit students' work." => "Permissão negada: O professor deve aguardar até a data de entrega para editar a tarefa dos estudantes.",
"Permission denied: you must be a teacher to access this page." => "Permissão Negada: você deve ser um professor para para acessar essa página.",
"Error: Could not fetch page" => "Erro: Página não realizada",
"This function is deprecated in favor of the improved quizzes outside of the Homework feature." => "Essa função está obsoleta em favor da melhora dos testes fora do recurso Tarefa de Casa.",
"Permission denied: You cannot rollback this page." => "Acesso Proibido: Você não pode desfazer a alteração dessa página.",
"Error: nonexistant version specified." => "Erro: não existe a versão especificada.",
"You must be a teacher or grader to access this page." => "Você precisa ser professor ou graduando para ver essa página.",
"Permission denied: You must be a teacher to edit assignments." => "Permissão negada: Você deve ser um professor para poder editar as atribuições.",
" error: Can not find assignment " => " erro: não foi possível achar atribuição",
"You have to type a searchword" => "Você deve digitar uma palavra de busca",
"You have to provide a name to the image" => "Você deve fornecer um nome para a imagem",
"someone coming from IP Address" => "algo vindo do endereço de IP",
"requested a reset of the password for the" => "peça para reiniciar a sua senha para o",
"The old password remains active until you activate the new one by following this link:" => "A senha antiga continua ativa até que você ative a nova nesse link:",
"This is only a temporary password. After you logged in with it, you will get to the 'change password' dialog." => "Essa é apenas uma senha temporária. Depois que você se logar com ela, será necessário criar uma nova senha.",
"Category: wiki, tracker, etc." => "Categoria: wiki, acompanhamento, etc.",
"Batch upload (CSV file<a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Upload em lote (CSV file<a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"slideshow_p" => "slide_p",
"slideshow_n" => "slide_n",
"Not rated yet" => "Ainda não ranqueado",
"Removed %s from group %s" => "%s removido do grupo %s",
"Invalid username or activation code" => "Usuário ou código de ativação inválido",
"Category: wiki, trackers, etc." => "Categoria: wiki, acompanhamentos, etc.",
"Information:" => "Informações:",
"Jukebox" => "Jukebox",
"TikiTabs" => "TikiTabs",
"Textarea options: quicktags,width,height,max - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved." => "Opções da área do texto: tags rápidos,largura,altura,max - tags rápidos é 1 ou 0, tamanho indicado em caracteres e linhas, max é o número máximo de caracteres que podem ser salvos.",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize indicated in pixels." => "Opções da imagem:: tamListaX,tamListaY,tamDetalhesX,tamDetalhesY indicados em pixels.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insere artigos na página wiki",
"You need to supply information for : " => "Você precisa fornecer informação para: ",
"Lists ''wanted'' Wiki pages" => "Listar páginas Wiki ''procuradas''",
"Please follow the steps below to have your password properly reset:\n\n1. Click the following link to confirm you wish to reset your password:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Click the following link to go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nAlternatively, go to {\$mail_site} and login using your username and temporary password:\n Username:   {\$mail_user}\n Temporary password:  {\$mail_pass}\n\n3. Done! You should be logged in." => "Por favor siga os passos abaixos para alterar sua senha:\n\n1. Clique no link para confirmar que pretende alterar sua senha:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Clique no link abaixo que te levará a página onde você deve colocar a nova senha \"permanente\". Por favor, escolha uma senha que apenas você terá conhecimento, e não compartilhe ela com ninguém.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nOu, vá para {\$mail_site} e entre usando seu usuário e a senha temporária:\n Usuário:   {\$mail_user}\n Senha temporária:  {\$mail_pass}\n\n3. Pronto! Você já deve estar logado.",
"New blog post: {\$mail_title}: {\$title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nova mensagem no blog: {\$mail_title}: {\$title} por {\$mail_user} às {\$mail_date|tiki_short_datetime}",
"List Courses" => "Listar cursos",
"Please" => "Por favor",
"log in" => "efetue o logon",
"to access full functionalities" => "para acessar todos os recursos",
"Skip to navigation" => "Pular para a navegação",
"Use Quote plugin for quoting" => "Use o plugin QUOTE para citar",
"Like pages" => "Páginas similares",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Utilize {literal}{{/literal}ed id=nome} ou literal}{{/literal}ted id=nome} para inserir zonas dinâmicas",
"Field is hidden? (visible by admin only)" => "O campo é secreto? (visível apenas para o administrador)",
"slideshow backward" => "voltar slide",
"quater" => "trimestre",
"Emphasis" => "Ênfase",
"italics" => "itálico",
"both" => "ambos",
"make_headings" => "criar_cabecalhos",
"underlines text" => "sublinhar texto",
"creates an editable drawing named foo" => "cria um desenho editável com o nome de foo",
"Simple box" => "Caixa simples",
"Will display using the indicated HTML color" => "Será exibido com a cor HTML indicada",
"Center" => "Centralizar",
"Will display the text centered" => "Exibirá o texto centralizado",
"Insert Module Output" => "Inserir saída de módulo",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>some_module)}text{MODULE}{/literal} pode ser usado para colocar a saída do módulo \"some_module\" dentro de uma página wiki. Veja <a href=\"{\$helpurl}PluginModule\">PluginModule</a> para mais informações. ",
"Rendering Program Code" => "Mostra código do programa",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}some code{CODE} {/literal} vai mostrar \"some code\" como código do programa. Esse plugin tem outras opções; veja <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"Activs" => "Atividades",
"Ins" => "Inst",
"time" => "hora",
"Preview Poll" => "Pré-visualizar enquete",
"Edit information" => "Editar informação",
"Jukebox preference" => "Preferências da jukebox",
"You do not have permission to write the template" => "Permissão negada: você não pode escrever o padrão",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Vá para a <a href=\"tiki-friends.php\">rede de amigos</a> para aceitar ou recusar esse pedido",
"All fileds must be from the same tracker" => "Todos os campos devem ser do mesmo acompanhamento",
"Project Group for " => "Grupo de Projeto para ",
"Project Admin Group for " => "Administrador do Projeto para ",
"no description" => "sem descrição",
"LDAP Host" => "Host LDAP",
"LDAP Port" => "Porta LDAP",
"use ...page... to separate pages" => "utilize ...page... para separar páginas",
"Invalid variable value : " => "Valor inválido para variável : ",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Inserir a saída da fonte rss em uma página Wiki",
"Best language" => "Língua preferencial",
"The tracker needs a text field named Subject" => "O acompanhamento precisa de um campo chamado Assunto",
"Flash binary (.sqf or .dcr)" => "Arquivo Flash (.sqf ou .dcr)",
"Search " => "Busca ",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Nota 1</b>: se você permitir que os usuários configurem módulos, os módulos atribuídos\naqui não aparecerão na tela até que o usuário habilite ele \nem Área pessoa->módulos.<br />\n<b>Nota 2</b>: Se você atribuir módulos para grupos certifique-se de que\na opção 'módulos acessíveis para todos grupos' não está habilitada \nem Admin->Geral\n",
"This module requires parameters trackerId and name set" => "Esse módulo requer os parâmetros trackerId e nome definidos",
"Import PHPWiki Dump" => "Importar PHPWiki",
"List pages where I am a creator" => "Listar páginas onde eu sou um autor",
"by creator" => "por autor",
"List pages where I am a modificator" => "Listar páginas onde eu sou um modificador",
"by modificator" => "por modificador",
"at tracker" => "no acompanhamento",
"Click here to create it" => "Clique aqui para criar",
"tikiwiki.org help" => "Ajuda em tikiwiki.org",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "As preferências do Tiki na base de dados (db) estão configuradas para no máximo 250 caracteres por padrão. Isso se aplica para o código personalizado também. Selecione esse campo se você quer atualizar suas preferências na tabela da base de dados para suportar mais do que 250 caracteres (apesar desse recurso ter sido bastante testado e funciona bem com o mysql é recomendado fazer manualmente um backup dos seus dados antes de qualquer atualização na db)",
"Template Viewing" => "Visualizar templates",
"themes" => "temas",
"admin content templates" => "administrar padrões de conteúdo",
"admin FortuneCookie" => "administrar FortuneCookie",
"admin Webmail" => "administrar Webmail",
"admin shoutbox words" => "administrar palavras  do quadro negro",
"Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Upload em lote (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"admin backups" => "administrar backups",
"Mark entry as private:" => "Marcar entrada como privada:",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Para mais informações acesse o endereço <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>",
"Descriptions of the available profiles" => "Descrições dos perfis disponíveis",
"admin cache" => "administrar cache",
"You have to \ncreate a gallery first!" => "Você precisa \ncriar uma galeria primeiro!",
"HomePage" => "Página inicial",
"view faq" => "ver faq",
"Projects" => "Projetos",
"Projects configuration" => "Configurar projetos",
"no such file" => "arquivo inexistente",
"add role" => "adicionar perfil",
"Print operations executed successfully" => "Saída das operações executadas com sucesso",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Andorra" => "Andorra",
// "Afghanistan" => "Afghanistan",
// "Anguilla" => "Anguilla",
// "Albania" => "Albania",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "Aruba" => "Aruba",
// "Aland_Islands" => "Aland_Islands",
// "Azerbaijan" => "Azerbaijan",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bouvet_Island" => "Bouvet_Island",
// "Botswana" => "Botswana",
// "Belize" => "Belize",
// "Catalan_Countries" => "Catalan_Countries",
// "Cocos_Islands" => "Cocos_Islands",
// "Central_African_Republic" => "Central_African_Republic",
// "Congo_Democratic" => "Congo_Democratic",
// "Cape_Verde" => "Cape_Verde",
// "Christmas_Island" => "Christmas_Island",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Western_Sahara" => "Western_Sahara",
// "Eritrea" => "Eritrea",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Gabon" => "Gabon",
// "Grenada" => "Grenada",
// "Georgia" => "Georgia",
// "Guernsey" => "Guernsey",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Gambia" => "Gambia",
// "Guinea" => "Guinea",
// "Guadeloupe" => "Guadeloupe",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Isle_of_Man" => "Isle_of_Man",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Cambodia" => "Cambodia",
// "Comoros" => "Comoros",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Laos" => "Laos",
// "Saint_Lucia" => "Saint_Lucia",
// "Liechtenstein" => "Liechtenstein",
// "Liberia" => "Liberia",
// "Lesotho" => "Lesotho",
// "Libya" => "Libya",
// "Moldova" => "Moldova",
// "Montenegro" => "Montenegro",
// "Madagascar" => "Madagascar",
// "Mali" => "Mali",
// "Myanmar" => "Myanmar",
// "Macao" => "Macao",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Montserrat" => "Montserrat",
// "Maldives" => "Maldives",
// "Namibia" => "Namibia",
// "Norfolk_Island" => "Norfolk_Island",
// "Oman" => "Oman",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "Pitcairn" => "Pitcairn",
// "Palau" => "Palau",
// "Reunion" => "Reunion",
// "Serbia" => "Serbia",
// "Rwanda" => "Rwanda",
// "Seychelles" => "Seychelles",
// "Saint_Helena" => "Saint_Helena",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Sierra_Leone" => "Sierra_Leone",
// "San_Marino" => "San_Marino",
// "Senegal" => "Senegal",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Syria" => "Syria",
// "Swaziland" => "Swaziland",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "Chad" => "Chad",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Togo" => "Togo",
// "Tajikistan" => "Tajikistan",
// "Tokelau" => "Tokelau",
// "Turkmenistan" => "Turkmenistan",
// "Tanzania" => "Tanzania",
// "Uganda" => "Uganda",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uzbekistan" => "Uzbekistan",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Viet_Nam" => "Viet_Nam",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "World" => "World",
// "Yemen" => "Yemen",
// "Mayotte" => "Mayotte",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Galician" => "Galician",
// "index" => "index",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "Default value is specified by having the value indicated twice consecutively" => "Default value is specified by having the value indicated twice consecutively",
// "drop down with other textfield" => "drop down with other textfield",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "~np~{~/np~EVENTS(calendarid=>id1+id2,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=>id1+id2,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insert rss feed output into a wikipage",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Other:" => "Other:",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "Referenced By Page" => "Referenced By Page",
// "Threaded" => "Threaded",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Please notify the admin that the \"sender email\" option in the General configuration section has not been set.  An internal Tiki message has been sent to the admin to validate your registration request.  An email should arrive shortly after you have been validated, with information on how to login for the first time into this site" => "Please notify the admin that the \"sender email\" option in the General configuration section has not been set.  An internal Tiki message has been sent to the admin to validate your registration request.  An email should arrive shortly after you have been validated, with information on how to login for the first time into this site",
// "RSS Feeds" => "RSS Feeds",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "RSS Trackers" => "RSS Trackers",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Post level trackback pings" => "Post level trackback pings",
// "Google Maps" => "Google Maps",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Best Language" => "Best Language",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// " as master" => " as master",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "Configure InterTiki here" => "Configure InterTiki here",
// "Right &amp; left boxes" => "Right &amp; left boxes",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "LRU list purging rate" => "LRU list purging rate",
// "Here you can (as an admin) place a piece of custom XHTML and/or Smarty code. Be careful and properly close all the tags before you choose to publish ! (Javascript, applets and object tags are stripped out.)" => "Here you can (as an admin) place a piece of custom XHTML and/or Smarty code. Be careful and properly close all the tags before you choose to publish ! (Javascript, applets and object tags are stripped out.)",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
// "Test" => "Test",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "While classic trackers are mature, mirror table trackers are an experimental feature. Many bugs have been reported when using plugins, etc.  <b>Do NOT use mirror trackers unless you know what you are doing</b> and are ready to participate to development and debugging. Mirror trackers could even eventually be discontinued from Tiki." => "While classic trackers are mature, mirror table trackers are an experimental feature. Many bugs have been reported when using plugins, etc.  <b>Do NOT use mirror trackers unless you know what you are doing</b> and are ready to participate to development and debugging. Mirror trackers could even eventually be discontinued from Tiki.",
// "Categories path" => "Categories path",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "History only for data, description, comment change" => "History only for data, description, comment change",
// "Spreadsheet" => "Spreadsheet",
// "Mods" => "Mods",
// "Click and scroll up to the top of the page" => "Click and scroll up to the top of the page",
// "Stats &amp; banners" => "Stats &amp; banners",
// "perso" => "perso",
// "admin charts template" => "admin charts template",
// "Managing content templates" => "Managing content templates",
// "Manage FortuneCookie" => "Manage FortuneCookie",
// "admin FortuneCookie tpl" => "admin FortuneCookie tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "Tiki integrator" => "Tiki integrator",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Help with Mail-in accounts" => "Help with Mail-in accounts",
// "article-put" => "article-put",
// "Discard to the end from" => "Discard to the end from",
// "mn" => "mn",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom <a href=\"tiki-admin.php?page=module\">Admin->Modules</a>\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom <a href=\"tiki-admin.php?page=module\">Admin->Modules</a>\n",
// "vertical" => "vertical",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Newsletters Help" => "Newsletters Help",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "To aggregate several RSS feeds, use {literal}{rss id=x+y+z}{/literal}. <b>\"show publish date\" must be checked.<b/>" => "To aggregate several RSS feeds, use {literal}{rss id=x+y+z}{/literal}. <b>\"show publish date\" must be checked.<b/>",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "Manage Banned Words in Shoutbox" => "Manage Banned Words in Shoutbox",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "Help with Surveys" => "Help with Surveys",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "Format if not the default short one:" => "Format if not the default short one:",
// "Show creation date when viewing tracker item?" => "Show creation date when viewing tracker item?",
// "Show lastModif date when viewing tracker item?" => "Show lastModif date when viewing tracker item?",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items?",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2,password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2,password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "Help for Backups" => "Help for Backups",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "Tikiwiki developers" => "Tikiwiki developers",
// "Tikiwiki CMS/Groupware" => "Tikiwiki CMS/Groupware",
// "Cyclic" => "Cyclic",
// "directory admin related tpl" => "directory admin related tpl",
// "Your time" => "Your time",
// "Allow trackback pings" => "Allow trackback pings",
// "Quicktag" => "Quicktag",
// "Wiki Syntax" => "Wiki Syntax",
// "Wiki Help" => "Wiki Help",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Regex search " => "Regex search ",
// "Case Insensitivity" => "Case Insensitivity",
// "admin Ephemerides tpl" => "admin Ephemerides tpl",
// "Forum Importer" => "Forum Importer",
// "List Forums" => "List Forums",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "<b>File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>.</b>" => "<b>File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>.</b>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred." => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred.",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into?" => "Which Forum Do You Wish to Import this Into?",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "galleries tpl" => "galleries tpl",
// "Bounding box" => "Bounding box",
// "You need to set a <a href=\"tiki-admin.php?page=gmap\">Google Maps API key</a>" => "You need to set a <a href=\"tiki-admin.php?page=gmap\">Google Maps API key</a>",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Pie Chart" => "Pie Chart",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the \navailable profiles" => "Descriptions of the \navailable profiles",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" \nhref=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" \nhref=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin",
// "sql queries have successfully been executed." => "sql queries have successfully been executed.",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "Help for managing cache" => "Help for managing cache",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "How to Use FAQs" => "How to Use FAQs",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Blog Help" => "Blog Help",
// "Trackers Help" => "Trackers Help",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "To display the objects you participate to:" => "To display the objects you participate to:",
// "(Only .gif images, and aproximately 45px x 45px)" => "(Only .gif images, and aproximately 45px x 45px)",
// "Average:" => "Average:",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "No structures" => "No structures",
// "add structure" => "add structure",
// "Selected Pages" => "Selected Pages",
// "P/F" => "P/F",
// "admin Referer stats tpl" => "admin Referer stats tpl",
// "search stats tpl" => "search stats tpl",
// "Graph" => "Graph",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "clean" => "clean",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "You can also <a class=\"rbox-link\" href=\"tiki-admin.php?page=theme\">change the default theme</a>." => "You can also <a class=\"rbox-link\" href=\"tiki-admin.php?page=theme\">change the default theme</a>.",
// "theme control objects tpl" => "theme control objects tpl",
// "theme control sections tpl" => "theme control sections tpl",
// "Toggle" => "Toggle",
// "use google map locator" => "use google map locator",
// "How to Use FAQs " => "How to Use FAQs ",
// "monitor this forum topic and thread" => "monitor this forum topic and thread",
// "stop monitoring this forum topic and thread" => "stop monitoring this forum topic and thread",
// "stop monitor" => "stop monitor",
// "LastModif" => "LastModif",
// "Any" => "Any",
// "Help on Administration Home" => "Help on Administration Home",
// "Intertiki settings" => "Intertiki settings",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "The file does not have the required header:" => "The file does not have the required header:",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Site No validated yet" => "Site No validated yet",
// "Incorrect param" => "Incorrect param",
// "This feature is disabled: feature_forums" => "This feature is disabled: feature_forums",
// "Form error - no import method selected for some reason." => "Form error - no import method selected for some reason.",
// "Form error - no server-side filename entered for selected import method." => "Form error - no server-side filename entered for selected import method.",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Please create a directory to hold your map files:" => "Please create a directory to hold your map files:",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// "Incorrect thread" => "Incorrect thread",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"Antigua" => "Antigua",
"Angola" => "Angola",
"Argentina" => "Argentina",
"Barbados" => "Barbados",
"Bangladesh" => "Bangladesh",
"Bulgaria" => "Bulgaria",
"Bermuda" => "Bermuda",
"Brunei" => "Brunei",
"Bahamas" => "Bahamas",
"Congo" => "Congo",
"Chile" => "Chile",
"China" => "China",
"Costa_Rica" => "Costa_Rica",
"Cuba" => "Cuba",
"Algeria" => "Algeria",
"Fiji" => "Fiji",
"Guatemala" => "Guatemala",
"Guam" => "Guam",
"Hong_Kong" => "Hong_Kong",
"Honduras" => "Honduras",
"Haiti" => "Haiti",
"Ireland" => "Ireland",
"Israel" => "Israel",
"Iraq" => "Iraq",
"Jamaica" => "Jamaica",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Sri_Lanka" => "Sri_Lanka",
"Malta" => "Malta",
"Malawi" => "Malawi",
"Nepal" => "Nepal",
"Nauru" => "Nauru",
"Niue" => "Niue",
"Panama" => "Panama",
"Portugal" => "Portugal",
"Quatar" => "Quatar",
"Russia" => "Russia",
"Slovenia" => "Slovenia",
"Slovakia" => "Slovakia",
"El_Salvador" => "El_Salvador",
"Timor-Leste" => "Timor-Leste",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Taiwan" => "Taiwan",
"Venezuela" => "Venezuela",
"Vanuatu" => "Vanuatu",
"Samoa" => "Samoa",
"Zambia" => "Zambia",
"Português" => "Português",
"blog" => "blog",
"faq" => "faq",
"Blogs" => "Blogs",
"Blog" => "Blog",
"Downloads" => "Downloads",
"Login" => "Login",
"Wiki" => "Wiki",
"FAQ" => "FAQ",
"Link" => "Link",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%H:%M %Z" => "%H:%M %Z",
"km" => "km",
"wiki" => "wiki",
"img-g" => "img-g",
"file-g" => "file-g",
"faqs" => "faqs",
"arts" => "arts",
"blogs" => "blogs",
"jscalendar" => "jscalendar",
"Plugin " => "Plugin ",
"desc" => "desc",
"Total" => "Total",
"RSS Wiki" => "RSS Wiki",
"RSS Blogs" => "RSS Blogs",
"Download" => "Download",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"download" => "download",
"Normal" => "Normal",
"CC" => "CC",
"BCC" => "BCC",
"Cache" => "Cache",
"Links" => "Links",
"Menus" => "Menus",
"QuickTags" => "QuickTags",
"Chat" => "Chat",
"Banners" => "Banners",
"Cookies" => "Cookies",
"Mail-in" => "Mail-in",
"phpinfo" => "phpinfo",
"Menu" => "Menu",
"Webmail" => "Webmail",
"WfMenu" => "WfMenu",
"Workflow" => "Workflow",
"Rankings" => "Rankings",
"FAQs" => "FAQs",
"DSN" => "DSN",
"Sites" => "Sites",
"login" => "login",
"Wiki RSS" => "Wiki RSS",
"Blogs RSS" => "Blogs RSS",
"cache" => "cache",
"del" => "del",
"[-]" => "[-]",
"pdf" => "pdf",
"slides" => "slides",
"chat" => "chat",
"rankings" => "rankings",
"powered by" => "powered by",
"Prefs" => "Prefs",
"Copyright" => "Copyright",
"dls" => "dls",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"RSS" => "RSS",
"Meta Tags" => "Meta Tags",
"ok" => "ok",
"Img" => "Img",
"E-mail" => "E-mail",
"PHPLayers" => "PHPLayers",
"AutoLinks" => "AutoLinks",
"Mover" => "Mover",
"Unix" => "Unix",
"Windows" => "Windows",
"IP" => "IP",
"PEAR::Auth" => "PEAR::Auth",
"LDAP" => "LDAP",
"PAM" => "PAM",
"Geourl" => "Geourl",
"Editor" => "Editor",
"Webmaster" => "Webmaster",
"Similar" => "Similar",
"x" => "x",
"ID" => "ID",
"loc" => "loc",
"cat" => "cat",
"lang" => "lang",
"prio" => "prio",
"Ranks" => "Ranks",
"Cookie" => "Cookie",
"cookie" => "cookie",
"Ver" => "Ver",
"dsn" => "dsn",
"min" => "min",
"coms" => "coms",
"ppd" => "ppd",
"Regex" => "Regex",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"phpLayersMenus" => "phpLayersMenus",
"Id" => "Id",
"downloads" => "downloads",
"admin" => "admin",
"Desc" => "Desc",
"Backups" => "Backups",
"popup" => "popup",
"h" => "h",
"zoom" => "zoom",
"+" => "+",
"URL:" => "URL:",
"sites" => "sites",
"editor" => "editor",
"pixels" => "pixels",
"Misc" => "Misc",
"tagline" => "tagline",
"hr" => "hr",
"Original" => "Original",
"%" => "%",
"id" => "id",
"normal" => "normal",
"Int" => "Int",
"Manual" => "Manual",
"#" => "#",
"inter" => "inter",
"val" => "val",
"Pop-up" => "Pop-up",
"ver:" => "ver:",
"If:SetNextact" => "If:SetNextact",
"proc" => "proc",
"auto" => "auto",
"int" => "int",
"Horizontal" => "Horizontal",
"Vertical" => "Vertical",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"hist" => "hist",
"v" => "v",
"Dls" => "Dls",
"/" => "/",
"adm" => "adm",
"Com" => "Com",
"Vers" => "Vers",
"msgs" => "msgs",
"Newsgroup" => "Newsgroup",
"P" => "P",
"F" => "F",
"Site" => "Site",
"tikiwiki.org" => "tikiwiki.org",
"site" => "site",
"auto-link urls" => "auto-link urls",
"eek" => "eek",
"CMS" => "CMS",
"pvs" => "pvs",
"Mb" => "Mb",
"bytes" => "bytes",
"Weblogs" => "Weblogs",
"UTC" => "UTC",
"Local" => "Local",
"Pos" => "Pos",
"pos" => "pos",
"Dif" => "Dif",
"emot" => "emot",
"pts" => "pts",
"Webmail Doc template" => "Webmail Doc template",
"pop" => "pop",
"clip" => "clip",
"cc" => "cc",
"bcc" => "bcc",
"Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
"TOP" => "TOP",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This script cannot be called directly" => "Este script não pode ser chamado diretamente",
"You have mistyped the anti-bot verification code; please try again." => "Você digitou errado o código de verificação; por favor tente de novo.",
"Missing title or body when trying to post a comment" => "Tentativa de envio de comentário sem título ou corpo",
"You do not have permission to use this feature" => "Você não tem permissão para usar esta funcionalidade",
"The copyright management feature is not enabled." => "O recurso de gerenciamento de direitos autorais está desabilitado.",
"You do not have permission to use this feature." => "Você não possui permissão para usar este recurso.",
"You must supply all the information, including title and year." => "Você precisa fornecer toda a informação, incluindo título e ano.",
"The text in RED is" => "O texto em VERMELHO é",
"character(s) too long - please edit it." => "caracter(es) muito grandes - por favor edite-os.",
"This feature is disabled" => "Este recurso está desabilitado",
"United_Arab_Emirates" => "Emirados_Árabes_Unidos",
"Armenia" => "Arménia",
"Antarctica" => "Antárctica",
"American_Samoa" => "Samoa_ Americana",
"Austria" => "Áustria",
"Australia" => "Austrália",
"Belgium" => "Bélgica",
"Bahrain" => "Barém",
"Bolivia" => "Bolívia",
"Brazil" => "Brasil",
"Belarus" => "Bielorrúsia",
"Canada" => "Canadá",
"Switzerland" => "Suíça",
"Ivory_Coast" => "Costa_do_Marfim",
"Cook_Islands" => "Ilhas_Cook",
"Cameroon" => "Camarões",
"Colombia" => "Colômbia",
"Cyprus" => "Chipre",
"Czech_Republic" => "República_Tcheca",
"Germany" => "Alemanha",
"Denmark" => "Dinamarca",
"Dominican_Republic" => "Republica_Dominicana",
"Ecuador" => "Equador",
"Estonia" => "Estónia",
"Egypt" => "Egito",
"Spain" => "Espanha",
"Ethiopia" => "Etiópia",
"Finland" => "Finlândia",
"Federated_States_of_Micronesia" => "Estados_Federados_da_Micronésia",
"France" => "França",
"United_Kingdom" => "Reino_Unido",
"French_Guiana" => "Guiana_Francesa",
"Greece" => "Grécia",
"Guinea_Bissau" => "Guiné_Bissao",
"Guyana" => "Guiana",
"Croatia" => "Croácia",
"Hungary" => "Hungria",
"Indonesia" => "Indonésia",
"India" => "Índia",
"Iran" => "Irã",
"Iceland" => "Islândia",
"Italy" => "Italia",
"Jordan" => "Jordânia",
"Japan" => "Japão",
"Kenya" => "Quênia",
"North_Korea" => "Coréia_do_Norte",
"South_Korea" => "Coréia_do_Sul",
"Cayman_Islands" => "Ilhas_ Cayman",
"Kazakstan" => "Cazaquistão",
"Lebanon" => "Líbano",
"Lithuania" => "Lituânia",
"Luxemburg" => "Luxemburgo",
"Latvia" => "Letônia",
"Morocco" => "Marrócos",
"Monaco" => "Mônaco",
"Marshall_Islands" => "Ilhas_Marshall",
"Macedonia" => "Macedônia",
"Mongolia" => "Mongólia",
"Mauritius" => "Mauricius",
"Mexico" => "México",
"Malaysia" => "Malásia",
"Mozambique" => "Moçambique",
"New_Caledonia" => "Nova_Caledonia",
"Niger" => "Níger",
"Nigeria" => "Nigéria",
"Nicaragua" => "Nicarágua",
"Netherlands" => "Holanda",
"Norway" => "Noruéga",
"New_Zealand" => "Nova_Zelândia",
"Peru" => "Perú",
"French_Polynesia" => "Polinésia_Francesa",
"Papua_New_Guinea" => "Papua_Nova_Guiné",
"Phillippines" => "Filipinas",
"Pakistan" => "Paquistão",
"Poland" => "Polonia",
"Puerto_Rico" => "Porto_Rico",
"Palestine" => "Palestina",
"Paraguay" => "Paraguai",
"Romania" => "Romênia",
"Saudi_Arabia" => "Arábia_Saudita",
"Solomon_Islands" => "Ilhas_Salomão",
"Sudan" => "Sudão",
"Sweden" => "Suécia",
"Singapore" => "Singapura",
"Somalia" => "Somália",
"Surinam" => "Suriname",
"Thailand" => "Tailândia",
"Tunisia" => "Tunísia",
"Turkey" => "Turquía",
"Trinidad_Tobago" => "Trinidá_e_Tobago",
"Ukraine" => "Ucrânia",
"United_States" => "Estados_Unidos",
"Uruguay" => "Uruguai",
"Vatican" => "Vaticano",
"St_Vincent_Grenadines" => "São_Vicente_e_Granadinas",
"Wales" => "País_de_Gales",
"South_Africa" => "África_do_Sul",
"Zimbabwe" => "Zimbábue",
"Europe" => "Europa",
"Yugoslavia" => "Iugoslávia",
"Arabic" => "Arábico",
"Catalan" => "Catalão",
"Simplified Chinese" => "Chinês Simplificado",
"Chinese" => "Chinês",
"Czech" => "Theco",
"Danish" => "Holandês",
"German" => "Alemão",
"English" => "Inglês",
"English British" => "Inglês Britânico",
"Spanish" => "Espanhol",
"Greek" => "Grego",
"French" => "Francês",
"Hebrew" => "Hebreu",
"Croatian" => "Croata",
"Italian" => "Italiano",
"Japanese" => "Japonês",
"Korean" => "Coreano",
"Hungarian" => "Hungaro",
"Dutch" => "Dinamarquês",
"Norwegian" => "Norueguês",
"Polish" => "Polonês",
"Brazilian Portuguese" => "Português do Brasil",
"Russian" => "Russo",
"Pijin Solomon" => "Salomão de Pijin",
"Slovak" => "Eslovaco",
"Serbian" => "Sérvio",
"Serbian Latin" => "Latim Sérvio",
"Swedish" => "Sueco",
"Tuvaluan" => "Tuvaluano",
"Traditional Chinese" => "Chinês Tradicional",
"Ukrainian" => "Ucraniano",
"This instance of activity is already complete" => "Essa instância já foi completada",
"Fatal error: cannot execute automatic activity \$activityId" => "Erro fatal: não é possível executar a atividade automática \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Erro fatal: configurando a próxima atividade para uma atividade inexistente",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Erro fatal: PróximaAtividade não combina com qualquer chave de atividade candidata",
"Fatal error: non-deterministic decision for autorouting activity" => "Erro fatal: nenhuma determinação para decisão de atividade de auto-rotação",
"Fatal error: trying to send an instance to an activity but no transition found" => "Erro fatal: tentando enviar uma instância para uma atividade mas nenhuma transição foi encontrada",
"Cannot add transition only split activities can have more than one outbound transition" => "Não é possível adicionar transição. Somente divisão de atividades podem ter mais que uma transição de saída",
"Circular reference found some activity has a transition leading to itself" => "Referência circular encontrou alguma transição chegando para si mesma",
"Process does not have a start activity" => "Processo não possui uma atividade inicial",
"Process does not have exactly one end activity" => "Processo não possui exatamente um fim de atividade",
"End activity is not reachable from start activity" => "Fim da atividade não é alcançável pelo início da atividade",
"Activity" => "Atividade",
" is interactive but has no role assigned" => " é interativo mas não possui parte designada",
" is non-interactive and non-autorouted but has no role assigned" => " é não-interativo e não roteado mas não possui parte designada",
" is standalone but has transitions" => " é standalone mas tem transições",
"Role" => "Perfil",
" is not mapped" => " não está mapeado",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Atividade '.\$res['name'].' é standalone e está usando o objeto \$instance",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Atividade '.\$res['name'].' é interativa então deve usar o método \$instance->complete()",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Atividade '.\$res['name'].' é não-interativa então deve usar o método \$instance->complete()",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Atividade '.\$res['name'].' é chaveada então deve usar o método \$instance->setNextActivity(\$actname)",
"Process %d has been activated" => "Processo %d foi ativado",
"Process %d has been deactivated" => "Processo %d foi desativado",
"Process %s %s imported" => "Processo %s %s importado",
"Process %s removed" => "Processo %s removido",
"Process %s has been updated" => "Processo %s foi atualizado",
"Process %s has been created" => "Processo %s foi criado",
"refresh" => "atualizar",
"locked" => "travada",
"locked by" => "travada por",
"Administration:" => "Administração:",
"continued" => "continuação",
"by" => "por",
"in" => "em",
"new image uploaded by" => "nova imagem carregada por",
"uploaded by" => "carregado por",
"new item in tracker" => "novo item no acompanhamento",
"new subscriptions" => "nova assinatura",
"not specified" => "não especificado",
"The file is not a CSV file or has not a correct syntax" => "O arquivo não é um arquivo CSV ou não possui o formato correto",
"article" => "artigo",
"directory" => "diretório",
"file gallery" => "galeria de arquivos",
"forum" => "fórum",
"image gallery" => "galeria de imagens",
"newsletter" => "comunicado",
"poll" => "enquete",
"quiz" => "teste",
"survey" => "pesquisa",
"tracker" => "acompanhamento",
"wiki page" => "página wiki",
"image" => "imagem",
"calendar" => "calendário",
"Cannot write to this file: " => "Impossível escrever neste arquivo: ",
"Cannot upload this file maximum upload size exceeded" => "Impossível carregar este arquivo: tamanho máximo para arquivo atingido",
"Anonymous" => "Anônimo",
"Use this thread to discuss the %s page." => "Use esse assunto para discutir a página %s ",
"Another post with the same title and content already exists" => "Um outro post com o mesmo título e conteúdo já existe",
"Line:" => "Linha:",
"Lines:" => "Linhas:",
"Newsletter subscription information at " => "Assinatura de comunicado em ",
"Cannot open this file:" => "Não foi possível abrir este arquivo:",
"Cannot write to this file:" => "Não foi possível escrever neste arquivo:",
"There was a problem with your upload." => "Ocorreu um problema com seu upload.",
"The file you are trying to upload is too big." => "O arquivo que você quer subir é muito grande.",
"The file you are trying to upload was only partially uploaded." => "O aquivo que você está tentando subir está apenas parcialmente atualizado.",
"You must select a file for upload." => "Você deve escolher um arquivo para subir.",
"Wiki Home" => "Página Inicial Wiki",
"Home" => "Página inicial",
"previous page" => "página anterior",
"next page" => "página posterior",
"posted on" => "enviado em",
"Continue" => "Continuar",
"Articles" => "Artigos",
"By:" => "Por:",
"Read" => "Lida",
"List articles" => "Listar artigos",
"Forums" => "Fóruns",
"Last post" => "Última mensagem",
"Invalid imagename (using filters for filenames)" => "Nome inválido de imagem (usando filtros para nomes de arquivos)",
"Errors detected" => "Erros detectados",
"Upload was not successful" => "Carga interrompida com falha",
"No image yet, sorry." => "Sinto muito, sem nenhuma imagem ainda.",
"No valid ogr2ogr executable" => "Executável ogr2ogr não é válido",
"Could not create \$tdo.mif in data directory" => "Não foi possível criar \$tdo.mif no diretório data",
"Could not create \$tdo.mid in data directory" => "Não foi possível criar \$tdo.mid no diretório data",
"unknown" => "desconhecido",
"Other" => "Outro",
"User Map Generated in:" => "Mapa do usuário Gerado em:",
"Image Map Generated in:" => "Mapa da imagem Gerado em:",
"NONE" => "NENHUM",
"File %s not found" => "Arquivos %s não encontrados",
"File %s is not a valid archive" => "Arquivo %s não é um arquivo válido",
"%s is an empty archive file" => "%s é um arquivo vazio",
"Invalid remote file on url %s" => "Arquivo remoto inválido em %s",
"Impossible to open %s : %s" => "Impossível abrir %s : %s",
"This poll is closed." => "Esta enquete está fechada.",
"Wiki top pages" => "Páginas Wiki mais populares",
"Hits" => "Visitas",
"Most relevant pages" => "Páginas mais relevantes",
"Relevance" => "Relevância",
"Wiki last pages" => "Páginas Wiki recentes",
"Modified" => "Modificado",
"Forums last topics" => "Tópicos recentes nos fóruns",
"Topic date" => "Data do tópico",
"Forums last posts" => "Últimas inserções nos fóruns",
"Forums most read topics" => "Tópicos mais lidos nos fóruns",
"Reads" => "Leituras",
"Forums best topics" => "Melhores tópicos nos fóruns",
"Score" => "Pontuação",
"Forums most visited forums" => "Fóruns mais visitados",
"Visits" => "Visitas",
"Forums with most posts" => "Fóruns com mais mensagens",
"Posts" => "Mensagens",
"Wiki top galleries" => "Galerias Wiki mais populares",
"Wiki top file galleries" => "Galerias de arquivos mais populares",
"Wiki top images" => "Imagens mais populares",
"Wiki top files" => "Arquivos mais populares",
"Wiki last images" => "Imagens mais recentes",
"Upload date" => "Data de carga",
"Wiki last files" => "Arquivos recentes",
"Wiki top articles" => "Artigos mais populares",
"Most visited blogs" => "Blogs mais visitados",
"Most active blogs" => "Blogs mais ativos",
"Blogs last posts" => "Últimas mensagens em blogs",
"Post date" => "Data de envio",
"Wiki top authors" => "Autores de Wiki mais produtivos",
"Pages" => "Páginas",
"Top article authors" => "Autores de artigos mais produtivos",
"tikiwiki logo" => "logo do tikiwiki",
"See other user's profile" => "Veja outro perfil de usuário",
"Have your profile seen" => "Mostre o seu perfil para outros",
"Make friends" => "Fazer amigos",
"Receive message" => "Receber mensagem",
"Send message" => "Enviar mensagem",
"Read an article" => "Ler um artigo",
"Publish an article" => "Publicar um artigo",
"Have your article read" => "Mostre seus artigos para outros",
"Create new file gallery" => "Criar nova galeria de arquivos",
"Upload new file to gallery" => "Subir novo arquivo para a galeria",
"Download other user's file" => "Baixar outro arquivo do usuário",
"Have your file downloaded" => "Permita que outros baixem seus arquivos",
"Create a new image gallery" => "Criar nova galeria de imagem",
"Upload new image to gallery" => "Subir um novo arquivo para a galeria",
"See other user's gallery" => "Veja outra galeria do usuário",
"See other user's image" => "Veja outra imagem do usuário",
"Have your gallery seen by other user" => "Mostre sua galeria para outros usuários",
"Have your image seen" => "Mostre sua imagem para outros",
"Create new blog" => "Criar novo blog",
"Post in a blog" => "Postar no blog",
"Read other user's blog" => "Ler o blog de outro usuário",
"Have your blog read" => "Mostre seu blog para outros",
"Create a new wiki page" => "Criar nova página wiki",
"Edit an existing page" => "Editar uma página existente",
"Attach file" => "Anexar um arquivo",
"Tracker" => "Acompanhamento",
"Unknown" => "Desconhecido",
"Trackeritem" => "Ítem de acompanhamento",
"Image Gallery" => "Imagem da galeria",
"Image" => "Imagem",
"Article" => "Artigo",
"Directory category" => "Categoria de diretório",
"Directory" => "Diretórios",
"Forum" => "Fórum",
"File Gallery" => "Galeria de arquivos",
"Gallery" => "Galeria",
"File" => "Arquivo",
"Blog post" => "Mensagem de blog",
"Tracker item" => "Item do acompanhamento",
"help" => "auxílio",
"The text is" => "O texto é",
"Text cut here" => "Corte o texto aqui",
"Task" => "Tarefa",
"from" => "de",
"for" => "para",
"Priority" => "Prioridade",
"Start date:" => "Data inicial:",
"End date:" => "Data final:",
"%A %d of %B, %Y" => "%A %d de %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d de %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d de %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d de %b, %Y[%H:%M %Z]",
"Friend" => "Amigo",
"Last seen on " => "Visto pela última vez em ",
"(idle for %s seconds)" => "(inativo por  %s segundos)",
"User information - Click for more info" => "Informação do usuário - Clique para saber mais",
"More info about \$other_user" => "Mais informação sobre \$other_user",
"(idle for \$idletime seconds)" => "(inativo por \$idletime segundos)",
"unlocked" => "destravada",
"created from structure" => "criar da estrutura",
"Use this tree to copy the structure" => "Use esta árvore para copiar a estrutura",
"An error occured in a database query!" => "Ocorreu um erro em uma <i>query</i> ao banco de dados!",
"Help" => "Ajuda",
"You are banned from" => "Você foi banido(a) de",
"quizzes" => "testes",
"forums" => "fóruns",
"games" => "jogos",
"picture not found" => "imagem não encontrada",
"drawing not found" => "desenho não encontrado",
"Click to edit dynamic variable" => "Clique para editar a variável dinâmica",
"Update variables" => "Atualizar variáveis",
"Altering database table failed" => "Alterando tabela da base de dados falhou",
"%d points" => "%d pontos",
"Removed" => "Removido",
"Created" => "Criado em",
"__WARNING__: No such module \$plugin! " => "__ADVERTÊNCIA__: Não existe o módulo \$plugin! ",
"new" => "novo",
"Create page:" => "Criar página:",
"show" => "mostrar",
"hide" => "esconder",
"Updated" => "Atualizado",
"Unknown language" => "Idioma desconhecido",
"Click here to confirm your action" => "Clique aqui para confirmar sua ação",
"Sea Surfing (CSRF) detected. Operation blocked." => "Detectado um Sea Surfing (CSRF). Operação bloqueada.",
"Status:" => "Estado:",
"(unchanged)" => "(sem alterações)",
"Item Modification" => "Modificação de Item",
"Item" => "Ítem",
"Item creation" => "Criação de Item",
"Tracker was modified at " => "Acompanhamento foi modificado em ",
"field is not numeric" => "campo não é numérico",
"text field" => "campo texto",
"half column" => "metade da coluna",
"size" => "tamanho",
"prepend" => "acrescentar ao começo",
"append" => "agregar",
"max" => "máximo",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opções do texto: 1,tamanho,concatenar no começo,agregar,tamanho máximo em caracteres, concatenar no começo será mostrado depois do campo agregar, max é o número máximo de caracteres que podem ser salvos, e o 1 inicial é para garantir que o próximo campo de texto ou checkbox esteja na mesma linha. Se você indicar apenas  1 significa que o próximo campo também estará na mesma linha.",
"textarea" => "área de texto",
"checkbox" => "caixa de marcação",
"Checkbox options: put 1 if you need that next field is on the same row." => "Opções <i>Checkbox</i>: coloque 1 se você precisa que o próximo campo seja na mesma linha.",
"numeric field" => "campo numérico",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opções Numéricas: 1,tamanho,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
"drop down" => "caixa de seleção",
"Dropdown options: list of items separated with commas." => "Opções da Caixa de Seleção: lista de Itens separados por vírgulas.",
"user selector" => "selecionador de usuário",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Seleção do usuário: use opções para preenchimento automático dos campos: você pode usar 1 para login do autor ou 2 para o login do modificador.",
"group selector" => "selecionador de grupo",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Seletor de Grupo: para preenchimento automático dos campos use as opções: você pode usar 1 para criar grupos e 2 para modificar grupos. O grupo padrão deve ser especificado, ou o primeiro grupo que vier será escolhido pelo usuário, ou o grupo padrçao será  Registrado.",
"country selector" => "selecionador de país",
"Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Opções ao selecionar o país: 1|2 onde 1 mostra apenas o nome do país e 2 mostra apenas a bandeira do país. Por padrão mostra os dois.",
"date and time" => "data e hora",
"action" => "ação",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Opções de ação: rótulo,mensagem,tiki-index.php,página:nome do campo,destaque=teste",
"header" => "cabeçalho",
"category" => "categoria",
"Category options: parentId" => "Opções da categoria: parentId",
"item link" => "item do link",
"items list" => "lista de itens",
"email" => "e-mail",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Opções do endereço de e-mail: 0|1|2 sendo que 0 coloca o endereço como texto puro, 1 cria um link hexadecimal para o endereço (mais difícil para enviar spams)e 2 cria um href normal para o endereço.",
"system" => "sistema",
"open" => "aberto",
"pending" => "pendente",
"closed" => "fechado",
"Added:" => "Adicionado:",
"Removed:" => "Removido:",
"Remaining:" => "Restando:",
"Old:" => "Antigo:",
"New:" => "Novo:",
"message" => "mensagem",
"No extra information for that attached file. " => "Sem informações extras para o arquivo anexado. ",
"child categories" => "categorias-filhas",
"objects in category" => "objetos nesta categoria",
"(AT)" => "(ARROBA)",
"(DOT)" => "(PONTO)",
"The administrator has not yet validated your account. Please wait." => "O administrador ainda não validou sua conta. Por favor espere.",
"You must validate your account first. An email has been sent to you" => "Primeiro você precisa validar sua conta. Um e-mail foi enviado com as instruções",
"The registration mail can't be sent. Contact the administrator" => "O e-mail para registro não pode ser enviado. Contate o administrador",
"Include all post in a blog" => "Incluir tudo o que foi postado em um blog",
"Date" => "Data",
"Title" => "Título",
"Author" => "Autor",
"Include a page" => "Incluir uma página",
"Lists files in a directory" => "Lista de arquivos em um diretório",
"could not be opened because it doesn't exist or permission was denied" => "não pode ser aberto porque não existe ou porque as permissões foram insuficientes",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Pega expressões regex e cruza o conteúdo com as tags REGEX e substitui o texto.",
"data" => "dados",
"one data per line" => "um dado por linha",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "O plugin SNARF repõe a si mesmo com o corpo HTML de uma URL.  Recolocamentos arbitrários regex podem ser feitos nesse contexto usando regex e regexres, o segundo sendo usado como o secundo argumento para preg_replace.",
"This data is put in a CODE caption." => "Esse dados são postos como uma legenda CODE.",
"Missing url parameter for SNARF plugin." => "Faltando endereço url como parâmetro para o plugin SNARF.",
"Displays browser client info" => "Mostra as informações do navegador do cliente",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Cria um link para uma posição numa página wiki. Use junto com o plugin ANAME, que permite definir a localização e o nome de uma posição",
"linktext" => "texto de link",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Cria uma posição numa página wiki. Use junto com o plugin ALINK, que cria links para posições",
"Include an article" => "Incluir um artigo",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insere artigos em páginas wiki",
"no such attachment on this page" => "nenhum anexo nessa página",
"Displays an attachment or a list of them" => "Mostra um anexo ou uma lista deles",
"comment" => "comentário",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num é opcional e é a ordem númerica dos anexos na lista. Se não for definido, uma lista com todos os anexos será mostrada.  Dentro da linha faz o comentário ser o texto do link.",
"Displays the user Avatar" => "Exibe a fotografia do usuário",
"username" => "usuário",
"List all pages which link to specific pages" => "Listar todas as páginas que possuem links para as páginas especificadas",
"Page cannot be found" => "A página não foi encontrada",
"No pages links to" => "Nenhuma página com link para",
"One page links to" => "Uma página com link para",
"pages link to" => "páginas com links para",
"Insert theme styled box on wiki page" => "Inserir caixa com estilo do tema na página wiki",
"text" => "texto",
"Insert list of items for the current/given category into wiki page" => "Inserir uma lista de itens para a categoria atual/fornecida na página wiki",
"Categories are disabled" => "Categorias estão desabilitadas",
"Display Tiki objects that have not been categorized" => "Exibir objetos Tiki que não foram categorizados",
"Insert the full category path for each category that this wiki page belongs to" => "Inserir o caminho completo para cada categoria a que esta página wiki pertence",
"Centers the plugin content in the wiki page" => "Centraliza o conteúdo de plugin na página wiki",
"Displays a snippet of code" => "Mostrar um pedaço de código",
"code" => "código",
"note: colors and ln are exclusive" => "nota: cores e ln são exclusivos",
"Insert copyright notices" => "Inserir informações de copyright",
"Example" => "Exemplo",
"days" => "dias",
"hours" => "horas",
"minutes" => "minutos",
"and" => "e",
"seconds" => "segundos",
"Insert a division block on wiki page" => "Insira um bloco de divisão na página wiki",
"Creates a definition list" => "Criar uma lista de definição",
"term" => "termo",
"definition" => "definição",
"one definition per line" => "uma definição por linha",
"Upcoming events" => "Próximos eventos",
"Displays the data using the Tikiwiki odd/even table style" => "Exibe os dados usando o estilo de tabelas par/ímpar do Tikiwiki",
"cells" => "células",
"heads and cells separated by ~|~" => "cabeçalhos e células separadas por ~|~",
"Missing parameter movie to the plugin flash" => "Falta o parâmetro movie para o plugin flash",
"Displays a SWF on the wiki page" => "Mostra um SWF na página wiki",
"Impossible to render the graphic." => "Não foi possível renderizar o gráfico.",
"View graphic" => "Ver gráfico",
"Displays a graphical GAUGE" => "Exibe um medidor gráfico",
"description" => "descrição",
"Display wiki text if user is in one of listed groups" => "Mostra o texto wiki se o usuário pertencer a um dos grupos listados",
"Runs a Java applet to access a local Jabber service" => "Executa um applet Java para acessar um serviço local Jabber",
"Displays the text only if the language matchs" => "Mostrar o texto somente se o idioma combina",
"Displays a map" => "Mostra mapa",
"Feature disabled" => "Recurso desabilitado",
"Displays an miniquiz" => "Mostra um mini-teste",
"Please choose a module" => "Por favor, selecione um módulo",
"to be used as argument" => "para ser utilizado como argumento",
"Displays a module inlined in page" => "Exibe um módulo embutido na página",
"Sorry no such module" => "Sinto muito, módulo inexistente",
"Displays the data using a monospace font" => "Exibe os dados usando uma fonte monoespaçada",
"Displays object hit info by object and days" => "Mostra informações de acesso do objeto por objeto e dias",
"Provides a list of plugins on this wiki." => "Provê uma lista de plug-ins neste wiki.",
"No version indicated" => "Nenhuma versão indicada",
"No arguments indicated" => "Nenhum argumento indicado",
"Displays the output of a poll, fields are indicated with numeric ids." => "Mostrar a saída de uma enquete, os campos são indicados por números.",
"missing poll ID for plugin POLL" => "faltando ID da enquete para o plugin POLL",
" wrote:" => " escreveu:",
"Quote:" => "Cita:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Cita o texto cercado por um boz, como o [QUOTE] do BBCode",
"~np~{~/np~RSS(id=>feedId+feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId+feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Exive um feed RSS numa página wiki",
"Automatically creates a link to the appropriate SourceForge object" => "Criar automaticamente um link para o objeto apropriado no SourceForge",
"TikiSheet" => "Planilha Tiki",
"Sheet Heading" => "Cabeçalho da planilha",
"Edit Sheet" => "Editar planilha",
"List wiki pages" => "Listar páginas wiki",
"Last modified by" => "Última modificação por",
"Clickable Skype link" => "Link para o Skype",
"Sorts the plugin content in the wiki page" => "Ordena o conteúdo do plugin na página wiki",
"Split a page into rows and columns" => "Dividir uma página em linhas e colunas",
"row1col1" => "linha1col1",
"row1col2" => "linha1col2",
"row2col1" => "linha2col1",
"row2col2" => "linha2col2",
"Missing db param" => "Parâmetro de banco de dados ausente",
"Run a sql query" => "Executar uma consulta SQL",
"sql query" => "Consulta SQL",
"Displays text in subscript." => "Mostra o texto no modo subscrito.",
"Displays text between an html tag" => "Mostrar texto entre tag HTML",
"Displays the thumbnail for an image" => "Mostrar miniatura para uma imagem",
"Search the titles of all pages in this wiki" => "Buscar os títulos de todas as páginas deste wiki",
"No pages found for title search" => "Nenhuma página encontrada para a busca de título",
"One page found for title search" => "Uma página encontrada para a busca de título",
" pages found for title search" => " páginas encontradas para a busca de título",
"Following mandatory fields are missing" => "Os seguintes campos obrigatórios não foram preenchidos",
"Following fields are incorrect" => "Os seguintes campos estão incorretos",
"select all" => "selecionar todos",
"Displays an input form for tracker submit" => "Mostra um formulário para inserção de um acompanhamento",
"Save" => "Salvar",
"You do not have permission to insert an item" => "Você não tem permissão para inserir um item",
"Fields marked with a * are mandatory." => "Os campos marcados com * são obrigatórios",
"All fields must be from the same tracker" => "Todos os campos precisam ser do mesmo acompanhamento",
"filter" => "filtro",
"Filters the items of a tracker, fields are indicated with numeric ids." => "Filtre os ítens de um acompanhamento, os campos são indicados com ids numéricos.",
"missing parameters" => "faltando os parâmetros",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Mostrar a saída de conteúdo de uma acompanhamento, campos são indicados com números.",
"missing tracker ID for plugin TRACKER" => "Faltando o ID do acompanhamento para o plugin ACOMPANHAMENTO",
"missing fields list" => "Faltando lista de campos",
"at" => "em",
"Error in tracker ID" => "Erro no ID do acompanhamento",
"No field indicated" => "Sem campo indicado",
"Links to a translated content" => "Links para um conteúdo traduzido",
"Displays the number of registered users" => "Mostrar o número de usuários registrados",
"Split the text in parts visible only under some conditions" => "Dividir o texto em partes visíveis apenas em algumas situações",
"Lists ''wanted'' Wiki pages: " => "Lista páginas wiki ''desejadas'': ",
"^Parameters: key=>value,...\n" => "^Parâmetros: chave=>valor,...\n",
"__key__ | __default__ | __comments__\n" => "__chave__ | __padrão__ | __comentários__\n",
"empty string" => "string vazia",
"possible values: " => "valores possíveis: ",
"ignored" => "ignorado",
"External Wiki" => "Wiki Externo",
"valid" => "válida",
"End of debug output." => "Final da saída de debug.",
"Wanted Page" => "Página desejada",
"failed" => "falhou",
"You are not logged in" => "Você não está logado(a)",
"Permission denied" => "Permissão negada",
"ERROR: Either the subject or body must be non-empty" => "ERRO: Ou o assunto ou o corpo tem que ser preenchido",
"ERROR: No valid users to send the message" => "ERRO: Nenhum destinatário válido para a mensagem",
"Invalid user" => "Usuário inválido",
"Message will be sent to: " => "A mensagem foi enviada para: ",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "A caixa de saída esta cheia. Arquive ou delete algumas mensagens antes de enviar novas mensagens.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Para poder enviar mensagens, você primeiro precisa habilitar a opção para recebe-las. Nas preferências de usuário habilite 'Permitir mensagens de outros usuários'.",
"User %s can not receive messages, mailbox is full" => "Os usuários %s não podem receber mensagens pois a caixa de entrada deles esta cheia",
"User %s can not receive messages" => "Os usuários %s não podem receber mensagens",
"Invalid user: %s" => "Usuário inválido: %s",
"Archive is full. Delete some messages from archive first." => "O arquivo esta cheio. Delete algumas mensagens antes de arquivar novas.",
"No more messages" => "Nenhuma outra mensagem",
"move %s in %s" => "mover %s para %s",
"Please provide an Id" => "Forneça um Id por favor",
"no object here yet" => "Nenhum objeto aqui",
"edit" => "editar",
"Quick edit a Wiki page" => "Edição rápida de página Wiki",
"Since your last visit" => "Desde sua última visita",
"Changes" => "Mudanças",
"since" => "desde",
"Changes since" => "Mudanças desde",
"new comments" => "novos comentários",
"new posts" => "novas mensagens",
"wiki pages changed" => "páginas Wiki alteradas",
"new articles" => "Novos Artigos",
"new FAQs" => "novos FAQs",
"new blogs" => "novos blogs",
"new blog posts" => "Novos postagens nos blogs",
"new image galleries" => "Nova galeria de imagens",
"new images" => "novas imagens",
"new file galleries" => "Novas galeria de arquivos",
"new files" => "novos arquivos",
"new polls" => "nova enquete",
"new users" => "novos usuários",
"new tracker items" => "novos itens de acompanhamento",
"The task title must have at least 3 characters" => "O título da tarefa deve conter pelo menos 3 caracteres",
"Invalid server key" => "Chave do servidor inválida",
"Invalid username or password" => "Usuário ou senha inválidos",
"Anti-Bot verification code" => "Código de verificação anti-robô",
"Random Image" => "Imagem Aleatória",
"Enter the code you see above" => "Digite o código que está acima",
"List of attached files" => "Lista de arquivos anexados",
"name" => "nome",
"uploaded" => "carregado",
"delete" => "apagar",
"Remove" => "Remover",
"Upload file" => "Carregar arquivo",
"attach" => "anexar",
"debug" => "depuração",
"Fatal error" => "Erro crítico",
"Description:" => "Descrição:",
"Created by" => "Criada por",
" on " => " em ",
"Last modified" => "Última modificação em",
"Post" => "Enviar",
"post" => "enviar",
"RSS feed" => "Fonte RSS",
"Edit blog" => "Editar blog",
"monitor this blog" => "monitorar este blog",
"stop monitoring this blog" => "não monitorar mais este blog",
"posts" => "mensagens",
"visits" => "visitas",
"Activity=" => "Atividade=",
"Categorize" => "Categorização",
"show categories" => "exibir categorias",
"hide categories" => "esconder categorias",
"Tip: hold down CTRL to select multiple categories" => "Dica: segure o CTRL para selecionar mais de uma categoria ao mesmo tempo",
"categorize this object" => "categorizar este objeto",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Dica: desmarque a caixa acima para deixar sem categoria essa página/objeto",
"No categories defined" => "Nenhuma categoria definida",
"Admin categories" => "Administrar categorias",
"browse category" => "navegar na categoria",
"author" => "autor",
"stars" => "estrelas",
"user level" => "nível de usuário",
"private message" => "mensagem particular",
"send email to user" => "enviar email ao usuário",
"user online" => "usuário on-line",
"user offline" => "usuário offline",
"on" => "em",
"score" => "pontuação",
"Vote" => "Votar",
"Edit" => "Editar",
"reply" => "responder",
"attachment" => "anexo",
"Moderator actions" => "Ações de moderador",
"delete selected" => "apagar selecionados",
"Move to topic:" => "Mover para o tópico:",
"move" => "mover",
"reported:" => "enviadas:",
"queued:" => "pendentes:",
"Posted messages" => "Mensagens postadas",
"Messages" => "Mensagens",
"All" => "Todos",
"Style" => "Estilo",
"Plain" => "Plano",
"Headers Only" => "Cabeçalho apenas",
"Sort" => "Ordenar",
"Newest first" => "Mais novos em primeiro",
"Oldest first" => "Mais antigos em primeiro",
"Threshold" => "Limite",
"Find" => "Buscar",
"set" => "definir",
"Hide all" => "Esconder todos",
"replies" => "respostas",
"below your current threshold" => "abaixo seu limite atual",
"prev" => "ant",
"Page" => "Página",
"next" => "próx",
"new reply" => "nova resposta",
"Editing reply" => "Editar resposta",
"Reply to the selected post" => "Responder a mensagem selecionada",
"Post new message" => "Enviar nova mensagem",
"Editing comment" => "Editando comentário",
"Comment on the selected post" => "Comentar mensagem selecionada",
"Post new comment" => "Enviar novo comentário",
"Preview" => "Pré-visualização",
"Required" => "Obrigatório",
"Rating" => "Nota",
"Smileys" => "Emoticons",
"Reply" => "Responder",
"Comment" => "Comentário",
"Reply to parent post" => "Responder para a mensagem principal",
"Post new reply" => "Enviar nova resposta",
"preview" => "pré-visualização",
"cancel" => "cancelar",
"Posting replies" => "Enviar respostas",
"Posting comments" => "Dicas para a edição",
"Use" => "Usar",
"or" => "ou",
"for links" => "para links",
"HTML tags are not allowed inside posts" => "Tags HTML não são permitidos dentro de mensagens",
"Go back" => "Retornar",
"Return to home page" => "Retornar à página inicial",
"Copyrights" => "Direitos Autorais",
"Year" => "Ano",
"Authors" => "Autores",
"up" => "subir",
"down" => "descer",
"add" => "adicionar",
"Syntax" => "Formato",
"Page generation debugging log" => "Log de depuração de geração de página",
"Features state" => "Estado de recursos",
"features matched" => "recursos selecionados",
"Watchlist" => "Lista de Notificações",
"Error" => "Erro",
"Perhaps you were looking for:" => "Talvez você esteja procurando por:",
"There are no wiki pages similar to '{\$page}'" => "Não há nenhuma página wiki similar a '{\$page}'",
"Create this page" => "Criar esta página",
"(page will be orphaned)" => "(a página será órfã)",
"Close Window" => "Fechar janela",
"Exact&nbsp;match" => "Correspondência&nbsp;exata",
"any type" => "qualquer tipo",
"all topic" => "todos os tópicos",
"any language" => "qualquer idioma",
"any category" => "qualquer categoria",
"find" => "buscar",
"Last update from CVS" => "Última atualização do CVS",
"RSS Articles" => "RSS Artigos",
"RSS Image Galleries" => "RSS Galeria de imagens",
"RSS File Galleries" => "RSS Galeria de arquivos",
"RSS Forums" => "RSS Fóruns",
"RSS Maps" => "RSS Mapas",
"RSS Directories" => "RSS Diretórios",
"RSS Calendars" => "RSS Calendário",
"You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page?" => "Você optou por sair dessa página. As alterações feitas que não foram salvas serão perdidas. Você tem certeza que quer sair dessa página?",
"Information" => "Informação",
"Hi {\$mail_user} has sent you this link:" => "Olá! O usuário {\$mail_user} enviou este link para você:",
"Blog post:" => "Mensagem de blog:",
"at:" => "em:",
"Somebody or you tried to subscribe this email address at our site:" => "Alguém (possivelmente você) tentou registrar este endereço de email no nosso site:",
"To the newsletter:" => "Para o comunicado:",
"In order to confirm your subscription you must access the following URL:" => "Para confirmar esta assinatura, acesse o seguinte endereço:",
"A new message was posted to forum" => "Uma nova mensagem foi enviada ao fórum",
"New topic:" => "Novo tópico:",
"Topic:" => "Tópico:",
"Message" => "Mensagem",
"You sent a request with the subject:" => "Você mandou uma requisição com o assunto:",
"Use the subject to indicate the operation to apply:" => "Use o assunto para indicar a operação para aplicar:",
"Tiki mail-in instructions" => "Instruções para mail-in Tiki",
"Page not found:" => "Página não encontrada:",
"Hi," => "Olá,",
"A new message was posted to you at {\$mail_machine}" => "Uma nova mensagem foi enviada para você a partir de {\$mail_machine}",
"From" => "De",
"Subject" => "Assunto",
"New message arrived from %s" => "Nova mensagem chegou de %s",
"Hi" => "Olá",
"Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Seu pedido de registro de conta no Tiki para {\$mail_site} foi validade pelo administrados e sua conta está ativa agora.",
"To login with your username and password, please follow this link:" => "Para entrar usando seu usuário e senha, por favar acesse esse link:",
"Enjoy the site!" => "Esperamos que você aprecie o site!",
"Tiki User Account Activated" => "Conta Tiki do usuário ativada",
"has requested an account on" => "solicitou uma conta em",
"To validate that account, please follow the link:" => "Para validar essa conta, por favor siga o link:",
"best regards" => "de nossa maior consideração",
"your Tikiwiki" => "seu Tikiwiki",
"Tiki User Registration Request" => "Solicitação de registro de usuário tiki",
"Go to your friendship network to accept or refuse this request" => "Vá para a sua rede de amigos para aceitar ou rejeitar esse pedido",
"You're invited to join my network of friends!" => "Convite para entrar na minha rede de amigos!",
"The user" => "O usuário",
"registered at your site" => "registrou-se no seu site",
"New user registration" => "Cadastramento de novo usuário",
"Bye bye!" => "Até logo!",
"This email address has been removed to the list of subscriptors of:" => "Este endereço de email foi removido da lista de assinantes de:",
"Newsletter:" => "Comunicado:",
"Bye bye from %s at %s" => "Removido da lista %s em %s",
"You can unsubscribe from this newsletter following this link" => "Você pode cancelar a assinatura deste comunicado clicando abaixo:",
"Welcome to our newsletter!" => "Bem-vindo(a) ao nosso comunicado!",
"This email address has been added to the list of subscriptors of:" => "Este endereço de email foi adicionado à lista de assinantes de:",
"You can always cancel your subscription using:" => "Você pode cancelar sua assinatura a qualquer momento usando:",
"Welcome to %s at %s" => "Bem vindo a %s em %s",
"Tiki email notification" => "Notificação de email Tiki",
"Someone coming from IP Address" => "Alguém acessando do endereço IP",
"requested a reminder of the password for your account" => "solicitou um lembrete de senha da sua conta",
"requested password reset for your account" => "solicitou que a senha para sua conta fosse recriada",
"Since this is your registered email address we inform that the password for this account is" => "Sendo esse o seu endereço eletrônico a sua senha é",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Clique no link a seguir para confirmar que você deseja uma nova senhae vá para a página onde você deve escolher uma nova senha. Escolha uma senha que apenas você saiba e não compartilhe com ninguém.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nPronto! Você já deve estar logado.",
"Important: Username & password are CaSe SenSitiVe" => "Importante: Usuário e senha são sensíveis a caixa ALTA/baixa",
"Important: The old password remains active if you don't click the link above." => "Importante: a senha velha permanecerá ativa se você não clicar no link acima.",
"Your Tiki account information for %s" => "A sua informação da conta Tiki para %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Um novo artigo foi enviado por \$mail_user} para {\$mail_site} em {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Você pode editar este artigo editando este link:",
"Title:" => "Título:",
"Heading:" => "Cabeçalho:",
"Body:" => "Corpo:",
"New article submitted at %s" => "Novo artigo enviado em %s",
"View the tracker item at:" => "Visualizar item do acompanhamento em:",
"Tracker was modified at" => "Acompanhamento modificado as",
"you or someone registered this email address at" => "alguém (possivelmente você) registrou este endereço de email em",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Se você deseja ser um usuário registrado neste site, utilize o seguinte link para logar-se pela primeira vez:",
"Your Tiki information registration" => "Instruções para cadastramento no Tiki",
"You will receive an email with information to login for the first time into this site" => "Você receberá um email com instruções sobre como logar-se pela primeira vez neste site",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Seu pedido de conta você registrado e será ativado pelo administrador o mais rápido possível.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nova artigo: {\$mail_title} por {\$mail_user} as {\$mail_date|tiki_short_datetime}",
"View the article at:" => "Vejo o artigo em:",
"If you don't want to receive these notifications follow this link:" => "Se você não deseja receber estas notificações siga este link:",
"New article post at %s" => "Novo artigo em %s",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nova mensagem de blog: {\$mail_title}, \"{\$mail_post_title}\", por {\$mail_user} em {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Veja o blog em:",
"New blog post at %s" => "Novo post no blog em %s",
"File Gallery %s changed" => "Galeria de arquivos %s alterada",
"A file was removed from the file gallery" => "Um arquivo foi removido da galeria de imagens",
"Removed by" => "Removido por",
"Name" => "Nome",
"File Name" => "Nome do arquivo",
"A new file was posted to file gallery" => "Novo arquivo na galeria de arquivos",
"Posted by" => "Enviado por",
"File Description" => "Descrição do Arquivo",
"Image Gallery {\$galleryName} changed" => "Galeria de imagem {\$galleryName} modificada",
"A new file was posted to image gallery" => "Um novo arquivo foi enviado para a galeria de imagem",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "O mapa {\$mail_page} foi alterado por {\$mail_user} em {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Você pode ver o mapa atualizado pelo link:",
"You can edit the map following this link:" => "Você pode editar o mapa pelo seguinte link:",
"A new file have been attached to page" => "Um novo arquivo foi anexado à página",
"File name" => "Nome do arquivo",
"Type" => "Tipo",
"Size" => "Tamanho",
"New attachment on %s, page" => "Novos anexos em %s, página",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A página {\$mail_page} foi criada por {\$mail_user} as {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A página {\$mail_page} foi alterada por {\$mail_user} em {\$mail_date|tiki_short_datetime}",
"Comment:" => "Comentário:",
"You can view the page by following this link:" => "Você pode acessar a página através desse link:",
"You can view a diff back to the previous version by following this link:" => "Você pode visualizar uma comparação de uma versão anterior através desse link:",
"The changes in this version follow below, followed after by the current full page text." => "As mudanças nessa versão seguem abaixo, em seguida é mostrado a versão atual da página.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Linhas: {\$oldd} mudou para +Linhas: {\$newd}",
"The new page content follows below." => "O conteúdo da nova página está abaixo.",
"Wiki page %s changed" => "Página wiki %s alterada",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A página {\$mail_page} foi comentada por {\$mail_user} em {\$mail_date|tiki_short_datetime}",
"Wiki page renamed" => "Página wiki renomeada",
"Old name" => "Nome antigo",
"New name" => "Novo nome",
"Thank you for you registration. You may log in now." => "Obrigado por registrar-se. Você pode se logar a partir de agora.",
"click on the map to zoom or pan, do not drag" => "clique no mapa para um zoom, não para arrastar",
"Scale" => "Escala",
"Zoom out x4" => "Menos zoom x4",
"Zoom out x3" => "Menos zoom x3",
"Zoom out x2" => "Menos zoom x2",
"Query" => "Consulta",
"Pan" => "Panorâmica",
"Zoom in x2" => "Mais zoom x2",
"Zoom in x3" => "Mais zoom x3",
"Zoom in x4" => "Mais zoom x4",
"Redraw" => "Redesenhar",
"select zoom/pan/query and image size" => "selecione zoom/pan/consulta e tamanho da imagem",
"Go" => "Ir",
"View the Map Only" => "Veja apenas o mapa",
"Reset Map" => "Reiniciar mapa",
"Click on the map or click redraw" => "Clique no mapa ou clique em redesenhar",
"Comments" => "Comentários",
"Last modification date" => "Data da última modificação",
"Overview" => "Visão geral",
"Legend" => "Legenda",
"Layer Manager" => "Gerenciador de Camadas",
"Layer" => "Camada",
"On" => "Ligado",
"Label" => "Rótulo",
"Download Layer" => "Download Camada",
"This layer has been set by the maps administrator to not be downloadable" => "Essa camada foi definida para como impossível de ser baixada pelo administrador dos mapas",
"you have requested to download the layer:" => "você requisitou o download da camada:",
"from\nthe mapfile:" => "de\no arquivo de mapa:",
"Here are the files to download, do not forget to rename them:" => "Aqui estão os arquivos para o download, não esqueça de renomeá-los:",
"Mapfiles" => "Arquivos de Mapas",
"Mapfile" => "Arquivo de Mapa",
"Available mapfiles" => "Arquivos de Mapas disponíveis",
"Actions" => "Ações",
"hits" => "visitas",
"hits last 7 days" => "cliques nos últimos 7 dias",
"monitor this map" => "monitorar este mapa",
"stop monitoring this map" => "parar de monitorar este mapa",
"No records found" => "Nenhum registro encontrado",
"Create a new mapfile" => "Criar um novo arquivo de mapa",
"create" => "criar",
"Mapfile listing" => "Listagem de mapas de arquivos",
"Reload" => "Recarregar",
"History" => "Histórico",
"save" => "salvar",
"You can view this map in your browser using" => "Você pode ver este mapa em seu browser usando",
"Mapfile History" => "Histórico dos arquivos de mapa",
"of" => "de",
"Version" => "Versão",
"compare" => "comparar",
"Comparing version {\$old.version} with version {\$new.version}" => "Comparando versão {\$old.version} com a versão {\$new.version}",
"Version:" => "Versão:",
"current" => "atual",
"Versions are identical" => "As versões são idênticas",
"Legend:" => "Legenda:",
"v=view" => "v=visualizar",
"c=compare" => "c=comparar",
"d=diff" => "d=visualizar diferentes versões",
"Side-by-side diff" => "Comparar diferentes versões lado-a-lado",
"Full side-by-side diff" => "Comparar diferentes versões lado-a-lado completo",
"Unified diff" => "Comparar diferentes versões unificado",
"Side-by-side view" => "Visualizar lado a lado",
"User" => "Usuário",
"Action" => "Ação",
"view" => "ver",
"diff" => "difer",
"older version" => "versão antiga",
"Directories" => "Diretórios",
"back to" => "voltar para",
"Files" => "Arquivos",
"Upload From Disk:" => "Carregar Do Disco:",
"Upload Files" => "Carregar Arquivos",
"Bytes maximum" => "Máximo de bytes",
"Create Directory:" => "Criar Diretório:",
"Create" => "Criar",
"index file (.shp):" => "arquivo índice (.shp):",
"files to index (regexp):" => "arquivos para índice (regexp):",
"Message Archive" => "Arquivo de mensagens",
"Edit template" => "Editar modelo",
"messages" => "mensagens",
"Archive is full!" => "Arquivo está cheio!",
"Unread" => "Não lida",
"Flagged" => "Selecionada",
"Unflagged" => "Não selecionada",
"Containing" => "Conteúdo",
"sender" => "remetente",
"subject" => "assunto",
"date" => "data",
"flagged" => "selecionada",
"No messages to display" => "Nenhuma mensagem a exibir",
"Broadcast message" => "Enviar mensagem global",
"Message Broadcast" => "Mensagem Global",
"edit template" => "editar modelo",
"Group" => "Grupo",
"All users" => "Todos os usuários",
"Lowest" => "Mínima",
"Low" => "Baixa",
"High" => "Alta",
"Very High" => "Máxima",
"send" => "enviar",
"Compose message" => "Escreva mensagem",
"Compose Message" => "Compor mensagem",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Para que as pessoas possam enviar mensagens para você e responder as mensagens que você enviar é necessário habilitar <a href='tiki-user_preferences.php'>Permitir mensagens de outros usuários</a>",
"To" => "Para",
"No messages to download" => "Nenhuma mensagem para baixar",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "A caixa de entrada esta cheia! Delete ou arquive algumas mensagens para pode receber novas mensagens.",
"move to archive" => "mover para o arquivo",
"Mark as read" => "Marcar como lida",
"Mark as unread" => "Marcar como não lida",
"Mark as flagged" => "Marcar como selecionada",
"Mark as unflagged" => "Marcar como não selecionada",
"mark" => "marca",
"reply to" => "responder para",
"find replied message" => "encontrar mensagens respondidas",
"Mailbox" => "Caixa de entrada",
"Compose" => "Escrever",
"Broadcast" => "Enviar para todos",
"Sent" => "Enviado",
"Archive" => "Arquivo",
"Auto-archive age for read messages:" => "Arquivar automaticamente mensagens lidas depois de certo tempo:",
"Read message" => "Ler mensagem",
"Prev" => "Ant",
"Next" => "Próx",
"Return to mailbox" => "Voltar para a Caixa de Entrada",
"replyall" => "responder a todos",
"Unflag" => "Desmarcar",
"Flag this message" => "Marcar esta mensagem",
"Cc" => "CC",
"Return to archive" => "Retornar para o arquivo",
"Return to outbox" => "Retornar para a caixa de saída",
"Sent Messages" => "Mensagens enviadas",
"Replied" => "Respondido",
"Not replied" => "Não respondido",
"receiver" => "destinatário",
"no" => "não",
"replied" => "respondida",
"'name' parameter for tikimodule missed" => "parâmetro 'nome' para tikimodule está perdido",
"Move module up" => "Mover módulo para cima",
"Move module down" => "Mover módulo para baixo",
"Hide module contents" => "Esconder conteúdo do módulo",
"Move module to opposite side" => "Mover módulo para o lado oposto",
"opp side" => "lado oposto",
"Unassign this module" => "Desabilitar este módulo",
"Are you sure you want to unassign this module?" => "Você tem certeza que deseja desabilitar este módulo?",
"remove" => "remover",
"Admin Menu" => "Administrar Menu",
"Live support" => "Suporte On-line",
"Banning" => "Banimento",
"Users" => "Usuários",
"Groups" => "Grupos",
"Modules" => "Módulos",
"Hotwords" => "Palavras-chaves",
"RSS modules" => "Módulos RSS",
"Polls" => "Enquetes",
"Mail notifications" => "Notificações por e-mail",
"Search stats" => "Estatísticas de busca",
"Categories" => "Categorias",
"Edit templates" => "Editar padrões",
"Admin drawings" => "Administrar desenhos",
"Dynamic content" => "Conteúdo dinâmico",
"Content templates" => "Padrões de conteúdo",
"HTML pages" => "Páginas HTML",
"Shoutbox" => "Mural",
"Shoutbox Words" => "Palavras do quadro negro",
"Referer stats" => "Estatísticas de referência",
"Admin dsn" => "Administrar DSN",
"External wikis" => "Wikis externos",
"System Admin" => "Administração do sistema",
"Security Admin" => "Administrar segurança",
"Syntax highlighting" => "Colorização de sintaxe",
"Display type unknown, you have to enter the banner type" => "Tipo desconhecido, você precisa especificar o tipo do banner",
"You forgot your Google ad_client number !" => "Você esqueceu o seu número ad_client do Google!",
"Contact us" => "Entre em contato",
"Stats" => "Estatísticas",
"Games" => "Jogos",
"Calendar" => "Calendário",
"MyMenu" => "MeuMenu",
"MyTiki" => "Área pessoal",
"MyTiki home" => "Área pessoal",
"Preferences" => "Preferências",
"Tasks" => "Tarefas",
"Bookmarks" => "Favoritos",
"Newsreader" => "Notícias",
"Notepad" => "Bloco de notas",
"My files" => "Meus arquivos",
"User menu" => "Menu do usuário",
"Mini calendar" => "Mini calendário",
"My watches" => "Minhas notificações",
"Admin processes" => "Administrar processos",
"Monitor processes" => "Monitorar processos",
"Monitor activities" => "Monitorar atividades",
"Monitor instances" => "Monitorar instâncias",
"User processes" => "Processos de usuário",
"User activities" => "Atividades do usuário",
"User instances" => "Instâncias de usuários",
"FriendsMenu" => "Menu dos amigos",
"Community" => "Comunidade",
"User list" => "Lista de usuários",
"Friendship Network" => "Rede de amigos",
"WikiMenu" => "MenuWiki",
"Last changes" => "Últimas alterações",
"Dump" => "Exportação",
"List pages" => "Listar páginas",
"Orphan pages" => "Páginas órfãs",
"Sandbox" => "Bancada de testes",
"Print" => "Imprimir",
"Send pages" => "Enviar páginas",
"Received pages" => "Páginas recebidas",
"Structures" => "Estruturas",
"GalMenu" => "MenuGal",
"Image Galleries" => "Galerias de imagens",
"Galleries" => "Galerias",
"Upload image" => "Carregar imagem",
"System gallery" => "Galeria do sistema",
"Articles home" => "Página de artigos",
"Submit article" => "Enviar artigo",
"View submissions" => "Ver artigos enviados",
"Edit article" => "Editar artigo",
"Send articles" => "Enviar artigos",
"Received articles" => "Artigos recebidos",
"Admin topics" => "Administrar assuntos",
"Admin types" => "Administrar tipos de artigos",
"List blogs" => "Listar blogs",
"Create/Edit blog" => "Criar/Editar blog",
"Admin posts" => "Administrar mensagens",
"ForMenu" => "MenuFor",
"List forums" => "Listar fóruns",
"Admin forums" => "Administrar fóruns",
"DirMenu" => "MenuDir",
"Submit a new link" => "Enviar um novo link",
"Browse directory" => "Listar links",
"Admin directory" => "Administrar diretórios",
"FileGalMenu" => "MenuGalArq",
"File Galleries" => "Galerias de Arquivos",
"List galleries" => "Listar galerias",
"List FAQs" => "Listar FAQs",
"Admin FAQs" => "Administrar FAQs",
"Maps" => "Mapas",
"Layer management" => "Gerenciamento de camadas",
"QuizMenu" => "MenuTeste",
"Quizzes" => "Testes",
"List quizzes" => "Listar testes",
"Quiz stats" => "Estats. Teste",
"Admin quiz" => "Administrar teste",
"ShtMenu" => "MuralMenu",
"TrkMenu" => "MenuAcomp",
"Trackers" => "Acompanhamentos",
"List trackers" => "Listar todos",
"Admin trackers" => "Administrar",
"SrvMenu" => "MenuPesq",
"Surveys" => "Pesquisas",
"List surveys" => "Listar pesquisas",
"Admin surveys" => "Administrar pesquisas",
"Newsletters" => "Comunicados",
"Send newsletters" => "Enviar comunicados",
"Admin newsletters" => "Administrar comunicados",
"Events" => "Eventos",
"Send events" => "Enviar eventos",
"Admin events" => "Administrar eventos",
"EphMenu" => "MenuCurios",
"Ephemerides" => "Curiosidades",
"Ephemerides Admin" => "Administrar curiosidades",
"ChartMenu" => "MenuGraf",
"Charts" => "Gráficos",
"Charts Admin" => "Administrar gráficos",
"AdmMenu" => "MenuAdm",
"Admin" => "Administrar",
"Admin home" => "Página do administrador",
"Debugger console" => "Console de debug",
"Theme control" => "Controle de temas",
"Drawings" => "Desenhos",
"Edit languages" => "Editar línguas",
"Integrator" => "Integrador",
"Mods Admin" => "Admin mods",
"UsrMenu" => "MenuUsuário",
"Click here to manage your personal menu" => "Clique aqui para editar seu menu pessoal",
"User Menu" => "Menu do Usuário",
"Tikiwiki Assistant" => "Assistente do Tikiwiki",
"Thank you for installing Tikiwiki" => "Obrigado por instalar o Tikiwiki",
"Click the :: options in the Menu for more options." => "Clique em :: opções no menu para mais opções.",
"Please, also see" => "Por favor, veja também",
"for more setup details." => "para mais detalhes de configuração.",
"Note 1:" => "Nota 1:",
"You can remove this module in" => "Você pode remover este módulo em",
"as well as assign or edit many others." => "como associar ou editar muitos outros.",
"Note 2:" => "Nota 2:",
"The menu module installed by default is named" => "O módulo do menu instalado por padrão se chama",
"it is a \"custom module\" which includes menu ID " => "é um \"custom module\" o que inclui um ID do menu ",
"That menu is stored in database and it can be edited from " => "Essa menu está na base de dados e pode ser editado no ",
"Do not mix this with the original <em>application_menu</em> module" => "Não misture esse com o módulo original <em>application_menu</em>",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Esse pode ser totalmente customizado para se parecer com o estilo usado mas isso só ser feito editando o arquivo mod-application_menu.tpl \"manually\"",
"Recently visited pages" => "Páginas recentemente visitadas",
"January" => "Janeiro",
"February" => "Fevereiro",
"March" => "Março",
"April" => "Abril",
"May" => "Maio",
"June" => "Junho",
"July" => "Julho",
"August" => "Agosto",
"September" => "Setembro",
"October" => "Outubro",
"November" => "Novembro",
"December" => "Dezembro",
"Monday" => "Segunda-feira",
"Tuesday" => "Terça-feira",
"Wednesday" => "Quarta-feira",
"Thursday" => "Quinta-feira",
"Friday" => "Sexta-feira",
"Saturday" => "Sábado",
"Sunday" => "Domingo",
"Filter" => "Filtrar",
"Today" => "Hoje",
"top" => "topo",
"Received objects" => "Objetos recebidos",
"Pages:" => "Páginas:",
"Last `\$module_rows` Sites" => "Últimos `\$module_rows` Sites",
"Last Sites" => "Últimos Sites",
"Directory Stats" => "Estatísticas dos links",
"Sites to validate" => "Sites a validar",
"Searches" => "Buscar",
"Visited links" => "Links visitados",
"Top \$module_rows Sites" => "Melhores \$module_rows Sites",
"Top Sites" => "Sites mais visitados",
"Current events" => "Eventos atuais",
"Featured links" => "Links oferecidos",
"Top `\$module_rows` topics" => "Melhores `\$module_rows` tópicos",
"Top topics" => "Tópicos mais discutidos",
"Last `\$module_rows` forum posts" => "Últimas `\$module_rows` mensagens no fórum",
"Last forum posts" => "Últimas mensagens no fórum",
"Last `\$module_rows` forum topics" => "Últimos `\$module_rows` tópicos em fóruns",
"Last forum topics" => "Últimos tópicos de fóruns",
"Most commented forums" => "Fóruns mais comentados",
"Most read topics" => "Tópicos mais lidos",
"Most visited forums" => "Fóruns mais visitados",
"Google Search" => "Busca Google",
"Last `\$module_rows` actions" => "Últimas `\$module_rows` ações",
"Last actions" => "Últimas ações",
"Last `\$module_rows` articles" => "Últimos `\$module_rows` artigos",
"Last articles" => "Últimos artigos",
"Last `\$module_rows` blog posts" => "Últimas  `\$module_rows` postagens em blogs",
"Last blog posts" => "Últimas mensagens para blogs",
"Last" => "Última",
"Last `\$module_rows` Created blogs" => "Últimos `\$module_rows` Blogs criados",
"Last Created blogs" => "Últimos Blogs Criados",
"Last `\$module_rows` Created FAQs" => "Últimas `\$module_rows` FAQs Criadas",
"Last Created FAQs" => "Últimos FAQs Criados",
"Last `\$module_rows` Created Quizzes" => "Últimos `\$module_rows` Testes Criados",
"Last Created Quizzes" => "Últimos Testes Criados",
"Last `\$module_rows` modified file galleries" => "Últimas `\$module_rows` galerias de arquivos modificadas",
"Last modified file galleries" => "Últimas galerias de arquivos modificadas",
"Last `\$module_rows` Files" => "Últimos `\$module_rows` arquivos",
"Last Files" => "Arquivos Recentes",
"Last `\$module_rows` galleries" => "Últimas `\$module_rows` galerias",
"Last galleries" => "Últimas galerias",
"Last `\$module_rows` Images" => "Últimas `\$module_rows` imagens",
"Last Images" => "Últimas imagens",
"Last `\$module_rows` modified events" => "Últimos `\$module_rows` eventos modificados",
"Last modifed events" => "Últimos eventos modificados",
"Last `\$module_rows` changes" => "Últimas `\$module_rows` alterações",
"Last `\$module_rows` Modified Items" => "Últimos `\$module_rows` itens modificados",
"Last Modified Items" => "Últimos itens modificados",
"Last `\$module_rows` Modified blogs" => "Últimos `\$module_rows` blogs modificados",
"Last Modified blogs" => "Últimos blogs modificados",
"Last `\$module_rows` submissions" => "Últimas `\$module_rows` submissões",
"Last submissions" => "Últimos artigos enviados",
"Last `\$module_rows` Modified Comments" => "Últimos `\$module_rows` comentários",
"Last Modified Comments" => "Últimos comentários",
"Last `\$module_rows` Items" => "Últimos `\$module_rows` itens",
"Last Items" => "Últimos itens",
"Last `\$module_rows` visitors" => "Últimos `\$module_rows` visitantes",
"Last visitors" => "Últimos visitantes",
"Open operator console" => "Abrir o console de operador",
"Online users" => "Usuários on-line",
"We have" => "Existem",
"online users" => "usuários on-line",
"logged as" => "logado como",
"Logout" => "Finalizar a sessão",
"user" => "usuário",
"Login through CAS" => "Entrar com CAS",
"Login as admin" => "Logar como administrador",
"pass" => "senha",
"Remember me" => "Lembre-se de mim",
"Click here to register" => "Clique aqui para registrar",
"register" => "registrar-se",
"Click here if you've forgotten your password" => "Clique aqui se você esqueceu sua senha",
"I forgot my pass" => "Esqueci minha senha",
"Click here to login using the default security protocol" => "Clique aqui para autenticar o protocolo padrão",
"standard" => "padrão",
"Click here to login using a secure protocol" => "Clique aqui para se autenticar usando um protocolo seguro",
"secure" => "seguro",
"stay in ssl mode" => "permanecer no modo seguro",
"local account" => "conta local",
"Tiki Logo" => "Logotipo Tiki",
"You have" => "Você possui",
"new messages" => "mensagens novas",
"new message" => "mensagem nova",
"You have 0 new messages" => "Você possui 0 mensagens novas",
"Waiting Submissions" => "Artigos Pendentes",
"submissions waiting to be examined" => "Artigos com aprovação pendente",
"Old articles" => "Artigos antigos",
"Send a message to" => "Enviar uma mensagem para",
"Send a message" => "Enviar mensagem",
"Random Images" => "Imagens aleatórias",
"Random Pages" => "Páginas aleatórias",
"Register as a new user" => "Registrar-se como novo usuário",
"Your email could not be validated; make sure you email is correct and click register below." => "Seu endereço de email não pôde ser validado; certifique-se de que está correto e clique em registrar-se abaixo.",
"Your registration code:" => "Seu código de registro:",
"Username" => "Usuário",
"Passcode to register (not your user password)" => "Código para registro (não é sua senha pessoal)",
"Registration code" => "Código de registro",
"Password" => "Senha",
"Repeat password" => "Confirmação de senha",
"Email" => "E-mail",
"Generate a password" => "Gerar uma senha",
"Articles RSS" => "Artigos RSS",
"Image Galleries RSS" => "Galeria de imagens RSS",
"File Galleries RSS" => "Galeria de arquivos RSS",
"Forums RSS" => "Fóruns RSS",
"Maps RSS" => "Mapas RSS",
"Calendars" => "Calendários",
"Search" => "Busca",
"in:" => "em:",
"Entire Site" => "Todo o Site",
"Wiki Pages" => "Páginas Wiki",
"Image Gals" => "Galeria de imagens",
"Images" => "Imagens",
"Blog Posts" => "Mensagens de Blogs",
"go" => "buscar",
"Search Wiki PageName" => "Buscar Nome de Página Wiki",
"Read More" => "Ler Mais",
"Since your last visit on" => "Desde sua última visita em",
"click to edit" => "clique para editar",
"Nothing has changed" => "Nenhuma alteração",
"Language: " => "Idioma: ",
"Language" => "Idioma",
"Most Active blogs" => "Blogs mais ativos",
"Top `\$module_rows` articles" => "`\$module_rows` melhores artigos",
"Top articles" => "Artigos mais lidos",
"Top `\$module_rows` File Galleries" => "`\$module_rows` Melhores Galerias de Arquivos",
"Top File Galleries" => "Galerias de Arquivos mais visitadas",
"Top `\$module_rows` files" => "Melhores `\$module_rows` arquivos",
"Top files" => "Melhores arquivos",
"Top `\$module_rows` Forum Posters" => "Os mais `\$module_rows` ativos no fórum",
"Top Forum Posters" => "Usuários mais ativos no fórum",
"Top `\$module_rows` games" => "Melhores `\$module_rows` jogos",
"Top games" => "Jogos mais populares",
"Top `\$module_rows` galleries" => "`\$module_rows` melhores galerias",
"Top galleries" => "Galerias mais visitadas",
"Top `\$module_rows` Images" => "`\$module_rows` melhores imagens",
"Top Images" => "Imagens mais populares",
"Top Objects" => "Objetos mais vistos",
"Top `\$module_rows` Pages" => "Melhores `\$module_rows` Páginas",
"Top Pages" => "Páginas mais visitadas",
"Top `\$module_rows` Quizzes" => "Melhores `\$module_rows` Testes",
"Top Quizzes" => "Testes mais visitados",
"Most `\$module_rows` visited blogs" => "`\$module_rows` Blogs mais visitados",
"Top `\$module_rows` Visited FAQs" => "`\$module_rows` FAQs mais visitadas",
"Top Visited FAQs" => "FAQs mais visitados",
"My blogs" => "Meus Blogs",
"My galleries" => "Minhas galerias",
"My Pages" => "Minhas Páginas",
"User tasks" => "Tarefas do usuário",
"done" => "pronto",
"Public tasks" => "Tarefas públicas",
"select" => "selecionar",
"User informations" => "Informações do usuário",
"Group informations" => "Informações do grupo",
"You need to activate user and/or group trackers" => "Você precisa ativar o acompanhamento para usuário e/ou grupo",
"Top users" => "Usuários mais ativos",
"Whats related" => "O que está relacionado",
"online user" => "usuário on-line",
"on host" => "no servidor",
"Last `\$module_rows` wiki comments" => "Últimos `\$module_rows` comentários no wiki",
"Last wiki comments" => "Últimos comentários no wiki",
" on page " => " na página ",
"Click to see the ratings" => "Clique para ver as classificações",
"vote" => "votar",
"Sent editions" => "Edições enviadas",
"users" => "usuários",
"sent" => "enviada",
"use" => "usar",
"Structures:" => "Estruturas:",
"show structures" => "mostrar estruturas",
"hide structures" => "esconder estruturas",
"Manage structures" => "Administrar estruturas",
"Are you sure you want to remove this module?" => "Você tem certeza que deseja remover esse módulo?",
"Powered by" => "Provido por",
"Execution time" => "Tempo de execução",
"secs" => "s",
"Memory usage" => "Memória usada",
"database queries used" => "consultas usadas no banco de dados",
"Server load" => "Carga do servidor",
"page id" => "id da página",
"cached" => "em cache",
"3d browser" => "navegador 3D",
"print" => "imprimir",
"create pdf" => "criar pdf",
"Save to notepad" => "Salvar no bloco de notas",
"monitor this page" => "monitorar esta página",
"stop monitoring this page" => "não monitorar mais esta página",
"backlinks" => "referências",
"Previous page" => "Página anterior",
"Parent page" => "Página pai",
"Next page" => "Próxima página",
"Child" => "Criança",
"Add Page" => "Adicionar página",
"First page" => "Primeira página",
"page" => "página",
"Last page" => "Última página",
"Last edited by" => "Último edição por",
"based on work by" => "baseado no trabalho de",
"Page last modified on" => "Última modificação em",
"Contributors to this page" => "Contribuíram para esta página",
"last modification" => "última modificação em",
"To edit the copyright notices" => "Para editar as mensagens de diretos autorais",
"click here" => "clique aqui",
"The content on this page is licensed under the terms of the" => "O conteúdo desta página é licenciado sob os termos do",
"The original document is available at" => "O documento original pode ser encontrado em",
"rename" => "renomear",
"unlock" => "destravar",
"lock" => "travar",
"perms" => "permissões",
"history" => "histórico",
"similar" => "similares",
"undo" => "desfazer",
"export" => "exportar",
"discuss" => "discutir",
"add comment" => "comentário",
"1 comment" => "1 comentário",
"comments" => "comentários",
"attach file" => "anexar",
"1 file attached" => "1 arquivo anexado",
"{\$atts_cnt} files attached" => "{\$atts_cnt} arquivos anexados",
"translation" => "traduzir",
"Page generated in" => "Página gerada em",
"The newsletter was sent to {\$sent} email addresses" => "O comunicado foi enviado para {\$sent} endereços de email",
"This newsletter will be sent to {\$subscribers} email addresses." => "Este comunicado será enviado para {\$subscribers} endereços de email.",
"Prepare a newsletter to be sent" => "Preparar um comunicado para envio",
"Newsletter" => "Comunicado",
"Apply template" => "Aplicar um padrão",
"none" => "nenhum",
"Data" => "Dados",
"Send Newsletters" => "Enviar Comunicados",
"User List" => "Lista de usuários",
"Homework" => "Tarefa de casa",
"Assignments" => "Associações",
"Last Changes" => "Últimas alterações",
"attachments" => "anexos",
"Click" => "Clique",
"User files" => "Arquivos do usuário",
"Favorites" => "Favoritos",
"Watches" => "Notificações",
"Show/Hide Left Menus" => "Mostrar/esconder menus do lado esquerdo",
"Show/Hide Right Menus" => "Mostrar/esconder menus do lado direito",
"home" => "Página Inicial",
"contact us" => "entre em contato",
"stats" => "estats",
"categories" => "categorias",
"Member list" => "Lista de membros",
"last changes" => "últimas alterações",
"dump" => "exportação",
"list pages" => "listar páginas",
"orphan pages" => "páginas-órfãs",
"sandbox" => "bancada de testes",
"received pages" => "páginas recebidas",
"structures" => "estruturas",
"Articles Home" => "Página principal de Artigos",
"Create/Edit Blog" => "Criar/Editar Blog",
"Browse Directory" => "Listar links",
"List Quizzes" => "Listar Testes",
"List Trackers" => "Listar",
"List Surveys" => "Listar Pesquisas",
"Made with" => "Criado com",
"MyFiles" => "Meus Arquivos",
"back to homepage" => "voltar à página inicial",
"logout" => "sair",
"This page is being edited by" => "Esta página está sendo validada por",
"Proceed at your own peril" => "Prossiga por conta própria",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "A Caixa de Areia é uma página onde você pode praticar as técnicas de edição, usar o recurso de pré-visualização. Nenhuma versão da caixa de areia é armazenada.",
"Description" => "Descrição",
"My Footnotes" => "Notas de rodapé",
"Edit Summary" => "Comentário da edição",
"Year:" => "Ano:",
"Authors:" => "Autores:",
"Allow HTML" => "Permitir HTML",
"Spellcheck" => "Verificação ortográfica",
"Import page" => "Importar página",
"export all versions" => "exportar todas as versões",
"Upload picture" => "Carregar uma imagem",
"no cache" => "sem cache",
"minute" => "minuto",
"hour" => "hora",
"License" => "Licença",
"Important" => "Importante",
"Minor" => "Menor",
"cancel edit" => "cancelar edição",
"No attachments for this page" => "Nenhum anexo para esta página",
"Confirm your action" => "Confirme sua ação",
"Please, confirm your action" => "Por favor, confirme sua ação",
"left/right" => "esquerdo/direito",
"Unassign module" => "Módulo não associado",
"debugger console" => "console de depuração",
"Mini Calendar" => "Mini-Calendário",
"Edit mapfiles" => "Editar arquivos de mapas",
"switch" => "alternar",
"on:" => "em:",
"reads" => "leituras",
"Article image" => "Imagem do artigo",
"Topic image" => "Imagem do assunto",
"Refresh" => "Atualizar",
"Location : " => "Localização : ",
"Find:" => "Localizar:",
"Sort posts by:" => "Ordenar mensagens por:",
"posted by" => "enviada por",
"read more" => "ler mais",
"pages" => "páginas",
"Permalink" => "Link permanente",
"referenced by" => "referenciado por",
"references" => "referências",
"view comments" => "ver comentários",
"email this post" => "enviar por email",
"Viewing blog post" => "Visualizando mensagem do blog",
"Return to blog" => "Retornar ao blog",
"Blog name" => "Nome do blog",
"Translate in" => "Traduzir em",
"babelfish it" => "traduzir",
"User Bookmarks" => "Favoritos",
"Welcome to" => "Bem vindo a",
"Enlarge area height" => "Ampliar a altura de área",
"Reduce area height" => "Reduzir a altura de área",
"Features" => "Recursos",
"General" => "Geral",
"Site Identity" => "Identidade do site",
"Site Calendar" => "Calendário do site",
"i18n" => "Internacionalização",
"Category" => "Categoria",
"Module" => "Módulo",
"Theme" => "Tema",
"Text area" => "Área para texto",
"Tip" => "Dica",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "Para adicionar/remover blogs, va para \"Create/Edit blog\" em \"Blogs\" no menu de aplicações, ou",
"Home Blog" => "Blog Principal",
"Home Blog (main blog)" => "Blog Inicial (Blog principal)",
"Blog features" => "Recursos de Blog",
"Blog level comments" => "Comentários de nível de Blog",
"Post level comments" => "Comentários de nível de Envio",
"Spellchecking" => "Correção ortográfica",
"Not Installed" => "Não Instalado",
"Default ordering for blog listing" => "Ordem padrão para listagem de Blog",
"Creation date (desc)" => "Data de criação (desc)",
"Last modification date (desc)" => "última data de modificação (desc)",
"Blog title (asc)" => "Título do Blog (asc)",
"Number of posts (desc)" => "Número de mensagens (desc)",
"Visits (desc)" => "Visitas (desc)",
"Activity (desc)" => "Atividade (desc)",
"Change preferences" => "Alterar preferências",
"Blog listing configuration (when listing available blogs)" => "Configuração de listagem de Blog (listando Blogs disponíveis)",
"Creation date" => "Data de criação",
"Last modification time" => "Última hora de modificação",
"Disabled" => "Desabilitado",
"Plain text" => "Texto não formatado",
"Link to user information" => "Link para informações do usuário",
"User avatar" => "Fotografia do usuário",
"Blog comments settings" => "Configurações de comentários de Blog",
"Default number of comments per page" => "Número padrão de comentários por página",
"Comments default ordering" => "Ordenação padrão para comentários",
"Points" => "Pontos",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Para adicionar/remover calendários, vá em \"Calendário\" em \"Administrar\" no menu principal, ou",
"Group calendar sticky popup" => "Popup pegajoso do calendário do grupo",
"Group calendar item view tab" => "Tab para ver item do calendário do grupo",
"Calendar manual selection of time/date" => "Seleção manual de hora e data do calendário",
"JsCalendar" => "Calendário Java Script",
"Change settings" => "Alterar configurações",
"Use categories to regroup various Tiki objects." => "Use as categorias para agrupar vários objetos do site.",
"Browse categories" => "Navegar nas categorias",
"Administer categories" => "Administrar categorias",
"Show Category Path" => "Exibir o Caminho de Categorias",
"Show Category Objects" => "Exibir Objetos de Categorias",
"Search may show forbidden results. Much better performance though." => "Busca pode mostrar resultados proibidos, mas isso garante uma performace melhor.",
"Ignore category viewing restrictions" => "Ignorar restrições para visualizar categorias",
"Look under \"Articles\" on the application menu for links to" => "Procure em \"Articles\" no menu de aplicações por links para",
"CMS features" => "Recursos de CMS",
"Submissions" => "Artigos submetidos",
"Use templates" => "Usar padrões",
"Print article" => "Imprimir artigo",
"Settings for page articles home" => "Configurações para a página inicial de artigos",
"Maximum number of articles in home" => "Número máximo de artigos na página inicial",
"Article comments settings" => "Configurações de comentários de artigos",
"Fields to display on page" => "Campos para mostrar na página",
"Topic" => "Assunto",
"Publish Date" => "Data de Publicação",
"Expire Date" => "Data de Expiração",
"Visible" => "Visível",
"User identity features" => "Recursos da identidade do usuário",
"Show user's info on mouseover" => "Mouseover mostra informações do usuário",
"Picture" => "Figura",
"Number of friends" => "Número de amigos",
"Country" => "País",
"Last login" => "Último login",
"Distance" => "Distância",
"Set features" => "Definir recursos",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "Para configurar o seu diretório, procure \"Admin directory\" em \"Directory\" no menu de aplicações, ou",
"Number of columns per page when listing categories" => "Número de colunas por página quando listar categorias",
"Links per page" => "Links por página",
"Validate URLs" => "Validar Endereços",
"enable cool sites" => "habilitar sites legais",
"Method to open directory links" => "Abrindo links do diretório",
"replace current window" => "substituir a janela atual",
"new window" => "nova janela",
"inline frame" => "frame interno",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Para adicionar/remover FAQs, procure por \"Admin FAQs\" em \"FAQs\" no menu de aplicações, ou",
"Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Veja a <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">avaliação de cada recurso</a> no site de desenvolvimento do Tiki.",
"Tiki sections and features" => "Seções e recursos do Tiki",
"Featured Help" => "Auxílio oferecido",
"Workflow engine" => "Gerenciador de Workflow",
"Live Support" => "Suporte on-line",
"Live support system" => "Sistema de auxílio on-line",
"Help System" => "Sistema de Ajuda",
"Show Module Controls" => "Mostrar Controle de Módulos",
"Tiki Calendar" => "Calendário Tiki",
"Tiki Template Viewing" => "Visualização de Modelos Tiki",
"PhpLayers Dynamic menus" => "Menus dinâmicos PhpLayers",
"Use Tabs" => "Usar Tabs",
"Tiki Sheet" => "Planilha Tiki",
"Site Logo and Identity" => "Logo do site e identidade",
"Mobile" => "Dispositivos móveis",
"Content Features" => "Recursos de Conteúdo",
"Hotwords in New Windows" => "Palavras-chaves em novas janelas",
"Custom Home" => "Página Inicial Personalizada",
"HTML Pages" => "Páginas HTML",
"Dynamic Content System" => "Sistema de Conteúdo Dinâmico",
"Allow Smileys" => "Permitir Emoticons",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use o plugin QUOTE em vez de &ldquo;>&rdquo; para citar",
"Administration Features" => "Recursos de administração",
"Banning System" => "Sistema de Banimento",
"Banning system" => "Sistema de banimento",
"Debugger Console" => "Console de depuração",
"Communications (send/receive objects)" => "Comunicação (enviar/receber objetos)",
"Theme Control" => "Controle de temas",
"XMLRPC API" => "API de XMLRPC",
"Referer Stats" => "Estatísticas de Referências",
"Contact Us" => "Entre em Contato",
"Contact Us (Anonymous)" => "Contate-nos (Anônimo)",
"Redirect On Error" => "Redirecionar em caso de erro",
"User Features" => "Recursos do Usuário",
"User Preferences Screen" => "Tela de Preferências do Usuário",
"Users can Configure Modules" => "Usuários podem configurar módulos",
"always" => "sempre",
"module decides" => "módulo decide",
"never" => "nunca",
"Users can Shade Modules" => "Usuários podem sombrear módulos",
"User Watches" => "Notificações do usuário",
"User Watches Translations" => "Usuários acompanham as traduções",
"User Tasks" => "Tarefas do usuário",
"User Messages" => "Mensagens do usuário",
"User Files" => "Arquivos do usuário",
"User Notepad" => "Bloco de notas do usuário",
"General Layout options" => "Opções gerais de layout",
"Users can Flip Columns" => "Usuários podem mudam colunas",
"Left column" => "Coluna da esquerda",
"user decides" => "usuário decide",
"Right column" => "Coluna da direita",
"Layout per section" => "Layout por sessão",
"Admin layout per section" => "Administrar layout por sessão",
"Top bar" => "Barra superior",
"Bottom bar" => "Barra inferior",
"Bottom bar icons" => "Ícones da barra inferior",
"Bottom bar debug" => "Informações de <i>debug</i> na barra inferior",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Para adicionar/remover galerias de arquivos, vá para \"Acervo de arquivos\" no menu de aplicações, ou",
"Home Gallery" => "Página inicial das Galerias",
"Home Gallery (main gallery)" => "Galeria Inicial (galeria principal)",
"Galleries features" => "Recursos das Galerias",
"Allow same file to be uploaded more than once" => "Permitir que o mesmo arquivo seja enviado mais de uma vez",
"Use database to store files" => "Utilizar o banco de dados para armazenar arquivos",
"Use a directory to store files" => "Utilizar um diretório para armazenar arquivos",
"Directory path" => "Caminho do diretório",
"Uploaded filenames must match regex" => "Arquivos carregados devem seguir a expressão regular",
"Uploaded filenames cannot match regex" => "Arquivos carregados não podem seguir a expressão regular",
"Storing files in a directory" => "Guardando arquivos em um diretório",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Se você decidir guardar arquivos em um diretório precisa ter certeza de que os usuários não conseguem acessam diretamente o diretório escolhido.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Você tem duas opções:<br /><ul><li>Usar um diretório fora do documento root, para isso verifique se o seu script php pode ler e escrever nesse diretório</li><li>Usar um diretório dentro do documento root e usar .htaccess para prevenir que os usuários possam listar o conteúdo do diretório</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Para configurar o diretório do patch use patchs do UNIX, por exemplo files/ ou c:/foo/files ou /www/files/",
"please read" => "por favor, leia",
"Gallery listing configuration" => "Configuração da listagem de galeria",
"Change configuration" => "Alterar configuração",
"File galleries comments settings" => "Configurações de comentários de galerias de arquivos",
"File galleries search indexing" => "Galeria de arquivos indexada para busca",
"Leave command blank to delete handler" => "Deixe o comando em branco para deletar a indexação",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 onde o nome do arquivo deve ser substituído (exemplo: \"strings %1\" para converter o documento para texto usando o comando de strings do unix)",
"Enable auto indexing on file upload or change" => "Habilitar indexamento automático quando fizer upload ou alteração de arquivo",
"MIME Type" => "Tipo MIME",
"System command" => "Comando do sistema",
"Reindex all files for search" => "Reindexar todos os arquivos para busca",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Para adicionar/remover forums, procure por \"Admin forums\" em \"Forums\" no menu de aplicações, ou",
"Home Forum" => "Página inicial do fórum",
"Home Forum (main forum)" => "Fórum Inicial (fórum principal)",
"Forums features" => "Recursos do fórum",
"Accept wiki syntax" => "Aceitar sintaxe Wiki",
"Forum quick jumps" => "Navegação rápida pelo fórum",
"Ordering for forums in the forum listing" => "Ordenação dos fóruns na listagem",
"Creation Date (desc)" => "Data de criação (desc)",
"Topics (desc)" => "Assuntos (desc)",
"Threads (desc)" => "Seqüências (desc)",
"Last post (desc)" => "Última mensagem (desc)",
"Name (desc)" => "Nome (desc)",
"Name (asc)" => "Nome (asc)",
"Forum listing configuration" => "Configuração da listagem de fóruns",
"Topics" => "Assuntos",
"Posts per day" => "Mensagens por dia",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Para adicionar/remover galerias, vá para \"Acervo de imagens\" no menu de aplicações, ou",
"You can upload images of a size of " => "Você pode fazer upload de imagens nesse tamanho ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Altere as variáveis file_uploads, upload_max_filesize, post_max_size e database variables (max_allowed_packet no mysql) para mudar os valores no arquivo php.ini",
"Uses Slideshow" => "Usar Slideshow",
"Use database to store images" => "Utilizar banco de dados para armazenar imagens",
"Use a directory to store images" => "Utilizar um diretório para armazenar imagens",
"Library to use for processing images" => "Biblioteca para processamento de imagens",
"Uploaded image names must match regex" => "Imagens carregadas devem seguir a expressão regular",
"Uploaded image names cannot match regex" => "Imagens carregadas não podem seguir a expressão regular",
"Directory Batch Loading" => "Carregar diretórios em lote",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Se você ativar a opção para carregar diretórios em lote, é necessário configurar um diretório onde seu servidor web possa ler (de preferência fora do seu espaço web). Também é necessário configurar uma forma para fazer o upload de imagens para aquele diretório, isso pode ser por scp, ftp, ou de outras formas",
"Enable directory batch loading" => "Habilitar a função de carregar diretórios em lote",
"Batch loading directory" => "Diretório carregado em lote",
"Enable cache images to all galleries" => "Habilitar imagens em cache para todas as galerias",
"Images cache directory" => "Diretório de imagens em cache",
"Exterminator" => "Exterminador",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Remover da galeria do sistema imagens que não estão sendo usados ou páginas Wiki, artigos ou mensagens de Blog",
"Move images from database storage to filesystem storage" => "Mover imagens da base dados para um diretório no sistema de arquivos",
"Move images from filesystem storage to database storage" => "Mover imagens de um diretório no sistema de arquivos para a base de dados",
"All galleries" => "Todas as galerias",
"Move" => "Mover",
"Move images from old filesystem store to new directory" => "Mover imagens de um diretório antigo para um novo diretório no sistema de arquivos",
"Moved" => "Movido",
"images" => "imagens",
"Image galleries comments settings" => "Configurações de comentários para galerias de imagens",
"General Preferences" => "Preferências gerais",
"Use group homepages" => "Página inicial por grupo",
"Go to group homepage only if login from default homepage" => "Ir para a página inicial do grupo apenas se o login for feito a partir da página inicial padrão",
"Use URI as Home Page" => "Utilizar URI como página inicial",
"Home page" => "Página inicial",
"Custom home" => "Página inicial personalizada",
"OS" => "Sistema Operacional",
"Unknown/Other" => "Desconhecido/Outro",
"PHP error reporting level for non-admin:" => "Nível de avisos de erros de PHP para não-administradores:",
"No error reporting" => "Não reportar erros",
"Report all PHP errors" => "Reportar todos os erros de PHP",
"Report all errors except notices" => "Reportar todos os erros, com exceção das notícias",
"Report PHP errors only for admin" => "Reportar erros de PHP apenas para os administradores",
"Default charset for sending mail:" => "Codificação de caracteres padrão para enviar e-mail:",
"Mail end of line:" => "Final de linha do e-mail:",
"(standard)" => "(padrão)",
"(some Unix MTA)" => "(alguns Unix MTA)",
"General Settings" => "Configurações Gerais",
"Disallow access to the site (except for those with permission)" => "Desabilitar o acesso ao site (exceto para quem tem permissão)",
"Message to display when site is closed" => "Mostrar mensagem quando o site estiver fechado",
"Disallow access when load is above the threshold (except for those with permission)" => "Desabilitar o acesso quando a carga do servidor está acima do seu limiar (exceto para quem possui permissão)",
"Max average server load threshold in the last minute" => "Média máxima carregada no último minuto",
"Message to display when server is too busy" => "Mostrar mensagem quando o servidor estiver sobrecarregado",
"Open external links in new window" => "Links externos em nova janela",
"Display modules to all groups always" => "Módulos acessíveis por todos grupos",
"Use cache for external pages" => "Cache para páginas externas",
"Use cache for external images" => "Cache para imagens externas",
"Use direct pagination links" => "Links de paginação direta",
"Display menus as folders" => "Exibir menus como pastas",
"Use gzipped output" => "Saída comprimida (gzip)",
"output compression is active." => "saída compactada ativa.",
"compression is handled by" => "compactação é feita por",
"Count admin pageviews" => "Contar visitas do admin",
"Hide anonymous-only modules from registered users" => "Esconder módulos exclusivos dos usuários anônimos de usuários registrados",
"Server name (for absolute URIs)" => "Nome do servidor (para URIs absolutas)",
"HTTPS Server" => "Servidor HTTPS",
"Automatic (uses HTTPS variable)" => "Automático (usar variável HTTPS)",
"No" => "Não",
"Yes" => "Sim",
"Browser title" => "Título no navegador",
"Wiki_Tiki_Title" => "Titulo_Wiki_Tiki",
"Temporary directory" => "Diretório temporário",
"Sender Email" => "Remetente (e-mail)",
"Contact user" => "Usuário para contato",
"Allow anonymous users to \"Contact Us\"" => "Permitir que usuários anônimos \"Contact Us\"",
"contact feature disabled" => "contato desabilitado",
"Store session data in database" => "Armazenar sessões no banco de dados",
"Session lifetime in minutes" => "Tempo de vida das sessões em minutos",
"Use proxy" => "Usar proxy",
"Proxy Host" => "Host do Proxy",
"Proxy port" => "Porta do Proxy",
"Maximum number of records in listings" => "Número máximo de registros em listagens",
"Help system" => "Sistema de ajuda",
"Help URL" => "URL de ajuda",
"Any help with the documentation is welcome." => "Qualquer ajuda com a documentação é bem-vinda.",
"Date and Time Formats" => "Formatos de data e hora",
"Long date format" => "Formato longo para datas",
"Short date format" => "Formato curto para datas",
"Long time format" => "Formato longo para horas",
"Short time format" => "Formato curto para horas",
"Date and Time Format Help" => "Auxílio para formatos de data e hora",
"Favicon icon file name:" => "Nome do arquivo do favicon:",
"Favicon icon MIME type:" => "Tipo MINE do Favicon:",
"image/png" => "imagem/png",
"image/bmp" => "imagem/bmp",
"image/x-icon" => "imagem/x-icon",
"Locations separator" => "Separador de localizações",
"Register this site at tikiwiki.org" => "Registrar este site no tikiwiki.org",
"Click here for more details." => "Clique aqui para mais detalhes.",
"Change admin password" => "Alterar a senha de admin",
"New password" => "Nova senha",
"Change password" => "Alterar senha",
"Google Map setup" => "Configuração do Google Map",
"You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "Você precisa soliticar uma chave do Google Maps para esse site. Isso pode ser feito no endereço:",
"Google Map Key" => "Chave do Google Maps",
"Internationalization" => "Internacionalização",
"I18n setup" => "Configurar internacionalização",
"Multilingual" => "Multilíngüe",
"Detect browser language" => "Detectar idioma do navegador",
"Reg users can change language" => "Usuários comuns podem alterar idioma",
"Restrict available languages" => "Restringir línguas disponíveis",
"Available languages:" => "Línguas disponíveis:",
"Use database for translation" => "Usar banco de dados para tradução",
"Edit or ex/import Languages" => "Editar ou importar/exportar Línguas",
"Record untranslated" => "Gravar sem tradução",
"Show Babelfish Translation URLs" => "Mostrar URLs de Tradução do Babelfish",
"Show Babelfish Translation Logo" => "Mostrar Logo de Tradução Babelfish",
"Warning: overrides manually registered local users" => "Alerta: sobrescreve usuários locais criados manualmente",
"Import user preferences" => "Importar preferências do usuários",
"Import user groups" => "Importar grupos de usuários",
"host" => "servidor",
"port" => "porta",
"path" => "caminho",
"groups" => "grupos",
"Add new server" => "Adicionar novos servidores",
"Key" => "Chave",
"Contact" => "Contato",
"New" => "Novo",
"Enable/disable Tiki features in " => "Habilitar/desabilitar recursos do Tiki em ",
"Admin->Features" => "Administrar->Recursos",
", but configure them elsewhere" => ", mas configure em outro lugar",
"Text Area" => "Área de texto",
"Users &amp; groups" => "Usuários &amp; grupos",
"Admin groups" => "Administrar grupos",
"Admin users" => "Administrar usuários",
"User registration and login" => "Cadastro e login de usuário",
"Authentication method" => "Método de autenticação",
"Just Tiki" => "Apenas autenticação do Tiki",
"Web Server" => "Servidor Web",
"Tiki and PEAR::Auth" => "Tiki e PEAR::Auth",
"Tiki and PAM" => "Tiki e PAM",
"CAS (Central Authentication Service)" => "CAS (Sistema de Autenticação Central)",
"Tiki and HTTP Auth" => "Tiki e autenticação HTTP",
"Use WebServer authentication for Tiki" => "Utilizar autenticação do servidor Web para o Tiki",
"Users can register" => "Usuários podem se cadastrar",
"... but need admin validation" => "... mas precisa de autorização do administrador",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Você precisa definir o <a href=\"tiki-admin.php?page=general\">remetente (e-mail)</a>",
"Create a group for each user <br />(with the same\nname as the user)" => "Criar um grupo para cada usuário <br />(com o mesmo \nnome do usuário)",
"Use tracker for more user information" => "Usar acompanhamentos para mais informações do usuário",
"Use tracker for more group information" => "Usar acompanhamento para mais informações do grupo",
"Request passcode to register" => "Exigir código secreto para cadastro",
"Prevent automatic/robot registration" => "Evitar cadastro automático/robôs",
" - Php GD library required" => " - Biblioteca Php GD necessária",
"Validate users by email" => "Validar usuários por e-mail",
"Validate email address (may not work)" => "Validar endereço de e-mail (pode não funcionar)",
"Users accept internal messages by default" => "Usuários aceitam mensagens internas por padrão",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Lembrar senhas por e-mail (se \"Guardar senhas em texto puro\" esta ativado) ou gerar nova senha por e-mail",
"Store plaintext passwords" => "Armazenar senhas sem criptografia",
"Reg users can change password" => "Usuários registrados podem alterar sua senha",
"Reg users can change theme" => "Usuários comuns podem alterar tema",
"Restrict available themes" => "Restringir temas disponíveis",
"Available styles:" => "Estilos disponíveis:",
"Maximum mailbox size (messages, 0=unlimited)" => "Tamanho máximo da caixa de entrada (mensagens, 0=ilimitado)",
"Maximum mail archive size (messages, 0=unlimited)" => "Tamanho máximo do arquivo de e-mail (mensagens, 0=ilimitado)",
"Maximum sent box size (messages, 0=unlimited)" => "Tamanho máximo da caixa de saída (mensagens, 0=ilimitado)",
"Use challenge/response authentication" => "Utilizar autenticação desafio/resposta",
"Force to use chars and nums in passwords" => "Exigir uso de letras e números em senhas",
"Minimum password length" => "Comprimento mínimo para senhas",
"Password invalid after days" => "Invalidar senhas após (dias)",
"Require HTTP Basic authentication" => "Exigir autenticação básica HTTP",
"Allow secure (https) login" => "Permitir login seguro (https)",
"Require secure (https) login" => "Exigir login seguro (https)",
"HTTP server name" => "Nome do servidor HTTP",
"HTTP port" => "Porta HTTP",
"HTTP URL prefix" => "Prefixo do endereço HTTP",
"HTTPS server name" => "Nome do servidor HTTPS",
"HTTPS port" => "Porta HTTPS",
"HTTPS URL prefix" => "Prefixo do endereço HTTPS",
"Remember me feature" => "Lembre-me os recursos",
"Only for users" => "Apenas para usuários",
"Users and admins" => "Usuários e administradores",
"Duration:" => "Duração:",
"day" => "dia",
"week" => "semana",
"month" => "mês",
"year" => "ano",
"Remember me name" => "Lembre-se do meu nome",
"Remember me domain" => "Lembre-me o domínio",
"Remember me path" => "Lembre-me o caminho",
"Protect against CSRF with a confirmation step" => "Proteger contra CSRF com uma etapa de confirmação",
"Protect against CSRF with a ticket" => "Proteger contar CSRF com um ticket",
"Highlight Group" => "Destacar grupo",
"choose a group ..." => "escolher um grupo ...",
"Create user if not in Tiki?" => "Criar usuário se não estiver no Tiki?",
"Create user if not in Auth?" => "Criar usuários se não estiver no PEAR::Auth?",
"Just use Tiki auth for admin?" => "Utilizar apenas autenticação do Tiki para admin?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(se ativo, irá sobrescrever o host e a porta abaixo)",
"LDAP Scope" => "Escopo LDAP",
"LDAP Base DN" => "Base DN do LDAP",
"LDAP User DN" => "Usuário DN do LDAP",
"LDAP User Attribute" => "Atributo do usuário do LDAP",
"LDAP User OC" => "OC do usuário do LDAP",
"LDAP Group DN" => "DN do Grupo do LDAP",
"LDAP Group Attribute" => "Atributo do Grupo do LDAP",
"LDAP Group OC" => "OC do grupo do LDAP",
"LDAP Member Attribute" => "Atributo do Membro do LDAP",
"LDAP Member Is DN" => "Membro do LDAP é DN",
"LDAP Admin User" => "Usuário de Administração LDAP",
"LDAP Admin Pwd" => "Senha de Administração LDAP",
"PAM service" => "Serviço PAM",
"Currently unused" => "Atualmente sem uso",
"CAS server version" => "Versão do servidor CAS",
"Version 1.0" => "Versão 1.0",
"Version 2.0" => "Versão 2.0",
"CAS server hostname" => "Nome do servidor CAS",
"CAS server port" => "Porta do servidor CAS",
"CAS server path" => "Path do servidor CAS",
"Change CAS preferences" => "Alterar preferências do CAS",
"full path to mapfiles" => "caminho completo para os arquivos de mapas",
"default mapfile" => "arquivo de mapa padrão",
"Wiki Page for Help" => "Página Wiki para Ajuda",
"Wiki Page for Comments" => "Página Wiki para Comentários",
"Full path to gdaltindex" => "Caminho completo para o gdaltindex",
"Full path to ogr2ogr" => "Path completo para ogr2ogr",
"Map Zone" => "Zona do mapa",
"Generate User Map" => "Gerar mapa do usuário",
"<b>Item</b>" => "<b>Ítem</b>",
"<b>Value</b>" => "<b>Valor</b>",
"Meta Keywords" => "Meta palavras-chaves",
"Meta Description" => "Meta descrição",
"Meta Author" => "Meta autor",
"geo.position" => "geo.posição",
"geo.region" => "geo.região",
"geo.placename" => "geo.nome_do_local",
"Robots" => "Robôs",
"meta robots" => "meta robôs",
"revisit after" => "retorne depois",
"Administer modules" => "Administrar módulos",
"Hint: If you remove your login module, use tiki-login_scr.php to be able to login!" => "Dica: se você remover o módulo de login, acesse diretamente a página tiki-login_scr.php para se logar!",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Para adicionar/remover enquetes, procure por \"Polls\" em \"Admin\" no menu de aplicações, ou",
"Allow Anonymous Poll Voting" => "Permitir que anônimos votem na enquete",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "Essa página é para configurar os fontes RSS gerados/exportados pelo tiki. Para ler/importar fontes RSS, procure por \"RSS modules\" no menu de aplicações, ou",
"<b>Feed</b>" => "<b>Campo</b>",
"<b>enable/disable</b>" => "<b>habilita/desabilita</b>",
"<b>Max number of items</b>" => "<b>Número máximo de itens</b>",
"Feed for Articles" => "Fonte para Artigos",
"Feed for Weblogs" => "Fonte para Weblogs",
"Feed for Image Galleries" => "Fonte para Galerias de Imagens",
"Feed for File Galleries" => "Fonte para Galerias de Arquivos",
"Feed for the Wiki" => "Fonte para Wiki",
"Feed for individual Image Galleries" => "Fonte para Galerias individuais de Imagens",
"Feed for individual File Galleries" => "Fonte para Galerias individuais de Arquivos",
"Feed for individual weblogs" => "Fonte para Weblogs individuais",
"Feed for forums" => "Fonte para fóruns",
"Feed for individual forums" => "Fonte para fóruns individuais",
"Feed for mapfiles" => "Campo para arquivos de mapas",
"Feed for directories" => "Fonte para os diretórios",
"Feed for tracker items" => "Fonte para os itens dos acompanhamentos",
"Default RDF version" => "Versão RDF padrão",
"Specification" => "Especificação",
"Documentation" => "Documentação",
"Caching time :" => "Tempo de cache :",
"seconds (0 = cache inactive)" => "segundos (0 = cache disabilitado)",
"You can see users rank by score in the module users_rank, for that go to" => "Você pode ver o ranking dos usuários no módulo users_rank, para isso procure por",
"Admin modules" => "Administrar módulos",
"Expiration" => "Expiração",
"Search features" => "Recursos da busca",
"Full Text Search" => "Busca completa",
"SearchStats" => "EstatsBusca",
"Referer Search Highlighting" => "Destacar busca",
"Refresh wiki search index now" => "Atualizar índice de busca no wiki agora",
"Performance issues" => "Questões de desempenho",
"Ignore individual object permissions" => "Ignorar permissões individuais para objeto",
"Settings for searching content" => "Configurações para busca de conteúdo",
"Search refresh rate" => "Taxa de atualização de busca",
"Minimum length of search word" => "Tamanho mínimo da palavra de busca",
"Max. number of words containing a syllable" => "Número máximo de palavras contendo uma sílaba",
"Max. age in hours of syllable search cache" => "Tempo máximo em horas de buscas de sílabas armazenadas",
"LRU list length" => "Tamanho da lista LRU",
"Don't forget: to use feature you will need to enable it on" => "Não se esqueça: para usar um recurso você precisa habilita-lo",
"This text can be used as a variable" => "Esse texto pode ser usado como uma variável",
"Custom Code" => "Código customizável",
"Custom code" => "Código customizável",
"Content" => "Conteúdo",
"Publish" => "publicação",
"Site Breadcrumbs" => "Rastro de navegação",
"Site breadcrumbs" => "Rastro de navegação",
"Site location bar" => "Barra de localização do site",
"at top of page" => "no topo da página",
"at top of center column" => "no topo da coluna central",
"Larger font for" => "Maior fonte para",
"entire location" => "localização completa",
"page name" => "nome da página",
"Use page description:" => "Descrição do uso da página:",
"Site Search" => "Busca do site",
"Site search bar" => "Barra de busca do site",
"Site Logo" => "Logo do site",
"Site logo" => "Logo do site",
"Site logo source" => "Fonte do logo do site",
"Site logo background color" => "Cor de fundo do logo do site",
"Site logo title (on mouse over)" => "Título do logo do site (aparece quando o mouse passa por cima)",
"Alt. description (e.g. for text browsers)" => "Descrição alternativa (ex: para navegadores modo texto",
"Site Ads and Banners" => "Publicidade e banners do site",
"Site ads and banners" => "Publicidade e banners do site",
"Site Menu" => "Menu do site",
"Site menu bar" => "Barra do menu do site",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Nota: para esse recursor funcionar é necessário ativar phplayers em Administrar->Recursos",
"Anonymous editors must input anti-bot code" => "Editores anônimos precisam preencher código anti-rôbo",
"Please also see:" => "Veja também:",
"Change style only" => "Mudar apenas o estilo",
"Slideshows theme" => "Tema para slides",
"Edit CSS" => "Editar CSS",
"View Templates" => "Ver templates",
"Edit Templates" => "Editar padrões",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Para configurar seus acompanhamentos, procure por \"Admin trackers\" em \"Trackers\" no menu de aplicações, ou",
"Trackers attachments preferences" => "Preferências dos anexos dos acompanhamentos",
"Path" => "Caminho",
"Trackers with mirror tables" => "Acompanhamentos com tabelas espelho",
"Use trackers with mirror tables" => "Usar acompanhamentos com tabelas espelho",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Dados são armazenados em uma tabela dedicada para cada acompanhamento, então você pode facilmente manipulá-los fora do Tikiwiki",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "ATENÇÃO: Acompanhamentos Velhos e Novos não podem coexistir. Acompanhamentos criados com a nova biblioteca\nnão funcionarão com a biblioteca nova e vice-versa",
"Validate choice" => "Validar escolha",
"Trackers attachments" => "Anexos dos acompanhamentos",
"Storage" => "Armazenar",
"change" => "alterar",
"Change all to db" => "Mudar tudo para a base de dados",
"Change all to file" => "Mudar tudo para arquivo",
"Quota (Mb)" => "Cota (Mb)",
"Use database to store userfiles" => "Utilizar o banco de dados para armazenar arquivos dos usuários",
"Use a directory to store userfiles" => "Utilizar um diretório para armazenar arquivos dos usuários",
"Allow viewing HTML mails?" => "Permitir visualização de mensagens HTML?",
"Maximum size for each attachment" => "Tamanho máximo para cada arquivo anexado",
"Unlimited" => "Ilimitado",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Para adicionar/editar páginas wiki facilmente, adicione o módulo  quick_edit em \"Modules\" no menu de aplicações, ou",
"Dumps" => "Exportações",
"Generate dump" => "Gerar exportação",
"Download last dump" => "Download última exportação",
"Create a Tag for the Current Wiki" => "Criar Tag para o wiki atual",
"Tag name" => "Nome da Tag",
"Restore the Wiki" => "Restaurar o Wiki",
"restore" => "restaurar",
"Remove a Tag" => "Remover Tag",
"Wiki Comments Settings" => "Configurações dos comentários Wiki",
"Export Wiki Pages" => "Exportar páginas Wiki",
"Export" => "Exportar",
"Wiki Administration" => "Administração do Wiki",
"Manage attachment preferences" => "Alterar as preferências dos anexos",
"Remove unused pictures" => "Remover imagens não utilizadas",
"Wiki Home Page" => "Página inicial do Wiki",
"Wiki Discussion" => "Discussão Wiki",
"Discuss pages on forums" => "Discutir páginas nos fóruns",
"Wiki Link Format" => "Formato de Link Wiki",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controlar reconhecimento de links Wiki usando dois parênteses como sintaxe Wiki <i>((nome da página))</i>.",
"complete" => "completo",
"latin" => "latim",
"english" => "inglês",
"Wiki Page List Configuration" => "Configuração da lista de páginas Wiki",
"Creator" => "Criador",
"Last version" => "Última versão",
"Status" => "Estado",
"Versions" => "Versões",
"Backlinks" => "Referências",
"Wiki 3D Browser Configuration" => "Configuração do Wiki 3D Browser",
"Enable wiki 3D browser" => "Habilitar navegador wiki 3D",
"Browser width" => "Largura da janela do navegador",
"Browser height" => "Altura da janela do navegador",
"Navigation depth" => "Profundidade da navegação",
"Feed animation interval (milisecs)" => "Intervalo de popup dos páginas (milisegundos)",
"Existing page node color" => "Cor das páginas existentes",
"Missing page node color" => "Cor das páginas inexistentes",
"HTML in Wiki Pages" => "HTML nas páginas Wiki",
"Wiki syntax used when a page contains HTML" => "Usar sintaxe Wiki para páginas que possuem HTML",
"full" => "completo",
"partial" => "parcial",
"Wysiwyg editor" => "Editor Wysiwyg",
"default" => "padrão",
"optional" => "opcional",
"Wiki Features" => "Recursos Wiki",
"Moved to:" => "Movido para:",
"Undo" => "Desfazer",
"MultiPrint" => "MultiImpressão",
"PDF generation" => "Geração de PDF",
"Warn on edit conflict" => "Avisar quando houver conflito de edição",
"Edit idle timeout" => "Tempo limite de espera para edição",
"mins" => "min",
"Pictures" => "Figuras",
"Use page description" => "Usar descrição de página",
"Show page title" => "Exibir título da página",
"Show page ID" => "Mostrar ID da página",
"Cache wiki pages (global)" => "Armazenamento de páginas wiki (global)",
"Individual cache" => "Armazenamento individual",
"Footnotes" => "Notas de rodapé",
"Users can lock pages (if perm)" => "Usuários podem travar páginas (se perm)",
"Use WikiWords" => "Usar WikiWords",
"Accept dashes and underscores in WikiWords" => "Aceitar hífen e travessão em PalavrasWiki",
"Link plural WikiWords to their singular forms" => "Conectar plurais de PalavrasWiki para suas formas singulares",
"Use Wiki paragraph formatting" => "Usar formatação Wiki de parágrafos",
"Automonospaced text" => "Texto auto-monoespaçado",
"Tables syntax" => "Sintaxe de tabelas",
"|| for rows" => "|| para linhas",
"\\n for rows" => "\\n para linhas",
"Open page as structure" => "Abrir página como estrutura",
"Use external link icons" => "Usar links de ícones externos",
"User's Page" => "Página do Usuário",
"UserPage prefix" => "Prefixo da página do usuário (UserPage)",
"Page creators are admin of their pages" => "Autores são admins de suas páginas",
"Import HTML" => "Importar HTML",
"Import Page" => "Importar páginas",
"List authors" => "Lista de autores",
"as Creator &amp; Last Editor" => "como criador &amp; Último editor",
"Business style" => "Estilo de negócios",
"Collaborative style" => "Estilo colaborativo",
"no (disabled)" => "não (disabilitado)",
"Print Page" => "Imprimir página",
"Regex search and replace" => "Busca e substituição regex",
"Wiki History" => "Histórico Wiki",
"Maximum number of versions for history" => "Número máximo de versões para histórico",
"unlimited" => "ilimitado",
"Never delete versions younger than days" => "Nunca apagar versões mais novas que (dias)",
"IP not displayed in history" => "IP não aparece no histórico",
"Diff style" => "Estilo de comparação entre versões",
"Only with last version" => "Apenas com a última versão",
"Any 2 versions" => "2 versões quaisquer",
"Copyright Management" => "Gerenciamento de Copyright",
"Enable Feature" => "Habilitar Recursos",
"License Page" => "Página de Licença",
"Submit Notice" => "Nota de Submissão",
"Wiki Watch" => "Notificação Wiki",
"Create watch for author on page creation" => "Criar notificações para autor na criação da página",
"Enable watch events when I am the editor" => "Habilitar notificações de eventos quando eu for o editor",
"Enable watches on comments" => "Habilitar notificações em comentários",
"Wiki attachments preferences" => "Preferências dos anexos Wiki",
"Wiki attachments" => "Arquivos anexados Wiki",
"Crosslinks to other features and settings" => "Links relacionados com outros recursos e configurações",
"Other sections" => "Outras sessões",
"Administration features" => "Recursos de administração",
"Security" => "Segurança",
"System" => "Sistema",
"SysLogs" => "Logs do sistema",
"Transversal features" => "Recursos transversais",
"which apply to more than one section" => "aqueles que se aplicam a mais de uma seção",
"Navigation features" => "Recursos de navegação",
"Text area features" => "Recursos de áreas de texto",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "recursos aplicáveis a todas as áreas de texto, como páginas wiki, artigos, blogs etc",
"Help on Banning System" => "Ajuda para banir o sistema",
"View tpl" => "Exibir tpl",
"admin banning tpl" => "administrar banir tpl",
"Add or edit a rule" => "Adicionar ou editar uma regra",
"Rule title" => "Título da regra",
"Username regex matching" => "Identificador de usuário por expressão regular",
"IP regex matching" => "IP por expressão regular",
"Banned from sections" => "Banido(a) das seções",
"check / uncheck all" => "marcar / desmarcar todos",
"Rule activated by dates" => "Regra ativada por datas",
"Rule active from" => "Regra ativa de",
"Rule active until" => "Regra ativa até",
"Custom message to the user" => "Mensagem personalizada para o usuário",
"Rules" => "Regras",
"User/IP" => "Usuário/IP",
"Sections" => "Seções",
"Admin Calendars" => "Administrar Calendários",
"Configure/Options" => "Configurar/Opções",
"List of Calendars" => "Lista de Calendários",
"participants" => "participantes",
"subscription" => "inscrições",
"permissions" => "permissões",
"Create/edit Calendars" => "Criar/editar Calendários",
"Custom Locations" => "Locais Personalizados",
"yes" => "sim",
"Custom Participants" => "Personalizar participantes",
"Custom Categories" => "Categorias Personalizadas",
"Custom Languages" => "Idiomas Personalizados",
"Custom Subscription List" => "Personalizar lista de inscrições",
"Custom Priorities" => "Prioridades Personalizadas",
"Personal Calendar" => "Calendário pessoal",
"admin categories" => "administrar categorias",
"admin categories tpl" => "admin categorias tpl",
"browse the category system" => "mudar para o sistema de categorias",
"Current category" => "Categoria atual",
"Top" => "Topo",
"Child categories" => "Categorias-filhas",
"Edit this category:" => "Editar esta categoria:",
"create new" => "criar nova",
"Add new category" => "Adicionar uma nova categoria",
"Parent" => "Pai",
"Perms inherited from closest parent if possible or from global perms" => "Permissões inerentes ao parentesco mais próximo se possível ou a permissões globais",
"Assign permissions automatically" => "Associar permissão automaticamente",
"recommended for best performance" => "recomendado para melhorar o desempenho",
"Edit permissions for this category" => "Editar permissões para essa categoria",
"Objects in category" => "Objetos na categoria",
"type" => "tipo",
"Add objects to category" => "Adicionar objetos à categoria",
"image gal" => "gal. imagem",
"file gal" => "gal. arquivo",
"Admin chart items" => "Administrar itens de gráficos",
"charts" => "gráficos",
"edit chart" => "editar gráfico",
"Add or edit an item" => "Adicionar ou editar um item",
"URL" => "Endereço",
"update" => "atualizar",
"Chart items" => "Itens de gráficos",
"No items defined yet" => "Nenhum item foi definido ainda",
"Admin charts" => "Administrar gráficos",
"View template" => "Visualizar template",
"Add or edit a chart" => "Adicionar ou editar um gráfico",
"Active" => "Ativo",
"Users can vote for only one item from this chart per period" => "Usuários podem votar em um único item por período",
"Prevent users from voting for the same item more than once" => "Previne que usuários votem no mesmo item mais de uma vez",
"Users can suggest new items" => "Usuários podem sugerir itens",
"Auto validate user suggestions" => "Validades automaticamente sugestões de usuários",
"Ranking shows" => "Ranking exibe",
"All items" => "Todos os itens",
"Top 10 items" => "10 itens superiores",
"Top 20 items" => "20 itens superiores",
"Top 40 items" => "40 itens superiores",
"Top 50 items" => "50 itens superiores",
"Top 100 items" => "100 itens superiores",
"Top 250 items" => "250 itens superiores",
"Voting system" => "Sistema de votação",
"Vote items" => "Itens de voto",
"Rank 1..5" => "Nota 1..5",
"Rank 1..10" => "Nota 1..10",
"Ranking frequency" => "Freqüência de votação",
"Realtime" => "Tempo real",
"Each 5 minutes" => "A cada 5 minutos",
"Daily" => "Diariamente",
"Weekly" => "Semanalmente",
"Monthly" => "Mensalmente",
"Show Average" => "Exibir a Média",
"Show Votes" => "Exibir Votos",
"Use Cookies for unregistered users" => "Utilizar cookies para usuários não registrados",
"Users can vote again after" => "Usuários podem votar novamente",
"Anytime" => "A qualquer hora",
"5 minutes" => "Após 5 minutos",
"1 day" => "Após 1 dia",
"1 week" => "Após 1 semana",
"1 month" => "Após 1 mês",
"Items" => "Itens",
"No charts defined yet" => "Nenhum gráfico ainda definido",
"Chat Administration" => "Administração do chat",
"Chat Admin" => "Administrar Chat",
"Chat Admin tpl" => "Administrar chat tpl",
"Create/edit channel" => "Criar/editar canal",
"Refresh rate" => "Taxa de atualização",
"Half a second" => "Meio segundo",
"second" => "segundo",
"Chat channels" => "Canais de chat",
"active" => "ativo",
"Admin templates" => "Administrar padrões",
"admin content templates template" => "administrar conteúdo do modelo dos templates",
"Edit this template:" => "Editar este padrão:",
"Create new template" => "Criar um novo padrão",
"use in cms" => "usar no CMS",
"use in wiki" => "usar no Wiki",
"use in newsletters" => "Usar em comunicados",
"use in events" => "usar em eventos",
"use in HTML pages" => "usar em páginas HTML",
"template" => "padrão",
"Templates" => "Padrões",
"last modif" => "última modificação",
"sections" => "seções",
"Admin cookies" => "Administrar cookies",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Para usar um cookie numa área de texto (página wiki, etc), num <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">módulo</a> ou num template, use {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Criar/editar cookies",
"Upload Cookies from textfile" => "Carregar Cookies a partir de arquivo texto",
"Upload from disk:" => "Carregar do disco:",
"upload" => "carregar",
"Remove all cookies" => "Remover todos cookies",
"Help on Drawings" => "Ajuda nos desenhos",
"admin Drawings tpl" => "administrar desenhos tpl",
"Available drawings" => "Desenhos disponíveis",
"Admin DSN" => "Administrar DSN",
"Create/edit dsn" => "Criar/editar dsn",
"Admin external wikis" => "Administrar Wikis externos",
"admin External Wikis" => "admin Wikis externos",
"tiki admin external wikis template" => "tiki administra templates de wikis externos",
"Create/Edit External Wiki" => "Criar/editar Wiki Externo",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "Endereço (use \$page para substituir pelo nome da página na URl. Exemplo: http://www.exemplo.com.br/tiki-index.php?page=\$page)",
"extwiki" => "wikiext",
"Admin Forums" => "Administrar Fóruns",
"admin forums template" => "administrar template dos fóruns",
"Create new forum" => "Criar novo fórum",
"Edit existing forums" => "Editar fóruns",
"Import forums" => "Importar fóruns",
"Edit this Forum:" => "Editar este Fórum:",
"Create New Forum" => "Criar um Novo Fórum",
"There are individual permissions set for this forum" => "Existem permissões individuais definidas para este fórum",
"Show description" => "Exibir descrição",
"Prevent flooding" => "Prevenir-se contra sobrecarga",
"Minimum time between posts" => "Tempo mínimo entre mensagens",
"Topics per page" => "Assuntos por página",
"Section" => "Seção",
"None" => "Nenhum",
"Create new" => "Criar nova",
"Moderator user" => "Usuário moderador",
"Moderator group" => "Grupo moderador",
"Password protected" => "Protegido por senha",
"Topics only" => "Apenas os assuntos",
"All posts" => "Todas as mensagens",
"Forum password" => "Senha do fórum",
"Default ordering for topics" => "Ordenação padrão para os assuntos",
"Date (desc)" => "Data (desc)",
"Date (asc)" => "Data (asc)",
"Score (desc)" => "Pontuação (desc)",
"Replies (desc)" => "Respostas (desc)",
"Reads (desc)" => "Leituras (desc)",
"Title (desc)" => "Título (desc)",
"Title (asc)" => "Título (asc)",
"Default ordering for threads" => "Ordenação padrão para as seqüências",
"Send this forums posts to this email" => "Enviar as mensagens deste fórum para o seguinte e-mail",
"Prune unreplied messages after" => "Mensagens não respondidas expiram após",
"Prune old messages after" => "Mensagens antigas expiram após",
"Topic list configuration" => "Configuração da lista de assuntos",
"Replies" => "Respostas",
"Posts can be rated" => "Mensagens podem receber notas",
"Display last post titles" => "Mostrar os títulos das últimas postagens",
"no display" => "não mostrar",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Direcionar mensagens deste fórum para este endereço de e-mail, em um formato que possa ser usado para enviar mensagens de volta",
"Send mails even when the post is generated by inbound mail" => "Enviar e-mails mesmo quando a mensagem for gerada por lixo eletrônico",
"Append a reply link to outbound mails" => "Adicione um link para resposta no e-mail enviado",
"Originating e-mail address for mails from this forum" => "Originar endereços de e-mail para mensagens deste fórum",
"Add messages from this email to the forum" => "Adicionar mensagens do seguinte e-mail para este fórum",
"POP3 server" => "Servidor POP3",
"Use topic smileys" => "Usar emoticons nos assuntos",
"Show topic summary" => "Exibir sumário dos assuntos",
"User information display" => "Exibição de informações dos usuários",
"avatar" => "fotografia",
"flag" => "marca",
"online" => "on-line",
"Approval type" => "Tipo de aprovação",
"All posted" => "Todas as mensagens enviadas",
"Queue anonymous posts" => "Enfileirar mensagens anônimas",
"Queue all posts" => "Enfileirar todas as mensagens",
"Attachments" => "Arquivos anexados",
"No attachments" => "Sem arquivos anexados",
"Everybody can attach" => "Todos podem anexar",
"Only users with attach permission" => "Apenas usuários com permissão de anexar",
"Moderators and admin can attach" => "Moderadores e admin podem anexar",
"Store attachments in:" => "Armazenar arquivos anexados em:",
"Database" => "Banco de dados",
"Max attachment size (bytes)" => "Tamanho máximo para arquivo anexado (bytes)",
"Edit Existing Forums" => "Editar fóruns",
"topics" => "assuntos",
"age" => "idade",
"last post" => "última mensagem",
"Assign Permissions (Active)" => "Associar permissões (ativo)",
"Assign Permissions" => "Designar Permissões",
"Click here to delete this forum" => "Clique aqui para remover este fórum",
"Admin Hotwords" => "Administrar Palavras-Chaves",
"admin hotwords" => "administrar palavras-chaves",
"admin hotwords template" => "administar palavras-chave template",
"Add Hotword" => "Adicionar Palavra-chave",
"Word" => "Palavra",
"Add" => "Adicionar",
"admin HTML page dynamic zones" => "administrar páginas HTML com zonas dinâmicas",
"Admin HTML pages" => "Administrar páginas HTML",
"Edit this page" => "Editar esta página",
"View page" => "Ver página",
"Edit zone" => "Editar zona",
"Zone" => "Zona",
"Dynamic zones" => "Zonas dinâmicas",
"zone" => "zona",
"content" => "conteúdo",
"Mass update" => "Atualização em massa",
"admin Html Pages" => "admin páginas Html",
"admin Html Pages template" => "admin template das páginas Html",
"Create new HTML page" => "Criar nova página HTML",
"Edit this HTML page:" => "Editar esta página HTML:",
"Page name" => "Nome da página",
"Dynamic" => "Dinâmica",
"Static" => "Estática",
"Refresh rate (if dynamic) [secs]" => "Taxa de atualização (se dinâmica) [em segundos]",
"Edit Repository:" => "Editar Repositório:",
"Create New Repository" => "Criar Novo Repositório",
"list repositories" => "listar repositórios",
"new repository" => "novo repositório",
"view repository" => "ver repositório",
"Human readable repository name" => "Nome de repositório humanamente legível",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Caminho do repositório (sistema de arquivos local: relativo/absoluto, remoto: prefixado com 'http://')",
"File name of start page" => "Nome do arquivo da página de início",
"Start page" => "Página de início",
"CSS file to load when browse this repository" => "Carregar arquivo CSS quando navegar este repositório",
"CSS file" => "Arquivo CSS",
"Is repository visible to users" => "repositório visível para usuários",
"Can files from repository be cached" => "Arquivos do repositório podem ser armazenados",
"Cacheable" => "Armazenáveis",
"Are files from repository can be cached" => "Arquivos do repositório podem ser armazenados",
"Clear all cached pages of this repository" => "Limpar todas as páginas armazenadas deste repositório",
"Clear cache" => "Limpar cache",
"Seconds count 'till cached page will be expired" => "Segundos não podem ser contados até o armazenamento de páginas expirar",
"Cache expiration" => "Expiração do cache",
"Human readable text description of repository" => "Descrição humanamente legível do repositório",
"Available Repositories" => "Repositórios Disponíveis",
"Start" => "Início",
"CSS File" => "Arquivo CSS",
"Edit rules" => "Edit regras",
"Edit Rules for Repository:" => "Editar Regras para o Repositório:",
"configure repositories" => "configurar repositórios",
"configure this repository" => "configurar este repositório",
"view this repository" => "ver este repositório",
"Add new rule" => "Adicionar nova regra",
"new rule" => "nova regra",
"view/hide copy rules dialog" => "ver/esconder copiar diálogo de regras",
"copy rules" => "copiar regras",
"Source repository" => "Repositório de origem",
"Copy" => "Copiar",
"According this order rules will be applied ('0' or empty = auto)" => "De acordo com esta ordem de regras pode ser aplicada ('0' ou vazio = auto)",
"Rule order" => "Ordenação de regra",
"Text to search for" => "Buscar por texto",
"Text to replace" => "Texto para trocar",
"Replace" => "Trocar",
"Is this regular expression or simple search/replacer" => "É uma expressão regular ou busca simples/alteração",
"Is case sensitive (for simple replacer)" => "É sensível a maiúsculas e minúsculas (para troca simples)",
"Case sensitive" => "Sensível a caixa",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "subconjunto de caracteres: imsxeADSXUu, os quais a expressão regular modifica",
"Regex modifiers" => "Modificadores de Regex",
"Human readable text description of rule" => "Texto humanamente legível de descrição de regra",
"Check to enable this rule" => "Selecione para habilitar esta regra",
"Enabled" => "Habilitado",
"Preview options" => "Pré-visualizar opções",
"Apply all rules or just this to generate preview" => "Aplicar todas as regras ou somente esta para gerar a pré-visualização",
"Apply all rules" => "Aplicar todas as regras",
"View source code after rules applied" => "Ver o código-fonte depois que as regras foram aplicadas",
"Code preview" => "Pré-visualização de código",
"Generate HTML preview" => "Gerar pré-visualização HTML",
"HTML preview" => "Pré-visualização HTML",
"Test file from repository to generate preview for (empty = configured start page)" => "Testar arquivo do repositório para gerar pré-visualização para (vazio = página de início configurada)",
"Preview Results" => "Resultados de Pré-visualização",
"Rules List" => "Lista de Regras",
"Case" => "Caixa",
"Admin layout" => "Administrar layout",
"layout options" => "opções de layout",
"admin featured links" => "administrar links oferecidos",
"admin featured links template" => "admin template dos recursos de link",
"Generate positions by hits" => "Gerar posições por número de acessos",
"List of featured links" => "Lista de links oferecidos",
"url" => "endereço",
"title" => "título",
"position" => "posição",
"Add Featured Link" => "Adicionar Link Oferecido",
"Edit this Featured Link:" => "Editar este Link Oferecido:",
"Create new Featured Link" => "Criar um novo Link Oferecido",
"Position" => "Posição",
"disables the link" => "desabilita este link",
"Link type" => "Tipo de link",
"replace current page" => "substituir a página atual",
"framed" => "em frame",
"open new window" => "abrir em nova janela",
"Mail-in accounts" => "Contas de Mail-in",
"admin mailin template" => "admin template de mailin",
"Account" => "Conta",
"Add new Mail-in account" => "Adicionar nova conta de Mail-in",
"Edit Mail-in account" => "Editar conta de Mail-in",
"Account name" => "Nome da conta",
"POP server" => "Servidor POP",
"Port" => "Porta",
"SMTP server" => "Servidor SMTP",
"SMTP requires authentication" => "Servidor SMTP requer autenticação",
"Article Topic" => "Tópico de artigo",
"Article Type" => "Tipo de artigo",
"Allow anonymous acces" => "Permitir acesso anônimo",
"Allow attachments" => "Permitir anexos",
"Check Mail-in accounts" => "Verificar contas de Mail-in",
"Check automatically" => "Verificar automaticamente",
"Frequency" => "Freqüência",
"List menus" => "Listar menus",
"Edit this menu" => "Editar este menu",
"Edit menu options" => "Editar opções do menu",
"Show Quick Urls" => "Mostrar Quick Urls",
"Hide Quick Urls" => "Esconder Quick Urls",
"Some useful URLs" => "Alguns endereços úteis",
"Permissions" => "permissões",
"option" => "opções",
"section level 0" => "seção (nível 0)",
"section level 1" => "seção (nível 1)",
"section level 2" => "seção (nível 2)",
"section level 3" => "seção (nível 3)",
"sorted section level 0" => "seção ordenada (nível 0)",
"separator" => "separador",
"Choose" => "Escolha",
"Home Page" => "Página Principal",
"Home Image Gal" => "Gal. Imgs Principal",
"Home Image Gallery" => "Galeria de Imagens Principal",
"Home File Gal" => "Gal. Arqs Principal",
"Home File Gallery" => "Galeria de Arquivos Principal",
"User preferences" => "Preferências do usuário",
"User prefs" => "Preferências",
"List image galleries" => "Listar galerias de imagens",
"Upload" => "Carregar",
"Gallery Rankings" => "Rankings de Galerias",
"Browse a gallery" => "Navegar por uma galeria",
"All articles" => "Todos artigos",
"Submit" => "Submeter",
"List Blogs" => "Listar Blogs",
"Create blog" => "Criar blog",
"File galleries" => "Galerias de Arquivos",
"View a forum" => "Exibir um fórum",
"View a thread" => "Exibir uma seqüência",
"View a FAQ" => "Exibir um FAQ",
"Take a quiz" => "Fazer um teste",
"Stats for a Quiz" => "Estatísticas de um teste",
"Preview menu" => "Pré-visualização do menu",
"Menu options" => "Opções de menus",
"Number of lines" => "Número de linhas",
"group" => "grupo",
"Admin Menus" => "Administrar Menus",
"admin menu builder" => "administrar construtor de menus",
"admin menus template" => "admin template dos menus",
"To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "Para usar um menu num <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">módulo</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Identidade do site</a> ou template, use {literal}{menu id=x}{/literal}, onde x é o ID do menu desejado. Para usar <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, você pode escolher uma das três formas abaixo:",
"Edit this Menu:" => "Editar este Menu:",
"Create new Menu" => "Criar um novo Menu",
"dynamic collapsed" => "contraído dinamicamente",
"dynamic extended" => "expandido dinamicamente",
"fixed" => "fixo",
"options" => "opções",
"Admin Modules" => "Administrar Módulos",
"admin modules" => "administrar módulos",
"admin modules template" => "admin templates do módulos",
"assign module" => "atribuir novo módulo",
"left modules" => "módulos da esquerda",
"right modules" => "módulos da direita",
"edit/create" => "editar/criar",
"clear cache" => "limpar o cache",
"User Modules" => "Módulos de Usuário",
"assign" => "atribuir",
"Assign new module" => "Atribuir novo módulo",
"Edit this assigned module:" => "Editar este módulo atribuído:",
"Module Name" => "Nome do Módulo",
"left" => "esquerda",
"right" => "direita",
"Order" => "Ordem",
"Cache Time" => "Tempo de Cache",
"Rows" => "Linhas",
"Parameters" => "Parâmetros",
"Visibility" => "Visibilidade",
"Displayed for the eligible users with no personal assigned modules" => "Mostrado para os usuários elegíveis sem módulos pessoais designados",
"Displayed now for all eligible users even with personal assigned modules" => "Mostrando agora para todos os usuários elegíveis com módulos pessoais designados",
"Displayed now, can't be unassigned" => "Mostrando agora, pode não estar designado",
"Not displayed until a user chooses it" => "Não mostrar até um usuário escolher isto",
"Assigned Modules" => "Módulos Atribuídos",
"Left Modules" => "Módulos da Esquerda",
"order" => "ordem",
"rows" => "linhas",
"parameters" => "parâmetros",
"Right Modules" => "Módulos da Direita",
"Create new user module" => "Criar um novo módulo de usuário",
"Edit this user module:" => "Editar este módulo de usuário:",
"Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Crie o seu próprio módulo abaixo. Antes de <a href=\"#assign\">atribuí-lo</a> veja se tudo está funcionando pré-visualizando o módulo. Usar HTML é seguro. Porém, se você usar de forma errada sintaxe wiki ou código Smarty você pode danificar o funcionamento geral do site.",
"Must be wiki parsed" => "Interpretar código wiki (selecione se usou um código wiki)",
"create/edit" => "criar/editar",
"Objects that can be included" => "Objetos que podem ser incluídos",
"Available polls" => "Enquetes disponíveis",
"Random active poll" => "Enquete ativa aleatórea",
"Random current poll" => "Enquete atual aleatórea",
"use poll" => "usar a enquete",
"Random image from" => "Imagem aleatória a partir de",
"use gallery" => "usar a galeria",
"Dynamic content blocks" => "Blocos de conteúdo dinâmico",
"use dynamic  content" => "usar conteúdo dinâmico",
"use rss module" => "utilizar módulo rss",
"use menu" => "utilizar o menu",
"tree" => "árvore",
"use phplayermenu" => "usar phplayermenu",
"Hint: For the vertical menu to work properly with all browsers, make sure to add <b>overflow=y</b> to the module parameters when you assign it." => "Dica: para o menu vertical funcionar de forma adequada em todos os navegadores, coloque <b>overflow=y</b> nos parâmetros do módulo quando você for atribuí-lo.",
"Banner zones" => "Zonas de Banner",
"use banner zone" => "Utilizar zona de banner",
"structure" => "estrutura",
"Admin newsletter subscriptions" => "Administrar assinaturas de comunicados",
"list newsletters" => "listar comunicados",
"admin newsletters" => "administrar comunicados",
"send newsletters" => "enviar comunicados",
"Add a subscription newsletters" => "Adicionar uma assinatura ao comunicado",
"You can add several email addresses by separating them with commas." => "É possível adicionar vários endereços de e-mail separando eles com vírgula.",
"Add email:" => "Adicionar email:",
"Add user:" => "Adicionar usuário:",
"Group users" => "Grupo de usuários",
"Group subscription also subscribes included groups" => "Inscrição do grupo também inscrive grupos incluídos",
"Don't send confirmation mail" => "Não enviar e-mail de confirmação",
"The user email will be refreshed at each newsletter sending" => "O usuário de e-mail vai ser atualizado a cada newsletter que for enviada",
"Subscribe group" => "Inscrever grupo",
"Subscriptions" => "Assinaturas",
"subscribed" => "inscrita",
"admin newsletters template" => "admin template de newsletters",
"Create/edit newsletters" => "Criar/editar comunicados",
"There are individual permissions set for this newsletter" => "Existem permissões individuais definidos para este comunicado",
"Users can subscribe/unsubscribe to this list" => "Usuários podem inscrever/desinscrever nesta lista",
"Users can subscribe any email address" => "Usuários podem inscrever quaisquer endereços de e-mail",
"Add unsubscribe instructions to each newsletter" => "Adicionar instruções de desinscrição em cada newsletter",
"Validate email addresses" => "Validar endereços de e-mail",
"editions" => "edições",
"last sent" => "última enviada",
"subscriptions" => "assinaturas",
"send newsletter" => "enviar newsletter",
"archives" => "arquivos",
"EMail notifications" => "Notificações por email",
"admin Email Notifications" => "administrar notificações e-mail",
"admin notifications template" => "admin template de notificações",
"Add notification" => "Adicionar notificação",
"Event" => "Evento",
"A user registers" => "Um usuário se registrou",
"A user submits an article" => "Um usuário submeteu um artigo",
"Any wiki page is changed" => "Qualquer página wiki é alterada",
"Any wiki page is changed, even minor changes" => "Qualquer página wiki é alterada, mesmo com pequenas mudanças",
"PHP error" => "Erro de PHP",
"use admin email" => "usar o endereço do admin",
"event" => "evento",
"object" => "objeto",
"No records found." => "Nenhum registro encontrado.",
"Admin Polls" => "Administrar Enquetes",
"List polls" => "Listar enquetes",
"Edit this poll" => "Editar esta enquete",
"Preview poll" => "Pre-visualização da enquete",
"Edit or add poll options" => "Editar ou adicionar opções de enquetes",
"Option" => "Opções",
"Poll options" => "Opções de enquetes",
"votes" => "votos",
"admin polls" => "administrar enquetes",
"admin polls template" => "administrar enquetes template",
"configure polls" => "configurar enquetes",
"Set last poll as current" => "Definir a última enquete como atual",
"Close all polls but last" => "Fechar todas as enquetes menos a última",
"Activate all polls" => "Ativar todas as enquetes",
"Create/edit Polls" => "Criar/editar enquetes",
"PublishDate" => "Data de Publicação",
"Admin Quicktags" => "Admininstrar Quicktags",
"admin QuickTags" => "administrar QuickTags",
"Create/Edit QuickTags" => "Criar/Editar QuickTags",
"label" => "rótulo",
"Insert (use 'text' for figuring the selection)" => "Inserir (usar 'text' para figurar a seleção)",
"Path to the tag icon" => "Caminho para o ícone de tag",
"Insert" => "Inserir",
"Icon" => "Ícone",
"Admin RSS modules" => "Administrar módulos RSS",
"admin RSS modules" => "administrar módulos RSS",
"admin RSSmodules template" => "admin template RSSmodules",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Essa página está configurada com fontes RSS geradas/importadas pelo tiki. Para gerar/exportar fontes RSS, procure por \"RSS feeds\" no painel de administração, ou",
"Content for the feed" => "Conteúdo para a fonte",
"Edit this RSS module:" => "Editar este módulo RSS:",
"Create new RSS module" => "Criar um novo módulo RSS",
"show feed title" => "mostrar campo de título",
"show publish date" => "mostrar data de publicação",
"Rss channels" => "Canais RSS",
"Last update" => "Última atualização",
"show pubdate" => "mostrar data da publicação",
"Score System" => "Sistema de pontuação",
"security admin" => "admin segurança",
"security admin tpl" => "administrar segurança tpl",
"edit tpl" => "editar tpl",
"PHP settings" => "Configurar PHP",
"PHP variable" => "Variáveis do PHP",
"Setting" => "Configurar",
"Risk Factor" => "Fator de risco",
"Explanation" => "Explicação",
"Tikiwiki settings" => "Configurar Tikiwiki",
"Tiki variable" => "Variável Tiki",
"Check all tiki files" => "Checar todos os arquivos tiki",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Nota: isso pode demorar muito tempo. Cheque o item max_execution_time no arquivo php.ini.",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Nota: voc tem que importar os dados das configurações de segurança através do processo de instalção (<a href=\"tiki-install.php\">tiki-install.php</a>). Importe o *secdb* enviado para a sua base de dados.",
"File checks" => "Checar arquivo",
"Filename" => "Nome do arquivo",
"State" => "Estado",
"Admin Shoutbox Words" => "Administrar palavras do quadro negro",
"admin shoutbox words template" => "administrar palavras do quadro negro template",
"Add Banned Word" => "Adicinionar palavras banidas",
"Are you sure you want to delete this word?" => "Você tem certeza que deseja deletar essa palavra?",
"admin structures template" => "administrar estruturas template",
"Structure ID" => "ID de Estrutura",
"export pages" => "exportar páginas",
"dump tree" => "exportar árvore",
"create webhelp" => "criar webhelp",
"view webhelp" => "ver webhelp",
"Destroy the structure leaving the wiki pages" => "Destruir a estrutura mantendo as páginas Wiki",
"Destroy the structure and remove the pages" => "Destruir a estrutura e remover as páginas",
"Create new structure" => "Criar uma nova estrutura",
"Use single spaces to indent structure levels" => "Usar espaços simples para indentar níveis da estrutura",
"Alias" => "Apelido",
"create new structure" => "criar nova estrutura",
"Edit survey questions" => "Editar as perguntas da pesquisa",
"survey stats" => "estatísticas das pesquisas",
"this survey stats" => "estatísticas desta pesquisa",
"edit this survey" => "editar esta pesquisa",
"admin surveys" => "administrar pesquisas",
"Create/edit questions for survey" => "Criar/editar perguntas para a pesquisa",
"Question" => "Pergunta",
"One choice" => "Uma opção",
"Multiple choices" => "Múltipla escolha",
"Short text" => "Texto curto",
"Rate (1..5)" => "Nota (1..5)",
"Rate (1..10)" => "Nota (1..10)",
"Options (if apply)" => "Opções (se for o caso)",
"Questions" => "Perguntas",
"question" => "pergunta",
"administer surveys template" => "administrar pesquisa template",
"list surveys" => "listar pesquisas",
"Edit this Survey:" => "Editar esta Pesquisa:",
"Create New Survey" => "Criar nova pesquisa",
"There are individual permissions set for this survey" => "Existem permissões individuais definidas para esta pesquisa",
"status" => "estado",
"questions" => "perguntas",
"active perms" => "permissões ativas",
"system admin" => "administração do sistema",
"system admin tpl" => "administrar sistema tpl",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Se o Tiki apresentar comportamento estranho, a primeira coisa a fazer é limpar o cache. Além disso, é sempre importante limpar o cache depois de uma atualização (por FTP ou SSH).",
"Empty" => "Esvaziar",
"files" => "arquivos",
"Templates compiler" => "Compilador de modelos",
"Compile" => "Compilar",
"Fix UTF-8 Errors in Tables" => "Consertar erros de codificação UTF-8 nas tabelas",
"Warning: Make a backup of your Database before using this function!" => "Cuidado: faça um backup da sua base de dados antes de utilizar essa função!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Cuidado: se você for converter grandes tabelas, aumente o tempo máximo de execução no php.ini!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Essa função converte linhas codificadas em ISO-8859-1 para UTF-8",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Isso pode ser necessário se você criou conteúdo com o tiki &lt; 1.8.4 e com a codificação padrão do apache definida como ISO-8859-1",
"UTF-8 Errors fixed" => "Erros de codificação UTF-8 corrigidos",
"Table" => "Tabela",
"Field" => "Campo",
"Investigate" => "Investigar",
"Fix it" => "Corrigir",
"Admin Topics" => "Administrar Assuntos",
"admin topics template" => "administrar tópicos template",
"Create a new topic" => "Criar um novo assunto",
"Topic Name" => "Nome do Assunto",
"Upload Image" => "Carregar uma Imagem",
"List of topics" => "Lista de assuntos",
"Active?" => "Ativo?",
"Articles (subs)" => "Artigos (assinaturas)",
"topic image" => "imagem do assunto",
"Remove with articles" => "Remover com artigos",
"Activate" => "Ativar",
"Deactivate" => "Desativar",
"Admin tracker" => "Administrar",
"Edit this tracker" => "Editar",
"View this tracker items" => "Ver itens",
"Edit tracker fields" => "Editar campos",
"Is column visible when listing tracker items?" => "Visível durante listagem de itens do acompanhamento?",
"Column links to edit/view item?" => "Clique na coluna para editar/visualizar o ítem?",
"Column is searchable?" => "Coluna localizável no mecanismo de busca?",
"Field is public? (for use thru trackerlist plugin)" => "Campo público? (para uso no plugin dos acompanhamentos)",
"Field is hidden?" => "Campo oculto?",
"not hidden" => "não oculto",
"visible by admin only" => "visível apenas para o administrador",
"editable by admin only" => "editável apenas para o administrador",
"Field is mandatory?" => "Campo obrigatório?",
"Tracker fields" => "Campos do acompanhamento",
"isMain" => "Clique",
"Tbl vis" => "Tab visiv",
"Searchable" => "Aparece no mecanismo de busca",
"Public" => "Público",
"Hidden" => "Secreto",
"Mandatory" => "Obrigatório",
"Import/export trackers fields" => "Importar/exportar campos dos acompanhamentos",
"Import" => "Importar",
"admin Trackers tpl" => "administrar Acompanhamentos tpl",
"Edit fields for tracker" => "Editar campos para acompanhamento",
"Edit tracker" => "Editar acompanhamento",
"Create trackers" => "Criar acompanhamentos",
"Import/export" => "Importar/exportar",
"created" => "criação",
"items" => "itens",
"active permissions" => "ativar permissões",
"fields" => "campos",
"Create/edit trackers" => "Criar/editar acompanhamentos",
"There are individual permissions set for this tracker" => "Estas são as permissões individuais para este acompanhamento",
"Use \"explicit\" names in the mirror table" => "Usar nomes \"explícitos\" nas tabelas espelho",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "o nome do acompanhamento precisa ser único, assim como o nome dos campos \ne eles precisam ser válidos no SQL",
"Show status" => "Mostrar status",
"Default status displayed in list mode" => "Status padrão aparente no modo de lista",
"Show status to tracker admin only" => "Mostrar status do acompanhamento para o administrador apenas",
"Send copies of all activity in this tracker to this e-mail address" => "Enviar cópias de toda a atividade nesse acompanhamento para esse endereço de e-mail",
"Use simplified e-mail format" => "Usar formato de e-mail simplificado",
"New items are created with status" => "Novos itens são criados com o status",
"Authoritative status for modified items" => "Estado obrigatório para itens modificados",
"No change" => "Nenhuma mudança",
"Item creator can modify his items?" => "O criador pode modificar os seus itens?",
"The tracker needs a user field with the option 1" => "O acompanhamento precisa de um campo para o usuário com a opção 1",
"Member of the default group of creator can modify items?" => "Membro do grupo padrão do criador pode modificar itens?",
"The tracker needs a group field with the option 1" => "O acompanhamento precisa de um campo para o grupo com a opção 1",
"Show creation date when listing tracker items?" => "Exibir data de criação na lista de itens de acompanhamento?",
"Show lastModif date when listing tracker items?" => "Exibir data da última alteração na lista de itens de acompanhamento?",
"What field is used for default sort?" => "Qual campo usado para a listagem por padrão?",
"lastModif" => "ultimaModif",
"What is default sort order in list?" => "Qual a ordem padrão para a listagem?",
"ascending" => "crescente",
"descending" => "decrescente",
"Tracker items allow ratings?" => "Itens dos acompanhamentos podem ter classificação?",
"with values" => "quais valores",
"and display rating results in listing?" => "e mostra o resultado da classificação na listagem?",
"Tracker items allow comments?" => "itens de acompanhamento podem ser comentados?",
"and display comments in listing?" => "e mostra comentários na listagem?",
"Tracker items allow attachments?" => "itens de acompanhamento permitem arquivos anexados?",
"and display attachments in listing?" => "e mostra anexos na listagem?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Opções para mostrar os anexos (Use números para ordenar os itens, 0 não será mostrado e valores negativos para aparecer em popups)",
"filename" => "nome do arquivo",
"filesize" => "tamanho do arquivo",
"version" => "versão",
"filetype" => "tipo do arquivo",
"longdesc" => "descrição longa",
"Do not show empty fields in item view?" => "Não mostrar campos vazios na visualização de um ítem?",
"Import/export trackers" => "Importar/Exportar acompanhamentos",
"Import/Export CSV Data" => "Importar/Exportar dados CSV",
"Import file" => "Importar arquivo",
"admin groups" => "administrar grupos",
"admin groups template" => "administrar template dos grupos",
"Add new group" => "Adicionar novo grupo",
"List" => "Lista",
"Edit group" => "Editar grupos",
"Members" => "Membros",
"Add a new group" => "Adicionar novo grupo",
"List of existing groups" => "Lista de grupos existentes",
"Number of displayed rows" => "Número de linhas exibidas",
"Includes" => "Inclusões",
"assign permissions" => "Associar permissões",
"Include" => "Incluir",
"The group will have all the permissions of the included groups" => "O novo grupo terá todas as permissões do grupo incluído",
"Group Homepage" => "Página principal do grupo",
"Use wiki page name or full URL" => "Usar nome da página wiki ou URL",
"Group Information Tracker" => "Informação do grupo de acompanhamentos",
"choose a group tracker ..." => "escolher um grupo de acompanhamentos ...",
"choose a field ..." => "escolha um campo ...",
"Users Information Tracker" => "Informações dos usuários de acompanhamentos",
"choose a users tracker ..." => "escolher usuários de acompanhamentos ...",
"Group tracker item : {\$groupitemid}" => "Item do grupo de acompanhamento : {\$groupitemid}",
"Edit item" => "Editar ítem",
"Group tracker item not found" => "Item do grupo de acompanhamento não encontrado",
"Create item" => "Criar item",
"Members List" => "Lista de membros",
"remove from group" => "remover do grupo",
"users in group" => "usuários no grupo",
"List all members" => "Listar todos os membros",
"admin users" => "administrar usuários",
"admin users template" => "administrar templates de usuários",
"Add a new user" => "Adicionar um novo usuário",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Atenção: como esse tiki está configurado como servidor secundário do Intertiki, todas as informações que você adicionar manualmente serão sobrescritas pelas informação do site primário, inclusive permissões dos usuários",
"Batch Upload Results" => "Resultado da Carga em Lote",
"Added users" => "Usuários adicionados",
"Rejected users" => "Usuários rejeitados",
"Reason" => "Motivo",
"Edit user" => "Editar usuário",
"Change user preferences" => "Alterar preferências do usuário",
"edit account settings" => "editar configurações da conta",
"Never" => "Nunca",
"Assign Group" => "Designar Grupo",
"edit included group" => "editar grupo incluído",
"Perform action with checked:" => "Ação com o que foi selecionado:",
"remove users and their userpages" => "remover usuários e suas páginas de usuário",
"manage group assignments" => "alterar associações do grupo",
"set default groups" => "definir grupos padrão",
"Assign selected to" => "Associar selecionados para",
"Remove selected from" => "Remover selecionados de",
"the following groups:" => "os seguintes grupos:",
"Tip: hold down CTRL to select multiple" => "Dica: segure a tecla CTRL para selecionar vários",
"Set the default group of the selected users to" => "Definir o grupo padrão dos usuários selecionados para",
"assign to groups" => "associar aos grupos",
"Warning: Are you sure you want to rename the \"admin\" user? It's better to add a new user and to assign this new user to the \"Admins\" group" => "Atenção: você tem certeza que quer renomear o usuário \"admin\"? É melhor adicionar um novo usuário e associá-lo ao grupo \"Admins\"",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Atenção: mudar o nome do usuário irá forçar o usuário a mudar sua senha e poderá confundir sites secundários configurados no Intertiki se houver algum",
"Warning: changing the username will require the user to change his password" => "Alerta: alterar o nome do usuário forçara o mesmo a alterar sua senha",
"Pass" => "Senha",
"Again" => "Confirmar",
"Registration" => "Inscrição",
"Batch upload" => "Carga em lote",
"Overwrite" => "Sobrescrever",
"User tracker item : {\$usersitemid}" => "Item do acompanhamento do usuário : {\$usersitemid}",
"Admin Article Types" => "Administrar Tipos de Artigos",
"Article Types tpl" => "Tipos de artigos tpl",
"Shows up in the drop down list of article types" => "Mostra no drop down uma lista de tipos de artigos",
"Rate" => "Classificação",
"Allow ratings by the author" => "Permitir classificações pelo autor",
"Show before publish date" => "Mostrar antes da data de publicação",
"non-admins can view before the publish date" => "não-administradores podem visualizar antes da data de publicação",
"Show after expire date" => "Mostrar depois da data de expiração",
"non-admins can view after the expire date" => "não-administradores podem visualizar mesmo depois da data final",
"Heading only" => "Somente cabeçalho",
"No article body, heading only" => "Sem corpo de artigo, apenas cabeçalho",
"Allow comments for this type" => "Permitir comentários para esse tipo",
"Comment Can Rate Article" => "Comentário pode classificar artigo",
"Allow comments to include a rating value" => "Permitir que os comentários adicionem valores para a classificação",
"Show image" => "Mostrar imagem",
"Show topic or own image" => "Mostrar tópico ou a própria imagem",
"Show avatar" => "Mostrar fotografia",
"Show author's avatar" => "Mostrar a fotografia do autor",
"Show author" => "Mostrar autor",
"Show author name" => "Mostrar o nome do autor",
"Show publish date" => "Mostrar data de publicação",
"Show expire date" => "Mostrar data de expiração",
"Show reads" => "Mostrar lidas",
"Show the number of times the article was read" => "Mostrar o número de vezes que o artigo foi visualizado",
"Show size" => "Mostrar tamanho",
"Show the size of the article" => "Mostrar o tamanho do artigo",
"Show topline" => "Mostrar linha de cima",
"Show a small title over the title" => "Mostrar um pequeno título embaixo do título",
"Show subtitle" => "Mostrar sub-título",
"Show the subtitle" => "Mostrar o sub-título",
"Show source" => "Mostrar fonte",
"Show link to source after article body" => "Mostrar link para a fonte depois do corpo do artigo",
"Show Image Caption" => "Mostrar descrição da imagem",
"Show a legend under the image" => "Mostrar legenda embaixo da imagem",
"Show Language" => "Mostrar idioma",
"Show the language" => "Mostrar o idioma",
"Creator can edit" => "Criador pode editar",
"The person who submits an article of this type can edit it" => "A pessoa que envia um artigo desse tipo pode edita-lo",
"Delete" => "Apagar",
"Delete this type" => "Deletar esse tipo",
"List of types" => "Lista de tipos",
"Show lang" => "Mostrar idioma",
"Review" => "Resenha",
"Classified" => "Classificado",
"Create a new type" => "Criar um novo tipo",
"Assign permissions to group" => "Definir permissões para o grupo",
"Edit Article" => "Editar Artigo",
"edit article tpl" => "editar artigo tpl",
"Group Information" => "Informações do Grupo",
"advanced feature" => "recurso avançado",
"level configuration" => "configurar os níveis",
"Create level" => "Criar nível",
"all permissions in level" => "todas as permissões no nível",
"all" => "todos",
"level" => "nível",
"inherited from" => "herdado de",
"inherited" => "herdado",
"Assign user" => "Atribuir usuário",
"to groups" => "aos grupos",
"User Information" => "Informações do Usuário",
"Default Group" => "Grupo Padrão",
"Available groups" => "Grupos disponíveis",
"assign perms to this group" => "associar permissões para esse grupo",
"to" => "a",
"backlinks to" => "refere-se a",
"No backlinks to this page" => "Sem referências para esta página",
"admin admin tpl" => "administrar admin tpl",
"List of available backups" => "Lista de backups disponíveis",
"Restoring a backup" => "Restaurando um backup",
"Warning!" => "Atenção!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Restaurar um backup destrói todos os dados no seu banco de dados Tiki. Todas suas tabelas serão sobrescritas com os dados do backup.",
"Click here to confirm restoring" => "Clique aqui para confirmar a restauração",
"Create new backup" => "Criar um novo backup",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "A criação de backups pode levar muito tempo. Se o processo não for concluído, você verá uma tela em branco. Se isto acontecer, você precisa aumentar o tempo máximo de execução de scripts em seu arquivo php.ini",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Sua galeria de imagem está definida para \"{\$gal_use_dir}\", você vai precisar fazer um backup usando FTP ou SCP.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "A sua galeria de arquivos está definida para \"{\$fgal_use_dir}\", você vai precisar fazer um backup usando FTP ou SCP.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Se algum dos seus fóruns possui anexos guardados no diretório você precisa fazer um backup deles usando FTP ou SCP.",
"Upload a backup" => "Carregar um backup",
"Upload backup" => "Carregar backup",
"Directory batch upload" => "Diretório para fazer upload em lote",
"Browse gallery" => "Visualizar galeria",
"Upload from disk" => "Carregar do disco",
"available images" => "imagens disponíveis",
"width" => "largura",
"height" => "altura",
"remove file extension from image name" => "remover a extensão quando mostrar o nome da imagem",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "exemplo: de \"digicam0001.jpg\" será mostrado digicam0001 no campo nome",
"convert sub directories to sub galleries" => "converte sub diretórios em sub galerias",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "exemplo: de \"misc/screenshots/digicam0001.jpg\" uma galeria chamada screenshots será criada",
"use sub directory names as description" => "usar o nome do sub diretório como descrição",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "exemplo: de \"misc/screenshots/digicam0001.jpg\" uma descrição misc/screenshots será criada",
"Select a Gallery" => "Selecionar galeria",
"Process" => "Processo",
"Edit Post" => "Editar Mensagem",
"Use wysiwyg editor" => "Usar editor WYSIWYG",
"Use normal editor" => "Usar editor normal",
"view blog" => "ver o blog",
"list blogs" => "listar os blogs",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Nota: Se você deseja usar imagens, por favor, salve a postagem antes e você\npoderá editar/postar imagens. Use a tag &lt;img&gt; para incluir imagens carregadas na área de texto\nou use a URL da imagem para incluir imagens usando o editor WYSIWYG. ",
"Use ...page... to separate pages in a multi-page post" => "Utilize ...page... para separar as páginas em uma mensagem multi-página",
"Upload image for this post" => "Carregar uma imagem para esta mensagem",
"Trash" => "Lixeira",
"Send trackback pings to:" => "Enviar pings de retorno para:",
"(comma separated list of URIs)" => "(lista de URIs separadas por vírgula)",
"save and exit" => "salvar e sair",
"admin the category system" => "administrar as categorias do sistema",
"admin category" => "administrar categoria",
"Browse in" => "Navegar em",
"Wiki pages" => "Páginas wiki",
"Image galleries" => "Galerias de imagens",
"Trackers Items" => "Itens dos acompanhamentos",
"Sheets" => "Planilhas",
"search category" => "buscar categoria",
"deep" => "profundo",
"Hide subcategories objects" => "Esconder subcategorias dos objetos",
"Show subcategories objects" => "Mostrar subcategorias dos objetos",
"Upper level" => "Nível superior",
"Objects" => "Objetos",
"Browsing Gallery" => "Navegando pela Galeria",
"list galleries" => "listar galerias",
"edit gallery" => "editar galeria",
"rebuild thumbnails" => "Recriar miniaturas",
"upload image" => "carregar uma imagem",
"Directory batch" => "Diretório em lote",
"list gallery" => "listar a galeria",
"All Images" => "Todas as imagens",
"monitor this gallery" => "monitorar essa galeria",
"stop monitoring this gallery" => "parar de monitorar essa galeria",
"Sort Images by" => "Ordenar imagens por",
"subgallery" => "sub galeria",
"Subgallery" => "Sub-galeria",
"hit" => "visita",
"original size" => "tamanho original",
"rotate right" => "girar para a direita",
"rotate" => "girar",
"Browsing Image" => "Visualizando Imagem",
"return to gallery" => "retornar à galeria",
"edit image" => "editar imagem",
"first image" => "primeira imagem",
"smaller" => "menor",
"bigger" => "maior",
"prev image" => "imagem anterior",
"Popup window" => "Janela de popup",
"popup window" => "janela de popup",
"next image" => "próxima imagem",
"slideshow forward" => "avançar slide",
"last image" => "última imagem",
"stop" => "parar",
"Direction" => "Direção",
"Click to zoom" => "Clique para dar zoom",
"Image Name" => "Nome da Imagem",
"Image size" => "Tamanho da imagem",
"imagescale" => "escaladeimagem",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal graus)",
"Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal graus)",
"Move image" => "Mover a imagem",
"You can view this image in your browser using" => "Você pode visualizar esta imagem em seu navegador usando",
"You can include the image in an HTML page using one of these lines" => "Você pode incluir imagens no código HTML usando uma dessas linhas",
"You can include the image in a tiki page using one of these lines" => "Você pode incluir imagens numa página tiki usando uma dessas linhas",
"add item" => "adicionar item",
"Edit/Create" => "Editar/Criar",
"Date Selector" => "Seletor de Data",
"click to navigate" => "clique para navegar",
"Focus:" => "Foco:",
"change focus" => "mudar focochange focus",
"quarter" => "trimestre",
"semester" => "semestre",
"calendar view" => "ver em forma de calendário",
"list view" => "ver em forma de lista",
"End" => "Fim",
"details" => "detalhes",
"Hours" => "Horas",
"Group Calendars" => "Agrupar Calendários",
"Tools Calendars" => "Calendários de Ferramentas",
"Duration" => "Duração",
"Location" => "Local",
"Organized by" => "Ordenado por",
"Participants" => "Participantes",
"Tentative" => "Tentativa",
"Confirmed" => "Confirmada",
"Cancelled" => "Cancelada",
"Subscription List" => "Lista de inscrição",
"Edit Calendar Item" => "Editar o Ítem do Calendário",
"New Calendar Item" => "Novo Item no Calendário",
"or create a new category" => "ou crie uma nova categoria",
"or create a new location" => "ou crie uma novo local",
"comma separated usernames" => "usuários separados por vírgula",
"comma separated username:role" => "usuário:perfil, separados por vírgula",
"with roles" => "com perfis",
"Chair" => "Cadeira",
"Optional" => "Opcional",
"Syntax error" => "Erro de sintaxe",
"Format: mm/dd/yyyy hh:mm<br />..." => "Formato: mm/dd/aaaa hh:mm<br />...",
"See strtotime php function" => "Ver função php strtotime",
"Format: mm/dd/yyy hh:mm<br />..." => "Formato: mm/dd/aaa hh:mm<br />...",
"duplicate" => "duplicar",
"save_to" => "salvar_para",
"close" => "fechar",
"click to view" => "clique para ver",
"Calendar import" => "Importar calendário",
"Calendar has been updated" => "Calendário foi atualizado",
"CSV File" => "Arquivo CSV",
"import" => "importar",
"Assign permissions to category" => "Associar permissões a uma categoria",
"Current permissions for this category" => "Permissões dessa categoria",
"permission" => "permissão",
"remove from this category &amp; all its children" => "remover dessa categoria &amp; todas os seus filhos",
"remove from this category only" => "remover apenas dessa categoria",
"No individual permissions global permissions apply" => "Nenhuma permissão individual, permissões globais em efeito",
"Assign permissions" => "Designar permissões",
"to group" => "ao grupo",
"this category &amp; all its children" => "essa categoria &amp; todos os seus filhos",
"this category only" => "essa categoria apenas",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Associar permissões para <b>todos os filhos</b> é recomendado para uma melhor performance.",
"Change password enforced" => "Alteração obrigatória de senha",
"Old password" => "Senha antiga",
"Again please" => "Confirmar",
"Welcome to the Tiki Chat Rooms" => "Bem-vindo(a) às salas de chat",
"Please select a chat channel" => "Por favor, selecione uma sala ",
"Nickname" => "Apelido",
"enter chat room" => "entrar na sala de chat",
"There are no channels setup, please contact a site admin" => "Não existem canais configurados. Por favor contate um administrador do site",
"Chatroom" => "Sala de chat",
"Browser not supported" => "Navegador não suportado",
"Active Channels" => "Canais ativos",
"Users in this channel" => "Usuários neste canal",
"Channel Information" => "Informações sobre o canal",
"Channel" => "Canal",
"Ratio" => "Taxa",
"Use :nickname:message for private messages" => "Utilize :apelido:mensagem para mensagens particulares",
"Use [URL|description] or [URL] for links" => "Utilize [URL|descrição] ou [URL] para links",
"Use (:smileyname:) for smileys" => "Usar (:emoticons:) for emoticons",
"Create PDF" => "Criar PDF",
"PDF Settings" => "Configurações PDF",
"Font" => "Fonte",
"Textheight" => "Altura do texto",
"Height of top Heading" => "Altura do cabeçalho superior",
"Height of mid Heading" => "Altura do cabeçalho intermediário",
"Height of inner Heading" => "Altura do cabeçalho interno",
"tbheight" => "tbaltura",
"Automatic Page Breaks" => "Quebra de Páginas Automática",
"Select Wiki Pages" => "Selecionar Páginas Wiki",
"add page" => "adicionar página",
"remove page" => "remover página",
"reset" => "reiniciar",
"Send a message to us" => "Escreva-nos",
"Contact us by email" => "Entre em contato por email",
"click here to send us an email" => "clique aqui para nos enviar um e-mail",
"Create WebHelp" => "Criar WebHelp",
"You can browse the generated WebHelp here" => "Você pode navegar o WebHelp gerado aqui",
"Structure" => "Estrutura",
"Top page" => "Página de Topo",
"Tiki Debugger Console" => "Console de Depuração Tiki",
"Close" => "Fechar",
"Current URL" => "Endereço atual",
"Command" => "Comando",
"exec" => "executar",
"Type <code>help</code> to get list of available commands" => "Digite <code>ajuda</code> para obter uma lista de comandos",
"Add a new site" => "Adicionar um novo site",
"You cannot add sites until Directory Categories are setup." => "Você não pode adicionar sites porque o diretório das categorias ainda não foi configurado.",
"Please contact the Site Administrator" => "Por favor entre em contato com o administrador do site",
"Site added" => "Site adicionado",
"The following site was added and validation by admin may be needed before appearing on the lists" => "O site a seguir foi adicionado mas a validação pelo administrador pode ser necessária antes que apareça nas listas",
"Add or edit a site" => "Adicionar ou editar um site",
"Name:" => "Login:",
"Categories:" => "Categorias:",
"Is valid" => "É válido",
"Directory Administration" => "Administrar links",
"admin directory tpl" => "administrar diretório tpl",
"Statistics" => "Estatísticas",
"There are" => "Existem",
"invalid sites" => "sites inválidos",
"valid sites" => "sites válidos",
"Users have visited" => "Usuários visitaram",
"sites from the directory" => "sites do diretório",
"Users have searched" => "Usuários buscaram",
"times from the directory" => "vezes a partir do diretório",
"Admin sites" => "Administrar sites",
"Admin category relationships" => "Administrar relacionamentos de categorias",
"Validate links" => "Validar links",
"Settings" => "Configurações",
"browse" => "navegar",
"related" => "relacionados",
"validate" => "validar",
"Admin directory categories" => "Administrar categorias de diretório",
"admin directory categories tpl" => "administrar categorias de diretório tpl",
"Parent category" => "Categoria-Pai",
"Add a directory category" => "Adicionar uma nova categoria",
"Edit this directory category" => "Editar esta categoria",
"Children type" => "Tipos de filhos",
"Most visited sub-categories" => "Sub-categorias mais visitadas",
"Category description" => "Descrição da categoria",
"Random sub-categories" => "Sub-categorias aleatórias",
"Maximum number of children to show" => "Número máximo de filhos a exibir",
"Allow sites in this category" => "Permitir sites nesta categoria",
"Show number of sites in this category" => "Exibir número de sites nesta categoria",
"Editor group" => "Grupo do editor",
"Subcategories" => "Sub-categorias",
"cType" => "Tipo",
"allow" => "permitir",
"count" => "contagem",
"relate" => "relacionadas",
"Admin related categories" => "Administrar categorias relacionadas",
"Admin Directory Related " => "Administrar Diretórios Relacionados ",
"Add a related category" => "Adicionar uma categoria relacionada",
"Mutual" => "Mútuo",
"Related categories" => "Categorias relacionadas",
"Admin Directory Sites" => "Administrar Sites do Diretório",
"Admin Directory Sites tpl" => "Administrar diretório dos sites tpl",
"Delete selected" => "Deletar selecionado(s)",
"country" => "país",
"new sites" => "novos sites",
"cool sites" => "sites legais",
"add a site" => "adicionar um site",
"add a category" => "adicionar categoria",
"any" => "qualquer",
"in entire directory" => "em todas as categorias",
"in current category" => "na categoria atual",
"search" => "buscar",
"Sort by" => "Ordenar por",
"name (desc)" => "nome (desc)",
"name (asc)" => "nome (asc)",
"hits (desc)" => "visitas (desc)",
"hits (asc)" => "visitas (asc)",
"creation date (desc)" => "data de criação (desc)",
"creation date (asc)" => "data de criação (asc)",
"last updated (desc)" => "última atualização em (desc)",
"last updated (asc)" => "última atualização em (asc)",
"sort" => "ordenar",
"Added" => "Adicionado em",
"Last updated" => "Última atualização em",
"Total categories" => "Total de categorias",
"Total links" => "Total de links",
"Links to validate" => "Links a validar",
"Searches performed" => "Buscas realizadas",
"Total links visited" => "Links visitados totais",
"Directory ranking" => "Ranking de links",
"Search results" => "Resultados da busca",
"Validate sites" => "Sites validados",
"Validate Sites" => "Validar Sites",
"directory validate sites tpl" => "diretório para validar sites tpl",
"list articles" => "listar artigos",
"view articles" => "ver artigos",
"Topline" => "Topo",
"Subtitle" => "Sub-título",
"Source" => "Fonte",
"Author Name" => "Nome do Autor",
"Own Image" => "Imagem própria",
"Use own image" => "Usar imagem própria",
"Float text around image" => "Texto flutuante ao redor da imagem",
"Own image size x" => "Largura da imagem própria",
"Own image size y" => "Altura da imagem própria",
"Image caption" => "Legenda",
"Heading" => "Cabeçalho",
"Body" => "Corpo",
"Use ...page... to separate pages in a multi-page article" => "Utilize ...page... para separar páginas em artigos multi-páginas",
"Expiration Date" => "Data de Expiração",
"Edit or create banners" => "Editar ou criar banners",
"List banners" => "Listar banners",
"URL to link the banner" => "Endereço para ligar ao banner",
"Client" => "Cliente",
"Max impressions" => "Impressões (máx)",
"create zone" => "criar zona",
"Show the banner only between these dates" => "Exibir o banner apenas entre estas datas",
"From date" => "Do dia",
"To date" => "Ao dia",
"Use dates" => "Utilizar datas",
"Show the banner only in this hours" => "Exibir o banner apenas entre estas horas",
"Show the banner only on" => "Exibir o banner apenas às",
"Mon" => "Seg",
"Tue" => "Ter",
"Wed" => "Qua",
"Thu" => "Qui",
"Fri" => "Sex",
"Sat" => "Sáb",
"Sun" => "Dom",
"Select ONE method for the banner" => "Selecione UM método para o banner",
"Use HTML" => "Usar HTML",
"HTML code" => "Código HTML",
"Use image" => "Usar a imagem",
"Image:" => "Imagem:",
"Current Image" => "Imagem atual",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Usar a imagem gerada pelo endereço (a imagem será requisitada no endereço para cada impressão)",
"Use text" => "Utilizar texto",
"Text" => "Texto",
"save the banner" => "salvar o banner",
"Remove Zones (you lose entered info for the banner)" => "Remover Zonas (informações editadas para o banner serão perdidas)",
"Edit Blog" => "Editar Blog",
"Create Blog" => "Criar Blog",
"Editing and Creating Blogs" => "Editando e criando blogs",
"edit blog tpl" => "editar blog tpl",
"Current heading" => "Cabeçalho atual",
"There are individual permissions set for this blog" => "Existem permissões individuais definidas para este blog",
"Number of posts to show" => "Número de mensagens a exibir",
"Allow other user to post in this blog" => "Permitir a outros usuários escrever neste blog",
"Use titles in blog posts" => "Utilizar títulos nas mensagens do blog",
"Allow search" => "Permitir busca",
"Allow comments" => "Permitir comentários",
"Show user avatar" => "Mostrar fotografia dos usuários",
"Blog heading" => "Cabeçalho do Blog",
"Edit Style Sheet" => "Editar Style Sheet",
"Style Sheet" => "Folha de Estilo",
"Cancel" => "Cancelar",
"choose a stylesheet" => "escolher um style sheet",
"try" => "experimentar",
"display" => "exibir",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Arquivos com nomes terminados em -{\$user} são modificáveis, os demais são apenas duplicáveis e podem ser utilizados como modelos.",
"Show Plugins Help" => "Exibir Auxílio para Plugins",
"For more information, please see <a href=\"{\$helpurl}Wiki+Syntax\">Wiki Syntax</a>" => "Para mais informações, veja <a href=\"{\$helpurl}Wiki+Syntax\">Sintaxe Wiki</a> (em inglês)",
"Bold text" => "Texto em negrito",
"underscores" => "sublinhados",
"Italic text" => "Texto em itálico",
"single quotes" => "aspas simples",
"Centered text" => "Texto centralizado",
"colons" => "dois pontos",
"some text" => "algum texto",
"Underlined text" => "Texto sublinhado",
"equals" => "igual",
"Text box" => "Caixa de texto",
"One carat" => "Um acento circunflexo",
"Creates a box with the data" => "Cria uma caixa com os dados",
"Box content" => "Conteúdo da caixa",
"Title bar" => "Barra de título",
"creates a title bar" => "Cria uma barra de título",
"Colored text" => "Texto colorido",
"Will display using the indicated HTML color or color name" => "Mostra o texto usando o código HTML ou nome da cor especificado",
"Lists" => "Listas",
"for bullet lists" => "para listas de itens",
"for numbered lists" => "para listas numeradas",
"for definiton lists" => "para listas de definições",
"Headings" => "Cabeçalhos",
"make headings" => "cria cabeçalhos",
"Show/Hide" => "Mostrar/esconder",
"show/hide heading section. + (shown) or - (hidden) by default" => "mostrar/esconder sessão do cabeçalho. + (mostra) or - (esconde) por padrão",
"Wiki References" => "Referências Wiki",
"JoinCapitalizedWords or use" => "UnirPalavrasComMaiusculas ou use",
"page|desc" => "página|desc",
"for wiki references" => "para referências Wiki",
"SomeName" => "AlgumNome",
"prevents referencing" => "prevenir referência",
"External links" => "Links externos",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "use colchetes para links externos: [URL] ou [URL|link_description] or [URL|description|nocache]  (essa última forma impede que o wiki coloque essa página no cache; use essa função para páginas grandes!)!).",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Para um Wiki externo, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
"Tables" => "Tabelas",
"row" => "linha",
"col" => "coluna",
"creates a table" => "cria uma tabela",
"displays an image" => "exibe uma imagem",
"height width desc link and align are optional" => "height, width, desc, link e align são opcionais",
"Non cacheable images" => "Imagens não armazenáveis em cache",
"Line break" => "Quebra de linha",
"(very useful especially in tables)" => "(muito útil especialmente em tabelas)",
"Horizontal rule" => "Linha horizontal",
"makes a horizontal rule" => "criar uma linha horizontal",
"creates the editable drawing foo" => "cria o desenho editável foo",
"Multi-page pages" => "Páginas multi-página",
"to separate pages" => "para separar páginas",
"Wiki File Attachments" => "Anexos do arquivo wiki",
"RSS feeds" => "Fontes RSS",
"displays rss feed with id=n maximum=m items" => "exibe fonte rss com itens id=n maximum=m",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Será substituído pelo valor real do bloco de conteúdo dinâmico com id=n",
"Dynamic variables" => "Variáveis dinâmicas",
"Inserts an editable variable" => "Inserir uma váriavel editável",
"Non parsed sections" => "Seções não interpretadas",
"Prevents wiki parsing of the enclosed data." => "O conteúdo entre as tags não é interpretado como código wiki.",
"Preformated sections" => "Seções pré-formatadas",
"Square Brackets" => "Colchetes",
"Use [[foo] to show [foo]." => "Usa [[foo] para mostrar [foo].",
"Block Preformatting" => "Pré-formatar bloca",
"Table of contents" => "Tabela de conteúdo",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" mostrar uma tabela de conteúdo para a página atual baseada em estruturas (toc) ou ! cabeçalhos (maketoc)",
"Show Text Formatting Rules" => "Exibir Regras de Formatação de Texto",
"No description available" => "Descrição não disponível",
"Quicktags" => "Tags rápidos",
"bold" => "negrito",
"italic" => "itálico",
"underline" => "sublinhado",
"table" => "tabela",
"table new" => "nova tabela",
"external link" => "link externo",
"wiki link'" => "link wiki'",
"heading1" => "cabeçalho1",
"title bar" => "barra de título",
"box" => "caixa",
"rss feed" => "fonte rss",
"dynamic content" => "conteúdo dinâmico",
"center text" => "centralizar texto",
"colored text" => "texto colorido",
"dynamic variable" => "variável dinâmica",
"New wms Metadata" => "Nova metadata wms",
"New Class" => "Nova classe",
"New Projection" => "Nova projeção",
"New Query" => "Nova consulta",
"New Scalebar" => "Nova barra de escala",
"New Layer" => "Nova camada",
"New Label" => "Novo rótulo",
"New Reference" => "Nova referência",
"New Legend" => "Nova legenda",
"New Web" => "Nova web",
"New Outputformat" => "Novo formato de saída",
"New Mapfile" => "Novo arquivo de mapa",
"special chars" => "carac especiais",
"special characters" => "caracteres especiais",
"admin quicktags" => "administrar tags rápidos",
"Edit Image" => "Editar Imagem",
"browse image" => "alterar imagem",
"Edit successful!" => "Edição bem-sucedida!",
"The following image was successfully edited" => "A seguinte imagem foi editada com sucesso",
"Image Description" => "Descrição da Imagem",
"Edit and create Languages" => "Editar e criar Línguas",
"Im- Export Languages" => "Importar/Exportar Línguas",
"Edit and create languages" => "Editar e criar línguas",
"Create Language" => "Criar Língua",
"Shortname" => "Nome Abreviado",
"like" => "como",
"Longname" => "Nome Completo",
"Select the language to edit" => "Selecione uma língua a editar",
"Add a translation" => "Adicionar uma tradução",
"Edit translations" => "Editar traduções",
"Translate recorded" => "Tradução registrada",
"Translation" => "Tradução",
"translate" => "traduzir",
"reset table" => "reinicializar",
"Program dynamic content for block" => "Programar conteúdo dinâmico para o bloco",
"create new block" => "criar um novo bloco",
"Return to block listing" => "Retornar à listagem de blocos",
"Block description: " => "Descrição do bloco: ",
"Create or edit content" => "Criar ou editar conteúdo",
"You are editing block:" => "Você está editando o bloco:",
"Publishing date" => "Data de publicação",
"Publishing Date" => "Data de Publicação",
"Edit question options" => "Editar opções da pergunta",
"list quizzes" => "listar testes",
"quiz stats" => "estats. teste",
"this quiz stats" => "estatísticas deste teste",
"edit this quiz" => "editar este teste",
"admin quizzes" => "administrar testes",
"Create/edit options for question" => "Criar/editar opções para a pergunta",
"points" => "pontos",
"Admin quizzes" => "Administrar testes",
"admin quizzes tpl" => "administrar quiz tpl",
"Create/edit quizzes" => "Criar/editar testes",
"There are individual permissions set for this quiz" => "Existem permissões individuais para este teste",
"Quiz can be repeated" => "Teste pode ser repetido",
"Store quiz results" => "Armazenar resultados do teste",
"Immediate feedback" => "Retorno imediato",
"Show correct answers" => "Mostrar respostas corretas",
"Shuffle questions" => "Embaralhar questões",
"Shuffle answers" => "Embaralhar respostas",
"Questions per page" => "Perguntas por página",
"Quiz is time limited" => "Tempo-limite para o teste",
"Maximum time" => "Tempo máximo",
"Passing Percentage" => "Percentual decorrido",
"canRepeat" => "podeRepetir",
"timeLimit" => "tempoLimite",
"results" => "resultados",
"Edit quiz questions" => "Editar perguntas do teste",
"edit quiz questions" => "editar questões do quiz",
"edit quiz questions tpl" => "editar questões do quiz tpl",
"Create/edit questions for quiz" => "Criar/editar perguntas do teste",
"Question Type" => "Tipo das questões",
"Import questions from text" => "Importar questões do texto",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instruções: digite, ou cole, as suas questões de múltipla escolha aqui, então defina a resposta correta na linha subsequente.  Separe questões adicionais com uma linha branca.  Indique as respostas corretas começando com \"*\" (sem as aspas).",
"Input" => "Entrada",
"maxScore" => "notaMaxima",
"From Points" => "Pontos Mínimos",
"To Points" => "Pontos Máximos",
"Answer" => "Resposta",
"Results" => "Resultados",
"answer" => "resposta",
"Modify Structure" => "Modificar Estrutura",
"You will remove" => "Você irá remover",
"and its subpages from the structure, now you have two options:" => "e suas sub-páginas da estrutura, existem duas opções:",
"Remove only from structure" => "Remover apenas da estrutura",
"Remove from structure and remove page too" => "Remover da estrutura e remover também a página",
"Current Node" => "Nó Atual",
"Page alias" => "Apelido da Página",
"Promote" => "Promover",
"Previous" => "Anterior",
"Demote" => "Demover",
"Add pages to current node" => "Adicionar páginas ao nó atual",
"After page" => "Após a página",
"create page" => "criar página",
"Use pre-existing page" => "Utilizar uma página pré-existente",
"Structure Layout" => "Estrutura de Layout",
"Help on Articles" => "Ajuda com os artigos",
"edit submissions tpl" => "editar artigos enviados tpl",
"list submissions" => "listar submissões",
"<b>*</b>=optional" => "<b>*</b>=opcional",
"<b>Topline</b>=small line above Title" => "<b>Linha de cima</b>=pequena linha em cima do título",
"<b>Subtitle</b>=small line below Title" => "<b>Subtítulo</b>=pequena linha embaixo do título",
"<b>Source</b>=URL to article source" => "<b>Fonte</b>=indica a fonte do artigo",
"EditTemplates" => "EditarPadroes",
"EditTemplates tpl" => "Editar templates tpl",
"Template listing" => "Listagem de padrões",
"Available templates" => "Padrões disponíveis",
"Template" => "Padrão",
"save only in the theme:" => "salvar apenas no tema:",
"Delete the copy in the theme:" => "Deletar a cópia no tema:",
"Edit a topic" => "Editar um tópico",
"Edit Translation:" => "Editar tradução:",
"edit translations" => "editar traduções",
"edit translations template" => "editar traduções template",
"View" => "Ver",
"You must specify the object language" => "Você precisa especificar o objeto do idioma",
"The object doesn't exist" => "O objeto não existe",
"The object doesn't have a language" => "O objeto não possui um idioma",
"The object has already a translation for this language" => "O objeto já tem uma tradução para esse idioma",
"The object is already in the set of translations" => "O objeto já está selecionado para traduções",
"Use this section to set the language of the version you are currently working on." => "Use essa sessão para definir o idioma da versão que você está trabalhando atualmente.",
"Set of Translations" => "Espaço das traduções",
"detach" => "desanexar",
"Select the article for which the current article is the translation." => "Selecione o artigo para o qual o artigo atual é a tradução.",
"Translation of:" => "Tradução de:",
"Enter the name of the page for which the current page is the translation." => "Coloque o nome para o qual a página atual é a tradução.",
"add to the set" => "adicionar ao espaço de traduções",
"Use rating" => "Usar classificação",
"disable" => "desabilitar",
"There is no available poll template." => "Não existe um modelo de enquete disponível.",
"You should ask an admin to create them." => "Você deve pedir para o administrador cria-los.",
"or use" => "ou use",
"an existing poll" => "uma enquete existente",
"This edit session will expire in {\$edittimeout} minutes. <strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "Essa sessão de edição irá expirar em {\$edittimeout} minutos. <strong>Pré-visualize</strong> ou <strong>salve</strong> seu trabalho para reiniciar o contador de tempo da sessão e não perder seu trabalho.",
"replace" => "substituir",
"Try to convert HTML to wiki" => "Tentar converter HTML para wiki",
"Admin ephemerides" => "Administrar curiosidades",
"All ephemerides" => "Todas curiosidades",
"Browse" => "Navegar",
"Admin FAQ" => "Administrar FAQ",
"View FAQ" => "Visualizar FAQ",
"Edit this FAQ" => "Editar este FAQ",
"new question" => "nova pergunta",
"Edit FAQ questions" => "Editar perguntas do FAQ",
"Use a question from another FAQ" => "Utilizar uma pergunta de outro FAQ",
"FAQ questions" => "Perguntas do FAQ",
"Suggested questions" => "Perguntas sugeridas",
"approve" => "aprovar",
"No suggested questions" => "Sem perguntas sugeridas",
"File Galleries tpl" => "Galeria de arquivos tpl",
"configure listing" => "configurar a listagem",
"Create a file gallery" => "Criar uma galeria de arquivos",
"Edit this file gallery:" => "Editar esta galeria de arquivos:",
"create new gallery" => "criar uma nova galeria",
"There are individual permissions set for this file gallery" => "Existem permissões individuais definidas para esta galeria de arquivos",
"Gallery is visible to non-admin users?" => "Galeria visível para usuários não administradores?",
"Listing configuration" => "Configuração de listagem",
"icon" => "ícone",
"Name-filename" => "Nome-nome de arquivo",
"Filename only" => "Apenas nome de arquivo",
"Max description display size" => "Tamanho máximo para descrição",
"Max Rows per page" => "Máximo de linhas por página",
"Other users can upload files to this gallery" => "Outros usuários podem carregar arquivos nesta galeria",
"You can access the file gallery using the following URL" => "Você pode acessar a galeria de arquivos pelo seguinte endereço",
"Available File Galleries" => "Galerias de Arquivos Disponíveis",
"Message queue for" => "Mensagem na fila para",
"back to forum" => "retornar ao fórum",
"Edit queued message" => "Editar mensagem na fila",
"topic" => "assunto",
"make this a thread of" => "transformar em uma seqüência de",
"None, this is a thread message" => "Nenhuma, esta é uma mensagem de uma seqüência",
"summary" => "sumário",
"announce" => "anúncio",
"hot" => "quente",
"sticky" => "persistente",
"no feeling" => "insensível",
"frown" => "muxoxo",
"exclaim" => "exclamação",
"idea" => "idéia",
"mad" => "furioso",
"neutral" => "neutro",
"sad" => "triste",
"happy" => "feliz",
"wink" => "piscadela",
"save and approve" => "salvar e aprovar",
"convert to topic" => "converter em um assunto",
"List of messages" => "Lista de mensagens",
"new topic" => "novo assunto",
"no summary" => "sem sumário",
"No messages queued yet" => "Nenhuma mensagem na fila",
"reject" => "rejeitar",
"configure forum" => "configurar fórum",
"Reported messages for" => "Mensagens enviadas para",
"Reported by" => "Enviada por",
"friends tpl" => "amigos tpl",
"Pending requests" => "Solicitações pendentes",
"Request Time" => "Solicitar tempo",
"accept" => "aceitar",
"refuse" => "recusar",
"Waiting requests" => "Esperando solicitações",
"Your friends" => "Seus amigos",
"Real Name" => "Nome completo",
"break friendship" => "romper amizade",
"Activity completed" => "Atividade completada",
"Admin process activities" => "Administrar atividades do processo",
"Add or edit an activity" => "Adicionar ou editar uma atividade",
"start" => "início",
"end" => "fim",
"activity" => "atividade",
"split" => "dividir",
"join" => "unir",
"standalone" => "independente",
"interactive" => "interativa",
"auto routed" => "roteado automaticamente",
"Expiration Time" => "Data de expiração",
"Years" => "Anos",
"Months" => "Meses",
"Days" => "Dias",
"Minutes" => "Minutos",
"Add transitions" => "Adicionar transições",
"Add transition from:" => "Adicionar uma transição de:",
"Add transition to:" => "Adicionar uma transição para:",
"roles" => "perfis",
"No roles associated to this activity" => "Não há um perfil associado a esta atividade",
"Add role" => "Adicionar perfil",
"add new" => "adicionar novo",
"Process activities" => "Atividades do processo",
"Routing" => "Roteamento",
"Interactive" => "Interativo",
"Automatic" => "Automático",
"Auto routed" => "Roteado automaticamente",
"route" => "rota",
"(no roles)" => "(sem perfil)",
"No activities defined yet" => "Nenhuma atividade definida ainda",
"Process Transitions" => "Transições do Processo",
"List of transitions" => "Lista de transições",
"From:" => "De:",
"Origin" => "Origem",
"No transitions defined yet" => "Nenhuma transição definida ainda",
"Add a transition" => "Adicionar uma transição",
"This process is invalid" => "Este processo é inválido",
"List of processes" => "Lista de processos",
"Inactive" => "Inativo",
"act" => "atv",
"active process" => "processo ativo",
"invalid" => "inválido",
"invalid process" => "processo inválido",
"valid process" => "processo válido",
"activities" => "atividades",
"graph" => "gráfico",
"new minor" => "novo secundário",
"new major" => "novo principal",
"No processes defined yet" => "Nenhum processo definido ainda",
"Admin instance" => "Administrar instância",
"Process:" => "Processo:",
"Instance" => "Instância",
"Workitems" => "Itens de trabalho",
"exception" => "exceção",
"completed" => "completado",
"aborted" => "abortado",
"Owner" => "Dono",
"Send all to" => "Enviar todos para",
"Don't move" => "Não mover",
"Activities" => "Atividades",
"Started" => "Iniciado",
"Act status" => "Estado da Atvd",
"Ended" => "Terminou",
"Not Defined" => "Não definido",
"Not Interactive" => "Não interativo",
"Not Ended" => "Não terminado",
"Properties" => "Propriedades",
"Property" => "Propriedade",
"Value" => "Valor",
"Add property" => "Adicionar propriedade",
"value" => "valor",
"run instance" => "executar instância",
"Executed" => "Executado",
"erase" => "apagar",
"Galaxia Admin Processes" => "Administrar Processos do Galaxia",
"Add or edit a process" => "Adicionar ou editar um processo",
"Process Name" => "Nome do Processo",
"is active?" => "Ativo?",
"Or upload a process using this form" => "Ou carregue um processo usando este formulário",
"Admin process roles" => "Administrar perfis de processo",
"Add or edit a role" => "Adicionar ou editar um perfil",
"Process roles" => "Perfis de processo",
"No roles defined yet" => "Nenhum perfil definido ainda",
"Map users to roles" => "Associar usuários a perfis",
"Map" => "Associar",
"Roles" => "Perfis",
"map" => "associar",
"Map groups to roles" => "Associar grupos a perfis",
"Operation" => "Operação",
"Warning" => "Aviso",
"No roles are defined yet so no roles can be mapped" => "Nenhuma regra definida, associação impossível",
"List of mappings" => "Lista de associações",
"No mappings defined yet" => "Nenhuma associação definida ainda",
"Admin process sources" => "Administrar fontes de processo",
"select source" => "selecionar a fonte",
"Shared code" => "Código compartilhado",
"Set next user" => "Definir próximo usuário",
"Get property" => "Obter propriedade",
"Set property" => "Definir propriedade",
"Complete" => "Completo",
"Process form" => "Formulário de processamento",
"Set Next act" => "Definir próxima ação",
"Switch construct" => "Alternar diagrama",
"Map process roles" => "Associar perfis do processo",
"admin processes" => "administrar processos",
"admin activities" => "administrar atividades",
"admin roles" => "administrar perfis",
"edit this process" => "editar este processo",
"Galaxia Monitor Activities" => "Monitoramento de Atividades do Galaxia",
"List of activities" => "Lista de atividades",
"routing" => "roteamento",
"Instances" => "Instâncias",
"run" => "executar",
"run activity" => "executar atividade",
"Enter the name of this instance" => "Coloque o nome dessa instância",
"The name is not valid. Please, enter the name again" => "O nome não é válido. Por favor, tente novamente",
"monitor" => "monitorar",
"monitor processes" => "monitorar processos",
"monitor activities" => "monitorar atividades",
"monitor instances" => "monitorar instâncias",
"monitor workitems" => "monitorar itens de trabalho",
"Galaxia Monitor Instances" => "Monitoramento de Instâncias do Galaxia",
"List of instances" => "Lista de instâncias",
"Not ended" => "Não terminado",
"No instances created yet" => "Nenhuma instância criada ainda",
"Galaxia Monitor Processes" => "Monitoramento de Processos do Galaxia",
"Valid" => "Válido",
"Invalid" => "Inválido",
"processes" => "processos",
"being run" => "sendo executados",
"exceptions" => "exceções",
"Monitor workitems" => "Monitorar itens de trabalho",
"List of workitems" => "Lista de itens de trabalho",
"instance" => "instância",
"My activities" => "Minhas atividades",
"Current Activity" => "Atividades atuais",
"Assigned To" => "Associado a",
"exception instance" => "instância-exceção",
"exceptions instance" => "instância-exceções",
"send instance" => "enviar instância",
"abort instance" => "abortar instância",
"grab instance" => "obter instância",
"release instance" => "liberar instância",
"No activities found" => "Nenhuma atividade encontrada",
"My instances" => "Minhas instâncias",
"No instances found" => "Nenhuma instância encontrada",
"activate" => "ativar",
"User Activities" => "Atividades de Usuário",
"Galaxia User Activities" => "Atividades de Usuário do Galaxia",
"process" => "processo",
"user processes" => "processos de usuários",
"user activities" => "atividades de usuários",
"user instances" => "instâncias de usuários",
"Galaxia User Instances" => "Instâncias de Usuários do Galaxia",
"Inst Status" => "Estado da inst",
"Not defined" => "Não definido",
"No instances defined yet" => "Nenhuma instância definida ainda",
"Galaxia User Processes" => "Processos de Usuário do Galaxia",
"Browsing Workitem" => "Visualizando Ítem de Trabalho",
"Workitem information" => "Informação do ítem de trabalho",
"rebuild cache" => "reconstruir cache",
"Create a gallery" => "Criar uma galeria",
"Edit this gallery:" => "Editar esta galeria:",
"There are individual permissions set for this gallery" => "Existem permissões individuais definidas para esta galeria",
"Geographic" => "Geografia",
"Images per row" => "Imagens por linha",
"Thumbnails size X" => "Largura das miniaturas",
"Thumbnails size Y" => "Altura das miniaturas",
"Default sort order" => "Ordem de listagem padrão",
"Fields to show during browsing the gallery" => "Campos que devem aparecer na navegação da galeria",
"Image ID" => "ID da Imagem",
"Creation Date" => "Data de criação",
"XY-Size" => "XY-tamanho",
"Filesize" => "Tamanho",
"Gallery Image" => "Galeria de imagens",
"Parent gallery" => "Galeria pai",
"Available scales" => "Escalas disponíveis",
"default scale" => "escalar padrão",
"No scales available" => "Nenhuma escala disponível",
"Original image is default scale" => "A imagem original é a escala padrão",
"Add scaled images with bounding box of square size" => "Adicionar escala para imagem",
"Owner of the gallery" => "Dono da galeria",
"Other users can upload images to this gallery" => "Outros usuários podem carregar imagens nesta galeria",
"You can access the gallery using the following URL" => "Você pode acessar esta galeria pelo seguinte endereço",
"Available Galleries" => "Galerias Disponíveis",
"Choose a filter" => "Escolher filtro",
"Imgs" => "Imagens",
"Make Map" => "Fazer mapa",
"Select Graphic Type" => "Selecionar tipo gráfico",
"Multiline" => "Multi-linha",
"Landscape" => "Paisagem",
"Portrait" => "Retrato",
"Independant Scale" => "Escala independente",
"Horizontal Scale" => "Escala horizontal",
"Bottom" => "Fundo",
"Vertical Scale" => "Escalar vertical",
"Left" => "Esquerda",
"Right" => "Direita",
"Series" => "Séries",
"Im- Export languages" => "Importar/exportar línguas",
"Select the language to Import" => "Selecione a língua para importar",
"Select the language to Export" => "Selecione a língua para exportar",
"Import From File" => "Importar do arquivo",
"Grab Wiki Tables" => "Obter tabelas wiki",
"Import pages from a Structured Text Dump" => "Importar páginas de uma exportação em texto estruturada",
"Name of the dump file (it has to be in dump/)" => "Nome do arquivo de exportação (precisa estar no diretório dump/)",
"Overwrite existing pages if the name is the same" => "Sobrescrever páginas com mesmo nome",
"Previously remove existing page versions" => "Remover versões previamente existentes da página",
"excerpt" => "trecho",
"result" => "resultado",
"body" => "corpo",
"reload" => "recarregar",
"Tiki cannot find a database connection" => "Tiki não conseguiu conectar à base de dados",
"Please enter your database connection info" => "Coloque as informações da conexão com a base de dados",
"Database type" => "Tipo da base de dados",
"The type of database you intend to use" => "O tipo de base de dados que você pretende usar",
"Host:" => "Servidor:",
"Database user" => "Usuário da base de dados",
"Database password" => "Senha da base de dados",
"Database name" => "Nome da base de dados",
"The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "O nome da base de dados onde o Tiki criará as tabelas. Você pode criar a base de dados usando mysqladmin ou PHPMyAdmin, ou ainda pedir para o responsável pelo seu servidor criar. Normalmente as tabelas do Tiki não conflitam com tabelas de outros softwares na mesma base de dados.",
"Welcome to the installation &amp; upgrade script!" => "Bem-vindo ao script de atualização da instalação!",
"Install" => "instalar",
"Upgrade" => "Atualização",
"backup your database" => "faça um backup da sua base de dados",
"with mysqldump or phpmyadmin before you proceed" => "com mysqldump ou phpmyadmin antes de continuar",
"Update database using script" => "Atualize a base de dados usando script",
"Do nothing and enter Tiki" => "Não faça nada e entre no Tiki",
"Reset database connection settings" => "Reinicia as configurações de conexão com a base de dados",
"This site has an admin account configured" => "Esse site tem uma conta de administrador configurada",
"Please enter your admin password to continue" => "Coloque a senha de admin para continuar",
"Print operations failed" => "Saída das operações que falharam",
"Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Sua base de dados foi configurada e o Tiki está pronto para rodar, se\n    \t\tessa é a sua primeira instação sua senha de administrador é 'admin'. Você pode\n    \t\tentrar agora no Tiki como 'admin' - 'admin' e começar a configurar\n    \t\ta aplicação",
"Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Nota: esse script de instalação pode ser utilizado para danificar seu site\n    \t\trecomendamos que você desabilite o script antes de começar a configurar a aplicação. Se\n    \t\tvocê decidir utilizá-lo novamente depois, siga as instruções para restaurar em\n\t\ttiki-install.php",
"READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "LEIA AS SEGUINTES NOTAS ANTES DE ENTRAR NO TIKI USANDO OS LINKS ABAIXO!",
"Note" => "Nota",
"If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "Se essa é a sua primeira instalação, vá para tiki-admin.php depois de logar para começar a configurar a aplicação",
"Clear cached version and refresh cache" => "Limpar versão em cache e recarregar o cache",
"configure rules" => "configurar regras",
"edit repository" => "editar repositório",
"Weeks" => "Semanas",
"Search by Date" => "Busca por Data",
"Found" => "Encontrado",
"LastChanges" => "Ultimas alterações",
"rollback" => "restaurar",
"source" => "fonte",
"Pages like" => "Páginas semelhantes",
"No pages found" => "Nenhuma página encontrada",
"List Articles" => "Listar Artigos",
"list articles tpl" => "listar artigos tpl",
"edit new article" => "editar um novo artigo",
"ExpireDate" => "DataDeExpiração",
"AuthorName" => "NomeDoAutor",
"admin Banners" => "administrar Banners",
"admin Banners tpl" => "administrar banners tpl",
"Create banner" => "Criar um banner",
"Method" => "Método",
"Use Dates?" => "Usar datas?",
"Max Impressions" => "Máx. Exibições",
"Impressions" => "Exibições",
"Clicks" => "Cliques",
"create new blog" => "criar um novo blog",
"Last Modified" => "Última Modificação",
"admin cache tpl" => "administrar cache tpl",
"Dynamic content system" => "Sistema de conteúdo dinâmico",
"Help on Dynamic Content" => "Ajuda no conteúdo dinâmico",
"admin DynamicContent tpl" => "administrar conteúdo dinâmico tpl",
"Create or edit content block" => "Criar ou editar um bloco de conteúdo dinâmico",
"Available content blocks" => "Blocos de conteúdo disponíveis",
"Current ver" => "Versão atual",
"Next ver" => "Próxima vers.",
"Future vers" => "Versões futuras",
"Old vers" => "Versão ant.",
"Program" => "Programa",
"list faqs tpl" => "listar faqs tpl",
"Edit this FAQ:" => "Editar este FAQ:",
"Create new FAQ" => "Criar um novo FAQ",
"Create New FAQ:" => "Criar um novo FAQ:",
"Users can suggest questions" => "Usuários podem sugerir perguntas",
"Available FAQs" => "FAQs Disponíveis",
"Listing Gallery" => "Listando a galeria",
"upload file" => "carregar um arquivo",
"Edit a file using this form" => "Editar um arquivo usando esta forma",
"Gallery Files" => "Arquivos da Galeria",
"move selected files" => "mover os arquivos selecionados",
"delete selected files" => "apagar os arquivos selecionados",
"Move to" => "Mover para",
"browse gallery" => "navegar pela galeria",
"Gallery Images" => "Imagens da Galeria",
"games tpl" => "jogos tpl",
"All games are from" => "Todos os jogos são de",
"visit the site for more games and fun" => "visite o site para mais jogos e brincadeiras",
"Upload a game" => "Carregar um jogo",
"Upload a new game" => "Carregar um novo jogo",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Miniatura (se o jogo se chamar foo.swf a miniatura deve se chamar foo.swf.gif ou foo.swf.png ou foo.swf.jpg)",
"Edit game" => "Editar o jogo",
"Played" => "Jogado",
"times" => "vezes",
"If you can't see the game then you need a flash plugin for your browser" => "Se você não consegue visualizar o jogo então você precisa instalar o plugin Flash no seu navegador",
"list posts tpl" => "listar mensagens tpl",
"edit blog" => "editar blog",
"Blog Title" => "Título do Blog",
"list quizzes tpl" => "listar quiz tpl",
"edit new submission" => "editar nova mensagem",
"Approve" => "Aprovar",
"edit quiz stats tpl" => "editar status quiz tpl",
"Survey stats" => "Estatísticas da pesquisa",
"actions" => "ações",
"take survey" => "pegar pesquisa",
"list trackers tpl" => "listar acompanhamentos tpl",
"users registered" => "usuários registrados",
"Distance (km)" => "Distância (km)",
"List Movies" => "Listar filmes",
"Choose a movie" => "Escolha um filme",
"Display" => "Mostrar",
"Last mod" => "Última alteração",
"Last author" => "Último autor",
"Last ver" => "Última versão",
"with checked" => "com marcação",
"admin live support tpl" => "administrar  live support tpl",
"Open client window" => "Abrir a janela de cliente",
"Generate HTML" => "Gerar HTML",
"Transcripts" => "Transcrição",
"Support tickets" => "Bilhete de suporte",
"Online operators" => "Operadores on-line",
"Operator" => "Operador",
"Accepted requests" => "Aceitar requisições",
"transcripts" => "transcrição",
"Offline operators" => "Operadores offline",
"Add an operator to the system" => "Adicionar um operador ao sistema",
"Operators must be tiki users" => "Operadores devem ser usuários Tiki",
"set as operator" => "definir como operador",
"Chat started" => "Chat iniciado",
"User:" => "Usuário:",
"Operator:" => "Operador:",
"Live support:User window" => "Suporte on-line:Janela do usuário",
"Request live support" => "Requisitar suporte on-line",
"Request support" => "Requisitar suporte",
"Open a support ticket instead" => "Obter um bilhete de suporte ao invés disto",
"Your request is being processed" => "Sua requisição está sendo processada",
"cancel request and exit" => "cancelar a requisição e sair",
"cancel request and leave a message" => "cancelar a requisição e deixar uma mensagem",
"Live support:Console" => "Suporte on-line:Console",
"be online" => "ficar on-line",
"be offline" => "ficar offline",
"Support requests" => "Requisições de suporte",
"Requested" => "Requisitou",
"Accept" => "Aceitar",
"Join" => "Juntar-se",
"Support chat transcripts" => "Transcrições do chat de suporte",
"back to admin" => "voltar à administração",
"operator" => "operador",
"started" => "iniciou",
"reason" => "motivo",
"Transcript" => "Transcrição",
"Mail-in feature" => "Recurso mail-in",
"User Calendar" => "Calendário do usuário",
"User Calendar Doc tpl" => "documento do calendário do usuário tpl",
"Remove old events" => "Remover eventos antigos",
"duration" => "duração",
"Add or edit event" => "Adicionar ou editar evento",
"Mini Calendar: Preferences" => "Mini-Calendário: Preferências",
"User Calendar Doc" => "Documento do calendário do usuário",
"User Calendar Preferences Doc tpl" => "Preferências do documento do calendário do usuário tpl",
"Calendar Interval in daily view" => "Intervalo do calendário na visão diária",
"Start hour for days" => "Hora inicial para os dias",
"End hour for days" => "Hora final para os dias",
"Reminders" => "Lembretes",
"no reminders" => "sem lembretes",
"Import CSV file" => "Importar arquivo CSV",
"Or enter path or URL" => "Ou entre o caminho ou endereço",
"add topic" => "adicionar assunto",
"Rebuild local list" => "Reconstruir lista localRebuild local list",
"Republish all" => "Republicar todos",
"Publish all" => "Publicar todos",
"Unpublish all" => "Despublicar todos",
"Attention" => "Atenção",
"Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "O Apache tem permissão para escrever na sua árvore de arquivos, o que permite a instalação, remoção ou atualização dos pacotes. Quando você terminar essas operações, é recomendável voltar as permissões para o modo mais seguro (usando \n\"./fixperms.sh fix\" por exemplo).",
"To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "Para instalar, remover ou atualizar pacotes é necessário que o usuário do Apache tenha permissão de escrita na árvore de arquivos da web (você pode usar \"./fixperms.sh open\" para fazer isso). Depois da instalação você deve remover essa permissão (usando \"./fixperms.sh fix\").",
"all types" => "todos os tipos",
"Display only this type" => "Mostrar apenas esse tipo",
"Unpublish" => "Não publicar",
"Republish" => "Publicar novamente",
"install" => "instalar",
"Package Config" => "Configurar pacote",
"My Tiki" => "Meu Tiki",
"my tiki tpl" => "área pessoal tpl",
"My pages" => "Minhas páginas",
"User Pages" => "Páginas de Usuários",
"Last editor" => "Último editor",
"Last modification" => "Última alteração",
"y" => "s",
"User Galleries" => "Galerias de Usuário",
"My items" => "Meus itens",
"Assigned items" => "Itens atribuídos",
"Unread Messages" => "Mensagens não lidas",
"My tasks" => "Minhas tarefas",
"User Blogs" => "Blogs de Usuários",
"subscribe" => "inscrever",
"Sent edition" => "Enviar edição",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Obrigado por sua assinatura. Você receberá um email em breve para confirmar sua assinatura. Nenhum comunicado será enviado até que sua inscrição seja confirmada.",
"Your email address was removed from the list of subscriptors." => "Seu endereço de email foi removido da lista de assinantes.",
"Subscription confirmed!" => "Assinatura confirmada!",
"Subscribe to newsletter" => "Assine o comunicado",
"Email:" => "E-mail:",
"Subscribe" => "Inscrever-se",
"Available Newsletters" => "Newsletters disponíveis",
"Select news group" => "Selecionar grupo de news",
"Back to servers" => "Voltar aos servidores",
"Msgs" => "Mens",
"News from" => "Novidades de",
"Back to groups" => "Voltar aos grupos",
"Save position" => "Gravar a posição",
"Reading article from" => "Lendo artigo de",
"Back to list of articles" => "Voltar à lista de artigos",
"First" => "Primeiro",
"Configure news servers" => "Configurar servidores de notícias",
"Configure Newsreader" => "Configurar leitor de notícias",
"configure newsreader server tpl" => "configurar servidor de leitores de notícias tpl",
"Select a news server to browse" => "Selecione um servidor de notícias para visualizar",
"server" => "servidor",
"Read the news" => "Ler notícias",
"Add or edit a news server" => "Adicionar ou editar um servidor de notícias",
"News server" => "Servidor de notícias",
"Notes" => "Notas",
"quota" => "cota",
"Write a note" => "Escrever uma nota",
"No notes yet" => "Sem notas ainda",
"merge selected notes into" => "combinar notas selecionadas em",
"Reading note:" => "Lendo nota:",
"List notes" => "Listar notas",
"Write note" => "Escrever nota",
"wiki create" => "criar wiki",
"wiki overwrite" => "sobrescrever wiki",
"Assign permissions to " => "Definir permissões a ",
"back" => "voltar",
"Current permissions for this object" => "Permissões atuais para este objeto",
"Assign permissions to this object" => "Definir permissões para este objeto",
"Published" => "Publicado",
"Votes" => "Votos",
"Orphan Pages" => "Páginas Órfãs",
"wiki help" => "auxílio wiki",
"Preview of version" => "Visualização prévia da versão",
"(current)" => "(atual)",
"rollback to this version" => "restaurar para essa versão",
"Source of version" => "Fonte da versão",
"s=source" => "s=fonte",
"b=rollback" => "b=restaurar",
"Assign permissions to page" => "Definir permissões para a página",
"Current permissions for this page" => "Permissões atuais para esta página",
"remove from this page" => "remover desta página",
"remove from this structure" => "remover desta estrutura",
"No individual permissions; category or global permissions apply" => "Sem permissões individuais, usando as permissões da categoria ou as globais",
"this page" => "esta página",
"this structure" => "essa estrutura",
"Current permissions for categories that this page belongs to" => "Permissões atuais para a categoria à qual essa página pertence",
"No category permissions; global permissions apply" => "Sem permissão na categoria, usando permissões globais",
"Send email notifications when this page changes to" => "Enviar notificações por email sobre alterações nesta página para",
"add email" => "adicionar endereço de email",
"Notifications" => "Notificações",
"Pick your avatar" => "Selecione sua fotografia",
"Your current avatar" => "Sua fotografia atual",
"no avatar" => "sem fotografia",
"Pick avatar from the library" => "Selecionar uma fotografia da biblioteca",
"icons" => "ícones",
"Show all" => "Exibir todos",
"Avatar Image" => "Imagem da fotografia",
"random" => "aleatório",
"Upload your own avatar" => "Carregar sua própria fotografia",
"atts" => "atributos",
"Number of voices" => "Número de vozes",
"Average" => "Média",
"List Attachments" => "Listar anexos",
"View Results" => "Ver Resultados",
"Vote poll" => "Votar na enquete",
"Other Polls" => "Outras enquetes",
"List Votes" => "Listar votos",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Nota: lembre-se que isto é apenas uma visualização, ainda não foi salvo.",
"Print multiple pages" => "Imprimir múltiplas páginas",
"Print Wiki Pages" => "Imprimir Páginas Wiki",
"clear" => "limpar",
"Edit quiz" => "Editar quiz",
"Current Version" => "Versão atual",
"General Options" => "Opções gerais",
"Publication Date" => "Data da publicação",
"at " => "às ",
"Use " => "Uso ",
"randomly selected questions." => "selecionar questões aleatoriamente.",
"Test-time Options" => "Opções durante o teste",
"Limit questions displayed per page to " => "Limitar questões mostradas por página ",
"&nbsp question(s)." => "&nbsp questão(s).",
"Impose a time limit of " => "Impor um limite de tempo de ",
"Allow students to store partial results and return to quiz." => "Permitir que estudantes guardem resultados parciais e voltem para o quiz.",
"Allow students to retake this quiz " => "Permitir que estudantes reiniciem esse quiz ",
"Grading and Feedback" => "Classificação e retorno",
"Grading method " => "Método de classificação ",
"Show students their score " => "Mostrar para os estudantes sua pontuação ",
"Show students the correct answers " => "Mostrar para os estudantes a resposta correta ",
"Publish statistics " => "Publicar estatísticas ",
"Extra Options" => "Opções extras",
"Solicit additional questions from students" => "Solicitar questões adicionais dos estudantes",
"Link quiz to forum named: " => "Criar um link do quiz para um fórum chamado: ",
"Prologue:" => "Prólogo:",
"Epilogue:" => "Epílogo:",
"Quiz result stats" => "Estatísticas de resultados do Teste",
"Quiz" => "Teste",
"Time" => "Tempo",
"User answers" => "Respostas do usuário",
"Stats for quizzes" => "Estats para testes",
"taken" => "feitos",
"Av score" => "Pontuação méd.",
"Av time" => "Tempo méd.",
"Stats for quiz" => "Estats para a pesquisa",
"clear stats" => "limpar estatísticas",
"time taken" => "tempo total",
"Stats for this quiz Questions " => "Estatísticas para as perguntas deste teste ",
"Top 10" => "10 Mais",
"Top 20" => "20 Mais",
"Top 50" => "50 Mais",
"Top 100" => "100 Mais",
"Received Articles" => "Artigos Recebidos",
"received articles tpl" => "artigos recebidos tpl",
"Edit received article" => "Editar o artigo recebido",
"Use Image" => "Usar Imagem",
"Image x size" => "Largura da imagem",
"Image y size" => "Altura da imagem",
"Image name" => "Nome da imagem",
"Accept Article" => "Aceitar o Artigo",
"Help on Communication Center" => "Ajuda no centro de comunicações",
"received pages tpl" => "páginas recebidas tpl",
"Edit received page" => "Editar uma página recebida",
"admin Referer stats" => "administrar Estats de Referência",
"last" => "último",
"A valid email is mandatory to register" => "É necessário um e-mail válido para poder se registrar",
"NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTA: Verifique se o domínio desse site não é marcado como spam por seu cliente de e-mail.<br /> Se não estiver recebendo e-mails do site verifique se eles não estão na caixa de spam.",
"Tiki site registered" => "Site Tiki registrado",
"You don't have permission to use this feature." => "Você não tem permissão para usar esse recurso.",
"Please register." => "Por favor faça o registro.",
"Read this first!" => "Leia isto em primeiro!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Nesta página você pode fazer com que seu site seja conhecido no tikiwiki.org. Ele será mostrado em uma lista de sites tiki conhecidos.",
"Registering is voluntary." => "O registro é voluntário.",
"Registering does not give you any benefits except one more link to your site." => "O registro não dá à você nenhum benefício exceto o link para seu site.",
"You don't get any emails, we don't sell the data about your site." => "Você não pode pegar nenhum e-mail, nós não vendemos os dados sobre seu site.",
"Registering is just for us to get an overview of Tiki's usage." => "O registro é somente para obtermos uma amostragem do uso do Tiki.",
"If your site is private or inside your intranet, you should not register!" => "Se o seu site é privado ou está dentro de sua intranet, você não deve se registrar!",
"Information about your site" => "Informação sobre seu site",
"I forgot my password" => "Esqueci minha senha",
"send me my password" => "envie minha senha",
"Return to HomePage" => "Retornar à página inicial",
"Remove page" => "Remover a página",
"last version" => "última versão",
"You are about to remove the page" => "Você está prestes a remover a página",
"permanently" => "permanentemente",
"Remove all versions of this page" => "Remover todas as versões desta página",
"Rename page" => "Renomear a página",
"Replicate" => "Replicar",
"Tikiwiki.org help" => "Ajuda Tikiwiki.org",
"Slave" => "Escravo",
"Master" => "Principal",
"Change" => "Mudar",
"Operations" => "Operações",
"Operations Log" => "Log das operações",
"Rollback page" => "Restaurar versão da página",
"to_version" => "versão_desejada",
"Search Stats" => "Estatísticas de busca",
"searched" => "buscadas",
"Search in" => "Buscar em",
"galleries" => "galerias",
"blog posts" => "mensagens de blogs",
"articles" => "artigos",
"trackers" => "acompanhamentos",
"entire site" => "site inteiro",
"wiki pages" => "páginas wiki",
"Simple search" => "Busca simples",
"No pages matched the search criteria" => "Nenhuma página atendeu aos seus critérios de busca",
"Send blog post" => "Enviar mensagem blog",
"A link to this post was sent to the following addresses:" => "Um link para esta mensagem foi enviada para os seguintes endereços:",
"Send post to this addresses" => "Enviar a mensagem para estes endereços",
"List of email addresses separated by commas" => "Lista de endereços de email separados por vírgulas",
"Apply content template" => "Aplicar conteúdo do template",
"Send objects" => "Enviar objetos",
"admin send objects tpl" => "administrar objetos enviados tpl",
"Transmission results" => "Resultados da transmissão",
"Send objects to this site" => "Enviar objetos para este site",
"password" => "senha",
"Send Wiki Pages" => "Enviar Páginas Wiki",
"Send Articles" => "Enviar Artigos",
"add article" => "adicionar um artigo",
"sheets tpl" => "planilhas tpl",
"Create a sheet" => "Criar uma planilha",
"Edit this sheet:" => "Editar essa planilha:",
"create new sheet" => "criar nova planilha",
"There are individual permissions set for this sheet" => "Existem permissões individuais definidas para essa planilha",
"Class Name" => "Nome da classe",
"Header Rows" => "Linhas do topo",
"Footer Rows" => "Linhas de baixo",
"Create new Sheet" => "Criar nova planilha",
"You can access the sheet using the following URL" => "Você pode acessar a planilha através do endereço",
"Available Sheets" => "Planilhas disponíveis",
"Tiki Shoutbox" => "Mural",
"admin Tiki Shoutbox" => "administrar Mural",
"admin Tiki Shoutbox tpl" => "administar quadro negro do tiki tpl",
"Change shoutbox general settings" => "Alterar configurações gerais do quadro negro",
"Post or edit a message" => "Enviar ou editar uma mensagem",
"first" => "primeiro",
"big grin" => "grande sorriso",
"confused" => "confuso",
"cool" => "legal",
"cry" => "chorando",
"evil" => "demônio",
"lol" => "engraçado",
"mr green" => "sr. verde",
"razz" => "insultoso",
"redface" => "cara vermelha",
"rolleyes" => "olhos enrolados",
"smile" => "sorriso",
"surprised" => "surpreso",
"twisted" => "torcido",
"arrow" => "seta",
"santa" => "papai noel",
"Most viewed objects" => "Objetos mais vistos",
"Most viewed objects in the last 7 days" => "Objetos mais vistos nos últimos 7 dias",
"Site Stats" => "Estatísticas do Site",
"Days online" => "Dias on-line",
"Total pageviews" => "Total de visualizações de páginas",
"Average pageviews per day" => "Média de visualizações de páginas diárias",
"Best day" => "Melhor dia",
"Worst day" => "Pior dia",
"Wiki Stats" => "Estatísticas Wiki",
"Size of Wiki Pages" => "Tamanho das Páginas Wiki",
"Average page length" => "Tamanho médio das páginas",
"Average versions per page" => "Média de versões por página",
"Visits to wiki pages" => "Visitas a páginas Wiki",
"Average links per page" => "Média de links por página",
"Image galleries Stats" => "Estatísticas de galerias de imagens",
"Average images per gallery" => "Número médio de imagens por galeria",
"Total size of images" => "Tamanho total das imagens",
"Average image size" => "Tamanho médio das imagens",
"Visits to image galleries" => "Visitas as galerias de imagens",
"File galleries Stats" => "Estatísticas das galerias de arquivos",
"Average files per gallery" => "Número médio de arquivos por galeria",
"Total size of files" => "Tamanho total dos arquivos",
"Average file size" => "Tamanho médio dos arquivos",
"Visits to file galleries" => "Visitas as galerias de arquivos",
"CMS Stats" => "Estatísticas de CMS",
"Total reads" => "Total de leituras",
"Average reads per article" => "Média de leituras por artigos",
"Total articles size" => "Tamanho total dos artigos",
"Average article size" => "Tamanho médio dos artigos",
"Forum Stats" => "Estatísticas dos fóruns",
"Total topics" => "Total de assuntos",
"Average topics per forums" => "Média de assuntos por fórum",
"Total threads" => "Número total de seqüências",
"Average threads per topic" => "Média de seqüências por tópico",
"Visits to forums" => "Visitas aos fóruns",
"Blog Stats" => "Estatísticas de Blogs",
"Total posts" => "Total de mensagens",
"Average posts per weblog" => "Média de mensagens por weblog",
"Total size of blog posts" => "Tamanho total das mensagens de blogs",
"Average posts size" => "Tamanho médio das mensagens",
"Visits to weblogs" => "Visitas aos weblogs",
"Poll Stats" => "Estatísticas das enquetes",
"Total votes" => "Total de votos",
"Average votes per poll" => "Média de votos por enquete",
"Faq Stats" => "Estatísticas de FAQ",
"Total questions" => "Total de perguntas",
"Average questions per FAQ" => "Média de perguntas por FAQ",
"User Stats" => "Estatísticas de usuários",
"User bookmarks" => "Bookmarks de usuários",
"Average bookmarks per user" => "Média de bookmarks por usuário",
"Quiz Stats" => "Estatísticas de testes",
"Average questions per quiz" => "Média de perguntas por teste",
"Quizzes taken" => "Testes realizados",
"Average quiz score" => "Nota média nos testes",
"Average time per quiz" => "Tempo médio por teste",
"Object" => "Objeto",
"Usage chart" => "Gráfico de uso",
"Usage chart image" => "Imagem do gráfico de uso",
"Daily Usage" => "Uso diário",
"Stats for surveys" => "Estatísticas de pesquisas",
"Survey" => "Pesquisa",
"Last taken" => "Última realização em",
"Stats for survey" => "Estatísticas para a pesquisa",
"Stats for this survey Questions " => "Estatísticas para as perguntas desta pesquisa ",
"SysLog" => "Logs do sistema",
"system logs" => "logs do sistema",
"system logs tpl" => "logs do sistema tpl",
"Time Left" => "Tempo restante",
"send answers" => "enviar as respostas",
"Result" => "Resultado",
"Thank you for your submission" => "Obrigado por enviar",
"Theme Control Center: categories" => "Centro de Controle de Temas: categorias",
"ThemeControl" => "ControleDeTemas",
"ThemeControl tpl" => "Controle do tema tpl",
"Theme is selected as follows" => "Um tema é selecionado da seguinte forma",
"If a theme is assigned to the individual object that theme is used." => "Se um tema for atribuído a um objeto individual o tema é utilizado",
"If not then if a theme is assigned to the object's category that theme is used" => "Senão, então se um tema for atribuído à categoria do objeto o tema é utilizado",
"If not then a theme for the section is used" => "Senão, um tema para a seção é utilizado",
"If none of the above was selected the user theme is used" => "Se nenhum dos itens acima for selecionado, o tema do usuário é utilizado",
"Finally if the user didn't select a theme the default theme is used" => "Finalmente, se o usuário não selecionou um tema o tema padrão é utilizado",
"Control by Objects" => "Controlado por objetos",
"Control by Sections" => "Controlar por seções",
"Assign themes to categories" => "Atribuir temas a categorias",
"Assigned categories" => "Categorias atribuídas",
"theme" => "tema",
"Theme Control Center: Objects" => "Centro de Controle de Temas: Objetos",
"ThemeControl Objects" => "ControleDeTemas Objetos",
"Control by Categories" => "Controle por Categorias",
"Assign themes to objects" => "Atribuir temas a objetos",
"Assigned objects" => "Objetos atribuídos",
"Theme Control Center: sections" => "Centro de Controle de Temas: seções",
"Assign themes to sections" => "Atribuir temas a seções",
"Assigned sections" => "Seções atribuídas",
"section" => "seção",
"This is" => "Este é o",
"by the" => "criado pela",
"Tiki community" => "comunidade Tiki",
"Edit File:" => "Editar arquivo:",
"Upload File" => "Carregar arquivo",
"File Title" => "Título do Arquivo",
"Now enter the file URL" => "Agora digite o endereço para o arquivo",
" or upload a local file from your disk" => " ou carregue um arquivo local do seu disco",
"Unzip all zip files" => "Descompacte todos os arquivos zip",
"The following file was successfully uploaded" => "O seguinte arquivo foi carregado com sucesso",
"You can download this file using" => "Você pode baixar este arquivo usando",
"You can include the file in an HTML/Tiki page using" => "Você pode incluir este arquivo em uma página HTML/Tiki usando",
"You have to create a gallery first!" => "Você precisa criar uma galeria antes de prosseguir!",
"Image Gallery tpl" => "Galeria de imagens tpl",
"or use filename" => "ou use o nome do arquivo",
"Now enter the image URL" => "Agora digite o endereço para a imagem",
" or upload a local image from your disk" => " ou carregue uma imagem local do seu disco",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Miniatura (opcional, sobrescreve a miniatura automaticamente gerada)",
"Note: Maximum image size is limited to" => "Nota: tamanho máximo de uma imagem:",
"Upload successful!" => "Carga bem-sucedida!",
"The following image was successfully uploaded" => "A seguinte imagem foi carregada com sucesso",
"Thumbnail" => "Miniatura",
"Image ID thumb" => "ID da miniatura da imagem",
"You can include the image in an Wiki page using" => "Você pode incluir a imagem em uma página Wiki usando",
"User assigned modules" => "Módulos atribuídos pelo usuário",
"User Assigned Modules" => "Módulos Atribuídos pelo Usuário",
"User Assigned Modules tpl" => "módulos associados pelo usuário tpl",
"Restore defaults" => "Restaurar padrões",
"move to right column" => "mover para a coluna direita",
"unassign" => "não atribuir mais",
"move to left column" => "mover para a coluna esquerda",
"Assign module" => "Definir módulo",
"Column" => "Coluna",
"User Bookmarks tpl" => "Favoritos do usuário tpl",
"Current folder" => "Pasta atual",
"Folders" => "Pastas",
"Folder in" => "Pasta em",
"remove folder" => "remover pasta",
"refresh cache" => "atualizar cache",
"Admin folders and bookmarks" => "Administrar pastas e favoritos",
"Add or edit folder" => "Adicionar ou editar pasta",
"Add or edit a URL" => "Adicionar ou editar um endereço",
"Avatar" => "Fotografia",
"Homepage" => "Site pessoal ou institucional",
"Users HomePage" => "Página inicial do usuário",
"Personal Wiki Page" => "Página Wiki Pessoal",
"Create page" => "Criar página",
"Displayed time zone" => "Fuso horário exibido",
"This user is your friend" => "Esse usuário é seu amigo",
"Request friendship from this user" => "Solicitação de amizade desse usuário",
"Send me a message" => "Envie-me uma mensagem",
"Toggle options" => "Mudar opções",
"User Preferences" => "Preferências do Usuário",
"UserPreferences tpl" => "Preferências do usuário tpl",
"Personal Information" => "Informação pessoal",
"General preferences" => "Preferências gerais",
"Other preferences" => "Outras preferências",
"Pick user Avatar" => "Escolher fotografia do usuário",
"Your personal Wiki Page" => "Sua página Wiki pessoal",
"Your personal tracker information" => "Informações do seu acompanhamento pessoal",
"View extra information" => "Visualizar informação extra",
"Change information" => "Atualizar informações",
"Is email public? (uses scrambling to prevent spam)" => "Endereço de email público? (utilizar ofuscação para evitar spam)",
"Unavailable - please set your e-mail below" => "Não disponível - por favor defina seu e-mail abaixo",
"Does your mail reader need a special charset" => "Seu cliente de e-mail precisa de codificação específica",
"Number of visited pages to remember" => "Número de páginas visitadas a lembrar",
"User information" => "Informação do Usuário",
"private" => "privada",
"public" => "pública",
"Use double-click to edit pages" => "Clique-duplo para editar páginas",
"Account Information" => "Conta",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Deixe os campos \"Nova senha\" e \"Confirmar nova senha\" em branco para manter a senha atual",
"Email address" => "E-mail",
"Confirm new password" => "Confirmar nova senha",
"Current password (required)" => "Senha atual (obrigatório)",
"Change administrative info" => "Atualizar",
"Messages per page" => "Mensagens por página",
"Allow messages from other users" => "Permitir mensagens de outros usuários",
"Note author when reading his mail" => "Notificar o autor quando ler o e-mail dele",
"Send me an email for messages with priority equal or greater than" => "Envie-me um email para mensagens com prioridade igual ou maior que",
"Auto-archive read messages after x days" => "Arquivar automaticamente mensagens lidas depois de x dias",
"Tasks per page" => "Tarefas por página",
"My messages" => "Minhas mensagens",
"My workflow" => "Minha workflow",
"User Tasks tpl" => "Tarefas do usuário tpl",
"New task" => "Nova tarefa",
"Task list" => "Lista de tarefas",
"Admin mode off" => "Administrar modo desligado",
"Admin mode on" => "Administrar modo ligado",
"Task help" => "Ajuda: Tarefas",
"Received task" => "Tarefa recebida",
"You received this task, please read and execute it" => "Você recebeu essa tarefa, por favor leia e execute ela",
"Send task" => "Enviar tarefa",
"You send this task to a other user" => "Você enviou essa tarefa para outro usuário",
"Shared task" => "Tarefas compartilhadas",
"This task is public to a special group" => "Essa tarefa é pública para um grupo especial",
"accepted by task user and creator" => "aceito pelo usuário e criador da tarefa",
"accepted user and creator" => "aceito usuário e criador",
"Task is accepted by user and creator" => "A tarefa foi aceito pelo usuário e pelo criador",
"not accepted by one user" => "não aceito por um usuário",
"not accepted user" => "usuário não aceito",
"Task is rejected by one user" => "Tarefa rejeitada por um usuário",
"waiting for me" => "esperando por mim",
"Task is not accepted by you, read the task and accept or reject it" => "Status da tarefa ainda não definido por você, por favor leia e aceite ou rejeite a tarefa",
"waiting for other user" => "esperando por outro usuário",
"Task is not accepted/rejected by other user" => "Tarefa não foi aceita/rejeitada por outro usuário",
"admin mode" => "modo de administração",
"trash" => "lixeira",
"empty trash" => "limpar lixeira",
"Edit task" => "Editar tarefa",
"red" => "vermelho",
"NOT accept" => "Não aceito",
"remove from trash" => "remover da lixeira",
"move into trash" => "mover para a lixeira",
"Task saved" => "Tarefas salvas",
"Edit Task" => "Editar tarefa",
"View Task" => "Visualizar tarefa",
"Open a new task" => "Abrir nova tarefa",
"taskId" => "ID da tarefa",
"Task user" => "Usuário da tarefa",
"Only the creator can delete this task" => "Apenas o proprietário pode deletar a tarefa",
"use start date and time" => "data e hora do início",
"use end date and time" => "data e hora do término",
"open / in process" => "em andamento",
"waiting / not started" => "esperando para começar",
"Percentage completed" => "Porcentagem de realização",
"waiting" => "esperando",
"shared for group" => "compartilhado para o grupo",
"accepted by user" => "aceito pelo usuário",
"no / rejected" => "não / rejeitado",
"accepted by creator" => "aceito pelo proprietário",
"Info" => "Informações",
"This message will be send to users if you are makeing changes of assigned tasks" => "Essa mensagem vai ser enviada para os usuários se você esta fazendo mudanças em tarefas associadas",
"Send message with changes" => "Enviar mensagens com as mudanças",
"Modified by" => "Modificado por",
"Marked as deleted" => "Marcar como deletado",
"Inform task user by email" => "Informar usuário da tarefa por e-mail",
"You can only view this task" => "Você pode apenas visualizar essa tarefa",
"priority" => "prioridade",
"%m/%d/%Y [%H:%M]" => "%m/%d/%A [%H:%M]",
"No tasks entered" => "Nenhuma tarefa cadastrada",
"select one" => "selecionar um",
"undo trash" => "limpar lixeira",
"show:" => "mostrar:",
"received" => "recebido",
"submitted" => "enviado",
"shared" => "compartilhado",
"all shared tasks" => "todas as tarefas compartilhadas",
"completed (100%)" => "completa (100%)",
"Public for group" => "Público para o grupo",
"User Watches tpl" => "Notificações do usuário tpl",
"Add Watch" => "Adicionar notificação",
"A user submits a blog post" => "Um usuário enviou uma mensagem no blog",
"A user posts a forum thread" => "Um usuário criou um novo assunto no fórum",
"A user posts a forum topic" => "Um usuário enviou um novo tópico no fórum",
"A user edited a wiki page" => "Um usuário editou uma página wiki",
"edit user files" => "editar arquivos do usuário",
"May need to refresh twice to see changes" => "Pode ser necessário atualizar duas vezes para ver as alterações",
"Add top level bookmarks to menu" => "Adicionar bookmarks de nível superior ao menu",
"Mode" => "Modo",
"replace window" => "substituir a janela",
"User_versions_for" => "Versões_de_usuário_para",
"Insert Row" => "Inserir linha",
"Insert Column" => "Inserir coluna",
"Remove Row" => "Remover linha",
"Remove Column" => "Remover coluna",
"Merge Cells" => "Mesclar células",
"Restore Cells" => "Restaurar células",
"Copy Calculation" => "Copiar cálculo",
"Format Cell" => "Formatar célula",
"Before" => "Antes",
"After" => "Depois",
"expires:" => "expira:",
"no comments" => "sem comentários",
"Banner stats" => "Estatísticas de Banner",
"Create new banner" => "Criar um novo banner",
"Banner Information" => "Informação do Banner",
"Click ratio" => "Taxa de cliques",
"Weekdays" => "Dias da semana",
"mon" => "seg",
"tue" => "ter",
"wed" => "qua",
"thu" => "qui",
"fri" => "sex",
"sat" => "sáb",
"sun" => "dom",
"Banner raw data" => "Dados brutos do Banner",
"Cached" => "Em cache",
"This is a cached version of the page." => "Esta é uma versão em cache da página.",
"Click here to view the Google cache of the page instead." => "Clique aqui para ver, ao invés, o cache do Google.",
"viewed" => "visualizada",
"edit items" => "editar itens",
"list charts" => "listar gráficos",
"last chart" => "último gráfico",
"previous chart" => "gráfico anterior",
"Chart created" => "Gráfico criado",
"next chart" => "próximo gráfico",
"pre" => "ant",
"permanency" => "permanência",
"item" => "ítem",
"chg" => "alt",
"avg" => "méd",
"info/vote" => "info/votar",
"Next chart will be generated on" => "Próximo gráfico será gerado em",
"View or vote items not listed in the chart" => "Ver ou votar em itens não listados no gráfico",
"Select something to vote on" => "Selecione uma votação",
"Item information" => "Informação do Ítem",
"Chart" => "Gráfico",
"Permanency" => "Permanência",
"Best Position" => "Melhor Posição",
"Vote this item" => "Votar neste ítem",
"Highest" => "Maior",
"view faq tpl" => "ver faq tpl",
"admin menus tpl" => "administrar menus tpl",
"Answers" => "Repostas",
"Q" => "P",
"A" => "R",
"add suggestion" => "adicionar sugestão",
"1 suggestion" => "1 sugestão",
"suggestions" => "sugestões",
"Forum List" => "Lista de Fóruns",
"Edit Forum" => "Editar Fórum",
"monitor this forum" => "monitorar este fórum",
"stop monitoring this forum" => "não monitorar mais este fórum",
"You have {\$unread} unread private messages" => "Você tem {\$unread} mensagens particulares não lidas",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Sua mensagem está aguardando aprovação, a mensagem pode ser postada depois\nque um moderador aprová-la.",
"You have to enter a title and text" => "Você precisa digitar um título e um texto",
"post new comment" => "enviar novo comentário",
"Summary" => "Sumário",
"HTML tags are not allowed inside comments" => "Tags HTML não são permitidos em comentários",
"moderator actions" => "ações de moderador",
"move selected topics" => "mover os tópicos selecionados",
"unlock selected topics" => "destravar os tópicos selecionados",
"lock selected topics" => "travar os tópicos selecionados",
"delete selected topics" => "apagar os tópicos selecionados",
"merge" => "unir",
"merge selected topics" => "unir os tópicos selecionados",
"reported messages:" => "mensagens enviadas:",
"queued messages:" => "mensagens pendentes:",
"Merge into topic" => "Unir no tópico",
"No topics yet" => "Nenhum tópico criado",
"topics in this forum" => "tópicos neste fórum",
"Show posts" => "Exibir mensagens",
"Last hour" => "Última hora",
"Last 24 hours" => "Últimas 24 horas",
"Last 48 hours" => "Últimas 48 horas",
"Jump to forum" => "Ir ao fórum",
" unread private messages" => " mensagens particulares não lidas",
"prev topic" => "tópico anterior",
"next topic" => "próximo tópico",
"posts:" => "mensagens:",
"monitor this topic" => "monitorar este tópico",
"stop monitoring this topic" => "não monitorar mais este tópico",
"Comments below your current threshold" => "Comentários abaixo do seu limite atual",
"IRC log" => "Log de IRC",
"Select" => "Selecionar",
"Show All" => "Mostrar Tudo",
"Edit fields" => "Editar campos",
"Insert new item" => "Inserir novo ítem",
" item found" => " item encontrado",
" items found" => " items encontrados",
"list attachments" => "listar anexos",
"View inserted item" => "Visualizar itens inseridos",
"fields marked with a * are mandatory" => "campos marcados com * são obrigatórios",
"Tracker item:" => "Item do acompanhamento:",
"View item" => "Visualizar ítem",
"Filter Tracker Items" => "Filtrar itens do acompanhamento",
"Add a comment" => "Adicionar um comentário",
"Attach a file to this item" => "Anexar um arquivo a este ítem",
"more info" => "mais informações",
"No attachments for this item" => "Sem arquivos anexados a este ítem",
"remove image" => "remover imagem",
"Special Operations" => "Operações especiais",
"Details" => "Detalhes",
"Webmail Doc" => "Documento Webmail",
"settings" => "configurações",
"mailbox" => "correio",
"compose" => "escrever",
"contacts" => "contatos",
"Contacts" => "Contatos",
"Edit mail account" => "Editar conta de e-mail",
"Add new mail account" => "Adicionar nova conta de email",
"User accounts" => "Contas de usuários",
"account" => "conta",
"View All" => "Ver Todas",
"Msg" => "Mnsg",
"back to mailbox" => "retornar à lista de mensagens",
"full headers" => "cabeçalhos completos",
"normal headers" => "cabeçalhos comuns",
"reply all" => "responder a todos",
"forward" => "remeter",
"Create/edit contacts" => "Criar/editar contatos",
"First Name" => "Nome",
"Last Name" => "Sobrenome",
"select from address book" => "selecionar da agenda de endereços",
"Use HTML mail" => "Usar email HTML",
"The following addresses are not in your address book" => "Os seguintes endereços não estão na sua agenda de endereços",
"add contacts" => "adicionar contatos",
"Attachment 1" => "Anexo 1",
"Attachment 2" => "Anexo 2",
"Attachment 3" => "Anexo 3",
"Address book" => "Agenda de endereços",
"Use this thread to discuss the page:" => "Use esse tópico para discutir a página:",
"Administration" => "Administração",
"%s enabled" => "%s habilitado",
"%s disabled" => "%s desabilitado",
"Enable/disable Tiki features here, but configure them elsewhere" => "Habilite/desabilite os recursos do tiki aqui, mas a configuração deve ser feita na parte específica de cada recurso",
"General preferences and settings" => "Configurações e preferências gerais",
"User registration, login and authentication" => "Registrar usuário, logar e autenticar",
"Wiki settings" => "Configurações Wiki",
"Wiki Attachments" => "Anexos wiki",
"Article/CMS settings" => "Artigos/Configurações do CMS",
"Poll comments settings" => "Configurações de comentários de enquetes",
"Configuration options for all blogs on your site" => "Opções de configuração para todos os blogs do site",
"Forums settings" => "Configurações de fóruns",
"FAQ comments settings" => "Configurar comentários do FAQ",
"Trackers settings" => "Configurações dos acompanhamentos",
"RSS settings" => "Configurações do RSS",
"Directory settings" => "Configurar diretório",
"Maps configuration" => "Configurar mapas",
"Meta Tags settings" => "Configurar meta tags",
"Search settings" => "Configurações de busca",
"Score settings" => "Configurar pontuação",
"Community settings" => "Configurações da Comunidade",
"Site Identity features" => "Recursos da identidade do site",
"Calendar settings" => "Configurar calendário",
"Help on \$admintitle Config" => "Ajuda sobre configuração em \$admintitle",
"Click here to delete this category" => "Clique aqui para deletar essa categoria",
"Category can`t be parent of itself" => "Categoria não pode ser pai dela mesma",
"No chart indicated" => "Nenhum gráfico indicado",
"Upload failed" => "A carga falhou",
"You have to provide a hotword and a URL" => "Você deve informar uma palavra-chave e uma URL",
"No page indicated" => "Nenhuma página indicada",
"Detected, Version:" => "Versão detectada:",
"Not detected." => "Não detectada.",
"The passwords don't match" => "A senha não confere",
"You cannot have a blank password" => "Você não pode ter uma senha vazia",
"Password should be at least" => "A senha deveria ter no mínimo",
"characters long" => "caracteres",
"Your admin password has been changed" => "Sua senha de administrador foi alterada",
"DATE-of" => "de",
"All Fields except gdaltindex must be filled" => "Todos os campos exceto gdaltindex devem ser preenchidos",
"No valid gdaltindex executable" => "Executável gdaltindex não é válido",
"You cannot mix old and new trackers" => "Você não pode misturar antigos e novos acompanhamentos",
"Tag already exists" => "O tag já existe",
"Tag not found" => "Tag não encontrado",
"Repository name can't be an empty" => "Nome do Repositório não pode ser vazio",
"Requested action is not supported on repository" => "A ação solicitada não é suportada em repositórios",
"No repository" => "Sem repositório",
"Search is mandatory field" => "Busca é um campo mandatório",
"File not found " => "Arquivo não encontrado ",
"Requested action in not supported on repository" => "Ação de requisição não é suportada no repositório",
"Non-existent link" => "Link inexistente",
"Mail-in account %s incorrect" => "Conta %s mail-in incorreta",
"Mail-in account %s saved" => "Conta %s mail-in salva",
"Frequency should be a positive integer!" => "Frequëncia deveria ser um inteiro positivo!",
"Mail-in accounts set to be checked every %s minutes" => "Contas de mail-in configuradas para serem chegas a cada %s minutos",
"Automatic Mail-in accounts checking disabled" => "Checar automaticamente contas de mail-in desabilitado",
"No menu indicated" => "Nenhum menu foi indicado",
"Cannot create or update module: You need to specify a name to the module" => "Não foi possível criar ou atualizar o módulo: você precisa especificar um nome para ele",
"Cannot create or update module: You cannot leave the data field empty" => "Não foi possível criar ou atualizar o módulo: você não pode deixar o campo 'data' em branco",
"No newsletter indicated" => "Nenhum comunicado foi indicado",
"No poll indicated" => "Nenhuma enquete foi indicada",
"unsafe" => "inseguro",
"register_globals should be off by default. See the php manual for details." => "register_globals deve estar desligado por padrão. Veja o manual do php para detalhes.",
"safe" => "seguro",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid deve estar desligada por padrão. Veja o manual do php para detalhes.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir provavelmente está no seu diretório do Tikiwiki. Existe um risco de alguém enviar qualquer arquivo para esse diretório e acessá-lo pelo navegador da internet",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "não foi possível checar se o upload_tmp_dir está acessível pelo navegador. Para ter certeza você deve checar a configuração do seu servidor web.",
"risky" => "arriscado",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen pode ser utilizado para subir remotamente dados ou scripts. Se você não usa blogs, é melhor deixar essa opção desabilitada.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "O patch para guardar arquivos na galeria de arquivos deve estar fora do diretório principal do tiki",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "O patch para guardar arquivos na galeria de imagens deve estar fora do diretório principal do tiki",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "O recurso  \"Editar templates\" está ativado. Não permita que esse recurso seja utilizado por quem você não pode confiar. Com ele pode-se facilmente injetar código PHP.",
"installed" => "instalado",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "O \"Wikiplugin Snarf\" esta instalado. Ele pode ser utilizado pelos editores wiki para incluir páginas localmente e criar html por substituição de expressões regulares.",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "O \"Wikiplugin Regex\" esta instalado. Ele pode ser utilizado pelos editores wiki para criar html por substituição de expressões regulares.",
"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "O \"Wikiplugin Lsdir\" está instalado. Ele pode ser utilizado pelos editores para visualizar o conteúdo de diretórios.",
"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "O \"Wikiplugin Bloglist\" esta instalado. Ele pode ser usado por editores wiki para mostrar blogs restritos.",
"SQL injection" => "Injeção SQL",
"SQL injection by authenticated user" => "Injeção SQL para usuários autenticados",
"SQL injection by authenticated user with special privileges" => "Injeção SQL apenas para usuários autenticados e com privilégios especiais.",
"SQL injection without authentication" => "Injeção SQL sem autenticação",
"PHP command injection" => "Injeção de comando PHP",
"PHP command injection by authenticated user" => "Injeção de comando PHP para usuário autenticado",
"PHP command injection by authenticated user with special privileges" => "Injeção de comando PHP apenas para usuários autenticados e com privilégios especiais.",
"PHP command injection without authentication" => "Injeção de comando PHP sem autenticação",
"File upload" => "Subir arquivo",
"File is not readable. Unable to check." => "Arquivo não esta disponível para a leitura. Impossível checar.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Esse arquivo não é um arquivo do Tikiwiki. Cheque se ele foi enviado por upload e se ele é perigoso.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Esse é um arquivo modificado. Não foi possível checar a versão. Verifique se ele pode ser perigoso.",
"This file is from another Tikiwiki version: " => "Esse arquivo é de uma outro versão do Tikiwiki: ",
" or " => " ou ",
"You have to provide a word" => "Você precisa especificar uma palavra",
"You must specify a page name, it will be created if it doesn't exist." => "Você deve especificar um nome de página, que pode ser criada se não existir.",
"page not added (Exists)" => "página não adicionada (pré-existente)",
"No survey indicated" => "Nenhuma pesquisa foi indicada",
"You don't have permission to use this feature" => "Você não tem permissão para usar esse recurso",
"No Errors detected" => "Nenhum erro detectado",
"No tracker indicated" => "Nenhum acompanhamento foi indicado",
"Group already exists" => "Grupo já existente",
"No records were found. Check the file please!" => "Nenhum registro encontrado. Por favor, verifique o arquivo.",
"User login is required" => "O login do usuário é obrigatório",
"Password is required" => "A senha é obrigatória",
"Email is required" => "O endereço de e-mail é obrigatório",
"Login contains invalid characters" => "O nome do usuário contém caracteres inválidos",
"User is duplicated" => "Usuário duplicado",
"Created account %s <%s>" => "Criada a conta %s <%s>",
"Assigned %s in group %s" => "Associado %s no grupo %s",
"User %s already exists" => "Usuário %s já existe",
"User login contains invalid characters" => "O nome do usuário contém caracteres inválidos",
"New %s created with %s %s." => "Novo %s criado com %s %s.",
"Impossible to create new %s with %s %s." => "Impossível criar novo %s com %s %s.",
"%s %s successfully deleted." => "%s %s deletado com sucesso.",
"%s %s removed from %s %s." => "%s %s removido de %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> deletado com sucesso.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> associado a %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removido de %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "grupo <b>%s</b> definido como grupo padrão do usuário <b>%s</b>.",
"User already exists" => "O usuário já existe",
"The passwords dont match" => "As senhas não coincidem",
"Password must contain both letters and numbers" => "A senha deve ser composta de letras e algarismos",
"%s modified successfully." => "%s modificado com sucesso.",
"%s modification failed." => "%s modificação falhou.",
"%s changed from %s to %s" => "%s mudou de %s para %s",
"Impossible to change %s from %s to %s" => "Impossível alterar %s de %s para %s",
"rss feed disabled" => "campo rss desabilitado",
"Permission denied you cannot view this section" => "Permissão negada: você não pode ver esta seção",
"Tiki RSS feed for articles" => "Fonte RSS para artigos",
"Last articles." => "Últimos Artigos.",
"Unknown group" => "Grupo desconhecido",
"Group doesnt exist" => "O grupo não existe",
"Unknown user" => "Usuário desconhecido",
"User doesnt exist" => "O usuário não existe",
"You have to indicate a group" => "Você precisa indicar um grupo",
"This group is invalid" => "Esse grupo não é válido",
"Permission denied you cannot view backlinks for this page" => "Permissão negada: você não pode ver referências a esta página",
"The page cannot be found" => "A página não pôde ser encontrada",
"Image Galleries Admin Panel" => "Painel de administração da galeria de imagens",
"Could not read image %s." => "Não possível possível ler a imagem %s.",
"Image %s upload failed." => "Upload da imagem %s falhou.",
"Image %s uploaded successfully." => "Imagem %s enviada com sucesso.",
"Image %s removed from Batch directory." => "Imagem %s removida do diretório em lote.",
"Impossible to remove image %s from Batch directory." => "Impossível remover imagem %s do diretório em lote.",
"Permission denied you cannot use the batch directory loading" => "Permissão negada, você não pode usar a função para carregar diretórios em lote",
"Incorrect directory chosen for batch upload of images." => "Diretório selecionado incorreto para fazer o upload de imagens em lote.",
"Please setup that dir on " => "Por favor configure aquele diretório ",
"Please contact the website administrator." => "Por favor contate o administrador do site.",
"Invalid directory name" => "Nome de diretório inválido",
"Permission denied you cannot post" => "Permissão negada: você não pode enviar mensagens",
"Permission denied you cannot edit this post" => "Permissão negada: você não pode editar esta mensagem",
"You can't post in any blog maybe you have to create a blog first" => "Você não pode escrever em nenhum blog: talvez você deva criar um blog antes",
"Top visited blogs" => "Blogs mais visitados",
"Last posts" => "Últimas mensagens",
"Top active blogs" => "Blogs mais ativos",
"No blogId specified" => "Nenhum ID de blog especificado",
"Tiki RSS feed for weblogs" => "Fonte RSS do tiki para weblogs",
"Last posts to weblogs." => "Últimas mensagens para weblogs.",
"Permission denied you cannot view this page" => "Permissão negada, você não pode ver esta página",
"Permission denied you cannot access this gallery" => "Permissão negada: você não pode acessar esta galeria",
"No gallery indicated" => "Nenhuma galeria foi indicada",
"Please login" => "Faça o login",
"Permission denied you can not view this section" => "Permissão negada: você não pode ver esta seção",
"Permission denied you cannot remove images from this gallery" => "Permissão negada: você não pode remover imagens desta galeria",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Permissão negada: você não pode recriar miniaturas nesta galeria",
"Permission denied you cannot rotate images in this gallery" => "Permissão negada: você não pode rotacionar imagens nesta galeria",
"No image indicated" => "Nenhuma imagem foi indicada",
"Permission denied you cannot move images from this gallery" => "Permissão negada: você não pode mover imagens desta galeria",
"Permission denied you cannot view the calendar" => "Permissão negada: você não pode visualizar o calendário",
"event without name" => "evento sem nome",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Primeiro dia da semana: Domingo (o ID é 0)",
"%m/%d" => "%d/%m",
"Access Denied" => "Acesso Proibido",
"Upcoming events." => "Próximos eventos.",
"Start:" => "Início:",
"End:" => "Fim:",
"No category indicated" => "Nenhuma categoria indicada",
"Permission denied; you cannot assign permissions for this category" => "Permissão negada; você não pode associar permissões para essa categoria",
"The passwords didn't match" => "As senhas informadas não conferem",
"You can not use the same password again" => "Esta senha não pode ser novamente utilizada",
"Invalid old password" => "Senha antiga inválida",
"Permission denied to use this feature" => "Permissão negada para usar este recurso.",
"No channel indicated" => "Nenhum canal indicado",
"No nickname indicated" => "Nenhum apelido indicado",
"Top authors" => "Autores mais produtivos",
"ERROR: you must include a subject or a message at least" => "ERRO: você deve incluir um assunto ou, pelo menos, uma mensagem",
"Message sent to" => "Mensagem enviada para",
"You need to change chmod 'whelp' manually to 777" => "Você deve mudar manualmente o chmod de 'whelp' para 777",
"This feature has been disabled" => "Este recurso foi desabilitado",
"Tiki RSS feed for directory sites" => "Fonte RSS para diretório de sites",
"Last sites." => "Últimos sites.",
"Must enter a name to add a site. " => "Deve digitar um nome para adicionar um site. ",
"Must enter a url to add a site. " => "Deve digitar uma url para adicionar um site. ",
"URL already added to the directory. Duplicate site? " => "URL já foi adicionada ao diretório. Duplicar o site? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "A URL não pode ser acessada. URL errada ou o site está fora do ar e não pode ser adicionado ao diretório. ",
"Must select a category. " => "Deve selecionar uma categoria. ",
"Must enter a name to add a site" => "É preciso digitar um nome para o site",
"Must enter a url to add a site" => "É preciso digitar um endereço para o site",
"URL already added to the directory. Duplicate site?" => "URL já presente no diretório. Site duplicado?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL não pode ser acessada: URL errada ou o site está fora do ar e não pode ser adicionado ao diretório",
"Must select a category" => "É preciso selecionar uma categoria",
"No site indicated" => "Nenhum site indicado",
"No parent specified" => "Nenhum parentesco especificado",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Últimos sites do diretório \".\$rc[\"name\"].\" .",
"You can not download files" => "Você não pode baixar arquivos",
"Error : The file %s doesn't exist." => "Erro : o arquivo %s não existe.",
"Permission denied you cannot edit this article" => "Permissão negada: você não pode editar este artigo",
"The language can't be changed as its set of translations has already this language" => "O idioma não pode ser alterado pois ele já se encontra no espaço de traduções",
"You do not have permissions to edit banners" => "Você não possui permissão de editar banners",
"Banner not found" => "Banner não encontrado",
"You do not have permission to edit this banner" => "Você não possui a permissão para editar este banner",
"Permission denied you cannot create or edit blogs" => "Permissão negada: você não pode criar ou editar blogs",
"Permission denied you cannot edit this blog" => "Permissão negada: você não pode editar este blog",
"You do not have permission to write the style sheet" => "Você não tem permissão para editar a style sheet",
"Invalid request to edit an image" => "Requisição inválida para editar uma imagem",
"Permission denied you cannot edit images" => "Permissão negada: você não pode editar imagens",
"Permission denied you can edit images but not in this gallery" => "Permissão negada: você pode editar imagens, mas não nesta galeria",
"Failed to edit the image" => "Falha ao tentar editar a imagem",
"Shortname must be 2 Characters" => "O nome abreviado deve ter 2 caracteres",
"You must provide a longname" => "Você tem que fornecer um nome completo",
"Language created" => "Língua criada",
"No content id indicated" => "Não foi indicado um id de conteúdo",
"No question indicated" => "Nenhuma questão indicada",
"No quiz indicated" => "Nenhum teste indicado",
"No structure indicated" => "Nenhuma estrutura indicada",
"Invalid structure_id or page_ref_id" => "structure_id inválida ou page_ref_id",
"Permission denied you cannot send submissions" => "Permissão negada: você não pode enviar artigos",
"Permission denied you cannot edit submissions" => "Permissão negada: você não pode editar artigos pendentes",
"You have to create a topic first" => "Você deve criar um tópico antes de prosseguir",
"You do not have permission to do that" => "Você não possui a permissão necessária",
"You do not have permission to write the template:" => "Você não tem permissão para escrever no template:",
"You do not have permission to read the template" => "Você não possui a permissão de ler o padrão",
"No topic id specified" => "Nenhum ID de tópico especificado",
"Invalid topic id specified" => "ID de tópico especificado inválido",
"No object indicated" => "Nenhum objeto indicado",
"No type indicated" => "Nenhum tipo indicado",
"Article not found" => "Artigo não encontrado",
"Permission denied you cannot edit this page" => "Permissão negada: você não pode editar esta página",
"page imported" => "página importada",
"created from import" => "criada a partir de uma importação",
"Can't import remote HTML page" => "Não posso importar a página HTML remota",
"Can't parse remote HTML page" => "Não posso analisar a página HTML remota",
"You cannot edit this page because it is a user personal page" => "Você não pode editar esta página porque ela é a página pessoal de alguém",
"The SandBox is disabled" => "A Bancada de testes está desabilitada",
"Cannot edit page because it is locked" => "A página não pode ser editada enquanto estiver travada",
"unknown error" => "erro desconhecido",
"cannot be found" => "não pode ser achado",
"No permission to view the page" => "Sem permissões para visualizar a página",
"No questions group indicated" => "Sem grupo de questões indicado",
"Permission denied you cannot create galleries and so you cant edit them" => "Permissão negada: você não pode criar galerias ou editá-las",
"Permission denied you cannot edit this gallery" => "Permissão negada: você não pode editar esta galeria",
"Permission denied you cannot remove this gallery" => "Permissão negada: você não pode remover esta galeria",
"Top visited file galleries" => "Galerias de arquivo mais visitadas",
"Most downloaded files" => "Arquivos mais baixados",
"Last files" => "Arquivos recentes",
"Tiki RSS feed for file galleries" => "Fonte RSS do tiki para galeria de arquivos",
"Last files uploaded to the file galleries." => "Últimos arquivos enviados para a galeria de arquivos.",
"No galleryId specified" => "Nenhum ID de galeria especificado",
"Tiki RSS feed for the file gallery: " => "Fonte RSS para galeria de arquivos: ",
"No forum indicated" => "Nenhum fórum indicado",
"Forum posts" => "Mensagens do Fórum",
"No forumId specified" => "Nenhum ID de fórum especificado",
"Tiki RSS feed for forum: " => "Fonte RSS para fórum: ",
"Tiki RSS feed for forums" => "Fonte RSS para fóruns",
"Last topics in forums." => "Últimos tópicos nos Fóruns.",
"Accepted friendship request from %s" => "Pedido para entrar na rede de amigos de %s aceito",
"Refused friendship request from %s" => "Pedido para entrar na rede de amigos de %s recusado",
"Broke friendship with %s" => "Romper amizade com %s",
"I have broken our friendship!" => "Eu rompi nossa amizade!",
"You must be logged in to use this feature" => "Você precisa estar logado para usar essa função",
"Friendship request sent to %s" => "Pedido de amizade enviado para %s",
"You're already friend of %s" => "Você já é amigo de %s",
"Invalid username" => "Usuário inválido",
"I have accepted your friendship request!" => "Eu aceitei seu convite para entrar na sua rede de amigos!",
"I have refused your friendship request!" => "Eu recusei o seu convite para entrar na sua rede de amigos!",
"No process indicated" => "Nenhum processo indicado",
"Activity name already exists" => "Nome repetido para a atividade",
"indicates if the process is active. Invalid processes cant be active" => "indica se o processo está ativo. Processos inválidos não podem ser ativados",
"No instance indicated" => "Nenhuma instância indicada",
"No activity indicated" => "Nenhuma atividade editada",
"The process name already exists" => "Nome repetido para o processo",
"Process already exists" => "Processo já existente",
"You cant execute this activity" => "Você não pode editar esta atividade",
"You couldn't abort a instance" => "Você não pode abortar uma instância",
"You couldn't exception a instance" => "Você não pode fazer uma exceção em uma instância",
"No user indicated" => "Nenhum usuário indicado",
"No title indicated" => "Nenhum título indicado",
"No comment indicated" => "Nenhum comentário indicado",
"No date indicated" => "Nenhuma data indicada",
"No item indicated" => "Nenhum ítem indicado",
"first uploaded image" => "primeira imagem enviada",
"last uploaded image" => "última imagem enviada",
"random image" => "imagem aleatória",
"Permission denied you cannot make the map of this gallery" => "Permissão negada, você não pode fazer o mapa dessa galeria",
"Top images" => "Imagens mais populares",
"Last images" => "Imagens recentes",
"Back to preferences" => "Voltar para preferências",
"No sheet specified." => "Nenhuma planilha especificada.",
"You must select a renderer." => "Você deve selecionar um renderizador.",
"Invalid Series for current graphic." => "Séries inválidas para o gráfico atual.",
"Tiki RSS feed for image galleries" => "Fonte RSS do tiki para a galeria de imagens",
"Last images uploaded to the image galleries." => "Últimas imagens enviadas para a galeria de imagens.",
"Tiki RSS feed for the image gallery: " => "Fonte RSS para galeria de imagens: ",
"overwriting old page" => "sobrescrevendo página antiga",
"updated from structured text import" => "atualizado a partir de uma exportação em texto estruturada",
"page created" => "página criada",
"created from structured text import" => "criado a partir de uma exportação em texto estruturada",
"No repository given" => "Nenhum repositório conhecido",
"Permission denied you cannot view pages like this page" => "Permissão negada: você não pode ver páginas como esta",
"Permission denied you cannot remove articles" => "Permissão negada: você não pode remover artigos",
"Permission denied you cannot remove banners" => "Permissão negada: você não pode remover banners",
"Permission denied you cannot remove this blog" => "Permissão negada: você não pode remover este blog",
"Non-existent gallery" => "Galeria inexistente",
"Permission denied you cannot remove files from this gallery" => "Permissão negada: você não pode remover arquivos desta galeria",
"Permission denied you can't upload files so you can't edit them" => "Permissão negada: você não pode carregar arquivos, de modo que não pode editá-los",
"Permission denied you cannot edit this file" => "Permissão negada: você não pode editar este arquivo",
"This gallery does not exist" => "Essa galeria não existe",
"The game file must have .swf or .dcr extension" => "O arquivo do jogo deve ter extensão .swf ou .dcr",
"The thumbnail name must be" => "O nome da miniatura deve ser",
"Please supply both files" => "Por favor suporte ambos os arquivos",
"You cannot admin blogs" => "Você não pode administrar blogs",
"Permission denied you cannot remove submissions" => "Permissão negada: você não pode remover assinaturas",
"Permission denied you cannot approve submissions" => "Permissão negada: você não pode aprovar assinaturas",
"Permission denied you cannot view pages" => "Permissão negada: você não pode ver páginas",
"Permission denied you cannot remove pages" => "Permissão negada: você não pode remover páginas",
"You have to enable cookies to be able to login to this site" => "Você deve habilitar os cookies para se autenticar neste site",
"XMLRPC Error: " => "Erro XMLRPC: ",
"Unable to create login" => "Não foi possível criar o login",
"Account validated successfully." => "Validação da conta confirmada.",
"Sorry, you can't use this feature." => "Desculpe, você não pode usar essa função.",
"changed" => "alterada",
"You do not have permissions to view the maps" => "Você não possui permissões para ver os mapas",
"Maps feature is not correctly setup : Maps path is missing." => "Os recursos dos mapas não estão configurados corretamente: Faltando a pasta Mapas.",
"Please create a directory named \$map_path to hold your map files." => "Por favor, crie um diretório chamado \$map_path para guardar seus arquivo de mapa.",
"mapfile name incorrect" => "nome do arquivo de mapa incorreto",
"This mapfile already exists" => "Este arquivo de mapa já existen",
"You do not have permission to write to the mapfile" => "Você não tem permissão para escrever no arquivo de mapa",
"You do not have permission to delete the mapfile" => "Você não tem permissão para remover o arquivo de mapa",
"I could not make a copy" => "Não foi possível fazer uma cópia",
"You do not have permission to read the mapfile" => "Você não tem permissão para ler o arquivo de mapa",
"You dont have permission to do that" => "Você não tem permissão para fazer isso",
"Tiki RSS feed for maps" => "Fonte RSS para mapas",
"List of maps available." => "Lista dos mapas disponíveis.",
"You do not have permissions to view the layers" => "Você não tem permissão para ver as camadas",
"Could not upload the file" => "Não é possível carregar o arquivo",
"You do not have permissions to delete a file" => "Você não tem permissão para remover o arquivo",
"File not found" => "Arquivo não encontrado",
"You do not have permissions to create a directory" => "Você não tem permissão para criar um diretório",
"The Directory is not empty" => "O Diretório não está vazio",
"You do not have permissions to delete a directory" => "Você não tem permissão para remover um diretório",
"You do not have permissions to create an index file" => "Você não tem permissão para criar um arquivo índice",
"Invalid file name" => "Nome de arquivo inválido",
"Invalid files to index" => "Arquivos inválidos para índice",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Eu não sei onde está o gdaltindex. Configure corretamente a funcionalidade de mapa",
"I could not create the index file" => "Eu não posso criar o arquivo de índice",
"Must be logged to use this feature" => "Você deve se logar para usar este recurso",
"Welcome at Hawiki" => "Bem-vindo(a) a Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Este site Tikiwiki está preparado para ser acessado de uma gama de dispositivos móveis, como celulares WAP, PDAs, dispositivos i-mode e muitos outros.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Você pode navegar neste site com seu dispositivo móvel apontando o browser dele para o seguinte endereço deste site:",
"About" => "Sobre",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Você precisa rodar o script setup.sh :<br />./setup.sh \$APACHEUSER all<br />Usuários comuns no apache são: www-data, apache ou nobody",
"Your PHP installation does not have zlib enabled." => "Sua versão do PHP não tem o zlib habilitado.",
"You must log in to use this feature" => "Você deve se logar para usar este recurso",
"You do not have permission to view other users data" => "Você não possui permissão para ver dados de outros usuários",
"You must be logged in to subscribe to newsletters" => "Você precisa se logar para assinar os comunicados",
"No server indicated" => "Nenhum servidor indicado",
"Cannot connect to" => "Impossível conectar-se a",
"Missing information to read news (server,port,username,password,group) required" => "A informação necessária para ler news (servidor, porta, username, senha, grupo) não foi fornecida",
"Cannot get messages" => "Impossível baixar as mensagens",
"No note indicated" => "Nenhuma nota indicada",
"merged note:" => "nota composta:",
"File is too big" => "O arquivo é grande demais",
"created from notepad" => "criado a partir do Bloco de Notas",
"No name indicated for wiki page" => "Nome não indicado para a página Wiki",
"Page already exists" => "Página já existe",
"Permission denied you cannot assign permissions for this page" => "Permissão negada: você não pode definir permissões para esta página",
"Not enough information to display this page" => "Informações insuficientes para exibir esta página",
"Permission denied you cannot browse this page history" => "Permissão negada: você não pode visualizar o histórico desta página",
"No article indicated" => "Nenhum artigo indicado",
"Article is not published yet" => "Artigo ainda não foi publicado",
"No post indicated" => "Nenhuma mensagem indicada",
"Blog not found" => "Blog não encontrado",
"No pages indicated" => "Nenhuma página indicada",
"Pageviews" => "Número de vezes que a página foi visualizada",
"You don't have permission to edit quizzes." => "Você não tem permissão para editar os testes.",
"No result indicated" => "Nenhum resultado indicado",
"Permision denied" => "Permissão negada",
"Registered" => "Registrado",
"Wrong registration code" => "Código de registro incorreto",
"Username is too long" => "Identificador de usuário muito longo",
"Username cannot contain whitespace" => "Identificador de usuário não pode conter espaços",
"Wrong passcode you need to know the passcode to register in this site" => "Código de registro incorreto; você precisa fornecer um código válido para registrar-se neste site",
"Invalid email address. You must enter a valid email address" => "Endereço de email inválido. Você precisa fornecer um endereço de email válido",
"Invalid username or activation code. Maybe this code has already been used." => "Usuário ou código de ativação inválido. Talvez o código já tenha sido usado.",
"Unable to send mail. User has not configured email" => "Não foi possível enviar e-mail. O usuário não configurou um endereço eletrônico",
"The mail can't be sent. Contact the administrator" => "Não foi possível enviar o e-mail. Por favor contate o administrador do site",
"A password and your IP address reminder email has been sent " => "Uma senha e seu endereço de IP foram enviados para seu endereço eletrônico ",
"A new (and temporary) password and your IP address has been sent " => "Uma nova senha temporária foi enviada, junto com seu endereço IP ",
"to the registered email address for" => "para o endereço de email registrado para",
"Invalid or unknown username" => "Usuário desconhecido ou inválido",
"Permission denied you cannot remove versions from this page" => "Permissão negada: você não pode remover versões desta página",
"Permission denied you cannot rename this page" => "Você não tem permissão para renomear essa página",
"Cannot rename page because the new name begins with reserved prefix" => "Não foi possível renomear a página pois o novo nome começa com um prefixo que está reservado",
"Cannot rename page maybe new page already exists" => "Impossível renomear a página: talvez já exista uma página com este nome",
"changed '%s' from '%s' to '%s'" => "alterado '%s' de '%s' para '%s'",
"Non-existent version" => "Versão inexistente",
"Permission denied you cannot rollback this page" => "Permissão negada: você não pode restaurar esta página",
"Error Message" => "Mensagem de erro",
"Tiki RSS Feed Error Message: \$errmsg" => "Mensagem de erro dos fontes RSS do tiki: \$errmsg",
"Post recommendation at" => "Envie recomendações em",
"One of the email addresses you typed is invalid" => "Um dos endereços de e-mail digitados não é válido",
"No newsletters available." => "Nenhuma newsletters disponível.",
" successfully sent" => " enviada com sucesso",
" not sent" => " não enviada",
"Error: " => "Erro: ",
"An error occurred." => "Ocorreu um erro.",
"You do not have permission to edit messages" => "Você não possui permissão para editar mensagens",
"This feature is for admins only" => "Este recurso é apenas para administradores",
"Page must be defined inside a structure to use this feature" => "A página tem que ser definida dentro de uma estrutura para o uso deste recurso",
"You cannot take this quiz twice" => "Você não pode fazer este teste mais de uma vez",
"Quiz time limit exceeded quiz cannot be computed" => "Limite de tempo do teste atingido: a nota não será calculada",
"You cannot take this survey twice" => "Você não pode responder a esta pesquisa mais de uma vez",
"Please create a category first" => "Por favor, selecione antes uma categoria",
"empty" => "vazio",
"No trackerId specified" => "trackerId não especificado",
"Tiki RSS feed for individual trackers: " => "Fontes RSS do tiki para acompanhamentos individuais: ",
"Invalid filename (using filters for filenames)" => "Nome inválido de arquivo (usando filtros para nomes de arquivos)",
"No permission to upload zipped file packages" => "Sem permissão para carregar arquivos zipados",
"Cannot read file" => "Impossível ler o arquivo",
"File update was successful" => "Arquivo atualizado com sucesso",
"Permission denied you cannot upload files" => "Permissão negada: você não pode carregar arquivos",
"Could not find the file requested" => "Não foi possível achar o arquivo requisitado",
"Permission denied you can upload files but not to this file gallery" => "Permissão negada: você pode carregar arquivos mas não nesta galeria de arquivos",
"Error processing zipped image package" => "Erro tentando processar arquivo zipado de imagem",
"No permission to upload zipped image packages" => "Sem permissão para carregar arquivos zipados de imagem",
"The uploaded file ist not recognized as a image" => "O arquivo enviado não foi reconhecido como imagem",
"Permission denied you cannot upload images" => "Permissão negada: você não pode carregar imagens",
"Permission denied you can upload images but not to this gallery" => "Permissão negada: você pode carregar imagens mas não nesta galeria",
"Cannot get image from URL" => "Impossível obter a imagem a partir do endereço",
"That is not an image (or you have php < 4.0.5)" => "Isto não é uma imagem (ou você tem o PHP < 4.0.5)",
"cannot process upload" => "impossível processar a carga",
"Usage" => "Uso",
"No url indicated" => "Nenhum endereço indicado",
"You are not logged in and no user indicated" => "Você não está logado e nenhum usuário foi indicado",
"The user has chosen to make his information private" => "O usuário preferiu manter sua informação sob sigilo",
"Invalid password.  Your current password is required to change administrative information" => "Senha inválida. Sua senha é necessária para mudar as informações administrativas",
"Email is set to %s" => "E-mail definido como %s",
"The passwords did not match" => "As senhas não coincidem",
"was moved into trash" => "foi movido para a lixeira",
"trashed by" => "deletado por",
"Rights by creator" => "Direitos do criador",
"END" => "Fim",
"Percentage" => "Porcentagem",
"Task accepted by creator" => "Tarefa aceita pelo criador",
"Task accepted by task user" => "Tarefa aceita pelo usuário",
"Task NOT accepted by creator" => "Tarefa NÃO aceita pelo criador",
"Task NOT accepted by task user" => "Tarefa NÃO aceita pelo usuário",
"Sorry this task does not exist or you have no rights to view this task" => "Desculpe, essa tarefa não existe ou você não tem permissões para visualiza-la",
"Task entries:" => "Entradas da tarefa:",
"Changes:" => "Mudanças:",
"Info message" => "Mensagem informativa",
"NEW Task" => "Nova tarefa",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Desculpe mas você não tem permissão para enviar tarefas para outros usuários ou os usuários não podem receber tarefas!",
"Changes on Task" => "Mudanças na tarefa",
"You received a new task" => "Você recebeu uma nova tarefa",
"The priority is" => "A prioridade é",
"very low" => "muito baixa",
"low" => "baixa",
"high" => "alta",
"very high" => "muito alta",
"You've to start your work at least on" => "Você precisa começar seu trabalho até",
"You've to finish your work on" => "Você precisa terminar seu trabalho em",
"Login and click the link below" => "Login e clique no link abaixo",
"Please read the task and work on it!" => "Por favor leia as tarefas e trabalhe nelas!",
"Sorry, there was an error while trying to write data into the database" => "Desculpe, houve um erro ao tentar escrever na base de dados",
"Cannot upload this file not enough quota" => "Impossível carregar este arquivo: cota máxima atingida",
"Non-existent user" => "Usuário inexistente",
"No banner indicated" => "Nenhum banner indicado",
"No blog indicated" => "Nenhum blog indicado",
"Permission denied you cannot remove the post" => "Permissão negada: você não pode remover a mensagem",
"No cache information available" => "Informação de cache não disponível",
"No faq indicated" => "Nenhum faq indicado",
"You are not permitted to remove someone else\\'s post!" => "Você não pode remover a mensagem postada por outra pessoa!",
"Wrong password. Cannot post comment" => "Senha incorreta. Impossível enviar comentário",
"Please wait 2 minutes between posts" => "Por favor, aguarde dois minutos entre mensagens",
"No thread indicated" => "Nenhuma seqüência indicada",
"A SheetId is required." => "Id da planilha é necessário.",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Seu endereço de email foi removido da lista de monitoramento deste acompanhamento",
"Your email address has been added to the list of addresses monitoring this tracker" => "Seu endereço de email foi adicionado à lista de monitoramento deste acompanhamento",
"Your email address has been removed from the list of addresses monitoring this item" => "Seu endereço de email foi removido da lista de monitoramento deste tem",
"Your email address has been added to the list of addresses monitoring this item" => "Seu endereço de email foi adicionado à lista de monitoramento deste tem",
"Cancel monitoring" => "Não monitorar mais",
"Monitor" => "Monitorar",
"That tracker don't use extras." => "Aquele acompanhamento não usa extras.",
"No subject" => "Sem assunto",
"Your email was sent" => "Seu email foi enviado",
"Top pages" => "Páginas mais populares",
"Last pages" => "Páginas recentes",
"Tiki RSS feed for the wiki pages" => "Fonte RSS para páginas wiki",
"Last modifications to the Wiki." => "Últimas modificações no wiki.",
"###end###"=>"###end###");
?>
