/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.jgraph.pad.GPDocument;
import org.jgraph.pad.GraphModelFileFormat;
import org.jgraph.pad.GraphModelProviderRegistry;

public class GPFileChooser
extends JFileChooser {
    public static final String LAST_PATH_POSITION = "LastPathPosition";
    public static final String LAST_FILE_FILTER = "LastFileFilter";

    public GPFileChooser(GPDocument gPDocument) {
        this.init(gPDocument);
    }

    public GPFileChooser(GPDocument gPDocument, String string) {
        super(string);
        this.init(gPDocument);
    }

    public GPFileChooser(GPDocument gPDocument, File file) {
        super(file);
        this.init(gPDocument);
    }

    public GPFileChooser(GPDocument gPDocument, FileSystemView fileSystemView) {
        super(fileSystemView);
        this.init(gPDocument);
    }

    public GPFileChooser(GPDocument gPDocument, File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
        this.init(gPDocument);
    }

    public GPFileChooser(GPDocument gPDocument, String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
        this.init(gPDocument);
    }

    protected void init(GPDocument gPDocument) {
        Object object;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    if (actionEvent.getActionCommand() != "ApproveSelection") break block2;
                    try {
                        Preferences.userNodeForPackage(this.getClass()).put(GPFileChooser.LAST_PATH_POSITION, GPFileChooser.this.getSelectedFile().getPath());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null && (propertyChangeEvent.getPropertyName().equals("fileFilterChanged") || propertyChangeEvent.getPropertyName().equals("DialogTypeChangedProperty"))) {
                    FileFilter fileFilter = GPFileChooser.this.getFileFilter();
                    GraphModelFileFormat graphModelFileFormat = GraphModelProviderRegistry.getGraphModelFileFormat(fileFilter);
                    if (graphModelFileFormat == null) {
                        GPFileChooser.this.setAccessory(null);
                    } else if (GPFileChooser.this.getDialogType() == 1) {
                        GPFileChooser.this.setAccessory(graphModelFileFormat.getWriteAccessory());
                    } else if (GPFileChooser.this.getDialogType() == 0) {
                        GPFileChooser.this.setAccessory(graphModelFileFormat.getReadAccessory());
                    }
                    Container container = GPFileChooser.this;
                    while (!(container instanceof Window)) {
                        if (container == null) {
                            return;
                        }
                        container = container.getParent();
                    }
                    if (container != null) {
                        ((Window)container).pack();
                    }
                }
            }
        });
        GraphModelFileFormat[] graphModelFileFormatArray = gPDocument == null ? GraphModelProviderRegistry.getGraphModelFileFormats() : gPDocument.getGraphModelProvider().getGraphModelFileFormats();
        int n = 0;
        while (n < graphModelFileFormatArray.length) {
            object = graphModelFileFormatArray[n];
            this.addChoosableFileFilter(object.getFileFilter());
            ++n;
        }
        try {
            object = Preferences.userNodeForPackage(this.getClass()).get(LAST_PATH_POSITION, System.getProperty("user.home"));
            try {
                this.setCurrentDirectory(new File((String)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                GraphModelFileFormat graphModelFileFormat = GraphModelProviderRegistry.getGraphModelFileFormat((String)object);
                this.setFileFilter(graphModelFileFormat.getFileFilter());
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {}
    }
}

