/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import org.jgraph.GPGraphpad;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.net.GraphNetworkModel;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPGraphUI;
import org.jgraph.pad.GPInternalFrame;
import org.jgraph.pad.GPLibraryPanel;
import org.jgraph.pad.GPOverviewPanel;
import org.jgraph.pad.GraphModelProvider;
import org.jgraph.pad.Rule;
import org.jgraph.pad.Touch;
import org.jgraph.pad.UndoHandler;
import org.jgraph.pad.resources.Translator;
import org.jgraph.utils.Utilities;
import org.jgraph.utils.gui.GPSplitPane;

public class GPDocument
extends JPanel
implements GraphSelectionListener,
ComponentListener,
Printable,
GraphModelListener,
PropertyChangeListener,
Observer {
    protected boolean enableTooltips;
    protected URL file;
    protected GPGraphpad graphpad;
    protected GPSplitPane splitPane;
    protected GPLibraryPanel libraryPanel;
    protected JScrollPane scrollPane;
    protected GPGraph graph;
    protected JDialog overviewDialog;
    protected Rule columnRule;
    protected Rule rowRule;
    protected GraphUndoManager graphUndoManager;
    protected UndoHandler undoHandler;
    protected Touch touch;
    protected boolean modified = false;
    protected static boolean isMetric = true;
    protected static boolean libraryExpanded = true;
    protected static boolean showRuler = true;
    protected Action fitAction;
    protected String findPattern;
    protected Object lastFound;
    protected GPInternalFrame internalFrame;
    protected GraphModelProvider graphModelProvider;
    protected GraphNetworkModel networkModel;
    static /* synthetic */ Class class$org$jgraph$pad$actions$FileSave;

    public GPDocument(GPGraphpad gPGraphpad, URL uRL, GraphModelProvider graphModelProvider, GPGraph gPGraph, GraphModel graphModel, GraphUndoManager graphUndoManager) {
        super(true);
        this.file = uRL;
        this.graphpad = gPGraphpad;
        this.graphModelProvider = graphModelProvider;
        this.undoHandler = new UndoHandler(this, true);
        this.graphUndoManager = graphUndoManager == null ? this.createGraphUndoManager() : graphUndoManager;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.graph = gPGraph;
        this.touch = new Touch(this.graph);
        this.registerListeners(this.graph);
        this.graph.getModel().addUndoableEditListener(this.undoHandler);
        this.networkModel = new GraphNetworkModel(this.graph.getModel());
        Component component = this.createCenterComponent();
        this.add(component);
        this.addComponentListener(this);
        this.setEnableTooltips(false);
        this.update();
    }

    public URL getFilename() {
        return this.file;
    }

    public void setFilename(URL uRL) {
        this.file = uRL;
        this.updateFrameTitle();
    }

    protected Component createCenterComponent() {
        Component component = this.createScrollPane();
        this.libraryPanel = this.createLibrary();
        JPanel jPanel = GPOverviewPanel.createOverviewPanel(this.getGraph(), this);
        GPSplitPane gPSplitPane = new GPSplitPane(0, jPanel, this.libraryPanel);
        ((Component)gPSplitPane).setName("DocumentLibrary");
        this.splitPane = new GPSplitPane(1, gPSplitPane, component);
        this.splitPane.setName("DocumentMain");
        this.splitPane.setOneTouchExpandable(true);
        return this.splitPane;
    }

    protected Component createScrollPane() {
        this.scrollPane = new JScrollPane(this.graph);
        JViewport jViewport = this.scrollPane.getViewport();
        try {
            String string = Translator.getString("ViewportBackingStore");
            Boolean bl = new Boolean(string);
            if (bl.booleanValue()) {
                jViewport.setScrollMode(2);
            } else {
                jViewport.setScrollMode(1);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.columnRule = new Rule(0, isMetric, this.graph);
        this.rowRule = new Rule(1, isMetric, this.graph);
        if (showRuler) {
            this.scrollPane.setColumnHeaderView(this.columnRule);
            this.scrollPane.setRowHeaderView(this.rowRule);
        }
        return this.scrollPane;
    }

    protected GPLibraryPanel createLibrary() {
        return new GPLibraryPanel(Translator.getString("LibraryName"), Utilities.tokenize(Translator.getString("LoadLibraries")), new Integer(Translator.getString("EntrySize")));
    }

    protected GraphUndoManager createGraphUndoManager() {
        return new GraphUndoManager();
    }

    public GPGraph getGraph() {
        return this.graph;
    }

    public GraphModel getModel() {
        return this.graph.getModel();
    }

    protected GPGraphUI getGraphUI() {
        return (GPGraphUI)this.graph.getUI();
    }

    public GraphLayoutCache getGraphLayoutCache() {
        return this.graph.getGraphLayoutCache();
    }

    protected void registerListeners(JGraph jGraph) {
        jGraph.getSelectionModel().addGraphSelectionListener(this);
        jGraph.getModel().addGraphModelListener(this);
        jGraph.getGraphLayoutCache().addObserver(this);
        jGraph.addPropertyChangeListener(this);
    }

    protected void unregisterListeners(JGraph jGraph) {
        jGraph.getSelectionModel().removeGraphSelectionListener(this);
        jGraph.getModel().removeGraphModelListener(this);
        jGraph.removePropertyChangeListener(this);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        this.updateFrameTitle();
        this.graphpad.update();
    }

    protected String getDocumentTitle() {
        String string;
        String string2 = string = this.file != null ? this.file.toString() : Translator.getString("NewGraph");
        if (this.modified) {
            string = string + " *";
        }
        return Translator.getString("Title") + " - " + string;
    }

    protected String getDocumentStatus() {
        String string = null;
        int n = this.graph.getSelectionCount();
        if (n > 0) {
            string = n + " " + Translator.getString("Selected");
        } else {
            int n2 = this.graph.getModel().getRootCount();
            if (n2 == 0) {
                string = Translator.getString("Empty");
            } else {
                string = n2 + " ";
                string = n2 > 1 ? string + Translator.getString("Cells") : string + Translator.getString("Cell");
                n2 = GPGraphpad.getGraphTools().getComponentCount(this.graph);
                string = string + " / " + n2 + " ";
                string = n2 > 1 ? string + Translator.getString("Components") : string + Translator.getString("Component");
            }
        }
        return string;
    }

    protected String getDocumentScale() {
        return Integer.toString((int)(this.graph.getScale() * 100.0)) + "%";
    }

    public void setSelectionAttributes(Map map) {
        Object[] objectArray = DefaultGraphModel.getDescendants(this.graph.getModel(), this.graph.getSelectionCells()).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (!this.graph.isPort(objectArray[n])) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        objectArray = arrayList.toArray();
        map = GraphConstants.cloneMap(map);
        map.remove("bounds");
        map.remove("points");
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            hashtable.put(objectArray[n2], GraphConstants.cloneMap(map));
            ++n2;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void setFontSizeForSelection(float f) {
        Object[] objectArray = DefaultGraphModel.getDescendants(this.graph.getModel(), this.graph.getSelectionCells()).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (!this.graph.isPort(objectArray[n])) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        objectArray = arrayList.toArray();
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(objectArray[n2], false);
            if (cellView != null) {
                Font font = GraphConstants.getFont(cellView.getAllAttributes());
                Map map = GraphConstants.createMap();
                GraphConstants.setFont(map, font.deriveFont(f));
                hashtable.put(objectArray[n2], map);
            }
            ++n2;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void setFontStyleForSelection(int n) {
        Object[] objectArray = DefaultGraphModel.getDescendants(this.graph.getModel(), this.graph.getSelectionCells()).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (!this.graph.isPort(objectArray[n2])) {
                arrayList.add(objectArray[n2]);
            }
            ++n2;
        }
        objectArray = arrayList.toArray();
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n3 = 0;
        while (n3 < objectArray.length) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(objectArray[n3], false);
            if (cellView != null) {
                Font font = GraphConstants.getFont(cellView.getAllAttributes());
                Map map = GraphConstants.createMap();
                GraphConstants.setFont(map, font.deriveFont(n));
                hashtable.put(objectArray[n3], map);
            }
            ++n3;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void setFontNameForSelection(String string) {
        Object[] objectArray = DefaultGraphModel.getDescendants(this.graph.getModel(), this.graph.getSelectionCells()).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (!this.graph.isPort(objectArray[n])) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        objectArray = arrayList.toArray();
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(objectArray[n2], false);
            if (cellView != null) {
                Font font = GraphConstants.getFont(cellView.getAllAttributes());
                Map map = GraphConstants.createMap();
                GraphConstants.setFont(map, new Font(string, font.getStyle(), font.getSize()));
                hashtable.put(objectArray[n2], map);
            }
            ++n2;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void setResizeAction(AbstractAction abstractAction) {
        this.fitAction = abstractAction;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.fitAction != null) {
            this.fitAction.actionPerformed(null);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    public void setScale(double d) {
        d = Math.max(Math.min(d, 16.0), 0.01);
        this.graph.setScale(d);
        this.componentResized(null);
    }

    public void updatePageFormat() {
        PageFormat pageFormat = this.graph.getPageFormat();
        this.columnRule.setActiveOffset((int)pageFormat.getImageableX());
        this.rowRule.setActiveOffset((int)pageFormat.getImageableY());
        this.columnRule.setActiveLength((int)pageFormat.getImageableWidth());
        this.rowRule.setActiveLength((int)pageFormat.getImageableHeight());
        if (this.graph.isPageVisible()) {
            int n = (int)pageFormat.getWidth();
            int n2 = (int)pageFormat.getHeight();
            this.graph.setMinimumSize(new Dimension(n + 5, n2 + 5));
        } else {
            this.graph.setMinimumSize(null);
        }
        this.invalidate();
        this.componentResized(null);
        this.graph.repaint();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3 = (int)pageFormat.getImageableWidth();
        int n4 = (int)pageFormat.getImageableHeight();
        int n5 = this.graph.getWidth() / n3 + 1;
        int n6 = n5 * (n2 = this.graph.getHeight() / n4 + 1);
        if (n >= n6) {
            return 1;
        }
        int n7 = n % n5;
        int n8 = n % n2;
        graphics.translate(-n7 * n3, -n8 * n4);
        graphics.setClip(n7 * n3, n8 * n4, n3, n4);
        this.graph.paint(graphics);
        graphics.translate(n7 * n3, n8 * n4);
        return 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.graphpad != null) {
            this.update();
        }
    }

    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        if (!this.graph.isSelectionEmpty()) {
            this.touch.setDamper(0.0);
        }
        this.update();
    }

    public void update(Observable observable, Object object) {
        this.modified = true;
        this.touch.resetDamper();
        this.update();
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        this.modified = true;
        this.touch.resetDamper();
        this.update();
    }

    protected void update() {
        this.updateFrameTitle();
        this.graphpad.update();
        this.graphpad.getStatusBar().setMessage(this.getDocumentStatus());
        this.graphpad.getStatusBar().setScale(this.getDocumentScale());
    }

    public GraphUndoManager getGraphUndoManager() {
        return this.graphUndoManager;
    }

    public void setGraphUndoManager(GraphUndoManager graphUndoManager) {
        this.graphUndoManager = graphUndoManager;
    }

    public void resetGraphUndoManager() {
        this.graphUndoManager.discardAllEdits();
    }

    public GPGraphpad getGraphpad() {
        return this.graphpad;
    }

    public void setGraphpad(GPGraphpad gPGraphpad) {
        this.graphpad = gPGraphpad;
    }

    public Touch getTouch() {
        return this.touch;
    }

    public void setTouch(Touch touch) {
        this.touch = touch;
    }

    public boolean close(boolean bl) {
        int n = 0;
        if (this.modified) {
            if (bl) {
                n = JOptionPane.showConfirmDialog(this.graphpad.getFrame(), Translator.getString("SaveChangesDialog"), Translator.getString("Title"), 1);
            }
            if (n == 0) {
                this.graphpad.getCurrentActionMap().get(Utilities.getClassNameWithoutPackage(class$org$jgraph$pad$actions$FileSave == null ? (class$org$jgraph$pad$actions$FileSave = GPDocument.class$("org.jgraph.pad.actions.FileSave")) : class$org$jgraph$pad$actions$FileSave)).actionPerformed(null);
                return true;
            }
            return n == 1;
        }
        return true;
    }

    public GPLibraryPanel getLibraryPanel() {
        return this.libraryPanel;
    }

    public String getFindPattern() {
        return this.findPattern;
    }

    public void setFindPattern(String string) {
        this.findPattern = string;
    }

    public Object getLastFound() {
        return this.lastFound;
    }

    public void setLastFound(Object object) {
        this.lastFound = object;
    }

    public JDialog getOverviewDialog() {
        return this.overviewDialog;
    }

    public void setOverviewDialog(JDialog jDialog) {
        this.overviewDialog = jDialog;
    }

    public GPSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void setSplitPane(GPSplitPane gPSplitPane) {
        this.splitPane = gPSplitPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    public Rule getColumnRule() {
        return this.columnRule;
    }

    public Rule getRowRule() {
        return this.rowRule;
    }

    public void setColumnRule(Rule rule) {
        this.columnRule = rule;
    }

    public void setRowRule(Rule rule) {
        this.rowRule = rule;
    }

    public boolean isEnableTooltips() {
        return this.enableTooltips;
    }

    public void setEnableTooltips(boolean bl) {
        this.enableTooltips = bl;
        if (this.enableTooltips) {
            ToolTipManager.sharedInstance().registerComponent(this.graph);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.graph);
        }
    }

    public GPInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    protected void setInternalFrame(GPInternalFrame gPInternalFrame) {
        this.internalFrame = gPInternalFrame;
    }

    protected void updateFrameTitle() {
        if (this.internalFrame != null) {
            this.internalFrame.setTitle(this.getFrameTitle());
        }
    }

    public String getFrameTitle() {
        return (this.file == null ? Translator.getString("NewGraph") : this.file.toString()) + (this.modified ? "*" : "");
    }

    public GraphModelProvider getGraphModelProvider() {
        return this.graphModelProvider;
    }

    public GraphNetworkModel getNetworkModel() {
        return this.networkModel;
    }

    public void setNetworkModel(GraphNetworkModel graphNetworkModel) {
        this.networkModel = graphNetworkModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        libraryExpanded = new Boolean(Translator.getString("LibraryExpanded"));
        isMetric = new Boolean(Translator.getString("IsMetric"));
        showRuler = new Boolean(Translator.getString("ShowRuler"));
    }

    protected class EventRedirector
    implements ActionListener {
        protected Action action;

        public EventRedirector(Action action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = GPDocument.this.graph;
            if (GPDocument.this.libraryPanel.hasFocus()) {
                jComponent = GPDocument.this.libraryPanel;
            }
            actionEvent = new ActionEvent(jComponent, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
            this.action.actionPerformed(actionEvent);
        }
    }
}

