/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.net;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.ParentMap;
import org.jgraph.net.GraphCellFactory;
import org.jgraph.net.GraphNetworkModel;
import org.jgraph.net.GraphNetworkModelListener;
import org.jgraph.pad.DefaultGraphModelFileFormatXML;
import org.jgraph.utils.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GraphNetworkModelPeer
extends Thread {
    protected GraphNetworkModel networkModel;
    protected ServerSocket serverSocket;

    public GraphNetworkModelPeer(int n, GraphNetworkModel graphNetworkModel) {
        this.networkModel = graphNetworkModel;
        try {
            this.serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.start();
    }

    public void run() {
        try {
            while (true) {
                System.out.println("Listening...");
                Socket socket = this.serverSocket.accept();
                System.out.println("New connection...");
                Connection connection = new Connection(socket.getInetAddress().toString(), socket, this.networkModel);
                this.networkModel.addNetworkModelListener(connection);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error: " + iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NPE while listening: Missing permissions?");
        }
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public static class FakeGraphModelChange
    implements GraphModelEvent.GraphModelChange {
        protected Object[] removed;
        protected Object[] inserted;
        protected Map nested;
        protected ConnectionSet cs;
        protected ParentMap pm;

        public FakeGraphModelChange(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
            this.removed = objectArray;
            this.inserted = objectArray2;
            this.nested = map;
            this.cs = connectionSet;
            this.pm = parentMap;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getPreviousAttributes() {
            return this.nested;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return this.cs;
        }

        public ParentMap getPreviousParentMap() {
            return this.pm;
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return null;
        }

        public Object getSource() {
            return null;
        }

        public Object[] getChanged() {
            return null;
        }

        public Map getAttributes() {
            return null;
        }

        public Object[] getContext() {
            return null;
        }
    }

    static class Connection
    extends Thread
    implements GraphNetworkModelListener {
        protected static final DefaultGraphModelFileFormatXML codec = new DefaultGraphModelFileFormatXML();
        protected String name;
        protected Socket client;
        protected BufferedReader client_reader;
        protected PrintWriter client_ostream;
        protected GraphNetworkModel networkModel;

        public Connection(String string, Socket socket, GraphNetworkModel graphNetworkModel) {
            this.name = string;
            this.networkModel = graphNetworkModel;
            System.out.println("Entering Connection constructor");
            this.client = socket;
            try {
                this.client_reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                this.client_ostream = new PrintWriter(this.client.getOutputStream());
            }
            catch (IOException iOException) {
                try {
                    this.client.close();
                }
                catch (IOException iOException2) {
                    System.err.println("Exception while getting socket streams:" + iOException);
                }
                return;
            }
            this.start();
            System.out.println("Leaving Connection constructor");
        }

        public String toString() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block12: {
                while (true) {
                    System.out.println("waiting for data");
                    String string = this.client_reader.readLine();
                    System.out.println("received=" + string);
                    if (string == null) break;
                    GraphModelEvent.GraphModelChange graphModelChange = null;
                    try {
                        graphModelChange = this.decode(string);
                        if (graphModelChange == null) continue;
                        this.networkModel.networkModelChanged(this, graphModelChange.getRemoved(), graphModelChange.getInserted(), graphModelChange.getPreviousAttributes(), graphModelChange.getPreviousConnectionSet(), graphModelChange.getPreviousParentMap());
                    }
                    catch (Exception exception) {
                        System.out.println("Error: " + exception.getMessage());
                    }
                }
                Object var5_5 = null;
                try {
                    this.client.close();
                    this.networkModel.removeNetworkModelListener(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stop();
                {
                    break block12;
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var5_6 = null;
                        try {
                            this.client.close();
                            this.networkModel.removeNetworkModelListener(this);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.stop();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        this.client.close();
                        this.networkModel.removeNetworkModelListener(this);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.stop();
                    throw throwable;
                }
            }
        }

        public void networkModelChanged(GraphNetworkModelListener graphNetworkModelListener, Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
            String string = this.encode(objectArray, objectArray2, map, connectionSet, parentMap);
            if (string != null) {
                this.client_ostream.println(string);
                this.client_ostream.flush();
                System.out.println("sent " + string);
            } else {
                System.out.println("Tried to send null message");
            }
        }

        public String encode(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
            String string;
            Object object;
            int n;
            String string2 = new String("<change>");
            if (objectArray != null && objectArray.length > 0) {
                string2 = string2 + "<remove>";
                n = 0;
                while (n < objectArray.length) {
                    string2 = string2 + this.networkModel.getIdMap().getID(objectArray[n]) + ",";
                    ++n;
                }
                string2 = string2.substring(0, string2.length() - 1);
                string2 = string2 + "</remove>";
            }
            if (objectArray2 != null && objectArray2.length > 0) {
                string2 = string2 + "<add>";
                n = 0;
                while (n < objectArray2.length) {
                    object = this.networkModel.getIdMap().getID(objectArray2[n]);
                    object = (String)object + "_" + GraphCellFactory.getType(objectArray2[n]);
                    string2 = string2 + (String)object + ",";
                    ++n;
                }
                string2 = string2.substring(0, string2.length() - 1);
                string2 = string2 + "</add>";
            }
            if (map != null && map.size() > 0) {
                string2 = string2 + "<attributes>";
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    string2 = string2 + "<map cell=\"" + this.networkModel.getIdMap().getID(object.getKey()) + "\">";
                    string2 = string2 + DefaultGraphModelFileFormatXML.encodeMap("", (Map)object.getValue(), false, null, false).replaceAll("\n", "");
                    string2 = string2 + "</map>";
                }
                string2 = string2 + "</attributes>";
            }
            if (connectionSet != null && connectionSet.size() > 0) {
                string2 = string2 + "<connect>";
                Iterator iterator = connectionSet.connections();
                while (iterator.hasNext()) {
                    object = (ConnectionSet.Connection)iterator.next();
                    string = "target";
                    if (((ConnectionSet.Connection)object).isSource()) {
                        string = "source";
                    }
                    string2 = string2 + "<" + string + ">" + this.networkModel.getIdMap().getID(((ConnectionSet.Connection)object).getEdge());
                    String string3 = this.networkModel.getIdMap().getID(((ConnectionSet.Connection)object).getPort());
                    if (string3 == null) {
                        string3 = "-1";
                    }
                    string2 = string2 + "," + string3 + "</" + string + ">";
                }
                string2 = string2 + "</connect>";
            }
            if (parentMap != null && parentMap.size() > 0) {
                string2 = string2 + "<group>";
                Iterator iterator = parentMap.entries();
                while (iterator.hasNext()) {
                    object = (ParentMap.Entry)iterator.next();
                    string2 = string2 + "<parent>" + this.networkModel.getIdMap().getID(((ParentMap.Entry)object).getChild());
                    string = this.networkModel.getIdMap().getID(((ParentMap.Entry)object).getParent());
                    if (string == null) {
                        string = "-1";
                    }
                    string2 = string2 + "," + string + "</parent>";
                }
                string2 = string2 + "</group>";
            }
            return string2 + "</change>";
        }

        public GraphModelEvent.GraphModelChange decode(String string) throws Exception {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n;
            int n2;
            Object object6;
            Object[] objectArray;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            Object[] objectArray2 = null;
            Node node = null;
            Object[] objectArray3 = null;
            Object[] objectArray4 = null;
            Object[] objectArray5 = null;
            int n3 = 0;
            while (n3 < document.getDocumentElement().getChildNodes().getLength()) {
                objectArray = document.getDocumentElement().getChildNodes().item(n3);
                if (objectArray.getNodeName().toLowerCase().equals("remove")) {
                    node = objectArray;
                } else if (objectArray.getNodeName().toLowerCase().equals("add")) {
                    objectArray2 = objectArray;
                } else if (objectArray.getNodeName().toLowerCase().equals("attributes")) {
                    objectArray3 = objectArray;
                } else if (objectArray.getNodeName().toLowerCase().equals("connect")) {
                    objectArray4 = objectArray;
                } else if (objectArray.getNodeName().toLowerCase().equals("group")) {
                    objectArray5 = objectArray;
                }
                ++n3;
            }
            objectArray = null;
            if (node != null) {
                objectArray = this.networkModel.getIdMap().getObjects(Utilities.tokenize(node.getChildNodes().item(0).getNodeValue(), ","));
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            Object[] objectArray6 = null;
            if (objectArray2 != null) {
                object6 = Utilities.tokenize(objectArray2.getChildNodes().item(0).getNodeValue(), ",");
                n2 = 0;
                while (n2 < ((String[])object6).length) {
                    n = object6[n2].indexOf("_");
                    object5 = object6[n2].substring(0, n);
                    object4 = object6[n2].substring(n + 1, object6[n2].length());
                    object3 = this.networkModel.getIdMap().getObject((String)object5, (String)object4);
                    if (object3 != null) {
                        linkedList.add(object3);
                    }
                    ++n2;
                }
                objectArray6 = linkedList.toArray();
            }
            object6 = null;
            if (objectArray3 != null) {
                object6 = new Hashtable();
                n2 = 0;
                while (n2 < objectArray3.getChildNodes().getLength()) {
                    Node node2 = objectArray3.getChildNodes().item(n2);
                    if (node2.getNodeName().toLowerCase().equals("map") && (object5 = node2.getAttributes().getNamedItem("cell")) != null && (object4 = this.networkModel.getIdMap().getObject(object5.getNodeValue(), null)) != null) {
                        object3 = DefaultGraphModelFileFormatXML.decodeMap(node2, true, true);
                        object6.put(object4, object3);
                    }
                    ++n2;
                }
                System.out.println("Attrs=" + object6);
            }
            ConnectionSet connectionSet = null;
            if (objectArray4 != null) {
                connectionSet = new ConnectionSet();
                n = 0;
                while (n < objectArray4.getChildNodes().getLength()) {
                    object5 = objectArray4.getChildNodes().item(n);
                    object4 = object5.getNodeName().toLowerCase();
                    if (object4.equals("source") || object4.equals("target")) {
                        boolean bl = object4.equals("source");
                        object2 = Utilities.tokenize(object5.getChildNodes().item(0).getNodeValue(), ",");
                        if (((String[])object2).length == 2) {
                            object = this.networkModel.getIdMap().getObject(object2[0], null);
                            Object object7 = this.networkModel.getIdMap().getObject(object2[1], null);
                            if (object != null) {
                                connectionSet.connect(object, object7, bl);
                            }
                        }
                    }
                    ++n;
                }
            }
            ParentMap parentMap = null;
            if (objectArray5 != null) {
                parentMap = new ParentMap();
                int n4 = 0;
                while (n4 < objectArray5.getChildNodes().getLength()) {
                    String[] stringArray;
                    object4 = objectArray5.getChildNodes().item(n4);
                    if (object4.getNodeName().toLowerCase().equals("parent") && (stringArray = Utilities.tokenize(object4.getChildNodes().item(0).getNodeValue(), ",")).length == 2) {
                        object2 = this.networkModel.getIdMap().getObject(stringArray[0], null);
                        object = this.networkModel.getIdMap().getObject(stringArray[1], null);
                        if (object2 != null) {
                            parentMap.addEntry(object2, object);
                        }
                    }
                    ++n4;
                }
            }
            return new FakeGraphModelChange(objectArray, objectArray6, (Map)object6, connectionSet, parentMap);
        }
    }
}

