##############################################################################
#
# ObjectBase.py
# Classes for ObjectBase,Comments,Trackbacks
#
# Copyright (c) 2003-2004 Atsushi Shibata. All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its 
# documentation for any purpose and without fee is hereby granted, provided that
# the above copyright notice appear in all copies and that both that copyright 
# notice and this permission notice appear in supporting documentation, and that
# the name of Atsushi Shibata not be used in advertising or publicity pertaining 
# to distribution of the software without specific, written prior permission. 
# 
# ATSUSHI SHIBAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SHIBAT ATSUSHI BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE. 
#
##############################################################################

__doc__="""ObjectBase"""


class ObjectBase:
    """Baseclass for COREBlog Entry/Comment/Trackback.
        This class imprements date-time features and moderation."""

    def date_created(self):
        """Return DateTime object for Object creation time."""

    def year_created(self):
        """Return year for Object creation time"""

    def month_created(self):
        """Return month for Object creation time"""

    def day_created(self):
        """Return day for Object creation time"""

    def weekday_created(self):
        """Return day of the week for Object creation time"""

class Comment(ObjectBase):
    """Class for COREBlog Comments.
        This class holds informations for comments,body,author,email,URL."""

    def index_html(self,REQUEST):
        """ Comment presentation """
        return self.comment_html(self,REQUEST)

class Trackback(ObjectBase):
    """Class for COREBlog Trackback item.
        This class holds informations for trackbacks,title,excerpt,URL,blog_name."""


class SendingTrackback(ObjectBase):
    """Class for COREBlog Trackback - sending to another blog."""

    def post_trackback(self,src_url,blog_name,title,excerpt,charcode="",fromcode=""):
        """Post a trackback and return result code."""

