/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;

public abstract class PersistentManagerBase
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
Runnable {
    private int checkInterval = 60;
    private static final String info = "PersistentManagerBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static String name = "PersistentManagerBase";
    private boolean started = false;
    private Hashtable sessionSwapIgnore = new Hashtable();
    private Thread thread = null;
    protected boolean threadDone = false;
    private String threadName = "PersistentManagerBase";
    private Store store = null;
    private boolean saveOnRestart = true;
    private int maxIdleBackup = -1;
    private int minIdleSwap = -1;
    private int maxIdleSwap = -1;

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", new Integer(oldCheckInterval), new Integer(this.checkInterval));
    }

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", new Integer(oldBackup), new Integer(this.maxIdleBackup));
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", new Integer(oldMaxIdleSwap), new Integer(this.maxIdleSwap));
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", new Integer(oldMinIdleSwap), new Integer(this.minIdleSwap));
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    public String getName() {
        return name;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", new Boolean(oldSaveOnRestart), new Boolean(this.saveOnRestart));
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            this.store.clear();
        }
        catch (IOException e) {
            this.log("Exception clearing the Store: " + e);
            e.printStackTrace();
        }
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    public boolean isLoaded(String id) {
        try {
            if (super.findSession(id) != null) {
                return true;
            }
        }
        catch (IOException e) {
            this.log("checking isLoaded for id, " + id + ", " + e.getMessage(), e);
        }
        return false;
    }

    public Session findSession(String id) throws IOException {
        Session session = super.findSession(id);
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    public void load() {
        this.recycled.clear();
        this.sessions.clear();
        if (this.store == null) {
            return;
        }
        String[] ids = null;
        try {
            ids = this.store.keys();
        }
        catch (IOException e) {
            this.log("Can't load sessions from store, " + e.getMessage(), e);
            return;
        }
        int n = ids.length;
        if (n == 0) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("persistentManager.loading", String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapIn(ids[i]);
                continue;
            }
            catch (IOException e) {
                this.log("Failed load session from store, " + e.getMessage(), e);
            }
        }
    }

    public void remove(Session session) {
        super.remove(session);
        if (this.store != null) {
            try {
                this.store.remove(session.getId());
            }
            catch (IOException e) {
                this.log("Exception removing session  " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n = sessions.length;
        if (n == 0) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("persistentManager.unloading", String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapOut(sessions[i]);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected Session swapIn(String id) throws IOException {
        if (this.store == null) {
            return null;
        }
        if (this.sessionSwapIgnore.contains(id)) {
            return null;
        }
        Session session = null;
        try {
            session = this.store.load(id);
        }
        catch (ClassNotFoundException e) {
            this.log(sm.getString("persistentManager.deserializeError", id, e));
            throw new IllegalStateException(sm.getString("persistentManager.deserializeError", id, e));
        }
        if (session == null) {
            this.sessionSwapIgnore.put(id, id);
            return null;
        }
        if (!session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
            this.log("session swapped in is invalid or expired");
            session.expire();
            this.store.remove(id);
            this.sessionSwapIgnore.put(id, id);
            return null;
        }
        if (this.debug > 2) {
            this.log(sm.getString("persistentManager.swapIn", id));
        }
        session.setManager(this);
        ((StandardSession)session).tellNew();
        this.add(session);
        ((StandardSession)session).activate();
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
            return;
        }
        try {
            this.store.save(session);
            this.sessionSwapIgnore.remove(session.getId());
        }
        catch (IOException e) {
            this.log(sm.getString("persistentManager.serializeError", session.getId(), e));
            throw e;
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Starting");
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("standardManager.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.debug >= 1) {
            this.log("Force random number initialization starting");
        }
        String dummy = this.generateSessionId();
        if (this.debug >= 1) {
            this.log("Force random number initialization completed");
        }
        if (this.store == null) {
            this.log("No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        if (!this.isStarted()) {
            throw new LifecycleException(sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.setStarted(false);
        this.threadStop();
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid()) continue;
                try {
                    session.expire();
                    continue;
                }
                catch (Throwable t) {
                    this.log(sm.getString("standardManager.expireException"), t);
                }
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        this.random = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                this.log(sm.getString("standardManager.sessionTimeout", event.getNewValue().toString()));
            }
        }
    }

    protected boolean isSessionStale(Session session, long timeNow) {
        long lastAccessed;
        int timeIdle;
        int maxInactiveInterval = session.getMaxInactiveInterval();
        return maxInactiveInterval >= 0 && (timeIdle = (int)((timeNow - (lastAccessed = ((StandardSession)session).getLastUsedTime())) / 1000L)) >= maxInactiveInterval;
    }

    protected void processExpires() {
        if (!this.started) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            StandardSession session = (StandardSession)sessions[i];
            if (!session.isValid() || !this.isSessionStale(session, timeNow)) continue;
            try {
                session.expire();
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("standardManager.expireException"), t);
            }
        }
    }

    protected void processMaxIdleSwaps() {
        if (!this.isStarted() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                long lastAccessed;
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - (lastAccessed = session.getLastUsedTime())) / 1000L)) <= this.maxIdleSwap || timeIdle <= this.minIdleSwap) continue;
                if (this.debug > 1) {
                    this.log(sm.getString("persistentManager.swapMaxIdle", session.getId(), new Integer(timeIdle)));
                }
                try {
                    this.swapOut(session);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    protected void processMaxActiveSwaps() {
        if (!this.isStarted() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.getMaxActiveSessions() >= sessions.length) {
            return;
        }
        if (this.debug > 0) {
            this.log(sm.getString("persistentManager.tooManyActive", new Integer(sessions.length)));
        }
        int toswap = sessions.length - this.getMaxActiveSessions();
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < sessions.length && toswap > 0; ++i) {
            StandardSession session = (StandardSession)sessions[i];
            int timeIdle = (int)((timeNow - session.getLastUsedTime()) / 1000L);
            if (timeIdle <= this.minIdleSwap) continue;
            if (this.debug > 1) {
                this.log(sm.getString("persistentManager.swapTooManyActive", session.getId(), new Integer(timeIdle)));
            }
            try {
                this.swapOut(session);
            }
            catch (IOException e) {
                // empty catch block
            }
            --toswap;
        }
    }

    protected void processMaxIdleBackups() {
        if (!this.isStarted() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastUsedTime()) / 1000L)) <= this.maxIdleBackup) continue;
                if (this.debug > 1) {
                    this.log(sm.getString("persistentManager.backupMaxIdle", session.getId(), new Integer(timeIdle)));
                }
                try {
                    this.writeSession(session);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardManager[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processPersistenceChecks();
            this.sessionSwapIgnore.clear();
        }
    }
}

