/*  Generated by CHR bootstrap compiler
    From: chr_translate.chr
    Date: Sat Mar 15 07:19:08 2008

    DO NOT EDIT.  EDIT THE CHR FILE INSTEAD
*/

:- module(chr_translate,
	  [ chr_translate/2
	  ]).
:- use_module(chr_runtime).
:- style_check(- (discontiguous)).
:- use_module(library(lists),
	      [ member/2,
		append/3,
		reverse/2,
		permutation/2,
		last/2
	      ]).
:- use_module(library(ordsets)).
:- use_module(hprolog).
:- use_module(pairlist).
:- use_module(a_star).
:- use_module(listmap).
:- use_module(clean_code).
:- use_module(builtins).
:- use_module(find).
:- use_module(guard_entailment).
:- use_module(chr_compiler_options).
:- use_module(chr_compiler_utility).
:- use_module(chr_compiler_errors).
:- include(chr_op).
:- op(1150, fx, (chr_type)).
:- op(1130, xfx, (--->)).
:- op(980, fx, +).
:- op(980, fx, -).
:- op(980, fx, ?).
:- op(1150, fx, (constraints)).
:- op(1150, fx, (chr_constraint)).
set_constraint_indices(A) :-
	set_constraint_indices(A, 1).
set_constraint_indices([], A) :-
	B is A-1,
	max_constraint_index(B).
set_constraint_indices([A|C], B) :-
	(   (   chr_pp_flag(debugable, on)
	    ;   \+only_ground_indexed_arguments(A),
		is_stored(A)
	    ;   is_stored(A),
		get_store_type(A, default)
	    ;   get_store_type(A, var_assoc_store(_, _))
	    )
	->  constraint_index(A, B),
	    D is B+1,
	    set_constraint_indices(C, D)
	;   set_constraint_indices(C, B)
	).
type_indexed_identifier_structure(A, B) :-
	type_indexed_identifier_name(A, type_indexed_identifier_struct, C),
	get_type_indexed_identifier_size(A, D),
	functor(B, C, D).
type_indexed_identifier_name(A, C, D) :-
	(   atom(A)
	->  B=A
	;   term_to_atom(A, B)
	),
	atom_concat_list([C, '_', B], D).
chr_translate(A, M) :-
	chr_info(banner, '\tThe K.U.Leuven CHR System\t\n\t\tContributors:\tTom Schrijvers, Jon Sneyers, Bart Demoen,\n\t\t\t\tJan Wielemaker\n\t\tCopyright:\tK.U.Leuven, Belgium\n\t\tURL:\t\thttp://www.cs.kuleuven.be/~~toms/CHR/\n', []),
	init_chr_pp_flags,
	partition_clauses(A, B, C, F),
	check_declared_constraints(B),
	generate_show_constraint(B, D, C, E),
	add_constraints(D),
	add_rules(E),
	check_rules(E, D),
	time('type checking', chr_translate:static_type_check),
	add_occurrences(E),
	time('functional dependency', chr_translate:functional_dependency_analysis(E)),
	time('set semantics', chr_translate:set_semantics_rules(E)),
	time('symmetry analysis', chr_translate:symmetry_analysis(E)),
	time('guard simplification', chr_translate:guard_simplification),
	time('late storage', chr_translate:storage_analysis(D)),
	time(observation, chr_translate:observation_analysis(D)),
	time('ai observation', chr_translate:ai_observation_analysis(D)),
	time('late allocation', chr_translate:late_allocation_analysis(D)),
	partial_wake_analysis,
	time('assume constraint stores', chr_translate:assume_constraint_stores(D)),
	time('default constraint indices', chr_translate:set_constraint_indices(D)),
	time('constraint code generation', chr_translate:constraints_code(D, H)),
	time('validate store assumptions', chr_translate:validate_store_type_assumptions(D)),
	phase_end(validate_store_type_assumptions),
	used_states_known,
	time('store code generation', chr_translate:store_management_preds(D, G)),
	insert_declarations(F, K),
	chr_module_declaration(I),
	append([G, H, I, [end_of_file]], J),
	clean_clauses(J, L),
	append([K, L], M).
store_management_preds(A, J) :-
	generate_attach_detach_a_constraint_all(A, B),
	generate_attr_unify_hook(D),
	generate_attach_increment(C),
	generate_extra_clauses(A, E),
	generate_insert_delete_constraints(A, F),
	generate_attach_code(A, G),
	generate_counter_code(H),
	generate_dynamic_type_check_clauses(I),
	append([B, C, D, E, F, G, H, I], J).
insert_declarations(B, D) :-
	findall((:-use_module(chr(A))), (auxiliary_module(A), is_used_auxiliary_module(A)), C),
	append(B, [ (:-use_module(chr(chr_runtime)))|C], D).
auxiliary_module(chr_hashtable_store).
auxiliary_module(chr_integertable_store).
auxiliary_module(chr_assoc_store).
generate_counter_code(A) :-
	(   chr_pp_flag(store_counter, on)
	->  A=[ ('$counter_init'(B):-nb_setval(B, 0)), ('$counter'(C, D):-nb_getval(C, D)), ('$counter_inc'(E):-nb_getval(E, F), G is F+1, nb_setval(E, G)), (:-'$counter_init'('$insert_counter')), (:-'$counter_init'('$delete_counter')), ('$insert_counter_inc':-'$counter_inc'('$insert_counter')), ('$delete_counter_inc':-'$counter_inc'('$delete_counter')), (counter_stats(H, I):-'$counter'('$insert_counter', H), '$counter'('$delete_counter', I))]
	;   A=[]
	).
chr_module_declaration(B) :-
	get_target_module(A),
	(   A\==chr_translate,
	    chr_pp_flag(toplevel_show_store, on)
	->  B=[ (:-multifile chr:'$chr_module'/1), chr:'$chr_module'(A)]
	;   B=[]
	).
partition_clauses([], [], [], []).
partition_clauses([A|M], B, C, E) :-
	(   parse_rule(A, D)
	->  B=G,
	    C=[D|H],
	    E=I
	;   is_declaration(A, F)
	->  append(F, G, B),
	    C=H,
	    E=I
	;   is_module_declaration(A, J)
	->  target_module(J),
	    B=G,
	    C=H,
	    E=[A|I]
	;   is_type_definition(A)
	->  B=G,
	    C=H,
	    E=I
	;   A=handler(_)
	->  chr_warning(deprecated(A), 'Backward compatibility: ignoring handler/1 declaration.\n', []),
	    B=G,
	    C=H,
	    E=I
	;   A=rules(_)
	->  chr_warning(deprecated(A), 'Backward compatibility: ignoring rules/1 declaration.\n', []),
	    B=G,
	    C=H,
	    E=I
	;   A=option(K, L)
	->  chr_warning(deprecated(A), 'Instead use `:-chr_option(~w,~w).\'\n', [K, L]),
	    handle_option(K, L),
	    B=G,
	    C=H,
	    E=I
	;   A= (:-chr_option(K, L))
	->  handle_option(K, L),
	    B=G,
	    C=H,
	    E=I
	;   A='$chr_compiled_with_version'(_)
	->  B=G,
	    C=H,
	    E=['$chr_compiled_with_version'(3)|I]
	;   B=G,
	    C=H,
	    E=[A|I]
	),
	partition_clauses(M, G, H, I).
'$chr_compiled_with_version'(3).
is_declaration(A, F) :-
	(   A= (:-B),
	    B=..[C, D],
	    C== (chr_constraint)
	->  conj2list(D, E)
	;   (   A= (:-B)
	    ->  B=..[ (constraints), D]
	    ;   A=..[ (constraints), D]
	    ),
	    conj2list(D, E),
	    chr_warning(deprecated(A), 'Instead use :- chr_constraint ~w.\n', [D])
	),
	extract_type_mode(E, F).
extract_type_mode([], []).
extract_type_mode([A/B|C], [A/B|D]) :- !,
	extract_type_mode(C, D).
extract_type_mode([A|H], [B|I]) :-
	functor(A, C, D),
	B=C/D,
	A=..[_|E],
	extract_types_and_modes(E, F, G),
	constraint_type(B, F),
	constraint_mode(B, G),
	extract_type_mode(H, I).
extract_types_and_modes([], [], []).
extract_types_and_modes([A|D], [B|E], [C|F]) :-
	extract_type_and_mode(A, B, C),
	extract_types_and_modes(D, E, F).
extract_type_and_mode(+A, A, +) :- !.
extract_type_and_mode(?A, A, ?) :- !.
extract_type_and_mode(-A, A, -) :- !.
extract_type_and_mode(+, any, +) :- !.
extract_type_and_mode(?, any, ?) :- !.
extract_type_and_mode(-, any, -) :- !.
extract_type_and_mode(A, _, _) :-
	chr_error(syntax(A), 'Illegal mode/type declaration.\n\tCorrect syntax is +type, -type or ?type\n\tor +, - or ?.\n', []).
is_type_definition(A) :-
	(   A= (:-B)
	->  true
	;   A=B
	),
	B=..[ (chr_type), C],
	(   C= (E--->D)
	->  tdisj2list(D, F),
	    type_definition(E, F)
	;   C= (G==E)
	->  type_alias(G, E)
	;   type_definition(C, []),
	    chr_warning(syntax, 'Empty type definition `~w\'.\nAre you sure you want to declare a phantom type?\n', [A])
	).
tdisj2list(A, B) :-
	tdisj2list(A, B, []).
tdisj2list(A, C, F) :-
	A= (B;D), !,
	tdisj2list(B, C, E),
	tdisj2list(D, E, F).
tdisj2list(A, [A|B], B).
parse_rule(A, D) :-
	A= @(C, B), !,
	rule(B, yes(C), D).
parse_rule(A, B) :-
	rule(A, no, B).
rule(A, E, D) :-
	A=pragma(G, B), !,
	(   var(B)
	->  C=[_]
	;   conj2list(B, C)
	),
	inc_rule_count(F),
	D=pragma(H, I, C, E, F),
	is_rule(G, H, I, D).
rule(D, B, A) :-
	inc_rule_count(C),
	A=pragma(E, F, [], B, C),
	is_rule(D, E, F, A).
is_rule(A, H, E, D) :-
	A= ==>(B, G), !,
	conj2list(B, C),
	get_ids(C, F, I, D),
	E=ids([], F),
	(   G= (J'|'K)
	->  H=rule([], I, J, K)
	;   H=rule([], I, true, G)
	).
is_rule(A, S, N, K) :-
	A= <=>(G, B), !,
	(   B= (C'|'D)
	->  E=C,
	    F=D
	;   E=true,
	    F=B
	),
	(   G= \(H, I)
	->  conj2list(H, J),
	    conj2list(I, L),
	    get_ids(J, P, Q, 0, M, K),
	    get_ids(L, O, R, M, _, K),
	    N=ids(O, P)
	;   conj2list(G, L),
	    Q=[],
	    get_ids(L, O, R, K),
	    N=ids(O, [])
	),
	S=rule(R, Q, E, F).
get_ids(A, B, C, D) :-
	get_ids(A, B, C, 0, _, D).
get_ids([], [], [], A, A, _).
get_ids([B|F], [A|G], [C|H], A, J, E) :-
	(   B= #(C, D)
	->  (   var(D)
	    ->  D=A
	    ;   check_direct_pragma(D, A, E)
	    )
	;   C=B
	),
	I is A+1,
	get_ids(F, G, H, I, J, E).
check_direct_pragma(passive, C, A) :- !,
	A=pragma(_, ids(_, _), _, _, B),
	passive(B, C).
check_direct_pragma(A, _, C) :-
	(   direct_pragma(B),
	    atom_concat(A, _, B)
	->  chr_warning(problem_pragma(A, C), 'completed `~w\' to `~w\'\n', [A, B])
	;   chr_warning(unsupported_pragma(A, C), '', [])
	).
direct_pragma(passive).
is_module_declaration((:-module(A)), A).
is_module_declaration((:-module(A, _)), A).
add_constraints([]).
add_constraints([A|D]) :-
	max_occurrence(A, 0),
	A=_/B,
	length(C, B),
	set_elems(C, ?),
	constraint_mode(A, C),
	add_constraints(D).
add_rules([]).
add_rules([A|C]) :-
	A=pragma(_, _, _, _, B),
	rule(B, A),
	add_rules(C).
check_declared_constraints(A) :-
	check_declared_constraints(A, []).
check_declared_constraints([], _).
check_declared_constraints([A|C], B) :-
	(   memberchk_eq(A, B)
	->  chr_error(syntax(A), 'Constraint multiply defined: ~w.\n\tRemove redundant declaration!\n', [A])
	;   true
	),
	check_declared_constraints(C, [A|B]).
check_rules([], _).
check_rules([A|C], B) :-
	check_rule(A, B),
	check_rules(C, B).
check_rule(A, F) :-
	check_rule_indexing(A),
	check_trivial_propagation_rule(A),
	A=pragma(B, _, G, _, _),
	B=rule(C, D, _, _),
	append(C, D, E),
	check_head_constraints(E, F, A),
	check_pragmas(G, A).
check_trivial_propagation_rule(A) :-
	A=pragma(B, _, _, _, C),
	(   B=rule([], _, _, true)
	->  chr_warning(weird_program, 'Ignoring propagation rule with empty body: ~@.\n\t\n', [format_rule(A)]),
	    set_all_passive(C)
	;   true
	).
check_head_constraints([], _, _).
check_head_constraints([A|E], D, F) :-
	functor(A, B, C),
	(   member(B/C, D)
	->  check_head_constraints(E, D, F)
	;   chr_error(syntax(A), 'Undeclared constraint ~w in head of ~@.\n\tConstraint should be one of ~w.\n', [B/C, format_rule(F), D])
	).
check_pragmas([], _).
check_pragmas([A|C], B) :-
	check_pragma(A, B),
	check_pragmas(C, B).
check_pragma(A, B) :-
	var(A), !,
	chr_error(syntax(A), 'Invalid pragma ~w in ~@.\n\tPragma should not be a variable!\n', [A, format_rule(B)]).
check_pragma(passive(B), A) :- !,
	A=pragma(_, ids(C, D), _, _, E),
	(   memberchk_eq(B, C)
	->  true
	;   memberchk_eq(B, D)
	->  true
	;   chr_error(syntax(B), 'Invalid identifier ~w in pragma passive in ~@.\n', [B, format_rule(A)])
	),
	passive(E, B).
check_pragma(mpassive(B), A) :- !,
	A=pragma(_, _, _, _, C),
	chr_warning(experimental, 'Experimental pragma ~w. Use with care!\n', [mpassive(B)]),
	maplist(passive(C), B).
check_pragma(A, B) :-
	A=already_in_heads, !,
	chr_warning(unsupported_pragma(A, B), 'Termination and correctness may be affected.\n', []).
check_pragma(A, B) :-
	A=already_in_head(_), !,
	chr_warning(unsupported_pragma(A, B), 'Termination and correctness may be affected.\n', []).
check_pragma(A, B) :-
	A=no_history, !,
	chr_warning(experimental, 'Experimental pragma no_history. Use with care!\n', []),
	B=pragma(_, _, _, _, C),
	no_history(C).
check_pragma(A, C) :-
	A=history(E, B), !,
	chr_warning(experimental, 'Experimental pragma ~w. Use with care!\n', [A]),
	(   B==[]
	->  chr_error(syntax(A), 'Invalid empty history.\n', [])
	;   true
	),
	C=pragma(_, _, _, _, D),
	history(D, E, B).
check_pragma(A, B) :-
	chr_error(syntax(A), 'Unknown pragma ~w in ~@.\n', [A, format_rule(B)]).
format_rule(A) :-
	A=pragma(_, _, _, B, D),
	(   B=yes(C)
	->  write('rule '),
	    write(C)
	;   write('rule number '),
	    write(D)
	).
check_rule_indexing(A) :-
	A=pragma(B, _, _, _, _),
	B=rule(C, D, E, _),
	term_variables(C-D, F),
	remove_anti_monotonic_guards(E, F, G),
	check_indexing(C, G-D),
	check_indexing(D, G-C),
	(   chr_pp_flag(term_indexing, on)
	->  term_variables(G, I),
	    append(C, D, H),
	    check_specs_indexing(H, I, _)
	;   true
	).
remove_anti_monotonic_guards(A, C, E) :-
	conj2list(A, B),
	remove_anti_monotonic_guard_list(B, C, D),
	list2conj(D, E).
remove_anti_monotonic_guard_list([], _, []).
remove_anti_monotonic_guard_list([A|F], C, D) :-
	(   A=var(B),
	    memberchk_eq(B, C)
	->  D=E
	;   D=[A|E]
	),
	remove_anti_monotonic_guard_list(F, C, E).
check_indexing([], _).
check_indexing([A|B], C) :-
	functor(A, E, F),
	A=..[_|D],
	term_variables(B-C, G),
	check_indexing(D, 1, E/F, G),
	check_indexing(B, [A|C]).
check_indexing([], _, _, _).
check_indexing([C|D], B, A, F) :-
	(   is_indexed_argument(A, B)
	->  true
	;   nonvar(C)
	->  indexed_argument(A, B)
	;   term_variables(D, E),
	    append(E, F, G),
	    (   memberchk_eq(C, G)
	    ->  indexed_argument(A, B)
	    ;   true
	    )
	),
	I is B+1,
	term_variables(C, H),
	append(H, F, J),
	check_indexing(D, I, A, J).
check_specs_indexing([], _, []).
check_specs_indexing([D|B], C, A) :-
	A=[F|H],
	term_variables(B, E, C),
	check_spec_indexing(D, E, F),
	term_variables(D, G, C),
	check_specs_indexing(B, G, H).
check_spec_indexing(A, F, B) :-
	functor(A, C, D),
	B=spec(C, D, G),
	A=..[_|E],
	check_args_spec_indexing(E, 1, F, G),
	indexing_spec(C/D, [G]).
check_args_spec_indexing([], _, _, []).
check_args_spec_indexing([C|A], D, B, F) :-
	term_variables(A, E, B),
	(   check_arg_spec_indexing(C, D, E, G)
	->  F=[G|H]
	;   F=H
	),
	I is D+1,
	term_variables(C, J, B),
	check_args_spec_indexing(A, I, J, H).
check_arg_spec_indexing(A, D, B, C) :-
	(   var(A)
	->  memberchk_eq(A, B),
	    C=specinfo(D, any, [])
	;   functor(A, E, F),
	    C=specinfo(D, E/F, [H]),
	    A=..[_|G],
	    check_args_spec_indexing(G, 1, B, H)
	).
add_occurrences([]).
add_occurrences([A|G]) :-
	A=pragma(rule(B, E, _, _), ids(C, F), _, _, D),
	add_occurrences(B, C, simplification, D),
	add_occurrences(E, F, propagation, D),
	add_occurrences(G).
add_occurrences([], [], _, _).
add_occurrences([A|H], [F|I], G, E) :-
	functor(A, B, C),
	D=B/C,
	new_occurrence(D, E, F, G),
	add_occurrences(H, I, G, E).
observation_analysis(A, C, B, E) :-
	(   all_spawned(A, B)
	->  true
	;   var(C)
	->  spawns_all(A, B)
	;   C=true
	->  true
	;   C=fail
	->  true
	;   C=!
	->  true
	;   C= (D, F)
	->  observation_analysis(A, D, B, E),
	    observation_analysis(A, F, B, E)
	;   C= (D;F)
	->  observation_analysis(A, D, B, E),
	    observation_analysis(A, F, B, E)
	;   C= (D->F)
	->  observation_analysis(A, D, B, E),
	    observation_analysis(A, F, B, E)
	;   C= (\+G)
	->  observation_analysis(A, G, B, E)
	;   functor(C, H, I),
	    member(H/I, E)
	->  spawns(A, B, H/I)
	;   C= (_=_)
	->  spawns_all_triggers(A, B)
	;   C= (_ is _)
	->  spawns_all_triggers(A, B)
	;   builtin_binds_b(C, J)
	->  (   J==[]
	    ->  true
	    ;   spawns_all_triggers(A, B)
	    )
	;   spawns_all(A, B)
	).
is_observed(A, B) :-
	is_observed(A, B, _),
	ai_is_observed(A, B).
is_stored_in_guard(A, B) :-
	chr_pp_flag(store_in_guards, on),
	do_is_observed(A, B, guard).
late_allocation_analysis(A) :-
	(   chr_pp_flag(late_allocation, on)
	->  late_allocation(A)
	;   true
	).
late_allocation([]).
late_allocation([A|B]) :-
	allocation_occurrence(A, 1),
	late_allocation(B).
generate_attach_detach_a_constraint_all([], []).
generate_attach_detach_a_constraint_all([A|D], F) :-
	(   (   chr_pp_flag(debugable, on)
	    ;   is_stored(A),
		\+only_ground_indexed_arguments(A),
		\+get_store_type(A, var_assoc_store(_, _))
	    )
	->  generate_attach_a_constraint(A, B),
	    generate_detach_a_constraint(A, C)
	;   B=[],
	    C=[]
	),
	generate_attach_detach_a_constraint_all(D, E),
	append([B, C, E], F).
generate_attach_a_constraint(A, [B, C]) :-
	generate_attach_a_constraint_nil(A, B),
	generate_attach_a_constraint_cons(A, C).
attach_constraint_atom(A, D, E, B) :-
	make_name(attach_, A, C),
	B=..[C, D, E].
generate_attach_a_constraint_nil(B, A) :-
	A= (C:-true),
	attach_constraint_atom(B, [], _, C).
generate_attach_a_constraint_cons(B, A) :-
	A= (C:-F),
	attach_constraint_atom(B, [I|D], E, C),
	attach_constraint_atom(B, D, E, G),
	F= (J, L, G),
	get_max_constraint_index(H),
	(   H==1
	->  generate_attach_body_1(B, I, E, J)
	;   generate_attach_body_n(B, I, E, J)
	),
	chr_pp_flag(solver_events, K),
	(   K\==none
	->  _=[[I|_], E],
	    get_target_module(M),
	    use_auxiliary_predicate(run_suspensions),
	    L=clp_events:subscribe(I, K, M, M:'$run_suspensions'([E]))
	;   L=true
	).
generate_attach_body_1(_, B, D, A) :-
	get_target_module(C),
	A= (get_attr(B, C, E)->put_attr(B, C, [D|E]);put_attr(B, C, [D])).
generate_attach_body_n(A/B, O, G, N) :-
	get_constraint_index(A/B, C),
	or_pattern(C, M),
	get_max_constraint_index(D),
	make_attr(D, H, E, R),
	nth1(C, E, F),
	substitute(F, E, [G|F], I),
	make_attr(D, H, I, S),
	substitute(F, E, [G], J),
	make_attr(D, T, J, U),
	copy_term(E, K),
	nth1(C, K, [G]),
	chr_delete(K, [G], L),
	set_elems(L, []),
	make_attr(D, M, K, V),
	get_target_module(P),
	N= (get_attr(O, P, Q)->Q=R, (H/\M=:=M->put_attr(O, P, S);T is H\/M, put_attr(O, P, U));put_attr(O, P, V)), !.
generate_detach_a_constraint(A, [B, C]) :-
	generate_detach_a_constraint_nil(A, B),
	generate_detach_a_constraint_cons(A, C).
detach_constraint_atom(A, D, E, B) :-
	make_name(detach_, A, C),
	B=..[C, D, E].
generate_detach_a_constraint_nil(B, A) :-
	A= (C:-true),
	detach_constraint_atom(B, [], _, C).
generate_detach_a_constraint_cons(B, A) :-
	A= (C:-F),
	detach_constraint_atom(B, [I|D], E, C),
	detach_constraint_atom(B, D, E, G),
	F= (J, G),
	get_max_constraint_index(H),
	(   H==1
	->  generate_detach_body_1(B, I, E, J)
	;   generate_detach_body_n(B, I, E, J)
	).
generate_detach_body_1(_, B, E, A) :-
	get_target_module(C),
	A= (get_attr(B, C, D)->'chr sbag_del_element'(D, E, F), (F==[]->del_attr(B, C);put_attr(B, C, F));true).
generate_detach_body_n(A/B, K, P, J) :-
	get_constraint_index(A/B, C),
	or_pattern(C, O),
	and_pattern(C, S),
	get_max_constraint_index(D),
	make_attr(D, H, E, N),
	nth1(C, E, F),
	substitute(F, E, [], G),
	make_attr(D, R, G, T),
	substitute(F, E, Q, I),
	make_attr(D, H, I, U),
	get_target_module(L),
	J= (get_attr(K, L, M)->M=N, (H/\O=:=O->'chr sbag_del_element'(F, P, Q), (Q==[]->R is H/\S, (R==0->del_attr(K, L);put_attr(K, L, T));put_attr(K, L, U));true);true), !.
create_indexed_variables_body([], [], [], _, _, _, empty, 0).
create_indexed_variables_body([J|B], [G|C], [H|D], K, A, F, I, O) :-
	E is A+1,
	create_indexed_variables_body(B, C, D, L, E, F, M, P),
	(   G== (?),
	    is_indexed_argument(F, A)
	->  (   atomic_type(H)
	    ->  I= ((var(J)->K=[J|L];K=L), N),
		(   M==empty
		->  N=true,
		    L=[]
		;   N=M
		)
	    ;   M==empty
	    ->  I=term_variables(J, K)
	    ;   I= (term_variables(J, K, L), M)
	    ),
	    O=P
	;   G== (-),
	    is_indexed_argument(F, A)
	->  (   M==empty
	    ->  I= (K=[J])
	    ;   I= (K=[J|L], M)
	    ),
	    O is P+1
	;   K=L,
	    I=M,
	    O is P+1
	).
spectermvars(B, A, C, D, F, E) :-
	spectermvars(A, 1, B, C, D, E, [], F).
spectermvars([], B, _, _, C, A, A, true) :-
	B>C, !.
spectermvars([F|I], C, B, L, M, H, O, A) :-
	A= (G, P),
	argspecs(B, C, D, K),
	merge_argspecs(D, E),
	arggoal(E, F, G, H, N),
	J is C+1,
	spectermvars(I, J, K, L, M, N, O, P).
argspecs([], _, [], []).
argspecs([[]|A], B, C, D) :-
	argspecs(A, B, C, D).
argspecs([[specinfo(B, D, E)|F]|J], A, C, G) :-
	(   A==B
	->  C=[specinfo(B, D, E)|I],
	    (   F=[]
	    ->  H=G
	    ;   G=[F|H]
	    )
	;   C=I,
	    G=[[specinfo(B, D, E)|F]|H]
	),
	argspecs(J, A, I, H).
merge_argspecs(A, C) :-
	sort(A, B),
	merge_argspecs_(B, C).
merge_argspecs_([], []).
merge_argspecs_([B], A) :- !,
	A=[B].
merge_argspecs_([specinfo(A, B, F), specinfo(A, C, G)|D], E) :-
	(   (   B==any
	    ;   C==any
	    )
	->  merge_argspecs_([specinfo(A, any, [])|D], E)
	;   B==C
	->  append(F, G, H),
	    merge_argspecs_([specinfo(A, B, H)|D], E)
	;   E=[specinfo(A, B, F)|I],
	    merge_argspecs_([specinfo(A, C, G)|D], I)
	).
arggoal(A, E, D, B, C) :-
	(   A==[]
	->  B=C,
	    D=true
	;   A=[specinfo(_, any, _)]
	->  D=term_variables(E, B, C)
	;   D= (var(E)->B=[E|C];F),
	    arggoal_cases(A, E, B, C, F)
	).
arggoal_cases([], _, A, B, A=B).
arggoal_cases([specinfo(_, D, A)|N], I, K, L, B) :-
	(   A==[]
	->  B=C
	;   A==[[]]
	->  B=C
	;   D=E/F
	->  B= (H;C),
	    functor(G, E, F),
	    G=..[_|J],
	    H= (I=G->M),
	    spectermvars(J, 1, A, E, F, K, L, M)
	),
	arggoal_cases(N, I, K, L, C).
generate_extra_clauses(A, B) :-
	generate_activate_clauses(A, B, C),
	generate_remove_clauses(A, C, D),
	generate_allocate_clauses(A, D, E),
	generate_insert_constraint_internal_clauses(A, E, F),
	generate_novel_production(F, G),
	generate_extend_history(G, H),
	generate_run_suspensions_clauses(A, H, I),
	I=[].
generate_remove_clauses([], A, A).
generate_remove_clauses([A|C], B, E) :-
	generate_remove_clause(A, B, D),
	generate_remove_clauses(C, D, E).
remove_constraint_goal(A, E, F, D, C, I, B) :-
	uses_state(A, removed),
	(   chr_pp_flag(inline_insertremove, off)
	->  use_auxiliary_predicate(remove_constraint_internal, A),
	    B= (H, (G==yes->C;D)),
	    remove_constraint_atom(A, E, F, G, H)
	;   delay_phase_end(validate_store_type_assumptions, generate_remove_body(A, E, F, D, C, I, B))
	).
remove_constraint_atom(A, D, F, E, B) :-
	make_name('$remove_constraint_internal_', A, C),
	(   chr_pp_flag(debugable, off),
	    (   only_ground_indexed_arguments(A)
	    ;   get_store_type(A, var_assoc_store(_, _))
	    )
	->  B=..[C, D, E]
	;   B=..[C, D, F, E]
	).
generate_remove_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(remove_constraint_internal, A)
	->  B=[D|C],
	    D= (E:-I),
	    remove_constraint_atom(A, F, G, H, E),
	    generate_remove_body(A, F, G, H=no, H=yes, active, I)
	;   B=C
	).
generate_remove_body(A, C, O, F, G, B, L) :-
	(   chr_pp_flag(debugable, off),
	    (   only_ground_indexed_arguments(A)
	    ;   get_store_type(A, var_assoc_store(_, _))
	    )
	->  (   B==active
	    ->  get_update_suspension_field(A, C, state, E, removed, H, D, I),
		if_used_state(A, not_stored_yet, D, true, J),
		if_used_state(A, not_stored_yet, (E==not_stored_yet->F;G), G, K)
	    ;   B==partner
	    ->  get_update_suspension_field(A, C, state, E, removed, H, _, I),
		J=true,
		K=G
	    ),
	    L= (H, J, I, K)
	;   static_suspension_term(A, M),
	    get_static_suspension_term_field(arguments, A, M, N),
	    generate_indexed_variables_body(A, N, Q, O),
	    (   chr_pp_flag(debugable, on)
	    ->  A=P/_,
		get_static_suspension_term_field(functor, A, M, P)
	    ;   true
	    ),
	    (   B==active
	    ->  get_update_static_suspension_field(A, C, M, state, E, removed, D, I),
		if_used_state(A, not_stored_yet, D, true, J),
		if_used_state(A, not_stored_yet, (E==not_stored_yet->O=[], F;Q, G), (Q, G), K)
	    ;   B==partner
	    ->  get_update_static_suspension_field(A, C, M, state, E, removed, _, I),
		J=true,
		K= (Q, G)
	    ),
	    L= (C=M, J, I, K)
	).
generate_activate_clauses([], A, A).
generate_activate_clauses([A|C], B, E) :-
	generate_activate_clause(A, B, D),
	generate_activate_clauses(C, D, E).
activate_constraint_goal(A, C, E, F, G, B) :-
	(   chr_pp_flag(inline_insertremove, off)
	->  use_auxiliary_predicate(activate_constraint, A),
	    B= (H, (D==yes->C;true)),
	    activate_constraint_atom(A, D, E, F, G, H)
	;   delay_phase_end(validate_store_type_assumptions, activate_constraint_body(A, C, true, E, F, G, B))
	).
activate_constraint_atom(A, D, G, E, F, B) :-
	make_name('$activate_constraint_', A, C),
	(   chr_pp_flag(debugable, off),
	    only_ground_indexed_arguments(A)
	->  B=..[C, D, E]
	;   chr_pp_flag(debugable, off),
	    may_trigger(A),
	    get_store_type(A, var_assoc_store(_, _))
	->  B=..[C, D, E, F]
	;   chr_pp_flag(debugable, off),
	    may_trigger(A),
	    get_store_type(A, var_assoc_store(_, _))
	->  B=..[C, D, G, E, F]
	;   B=..[C, D, G, E]
	).
generate_activate_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(activate_constraint, A)
	->  B=[D|C],
	    D= (E:-J),
	    activate_constraint_atom(A, F, G, H, I, E),
	    activate_constraint_body(A, F=yes, F=no, G, H, I, J)
	;   B=C
	).
activate_constraint_body(A, K, L, N, B, C, S) :-
	(   chr_pp_flag(debugable, off),
	    may_trigger(A),
	    uses_field(A, generation)
	->  get_update_suspension_field(A, B, generation, F, C, D, E, G),
	    H= (D, E, C is F+1, G)
	;   H=true
	),
	get_update_suspension_field(A, B, state, J, active, T, I, V),
	if_used_state(A, not_stored_yet, I, true, U),
	(   chr_pp_flag(debugable, off),
	    (   only_ground_indexed_arguments(A)
	    ;   get_store_type(A, var_assoc_store(_, _))
	    )
	->  if_used_state(A, not_stored_yet, (J==not_stored_yet->K;L), L, R)
	;   get_dynamic_suspension_term_field(arguments, A, B, M, P),
	    generate_indexed_variables_body(A, M, Q, N),
	    (   chr_pp_flag(guard_locks, off)
	    ->  O=true
	    ;   O='chr none_locked'(N)
	    ),
	    if_used_state(A, not_stored_yet, (J==not_stored_yet->P, Q, O, K;L), L, R)
	),
	S= (T, U, V, H, R).
generate_allocate_clauses([], A, A).
generate_allocate_clauses([A|C], B, E) :-
	generate_allocate_clause(A, B, D),
	generate_allocate_clauses(C, D, E).
allocate_constraint_goal(A, B, C, D) :-
	uses_state(A, not_stored_yet),
	(   chr_pp_flag(inline_insertremove, off)
	->  use_auxiliary_predicate(allocate_constraint, A),
	    allocate_constraint_atom(A, B, C, D)
	;   D= (B=E, F),
	    delay_phase_end(validate_store_type_assumptions, allocate_constraint_body(A, E, C, F))
	).
allocate_constraint_atom(A, D, E, B) :-
	make_name('$allocate_constraint_', A, C),
	B=..[C, D|E].
generate_allocate_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(allocate_constraint, A)
	->  B=[D|C],
	    D= (G:-I),
	    A=_/E,
	    length(F, E),
	    allocate_constraint_atom(A, H, F, G),
	    allocate_constraint_body(A, H, F, I)
	;   B=C
	).
allocate_constraint_body(A, E, C, P) :-
	static_suspension_term(A, B),
	get_static_suspension_term_field(arguments, A, B, C),
	(   chr_pp_flag(debugable, on)
	->  A=D/_,
	    get_static_suspension_term_field(functor, A, B, D)
	;   true
	),
	(   chr_pp_flag(debugable, on)
	->  (   may_trigger(A)
	    ->  append(C, [E], F),
		build_head(_, _, [0], F, H),
		get_target_module(G),
		I=G:H
	    ;   I=true
	    ),
	    K= (E=B),
	    create_static_suspension_field(A, B, continuation, I, L),
	    create_static_suspension_field(A, B, generation, 0, J)
	;   may_trigger(A),
	    uses_field(A, generation)
	->  create_static_suspension_field(A, B, generation, 0, J),
	    E=B,
	    K=true,
	    L=true
	;   J=true,
	    E=B,
	    K=true,
	    L=true
	),
	(   uses_history(A)
	->  create_static_suspension_field(A, B, history, t, M)
	;   M=true
	),
	create_static_suspension_field(A, B, state, not_stored_yet, Q),
	(   has_suspension_field(A, id)
	->  get_static_suspension_term_field(id, A, B, N),
	    O='chr gen_id'(N)
	;   O=true
	),
	P= (K, L, J, M, Q, O).
generate_insert_constraint_internal_clauses([], A, A).
generate_insert_constraint_internal_clauses([A|C], B, E) :-
	generate_insert_constraint_internal_clause(A, B, D),
	generate_insert_constraint_internal_clauses(C, D, E).
insert_constraint_internal_constraint_goal(A, B, C, D, E, F) :-
	(   chr_pp_flag(inline_insertremove, off)
	->  use_auxiliary_predicate(remove_constraint_internal, A),
	    insert_constraint_internal_constraint_atom(A, B, C, D, E, F)
	;   delay_phase_end(validate_store_type_assumptions, generate_insert_constraint_internal_body(A, C, D, E, B, F))
	).
insert_constraint_internal_constraint_atom(A, D, E, F, G, B) :-
	insert_constraint_internal_constraint_name(A, C),
	(   chr_pp_flag(debugable, on)
	->  B=..[C, D, E, F|G]
	;   (   only_ground_indexed_arguments(A)
	    ;   get_store_type(A, var_assoc_store(_, _))
	    )
	->  B=..[C, E|G]
	;   B=..[C, D, E|G]
	).
insert_constraint_internal_constraint_name(A, B) :-
	make_name('$insert_constraint_internal_', A, B).
generate_insert_constraint_internal_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(insert_constraint_internal, A)
	->  B=[D|C],
	    D= (G:-K),
	    A=_/E,
	    length(F, E),
	    insert_constraint_internal_constraint_atom(A, J, H, I, F, G),
	    generate_insert_constraint_internal_body(A, H, I, F, J, K)
	;   B=C
	).
generate_insert_constraint_internal_body(A, K, C, G, M, J) :-
	static_suspension_term(A, B),
	create_static_suspension_field(A, B, state, active, L),
	(   chr_pp_flag(debugable, on)
	->  get_static_suspension_term_field(continuation, A, B, C),
	    create_static_suspension_field(A, B, generation, 0, D)
	;   may_trigger(A),
	    uses_field(A, generation)
	->  create_static_suspension_field(A, B, generation, 0, D)
	;   D=true
	),
	(   chr_pp_flag(debugable, on)
	->  A=E/_,
	    get_static_suspension_term_field(functor, A, B, E)
	;   true
	),
	(   uses_history(A)
	->  create_static_suspension_field(A, B, history, t, F)
	;   F=true
	),
	get_static_suspension_term_field(arguments, A, B, G),
	_=[_|_],
	(   chr_pp_flag(debugable, off),
	    (   only_ground_indexed_arguments(A)
	    ;   get_store_type(A, var_assoc_store(_, _))
	    )
	->  suspension_term_base_fields(A, _),
	    (   has_suspension_field(A, id)
	    ->  get_static_suspension_term_field(id, A, B, H),
		I='chr gen_id'(H)
	    ;   I=true
	    ),
	    J= (K=B, L, D, F, I)
	;   (   has_suspension_field(A, id)
	    ->  get_static_suspension_term_field(id, A, B, H),
		I='chr gen_id'(H)
	    ;   I=true
	    ),
	    generate_indexed_variables_body(A, G, O, M),
	    (   chr_pp_flag(guard_locks, off)
	    ->  N=true
	    ;   N='chr none_locked'(M)
	    ),
	    J= (K=B, O, N, L, D, F, I)
	).
generate_novel_production(A, B) :-
	(   is_used_auxiliary_predicate(novel_production)
	->  A=[C|B],
	    C= ('$novel_production'(D, E):-arg(3, D, F), (hprolog:get_ds(E, F, _)->fail;true))
	;   A=B
	).
generate_extend_history(A, B) :-
	(   is_used_auxiliary_predicate(extend_history)
	->  A=[C|B],
	    C= ('$extend_history'(D, E):-arg(3, D, F), hprolog:put_ds(E, F, x, G), setarg(3, D, G))
	;   A=B
	).
generate_run_suspensions_clauses([], A, A).
generate_run_suspensions_clauses([A|C], B, E) :-
	generate_run_suspensions_clause(A, B, D),
	generate_run_suspensions_clauses(C, D, E).
run_suspensions_goal(A, D, B) :-
	make_name('$run_suspensions_', A, C),
	B=..[C, D].
generate_run_suspensions_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(run_suspensions, A)
	->  B=[D, G|C],
	    run_suspensions_goal(A, [], D),
	    (   chr_pp_flag(debugable, on)
	    ->  run_suspensions_goal(A, [E|F], H),
		get_update_suspension_field(A, E, state, K, triggered, I, J, L),
		get_update_suspension_field(A, E, state, V, active, T, U, W),
		get_update_suspension_field(A, E, generation, P, O, M, N, Q),
		get_dynamic_suspension_term_field(continuation, A, E, S, R),
		run_suspensions_goal(A, F, X),
		G= (H:-I, J, (K==active->L, M, N, O is P+1, Q, R, ('chr debug_event'(wake(E)), call(S);'chr debug_event'(fail(E)), !, fail), ('chr debug_event'(exit(E));'chr debug_event'(redo(E)), fail), T, U, (V==triggered->W;true);true), X)
	    ;   run_suspensions_goal(A, [E|F], H),
		static_suspension_term(A, Y),
		get_static_suspension_term_field(arguments, A, Y, Z),
		append(Z, [E], A1),
		make_suspension_continuation_goal(A, A1, S),
		run_suspensions_goal(A, F, X),
		(   uses_field(A, generation)
		->  get_update_static_suspension_field(A, E, Y, generation, P, O, M, Q),
		    B1= (M, O is P+1, Q)
		;   B1=true
		),
		get_update_static_suspension_field(A, E, Y, state, K, triggered, I, L),
		get_update_static_suspension_field(A, E, Y, state, V, active, D1, E1),
		if_used_state(A, removed, (I, (K==active->C1;true)), C1, F1),
		C1= (L, B1, S, D1, (V==triggered->E1;true)),
		G= (H:-E=Y, F1, X)
	    )
	;   B=C
	).
generate_attach_increment(B) :-
	get_max_constraint_index(A),
	(   is_used_auxiliary_predicate(attach_increment),
	    A>0
	->  B=[C, D],
	    generate_attach_increment_empty(C),
	    (   A==1
	    ->  generate_attach_increment_one(D)
	    ;   generate_attach_increment_many(A, D)
	    )
	;   B=[]
	).
generate_attach_increment_empty((attach_increment([], _):-true)).
generate_attach_increment_one(I) :-
	J=attach_increment([B|H], E),
	get_target_module(C),
	(   chr_pp_flag(guard_locks, off)
	->  A=true
	;   A='chr not_locked'(B)
	),
	K= (A, (get_attr(B, C, D)->sort(D, F), 'chr merge_attributes'(E, F, G), put_attr(B, C, G);put_attr(B, C, E)), attach_increment(H, E)),
	I= (J:-K).
generate_attach_increment_many(A, A1) :-
	make_attr(A, W, C, B),
	make_attr(A, X, D, T),
	B1=attach_increment([Q|Z], B),
	bagof(G, E^F^H^I^ (member2(C, D, E-F), G= (sort(F, H), 'chr merge_attributes'(E, H, I))), J),
	list2conj(J, U),
	bagof(N, K^L^M^member((K, 'chr merge_attributes'(L, M, N)), J), O),
	make_attr(A, V, O, Y),
	get_target_module(R),
	(   chr_pp_flag(guard_locks, off)
	->  P=true
	;   P='chr not_locked'(Q)
	),
	C1= (P, (get_attr(Q, R, S)->S=T, U, V is W\/X, put_attr(Q, R, Y);put_attr(Q, R, B)), attach_increment(Z, B)),
	A1= (B1:-C1).
generate_attr_unify_hook(B) :-
	get_max_constraint_index(A),
	(   A==0
	->  B=[]
	;   B=[C],
	    (   A==1
	    ->  generate_attr_unify_hook_one(C)
	    ;   generate_attr_unify_hook_many(A, C)
	    )
	).
generate_attr_unify_hook_one(Q) :-
	R=attr_unify_hook(C, L),
	get_target_module(N),
	get_indexed_constraint(1, A),
	(   get_store_type(A, default)
	->  make_run_suspensions(F, B, O),
	    make_run_suspensions(B, B, P),
	    (   atomic_types_suspended_constraint(A)
	    ->  G=true,
		B=C,
		H=true,
		I=D,
		J= (append(C, D, E), sort(E, F)),
		K=true
	    ;   G=sort(C, B),
		H=sort(D, I),
		J='chr merge_attributes'(B, I, F),
		use_auxiliary_predicate(attach_increment),
		K= (compound(L)->term_variables(L, M), attach_increment(M, B);true)
	    ),
	    S= (G, (var(L)-> (get_attr(L, N, D)->H, J, put_attr(L, N, F), O;put_attr(L, N, B), P);K, P)),
	    Q= (R:-S)
	;   get_store_type(A, var_assoc_store(_, _))
	->  make_run_suspensions(E, E, O),
	    J=merge_into_assoc_store(C, D, E),
	    S= (get_attr(L, N, D)->J, O;put_attr(L, N, C)),
	    Q= (R:-S)
	).
generate_attr_unify_hook_many(A, I1) :-
	make_attr(A, Q, C, R),
	make_attr(A, E1, H, B1),
	bagof(D, B^E^ (member(B, C), D=sort(B, E)), F),
	list2conj(F, Y),
	bagof(E, B^member(sort(B, E), F), G),
	bagof(K, I^J^L^M^ (member2(G, H, I-J), K= (sort(J, L), 'chr merge_attributes'(I, L, M))), O),
	bagof(M, I^L^N^member((N, 'chr merge_attributes'(I, L, M)), O), P),
	list2conj(O, C1),
	make_attr(A, D1, P, F1),
	make_attr(A, Q, G, X),
	J1=attr_unify_hook(R, V),
	get_target_module(Z),
	make_run_suspensions_loop(P, G, G1),
	make_run_suspensions_loop(G, G, H1),
	(   forall((between(1, A, S), get_indexed_constraint(S, T)), atomic_types_suspended_constraint(T))
	->  U=true
	;   use_auxiliary_predicate(attach_increment),
	    U= (compound(V)->term_variables(V, W), attach_increment(W, X);true)
	),
	K1= (Y, (var(V)-> (get_attr(V, Z, A1)->A1=B1, C1, D1 is Q\/E1, put_attr(V, Z, F1), G1;put_attr(V, Z, X), H1);U, H1)),
	I1= (J1:-K1).
make_run_suspensions(A, B, C) :-
	make_run_suspensions(1, A, B, C).
make_run_suspensions(A, E, C, D) :-
	(   get_indexed_constraint(A, B),
	    may_trigger(B)
	->  use_auxiliary_predicate(run_suspensions, B),
	    (   wakes_partially(B)
	    ->  run_suspensions_goal(B, C, D)
	    ;   run_suspensions_goal(B, E, D)
	    )
	;   D=true
	).
make_run_suspensions_loop(A, B, C) :-
	make_run_suspensions_loop(A, B, 1, C).
make_run_suspensions_loop([], [], _, true).
make_run_suspensions_loop([B|E], [C|F], A, (D, H)) :-
	make_run_suspensions(A, B, C, D),
	G is A+1,
	make_run_suspensions_loop(E, F, G, H).
generate_insert_delete_constraints([], []).
generate_insert_delete_constraints([A|D], B) :-
	(   is_stored(A)
	->  generate_insert_delete_constraint(A, B, C)
	;   B=C
	),
	generate_insert_delete_constraints(D, C).
generate_insert_delete_constraint(A, B, D) :-
	insert_constraint_clause(A, B, C),
	delete_constraint_clause(A, C, D).
insert_constraint_goal(A, B, E, C) :-
	(   chr_pp_flag(inline_insertremove, off)
	->  use_auxiliary_predicate(insert_in_store, A),
	    insert_constraint_atom(A, B, C)
	;   delay_phase_end(validate_store_type_assumptions, (insert_constraint_body(A, B, D, C), insert_constraint_direct_used_vars(D, E)))
	).
insert_constraint_direct_used_vars([], _).
insert_constraint_direct_used_vars([A-C|D], B) :-
	nth1(A, B, C),
	insert_constraint_direct_used_vars(D, B).
insert_constraint_atom(A, D, B) :-
	make_name('$insert_in_store_', A, C),
	B=..[C, D].
insert_constraint_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(insert_in_store, A)
	->  B=[D|C],
	    D= (E:-J, I, G),
	    insert_constraint_atom(A, F, E),
	    insert_constraint_body(A, F, H, G),
	    insert_constraint_used_vars(H, A, F, I),
	    (   chr_pp_flag(store_counter, on)
	    ->  J='$insert_counter_inc'
	    ;   J=true
	    )
	;   B=C
	).
insert_constraint_used_vars([], _, _, true).
insert_constraint_used_vars([A-D|F], B, C, (E, G)) :-
	get_dynamic_suspension_term_field(argument(A), B, C, D, E),
	insert_constraint_used_vars(F, B, C, G).
insert_constraint_body(A, C, D, E) :-
	get_store_type(A, B),
	insert_constraint_body(B, A, C, D, E).
insert_constraint_body(default, A, D, [], F) :-
	global_list_store_name(A, B),
	make_get_store_goal(B, E, G),
	make_update_store_goal(B, C, H),
	(   chr_pp_flag(debugable, on)
	->  C=[D|E],
	    F= (G, H)
	;   set_dynamic_suspension_term_field(global_list_prev, A, I, C, J),
	    F= (G, C=[D|E], H, (E=[I|_]->J;true))
	).
insert_constraint_body(multi_inthash(A), B, C, [], D) :-
	generate_multi_inthash_insert_constraint_bodies(A, B, C, D).
insert_constraint_body(multi_hash(A), B, C, E, D) :-
	generate_multi_hash_insert_constraint_bodies(A, B, C, D, E),
	sort_out_used_vars(E, _).
insert_constraint_body(global_ground, A, D, [], F) :-
	global_ground_store_name(A, B),
	make_get_store_goal(B, E, G),
	make_update_store_goal(B, C, H),
	(   chr_pp_flag(debugable, on)
	->  C=[D|E],
	    F= (G, H)
	;   set_dynamic_suspension_term_field(global_list_prev, A, I, C, J),
	    F= (G, C=[D|E], H, (E=[I|_]->J;true))
	).
insert_constraint_body(var_assoc_store(A, B), _, H, [A-D, B-G], C) :-
	get_target_module(E),
	C= (get_attr(D, E, F)->insert_assoc_store(F, G, H);new_assoc_store(F), put_attr(D, E, F), insert_assoc_store(F, G, H)).
insert_constraint_body(global_singleton, A, C, [], D) :-
	global_singleton_store_name(A, B),
	make_update_store_goal(B, C, E),
	D=E.
insert_constraint_body(multi_store(B), D, A, K, I) :-
	find_with_var_identity(F-E, [A], (member(C, B), chr_translate:insert_constraint_body(C, D, A, E, F)), G),
	once(pairup(H, J, G)),
	list2conj(H, I),
	sort_out_used_vars(J, K).
insert_constraint_body(identifier_store(B), D, I, A, G) :-
	A=[B-H],
	get_identifier_size(C),
	functor(F, struct, C),
	get_identifier_index(D, B, E),
	arg(E, F, J),
	G= (H=F, setarg(E, H, [I|J])).
insert_constraint_body(type_indexed_identifier_store(B, C), D, I, A, G) :-
	A=[B-H],
	type_indexed_identifier_structure(C, F),
	get_type_indexed_identifier_index(C, D, B, E),
	arg(E, F, J),
	G= (H=F, setarg(E, H, [I|J])).
sort_out_used_vars(A, D) :-
	flatten(A, B),
	sort(B, C),
	sort_out_used_vars1(C, D).
sort_out_used_vars1([], []).
sort_out_used_vars1([B-C], A) :- !,
	A=[B-C].
sort_out_used_vars1([A-C, B-D|E], F) :-
	(   A==B
	->  C=D,
	    sort_out_used_vars1([A-C|E], F)
	;   F=[A-C|G],
	    sort_out_used_vars1([B-D|E], G)
	).
generate_multi_inthash_insert_constraint_bodies([], _, _, true).
generate_multi_inthash_insert_constraint_bodies([B|I], A, C, (D, J)) :-
	multi_hash_store_name(A, B, F),
	multi_hash_key(A, B, C, E, H),
	D= (E, nb_getval(F, G), insert_iht(G, H, C)),
	generate_multi_inthash_insert_constraint_bodies(I, A, C, J).
generate_multi_hash_insert_constraint_bodies([], _, _, true, []).
generate_multi_hash_insert_constraint_bodies([B|J], A, C, (F, K), [D|L]) :-
	multi_hash_store_name(A, B, E),
	multi_hash_key_direct(A, B, C, I, D),
	make_get_store_goal(E, H, G),
	F= (G, insert_ht(H, I, C)),
	generate_multi_hash_insert_constraint_bodies(J, A, C, K, L).
delete_constraint_clause(A, B, C) :-
	(   is_used_auxiliary_predicate(delete_from_store, A)
	->  B=[D|C],
	    D= (E:-I),
	    delete_constraint_atom(A, H, E),
	    A=F/G,
	    functor(E, F, G),
	    delete_constraint_body(A, E, H, [], I)
	;   B=C
	).
delete_constraint_goal(A, E, G, F) :-
	functor(A, B, C),
	D=B/C,
	(   chr_pp_flag(inline_insertremove, off)
	->  use_auxiliary_predicate(delete_from_store, D),
	    delete_constraint_atom(D, E, F)
	;   delay_phase_end(validate_store_type_assumptions, delete_constraint_body(D, A, E, G, F))
	).
delete_constraint_atom(A, D, B) :-
	make_name('$delete_from_store_', A, C),
	B=..[C, D].
delete_constraint_body(C, E, F, G, A) :-
	A= (B, H),
	(   chr_pp_flag(store_counter, on)
	->  B='$delete_counter_inc'
	;   B=true
	),
	get_store_type(C, D),
	delete_constraint_body(D, C, E, F, G, H).
delete_constraint_body(default, A, _, F, _, C) :-
	(   chr_pp_flag(debugable, on)
	->  global_list_store_name(A, B),
	    make_get_store_goal(B, E, D),
	    make_update_store_goal(B, G, H),
	    C= (D, 'chr sbag_del_element'(E, F, G), H)
	;   get_dynamic_suspension_term_field(global_list_prev, A, F, J, K),
	    global_list_store_name(A, B),
	    make_get_store_goal(B, E, D),
	    make_update_store_goal(B, L, H),
	    set_dynamic_suspension_term_field(global_list_prev, A, I, _, M),
	    set_dynamic_suspension_term_field(global_list_prev, A, I, J, N),
	    C= (K, (var(J)->D, E=[_|L], H, (L=[I|_]->M;true);J=[_, _|L], setarg(2, J, L), (L=[I|_]->N;true)))
	).
delete_constraint_body(multi_inthash(A), B, _, C, _, D) :-
	generate_multi_inthash_delete_constraint_bodies(A, B, C, D).
delete_constraint_body(multi_hash(A), B, C, D, E, F) :-
	generate_multi_hash_delete_constraint_bodies(A, B, C, D, E, F).
delete_constraint_body(global_ground, A, _, F, _, C) :-
	(   chr_pp_flag(debugable, on)
	->  global_ground_store_name(A, B),
	    make_get_store_goal(B, E, D),
	    make_update_store_goal(B, G, H),
	    C= (D, 'chr sbag_del_element'(E, F, G), H)
	;   get_dynamic_suspension_term_field(global_list_prev, A, F, J, K),
	    global_ground_store_name(A, B),
	    make_get_store_goal(B, E, D),
	    make_update_store_goal(B, L, H),
	    set_dynamic_suspension_term_field(global_list_prev, A, I, _, M),
	    set_dynamic_suspension_term_field(global_list_prev, A, I, J, N),
	    C= (K, (var(J)->D, E=[_|L], H, (L=[I|_]->M;true);J=[_, _|L], setarg(2, J, L), (L=[I|_]->N;true)))
	).
delete_constraint_body(var_assoc_store(A, D), B, _, C, _, E) :-
	get_target_module(H),
	get_dynamic_suspension_term_field(argument(A), B, C, G, F),
	get_dynamic_suspension_term_field(argument(D), B, C, K, I),
	E= (F, get_attr(G, H, J), I, delete_assoc_store(J, K, C)).
delete_constraint_body(global_singleton, A, _, _, _, C) :-
	global_singleton_store_name(A, B),
	make_update_store_goal(B, [], D),
	C=D.
delete_constraint_body(multi_store(D), F, C, A, B, I) :-
	find_with_var_identity(G, [A/B/C], (member(E, D), chr_translate:delete_constraint_body(E, F, C, A, B, G)), H),
	list2conj(H, I).
delete_constraint_body(identifier_store(B), F, A, D, C, I) :-
	get_suspension_argument_possibly_in_scope(A, B, C, D, K, J),
	get_identifier_size(E),
	functor(H, struct, E),
	get_identifier_index(F, B, G),
	arg(G, H, L),
	I= (J, K=H, 'chr sbag_del_element'(L, D, M), setarg(G, K, M)).
delete_constraint_body(type_indexed_identifier_store(B, E), F, A, D, C, I) :-
	get_suspension_argument_possibly_in_scope(A, B, C, D, K, J),
	type_indexed_identifier_structure(E, H),
	get_type_indexed_identifier_index(E, F, B, G),
	arg(G, H, L),
	I= (J, K=H, 'chr sbag_del_element'(L, D, M), setarg(G, K, M)).
generate_multi_inthash_delete_constraint_bodies([], _, _, true).
generate_multi_inthash_delete_constraint_bodies([B|I], A, C, (D, J)) :-
	multi_hash_store_name(A, B, F),
	multi_hash_key(A, B, C, E, H),
	D= (E, nb_getval(F, G), delete_iht(G, H, C)),
	generate_multi_inthash_delete_constraint_bodies(I, A, C, J).
generate_multi_hash_delete_constraint_bodies([], _, _, _, _, true).
generate_multi_hash_delete_constraint_bodies([B|L], A, C, D, E, (G, M)) :-
	multi_hash_store_name(A, B, F),
	multi_hash_key(A, C, B, D, E, H, K),
	make_get_store_goal(F, J, I),
	G= (H, I, delete_ht(J, K, D)),
	generate_multi_hash_delete_constraint_bodies(L, _, C, D, E, M).
generate_attach_code(A, [B|C]) :-
	enumerate_stores_code(A, B),
	generate_attach_code(A, C, D),
	module_initializers(E),
	prolog_global_variables_code(F),
	D=[ ('$chr_initialization':-E), (:-'$chr_initialization')|F].
generate_attach_code([], A, A).
generate_attach_code([A|D], C, F) :-
	get_store_type(A, B),
	generate_attach_code(B, A, C, E),
	generate_attach_code(D, E, F).
generate_attach_code(default, A, B, C) :-
	global_list_store_initialisation(A, B, C).
generate_attach_code(multi_inthash(A), B, C, E) :-
	multi_inthash_store_initialisations(A, B, C, D),
	multi_inthash_via_lookups(A, B, D, E).
generate_attach_code(multi_hash(A), B, C, E) :-
	multi_hash_store_initialisations(A, B, C, D),
	multi_hash_via_lookups(A, B, D, E).
generate_attach_code(global_ground, A, B, C) :-
	global_ground_store_initialisation(A, B, C).
generate_attach_code(var_assoc_store(_, _), _, A, A) :-
	use_auxiliary_module(chr_assoc_store).
generate_attach_code(global_singleton, A, B, C) :-
	global_singleton_store_initialisation(A, B, C).
generate_attach_code(multi_store(A), B, C, D) :-
	multi_store_generate_attach_code(A, B, C, D).
generate_attach_code(identifier_store(B), A, L, P) :-
	get_identifier_index(A, B, C),
	(   C==2
	->  get_identifier_size(D),
	    functor(E, struct, D),
	    E=..[_, G|F],
	    set_elems(F, []),
	    M=new_identifier(G, E),
	    functor(H, struct, D),
	    arg(1, H, I),
	    N= (user:portray(H):-write('<id:'), print(I), write(>)),
	    functor(J, struct, D),
	    arg(1, J, K),
	    O=identifier_label(J, K),
	    L=[M, N, O|P]
	;   L=P
	).
generate_attach_code(type_indexed_identifier_store(C, A), B, E, M1) :-
	get_type_indexed_identifier_index(A, B, C, D),
	(   D==2
	->  identifier_store_initialization(A, E, H1),
	    get_type_indexed_identifier_size(A, _),
	    type_indexed_identifier_structure(A, F),
	    F=..[_, I|G],
	    set_elems(G, []),
	    type_indexed_identifier_name(A, new_identifier, H),
	    P=..[H, I, F],
	    N=..[H, K, M],
	    type_indexed_identifier_structure(A, J),
	    J=..[_, K|L],
	    set_elems(L, []),
	    O= (M=J),
	    Q=user:goal_expansion(N, O),
	    writeln(P-Q),
	    type_indexed_identifier_structure(A, R),
	    arg(1, R, S),
	    I1= (user:portray(R):-write('<id:'), print(S), write(>)),
	    type_indexed_identifier_structure(A, T),
	    arg(1, T, V),
	    type_indexed_identifier_name(A, identifier_label, U),
	    J1=..[U, T, V],
	    Y=..[U, _, X],
	    type_indexed_identifier_structure(A, W),
	    arg(1, W, X),
	    Z= (_=W),
	    K1= (user:goal_expansion(Y, Z):-writeln(expanding)),
	    identifier_store_name(A, E1),
	    lookup_identifier_atom(A, B1, C1, D1),
	    type_indexed_identifier_name(A, new_identifier, A1),
	    G1=..[A1, B1, C1],
	    L1= (D1:-nb_getval(E1, F1), (lookup_ht(F1, B1, [C1])->true;G1, insert_ht(F1, B1, C1))),
	    H1=[ (:-multifile goal_expansion/2), (:-dynamic goal_expansion/2), P, Q, I1, J1, K1, L1|M1]
	;   E=M1
	).
lookup_identifier_atom(A, D, E, B) :-
	atom_concat(lookup_identifier_, A, C),
	B=..[C, D, E].
identifier_label_atom(A, D, E, B) :-
	type_indexed_identifier_name(A, identifier_label, C),
	B=..[C, D, E].
multi_store_generate_attach_code([], _, A, A).
multi_store_generate_attach_code([A|D], B, C, F) :-
	generate_attach_code(A, B, C, E),
	multi_store_generate_attach_code(D, B, E, F).
multi_inthash_store_initialisations([], _, A, A).
multi_inthash_store_initialisations([B|F], A, E, H) :-
	use_auxiliary_module(chr_integertable_store),
	multi_hash_store_name(A, B, C),
	module_initializer((new_iht(D), nb_setval(C, D))),
	G=E,
	multi_inthash_store_initialisations(F, A, G, H).
multi_hash_store_initialisations([], _, A, A).
multi_hash_store_initialisations([B|G], A, F, I) :-
	use_auxiliary_module(chr_hashtable_store),
	multi_hash_store_name(A, B, C),
	prolog_global_variable(C),
	make_init_store_goal(C, D, E),
	module_initializer((new_ht(D), E)),
	H=F,
	multi_hash_store_initialisations(G, A, H, I).
global_list_store_initialisation(A, D, E) :-
	(   is_stored(A)
	->  global_list_store_name(A, B),
	    prolog_global_variable(B),
	    make_init_store_goal(B, [], C),
	    module_initializer(C)
	;   true
	),
	D=E.
global_ground_store_initialisation(A, D, E) :-
	global_ground_store_name(A, B),
	prolog_global_variable(B),
	make_init_store_goal(B, [], C),
	module_initializer(C),
	D=E.
global_singleton_store_initialisation(A, D, E) :-
	global_singleton_store_name(A, B),
	prolog_global_variable(B),
	make_init_store_goal(B, [], C),
	module_initializer(C),
	D=E.
identifier_store_initialization(A, E, F) :-
	use_auxiliary_module(chr_hashtable_store),
	identifier_store_name(A, B),
	prolog_global_variable(B),
	make_init_store_goal(B, C, D),
	module_initializer((new_ht(C), D)),
	E=F.
multi_inthash_via_lookups([], _, A, A).
multi_inthash_via_lookups([B|J], A, G, L) :-
	multi_hash_via_lookup_goal(A, B, E, F, H),
	multi_hash_store_name(A, B, C),
	I= (nb_getval(C, D), lookup_iht(D, E, F)),
	G=[ (H:-I)|K],
	multi_inthash_via_lookups(J, A, K, L).
multi_hash_via_lookups([], _, A, A).
multi_hash_via_lookups([B|K], A, H, M) :-
	multi_hash_via_lookup_goal(A, B, F, G, I),
	multi_hash_store_name(A, B, C),
	make_get_store_goal(C, E, D),
	J= (D, lookup_ht(E, F, G)),
	H=[ (I:-J)|L],
	multi_hash_via_lookups(K, A, L, M).
multi_hash_via_lookup_goal(A, B, E, F, C) :-
	multi_hash_via_lookup_name(A, B, D),
	C=..[D, E, F].
multi_hash_via_lookup_name(C/D, A, E) :-
	(   integer(A)
	->  B=A
	;   is_list(A)
	->  atom_concat_list(A, B)
	),
	atom_concat_list(['$via1_multi_hash_', C, /, D, -, B], E).
multi_hash_store_name(D/E, A, F) :-
	get_target_module(C),
	(   integer(A)
	->  B=A
	;   is_list(A)
	->  atom_concat_list(A, B)
	),
	atom_concat_list(['$chr_store_multi_hash_', C, :, D, /, E, -, B], F).
multi_hash_key(C, A, D, F, E) :-
	(   (   integer(A)
	    ->  B=A
	    ;   A=[B]
	    )
	->  get_dynamic_suspension_term_field(argument(B), C, D, E, F)
	;   is_list(A)
	->  sort(A, G),
	    find_with_var_identity(I-H, [D], (member(B, G), get_dynamic_suspension_term_field(argument(B), C, D, H, I)), J),
	    once(pairup(L, K, J)),
	    E=..[k|K],
	    list2conj(L, F)
	).
multi_hash_key(_, C, A, E, D, G, F) :-
	(   (   integer(A)
	    ->  B=A
	    ;   A=[B]
	    )
	->  get_suspension_argument_possibly_in_scope(C, B, D, E, F, G)
	;   is_list(A)
	->  sort(A, H),
	    find_with_var_identity(J-I, [E/C/D], (member(B, H), get_suspension_argument_possibly_in_scope(C, B, D, E, I, J)), K),
	    once(pairup(M, L, K)),
	    F=..[k|L],
	    list2conj(M, G)
	).
get_suspension_argument_possibly_in_scope(B, A, C, J, E, F) :-
	arg(A, B, D),
	(   lookup_eq(C, D, E)
	->  F=true
	;   functor(B, G, H),
	    I=G/H,
	    get_dynamic_suspension_term_field(argument(A), I, J, E, F)
	).
multi_hash_key_direct(_, A, _, D, C) :-
	(   (   integer(A)
	    ->  B=A
	    ;   A=[B]
	    )
	->  C=[B-D]
	;   is_list(A)
	->  sort(A, E),
	    pairup(E, F, C),
	    D=..[k|F]
	).
multi_hash_key_args(A, B, C) :-
	(   integer(A)
	->  arg(A, B, D),
	    C=[D]
	;   is_list(A)
	->  sort(A, F),
	    term_variables(B, E),
	    find_with_var_identity(D, E, (member(G, F), arg(G, B, D)), C)
	).
global_list_store_name(B/C, D) :-
	get_target_module(A),
	atom_concat_list(['$chr_store_global_list_', A, :, B, /, C], D).
global_ground_store_name(B/C, D) :-
	get_target_module(A),
	atom_concat_list(['$chr_store_global_ground_', A, :, B, /, C], D).
global_singleton_store_name(B/C, D) :-
	get_target_module(A),
	atom_concat_list(['$chr_store_global_singleton_', A, :, B, /, C], D).
identifier_store_name(B, C) :-
	get_target_module(A),
	atom_concat_list(['$chr_identifier_lookup_', A, :, B], C).
prolog_global_variables_code(B) :-
	prolog_global_variables(A),
	(   A==[]
	->  B=[]
	;   findall('$chr_prolog_global_variable'(C), member(C, A), D),
	    B=[ (:-dynamic user:exception/3), (:-multifile user:exception/3), (user:exception(undefined_global_variable, C, retry):-'$chr_prolog_global_variable'(C), '$chr_initialization')|D]
	).
sbag_member_call(A, B, 'chr sbag_member'(A, B)).
update_mutable_call(A, B, 'chr update_mutable'(A, B)).
create_mutable_call(B, A, true) :-
	A=mutable(B).
get_suspension_field(B, C, A, D, E) :-
	get_dynamic_suspension_term_field(A, B, C, D, E).
update_suspension_field(B, C, A, D, E) :-
	set_dynamic_suspension_term_field(A, B, C, D, E).
get_update_suspension_field(B, C, A, D, F, true, E, G) :-
	get_dynamic_suspension_term_field(A, B, C, D, E),
	set_dynamic_suspension_term_field(A, B, C, F, G).
create_static_suspension_field(B, C, A, D, true) :-
	get_static_suspension_term_field(A, B, C, D).
get_static_suspension_field(B, C, A, D, true) :-
	get_static_suspension_term_field(A, B, C, D).
get_update_static_suspension_field(B, E, C, A, D, F, true, G) :-
	get_static_suspension_term_field(A, B, C, D),
	set_dynamic_suspension_term_field(A, B, E, F, G).
enumerate_stores_code(A, D) :-
	E='$enumerate_constraints'(B),
	enumerate_store_bodies(A, B, C),
	list2disj(C, F),
	D= (E:-F).
enumerate_store_bodies([], _, []).
enumerate_store_bodies([A|M], H, J) :-
	(   is_stored(A)
	->  get_store_type(A, B),
	    enumerate_store_body(B, A, C, F),
	    get_dynamic_suspension_term_field(arguments, A, C, E, G),
	    A=D/_,
	    I=..[D|E],
	    K= (F, G, H=I),
	    J=[K|L]
	;   J=L
	),
	enumerate_store_bodies(M, H, L).
enumerate_store_body(default, A, B, E) :-
	global_list_store_name(A, C),
	sbag_member_call(B, D, G),
	make_get_store_goal(C, D, F),
	E= (F, G).
enumerate_store_body(multi_inthash([A|_]), B, C, D) :-
	multi_inthash_enumerate_store_body(A, B, C, D).
enumerate_store_body(multi_hash([A|_]), B, C, D) :-
	multi_hash_enumerate_store_body(A, B, C, D).
enumerate_store_body(global_ground, A, B, E) :-
	global_ground_store_name(A, C),
	sbag_member_call(B, D, G),
	make_get_store_goal(C, D, F),
	E= (F, G).
enumerate_store_body(var_assoc_store(_, _), _, _, A) :-
	A=fail.
enumerate_store_body(global_singleton, A, C, D) :-
	global_singleton_store_name(A, B),
	make_get_store_goal(B, C, E),
	D= (E, C\==[]).
enumerate_store_body(multi_store(A), C, D, E) :-
	once((
	    member(B, A),
	    enumerate_store_body(B, C, D, E)
	    )).
enumerate_store_body(identifier_store(_), _, _, A) :-
	A=fail.
enumerate_store_body(type_indexed_identifier_store(_, _), _, _, A) :-
	A=fail.
multi_inthash_enumerate_store_body(B, A, F, C) :-
	multi_hash_store_name(A, B, D),
	C= (nb_getval(D, E), value_iht(E, F)).
multi_hash_enumerate_store_body(B, A, G, D) :-
	multi_hash_store_name(A, B, C),
	make_get_store_goal(C, F, E),
	D= (E, value_ht(F, G)).
guard_simplification :-
	(   chr_pp_flag(guard_simplification, on)
	->  simplify_guards(1)
	;   true
	).
head_types_modes_condition([], _, true).
head_types_modes_condition([B|D], A, (C, E)) :-
	types_modes_condition(A, B, C),
	head_types_modes_condition(D, A, E).
normalize_conj_list(A, C) :-
	list2conj(A, B),
	conj2list(B, C).
compute_derived_info([], _, _, _, _, _, _, _, [], []).
compute_derived_info([D|Z], A, H, G, B, A1, U, B1, [R|C1], [Y|D1]) :-
	copy_term(A-B, C),
	variable_replacement(A-B, C, E),
	append(D, E, J),
	list2conj(A, F),
	negate_b(F, N),
	make_head_matchings_explicit_not_negated2(G, H, I),
	list2conj(I, P),
	term_variables(J, L),
	term_variables(A-B-I, K),
	new_vars(K, L, M),
	append(J, M, S),
	(   B==true
	->  O=N
	;   negate_b(B, Q),
	    O= (N;P, Q)
	),
	copy_with_variable_replacement(O, R, S),
	copy_with_variable_replacement(B, V, S),
	copy_with_variable_replacement(A, T, S),
	list2conj(T, X),
	apply_guard_wrt_term(U, V, W),
	apply_guard_wrt_term(W, X, Y),
	compute_derived_info(Z, A, H, G, B, A1, U, B1, C1, D1).
simplify_guard(A, C, B, G, E) :-
	conj2list(A, D),
	guard_entailment:simplify_guards(B, C, D, F, E),
	list2conj(F, G).
new_vars([], _, []).
new_vars([A|C], B, D) :-
	(   memberchk_eq(A, B)
	->  new_vars(C, B, D)
	;   D=[A-E, E-A|F],
	    new_vars(C, B, F)
	).
head_subset(A, B, C) :-
	head_subset(A, B, C, [], _).
head_subset([], B, A, A, B).
head_subset([A|D], B, F, C, H) :-
	head_member(A, B, G, C, E),
	head_subset(D, E, F, G, H).
head_member(A, [B|F], D, C, E) :-
	(   variable_replacement(A, B, C, D),
	    E=F
	;   head_member(A, F, D, C, G),
	    E=[B|G]
	).
make_head_matchings_explicit(A, E, C) :-
	extract_arguments(A, B),
	make_matchings_explicit(B, D, [], [], _, C),
	substitute_arguments(A, D, E).
make_head_matchings_explicit_not_negated(A, E, C) :-
	extract_arguments(A, B),
	make_matchings_explicit_not_negated(B, D, C),
	substitute_arguments(A, D, E).
make_head_matchings_explicit_not_negated2(A, B, E) :-
	extract_arguments(A, C),
	extract_arguments(B, D),
	make_matchings_explicit_not_negated(C, D, E).
extract_arguments([], []).
extract_arguments([A|D], C) :-
	A=..[_|B],
	append(B, E, C),
	extract_arguments(D, E).
substitute_arguments([], [], []).
substitute_arguments([A|G], C, [D|I]) :-
	functor(A, E, B),
	split_at(B, C, F, H),
	D=..[E|F],
	substitute_arguments(G, H, I).
make_matchings_explicit([], [], _, A, A, []).
make_matchings_explicit([A|T], [F|U], B, C, V, D) :-
	(   var(A)
	->  (   memberchk_eq(A, B)
	    ->  list2disj(C, E),
		D=[ (E;F==A)|G],
		H=B
	    ;   D=G,
		F=A,
		H=[A|B]
	    ),
	    Q=C
	;   functor(A, I, M),
	    A=..[I|J],
	    make_matchings_explicit(J, K, B, C, R, L),
	    N=..[I|K],
	    (   L==[]
	    ->  D=[functor(F, I, M)|G]
	    ;   list2conj(L, O),
		list2disj(C, E),
		P= (F\=N;E;O),
		D=[functor(F, I, M), P|G]
	    ),
	    Q=[F\=N|R],
	    term_variables(J, S),
	    append(B, S, H)
	),
	make_matchings_explicit(T, U, H, Q, V, G).
make_matchings_explicit_not_negated([], [], []).
make_matchings_explicit_not_negated([C|D], [B|E], A) :-
	A=[B=C|F],
	make_matchings_explicit_not_negated(D, E, F).
apply_guard_wrt_term([], _, []).
apply_guard_wrt_term([A|G], B, [C|H]) :-
	(   var(A)
	->  apply_guard_wrt_variable(B, A, C)
	;   A=..[E|D],
	    apply_guard_wrt_term(D, B, F),
	    C=..[E|F]
	),
	apply_guard_wrt_term(G, B, H).
apply_guard_wrt_variable((A, C), B, E) :- !,
	apply_guard_wrt_variable(A, B, D),
	apply_guard_wrt_variable(C, D, E).
apply_guard_wrt_variable(A, B, D) :-
	(   A= (C=E),
	    B==C
	->  D=E
	;   A=functor(F, G, H),
	    B==F,
	    ground(G),
	    ground(H)
	->  functor(D, G, H)
	;   D=B
	).
replace_some_heads(A, B, _, [], A, B, _, _, []) :- !.
replace_some_heads([], [M|D], [A|E], [B|F], [], [C|G], H, I, J) :- !,
	(   A==B
	->  C=B,
	    replace_some_heads([], D, E, F, [], G, H, I, J)
	;   B=functor(K, N, L),
	    A==K
	->  length(O, L),
	    (   var(M)
	    ->  Q=[],
		C=..[N|O]
	    ;   M=..[N|P],
		use_same_args(P, O, R, H, I, Q),
		C=..[N|R]
	    ),
	    replace_some_heads([], D, E, F, [], G, H, I, S),
	    append(Q, S, J)
	;   C=M,
	    replace_some_heads([], D, E, [B|F], [], G, H, I, J)
	).
replace_some_heads([O|D], E, [A|F], [B|G], [C|H], I, J, K, L) :- !,
	(   A==B
	->  C=B,
	    replace_some_heads(D, E, F, G, H, I, J, K, L)
	;   B=functor(M, P, N),
	    A==M
	->  length(Q, N),
	    (   var(O)
	    ->  S=[],
		C=..[P|Q]
	    ;   O=..[P|R],
		use_same_args(R, Q, T, J, K, S),
		C=..[P|T]
	    ),
	    replace_some_heads(D, E, F, G, H, I, J, K, U),
	    append(S, U, L)
	;   C=O,
	    replace_some_heads(D, E, F, [B|G], H, I, J, K, L)
	).
use_same_args([], [], [], _, _, []).
use_same_args([A|C], [_|D], [B|E], F, G, H) :-
	var(A), !,
	B=A,
	use_same_args(C, D, E, F, G, H).
use_same_args([A|G], [D|H], [F|I], J, B, C) :-
	nonvar(A), !,
	(   vars_occur_in(A, B)
	->  C=[D=A|E]
	;   C=E
	),
	F=D,
	use_same_args(G, H, I, J, B, E).
simplify_heads([], _, _, _, [], []).
simplify_heads([A|C], D, F, I, H, G) :-
	A= (E=B),
	(   (   nonvar(B)
	    ;   vars_occur_in(B, C-D)
	    ),
	    guard_entailment:entails_guard(D, E=B)
	->  (   vars_occur_in(B, F-C-D)
	    ->  G=J,
		H=K
	    ;   (   vars_occur_in(B, I)
		->  G=[E=B|J]
		;   G=J
		),
		H=[E|K]
	    )
	;   nonvar(B),
	    functor(B, L, M),
	    guard_entailment:entails_guard([functor(E, L, M)|D], E=B)
	->  G=J,
	    (   vars_occur_in(B, F-C-D)
	    ->  H=K
	    ;   H=[functor(E, L, M)|K]
	    )
	;   H=K,
	    G=J
	),
	simplify_heads(C, [A|D], F, I, K, J).
vars_occur_in(A, B) :-
	term_variables(A, C),
	term_variables(B, D),
	intersect_eq(C, D, E),
	E\==[].
flatten_stuff([A|B], E) :- !,
	flatten_stuff(A, C),
	flatten_stuff(B, D),
	append(C, D, E).
flatten_stuff((A;B), E) :- !,
	flatten_stuff(A, C),
	flatten_stuff(B, D),
	append(C, D, E).
flatten_stuff((A, B), E) :- !,
	flatten_stuff(A, C),
	flatten_stuff(B, D),
	append(C, D, E).
flatten_stuff(chr_pp_not_in_store(A), [A]) :- !.
flatten_stuff(_, []).
unify_stuff(_, [], []).
unify_stuff(H, [A|K], [B|L]) :-
	A\==B,
	term_variables(A, C),
	term_variables(B, D),
	intersect_eq(C, D, E),
	check_safe_unif(A, B, E),
	variable_replacement(A, B, F),
	check_replacement(F),
	term_variables(F, G),
	list_difference_eq(G, C, I),
	intersect_eq(H, I, J),
	J==[],
	A=B,
	unify_stuff(H, K, L), !.
unify_stuff(A, B, [_|C]) :-
	unify_stuff(A, B, C).
unify_stuff(A, [_|B], C) :-
	unify_stuff(A, B, C).
check_safe_unif(A, B, C) :-
	var(A), !,
	var(B),
	(   (   memberchk_eq(A, C)
	    ;   memberchk_eq(B, C)
	    )
	->  A==B
	;   true
	).
check_safe_unif([], [], _) :- !.
check_safe_unif([A|D], [B|E], C) :- !,
	check_safe_unif(A, B, C), !,
	check_safe_unif(D, E, C).
check_safe_unif(A, B, F) :-
	nonvar(A), !,
	nonvar(B),
	A=..[C|D],
	B=..[C|E],
	check_safe_unif(D, E, F).
check_safe_unif2(A, _) :-
	var(A), !.
check_safe_unif2([], []) :- !.
check_safe_unif2([A|C], [B|D]) :- !,
	check_safe_unif2(A, B), !,
	check_safe_unif2(C, D).
check_safe_unif2(A, B) :-
	nonvar(A), !,
	nonvar(B),
	A=..[C|D],
	B=..[C|E],
	check_safe_unif2(D, E).
check_replacement(A) :-
	check_replacement(A, B),
	sort(B, C),
	length(C, D), !,
	length(B, D).
check_replacement([], []).
check_replacement([A-_|B], [A|C]) :-
	check_replacement(B, C).
add_failing_occ(A, D, E, G, S, R, _, H, M) :-
	A=pragma(rule(_, _, N, _), ids(C, B), _, _, _),
	append(B, C, F),
	missing_partner_cond(D, E, F, G, Q, I, H),
	copy_term((I, D, E), (J, K, L)),
	variable_replacement((I, D, E), (J, K, L), M),
	copy_with_variable_replacement(N, O, M),
	extract_explicit_matchings(O, P),
	negate_b(P, T),
	copy_with_variable_replacement(Q, U, M),
	(   check_safe_unif2(R, J),
	    R=J
	->  S=[ (T;U)]
	;   S=[chr_pp_void_info]
	).
missing_partner_cond([], [], [], _, fail, _, _).
missing_partner_cond([B|C], [_|D], [A|E], A, F, B, G) :- !,
	missing_partner_cond(C, D, E, A, F, B, G).
missing_partner_cond([B|C], [_|D], [_|E], F, A, H, I/J) :-
	A= (chr_pp_not_in_store(B);G),
	missing_partner_cond(C, D, E, F, G, H, I/J).
extract_explicit_matchings(A=B) :-
	var(A),
	var(B), !,
	A=B.
extract_explicit_matchings(A==B) :-
	var(A),
	var(B), !,
	A=B.
extract_explicit_matchings((A, B), C) :- !,
	(   extract_explicit_matchings(A)
	->  extract_explicit_matchings(B, C)
	;   C= (A, D),
	    extract_explicit_matchings(B, D)
	).
extract_explicit_matchings(A, B) :- !,
	(   extract_explicit_matchings(A)
	->  B=true
	;   B=A
	).
oneway_unification(A, C) :-
	term_variables(A, B),
	chr_runtime:lockv(B),
	A=C,
	chr_runtime:unlockv(B).
get_type_definition_det(A, B) :-
	(   get_type_definition(A, B)
	->  true
	;   chr_error(type, 'Could not find type definition for type `~w\'.\n', [A])
	).
get_constraint_type_det(A, B) :-
	(   get_constraint_type(A, B)
	->  true
	;   A=_/C,
	    replicate(C, any, B)
	).
modes_condition([], [], true).
modes_condition([A|E], [C|F], B) :-
	(   A== (+)
	->  B= (ground(C), D)
	;   A== (-)
	->  B= (var(C), D)
	;   B=D
	),
	modes_condition(E, F, D).
types_condition([], [], [], [], true).
types_condition([B|I], [D|J], [E|K], [A|L], (H, M)) :-
	(   A== (-)
	->  F=[true]
	;   get_type_definition_det(B, C),
	    type_condition(C, D, E, A, G),
	    (   A== (+)
	    ->  F=G
	    ;   F=[\+ground(D)|G]
	    )
	),
	list2disj(F, H),
	types_condition(I, J, K, L, M).
type_condition([], _, _, _, []).
type_condition([A|F], B, D, E, [C|G]) :-
	(   var(A)
	->  chr_error(type, 'Unexpected variable type in type definition!\n', [])
	;   atomic_builtin_type(A, B, C)
	->  true
	;   compound_builtin_type(A, B, C)
	->  true
	;   type_def_case_condition(A, B, D, E, C)
	),
	type_condition(F, B, D, E, G).
atomic_builtin_type(any, _, true).
atomic_builtin_type(dense_int, A, (integer(A), A>=0)).
atomic_builtin_type(int, A, integer(A)).
atomic_builtin_type(number, A, number(A)).
atomic_builtin_type(float, A, float(A)).
atomic_builtin_type(natural, A, (integer(A), A>=0)).
atomic_builtin_type(chr_identifier, _, true).
compound_builtin_type(chr_identifier(_), _, true).
type_def_case_condition(A, D, E, H, C) :-
	(   nonvar(A)
	->  functor(A, F, B),
	    (   B==0
	    ->  C= (D=A)
	    ;   var(E)
	    ->  C=functor(D, F, B)
	    ;   functor(E, F, B)
	    ->  C= (functor(D, F, B), D=G, M),
		A=..[_|I],
		E=..[_|K],
		functor(G, F, B),
		G=..[_|J],
		replicate(B, H, L),
		types_condition(I, J, K, L, M)
	    ;   C=functor(D, F, B)
	    )
	;   chr_error(internal, 'Illegal type definition (must be nonvar).\n', [])
	).
static_type_check_heads([]).
static_type_check_heads([A|B]) :-
	static_type_check_head(A),
	static_type_check_heads(B).
static_type_check_head(A) :-
	functor(A, B, C),
	get_constraint_type_det(B/C, E),
	A=..[_|D],
	maplist(static_type_check_term(head(A)), D, E).
static_type_check_body([]).
static_type_check_body([A|F]) :-
	functor(A, B, C),
	get_constraint_type_det(B/C, E),
	A=..[_|D],
	maplist(static_type_check_term(body(A)), D, E),
	static_type_check_body(F).
format_src(head(A)) :-
	format('head ~w', [A]).
format_src(body(A)) :-
	format('body goal ~w', [A]).
generate_dynamic_type_check_clauses(D) :-
	(   chr_pp_flag(debugable, on)
	->  dynamic_type_check,
	    get_dynamic_type_check_clauses(A),
	    append(A, [ ('$dynamic_type_check'(B, C):-throw(error(type_error(B, C), context(_, 'CHR Runtime Type Error'))))], D)
	;   D=[]
	).
dynamic_type_check_clause(A, B, J) :-
	copy_term(A-B, K-C),
	functor(C, D, E),
	functor(F, D, E),
	C=..[_|G],
	F=..[_|H],
	maplist(dynamic_type_check_call, G, H, I),
	list2conj(I, L),
	J= ('$dynamic_type_check'(K, F):-L).
dynamic_type_check_alias_clause(B, C, A) :-
	A= ('$dynamic_type_check'(B, D):-'$dynamic_type_check'(C, D)).
dynamic_type_check_call(A, C, B) :-
	(   A==any
	->  B=true
	;   B=when(nonvar(C), once('$dynamic_type_check'(A, C)))
	).
atomic_types_suspended_constraint(A) :-
	A=_/B,
	get_constraint_type(A, D),
	get_constraint_mode(A, E),
	findall(C, between(1, B, C), F),
	maplist(atomic_types_suspended_constraint(A), D, E, F).
atomic_types_suspended_constraint(A, D, C, B) :-
	(   is_indexed_argument(A, B)
	->  (   C== (?)
	    ->  atomic_type(D)
	    ;   true
	    )
	;   true
	).
storage_analysis(A) :-
	(   chr_pp_flag(storage_analysis, on)
	->  check_constraint_storages(A)
	;   true
	).
check_constraint_storages([]).
check_constraint_storages([A|B]) :-
	check_constraint_storage(A),
	check_constraint_storages(B).
check_constraint_storage(A) :-
	get_max_occurrence(A, B),
	check_occurrences_storage(A, 1, B).
check_occurrences_storage(C, A, B) :-
	(   A>B
	->  stored_completing(C, 1, 0)
	;   check_occurrence_storage(C, A),
	    D is A+1,
	    check_occurrences_storage(C, D, B)
	).
check_occurrence_storage(A, B) :-
	get_occurrence(A, B, C, D),
	(   is_passive(C, D)
	->  stored(A, B, maybe)
	;   get_rule(C, E),
	    E=pragma(rule(G, I, J, M), ids(F, K), _, _, _),
	    (   select2(D, H, F, G, _, _)
	    ->  check_storage_head1(H, B, G, I, J)
	    ;   select2(D, L, K, I, _, _)
	    ->  check_storage_head2(L, B, G, M)
	    )
	).
check_storage_head1(A, I, D, E, F) :-
	functor(A, B, C),
	H=B/C,
	(   D==[A],
	    E==[],
	    guard_entailment:entails_guard([chr_pp_headvariables(A)], F),
	    A=..[_|G],
	    no_matching(G, [])
	->  stored(H, I, no)
	;   stored(H, I, maybe)
	).
no_matching([], _).
no_matching([A|C], B) :-
	var(A),
	\+memberchk_eq(A, B),
	no_matching(C, [A|B]).
check_storage_head2(A, G, D, E) :-
	functor(A, B, C),
	F=B/C,
	(   D\==[],
	    E==true
	->  stored(F, G, maybe)
	;   stored(F, G, yes)
	).
constraints_code(A, C) :-
	(   chr_pp_flag(reduced_indexing, on),
	    \+forsome(B, A, \+chr_translate:only_ground_indexed_arguments(B))
	->  none_suspended_on_variables
	;   true
	),
	constraints_code1(A, C, []).
constraint_prelude(B/A, K) :-
	vars_susp(A, C, E, D),
	L=..[B|C],
	make_suspension_continuation_goal(B/A, D, G),
	build_head(B, A, [0], D, Q),
	(   chr_pp_flag(debugable, on)
	->  insert_constraint_goal(B/A, E, C, N),
	    attach_constraint_atom(B/A, F, E, O),
	    delay_phase_end(validate_store_type_assumptions, chr_translate:update_suspension_field(B/A, E, state, inactive, P)),
	    insert_constraint_internal_constraint_goal(B/A, F, E, G, C, M),
	    (   get_constraint_type(B/A, H)
	    ->  maplist(dynamic_type_check_call, H, C, I),
		list2conj(I, J)
	    ;   J=true
	    ),
	    K= (L:-J, M, N, O, P, 'chr debug_event'(insert(#(L, E))), ('chr debug_event'(call(E)), Q;'chr debug_event'(fail(E)), !, fail), ('chr debug_event'(exit(E));'chr debug_event'(redo(E)), fail))
	;   get_allocation_occurrence(B/A, 0)
	->  gen_insert_constraint_internal_goal(B/A, R, D, C, E),
	    delay_phase_end(validate_store_type_assumptions, chr_translate:update_suspension_field(B/A, E, state, inactive, P)),
	    K= (L:-R, P, Q)
	;   K= (L:-Q)
	).
make_suspension_continuation_goal(A/B, C, D) :-
	(   may_trigger(A/B)
	->  build_head(A, B, [0], C, E),
	    (   chr_pp_flag(debugable, off)
	    ->  D=E
	    ;   get_target_module(F),
		D=F:E
	    )
	;   D=true
	).
gen_cond_attach_clause(A/B, I, K, M) :-
	(   is_finally_stored(A/B)
	->  get_allocation_occurrence(A/B, D),
	    get_max_occurrence(A/B, C),
	    (   chr_pp_flag(debugable, off),
		C<D
	    ->  (   only_ground_indexed_arguments(A/B)
		->  gen_insert_constraint_internal_goal(A/B, E, F, G, H)
		;   gen_cond_attach_goal(A/B, E, F, G, H)
		)
	    ;   vars_susp(B, G, H, F),
		gen_uncond_attach_goal(A/B, H, G, E, _)
	    ),
	    build_head(A, B, I, F, J),
	    L= (J:-E),
	    K=[L|M]
	;   K=M
	).
gen_cond_attach_goal(E/A, J, D, B, C) :-
	vars_susp(A, B, C, D),
	make_suspension_continuation_goal(E/A, D, H),
	(   get_store_type(E/A, var_assoc_store(_, _))
	->  F=true
	;   attach_constraint_atom(E/A, G, C, F)
	),
	_=..[E|B],
	insert_constraint_goal(E/A, C, B, I),
	insert_constraint_internal_constraint_goal(E/A, G, C, H, B, K),
	(   may_trigger(E/A)
	->  activate_constraint_goal(E/A, (I, F), G, C, _, L),
	    J= (var(C)->K, I, F;L)
	;   J= (K, I, F)
	).
gen_insert_constraint_internal_goal(E/A, I, D, B, C) :-
	vars_susp(A, B, C, D),
	make_suspension_continuation_goal(E/A, D, H),
	(   \+only_ground_indexed_arguments(E/A),
	    \+get_store_type(E/A, var_assoc_store(_, _))
	->  attach_constraint_atom(E/A, G, C, F)
	;   F=true
	),
	_=..[E|B],
	insert_constraint_goal(E/A, C, B, K),
	insert_constraint_internal_constraint_goal(E/A, G, C, H, B, J),
	(   only_ground_indexed_arguments(E/A),
	    chr_pp_flag(debugable, off)
	->  I= (J, K)
	;   I= (J, K, F)
	).
gen_uncond_attach_goal(A, B, D, H, G) :-
	(   \+only_ground_indexed_arguments(A),
	    \+get_store_type(A, var_assoc_store(_, _))
	->  attach_constraint_atom(A, F, B, C)
	;   C=true
	),
	insert_constraint_goal(A, B, D, E),
	(   chr_pp_flag(late_allocation, on)
	->  activate_constraint_goal(A, (E, C), F, B, G, H)
	;   activate_constraint_goal(A, true, F, B, G, H)
	).
head1_code(E, H, F, G, A, K, L, M, N, O) :-
	A=pragma(B, _, _, _, D),
	B=rule(_, C, _, _),
	(   C==[]
	->  reorder_heads(D, E, F, G, I, J),
	    simplification_code(E, H, I, J, A, K, L, M, N, O)
	;   simpagation_head1_code(E, H, F, G, A, K, L, M, N, O)
	).
head2_code(E, H, F, G, A, K, L, M, N, O) :-
	A=pragma(B, _, _, _, D),
	B=rule(C, _, _, _),
	(   C==[]
	->  reorder_heads(D, E, F, G, I, J),
	    propagation_code(E, H, I, J, B, D, K, L, M, N, O)
	;   simpagation_head2_code(E, H, F, G, A, K, L, M, N, O)
	).
gen_alloc_inc_clause(B/A, F, C, L, N) :-
	vars_susp(A, G, H, D),
	build_head(B, A, C, D, I),
	inc_id(C, E),
	build_head(B, A, E, D, K),
	gen_occ_allocation(B/A, F, G, H, J),
	M= (I:-J, K),
	L=[M|N].
gen_occ_allocation(A, B, E, D, F) :-
	get_allocation_occurrence(A, C),
	(   chr_pp_flag(debugable, off),
	    B==C
	->  allocate_constraint_goal(A, D, E, G),
	    (   may_trigger(A)
	    ->  F= (var(D)->G;true)
	    ;   F=G
	    )
	;   F=true
	).
gen_occ_allocation_in_guard(A, B, E, D, F) :-
	get_allocation_occurrence(A, C),
	(   chr_pp_flag(debugable, off),
	    B<C
	->  allocate_constraint_goal(A, D, E, G),
	    (   may_trigger(A)
	    ->  F= (var(D)->G;true)
	    ;   F=G
	    )
	;   F=true
	).
guard_via_reschedule_new(A, B, C, D, E, G) :-
	(   chr_pp_flag(guard_via_reschedule, on)
	->  guard_via_reschedule_main_new(A, B, C, D, E, F),
	    list2conj(F, G)
	;   length(A, H),
	    length(E, H),
	    length(B, I),
	    length(D, I),
	    append(E, D, J),
	    list2conj(J, G)
	).
guard_via_reschedule_main_new(B, C, A, M, I, J) :-
	initialize_unit_dictionary(A, F),
	maplist(wrap_in_functor(lookup), B, D),
	maplist(wrap_in_functor(guard), C, E),
	build_units(D, E, F, G),
	dependency_reorder(G, H),
	wrappedunits2lists(H, K, I, J),
	sort(K, L),
	snd_of_pairs(L, M).
wrap_in_functor(B, C, A) :-
	A=..[B, C].
wrappedunits2lists([], [], [], []).
wrappedunits2lists([unit(G, B, _, _)|J], E, C, A) :-
	A=[D|K],
	(   B=lookup(F)
	->  C=[D|I],
	    E=H
	;   B=guard(F)
	->  E=[G-D|H],
	    C=I
	),
	wrappedunits2lists(J, H, I, K).
guard_splitting(A, I) :-
	A=rule(B, C, D, _),
	append(B, C, E),
	conj2list(D, F),
	term_variables(E, G),
	split_off_simple_guard_new(F, G, H, J),
	append(H, [S], I),
	term_variables(J, M),
	ground_vars(E, K),
	list_difference_eq(G, K, L),
	intersect_eq(L, M, O),
	(   chr_pp_flag(guard_locks, on),
	    bagof('chr lock'(N)-'chr unlock'(N), lists:member(N, O), P)
	->  once(pairup(Q, R, P))
	;   Q=[],
	    R=[]
	),
	list2conj(Q, T),
	list2conj(R, V),
	list2conj(J, U),
	S= (T, U, V).
guard_body_copies3(A, B, C, D, G) :-
	A=rule(_, _, _, E),
	my_term_copy(B, C, F, D),
	my_term_copy(E, F, G).
split_off_simple_guard_new([], _, [], []).
split_off_simple_guard_new([A|D], B, C, F) :-
	(   simple_guard_new(A, B)
	->  C=[A|E],
	    split_off_simple_guard_new(D, B, E, F)
	;   C=[],
	    F=[A|D]
	).
simple_guard_new(A, D) :-
	builtin_binds_b(A, B),
	\+((
	    member(C, B),
	    memberchk_eq(C, D)
	    )).
dependency_reorder(A, B) :-
	dependency_reorder(A, [], B).
dependency_reorder([], A, B) :-
	reverse(A, B).
dependency_reorder([A|F], C, G) :-
	A=unit(_, _, B, D),
	(   B==fixed
	->  E=[A|C]
	;   dependency_insert(C, A, D, E)
	),
	dependency_reorder(F, E, G).
dependency_insert([], A, _, [A]).
dependency_insert([A|F], E, C, D) :-
	A=unit(B, _, _, _),
	(   memberchk(B, C)
	->  D=[E, A|F]
	;   D=[A|G],
	    dependency_insert(F, E, C, G)
	).
build_units(A, D, B, C) :-
	build_retrieval_units(A, 1, E, B, F, C, G),
	build_guard_units(D, E, F, G).
build_retrieval_units([], A, A, B, B, C, C).
build_retrieval_units([A|G], C, I, D, K, E, M) :-
	term_variables(A, B),
	update_unit_dictionary(B, C, D, J, [], F),
	E=[unit(C, A, fixed, F)|L],
	H is C+1,
	build_retrieval_units(G, H, I, J, K, L, M).
initialize_unit_dictionary(A, C) :-
	term_variables(A, B),
	pair_all_with(B, 0, C).
update_unit_dictionary([], _, A, A, B, B).
update_unit_dictionary([B|H], D, A, I, E, J) :-
	(   lookup_eq(A, B, C)
	->  (   (   C==D
		;   memberchk(C, E)
		)
	    ->  F=E
	    ;   F=[C|E]
	    ),
	    G=A
	;   G=[B-D|A],
	    F=E
	),
	update_unit_dictionary(H, D, G, I, F, J).
build_guard_units(A, C, F, B) :-
	(   A=[D]
	->  B=[unit(C, D, fixed, [])]
	;   A=[D|H]
	->  term_variables(D, E),
	    update_unit_dictionary2(E, C, F, J, [], G),
	    B=[unit(C, D, movable, G)|K],
	    I is C+1,
	    build_guard_units(H, I, J, K)
	).
update_unit_dictionary2([], _, A, A, B, B).
update_unit_dictionary2([B|H], D, A, I, E, J) :-
	(   lookup_eq(A, B, C)
	->  (   (   C==D
		;   memberchk(C, E)
		)
	    ->  F=E
	    ;   F=[C|E]
	    ),
	    G=[B-D|A]
	;   G=[B-D|A],
	    F=E
	),
	update_unit_dictionary2(H, D, G, I, F, J).
functional_dependency_analysis(A) :-
	(   fail,
	    chr_pp_flag(functional_dependency_analysis, on)
	->  functional_dependency_analysis_main(A)
	;   true
	).
functional_dependency_analysis_main([]).
functional_dependency_analysis_main([A|F]) :-
	(   discover_unique_pattern(A, B, C, D, E)
	->  functional_dependency(B, C, D, E)
	;   true
	),
	functional_dependency_analysis_main(F).
discover_unique_pattern(A, P/Q, B, N, O) :-
	A=pragma(C, _, _, _, B),
	C=rule(D, E, H, _),
	(   D=[F],
	    E=[G]
	->  true
	;   D=[F, G],
	    E==[]
	->  true
	),
	check_unique_constraints(F, G, H, B, J),
	term_variables(F, I),
	\+((
	    member(K, I),
	    lookup_eq(J, K, L),
	    memberchk_eq(L, I)
	    )),
	select_pragma_unique_variables(I, J, M),
	copy_term_nat(F-M, N-O),
	functor(F, P, Q).
select_pragma_unique_variables([], _, []).
select_pragma_unique_variables([B|E], A, C) :-
	(   lookup_eq(A, B, _)
	->  C=D
	;   C=[B|D]
	),
	select_pragma_unique_variables(E, A, D).
set_semantics_rules(A) :-
	(   fail,
	    chr_pp_flag(set_semantics_rule, on)
	->  set_semantics_rules_main(A)
	;   true
	).
set_semantics_rules_main([]).
set_semantics_rules_main([A|B]) :-
	set_semantics_rule_main(A),
	set_semantics_rules_main(B).
set_semantics_rule_main(A) :-
	A=pragma(B, C, _, _, D),
	(   B=rule([F], [K], true, _),
	    C=ids([E], [N]),
	    \+is_passive(D, E),
	    functor(F, G, H),
	    get_functional_dependency(G/H, D, I, J),
	    copy_term_nat(I-J, F-L),
	    copy_term_nat(I-J, K-M),
	    L==M
	->  passive(D, N)
	;   true
	).
check_unique_constraints(B, C, E, A, D) :-
	\+any_passive_head(A),
	variable_replacement(B-C, C-B, D),
	copy_with_variable_replacement(E, G, D),
	negate_b(E, F),
	once(entails_b(F, G)).
symmetry_analysis(A) :-
	(   chr_pp_flag(check_unnecessary_active, off)
	->  true
	;   symmetry_analysis_main(A)
	).
symmetry_analysis_main([]).
symmetry_analysis_main([A|H]) :-
	A=pragma(B, ids(E, G), _, _, F),
	B=rule(D, C, _, _),
	(   (   \+chr_pp_flag(check_unnecessary_active, simplification)
	    ;   C==[]
	    ),
	    D\==[]
	->  symmetry_analysis_heads_simplification(D, E, [], [], B, F),
	    symmetry_analysis_heads_propagation(C, G, [], [], B, F)
	;   true
	),
	symmetry_analysis_main(H).
symmetry_analysis_heads_simplification([], [], _, _, _, _).
symmetry_analysis_heads_simplification([G|K], [B|L], C, D, H, A) :-
	(   \+is_passive(A, B),
	    member2(C, D, F-E),
	    \+is_passive(A, E),
	    variable_replacement(F, G, I),
	    copy_with_variable_replacement(H, J, I),
	    identical_guarded_rules(H, J)
	->  passive(A, B)
	;   true
	),
	symmetry_analysis_heads_simplification(K, L, [G|C], [B|D], H, A).
symmetry_analysis_heads_propagation([], [], _, _, _, _).
symmetry_analysis_heads_propagation([G|K], [B|L], C, D, H, A) :-
	(   \+is_passive(A, B),
	    member2(C, D, F-E),
	    \+is_passive(A, E),
	    variable_replacement(F, G, I),
	    copy_with_variable_replacement(H, J, I),
	    identical_rules(H, J)
	->  passive(A, B)
	;   true
	),
	symmetry_analysis_heads_propagation(K, L, [G|C], [B|D], H, A).
simplification_code(B, C1, M, N, A, D/C, T, E, Q1, S1) :-
	A=pragma(I, _, _, _, J),
	head_info(B, C, _, U, F, G),
	build_head(D, C, E, F, K1),
	get_constraint_mode(D/C, H),
	head_arg_matches(G, H, [], L1, P, [], Q),
	guard_splitting(I, K),
	(   is_stored_in_guard(D/C, J)
	->  L=[_|K]
	;   L=K
	),
	guard_via_reschedule_new(M, L, B, S, O, M1),
	rest_heads_retrieval_and_matching(M, N, B, O, Z, P, R, [], [], [], Q, _),
	guard_body_copies3(I, L, R, S, P1),
	(   is_stored_in_guard(D/C, J)
	->  gen_occ_allocation_in_guard(D/C, T, V, U, X),
	    gen_uncond_attach_goal(D/C, U, V, Y, _),
	    S=[W|_],
	    W= (X, Y)
	;   true
	),
	partner_constraint_detachments(Z, M, R, N1),
	active_constraint_detachment(E, U, B, R, O1),
	(   chr_pp_flag(debugable, on)
	->  I=rule(_, _, A1, B1),
	    my_term_copy(A1-B1, R, E1-F1),
	    sort_by_key([U|Z], [C1|N], D1),
	    G1='chr debug_event'(try(D1, [], E1, F1)),
	    H1='chr debug_event'(apply(D1, [], E1, F1)),
	    instrument_goal(J1, G1, H1, I1)
	;   I1=J1
	),
	(   unconditional_occurrence(D/C, T),
	    chr_pp_flag(late_allocation, on)
	->  J1=true
	;   J1=!
	),
	R1= (K1:-L1, M1, I1, N1, O1, P1),
	Q1=[R1|S1].
head_arg_matches(A, B, C, D, E) :-
	head_arg_matches(A, B, C, D, E, [], _).
head_arg_matches(A, B, C, H, E, D, F) :-
	head_arg_matches_(A, B, C, D, G, E, F),
	list2conj(G, H).
head_arg_matches_([], [], A, B, [], A, B).
head_arg_matches_([A-F|K], [C|L], B, D, E, Z, A1) :-
	(   var(A)
	->  (   lookup_eq(B, A, G)
	    ->  (   C= (+)
		->  (   memberchk_eq(A, D)
		    ->  E=[F=G|H],
			I=D
		    ;   E=[F==G|H],
			I=[A|D]
		    )
		;   E=[F==G|H],
		    I=D
		),
		J=B
	    ;   J=[A-F|B],
		E=H,
		(   C= (+)
		->  I=[A|D]
		;   I=D
		)
	    ),
	    P=K,
	    Q=L
	;   ground(A),
	    A='$chr_identifier_match'(N, M)
	->  identifier_label_atom(M, F, N, O),
	    E=[O|H],
	    B=J,
	    I=D,
	    P=K,
	    Q=L
	;   atomic(A)
	->  (   C= (+)
	    ->  E=[F=A|H]
	    ;   E=[F==A|H]
	    ),
	    B=J,
	    I=D,
	    P=K,
	    Q=L
	;   C== (+),
	    is_ground(D, A)
	->  copy_with_variable_replacement(A, R, B),
	    E=[F=R|H],
	    B=J,
	    I=D,
	    P=K,
	    Q=L
	;   A=..[_|V],
	    functor(A, S, T),
	    functor(U, S, T),
	    U=..[_|W],
	    (   C= (+)
	    ->  E=[F=U|H]
	    ;   E=[nonvar(F), F=U|H]
	    ),
	    pairup(V, W, X),
	    append(X, K, P),
	    replicate(T, C, Y),
	    append(Y, L, Q),
	    J=B,
	    I=D
	),
	head_arg_matches_(P, Q, J, I, H, Z, A1).
add_heads_types([], A, A).
add_heads_types([A|C], B, E) :-
	add_head_types(A, B, D),
	add_heads_types(C, D, E).
add_head_types(A, F, G) :-
	functor(A, B, C),
	get_constraint_type_det(B/C, E),
	A=..[_|D],
	add_args_types(D, E, F, G).
add_args_types([], [], A, A).
add_args_types([A|D], [B|E], C, G) :-
	add_arg_types(A, B, C, F),
	add_args_types(D, E, F, G).
add_arg_types(A, D, B, C) :-
	(   var(A)
	->  (   lookup_eq(B, A, _)
	    ->  C=B
	    ;   C=[A-D|B]
	    )
	;   ground(A)
	->  C=B
	;   term_variables(A, E),
	    length(E, F),
	    replicate(F, any, G),
	    add_args_types(E, G, B, C)
	).
add_heads_ground_variables([], A, A).
add_heads_ground_variables([A|C], B, E) :-
	add_head_ground_variables(A, B, D),
	add_heads_ground_variables(C, D, E).
add_head_ground_variables(A, F, G) :-
	functor(A, B, C),
	get_constraint_mode(B/C, E),
	A=..[_|D],
	add_arg_ground_variables(D, E, F, G).
add_arg_ground_variables([], [], A, A).
add_arg_ground_variables([B|F], [A|G], D, H) :-
	(   A== (+)
	->  term_variables(B, C),
	    add_var_ground_variables(C, D, E)
	;   D=E
	),
	add_arg_ground_variables(F, G, E, H).
add_var_ground_variables([], A, A).
add_var_ground_variables([A|D], B, E) :-
	(   memberchk_eq(A, B)
	->  C=B
	;   C=[A|B]
	),
	add_var_ground_variables(D, C, E).
is_ground(B, A) :-
	(   ground(A)
	->  true
	;   compound(A)
	->  A=..[_|C],
	    maplist(is_ground(B), C)
	;   memberchk_eq(A, B)
	).
check_ground(C, A, D) :-
	term_variables(A, B),
	check_ground_variables(B, C, D).
check_ground_variables([], _, true).
check_ground_variables([A|C], B, D) :-
	(   memberchk_eq(A, B)
	->  check_ground_variables(C, B, D)
	;   D= (ground(A), E),
	    check_ground_variables(C, B, E)
	).
rest_heads_retrieval_and_matching(A, B, C, D, E, F, G, H, I, J) :-
	rest_heads_retrieval_and_matching(A, B, C, D, E, F, G, H, I, J, [], _).
rest_heads_retrieval_and_matching(A, B, E, F, G, H, I, C, D, J, K, L) :-
	(   A=[_|_]
	->  rest_heads_retrieval_and_matching_n(A, B, C, D, E, F, G, H, I, J, K, L)
	;   F=[],
	    G=[],
	    H=I,
	    K=L
	).
rest_heads_retrieval_and_matching_n([], _, _, _, _, [], [], A, A, _, B, B).
rest_heads_retrieval_and_matching_n([A|E1], [_|F1], F, X, E, [B1|G1], [M|H1], G, I1, _, L, J1) :-
	functor(A, C, B),
	head_info(A, B, I, _, _, J),
	get_store_type(C/B, D),
	(   D==default
	->  passive_head_via(A, [E|F], G, O, N),
	    delay_phase_end(validate_store_type_assumptions, (static_suspension_term(C/B, H), get_static_suspension_term_field(arguments, C/B, H, I), get_static_suspension_field(C/B, H, state, active, Q))),
	    get_constraint_mode(C/B, K),
	    head_arg_matches(J, K, G, U, V, L, W),
	    S=J,
	    sbag_member_call(M, N, P),
	    R= (O, P, M=H, Q)
	;   delay_phase_end(validate_store_type_assumptions, (static_suspension_term(C/B, H), get_static_suspension_term_field(arguments, C/B, H, I))),
	    existential_lookup(D, A, [E|F], G, L, H, R, M, J, S),
	    get_constraint_mode(C/B, K),
	    filter_mode(S, J, K, T),
	    head_arg_matches(S, T, G, U, V, L, W)
	),
	different_from_other_susps(A, M, F, X, C1),
	append(S, V, Y),
	translate(W, Y, Z),
	translate(W, V, A1),
	inline_matching_goal(U, D1, Z, A1),
	B1= (R, C1, D1),
	rest_heads_retrieval_and_matching_n(E1, F1, [A|F], [M|X], E, G1, H1, V, I1, _, W, J1).
inline_matching_goal(A==C, true, B, D) :-
	memberchk_eq(A, B),
	memberchk_eq(C, D),
	A=C, !.
inline_matching_goal((A, E), (B, F), C, D) :- !,
	inline_matching_goal(A, B, C, D),
	inline_matching_goal(E, F, C, D).
inline_matching_goal(A, A, _, _).
filter_mode([], _, _, []).
filter_mode([I-A|E], [_-B|F], [D|G], C) :-
	(   A==B
	->  C=[D|H],
	    filter_mode(E, F, G, H)
	;   filter_mode([I-A|E], F, G, C)
	).
check_unique_keys([], _).
check_unique_keys([B|C], A) :-
	lookup_eq(A, B, _),
	check_unique_keys(C, A).
different_from_other_susps(C, D, A, B, F) :-
	different_from_other_susps_(A, B, C, D, E),
	list2conj(E, F).
different_from_other_susps_(_, [], _, _, []) :- !.
different_from_other_susps_([B|K], [I|L], A, H, G) :-
	(   functor(A, C, D),
	    functor(B, C, D),
	    copy_term_nat(B-A, E-F),
	    \+ \+E=F
	->  G=[H\==I|J]
	;   G=J
	),
	different_from_other_susps_(K, L, A, H, J).
passive_head_via(A, D, N, G, F) :-
	functor(A, B, C),
	get_constraint_index(B/C, _),
	common_variables(A, D, I),
	global_list_store_name(B/C, E),
	H=nb_getval(E, F),
	get_constraint_mode(B/C, J),
	(   Q==[]
	->  G=H
	;   member(M, I),
	    nth(K, J, -),
	    arg(K, A, L),
	    L==M
	->  translate([M], N, [O]),
	    gen_get_mod_constraints(B/C, O, P, F),
	    G=P
	;   translate(I, N, Q),
	    add_heads_types(D, [], R),
	    my_term_copy(R, N, S),
	    gen_get_mod_constraints(B/C, Q, S, T, P, F),
	    G= (T->P;H)
	).
common_variables(A, B, E) :-
	term_variables(A, C),
	term_variables(B, D),
	intersect_eq(C, D, E).
gen_get_mod_constraints(N, A, B, E, H, L) :-
	get_target_module(I),
	(   A=[C]
	->  lookup_eq(B, C, D),
	    (   atomic_type(D)
	    ->  E=var(C),
		C=F
	    ;   E='chr newvia_1'(C, F)
	    )
	;   A=[C, G]
	->  E='chr newvia_2'(C, G, F)
	;   E='chr newvia'(A, F)
	),
	H= (get_attr(F, I, M), K),
	get_max_constraint_index(J),
	(   J==1
	->  K=true,
	    L=M
	;   K= (M=O),
	    get_constraint_index(N, P),
	    make_attr(J, _, Q, O),
	    nth1(P, Q, L)
	).
gen_get_mod_constraints(H, B, A, F) :-
	get_target_module(C),
	A= (get_attr(B, C, G), E),
	get_max_constraint_index(D),
	(   D==1
	->  E=true,
	    F=G
	;   E= (G=I),
	    get_constraint_index(H, J),
	    make_attr(D, _, K, I),
	    nth1(J, K, F)
	).
guard_body_copies(A, B, E, C) :-
	guard_body_copies2(A, B, D, C),
	list2conj(D, E).
guard_body_copies2(A, D, H, Y) :-
	A=rule(J, _, B, W),
	conj2list(B, C),
	split_off_simple_guard(C, D, E, F),
	my_term_copy(E-F, D, X, G-I),
	append(G, [S], H),
	term_variables(F, K),
	term_variables(I, O),
	ground_vars(J, L),
	list_difference_eq(K, L, _),
	(   chr_pp_flag(guard_locks, on),
	    bagof('chr lock'(M)-'chr unlock'(M), N^ (lists:member(N, K), pairlist:lookup_eq(D, N, M), memberchk_eq(M, O)), P)
	->  once(pairup(Q, R, P))
	;   Q=[],
	    R=[]
	),
	list2conj(Q, T),
	list2conj(R, V),
	list2conj(I, U),
	S= (T, U, V),
	my_term_copy(W, X, Y).
split_off_simple_guard([], _, [], []).
split_off_simple_guard([A|D], B, C, F) :-
	(   simple_guard(A, B)
	->  C=[A|E],
	    split_off_simple_guard(D, B, E, F)
	;   C=[],
	    F=[A|D]
	).
simple_guard(A, C) :-
	binds_b(A, B),
	\+((
	    member(D, B),
	    lookup_eq(C, D, _)
	    )).
active_constraint_detachment(E, I, A, J, H) :-
	functor(A, B, C),
	D=B/C,
	(   is_stored(D)
	->  (   (   E==[0]
		;   get_allocation_occurrence(D, G),
		    get_max_occurrence(D, F),
		    F<G
		),
		only_ground_indexed_arguments(D),
		chr_pp_flag(late_allocation, on)
	    ->  H=true
	    ;   gen_uncond_susp_detachment(A, I, active, J, K),
		(   chr_pp_flag(late_allocation, on)
		->  H= (var(I)->true;K)
		;   H=K
		)
	    )
	;   H=true
	).
partner_constraint_detachments([], [], _, true).
partner_constraint_detachments([B|E], [A|F], C, (D, G)) :-
	gen_uncond_susp_detachment(A, B, partner, C, D),
	partner_constraint_detachments(E, F, C, G).
gen_uncond_susp_detachment(A, G, H, J, E) :-
	functor(A, B, C),
	D=B/C,
	(   is_stored(D)
	->  E= (F, I),
	    (   chr_pp_flag(debugable, on)
	    ->  F='chr debug_event'(remove(G))
	    ;   F=true
	    ),
	    remove_constraint_goal(D, G, L, true, (K, M), H, I),
	    delete_constraint_goal(A, G, J, K),
	    (   \+only_ground_indexed_arguments(D),
		\+get_store_type(D, var_assoc_store(_, _))
	    ->  detach_constraint_atom(D, L, G, M)
	    ;   M=true
	    )
	;   E=true
	).
simpagation_head1_code(C, L1, J, L, A, E/D, A1, H, B2, D2) :-
	A=pragma(B, ids(_, M), _, _, N),
	B=rule(_, K, J1, K1),
	head_info(C, D, _, B1, I, F),
	get_constraint_mode(E/D, G),
	head_arg_matches(F, G, [], W1, V, [], W),
	build_head(E, D, H, I, V1),
	append(J, K, O),
	append(L, M, P),
	reorder_heads(N, C, O, P, S, T),
	guard_splitting(B, Q),
	(   is_stored_in_guard(E/D, N)
	->  R=[_|Q]
	;   R=Q
	),
	guard_via_reschedule_new(S, R, C, Z, U, X1),
	rest_heads_retrieval_and_matching(S, T, C, U, X, V, Y, [], [], [], W, _),
	split_by_ids(T, X, L, G1, H1, M1, N1),
	guard_body_copies3(B, R, Y, Z, A2),
	(   is_stored_in_guard(E/D, N)
	->  gen_occ_allocation_in_guard(E/D, A1, C1, B1, E1),
	    gen_uncond_attach_goal(E/D, B1, C1, F1, _),
	    Z=[D1|_],
	    D1= (E1, F1)
	;   true
	),
	sort_by_key(G1, H1, I1),
	partner_constraint_detachments(I1, J, Y, Y1),
	active_constraint_detachment(H, B1, C, Y, Z1),
	(   chr_pp_flag(debugable, on)
	->  my_term_copy(J1-K1, Y, Q1-R1),
	    sort_by_key([B1|G1], [L1|H1], O1),
	    sort_by_key(M1, N1, P1),
	    S1='chr debug_event'(try(O1, P1, Q1, R1)),
	    T1='chr debug_event'(apply(O1, P1, Q1, R1)),
	    instrument_goal(!, S1, T1, U1)
	;   U1=!
	),
	C2= (V1:-W1, X1, U1, Y1, Z1, A2),
	B2=[C2|D2].
split_by_ids([], [], _, [], []).
split_by_ids([A|H], [D|I], B, C, E) :-
	(   memberchk_eq(A, B)
	->  C=[D|F],
	    E=G
	;   C=F,
	    E=[D|G]
	),
	split_by_ids(H, I, B, F, G).
split_by_ids([], [], _, [], [], [], []).
split_by_ids([A|L], [D|M], B, C, E, F, G) :-
	(   memberchk_eq(A, B)
	->  C=[D|H],
	    E=[A|I],
	    F=J,
	    G=K
	;   C=H,
	    E=I,
	    F=[D|J],
	    G=[A|K]
	),
	split_by_ids(L, M, B, H, I, J, K).
simpagation_head2_code(H, C1, D, F, A, O, P, Q, R, E1) :-
	A=pragma(B, ids(E, T), _, _, G),
	B=rule(C, _, M, N),
	append(C, D, I),
	append(E, F, J),
	reorder_heads(G, H, I, J, [K|L], [S|U]),
	simpagation_head2_prelude(H, K, [L, M, N], O, P, Q, R, W),
	extend_id(Q, V),
	(   memberchk_eq(S, T)
	->  simpagation_universal_searches(L, U, T, [K, H], B, O, Z, A1, B1, V, Y, W, X)
	;   W=X,
	    V=Y,
	    Z=L,
	    A1=[K, H],
	    B1=U
	),
	universal_search_iterator_end(A1, Z, B, O, Y, X, D1),
	simpagation_head2_worker(A1, Z, B1, C1, A, O, P, Y, D1, E1).
simpagation_universal_searches([], [], _, A, _, _, [], A, [], B, B, C, C).
simpagation_universal_searches(A, [H|K], I, C, D, E, M, N, O, B, Q, F, S) :-
	A=[L|J],
	inc_id(B, P),
	universal_search_iterator_end(C, A, D, E, B, F, G),
	universal_search_iterator(A, C, D, E, B, G, R),
	(   memberchk_eq(H, I)
	->  simpagation_universal_searches(J, K, I, [L|C], D, E, M, N, O, P, Q, R, S)
	;   Q=P,
	    R=S,
	    M=J,
	    N=[L|C],
	    K=O
	).
simpagation_head2_prelude(A, H, N, C/B, K, D, X, Z) :-
	head_info(A, B, L, M, E, F),
	build_head(C, B, D, E, S),
	get_constraint_mode(C/B, G),
	head_arg_matches(F, G, [], T, I, [], J),
	lookup_passive_head(H, [A], I, J, U, O),
	gen_occ_allocation(C/B, K, L, M, V),
	extend_id(D, Q),
	extra_active_delegate_variables(A, [H|N], I, P),
	append([O|E], P, R),
	build_head(C, B, Q, R, W),
	Y= (S:-T, U, !, V, W),
	X=[Y|Z].
extra_active_delegate_variables(A, B, C, E) :-
	A=..[_|D],
	delegate_variables(A, B, C, D, E).
passive_delegate_variables(B, A, C, D, F) :-
	term_variables(A, E),
	delegate_variables(B, C, D, E, F).
delegate_variables(A, B, H, F, I) :-
	term_variables(A, C),
	term_variables(B, D),
	intersect_eq(C, D, E),
	list_difference_eq(E, F, G),
	translate(G, H, I).
simpagation_head2_worker([D|C], E, C1, _, A, V/W, N1, X, L2, M2) :-
	A=pragma(B, ids(G1, _), D2, _, Z),
	B=rule(_, _, F, G),
	get_prop_inner_loop_vars(C, [D, E, F, G], U, N, O1, P1, P),
	gen_var(J),
	gen_var(T),
	functor(D, K, H),
	gen_vars(H, I),
	head_info(D, H, I, J, _, L),
	get_constraint_mode(K/H, M),
	head_arg_matches(L, M, N, S, E1, [], _),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(K/H, O), get_static_suspension_field(K/H, O, state, active, Q), get_static_suspension_term_field(arguments, K/H, O, I))),
	different_from_other_susps(D, J, C, P, R),
	G2= (J=O, Q, R, S),
	Y=[[J|T]|U],
	build_head(V, W, X, Y, F2),
	guard_splitting(B, A1),
	(   is_stored_in_guard(V/W, Z)
	->  B1=[_|A1]
	;   B1=A1
	),
	guard_via_reschedule_new(E, B1, [D|C], M1, D1, H2),
	rest_heads_retrieval_and_matching(E, C1, [D|C], D1, F1, E1, J1, [D|C], [J|P], []),
	split_by_ids(C1, F1, G1, H1, W1),
	split_by_ids(C1, E, G1, I1, _),
	partner_constraint_detachments([J|H1], [D|I1], J1, I2),
	K1=[T|U],
	build_head(V, W, X, K1, Q1),
	L1=[[]|U],
	build_head(V, W, X, L1, S1),
	guard_body_copies3(B, B1, J1, M1, J2),
	(   is_stored_in_guard(V/W, Z)
	->  M1=[B2|_]
	;   true
	),
	(   is_observed(V/W, N1)
	->  gen_uncond_attach_goal(V/W, O1, P1, T1, R1),
	    gen_state_cond_call(O1, V/W, Q1, R1, U1),
	    gen_state_cond_call(O1, V/W, S1, R1, V1)
	;   T1=true,
	    U1=Q1,
	    V1=S1
	),
	(   chr_pp_flag(debugable, on)
	->  my_term_copy(F-G, N, X1-Y1),
	    Z1='chr debug_event'(try([J|H1], [O1|W1], X1, Y1)),
	    A2='chr debug_event'(apply([J|H1], [O1|W1], X1, Y1))
	;   Z1=true,
	    A2=true
	),
	(   is_stored_in_guard(V/W, Z)
	->  B2=T1,
	    C2=true
	;   B2=true,
	    C2=T1
	),
	(   member(unique(_, E2), D2),
	    check_unique_keys(E2, N)
	->  K2= (F2:-G2-> (H2, Z1->A2, I2, C2, J2, V1;S1);Q1)
	;   K2= (F2:-G2, H2, Z1->A2, I2, C2, J2, U1;Q1)
	),
	L2=[K2|M2].
gen_state_cond_call(B, A, J, D, I) :-
	(   may_trigger(A)
	->  does_use_field(A, generation),
	    delay_phase_end(validate_store_type_assumptions, (static_suspension_term(A, C), get_update_static_suspension_field(A, B, C, state, active, inactive, E, F), get_static_suspension_field(A, C, generation, D, H), get_static_suspension_term_field(arguments, A, C, G)))
	;   delay_phase_end(validate_store_type_assumptions, (static_suspension_term(A, C), get_update_static_suspension_field(A, B, C, state, active, inactive, E, F), get_static_suspension_term_field(arguments, A, C, G))),
	    H=true
	),
	I= (B=C, E, H->F, J;true).
propagation_code(B, C, A, K, D, E, F, G, H, I, J) :-
	(   A==[]
	->  propagation_single_headed(B, C, D, E, F, G, H, I, J)
	;   propagation_multi_headed(B, A, K, D, E, F, G, H, I, J)
	).
propagation_single_headed(A, _, I, V, C/B, L, D, P1, R1) :-
	head_info(A, B, W, P, E, G),
	build_head(C, B, D, E, L1),
	inc_id(D, F),
	build_head(C, B, F, E, K),
	get_constraint_mode(C/B, H),
	head_arg_matches(G, H, [], M1, J, [], _),
	guard_body_copies(I, J, N1, O1),
	Z=K,
	(   unconditional_occurrence(C/B, L),
	    chr_pp_flag(late_allocation, on)
	->  M=true
	;   M=!
	),
	I=rule(_, _, N, O),
	(   chr_pp_flag(debugable, on)
	->  my_term_copy(N-O, J, Q-R),
	    S='chr debug_event'(try([], [P], Q, R)),
	    T='chr debug_event'(apply([], [P], Q, R)),
	    instrument_goal(M, S, T, U)
	;   U=M
	),
	(   may_trigger(C/B),
	    \+has_no_history(V)
	->  use_auxiliary_predicate(novel_production),
	    use_auxiliary_predicate(extend_history),
	    does_use_history(C/B, L),
	    gen_occ_allocation(C/B, L, W, P, D1),
	    (   named_history(V, X, _)
	    ->  Y=X
	    ;   Y=V
	    ),
	    E1='$novel_production'(P, Y),
	    F1='$extend_history'(P, Y),
	    (   is_observed(C/B, L)
	    ->  gen_uncond_attach_goal(C/B, P, W, B1, A1),
		gen_state_cond_call(P, C/B, Z, A1, C1)
	    ;   B1=true,
		C1=Z
	    )
	;   D1=true,
	    E1=true,
	    F1=true,
	    (   is_observed(C/B, L)
	    ->  get_allocation_occurrence(C/B, G1),
		(   L==G1
		->  gen_insert_constraint_internal_goal(C/B, B1, E, W, P),
		    A1=0
		;   B1= (H1, I1),
		    gen_occ_allocation(C/B, L, W, P, H1),
		    gen_uncond_attach_goal(C/B, P, W, I1, A1)
		),
		gen_state_cond_call(P, C/B, Z, A1, C1)
	    ;   gen_occ_allocation(C/B, L, W, P, B1),
		C1=Z
	    )
	),
	(   is_stored_in_guard(C/B, V)
	->  J1=B1,
	    K1=true
	;   J1=true,
	    K1=B1
	),
	Q1= (L1:-M1, D1, E1, J1, N1, U, F1, K1, O1, C1),
	P1=[Q1|R1].
propagation_multi_headed(B, A, J, C, K, D, E, F, G, N) :-
	A=[I|H],
	propagation_prelude(B, A, C, D, E, F, G, M),
	extend_id(F, L),
	propagation_nested_code(H, [I, B], J, C, K, D, E, L, M, N).
propagation_prelude(A, [I|J], H, C/B, O, D, B1, D1) :-
	head_info(A, B, P, Q, E, F),
	build_head(C, B, D, E, W),
	get_constraint_mode(C/B, G),
	head_arg_matches(F, G, [], X, M, [], N),
	H=rule(_, _, K, L),
	extra_active_delegate_variables(A, [I, J, K, L], M, S),
	lookup_passive_head(I, [A], M, N, Y, R),
	gen_occ_allocation(C/B, O, P, Q, Z),
	extend_id(D, T),
	append([R|E], S, U),
	build_head(C, B, T, U, V),
	A1=V,
	C1= (W:-X, Y, !, Z, A1),
	B1=[C1|D1].
propagation_nested_code([], [A|B], G, C, H, D, I, E, F, K) :-
	universal_search_iterator_end([A|B], [], C, D, E, F, J),
	propagation_body(A, B, G, C, H, D, I, E, J, K).
propagation_nested_code([B|C], A, I, D, J, E, K, F, G, N) :-
	universal_search_iterator_end(A, [B|C], D, E, F, G, H),
	universal_search_iterator([B|C], A, D, E, F, H, M),
	inc_id(F, L),
	propagation_nested_code(C, [B|A], I, D, J, E, K, L, M, N).
check_fd_lookup_condition(A, B, _, _) :-
	get_store_type(A/B, global_singleton), !.
check_fd_lookup_condition(A, B, E, F) :-
	\+may_trigger(A/B),
	get_functional_dependency(A/B, 1, C, D),
	copy_term(C-D, E-G),
	term_variables(F, H),
	intersect_eq(G, H, G), !.
propagation_body(C, B, N1, A, M1, P/Q, F1, R, T2, V2) :-
	A=rule(_, Y1, D, E),
	gen_var_susp_list_for_b(B, [C, D, E], C1, F, T, G, U),
	flatten(F, O),
	init(G, D1),
	last(G, G1),
	gen_var(L),
	gen_var(N),
	functor(C, I, H),
	gen_vars(H, K),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(I/H, J), get_static_suspension_field(I/H, J, state, active, M), get_static_suspension_term_field(arguments, I/H, J, K))),
	O2= (L=J, M),
	S=[[L|N]|O],
	build_head(P, Q, R, S, N2),
	(   check_fd_lookup_condition(I, H, C, B)
	->  universal_search_iterator_failure_vars(B, R, F, T, U, V, X),
	    W=V
	;   W=[N|O],
	    X=R
	),
	build_head(P, Q, X, W, Y),
	I1=Y,
	C=..[_|Z],
	pairup(Z, K, A1),
	get_constraint_mode(I/H, B1),
	head_arg_matches(A1, B1, C1, Q2, E1),
	different_from_other_susps(C, L, B, D1, P2),
	guard_body_copies(A, E1, R2, S2),
	get_occurrence(P/Q, F1, _, R1),
	(   is_observed(P/Q, F1)
	->  init(T, H1),
	    gen_uncond_attach_goal(P/Q, G1, H1, K1, J1),
	    gen_state_cond_call(G1, P/Q, I1, J1, L1)
	;   K1=true,
	    L1=I1
	),
	(   (   is_least_occurrence(M1)
	    ;   has_no_history(M1)
	    )
	->  P1=true,
	    Q1=true
	;   \+may_trigger(P/Q),
	    forall(member(O1, N1), chr_translate:is_passive(M1, O1))
	->  P1=true,
	    Q1=true
	;   get_occurrence(P/Q, F1, _, R1),
	    use_auxiliary_predicate(novel_production),
	    use_auxiliary_predicate(extend_history),
	    does_use_history(P/Q, F1),
	    (   named_history(M1, W1, S1)
	    ->  reverse([L|D1], T1),
		named_history_susps(S1, [R1|N1], [G1|T1], U1),
		U1=[V1|_],
		(   length(S1, 1)
		->  Q1='$extend_history'(V1, W1),
		    P1='$novel_production'(V1, W1)
		;   findall(X1, (member(O1, S1), get_occurrence_from_id(X1, _, M1, O1)), C2),
		    D2=..[t, W1|U1]
		)
	    ;   V1=G1,
		findall(A2/B2, (member(Z1, Y1), functor(Z1, A2, B2)), C2),
		sort([R1|N1], S1),
		history_susps(N1, [L|D1], G1, R1, U1),
		D2=..[t, M1|U1]
	    ),
	    (   var(P1)
	    ->  novel_production_calls(C2, S1, U1, M1, E2, F2),
		Q1='$extend_history'(V1, E2),
		P1= (E2=D2, F2)
	    ;   true
	    )
	),
	(   chr_pp_flag(debugable, on)
	->  A=rule(_, _, D, E),
	    my_term_copy(D-E, E1, H2-I2),
	    get_occurrence(P/Q, F1, _, R1),
	    sort_by_key([G1, L|D1], [R1|N1], G2),
	    J2='chr debug_event'(try([], G2, H2, I2)),
	    K2='chr debug_event'(apply([], G2, H2, I2))
	;   J2=true,
	    K2=true
	),
	(   is_stored_in_guard(P/Q, M1)
	->  L2=K1,
	    M2=true
	;   L2=true,
	    M2=K1
	),
	U2= (N2:-O2, P2, Q2, P1, L2, R2, J2->K2, Q1, M2, S2, L1;I1),
	T2=[U2|V2].
novel_production_calls([], [], [], _, _, true).
novel_production_calls([A|H], [C|I], [E|J], B, F, (G, K)) :-
	get_occurrence_from_id(A, D, B, C),
	delay_phase_end(validate_store_type_assumptions, novel_production_call(A, D, '$novel_production'(E, F), G)),
	novel_production_calls(H, I, J, B, F, K).
history_susps(E, A, B, D, F) :-
	reverse(A, C),
	sort_by_key([B|C], [D|E], F).
named_history_susps([], _, _, []).
named_history_susps([A|E], C, D, [B|H]) :-
	select2(A, B, C, D, F, G), !,
	named_history_susps(E, F, G, H).
gen_var_susp_list_for([A], I, H, K, D, C) :- !,
	functor(A, E, B),
	head_info(A, B, _, C, D, F),
	get_constraint_mode(E/B, G),
	head_arg_matches(F, G, [], _, H),
	extra_active_delegate_variables(A, I, H, J),
	append(D, J, K).
gen_var_susp_list_for([B|A], C, K, N, D, E) :-
	gen_var_susp_list_for(A, [B|C], J, D, _, _),
	functor(B, G, F),
	gen_var(E),
	head_info(B, F, _, M, _, H),
	get_constraint_mode(G/F, I),
	head_arg_matches(H, I, J, _, K),
	passive_delegate_variables(B, A, C, K, L),
	append(L, [M, E|D], N).
gen_var_susp_list_for_b([A], I, H, [K], D, [C], []) :- !,
	functor(A, E, B),
	head_info(A, B, _, C, D, F),
	get_constraint_mode(E/B, G),
	head_arg_matches(F, G, [], _, H),
	extra_active_delegate_variables(A, I, H, J),
	append(D, J, K).
gen_var_susp_list_for_b([B|A], C, O, [Q|D], E, [J|F], [H|G]) :-
	gen_var_susp_list_for_b(A, [B|C], N, D, E, F, G),
	functor(B, K, I),
	gen_var(H),
	head_info(B, I, _, J, _, L),
	get_constraint_mode(K/I, M),
	head_arg_matches(L, M, N, _, O),
	passive_delegate_variables(B, A, C, O, P),
	append(P, [J, H], Q).
get_prop_inner_loop_vars([A], I, L, H, D, C, []) :- !,
	functor(A, E, B),
	head_info(A, B, C, D, J, F),
	get_constraint_mode(E/B, G),
	head_arg_matches(F, G, [], _, H),
	extra_active_delegate_variables(A, I, H, K),
	append(J, K, L).
get_prop_inner_loop_vars([B|A], C, Q, M, D, E, [H|F]) :-
	get_prop_inner_loop_vars(A, [B|C], P, L, D, E, F),
	functor(B, I, G),
	gen_var(O),
	head_info(B, G, _, H, _, J),
	get_constraint_mode(I/G, K),
	head_arg_matches(J, K, L, _, M),
	passive_delegate_variables(B, A, C, M, N),
	append(N, [H, O|P], Q).
reorder_heads(C, D, A, E, F, G) :-
	(   chr_pp_flag(reorder_heads, on),
	    length(A, B),
	    B=<6
	->  reorder_heads_main(C, D, A, E, F, G)
	;   F=A,
	    G=E
	).
reorder_heads_main(E, A, C, D, N, P) :-
	term_variables(A, B),
	F=entry([], [], B, C, D, E),
	copy_term_nat(F, G),
	a_star(G, H^ (chr_translate:final_data(H)), I^J^K^ (chr_translate:expand_data(I, J, K)), L),
	G=F,
	L=entry(M, O, _, _, _, _),
	reverse(M, N),
	reverse(O, P).
final_data(A) :-
	A=entry(_, _, _, _, [], _).
expand_data(A, F, N) :-
	A=entry(G, I, E, B, C, M),
	select2(D, H, B, C, K, L),
	term_variables([D|E], J),
	F=entry([D|G], [H|I], J, K, L, M),
	order_score(D, H, E, K, M, N).
order_score(A, E, F, G, H, I) :-
	functor(A, B, C),
	get_store_type(B/C, D),
	order_score(D, A, E, F, G, H, I).
order_score(default, A, _, D, B, _, F) :-
	term_variables(A, C),
	term_variables(B, E),
	order_score_vars(C, D, E, F).
order_score(multi_inthash(A), B, _, C, _, _, D) :-
	order_score_indexes(A, B, C, 0, D).
order_score(multi_hash(A), B, _, C, _, _, D) :-
	order_score_indexes(A, B, C, 0, D).
order_score(global_ground, A, _, D, B, _, F) :-
	term_variables(A, C),
	term_variables(B, E),
	order_score_vars(C, D, E, G),
	F is G*2.
order_score(var_assoc_store(_, _), _, _, _, _, _, 1).
order_score(global_singleton, _, _, _, _, _, A) :-
	A=1.
order_score(multi_store(D), A, F, B, C, G, J) :-
	find_with_var_identity(H, t(A, B, C), (lists:member(E, D), chr_translate:order_score(E, A, F, B, C, G, H)), I),
	min_list(I, J).
order_score(identifier_store(_), _, _, _, _, _, A) :-
	A=10.
order_score(type_indexed_identifier_store(_, _), _, _, _, _, _, A) :-
	A=10.
order_score_indexes([], _, _, A, B) :-
	A>0,
	B=100.
order_score_indexes([A|H], B, E, F, I) :-
	multi_hash_key_args(A, B, C),
	(   forall(D, C, memberchk_eq(D, E))
	->  G is F+1
	;   G=F
	),
	order_score_indexes(H, B, E, G, I).
order_score_vars(A, B, C, G) :-
	order_score_count_vars(A, B, C, D-E-F),
	(   D-E-F==0-0-0
	->  G=0
	;   D>0
	->  G is max(10-D, 0)
	;   E>0
	->  G is max(10-E, 1)*10
	;   G is max(10-F, 1)*100
	).
order_score_count_vars([], _, _, 0-0-0).
order_score_count_vars([D|A], B, C, E-G-I) :-
	order_score_count_vars(A, B, C, F-H-J),
	(   memberchk_eq(D, B)
	->  E is F+1,
	    G=H,
	    I=J
	;   memberchk_eq(D, C)
	->  G is H+1,
	    E=F,
	    I=J
	;   I is J+1,
	    E=F,
	    G=H
	).
create_get_mutable_ref(C, B, A) :-
	A= (B=mutable(C)).
create_get_mutable(B, A, C) :-
	A=mutable(B),
	C=true.
gen_var(_).
gen_vars(B, A) :-
	length(A, B).
head_info(E, A, B, C, D, G) :-
	vars_susp(A, B, C, D),
	E=..[_|F],
	pairup(F, B, G).
inc_id([C|A], [B|A]) :-
	B is C+1.
dec_id([C|A], [B|A]) :-
	B is C-1.
extend_id(A, [0|A]).
next_id([_, C|A], [B|A]) :-
	B is C+1.
build_head(A, B, C, H, F) :-
	buildName(A, B, C, G),
	(   (   chr_pp_flag(debugable, on)
	    ;   is_stored(A/B),
		has_active_occurrence(A/B),
		(   may_trigger(A/B)
		;   get_allocation_occurrence(A/B, E),
		    get_max_occurrence(A/B, D),
		    D>=E
		)
	    )
	->  F=..[G|H]
	;   init(H, I),
	    F=..[G|I]
	).
buildName(A, B, E, H) :-
	(   (   chr_pp_flag(debugable, on)
	    ;   once((
		    (   is_stored(A/B),
			(   has_active_occurrence(A/B)
			;   chr_pp_flag(late_allocation, off)
			),
			(   may_trigger(A/B)
			;   get_allocation_occurrence(A/B, D),
			    get_max_occurrence(A/B, C),
			    C>=D
			)
		    ;   E\=[0]
		    )
		    ))
	    )
	->  atom_concat(A, /, F),
	    atomic_concat(F, B, G),
	    buildName_(E, G, H)
	;   H=A
	).
buildName_([], A, A).
buildName_([E|A], B, F) :-
	buildName_(A, B, C),
	atom_concat(C, '__', D),
	atomic_concat(D, E, F).
vars_susp(B, A, C, D) :-
	length(A, B),
	append(A, [C], D).
make_attr(B, D, A, C) :-
	length(A, B),
	C=..[v, D|A].
or_pattern(A, B) :-
	C is A-1,
	B is 1<<C.
and_pattern(A, C) :-
	B is A-1,
	D is 1<<B,
	C is-1* (D+1).
make_name(A, B/C, D) :-
	atom_concat_list([A, B, /, C], D).
lookup_passive_head(A, E, F, G, H) :-
	functor(A, B, C),
	get_store_type(B/C, D),
	lookup_passive_head(D, A, E, F, [], G, H).
lookup_passive_head(A, E, F, G, H, I) :-
	functor(A, B, C),
	get_store_type(B/C, D),
	lookup_passive_head(D, A, E, F, G, H, I).
lookup_passive_head(default, A, B, C, _, D, E) :-
	functor(A, _, _),
	passive_head_via(A, B, C, D, E).
lookup_passive_head(multi_inthash(A), B, _, C, D, E, F) :-
	hash_lookup_passive_head(inthash, A, B, C, D, E, F, _).
lookup_passive_head(multi_hash(A), B, _, C, D, E, F) :-
	hash_lookup_passive_head(hash, A, B, C, D, E, F, _).
lookup_passive_head(global_ground, A, _, _, _, F, E) :-
	functor(A, B, C),
	global_ground_store_name(B/C, D),
	make_get_store_goal(D, E, F),
	update_store_type(B/C, global_ground).
lookup_passive_head(var_assoc_store(A, C), B, _, F, _, G, L) :-
	arg(A, B, D),
	arg(C, B, E),
	translate([D, E], F, [H, K]),
	get_target_module(I),
	G= (get_attr(H, I, J), lookup_assoc_store(J, K, L)).
lookup_passive_head(global_singleton, A, _, _, _, E, H) :-
	functor(A, B, C),
	global_singleton_store_name(B/C, D),
	make_get_store_goal(D, G, F),
	E= (F, G\==[], H=[G]),
	update_store_type(B/C, global_singleton).
lookup_passive_head(multi_store(A), C, D, E, F, G, H) :-
	once((
	    member(B, A),
	    lookup_passive_head(B, C, D, E, F, G, H)
	    )).
lookup_passive_head(identifier_store(B), A, _, D, _, I, G) :-
	functor(A, E, F),
	arg(B, A, C),
	translate([C], D, [H]),
	delay_phase_end(validate_store_type_assumptions, identifier_lookup(E/F, B, G, H, I)),
	update_store_type(E/F, identifier_store(B)),
	get_identifier_index(E/F, B, _).
lookup_passive_head(type_indexed_identifier_store(B, F), A, _, D, _, E, M) :-
	functor(A, K, L),
	arg(B, A, C),
	(   var(C)
	->  translate([C], D, [H]),
	    E=J
	;   ground(C),
	    C='$chr_identifier_match'(G, _)
	->  lookup_identifier_atom(F, G, H, I),
	    E= (I, J)
	),
	delay_phase_end(validate_store_type_assumptions, type_indexed_identifier_lookup(K/L, B, F, M, H, J)),
	update_store_type(K/L, type_indexed_identifier_store(B, F)),
	get_type_indexed_identifier_index(F, K/L, B, _).
identifier_lookup(B, C, F, H, G) :-
	get_identifier_size(A),
	functor(E, struct, A),
	get_identifier_index(B, C, D),
	arg(D, E, F),
	G= (H=E).
type_indexed_identifier_lookup(B, C, A, F, H, G) :-
	type_indexed_identifier_structure(A, E),
	get_type_indexed_identifier_index(A, B, C, D),
	arg(D, E, F),
	G= (H=E).
hash_lookup_passive_head(P, B, C, E, K, M, J, A) :-
	once((
	    member(A, B),
	    multi_hash_key_args(A, C, D),
	    (   translate(D, E, F)
	    ;   ground(D),
		F=D
	    )
	    )),
	(   F=[G]
	->  true
	;   G=..[k|F]
	),
	functor(C, H, I),
	multi_hash_via_lookup_goal(H/I, A, G, J, O),
	check_ground(K, D, L),
	my_term_copy(L, E, N),
	M= (N, O),
	(   P==inthash
	->  update_store_type(H/I, multi_inthash([A]))
	;   update_store_type(H/I, multi_hash([A]))
	).
existential_lookup(var_assoc_store(B, C), D, E, F, G, L, M, H, A, A) :- !,
	lookup_passive_head(var_assoc_store(B, C), D, E, F, G, N, I),
	sbag_member_call(H, I, O),
	functor(D, J, K),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(J/K, L), get_static_suspension_field(J/K, L, state, active, P))),
	M= (N, O, H=L, P).
existential_lookup(global_singleton, B, _, _, _, I, G, F, A, A) :- !,
	functor(B, C, D),
	global_singleton_store_name(C/D, E),
	make_get_store_goal(E, F, H),
	G= (H, F\==[], F=I),
	update_store_type(C/D, global_singleton).
existential_lookup(multi_store(A), C, D, E, F, G, H, I, J, K) :- !,
	once((
	    member(B, A),
	    existential_lookup(B, C, D, E, F, G, H, I, J, K)
	    )).
existential_lookup(multi_inthash(A), B, _, C, D, E, F, G, H, I) :- !,
	existential_hash_lookup(inthash, A, B, C, D, E, F, G, H, I).
existential_lookup(multi_hash(A), B, _, C, D, E, F, G, H, I) :- !,
	existential_hash_lookup(hash, A, B, C, D, E, F, G, H, I).
existential_lookup(identifier_store(A), B, C, D, E, M, N, K, F, G) :- !,
	lookup_passive_head(identifier_store(A), B, C, D, E, O, J),
	hash_index_filter(F, A, G),
	functor(B, H, I),
	(   check_fd_lookup_condition(H, I, B, _)
	->  L= (J=[K])
	;   sbag_member_call(K, J, L)
	),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(H/I, M), get_static_suspension_field(H/I, M, state, active, P))),
	N= (O, L, K=M, P).
existential_lookup(type_indexed_identifier_store(A, B), C, D, E, F, N, O, L, G, H) :- !,
	lookup_passive_head(type_indexed_identifier_store(A, B), C, D, E, F, P, K),
	hash_index_filter(G, A, H),
	functor(C, I, J),
	(   check_fd_lookup_condition(I, J, C, _)
	->  M= (K=[L])
	;   sbag_member_call(L, K, M)
	),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(I/J, N), get_static_suspension_field(I/J, N, state, active, Q))),
	O= (P, M, L=N, Q).
existential_lookup(B, C, D, E, F, K, L, G, A, A) :-
	lookup_passive_head(B, C, D, E, F, M, H),
	sbag_member_call(G, H, N),
	functor(C, I, J),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(I/J, K), get_static_suspension_field(I/J, K, state, active, O))),
	L= (M, N, G=K, O).
existential_hash_lookup(A, B, C, D, E, N, O, L, F, H) :-
	hash_lookup_passive_head(A, B, C, D, E, P, K, G),
	hash_index_filter(F, G, H),
	functor(C, I, J),
	(   check_fd_lookup_condition(I, J, C, _)
	->  M= (K=[L])
	;   sbag_member_call(L, K, M)
	),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(I/J, N), get_static_suspension_field(I/J, N, state, active, Q))),
	O= (P, M, L=N, Q).
hash_index_filter(C, A, D) :-
	(   integer(A)
	->  B=[A]
	;   B=A
	),
	hash_index_filter(C, B, 1, D).
hash_index_filter([], _, _, []).
hash_index_filter([E|F], A, B, D) :-
	(   A=[C|G]
	->  H is B+1,
	    (   C>B
	    ->  D=[E|I],
		hash_index_filter(F, [C|G], H, I)
	    ;   C==B
	    ->  hash_index_filter(F, G, H, D)
	    )
	;   D=[E|F]
	).
assume_constraint_stores([]).
assume_constraint_stores([A|T]) :-
	(   chr_pp_flag(debugable, off),
	    only_ground_indexed_arguments(A),
	    is_stored(A),
	    get_store_type(A, default)
	->  get_indexed_arguments(A, B),
	    length(B, C),
	    (   C>10
	    ->  findall([D], member(D, B), F)
	    ;   findall(D, (sublist(D, B), D\==[]), E),
		predsort(longer_list, E, F)
	    ),
	    (   get_functional_dependency(A, 1, G, H),
		all_distinct_var_args(G),
		H==[]
	    ->  assumed_store_type(A, global_singleton)
	    ;   get_constraint_type_det(A, I),
		partition_indexes(F, I, M, J, O, R),
		(   J=[]
		->  K=L
		;   K=[multi_inthash(J)|L]
		),
		(   M=[]
		->  L=N
		;   L=[multi_hash(M)|N]
		),
		(   O=[]
		->  N=Q
		;   maplist(wrap_in_functor(identifier_store), O, P),
		    append(P, Q, N)
		),
		append(R, S, Q),
		S=[global_ground],
		assumed_store_type(A, multi_store(K))
	    )
	;   true
	),
	assume_constraint_stores(T).
partition_indexes([], _, [], [], [], []).
partition_indexes([A|O], C, H, G, F, I) :-
	(   A=[B],
	    nth(B, C, D),
	    unalias_type(D, E),
	    E==chr_identifier
	->  F=[B|L],
	    G=M,
	    H=N,
	    I=K
	;   A=[B],
	    nth(B, C, D),
	    unalias_type(D, E),
	    nonvar(E),
	    E=chr_identifier(J)
	->  I=[type_indexed_identifier_store(B, J)|K],
	    F=L,
	    G=M,
	    H=N
	;   A=[B],
	    nth(B, C, D),
	    unalias_type(D, E),
	    E==dense_int
	->  G=[A|M],
	    H=N,
	    F=L,
	    I=K
	;   member(B, A),
	    nth(B, C, D),
	    unalias_type(D, E),
	    nonvar(E),
	    E=chr_identifier(_)
	->  G=M,
	    H=N,
	    F=L,
	    I=K
	;   G=M,
	    H=[A|N],
	    F=L,
	    I=K
	),
	partition_indexes(O, C, N, M, L, K).
longer_list(F, A, B) :-
	length(A, D),
	length(B, C),
	compare(E, C, D),
	(   E== (=)
	->  compare(F, A, B)
	;   F=E
	).
all_distinct_var_args(A) :-
	A=..[_|B],
	copy_term_nat(B, C),
	all_distinct_var_args_(C).
all_distinct_var_args_([]).
all_distinct_var_args_([A|B]) :-
	var(A),
	A=t,
	all_distinct_var_args_(B).
get_indexed_arguments(A, C) :-
	A=_/B,
	get_indexed_arguments(1, B, A, C).
get_indexed_arguments(A, B, D, C) :-
	(   A>B
	->  C=[]
	;   (   is_indexed_argument(D, A)
	    ->  C=[A|E]
	    ;   C=E
	    ),
	    F is A+1,
	    get_indexed_arguments(F, B, D, E)
	).
validate_store_type_assumptions([]).
validate_store_type_assumptions([A|B]) :-
	validate_store_type_assumption(A),
	validate_store_type_assumptions(B).
universal_search_iterator_end([C|B], D, A, L/M, G, S, U) :-
	A=rule(_, _, E, F),
	gen_var_susp_list_for_b(B, [C, D, E, F], _, H, I, _, J),
	universal_search_iterator_failure_vars(B, G, H, I, J, P, O),
	flatten(H, K),
	N=[[]|K],
	build_head(L, M, G, N, Q),
	build_head(L, M, O, P, R),
	T= (Q:-R),
	S=[T|U].
universal_search_iterator_failure_vars(F, A, E, D, K, C, B) :-
	(   A=[0|_]
	->  next_id(A, B),
	    C=D
	;   E=[_|M],
	    dec_id(A, L),
	    (   F=[G|J],
		functor(G, H, I),
		check_fd_lookup_condition(H, I, G, J)
	    ->  K=[_|N],
		universal_search_iterator_failure_vars(J, L, M, D, N, C, B)
	    ;   B=L,
		flatten(M, P),
		K=[O|_],
		C=[O|P]
	    )
	).
universal_search_iterator([D|E], [C|B], A, A1/B1, X, R1, T1) :-
	A=rule(_, _, F, G),
	gen_var_susp_list_for_b(B, [C, D, E, F, G], O, I, H1, H, I1),
	init(H, R),
	flatten(I, Z),
	gen_var(Y),
	functor(C, L, J),
	gen_vars(J, K),
	head_info(C, J, K, Q, _, M),
	get_constraint_mode(L/J, N),
	head_arg_matches(M, N, O, U, V),
	delay_phase_end(validate_store_type_assumptions, (static_suspension_term(L/J, P), get_static_suspension_field(L/J, P, state, active, S), get_static_suspension_term_field(arguments, L/J, P, K))),
	different_from_other_susps(C, Q, B, R, T),
	N1= (Q=P, S, T, U),
	add_heads_ground_variables([C|B], [], W),
	lookup_passive_head(D, [C|B], V, W, O1, D1),
	inc_id(X, F1),
	C1=[[Q|Y]|Z],
	build_head(A1, B1, X, C1, M1),
	passive_delegate_variables(C, B, [D, E, F, G], V, E1),
	append([D1|E1], [Q, Y|Z], G1),
	build_head(A1, B1, F1, G1, P1),
	(   check_fd_lookup_condition(L, J, C, B)
	->  universal_search_iterator_failure_vars(B, X, I, H1, I1, J1, L1),
	    K1=J1
	;   K1=[Y|Z],
	    L1=X
	),
	build_head(A1, B1, L1, K1, Q1),
	S1= (M1:-N1, O1->P1;Q1),
	R1=[S1|T1].
ai_observation_analysis(A) :-
	(   chr_pp_flag(ai_observation_analysis, on),
	    get_target_module(_),
	    '$chr_compiled_with_version'(3)
	->  list_to_ord_set(A, B),
	    abstract_constraints(B),
	    ai_observation_schedule_initial_calls(B, B),
	    ai_observation_gather_results
	;   true
	).
ai_observation_schedule_initial_calls([], _).
ai_observation_schedule_initial_calls([A|C], B) :-
	ai_observation_schedule_initial_call(A, B),
	ai_observation_schedule_initial_calls(C, B).
ai_observation_schedule_initial_call(A, _) :-
	ai_observation_top(A, B),
	initial_call_pattern(B).
ai_observation_schedule_new_calls([], _).
ai_observation_schedule_new_calls([B|D], A) :-
	A=odom(_, C),
	initial_call_pattern(odom(B, C)),
	ai_observation_schedule_new_calls(D, A).
ai_observation_lub(odom(A, B), odom(A, C), odom(A, D)) :-
	ord_intersection(B, C, D).
ai_observation_bot(A, B, odom(A, B)).
ai_observation_top(A, odom(A, B)) :-
	ord_empty(B).
ai_observation_leq(odom(A, C), odom(A, B)) :-
	ord_subset(B, C).
ai_observation_observe_set(A, B, C) :-
	ord_subtract(A, B, C).
ai_observation_abstract_constraint(A, E, B) :-
	functor(A, C, D),
	B=C/D,
	memberchk(B, E).
ai_observation_abstract_constraints(A, C, E) :-
	findall(D, (member(B, A), ai_observation_abstract_constraint(B, C, D)), E).
ai_observation_abstract_goal_(A, B, C, G, H, I) :-
	term_variables((A, B, C), E),
	append(A, B, D),
	ground_vars(D, F),
	list_difference_eq(E, F, J),
	ai_observation_abstract_goal(G, H, I, [], J), !.
ground_vars([], []).
ground_vars([A|F], I) :-
	functor(A, B, C),
	get_constraint_mode(B/C, E),
	head_info(A, C, _, _, _, D),
	head_arg_matches(D, E, [], _, _, [], G),
	ground_vars(F, H),
	append(G, H, I).
ai_observation_abstract_goal((A, E), B, C, G, D) :- !,
	ai_observation_abstract_goal(A, B, C, F, D),
	ai_observation_abstract_goal(E, B, F, G, D).
ai_observation_abstract_goal((A;E), B, C, G, D) :- !,
	ai_observation_abstract_goal(A, B, C, F, D),
	ai_observation_abstract_goal(E, B, F, G, D).
ai_observation_abstract_goal((A->E), B, C, G, D) :- !,
	ai_observation_abstract_goal(A, B, C, F, D),
	ai_observation_abstract_goal(E, B, F, G, D).
ai_observation_abstract_goal(B, C, [D|A], A, _) :-
	ai_observation_abstract_constraint(B, C, D), !.
ai_observation_abstract_goal(true, _, A, A, _) :- !.
ai_observation_abstract_goal(writeln(_), _, A, A, _) :- !.
ai_observation_abstract_goal(B, _, A, A, D) :-
	builtin_binds_b(B, C),
	intersect_eq(C, D, []), !.
ai_observation_abstract_goal(_, _, [B|A], A, _) :-
	B=builtin.
ai_observation_is_observed(odom(_, B), A) :-
	\+ord_memberchk(A, B).
unconditional_occurrence(A, B) :-
	get_occurrence(A, B, C, _),
	get_rule(C, D),
	D=pragma(E, _, _, _, _),
	copy_term_nat(E, F),
	F=rule(G, H, I, _),
	guard_entailment:entails_guard([chr_pp_headvariables(G, H)], I),
	once((
	    (   G=[J],
		H==[]
	    ;   H=[J],
		G==[],
		\+may_trigger(A)
	    )
	    )),
	functor(J, _, _),
	J=..[_|K],
	unconditional_occurrence_args(K).
unconditional_occurrence_args([]).
unconditional_occurrence_args([A|B]) :-
	var(A),
	A=x,
	unconditional_occurrence_args(B).
partial_wake_args([], _, _, _).
partial_wake_args([B|E], [A|F], D, C) :-
	(   A\== (+)
	->  (   nonvar(B)
	    ->  no_partial_wake(C)
	    ;   memberchk_eq(B, D)
	    ->  no_partial_wake(C)
	    ;   true
	    )
	;   true
	),
	partial_wake_args(E, F, D, C).
generate_show_constraint(B, A, D, C) :-
	(   chr_pp_flag(show, on)
	->  A=['$show'/0|B],
	    generate_show_rules(B, C, [E|D]),
	    inc_rule_count(F),
	    E=pragma(rule(['$show'], [], true, true), ids([0], []), [], no, F)
	;   A=B,
	    C=D
	).
generate_show_rules([], A, A).
generate_show_rules([A/B|F], [C|G], H) :-
	functor(D, A, B),
	inc_rule_count(E),
	C=pragma(rule([], ['$show', D], true, writeln(D)), ids([], [0, 1]), [passive(1)], no, E),
	generate_show_rules(F, G, H).
static_suspension_term(A/B, D) :-
	suspension_term_base(A/B, C),
	E is C+B,
	functor(D, suspension, E).
has_suspension_field(A, B) :-
	suspension_term_base_fields(A, C),
	memberchk(B, C).
suspension_term_base(A, C) :-
	suspension_term_base_fields(A, B),
	length(B, C).
suspension_term_base_fields(B, A) :-
	(   chr_pp_flag(debugable, on)
	->  A=[id, state, history, generation, continuation, functor]
	;   (   uses_history(B)
	    ->  A=[id, state, history|C]
	    ;   only_ground_indexed_arguments(B),
		get_functional_dependency(B, 1, _, _)
	    ->  A=[state|C]
	    ;   A=[id, state|C]
	    ),
	    (   only_ground_indexed_arguments(B)
	    ->  get_store_type(B, D),
		basic_store_types(D, E),
		(   memberchk(global_ground, E)
		->  C=[global_list_prev]
		;   C=[]
		)
	    ;   may_trigger(B)
	    ->  (   uses_field(B, generation)
		->  C=[generation, global_list_prev]
		;   C=[global_list_prev]
		)
	    ;   C=[global_list_prev]
	    )
	).
get_static_suspension_term_field(C, A, E, F) :-
	suspension_term_base_fields(A, B),
	nth(D, B, C), !,
	arg(D, E, F).
get_static_suspension_term_field(arguments, A, B, E) :- !,
	suspension_term_base(A, C),
	B=..[_|D],
	drop(C, D, E).
get_static_suspension_term_field(A, B, _, _) :-
	chr_error(internal, 'Trying to obtain field ~w of ~w, wich does not have it!', [A, B]).
get_dynamic_suspension_term_field(C, A, F, G, D) :-
	suspension_term_base_fields(A, B),
	nth(E, B, C), !,
	D=arg(E, F, G).
get_dynamic_suspension_term_field(arguments, A, E, C, D) :- !,
	static_suspension_term(A, B),
	get_static_suspension_term_field(arguments, A, B, C),
	D= (E=B).
get_dynamic_suspension_term_field(argument(B), A, F, G, D) :- !,
	suspension_term_base(A, C),
	E is B+C,
	D=arg(E, F, G).
get_dynamic_suspension_term_field(A, B, _, _, _) :-
	chr_error(internal, 'Dynamic goal to get ~w of ~w, which does not have this field!', [A, B]).
set_dynamic_suspension_term_field(C, A, F, G, D) :-
	suspension_term_base_fields(A, B),
	nth(E, B, C), !,
	D=setarg(E, F, G).
set_dynamic_suspension_term_field(A, B, _, _, _) :-
	chr_error(internal, 'Dynamic goal to set ~w of ~w, which does not have this field!', [A, B]).
basic_store_types(multi_store(A), A) :- !.
basic_store_types(A, [A]).
:- use_module(chr(chr_runtime)).
:- use_module(chr(chr_hashtable_store)).
'attach_type_definition/2'([], _).
'attach_type_definition/2'([A|L], D) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, E, F, G, H, I, J),
	    (   C/\1=:=1
	    ->  put_attr(A, chr_translate, v(C, [D|E], F, G, H, I, J))
	    ;   K is C\/1,
		put_attr(A, chr_translate, v(K, [D], F, G, H, I, J))
	    )
	;   put_attr(A, chr_translate, v(1, [D], [], [], [], [], []))
	),
	'attach_type_definition/2'(L, D).
'detach_type_definition/2'([], _).
'detach_type_definition/2'([A|M], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, D, H, I, J, K, L),
	    (   C/\1=:=1
	    ->  'chr sbag_del_element'(D, E, F),
		(   F==[]
		->  G is C/\ -2,
		    (   G==0
		    ->  del_attr(A, chr_translate)
		    ;   put_attr(A, chr_translate, v(G, [], H, I, J, K, L))
		    )
		;   put_attr(A, chr_translate, v(C, F, H, I, J, K, L))
		)
	    ;   true
	    )
	;   true
	),
	'detach_type_definition/2'(M, E).
'attach_type_alias/2'([], _).
'attach_type_alias/2'([A|L], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, D, F, G, H, I, J),
	    (   C/\2=:=2
	    ->  put_attr(A, chr_translate, v(C, D, [E|F], G, H, I, J))
	    ;   K is C\/2,
		put_attr(A, chr_translate, v(K, D, [E], G, H, I, J))
	    )
	;   put_attr(A, chr_translate, v(2, [], [E], [], [], [], []))
	),
	'attach_type_alias/2'(L, E).
'detach_type_alias/2'([], _).
'detach_type_alias/2'([A|M], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, H, D, I, J, K, L),
	    (   C/\2=:=2
	    ->  'chr sbag_del_element'(D, E, F),
		(   F==[]
		->  G is C/\ -3,
		    (   G==0
		    ->  del_attr(A, chr_translate)
		    ;   put_attr(A, chr_translate, v(G, H, [], I, J, K, L))
		    )
		;   put_attr(A, chr_translate, v(C, H, F, I, J, K, L))
		)
	    ;   true
	    )
	;   true
	),
	'detach_type_alias/2'(M, E).
'attach_unalias_type/2'([], _).
'attach_unalias_type/2'([A|L], F) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, D, E, G, H, I, J),
	    (   C/\4=:=4
	    ->  put_attr(A, chr_translate, v(C, D, E, [F|G], H, I, J))
	    ;   K is C\/4,
		put_attr(A, chr_translate, v(K, D, E, [F], H, I, J))
	    )
	;   put_attr(A, chr_translate, v(4, [], [], [F], [], [], []))
	),
	'attach_unalias_type/2'(L, F).
'detach_unalias_type/2'([], _).
'detach_unalias_type/2'([A|M], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, H, I, D, J, K, L),
	    (   C/\4=:=4
	    ->  'chr sbag_del_element'(D, E, F),
		(   F==[]
		->  G is C/\ -5,
		    (   G==0
		    ->  del_attr(A, chr_translate)
		    ;   put_attr(A, chr_translate, v(G, H, I, [], J, K, L))
		    )
		;   put_attr(A, chr_translate, v(C, H, I, F, J, K, L))
		)
	    ;   true
	    )
	;   true
	),
	'detach_unalias_type/2'(M, E).
'attach_static_type_check_var/3'([], _).
'attach_static_type_check_var/3'([A|L], G) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, D, E, F, H, I, J),
	    (   C/\8=:=8
	    ->  put_attr(A, chr_translate, v(C, D, E, F, [G|H], I, J))
	    ;   K is C\/8,
		put_attr(A, chr_translate, v(K, D, E, F, [G], I, J))
	    )
	;   put_attr(A, chr_translate, v(8, [], [], [], [G], [], []))
	),
	'attach_static_type_check_var/3'(L, G).
'detach_static_type_check_var/3'([], _).
'detach_static_type_check_var/3'([A|M], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, H, I, J, D, K, L),
	    (   C/\8=:=8
	    ->  'chr sbag_del_element'(D, E, F),
		(   F==[]
		->  G is C/\ -9,
		    (   G==0
		    ->  del_attr(A, chr_translate)
		    ;   put_attr(A, chr_translate, v(G, H, I, J, [], K, L))
		    )
		;   put_attr(A, chr_translate, v(C, H, I, J, F, K, L))
		)
	    ;   true
	    )
	;   true
	),
	'detach_static_type_check_var/3'(M, E).
'attach_static_atomic_builtin_type_check_var/3'([], _).
'attach_static_atomic_builtin_type_check_var/3'([A|L], H) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, D, E, F, G, I, J),
	    (   C/\16=:=16
	    ->  put_attr(A, chr_translate, v(C, D, E, F, G, [H|I], J))
	    ;   K is C\/16,
		put_attr(A, chr_translate, v(K, D, E, F, G, [H], J))
	    )
	;   put_attr(A, chr_translate, v(16, [], [], [], [], [H], []))
	),
	'attach_static_atomic_builtin_type_check_var/3'(L, H).
'detach_static_atomic_builtin_type_check_var/3'([], _).
'detach_static_atomic_builtin_type_check_var/3'([A|M], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, H, I, J, K, D, L),
	    (   C/\16=:=16
	    ->  'chr sbag_del_element'(D, E, F),
		(   F==[]
		->  G is C/\ -17,
		    (   G==0
		    ->  del_attr(A, chr_translate)
		    ;   put_attr(A, chr_translate, v(G, H, I, J, K, [], L))
		    )
		;   put_attr(A, chr_translate, v(C, H, I, J, K, F, L))
		)
	    ;   true
	    )
	;   true
	),
	'detach_static_atomic_builtin_type_check_var/3'(M, E).
'attach_atomic_type/1'([], _).
'attach_atomic_type/1'([A|L], I) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, D, E, F, G, H, J),
	    (   C/\32=:=32
	    ->  put_attr(A, chr_translate, v(C, D, E, F, G, H, [I|J]))
	    ;   K is C\/32,
		put_attr(A, chr_translate, v(K, D, E, F, G, H, [I]))
	    )
	;   put_attr(A, chr_translate, v(32, [], [], [], [], [], [I]))
	),
	'attach_atomic_type/1'(L, I).
'detach_atomic_type/1'([], _).
'detach_atomic_type/1'([A|M], E) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(C, H, I, J, K, L, D),
	    (   C/\32=:=32
	    ->  'chr sbag_del_element'(D, E, F),
		(   F==[]
		->  G is C/\ -33,
		    (   G==0
		    ->  del_attr(A, chr_translate)
		    ;   put_attr(A, chr_translate, v(G, H, I, J, K, L, []))
		    )
		;   put_attr(A, chr_translate, v(C, H, I, J, K, L, F))
		)
	    ;   true
	    )
	;   true
	),
	'detach_atomic_type/1'(M, E).
attach_increment([], _).
attach_increment([A|D1], v(U, D, G, J, M, P, S)) :-
	(   get_attr(A, chr_translate, B)
	->  B=v(V, C, F, I, L, O, R),
	    sort(C, E),
	    'chr merge_attributes'(D, E, X),
	    sort(F, H),
	    'chr merge_attributes'(G, H, Y),
	    sort(I, K),
	    'chr merge_attributes'(J, K, Z),
	    sort(L, N),
	    'chr merge_attributes'(M, N, A1),
	    sort(O, Q),
	    'chr merge_attributes'(P, Q, B1),
	    sort(R, T),
	    'chr merge_attributes'(S, T, C1),
	    W is U\/V,
	    put_attr(A, chr_translate, v(W, X, Y, Z, A1, B1, C1))
	;   put_attr(A, chr_translate, v(U, D, G, J, M, P, S))
	),
	attach_increment(D1, v(U, D, G, J, M, P, S)).
attr_unify_hook(v(A1, A, B, C, D, E, F), G) :-
	sort(A, J),
	sort(B, M),
	sort(C, P),
	sort(D, S),
	sort(E, V),
	sort(F, Y),
	(   var(G)
	->  (   get_attr(G, chr_translate, H)
	    ->  H=v(B1, I, L, O, R, U, X),
		sort(I, K),
		'chr merge_attributes'(J, K, D1),
		sort(L, N),
		'chr merge_attributes'(M, N, E1),
		sort(O, Q),
		'chr merge_attributes'(P, Q, F1),
		sort(R, T),
		'chr merge_attributes'(S, T, G1),
		sort(U, W),
		'chr merge_attributes'(V, W, H1),
		sort(X, Z),
		'chr merge_attributes'(Y, Z, I1),
		C1 is A1\/B1,
		put_attr(G, chr_translate, v(C1, D1, E1, F1, G1, H1, I1)),
		'$run_suspensions_type_definition/2'(D1),
		'$run_suspensions_type_alias/2'(E1),
		'$run_suspensions_unalias_type/2'(F1),
		'$run_suspensions_static_type_check_var/3'(G1),
		'$run_suspensions_static_atomic_builtin_type_check_var/3'(H1),
		'$run_suspensions_atomic_type/1'(I1)
	    ;   put_attr(G, chr_translate, v(A1, J, M, P, S, V, Y)),
		'$run_suspensions_type_definition/2'(J),
		'$run_suspensions_type_alias/2'(M),
		'$run_suspensions_unalias_type/2'(P),
		'$run_suspensions_static_type_check_var/3'(S),
		'$run_suspensions_static_atomic_builtin_type_check_var/3'(V),
		'$run_suspensions_atomic_type/1'(Y)
	    )
	;   (   compound(G)
	    ->  term_variables(G, J1),
		attach_increment(J1, v(A1, J, M, P, S, V, Y))
	    ;   true
	    ),
	    '$run_suspensions_type_definition/2'(J),
	    '$run_suspensions_type_alias/2'(M),
	    '$run_suspensions_unalias_type/2'(P),
	    '$run_suspensions_static_type_check_var/3'(S),
	    '$run_suspensions_static_atomic_builtin_type_check_var/3'(V),
	    '$run_suspensions_atomic_type/1'(Y)
	).
'$novel_production'(A, B) :-
	arg(3, A, C),
	(   hprolog:get_ds(B, C, _)
	->  fail
	;   true
	).
'$extend_history'(A, B) :-
	arg(3, A, C),
	hprolog:put_ds(B, C, x, D),
	setarg(3, A, D).
'$run_suspensions_type_definition/2'([]).
'$run_suspensions_type_definition/2'([A|G]) :-
	A=suspension(_, B, _, C, _, E, F),
	(   B==active
	->  setarg(2, A, triggered),
	    D is C+1,
	    setarg(4, A, D),
	    'type_definition/2__0'(E, F, A),
	    (   B==triggered
	    ->  setarg(2, A, active)
	    ;   true
	    )
	;   true
	),
	'$run_suspensions_type_definition/2'(G).
'$run_suspensions_type_alias/2'([]).
'$run_suspensions_type_alias/2'([A|G]) :-
	A=suspension(_, B, _, C, _, E, F),
	(   B==active
	->  setarg(2, A, triggered),
	    D is C+1,
	    setarg(4, A, D),
	    'type_alias/2__0'(E, F, A),
	    (   B==triggered
	    ->  setarg(2, A, active)
	    ;   true
	    )
	;   true
	),
	'$run_suspensions_type_alias/2'(G).
'$run_suspensions_unalias_type/2'([]).
'$run_suspensions_unalias_type/2'([A|E]) :-
	A=suspension(_, B, _, C, D),
	(   B==active
	->  setarg(2, A, triggered),
	    'unalias_type/2__0'(C, D, A),
	    (   B==triggered
	    ->  setarg(2, A, active)
	    ;   true
	    )
	;   true
	),
	'$run_suspensions_unalias_type/2'(E).
'$run_suspensions_static_type_check_var/3'([]).
'$run_suspensions_static_type_check_var/3'([A|F]) :-
	A=suspension(_, B, _, C, D, E),
	(   B==active
	->  setarg(2, A, triggered),
	    'static_type_check_var/3__0'(C, D, E, A),
	    (   B==triggered
	    ->  setarg(2, A, active)
	    ;   true
	    )
	;   true
	),
	'$run_suspensions_static_type_check_var/3'(F).
'$run_suspensions_static_atomic_builtin_type_check_var/3'([]).
'$run_suspensions_static_atomic_builtin_type_check_var/3'([A|F]) :-
	A=suspension(_, B, _, C, D, E),
	(   B==active
	->  setarg(2, A, triggered),
	    'static_atomic_builtin_type_check_var/3__0'(C, D, E, A),
	    (   B==triggered
	    ->  setarg(2, A, active)
	    ;   true
	    )
	;   true
	),
	'$run_suspensions_static_atomic_builtin_type_check_var/3'(F).
'$run_suspensions_atomic_type/1'([]).
'$run_suspensions_atomic_type/1'([A|D]) :-
	A=suspension(_, B, _, C),
	(   B==active
	->  setarg(2, A, triggered),
	    'atomic_type/1__0'(C, A),
	    (   B==triggered
	    ->  setarg(2, A, active)
	    ;   true
	    )
	;   true
	),
	'$run_suspensions_atomic_type/1'(D).
'$enumerate_constraints'(C) :-
	(   nb_getval('$chr_store_global_ground_chr_translate:target_module/1', A),
	    'chr sbag_member'(B, A),
	    B=suspension(_, _, _, D),
	    C=target_module(D)
	;   nb_getval('$chr_store_multi_hash_chr_translate:indexed_argument/2-1', E),
	    value_ht(E, F),
	    F=suspension(_, _, G, H),
	    C=indexed_argument(G, H)
	;   nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', I),
	    'chr sbag_member'(J, I),
	    J=suspension(_, _, _, _, K, L),
	    C=constraint_mode(K, L)
	;   nb_getval('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0', M),
	    'chr sbag_member'(N, M),
	    N=suspension(_, _, _),
	    C=none_suspended_on_variables
	;   nb_getval('$chr_store_multi_hash_chr_translate:store_type/2-1', O),
	    value_ht(O, P),
	    P=suspension(_, _, Q, R),
	    C=store_type(Q, R)
	;   nb_getval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', S),
	    value_ht(S, T),
	    T=suspension(_, _, U, V),
	    C=actual_store_types(U, V)
	;   nb_getval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', W),
	    value_ht(W, X),
	    X=suspension(_, _, Y, Z),
	    C=assumed_store_type(Y, Z)
	;   nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', A1),
	    'chr sbag_member'(B1, A1),
	    B1=suspension(_, _, _, C1),
	    C=rule_count(C1)
	;   nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', D1),
	    value_ht(D1, E1),
	    E1=suspension(_, _, _, F1, G1),
	    C=passive(F1, G1)
	;   nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', H1),
	    'chr sbag_member'(I1, H1),
	    I1=suspension(_, _, _, _, J1, K1, L1, M1, N1),
	    C=occurrence(J1, K1, L1, M1, N1)
	;   nb_getval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', O1),
	    value_ht(O1, P1),
	    P1=suspension(_, _, _, Q1, R1),
	    C=max_occurrence(Q1, R1)
	;   nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', S1),
	    value_ht(S1, T1),
	    T1=suspension(_, _, U1, V1),
	    C=allocation_occurrence(U1, V1)
	;   nb_getval('$chr_store_global_ground_chr_translate:rule/2', W1),
	    'chr sbag_member'(X1, W1),
	    X1=suspension(_, _, _, _, Y1, Z1),
	    C=rule(Y1, Z1)
	;   nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', A2),
	    value_ht(A2, B2),
	    B2=suspension(_, _, C2, D2),
	    C=least_occurrence(C2, D2)
	;   nb_getval('$chr_store_multi_hash_chr_translate:constraint_index/2-2', E2),
	    value_ht(E2, F2),
	    F2=suspension(_, _, G2, H2),
	    C=constraint_index(G2, H2)
	;   nb_getval('$chr_store_global_ground_chr_translate:max_constraint_index/1', I2),
	    'chr sbag_member'(J2, I2),
	    J2=suspension(_, _, _, K2),
	    C=max_constraint_index(K2)
	;   nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', L2),
	    'chr sbag_member'(M2, L2),
	    M2=suspension(_, _, _, N2),
	    C=identifier_size(N2)
	;   nb_getval('$chr_store_multi_hash_chr_translate:identifier_index/3-12', O2),
	    value_ht(O2, P2),
	    P2=suspension(_, _, Q2, R2, S2),
	    C=identifier_index(Q2, R2, S2)
	;   nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1', T2),
	    value_ht(T2, U2),
	    U2=suspension(_, _, V2, W2),
	    C=type_indexed_identifier_size(V2, W2)
	;   nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-123', X2),
	    value_ht(X2, Y2),
	    Y2=suspension(_, _, Z2, A3, B3, C3),
	    C=type_indexed_identifier_index(Z2, A3, B3, C3)
	;   nb_getval('$chr_store_multi_hash_chr_translate:no_history/1-1', D3),
	    value_ht(D3, E3),
	    E3=suspension(_, _, F3),
	    C=no_history(F3)
	;   nb_getval('$chr_store_multi_hash_chr_translate:history/3-1', G3),
	    value_ht(G3, H3),
	    H3=suspension(_, _, I3, J3, K3),
	    C=history(I3, J3, K3)
	;   nb_getval('$chr_store_multi_hash_chr_translate:indexing_spec/2-1', L3),
	    value_ht(L3, M3),
	    M3=suspension(_, _, N3, O3),
	    C=indexing_spec(N3, O3)
	;   nb_getval('$chr_store_global_ground_chr_translate:observation_analysis/1', P3),
	    'chr sbag_member'(Q3, P3),
	    Q3=suspension(_, _, _, R3),
	    C=observation_analysis(R3)
	;   nb_getval('$chr_store_global_ground_chr_translate:spawns/3', S3),
	    'chr sbag_member'(T3, S3),
	    T3=suspension(_, _, _, _, U3, V3, W3),
	    C=spawns(U3, V3, W3)
	;   nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', X3),
	    value_ht(X3, Y3),
	    Y3=suspension(_, _, Z3, A4),
	    C=spawns_all(Z3, A4)
	;   nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', B4),
	    'chr sbag_member'(C4, B4),
	    C4=suspension(_, _, _, _, D4, E4),
	    C=spawns_all_triggers(D4, E4)
	;   nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', F4),
	    'chr sbag_member'(G4, F4),
	    G4=suspension(_, _, _),
	    C=spawns_all_triggers_implies_spawns_all
	;   nb_getval('$chr_store_global_ground_chr_translate:module_initializer/1', H4),
	    'chr sbag_member'(I4, H4),
	    I4=suspension(_, _, _, J4),
	    C=module_initializer(J4)
	;   nb_getval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', K4),
	    'chr sbag_member'(L4, K4),
	    L4=suspension(_, _, _, M4),
	    C=prolog_global_variable(M4)
	;   nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', N4),
	    value_ht(N4, O4),
	    O4=suspension(_, _, _, P4, Q4, R4, S4, T4, U4, V4),
	    C=prev_guard_list(P4, Q4, R4, S4, T4, U4, V4)
	;   nb_getval('$chr_store_multi_hash_chr_translate:set_all_passive/1-1', W4),
	    value_ht(W4, X4),
	    X4=suspension(_, _, _, Y4),
	    C=set_all_passive(Y4)
	;   nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', Z4),
	    'chr sbag_member'(A5, Z4),
	    A5=suspension(_, _, _, B5),
	    C=multiple_occ_constraints_checked(B5)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C5),
	    'chr sbag_member'(D5, C5),
	    D5=suspension(_, _, _, _, _, E5, F5),
	    C=type_definition(E5, F5)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', G5),
	    'chr sbag_member'(H5, G5),
	    H5=suspension(_, _, _, _, _, I5, J5),
	    C=type_alias(I5, J5)
	;   nb_getval('$chr_store_multi_hash_chr_translate:constraint_type/2-1', K5),
	    value_ht(K5, L5),
	    L5=suspension(_, _, M5, N5),
	    C=constraint_type(M5, N5)
	;   nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', O5),
	    'chr sbag_member'(P5, O5),
	    P5=suspension(_, _, _, Q5, R5),
	    C=unalias_type(Q5, R5)
	;   nb_getval('$chr_store_global_ground_chr_translate:types_modes_condition/3', S5),
	    'chr sbag_member'(T5, S5),
	    T5=suspension(_, _, _, U5, V5, W5),
	    C=types_modes_condition(U5, V5, W5)
	;   nb_getval('$chr_store_global_ground_chr_translate:static_type_check/0', X5),
	    'chr sbag_member'(Y5, X5),
	    Y5=suspension(_, _, _, _),
	    C=static_type_check
	;   nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', Z5),
	    'chr sbag_member'(A6, Z5),
	    A6=suspension(_, _, _, B6, C6, D6),
	    C=static_type_check_var(B6, C6, D6)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E6),
	    'chr sbag_member'(F6, E6),
	    F6=suspension(_, _, _, G6, H6, I6),
	    C=static_atomic_builtin_type_check_var(G6, H6, I6)
	;   nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', J6),
	    'chr sbag_member'(K6, J6),
	    K6=suspension(_, _, _, _),
	    C=dynamic_type_check
	;   nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', L6),
	    'chr sbag_member'(M6, L6),
	    M6=suspension(_, _, _, N6),
	    C=dynamic_type_check_clauses(N6)
	;   nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', O6),
	    'chr sbag_member'(P6, O6),
	    P6=suspension(_, _, _, Q6),
	    C=atomic_type(Q6)
	;   nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', R6),
	    value_ht(R6, S6),
	    S6=suspension(_, _, T6, U6, V6),
	    C=stored(T6, U6, V6)
	;   nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', W6),
	    value_ht(W6, X6),
	    X6=suspension(_, _, _, Y6, Z6, A7),
	    C=stored_complete(Y6, Z6, A7)
	;   nb_getval('$chr_store_multi_hash_chr_translate:check_all_passive/2-1', B7),
	    value_ht(B7, C7),
	    C7=suspension(_, _, D7, E7),
	    C=check_all_passive(D7, E7)
	;   nb_getval('$chr_store_global_ground_chr_translate:constraints_code1/3', F7),
	    'chr sbag_member'(G7, F7),
	    G7=suspension(_, _, _, H7, I7, J7),
	    C=constraints_code1(H7, I7, J7)
	;   nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/1-1', K7),
	    value_ht(K7, L7),
	    L7=suspension(_, _, M7),
	    C=use_auxiliary_predicate(M7)
	;   nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-1', N7),
	    value_ht(N7, O7),
	    O7=suspension(_, _, P7, Q7),
	    C=use_auxiliary_predicate(P7, Q7)
	;   nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_module/1-1', R7),
	    value_ht(R7, S7),
	    S7=suspension(_, _, T7),
	    C=use_auxiliary_module(T7)
	;   nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-1', U7),
	    value_ht(U7, V7),
	    V7=suspension(_, _, W7, X7, Y7, Z7),
	    C=functional_dependency(W7, X7, Y7, Z7)
	;   nb_getval('$chr_store_multi_hash_chr_translate:initial_call_pattern/1-1', A8),
	    value_ht(A8, B8),
	    B8=suspension(_, _, _, C8),
	    C=initial_call_pattern(C8)
	;   nb_getval('$chr_store_multi_hash_chr_translate:call_pattern/1-1', D8),
	    value_ht(D8, E8),
	    E8=suspension(_, _, F8),
	    C=call_pattern(F8)
	;   nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', G8),
	    value_ht(G8, H8),
	    H8=suspension(_, _, _, I8, J8),
	    C=final_answer_pattern(I8, J8)
	;   nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', K8),
	    'chr sbag_member'(L8, K8),
	    L8=suspension(_, _, _, M8),
	    C=abstract_constraints(M8)
	;   nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-1', N8),
	    value_ht(N8, O8),
	    O8=suspension(_, _, _, P8, Q8),
	    C=depends_on(P8, Q8)
	;   nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2', R8),
	    value_ht(R8, S8),
	    S8=suspension(_, _, _, T8, U8, V8, W8),
	    C=depends_on_ap(T8, U8, V8, W8)
	;   nb_getval('$chr_store_multi_hash_chr_translate:depends_on_goal/2-2', X8),
	    value_ht(X8, Y8),
	    Y8=suspension(_, _, _, Z8, A9),
	    C=depends_on_goal(Z8, A9)
	;   nb_getval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', B9),
	    'chr sbag_member'(C9, B9),
	    C9=suspension(_, _, _, D9, E9),
	    C=ai_observed_internal(D9, E9)
	;   nb_getval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', F9),
	    'chr sbag_member'(G9, F9),
	    G9=suspension(_, _, _, H9, I9),
	    C=ai_not_observed_internal(H9, I9)
	;   nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed/2-12', J9),
	    value_ht(J9, K9),
	    K9=suspension(_, _, L9, M9),
	    C=ai_not_observed(L9, M9)
	;   nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-3', N9),
	    value_ht(N9, O9),
	    O9=suspension(_, _, _, P9, Q9, R9),
	    C=depends_on_as(P9, Q9, R9)
	;   nb_getval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', S9),
	    'chr sbag_member'(T9, S9),
	    T9=suspension(_, _, _),
	    C=ai_observation_gather_results
	;   nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_simplification_rest_heads/3-12', U9),
	    value_ht(U9, V9),
	    V9=suspension(_, _, W9, X9, Y9),
	    C=ai_observation_memoed_simplification_rest_heads(W9, X9, Y9)
	;   nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_propagation_rest_heads/3-12', Z9),
	    value_ht(Z9, A10),
	    A10=suspension(_, _, B10, C10, D10),
	    C=ai_observation_memoed_propagation_rest_heads(B10, C10, D10)
	;   nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_abstract_goal/2-1', E10),
	    value_ht(E10, F10),
	    F10=suspension(_, _, G10, H10),
	    C=ai_observation_memoed_abstract_goal(G10, H10)
	;   nb_getval('$chr_store_global_ground_chr_translate:ai_observation_memo_abstract_goal/2', I10),
	    'chr sbag_member'(J10, I10),
	    J10=suspension(_, _, _, K10, L10),
	    C=ai_observation_memo_abstract_goal(K10, L10)
	;   nb_getval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', M10),
	    'chr sbag_member'(N10, M10),
	    N10=suspension(_, _, _, _),
	    C=partial_wake_analysis
	;   nb_getval('$chr_store_multi_hash_chr_translate:no_partial_wake/1-1', O10),
	    value_ht(O10, P10),
	    P10=suspension(_, _, Q10),
	    C=no_partial_wake(Q10)
	;   nb_getval('$chr_store_multi_hash_chr_translate:phase_end/1-1', R10),
	    value_ht(R10, S10),
	    S10=suspension(_, _, T10),
	    C=phase_end(T10)
	;   nb_getval('$chr_store_multi_hash_chr_translate:delay_phase_end/2-1', U10),
	    value_ht(U10, V10),
	    V10=suspension(_, _, W10, X10),
	    C=delay_phase_end(W10, X10)
	;   nb_getval('$chr_store_multi_hash_chr_translate:does_use_history/2-1', Y10),
	    value_ht(Y10, Z10),
	    Z10=suspension(_, _, A11, B11),
	    C=does_use_history(A11, B11)
	;   nb_getval('$chr_store_multi_hash_chr_translate:does_use_field/2-12', C11),
	    value_ht(C11, D11),
	    D11=suspension(_, _, E11, F11),
	    C=does_use_field(E11, F11)
	;   nb_getval('$chr_store_multi_hash_chr_translate:uses_state/2-12', G11),
	    value_ht(G11, H11),
	    H11=suspension(_, _, I11, J11),
	    C=uses_state(I11, J11)
	;   nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', K11),
	    'chr sbag_member'(L11, K11),
	    L11=suspension(_, _, _, M11, N11, O11, P11, Q11),
	    C=if_used_state(M11, N11, O11, P11, Q11)
	;   nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', R11),
	    'chr sbag_member'(S11, R11),
	    S11=suspension(_, _, _),
	    C=used_states_known
	).
'$via1_multi_hash_indexed_argument/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:indexed_argument/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_indexed_argument/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:indexed_argument/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_constraint_mode/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_mode/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_store_type/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:store_type/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_actual_store_types/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_assumed_store_type/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_passive/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_passive/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_occurrence/5-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_occurrence/5-3'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_occurrence/5-13'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_occurrence/5-34'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_occurrence/5-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_max_occurrence/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_allocation_occurrence/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_allocation_occurrence/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_rule/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_least_occurrence/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_constraint_index/2-2'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_index/2-2', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_constraint_index/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_index/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_identifier_index/3-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:identifier_index/3-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_type_indexed_identifier_size/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_type_indexed_identifier_index/4-123'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-123', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_type_indexed_identifier_index/4-23'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-23', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_no_history/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:no_history/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_history/3-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:history/3-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_indexing_spec/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:indexing_spec/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns/3-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns/3-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns/3-3'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns/3-13'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns/3-123'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns_all/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns_all/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns_all_triggers/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_spawns_all_triggers/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_prolog_global_variable/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:prolog_global_variable/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_prev_guard_list/7-2'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_prev_guard_list/7-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_set_all_passive/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:set_all_passive/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_constraint_type/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_type/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_stored/3-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_stored/3-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_stored_complete/3-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_check_all_passive/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:check_all_passive/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_use_auxiliary_predicate/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_use_auxiliary_predicate/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_use_auxiliary_predicate/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_use_auxiliary_module/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_module/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_functional_dependency/4-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_functional_dependency/4-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_initial_call_pattern/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:initial_call_pattern/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_call_pattern/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:call_pattern/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_final_answer_pattern/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on/2-2'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-2', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on_ap/4-2'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on_ap/4-3'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-3', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on_goal/2-2'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on_goal/2-2', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_ai_observed_internal/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observed_internal/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_ai_not_observed_internal/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed_internal/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_ai_not_observed/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on_as/3-3'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-3', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_depends_on_as/3-2'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-2', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_ai_observation_memoed_simplification_rest_heads/3-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_simplification_rest_heads/3-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_ai_observation_memoed_propagation_rest_heads/3-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_propagation_rest_heads/3-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_ai_observation_memoed_abstract_goal/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_abstract_goal/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_no_partial_wake/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:no_partial_wake/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_phase_end/1-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:phase_end/1-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_delay_phase_end/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:delay_phase_end/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_does_use_history/2-1'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:does_use_history/2-1', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_does_use_history/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:does_use_history/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_does_use_field/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:does_use_field/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_uses_state/2-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:uses_state/2-12', A),
	lookup_ht(A, B, C).
'$via1_multi_hash_if_used_state/5-12'(B, C) :-
	nb_getval('$chr_store_multi_hash_chr_translate:if_used_state/5-12', A),
	lookup_ht(A, B, C).
'$chr_initialization' :-
	nb_setval('$chr_store_global_ground_chr_translate:used_states_known/0', []),
	new_ht(A),
	nb_setval('$chr_store_multi_hash_chr_translate:if_used_state/5-12', A),
	nb_setval('$chr_store_global_ground_chr_translate:if_used_state/5', []),
	new_ht(B),
	nb_setval('$chr_store_multi_hash_chr_translate:uses_state/2-12', B),
	new_ht(C),
	nb_setval('$chr_store_multi_hash_chr_translate:does_use_field/2-12', C),
	new_ht(D),
	nb_setval('$chr_store_multi_hash_chr_translate:does_use_history/2-12', D),
	new_ht(E),
	nb_setval('$chr_store_multi_hash_chr_translate:does_use_history/2-1', E),
	new_ht(F),
	nb_setval('$chr_store_multi_hash_chr_translate:delay_phase_end/2-1', F),
	new_ht(G),
	nb_setval('$chr_store_multi_hash_chr_translate:phase_end/1-1', G),
	new_ht(H),
	nb_setval('$chr_store_multi_hash_chr_translate:no_partial_wake/1-1', H),
	nb_setval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', []),
	nb_setval('$chr_store_global_ground_chr_translate:ai_observation_memo_abstract_goal/2', []),
	new_ht(I),
	nb_setval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_abstract_goal/2-1', I),
	new_ht(J),
	nb_setval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_propagation_rest_heads/3-12', J),
	new_ht(K),
	nb_setval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_simplification_rest_heads/3-12', K),
	nb_setval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', []),
	new_ht(L),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on_as/3-2', L),
	new_ht(M),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on_as/3-3', M),
	new_ht(N),
	nb_setval('$chr_store_multi_hash_chr_translate:ai_not_observed/2-12', N),
	new_ht(O),
	nb_setval('$chr_store_multi_hash_chr_translate:ai_not_observed_internal/2-12', O),
	nb_setval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', []),
	new_ht(P),
	nb_setval('$chr_store_multi_hash_chr_translate:ai_observed_internal/2-12', P),
	nb_setval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', []),
	new_ht(Q),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on_goal/2-2', Q),
	new_ht(R),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-3', R),
	new_ht(S),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2', S),
	new_ht(T),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on/2-2', T),
	new_ht(U),
	nb_setval('$chr_store_multi_hash_chr_translate:depends_on/2-1', U),
	nb_setval('$chr_store_global_ground_chr_translate:abstract_constraints/1', []),
	new_ht(V),
	nb_setval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', V),
	new_ht(W),
	nb_setval('$chr_store_multi_hash_chr_translate:call_pattern/1-1', W),
	new_ht(X),
	nb_setval('$chr_store_multi_hash_chr_translate:initial_call_pattern/1-1', X),
	new_ht(Y),
	nb_setval('$chr_store_multi_hash_chr_translate:functional_dependency/4-12', Y),
	new_ht(Z),
	nb_setval('$chr_store_multi_hash_chr_translate:functional_dependency/4-1', Z),
	new_ht(A1),
	nb_setval('$chr_store_multi_hash_chr_translate:use_auxiliary_module/1-1', A1),
	new_ht(B1),
	nb_setval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-12', B1),
	new_ht(C1),
	nb_setval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-1', C1),
	new_ht(D1),
	nb_setval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/1-1', D1),
	nb_setval('$chr_store_global_ground_chr_translate:constraints_code1/3', []),
	new_ht(E1),
	nb_setval('$chr_store_multi_hash_chr_translate:check_all_passive/2-1', E1),
	new_ht(F1),
	nb_setval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', F1),
	new_ht(G1),
	nb_setval('$chr_store_multi_hash_chr_translate:stored/3-12', G1),
	new_ht(H1),
	nb_setval('$chr_store_multi_hash_chr_translate:stored/3-1', H1),
	nb_setval('$chr_store_global_list_chr_translate:atomic_type/1', []),
	nb_setval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', []),
	nb_setval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', []),
	nb_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', []),
	nb_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', []),
	nb_setval('$chr_store_global_ground_chr_translate:static_type_check/0', []),
	nb_setval('$chr_store_global_ground_chr_translate:types_modes_condition/3', []),
	nb_setval('$chr_store_global_list_chr_translate:unalias_type/2', []),
	new_ht(I1),
	nb_setval('$chr_store_multi_hash_chr_translate:constraint_type/2-1', I1),
	nb_setval('$chr_store_global_list_chr_translate:type_alias/2', []),
	nb_setval('$chr_store_global_list_chr_translate:type_definition/2', []),
	nb_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', []),
	new_ht(J1),
	nb_setval('$chr_store_multi_hash_chr_translate:set_all_passive/1-1', J1),
	new_ht(K1),
	nb_setval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', K1),
	new_ht(L1),
	nb_setval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', L1),
	new_ht(M1),
	nb_setval('$chr_store_multi_hash_chr_translate:prolog_global_variable/1-1', M1),
	nb_setval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', []),
	nb_setval('$chr_store_global_ground_chr_translate:module_initializer/1', []),
	nb_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', []),
	new_ht(N1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', N1),
	new_ht(O1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', O1),
	nb_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', []),
	new_ht(P1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns_all/2-12', P1),
	new_ht(Q1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', Q1),
	new_ht(R1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns/3-123', R1),
	new_ht(S1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns/3-13', S1),
	new_ht(T1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns/3-3', T1),
	new_ht(U1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns/3-1', U1),
	new_ht(V1),
	nb_setval('$chr_store_multi_hash_chr_translate:spawns/3-12', V1),
	nb_setval('$chr_store_global_ground_chr_translate:spawns/3', []),
	nb_setval('$chr_store_global_ground_chr_translate:observation_analysis/1', []),
	new_ht(W1),
	nb_setval('$chr_store_multi_hash_chr_translate:indexing_spec/2-1', W1),
	new_ht(X1),
	nb_setval('$chr_store_multi_hash_chr_translate:history/3-1', X1),
	new_ht(Y1),
	nb_setval('$chr_store_multi_hash_chr_translate:no_history/1-1', Y1),
	new_ht(Z1),
	nb_setval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-23', Z1),
	new_ht(A2),
	nb_setval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-123', A2),
	new_ht(B2),
	nb_setval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1', B2),
	new_ht(C2),
	nb_setval('$chr_store_multi_hash_chr_translate:identifier_index/3-12', C2),
	nb_setval('$chr_store_global_ground_chr_translate:identifier_size/1', []),
	nb_setval('$chr_store_global_ground_chr_translate:max_constraint_index/1', []),
	new_ht(D2),
	nb_setval('$chr_store_multi_hash_chr_translate:constraint_index/2-1', D2),
	new_ht(E2),
	nb_setval('$chr_store_multi_hash_chr_translate:constraint_index/2-2', E2),
	new_ht(F2),
	nb_setval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', F2),
	new_ht(G2),
	nb_setval('$chr_store_multi_hash_chr_translate:rule/2-1', G2),
	nb_setval('$chr_store_global_ground_chr_translate:rule/2', []),
	new_ht(H2),
	nb_setval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', H2),
	new_ht(I2),
	nb_setval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', I2),
	new_ht(J2),
	nb_setval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', J2),
	new_ht(K2),
	nb_setval('$chr_store_multi_hash_chr_translate:occurrence/5-1', K2),
	new_ht(L2),
	nb_setval('$chr_store_multi_hash_chr_translate:occurrence/5-34', L2),
	new_ht(M2),
	nb_setval('$chr_store_multi_hash_chr_translate:occurrence/5-13', M2),
	new_ht(N2),
	nb_setval('$chr_store_multi_hash_chr_translate:occurrence/5-3', N2),
	new_ht(O2),
	nb_setval('$chr_store_multi_hash_chr_translate:occurrence/5-12', O2),
	nb_setval('$chr_store_global_ground_chr_translate:occurrence/5', []),
	new_ht(P2),
	nb_setval('$chr_store_multi_hash_chr_translate:passive/2-12', P2),
	new_ht(Q2),
	nb_setval('$chr_store_multi_hash_chr_translate:passive/2-1', Q2),
	nb_setval('$chr_store_global_ground_chr_translate:rule_count/1', []),
	new_ht(R2),
	nb_setval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', R2),
	new_ht(S2),
	nb_setval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', S2),
	new_ht(T2),
	nb_setval('$chr_store_multi_hash_chr_translate:store_type/2-1', T2),
	nb_setval('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0', []),
	new_ht(U2),
	nb_setval('$chr_store_multi_hash_chr_translate:constraint_mode/2-1', U2),
	nb_setval('$chr_store_global_ground_chr_translate:constraint_mode/2', []),
	new_ht(V2),
	nb_setval('$chr_store_multi_hash_chr_translate:indexed_argument/2-12', V2),
	new_ht(W2),
	nb_setval('$chr_store_multi_hash_chr_translate:indexed_argument/2-1', W2),
	nb_setval('$chr_store_global_ground_chr_translate:target_module/1', []).
:- '$chr_initialization'.
:- dynamic user:exception/3.
:- multifile user:exception/3.
user:exception(undefined_global_variable, A, retry) :-
	'$chr_prolog_global_variable'(A),
	'$chr_initialization'.
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:used_states_known/0').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:if_used_state/5-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:if_used_state/5').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:uses_state/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:does_use_field/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:does_use_history/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:does_use_history/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:delay_phase_end/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:phase_end/1-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:no_partial_wake/1-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:partial_wake_analysis/0').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:ai_observation_memo_abstract_goal/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:ai_observation_memoed_abstract_goal/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:ai_observation_memoed_propagation_rest_heads/3-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:ai_observation_memoed_simplification_rest_heads/3-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on_as/3-2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on_as/3-3').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:ai_not_observed/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:ai_not_observed_internal/2-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:ai_observed_internal/2-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:ai_observed_internal/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on_goal/2-2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on_ap/4-3').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on/2-2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:depends_on/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:abstract_constraints/1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:call_pattern/1-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:initial_call_pattern/1-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:functional_dependency/4-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:functional_dependency/4-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:use_auxiliary_module/1-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/1-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:constraints_code1/3').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:check_all_passive/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:stored_complete/3-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:stored/3-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:stored/3-1').
'$chr_prolog_global_variable'('$chr_store_global_list_chr_translate:atomic_type/1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:dynamic_type_check/0').
'$chr_prolog_global_variable'('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3').
'$chr_prolog_global_variable'('$chr_store_global_list_chr_translate:static_type_check_var/3').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:static_type_check/0').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:types_modes_condition/3').
'$chr_prolog_global_variable'('$chr_store_global_list_chr_translate:unalias_type/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:constraint_type/2-1').
'$chr_prolog_global_variable'('$chr_store_global_list_chr_translate:type_alias/2').
'$chr_prolog_global_variable'('$chr_store_global_list_chr_translate:type_definition/2').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:set_all_passive/1-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:prolog_global_variable/1-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:prolog_global_variable/1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:module_initializer/1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:spawns_all_triggers/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns_all/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns_all/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns/3-123').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns/3-13').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns/3-3').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns/3-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:spawns/3-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:spawns/3').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:observation_analysis/1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:indexing_spec/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:history/3-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:no_history/1-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-23').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-123').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:identifier_index/3-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:identifier_size/1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:max_constraint_index/1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:constraint_index/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:constraint_index/2-2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:least_occurrence/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:rule/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:rule/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:max_occurrence/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:occurrence/5-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:occurrence/5-34').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:occurrence/5-13').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:occurrence/5-3').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:occurrence/5-12').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:occurrence/5').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:passive/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:passive/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:rule_count/1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:actual_store_types/2-1').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:store_type/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:constraint_mode/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:constraint_mode/2').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:indexed_argument/2-12').
'$chr_prolog_global_variable'('$chr_store_multi_hash_chr_translate:indexed_argument/2-1').
'$chr_prolog_global_variable'('$chr_store_global_ground_chr_translate:target_module/1').
target_module(_) :-
	nb_getval('$chr_store_global_ground_chr_translate:target_module/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _), !.
target_module(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:target_module/1', A), !,
	'target_module/1__0__0'(A, B).
'target_module/1__0__0'([], A) :-
	'target_module/1__1'(A).
'target_module/1__0__0'([A|F], G) :-
	(   A=suspension(_, active, _, _)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:target_module/1', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:target_module/1', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    'target_module/1__0__0'(F, G)
	;   'target_module/1__0__0'(F, G)
	).
target_module(A) :-
	'target_module/1__1'(A).
'target_module/1__1'(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:target_module/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:target_module/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
get_target_module(C) :-
	nb_getval('$chr_store_global_ground_chr_translate:target_module/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, D), !,
	C=D.
get_target_module(user).
indexed_argument(A, B) :-
	'$via1_multi_hash_indexed_argument/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
indexed_argument(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:indexed_argument/2-1', D),
	insert_ht(D, A, E),
	nb_getval('$chr_store_multi_hash_chr_translate:indexed_argument/2-12', F),
	insert_ht(F, k(A, B), E).
is_indexed_argument(A, B) :-
	'$via1_multi_hash_indexed_argument/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
is_indexed_argument(_, _) :-
	fail.
constraint_mode(A, B) :-
	'constraint_mode/2__0'(A, B, _).
'constraint_mode/2__0'(A, _, _) :-
	'$via1_multi_hash_constraint_mode/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, _), !.
'constraint_mode/2__0'(A, C, D) :-
	'$via1_multi_hash_constraint_mode/2-1'(A, B), !,
	'constraint_mode/2__0__0'(B, A, C, D).
'constraint_mode/2__0__0'([], A, B, C) :-
	'constraint_mode/2__1'(A, B, C).
'constraint_mode/2__0__0'([A|I], C, J, K) :-
	(   A=suspension(_, active, _, _, B, _),
	    B==C
	->  setarg(2, A, removed),
	    arg(4, A, D),
	    (   var(D)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', E),
		E=[_|F],
		b_setval('$chr_store_global_ground_chr_translate:constraint_mode/2', F),
		(   F=[G|_]
		->  setarg(4, G, _)
		;   true
		)
	    ;   D=[_, _|F],
		setarg(2, D, F),
		(   F=[G|_]
		->  setarg(4, G, D)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:constraint_mode/2-1', H),
	    delete_ht(H, C, A),
	    'constraint_mode/2__0__0'(I, C, J, K)
	;   'constraint_mode/2__0__0'(I, C, J, K)
	).
'constraint_mode/2__0'(A, B, C) :-
	'constraint_mode/2__1'(A, B, C).
'constraint_mode/2__1'(A, C, B) :-
	A=F/G,
	nb_getval('$chr_store_global_ground_chr_translate:types_modes_condition/3', E), !,
	B=suspension(D, not_stored_yet, t, _, A, C),
	'chr gen_id'(D),
	'constraint_mode/2__1__0'(E, A, C, B, F, G).
'constraint_mode/2__1__0'([], A, B, C, _, _) :-
	'constraint_mode/2__2'(A, B, C).
'constraint_mode/2__1__0'([A|C1], Q, S, K, E, F) :-
	(   A=suspension(_, active, _, B, C, R),
	    B=[D|Z],
	    C=[V|A1],
	    functor(D, E, F)
	->  setarg(2, A, removed),
	    arg(3, A, G),
	    (   var(G)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:types_modes_condition/3', H),
		H=[_|I],
		b_setval('$chr_store_global_ground_chr_translate:types_modes_condition/3', I),
		(   I=[J|_]
		->  setarg(3, J, _)
		;   true
		)
	    ;   G=[_, _|I],
		setarg(2, G, I),
		(   I=[J|_]
		->  setarg(3, J, G)
		;   true
		)
	    ),
	    arg(2, K, L),
	    setarg(2, K, active),
	    (   L==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', M),
		N=[K|M],
		b_setval('$chr_store_global_ground_chr_translate:constraint_mode/2', N),
		(   M=[O|_]
		->  setarg(4, O, N)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:constraint_mode/2-1', P),
		insert_ht(P, Q, K)
	    ;   true
	    ),
	    D=..[_|T],
	    R= (U, Y, B1),
	    modes_condition(S, T, U),
	    get_constraint_type_det(E/F, W),
	    V=..[_|X],
	    types_condition(W, T, X, S, Y),
	    types_modes_condition(Z, A1, B1),
	    (   K=suspension(_, active, _, _, _, _)
	    ->  setarg(2, K, inactive),
		'constraint_mode/2__1__0'(C1, Q, S, K, E, F)
	    ;   true
	    )
	;   'constraint_mode/2__1__0'(C1, Q, S, K, E, F)
	).
'constraint_mode/2__1'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, _, B, C),
	'chr gen_id'(D),
	'constraint_mode/2__2'(B, C, A).
'constraint_mode/2__2'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-1'(A, B), !,
	'constraint_mode/2__2__0'(B, A, C, D).
'constraint_mode/2__2__0'([], A, B, C) :-
	'constraint_mode/2__3'(A, B, C).
'constraint_mode/2__2__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, _, B, _, E, F, G),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', D)
	->  'constraint_mode/2__2__1'(D, E, F, G, A, H, C, I, J)
	;   'constraint_mode/2__2__0'(H, C, I, J)
	).
'constraint_mode/2__2__1'([], _, _, _, _, A, B, C, D) :-
	'constraint_mode/2__2__0'(A, B, C, D).
'constraint_mode/2__2__1'([A|D], B, E, F, G, H, I, J, K) :-
	(   A=suspension(_, active, _, _),
	    '$via1_multi_hash_rule/2-1'(B, C)
	->  'constraint_mode/2__2__2'(C, A, D, B, E, F, G, H, I, J, K)
	;   'constraint_mode/2__2__1'(D, B, E, F, G, H, I, J, K)
	).
'constraint_mode/2__2__2'([], _, A, B, C, D, E, F, G, H, I) :-
	'constraint_mode/2__2__1'(A, B, C, D, E, F, G, H, I).
'constraint_mode/2__2__2'([A|X], D, Y, C, O, P, E, Z, M, U, F) :-
	(   A=suspension(_, active, _, _, B, N),
	    B==C,
	    G=t(273, D, E, A, F),
	    '$novel_production'(D, G),
	    '$novel_production'(E, G),
	    '$novel_production'(A, G),
	    '$novel_production'(F, G)
	->  '$extend_history'(F, G),
	    arg(2, F, H),
	    setarg(2, F, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', I),
		J=[F|I],
		b_setval('$chr_store_global_ground_chr_translate:constraint_mode/2', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:constraint_mode/2-1', L),
		insert_ht(L, M, F)
	    ;   true
	    ),
	    N=pragma(rule(Q, W, S, _), _, _, _, _),
	    (   is_passive(C, O)
	    ->  true
	    ;   P==simplification
	    ->  select(R, Q, _),
		R=..[_|T],
		term_variables(S, V),
		partial_wake_args(T, U, V, M)
	    ;   select(R, W, _),
		R=..[_|T],
		term_variables(S, V),
		partial_wake_args(T, U, V, M)
	    ),
	    (   F=suspension(_, active, _, _, _, _)
	    ->  setarg(2, F, inactive),
		'constraint_mode/2__2__2'(X, D, Y, C, O, P, E, Z, M, U, F)
	    ;   true
	    )
	;   'constraint_mode/2__2__2'(X, D, Y, C, O, P, E, Z, M, U, F)
	).
'constraint_mode/2__2'(A, B, C) :-
	'constraint_mode/2__3'(A, B, C).
'constraint_mode/2__3'(G, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:constraint_mode/2', D),
	    (   C=[E|_]
	    ->  setarg(4, E, D)
	    ;   true
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:constraint_mode/2-1', F),
	    insert_ht(F, G, A)
	;   true
	).
get_constraint_mode(A, D) :-
	'$via1_multi_hash_constraint_mode/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, E), !,
	D=E.
get_constraint_mode(_/A, B) :-
	replicate(A, ?, B).
may_trigger(A) :-
	\+has_active_occurrence(A), !,
	fail.
may_trigger(A) :-
	'$via1_multi_hash_constraint_mode/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, G),
	'$via1_multi_hash_indexed_argument/2-1'(A, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, F),
	nth1(F, G, H),
	H\== (+), !,
	is_stored(A).
may_trigger(_) :-
	chr_pp_flag(debugable, on).
only_ground_indexed_arguments(A) :-
	'$via1_multi_hash_constraint_mode/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, G),
	'$via1_multi_hash_indexed_argument/2-1'(A, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, F),
	nth1(F, G, H),
	H\== (+), !,
	fail.
only_ground_indexed_arguments(_).
none_suspended_on_variables :-
	nb_getval('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !.
none_suspended_on_variables :-
	B=suspension(A, active, _),
	'chr gen_id'(A),
	nb_getval('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0', C),
	D=[B|C],
	b_setval('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0', D),
	(   C=[E|_]
	->  setarg(3, E, D)
	;   true
	).
are_none_suspended_on_variables :-
	nb_getval('$chr_store_global_ground_chr_translate:none_suspended_on_variables/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !.
are_none_suspended_on_variables :-
	fail.
store_type(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:store_type/2-1', D),
	insert_ht(D, A, E).
get_store_type(A, D) :-
	'$via1_multi_hash_store_type/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_store_type(A, D) :-
	'$via1_multi_hash_assumed_store_type/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_store_type(_, default).
update_store_type(A, D) :-
	'$via1_multi_hash_actual_store_types/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E),
	member(D, E), !.
update_store_type(A, E) :-
	'$via1_multi_hash_actual_store_types/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, F), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', D),
	delete_ht(D, A, C),
	actual_store_types(A, [E|F]).
update_store_type(A, B) :-
	actual_store_types(A, [B]).
actual_store_types(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', D),
	insert_ht(D, A, E).
assumed_store_type(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', D),
	insert_ht(D, A, E).
validate_store_type_assumption(A) :-
	'$via1_multi_hash_actual_store_types/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, H),
	'$via1_multi_hash_assumed_store_type/2-1'(A, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', F),
	delete_ht(F, A, C),
	setarg(2, E, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', G),
	delete_ht(G, A, E),
	store_type(A, multi_store(H)).
validate_store_type_assumption(A) :-
	'$via1_multi_hash_actual_store_types/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, H),
	'$via1_multi_hash_store_type/2-1'(A, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:actual_store_types/2-1', F),
	delete_ht(F, A, C),
	setarg(2, E, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:store_type/2-1', G),
	delete_ht(G, A, E),
	store_type(A, multi_store(H)).
validate_store_type_assumption(A) :-
	'$via1_multi_hash_assumed_store_type/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _),
	chr_pp_flag(debugable, on), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', D),
	delete_ht(D, A, C),
	store_type(A, default).
validate_store_type_assumption(A) :-
	'$via1_multi_hash_assumed_store_type/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:assumed_store_type/2-1', D),
	delete_ht(D, A, C),
	store_type(A, global_ground).
validate_store_type_assumption(_).
rule_count(_) :-
	nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _), !.
rule_count(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', A), !,
	'rule_count/1__0__0'(A, B).
'rule_count/1__0__0'([], A) :-
	'rule_count/1__1'(A).
'rule_count/1__0__0'([A|F], G) :-
	(   A=suspension(_, active, _, _)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:rule_count/1', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    'rule_count/1__0__0'(F, G)
	;   'rule_count/1__0__0'(F, G)
	).
rule_count(A) :-
	'rule_count/1__1'(A).
'rule_count/1__1'(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:rule_count/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
inc_rule_count(G) :-
	nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, H), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:rule_count/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:rule_count/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	G is H+1,
	rule_count(G).
inc_rule_count(1) :-
	rule_count(1).
passive(A, B) :-
	'passive/2__0'(A, B, _).
'passive/2__0'(A, B, _) :-
	'$via1_multi_hash_passive/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !.
'passive/2__0'(A, B, C) :-
	'$via1_multi_hash_occurrence/5-34'(k(A, B), E), !,
	C=suspension(D, not_stored_yet, t, A, B),
	'chr gen_id'(D),
	'passive/2__0__0'(E, A, B, C).
'passive/2__0__0'([], A, B, C) :-
	'passive/2__1'(A, B, C).
'passive/2__0__0'([A|I], C, E, J) :-
	(   A=suspension(_, active, _, _, F, G, B, D, _),
	    B==C,
	    D==E,
	    '$via1_multi_hash_allocation_occurrence/2-12'(k(F, G), H)
	->  'passive/2__0__1'(H, F, G, A, I, C, E, J)
	;   'passive/2__0__0'(I, C, E, J)
	).
'passive/2__0__1'([], _, _, _, A, B, C, D) :-
	'passive/2__0__0'(A, B, C, D).
'passive/2__0__1'([A|O], C, E, P, Q, K, M, H) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', F),
	    delete_ht(F, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', G),
	    delete_ht(G, k(C, E), A),
	    arg(2, H, I),
	    setarg(2, H, active),
	    (   I==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', J),
		insert_ht(J, K, H),
		nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', L),
		insert_ht(L, k(K, M), H)
	    ;   true
	    ),
	    N is E+1,
	    allocation_occurrence(C, N),
	    (   H=suspension(_, active, _, _, _)
	    ->  setarg(2, H, inactive),
		'passive/2__0__1'(O, C, E, P, Q, K, M, H)
	    ;   true
	    )
	;   'passive/2__0__1'(O, C, E, P, Q, K, M, H)
	).
'passive/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, B, C),
	'chr gen_id'(D),
	'passive/2__1'(B, C, A).
'passive/2__1'(A, C, D) :-
	'$via1_multi_hash_least_occurrence/2-1'(A, B), !,
	'passive/2__1__0'(B, A, C, D).
'passive/2__1__0'([], A, B, C) :-
	'passive/2__2'(A, B, C).
'passive/2__1__0'([A|O], C, F, J) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[E|N],
	    E==F,
	    ground(C),
	    '$via1_multi_hash_rule/2-1'(C, G),
	    'chr sbag_member'(H, G),
	    H=suspension(_, active, _, _, _, _)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', I),
	    delete_ht(I, C, A),
	    arg(2, J, K),
	    setarg(2, J, active),
	    (   K==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', L),
		insert_ht(L, C, J),
		nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', M),
		insert_ht(M, k(C, F), J)
	    ;   true
	    ),
	    least_occurrence(C, N),
	    (   J=suspension(_, active, _, _, _)
	    ->  setarg(2, J, inactive),
		'passive/2__1__0'(O, C, F, J)
	    ;   true
	    )
	;   'passive/2__1__0'(O, C, F, J)
	).
'passive/2__1'(A, B, C) :-
	'passive/2__2'(A, B, C).
'passive/2__2'(A, B, D) :-
	'$via1_multi_hash_occurrence/5-34'(k(A, B), C), !,
	'passive/2__2__0'(C, A, B, D).
'passive/2__2__0'([], A, B, C) :-
	'passive/2__3'(A, B, C).
'passive/2__2__0'([A|I], C, E, J) :-
	(   A=suspension(_, active, _, _, F, G, B, D, _),
	    B==C,
	    D==E,
	    '$via1_multi_hash_stored/3-12'(k(F, G), H)
	->  'passive/2__2__1'(H, F, G, A, I, C, E, J)
	;   'passive/2__2__0'(I, C, E, J)
	).
'passive/2__2__1'([], _, _, _, A, B, C, D) :-
	'passive/2__2__0'(A, B, C, D).
'passive/2__2__1'([A|U], C, E, V, W, P, R, M) :-
	(   A=suspension(_, active, B, D, F),
	    B==C,
	    D==E,
	    F=yes,
	    ground(C),
	    '$via1_multi_hash_stored_complete/3-1'(C, G),
	    'chr sbag_member'(H, G),
	    H=suspension(_, active, _, _, I, S),
	    E<I
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', K),
	    delete_ht(K, k(C, E), A),
	    setarg(2, H, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', L),
	    delete_ht(L, C, H),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', O),
		insert_ht(O, P, M),
		nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', Q),
		insert_ht(Q, k(P, R), M)
	    ;   true
	    ),
	    T is S-1,
	    stored(C, E, maybe),
	    stored_complete(C, I, T),
	    (   M=suspension(_, active, _, _, _)
	    ->  setarg(2, M, inactive),
		'passive/2__2__1'(U, C, E, V, W, P, R, M)
	    ;   true
	    )
	;   'passive/2__2__1'(U, C, E, V, W, P, R, M)
	).
'passive/2__2'(A, B, C) :-
	'passive/2__3'(A, B, C).
'passive/2__3'(A, C, D) :-
	'$via1_multi_hash_rule/2-1'(A, B), !,
	'passive/2__3__0'(B, A, C, D).
'passive/2__3__0'([], A, B, C) :-
	'passive/2__4'(A, B, C).
'passive/2__3__0'([A|N], C, G, D) :-
	(   A=suspension(_, active, _, _, B, F),
	    B==C,
	    E=t(196, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E),
	    F=pragma(rule(_, _, _, _), ids([G|K], L), _, _, C)
	->  '$extend_history'(D, E),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', I),
		insert_ht(I, C, D),
		nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', J),
		insert_ht(J, k(C, G), D)
	    ;   true
	    ),
	    append(K, L, M),
	    check_all_passive(C, M),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'passive/2__3__0'(N, C, G, D)
	    ;   true
	    )
	;   'passive/2__3__0'(N, C, G, D)
	).
'passive/2__3'(A, B, C) :-
	'passive/2__4'(A, B, C).
'passive/2__4'(A, C, D) :-
	'$via1_multi_hash_rule/2-1'(A, B), !,
	'passive/2__4__0'(B, A, C, D).
'passive/2__4__0'([], A, B, C) :-
	'passive/2__5'(A, B, C).
'passive/2__4__0'([A|L], C, G, D) :-
	(   A=suspension(_, active, _, _, B, F),
	    B==C,
	    E=t(197, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E),
	    F=pragma(rule(_, _, _, _), ids([], [G|K]), _, _, C)
	->  '$extend_history'(D, E),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', I),
		insert_ht(I, C, D),
		nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', J),
		insert_ht(J, k(C, G), D)
	    ;   true
	    ),
	    check_all_passive(C, K),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'passive/2__4__0'(L, C, G, D)
	    ;   true
	    )
	;   'passive/2__4__0'(L, C, G, D)
	).
'passive/2__4'(A, B, C) :-
	'passive/2__5'(A, B, C).
'passive/2__5'(A, C, D) :-
	'$via1_multi_hash_check_all_passive/2-1'(A, B), !,
	'passive/2__5__0'(B, A, C, D).
'passive/2__5__0'([], A, B, C) :-
	'passive/2__6'(A, B, C).
'passive/2__5__0'([A|M], C, F, H) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[E|L],
	    E==F
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:check_all_passive/2-1', G),
	    delete_ht(G, C, A),
	    arg(2, H, I),
	    setarg(2, H, active),
	    (   I==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', J),
		insert_ht(J, C, H),
		nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', K),
		insert_ht(K, k(C, F), H)
	    ;   true
	    ),
	    check_all_passive(C, L),
	    (   H=suspension(_, active, _, _, _)
	    ->  setarg(2, H, inactive),
		'passive/2__5__0'(M, C, F, H)
	    ;   true
	    )
	;   'passive/2__5__0'(M, C, F, H)
	).
'passive/2__5'(A, B, C) :-
	'passive/2__6'(A, B, C).
'passive/2__6'(D, F, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:passive/2-1', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:passive/2-12', E),
	    insert_ht(E, k(D, F), A)
	;   true
	).
is_passive(A, B) :-
	'$via1_multi_hash_passive/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !.
is_passive(_, _) :-
	fail.
any_passive_head(A) :-
	'$via1_multi_hash_passive/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _), !.
any_passive_head(_) :-
	fail.
new_occurrence(A, G, H, I) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, E), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', D),
	delete_ht(D, A, C),
	F is E+1,
	occurrence(A, F, G, H, I),
	max_occurrence(A, F).
new_occurrence(A, B, _, _) :-
	chr_error(internal, 'new_occurrence: missing max_occurrence for ~w in rule ~w\n', [A, B]).
occurrence(A, B, C, D, E) :-
	'occurrence/5__0'(A, B, C, D, E, _).
'occurrence/5__0'(A, B, D, E, F, C) :-
	'$via1_multi_hash_allocation_occurrence/2-12'(k(A, B), H), !,
	C=suspension(G, not_stored_yet, t, _, A, B, D, E, F),
	'chr gen_id'(G),
	'occurrence/5__0__0'(H, A, B, D, E, F, C).
'occurrence/5__0__0'([], A, B, C, D, E, F) :-
	'occurrence/5__1'(A, B, C, D, E, F).
'occurrence/5__0__0'([A|W], C, E, F, G, X, L) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    ground(F),
	    ground(G),
	    '$via1_multi_hash_passive/2-12'(k(F, G), H),
	    'chr sbag_member'(I, H),
	    I=suspension(_, active, _, _, _)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', K),
	    delete_ht(K, k(C, E), A),
	    arg(2, L, M),
	    setarg(2, L, active),
	    (   M==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', N),
		O=[L|N],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', O),
		(   N=[P|_]
		->  setarg(4, P, O)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', Q),
		insert_ht(Q, k(C, E), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', R),
		insert_ht(R, F, L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', S),
		insert_ht(S, k(C, F), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', T),
		insert_ht(T, k(F, G), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', U),
		insert_ht(U, C, L)
	    ;   true
	    ),
	    V is E+1,
	    allocation_occurrence(C, V),
	    (   L=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, L, inactive),
		'occurrence/5__0__0'(W, C, E, F, G, X, L)
	    ;   true
	    )
	;   'occurrence/5__0__0'(W, C, E, F, G, X, L)
	).
'occurrence/5__0'(B, C, D, E, F, A) :-
	A=suspension(G, not_stored_yet, t, _, B, C, D, E, F),
	'chr gen_id'(G),
	'occurrence/5__1'(B, C, D, E, F, A).
'occurrence/5__1'(A, B, D, E, F, G) :-
	'$via1_multi_hash_allocation_occurrence/2-12'(k(A, B), C), !,
	'occurrence/5__1__0'(C, A, B, D, E, F, G).
'occurrence/5__1__0'([], A, B, C, D, E, F) :-
	'occurrence/5__2'(A, B, C, D, E, F).
'occurrence/5__1__0'([A|Y], C, E, F, J, Z, N) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    ground(F),
	    '$via1_multi_hash_rule/2-1'(F, G),
	    'chr sbag_member'(H, G),
	    H=suspension(_, active, _, _, _, I),
	    \+is_stored_in_guard(C, F),
	    I=pragma(_, ids(K, _), _, _, _),
	    member(J, K)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', L),
	    delete_ht(L, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', M),
	    delete_ht(M, k(C, E), A),
	    arg(2, N, O),
	    setarg(2, N, active),
	    (   O==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', P),
		Q=[N|P],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', Q),
		(   P=[R|_]
		->  setarg(4, R, Q)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', S),
		insert_ht(S, k(C, E), N),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', T),
		insert_ht(T, F, N),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', U),
		insert_ht(U, k(C, F), N),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', V),
		insert_ht(V, k(F, J), N),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', W),
		insert_ht(W, C, N)
	    ;   true
	    ),
	    X is E+1,
	    allocation_occurrence(C, X),
	    (   N=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, N, inactive),
		'occurrence/5__1__0'(Y, C, E, F, J, Z, N)
	    ;   true
	    )
	;   'occurrence/5__1__0'(Y, C, E, F, J, Z, N)
	).
'occurrence/5__1'(A, B, C, D, E, F) :-
	'occurrence/5__2'(A, B, C, D, E, F).
'occurrence/5__2'(A, B, D, E, F, G) :-
	'$via1_multi_hash_allocation_occurrence/2-12'(k(A, B), C), !,
	'occurrence/5__2__0'(C, A, B, D, E, F, G).
'occurrence/5__2__0'([], A, B, C, D, E, F) :-
	'occurrence/5__3'(A, B, C, D, E, F).
'occurrence/5__2__0'([A|X], C, E, F, U, Y, L) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    ground(F),
	    '$via1_multi_hash_rule/2-1'(F, G),
	    'chr sbag_member'(H, G),
	    H=suspension(_, active, _, _, _, I),
	    I=pragma(rule([_|_], _, _, _), _, _, _, _),
	    \+is_observed(C, E)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', K),
	    delete_ht(K, k(C, E), A),
	    arg(2, L, M),
	    setarg(2, L, active),
	    (   M==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', N),
		O=[L|N],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', O),
		(   N=[P|_]
		->  setarg(4, P, O)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', Q),
		insert_ht(Q, k(C, E), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', R),
		insert_ht(R, F, L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', S),
		insert_ht(S, k(C, F), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', T),
		insert_ht(T, k(F, U), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', V),
		insert_ht(V, C, L)
	    ;   true
	    ),
	    W is E+1,
	    allocation_occurrence(C, W),
	    (   L=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, L, inactive),
		'occurrence/5__2__0'(X, C, E, F, U, Y, L)
	    ;   true
	    )
	;   'occurrence/5__2__0'(X, C, E, F, U, Y, L)
	).
'occurrence/5__2'(A, B, C, D, E, F) :-
	'occurrence/5__3'(A, B, C, D, E, F).
'occurrence/5__3'(C, D, A, E, F, G) :-
	'$via1_multi_hash_rule/2-1'(A, B), !,
	'occurrence/5__3__0'(B, C, D, A, E, F, G).
'occurrence/5__3__0'([], A, B, C, D, E, F) :-
	'occurrence/5__4'(A, B, C, D, E, F).
'occurrence/5__3__0'([A|H], D, E, C, I, J, K) :-
	(   A=suspension(_, active, _, _, B, G),
	    B==C,
	    '$via1_multi_hash_allocation_occurrence/2-12'(k(D, E), F)
	->  'occurrence/5__3__1'(F, G, A, H, D, E, C, I, J, K)
	;   'occurrence/5__3__0'(H, D, E, C, I, J, K)
	).
'occurrence/5__3__1'([], _, _, A, B, C, D, E, F, G) :-
	'occurrence/5__3__0'(A, B, C, D, E, F, G).
'occurrence/5__3__1'([A|Y], J, Z, A1, C, E, F, V, B1, M) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    ground(F),
	    '$via1_multi_hash_least_occurrence/2-1'(F, G),
	    'chr sbag_member'(H, G),
	    H=suspension(_, active, _, I),
	    I=[],
	    J=pragma(rule([], _, _, _), _, _, _, _),
	    \+is_observed(C, E)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', K),
	    delete_ht(K, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', L),
	    delete_ht(L, k(C, E), A),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', O),
		P=[M|O],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', P),
		(   O=[Q|_]
		->  setarg(4, Q, P)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', R),
		insert_ht(R, k(C, E), M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', S),
		insert_ht(S, F, M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', T),
		insert_ht(T, k(C, F), M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', U),
		insert_ht(U, k(F, V), M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', W),
		insert_ht(W, C, M)
	    ;   true
	    ),
	    X is E+1,
	    allocation_occurrence(C, X),
	    (   M=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, M, inactive),
		'occurrence/5__3__1'(Y, J, Z, A1, C, E, F, V, B1, M)
	    ;   true
	    )
	;   'occurrence/5__3__1'(Y, J, Z, A1, C, E, F, V, B1, M)
	).
'occurrence/5__3'(A, B, C, D, E, F) :-
	'occurrence/5__4'(A, B, C, D, E, F).
'occurrence/5__4'(C, D, A, E, F, G) :-
	'$via1_multi_hash_rule/2-1'(A, B), !,
	'occurrence/5__4__0'(B, C, D, A, E, F, G).
'occurrence/5__4__0'([], A, B, C, D, E, F) :-
	'occurrence/5__5'(A, B, C, D, E, F).
'occurrence/5__4__0'([A|E], F, G, C, H, I, J) :-
	(   A=suspension(_, active, _, _, B, _),
	    B==C,
	    '$via1_multi_hash_least_occurrence/2-1'(C, D)
	->  'occurrence/5__4__1'(D, A, E, F, G, C, H, I, J)
	;   'occurrence/5__4__0'(E, F, G, C, H, I, J)
	).
'occurrence/5__4__1'([], _, A, B, C, D, E, F, G) :-
	'occurrence/5__4__0'(A, B, C, D, E, F, G).
'occurrence/5__4__1'([A|X], Y, Z, G, K, C, F, A1, M) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[E|W],
	    E==F,
	    ground(G),
	    '$via1_multi_hash_allocation_occurrence/2-1'(G, H),
	    'chr sbag_member'(I, H),
	    I=suspension(_, active, _, J),
	    J>=K,
	    \+may_trigger(G)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', L),
	    delete_ht(L, C, A),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', O),
		P=[M|O],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', P),
		(   O=[Q|_]
		->  setarg(4, Q, P)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', R),
		insert_ht(R, k(G, K), M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', S),
		insert_ht(S, C, M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', T),
		insert_ht(T, k(G, C), M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', U),
		insert_ht(U, k(C, F), M),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', V),
		insert_ht(V, G, M)
	    ;   true
	    ),
	    least_occurrence(C, W),
	    (   M=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, M, inactive),
		'occurrence/5__4__1'(X, Y, Z, G, K, C, F, A1, M)
	    ;   true
	    )
	;   'occurrence/5__4__1'(X, Y, Z, G, K, C, F, A1, M)
	).
'occurrence/5__4'(A, B, C, D, E, F) :-
	'occurrence/5__5'(A, B, C, D, E, F).
'occurrence/5__5'(C, D, A, E, F, G) :-
	'$via1_multi_hash_set_all_passive/1-1'(A, B), !,
	'occurrence/5__5__0'(B, C, D, A, E, F, G).
'occurrence/5__5__0'([], A, B, C, D, E, F) :-
	'occurrence/5__6'(A, B, C, D, E, F).
'occurrence/5__5__0'([A|R], K, L, C, P, S, D) :-
	(   A=suspension(_, active, _, B),
	    B==C,
	    E=t(131, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', G),
		H=[D|G],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', H),
		(   G=[I|_]
		->  setarg(4, I, H)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', J),
		insert_ht(J, k(K, L), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', M),
		insert_ht(M, C, D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', N),
		insert_ht(N, k(K, C), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', O),
		insert_ht(O, k(C, P), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', Q),
		insert_ht(Q, K, D)
	    ;   true
	    ),
	    passive(C, P),
	    (   D=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'occurrence/5__5__0'(R, K, L, C, P, S, D)
	    ;   true
	    )
	;   'occurrence/5__5__0'(R, K, L, C, P, S, D)
	).
'occurrence/5__5'(A, B, C, D, E, F) :-
	'occurrence/5__6'(A, B, C, D, E, F).
'occurrence/5__6'(B, C, D, E, F, G) :-
	nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', A), !,
	'occurrence/5__6__0'(A, B, C, D, E, F, G).
'occurrence/5__6__0'([], A, B, C, D, E, F) :-
	'occurrence/5__7'(A, B, C, D, E, F).
'occurrence/5__6__0'([A|E1], E, H, B, C1, F1, T) :-
	(   A=suspension(_, active, _, O),
	    ground(B),
	    '$via1_multi_hash_rule/2-1'(B, C),
	    'chr sbag_member'(D, C),
	    D=suspension(_, active, _, _, _, M),
	    ground(E),
	    ground(B),
	    '$via1_multi_hash_occurrence/5-13'(k(E, B), F),
	    'chr sbag_member'(G, F),
	    G=suspension(_, active, _, _, _, I, _, _, _),
	    H<I,
	    ground(B),
	    '$via1_multi_hash_prev_guard_list/7-1'(B, J),
	    'chr sbag_member'(K, J),
	    K=suspension(_, active, _, _, L, _, _, _, _, _),
	    L=0,
	    chr_pp_flag(occurrence_subsumption, on),
	    M=pragma(rule(N, _, _, _), _, _, _, B),
	    N\==[],
	    \+memberchk_eq(E, O)
	->  setarg(2, A, removed),
	    arg(3, A, P),
	    (   var(P)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', Q),
		Q=[_|R],
		b_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', R),
		(   R=[S|_]
		->  setarg(3, S, _)
		;   true
		)
	    ;   P=[_, _|R],
		setarg(2, P, R),
		(   R=[S|_]
		->  setarg(3, S, P)
		;   true
		)
	    ),
	    arg(2, T, U),
	    setarg(2, T, active),
	    (   U==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', V),
		W=[T|V],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', W),
		(   V=[X|_]
		->  setarg(4, X, W)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', Y),
		insert_ht(Y, k(E, H), T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', Z),
		insert_ht(Z, B, T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', A1),
		insert_ht(A1, k(E, B), T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', B1),
		insert_ht(B1, k(B, C1), T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', D1),
		insert_ht(D1, E, T)
	    ;   true
	    ),
	    first_occ_in_rule(B, E, H, C1),
	    multiple_occ_constraints_checked([E|O]),
	    (   T=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, T, inactive),
		'occurrence/5__6__0'(E1, E, H, B, C1, F1, T)
	    ;   true
	    )
	;   'occurrence/5__6__0'(E1, E, H, B, C1, F1, T)
	).
'occurrence/5__6'(A, B, C, D, E, F) :-
	'occurrence/5__7'(A, B, C, D, E, F).
'occurrence/5__7'(B, C, D, E, F, G) :-
	nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', A), !,
	'occurrence/5__7__0'(A, B, C, D, E, F, G).
'occurrence/5__7__0'([], A, B, C, D, E, F) :-
	'occurrence/5__8'(A, B, C, D, E, F).
'occurrence/5__7__0'([A|F1], E, I, B, C1, G1, T) :-
	(   A=suspension(_, active, _, O),
	    ground(B),
	    '$via1_multi_hash_rule/2-1'(B, C),
	    'chr sbag_member'(D, C),
	    D=suspension(_, active, _, _, _, M),
	    ground(E),
	    ground(B),
	    '$via1_multi_hash_occurrence/5-13'(k(E, B), F),
	    'chr sbag_member'(G, F),
	    G=suspension(_, active, _, _, _, H, _, E1, _),
	    H<I,
	    ground(B),
	    '$via1_multi_hash_prev_guard_list/7-1'(B, J),
	    'chr sbag_member'(K, J),
	    K=suspension(_, active, _, _, L, _, _, _, _, _),
	    L=0,
	    chr_pp_flag(occurrence_subsumption, on),
	    M=pragma(rule(N, _, _, _), _, _, _, B),
	    N\==[],
	    \+memberchk_eq(E, O)
	->  setarg(2, A, removed),
	    arg(3, A, P),
	    (   var(P)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', Q),
		Q=[_|R],
		b_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', R),
		(   R=[S|_]
		->  setarg(3, S, _)
		;   true
		)
	    ;   P=[_, _|R],
		setarg(2, P, R),
		(   R=[S|_]
		->  setarg(3, S, P)
		;   true
		)
	    ),
	    arg(2, T, U),
	    setarg(2, T, active),
	    (   U==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', V),
		W=[T|V],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', W),
		(   V=[X|_]
		->  setarg(4, X, W)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', Y),
		insert_ht(Y, k(E, I), T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', Z),
		insert_ht(Z, B, T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', A1),
		insert_ht(A1, k(E, B), T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', B1),
		insert_ht(B1, k(B, C1), T),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', D1),
		insert_ht(D1, E, T)
	    ;   true
	    ),
	    first_occ_in_rule(B, E, H, E1),
	    multiple_occ_constraints_checked([E|O]),
	    (   T=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, T, inactive),
		'occurrence/5__7__0'(F1, E, I, B, C1, G1, T)
	    ;   true
	    )
	;   'occurrence/5__7__0'(F1, E, I, B, C1, G1, T)
	).
'occurrence/5__7'(A, B, C, D, E, F) :-
	'occurrence/5__8'(A, B, C, D, E, F).
'occurrence/5__8'(A, C, D, E, F, G) :-
	'$via1_multi_hash_stored_complete/3-1'(A, B), !,
	'occurrence/5__8__0'(B, A, C, D, E, F, G).
'occurrence/5__8__0'([], A, B, C, D, E, F) :-
	'occurrence/5__9'(A, B, C, D, E, F).
'occurrence/5__8__0'([A|B1], C, D, I, J, C1, P) :-
	(   A=suspension(_, active, _, B, E, Z),
	    B==C,
	    D<E,
	    ground(C),
	    ground(D),
	    '$via1_multi_hash_stored/3-12'(k(C, D), F),
	    'chr sbag_member'(G, F),
	    G=suspension(_, active, _, _, H),
	    H=yes,
	    ground(I),
	    ground(J),
	    '$via1_multi_hash_passive/2-12'(k(I, J), K),
	    'chr sbag_member'(L, K),
	    L=suspension(_, active, _, _, _)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', M),
	    delete_ht(M, C, A),
	    setarg(2, G, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', N),
	    delete_ht(N, C, G),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', O),
	    delete_ht(O, k(C, D), G),
	    arg(2, P, Q),
	    setarg(2, P, active),
	    (   Q==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', R),
		S=[P|R],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', S),
		(   R=[T|_]
		->  setarg(4, T, S)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', U),
		insert_ht(U, k(C, D), P),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', V),
		insert_ht(V, I, P),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', W),
		insert_ht(W, k(C, I), P),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', X),
		insert_ht(X, k(I, J), P),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', Y),
		insert_ht(Y, C, P)
	    ;   true
	    ),
	    A1 is Z-1,
	    stored(C, D, maybe),
	    stored_complete(C, E, A1),
	    (   P=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, P, inactive),
		'occurrence/5__8__0'(B1, C, D, I, J, C1, P)
	    ;   true
	    )
	;   'occurrence/5__8__0'(B1, C, D, I, J, C1, P)
	).
'occurrence/5__8'(A, B, C, D, E, F) :-
	'occurrence/5__9'(A, B, C, D, E, F).
'occurrence/5__9'(C, D, A, E, F, G) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'occurrence/5__9__0'(B, C, D, A, E, F, G).
'occurrence/5__9__0'([], A, B, C, D, E, F) :-
	'occurrence/5__10'(A, B, C, D, E, F).
'occurrence/5__9__0'([A|F], G, H, C, I, J, K) :-
	(   A=suspension(_, active, _, _, D, _, B, _, _),
	    B==C,
	    '$via1_multi_hash_stored_complete/3-1'(D, E)
	->  'occurrence/5__9__1'(E, D, A, F, G, H, C, I, J, K)
	;   'occurrence/5__9__0'(F, G, H, C, I, J, K)
	).
'occurrence/5__9__1'([], _, _, A, B, C, D, E, F, G) :-
	'occurrence/5__9__0'(A, B, C, D, E, F, G).
'occurrence/5__9__1'([A|G], C, H, I, J, K, L, M, N, O) :-
	(   A=suspension(_, active, _, B, F, D),
	    B==C,
	    D=0,
	    '$via1_multi_hash_max_occurrence/2-1'(C, E)
	->  'occurrence/5__9__2'(E, F, A, G, C, H, I, J, K, L, M, N, O)
	;   'occurrence/5__9__1'(G, C, H, I, J, K, L, M, N, O)
	).
'occurrence/5__9__2'([], _, _, A, B, C, D, E, F, G, H, I, J) :-
	'occurrence/5__9__1'(A, B, C, D, E, F, G, H, I, J).
'occurrence/5__9__2'([A|W], H, F, X, C, E, Y, O, P, R, U, Z, D) :-
	(   A=suspension(_, active, _, B, I),
	    B==C,
	    G=t(195, D, E, F, A),
	    '$novel_production'(D, G),
	    '$novel_production'(E, G),
	    '$novel_production'(F, G),
	    '$novel_production'(A, G),
	    H=<I
	->  '$extend_history'(D, G),
	    arg(2, D, J),
	    setarg(2, D, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', K),
		L=[D|K],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', L),
		(   K=[M|_]
		->  setarg(4, M, L)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', N),
		insert_ht(N, k(O, P), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', Q),
		insert_ht(Q, R, D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', S),
		insert_ht(S, k(O, R), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', T),
		insert_ht(T, k(R, U), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', V),
		insert_ht(V, O, D)
	    ;   true
	    ),
	    passive(R, U),
	    (   D=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'occurrence/5__9__2'(W, H, F, X, C, E, Y, O, P, R, U, Z, D)
	    ;   true
	    )
	;   'occurrence/5__9__2'(W, H, F, X, C, E, Y, O, P, R, U, Z, D)
	).
'occurrence/5__9'(A, B, C, D, E, F) :-
	'occurrence/5__10'(A, B, C, D, E, F).
'occurrence/5__10'(C, D, A, E, F, G) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'occurrence/5__10__0'(B, C, D, A, E, F, G).
'occurrence/5__10__0'([], A, B, C, D, E, F) :-
	'occurrence/5__11'(A, B, C, D, E, F).
'occurrence/5__10__0'([A|G], D, H, C, I, J, K) :-
	(   A=suspension(_, active, _, _, _, _, B, F, _),
	    B==C,
	    '$via1_multi_hash_max_occurrence/2-1'(D, E)
	->  'occurrence/5__10__1'(E, F, A, G, D, H, C, I, J, K)
	;   'occurrence/5__10__0'(G, D, H, C, I, J, K)
	).
'occurrence/5__10__1'([], _, _, A, B, C, D, E, F, G) :-
	'occurrence/5__10__0'(A, B, C, D, E, F, G).
'occurrence/5__10__1'([A|F], G, H, I, C, J, K, L, M, N) :-
	(   A=suspension(_, active, _, B, E),
	    B==C,
	    '$via1_multi_hash_stored_complete/3-1'(C, D)
	->  'occurrence/5__10__2'(D, E, A, F, G, H, I, C, J, K, L, M, N)
	;   'occurrence/5__10__1'(F, G, H, I, C, J, K, L, M, N)
	).
'occurrence/5__10__2'([], _, _, A, B, C, D, E, F, G, H, I, J) :-
	'occurrence/5__10__1'(A, B, C, D, E, F, G, H, I, J).
'occurrence/5__10__2'([A|X], J, G, Y, W, E, Z, C, P, R, U, A1, F) :-
	(   A=suspension(_, active, _, B, I, D),
	    B==C,
	    D=0,
	    H=t(195, E, F, A, G),
	    '$novel_production'(E, H),
	    '$novel_production'(F, H),
	    '$novel_production'(A, H),
	    '$novel_production'(G, H),
	    I=<J
	->  '$extend_history'(F, H),
	    arg(2, F, K),
	    setarg(2, F, active),
	    (   K==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', L),
		M=[F|L],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', M),
		(   L=[N|_]
		->  setarg(4, N, M)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', O),
		insert_ht(O, k(C, P), F),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', Q),
		insert_ht(Q, R, F),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', S),
		insert_ht(S, k(C, R), F),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', T),
		insert_ht(T, k(R, U), F),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', V),
		insert_ht(V, C, F)
	    ;   true
	    ),
	    passive(R, W),
	    (   F=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, F, inactive),
		'occurrence/5__10__2'(X, J, G, Y, W, E, Z, C, P, R, U, A1, F)
	    ;   true
	    )
	;   'occurrence/5__10__2'(X, J, G, Y, W, E, Z, C, P, R, U, A1, F)
	).
'occurrence/5__10'(A, B, C, D, E, F) :-
	'occurrence/5__11'(A, B, C, D, E, F).
'occurrence/5__11'(A, C, D, E, F, G) :-
	'$via1_multi_hash_stored_complete/3-1'(A, B), !,
	'occurrence/5__11__0'(B, A, C, D, E, F, G).
'occurrence/5__11__0'([], A, B, C, D, E, F) :-
	'occurrence/5__12'(A, B, C, D, E, F).
'occurrence/5__11__0'([A|S], C, F, N, Q, T, D) :-
	(   A=suspension(_, active, _, B, G, _),
	    B==C,
	    E=t(204, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E),
	    F>G
	->  '$extend_history'(D, E),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', I),
		J=[D|I],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', L),
		insert_ht(L, k(C, F), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', M),
		insert_ht(M, N, D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', O),
		insert_ht(O, k(C, N), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', P),
		insert_ht(P, k(N, Q), D),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', R),
		insert_ht(R, C, D)
	    ;   true
	    ),
	    passive(N, Q),
	    (   D=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'occurrence/5__11__0'(S, C, F, N, Q, T, D)
	    ;   true
	    )
	;   'occurrence/5__11__0'(S, C, F, N, Q, T, D)
	).
'occurrence/5__11'(A, B, C, D, E, F) :-
	'occurrence/5__12'(A, B, C, D, E, F).
'occurrence/5__12'(A, D, B, E, F, G) :-
	'$via1_multi_hash_functional_dependency/4-12'(k(A, B), C), !,
	'occurrence/5__12__0'(C, A, D, B, E, F, G).
'occurrence/5__12__0'([], A, B, C, D, E, F) :-
	'occurrence/5__13'(A, B, C, D, E, F).
'occurrence/5__12__0'([A|Y], C, I, E, U, Z, L) :-
	(   A=suspension(_, active, B, D, W, X),
	    B==C,
	    D==E,
	    E>1,
	    ground(C),
	    '$via1_multi_hash_allocation_occurrence/2-1'(C, F),
	    'chr sbag_member'(G, F),
	    G=suspension(_, active, _, H),
	    H>I
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-12', K),
	    delete_ht(K, k(C, E), A),
	    arg(2, L, M),
	    setarg(2, L, active),
	    (   M==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', N),
		O=[L|N],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', O),
		(   N=[P|_]
		->  setarg(4, P, O)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', Q),
		insert_ht(Q, k(C, I), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', R),
		insert_ht(R, E, L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', S),
		insert_ht(S, k(C, E), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', T),
		insert_ht(T, k(E, U), L),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', V),
		insert_ht(V, C, L)
	    ;   true
	    ),
	    functional_dependency(C, 1, W, X),
	    (   L=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, L, inactive),
		'occurrence/5__12__0'(Y, C, I, E, U, Z, L)
	    ;   true
	    )
	;   'occurrence/5__12__0'(Y, C, I, E, U, Z, L)
	).
'occurrence/5__12'(A, B, C, D, E, F) :-
	'occurrence/5__13'(A, B, C, D, E, F).
'occurrence/5__13'(A, C, D, E, F, G) :-
	'$via1_multi_hash_constraint_mode/2-1'(A, B), !,
	'occurrence/5__13__0'(B, A, C, D, E, F, G).
'occurrence/5__13__0'([], A, B, C, D, E, F) :-
	'occurrence/5__14'(A, B, C, D, E, F).
'occurrence/5__13__0'([A|F], C, G, H, I, J, K) :-
	(   A=suspension(_, active, _, _, B, E),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', D)
	->  'occurrence/5__13__1'(D, E, A, F, C, G, H, I, J, K)
	;   'occurrence/5__13__0'(F, C, G, H, I, J, K)
	).
'occurrence/5__13__1'([], _, _, A, B, C, D, E, F, G) :-
	'occurrence/5__13__0'(A, B, C, D, E, F, G).
'occurrence/5__13__1'([A|D], E, F, G, H, I, B, J, K, L) :-
	(   A=suspension(_, active, _, _),
	    '$via1_multi_hash_rule/2-1'(B, C)
	->  'occurrence/5__13__2'(C, A, D, E, F, G, H, I, B, J, K, L)
	;   'occurrence/5__13__1'(D, E, F, G, H, I, B, J, K, L)
	).
'occurrence/5__13__2'([], _, A, B, C, D, E, F, G, H, I, J) :-
	'occurrence/5__13__1'(A, B, C, D, E, F, G, H, I, J).
'occurrence/5__13__2'([A|C1], D, D1, Z, F, E1, M, N, C, R, U, E) :-
	(   A=suspension(_, active, _, _, B, T),
	    B==C,
	    G=t(273, D, E, A, F),
	    '$novel_production'(D, G),
	    '$novel_production'(E, G),
	    '$novel_production'(A, G),
	    '$novel_production'(F, G)
	->  '$extend_history'(E, G),
	    arg(2, E, H),
	    setarg(2, E, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', I),
		J=[E|I],
		b_setval('$chr_store_global_ground_chr_translate:occurrence/5', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', L),
		insert_ht(L, k(M, N), E),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', O),
		insert_ht(O, C, E),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', P),
		insert_ht(P, k(M, C), E),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', Q),
		insert_ht(Q, k(C, R), E),
		nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', S),
		insert_ht(S, M, E)
	    ;   true
	    ),
	    T=pragma(rule(V, B1, X, _), _, _, _, _),
	    (   is_passive(C, R)
	    ->  true
	    ;   U==simplification
	    ->  select(W, V, _),
		W=..[_|Y],
		term_variables(X, A1),
		partial_wake_args(Y, Z, A1, M)
	    ;   select(W, B1, _),
		W=..[_|Y],
		term_variables(X, A1),
		partial_wake_args(Y, Z, A1, M)
	    ),
	    (   E=suspension(_, active, _, _, _, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'occurrence/5__13__2'(C1, D, D1, Z, F, E1, M, N, C, R, U, E)
	    ;   true
	    )
	;   'occurrence/5__13__2'(C1, D, D1, Z, F, E1, M, N, C, R, U, E)
	).
'occurrence/5__13'(A, B, C, D, E, F) :-
	'occurrence/5__14'(A, B, C, D, E, F).
'occurrence/5__14'(G, H, J, M, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:occurrence/5', D),
	    (   C=[E|_]
	    ->  setarg(4, E, D)
	    ;   true
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-12', F),
	    insert_ht(F, k(G, H), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-3', I),
	    insert_ht(I, J, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-13', K),
	    insert_ht(K, k(G, J), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-34', L),
	    insert_ht(L, k(J, M), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:occurrence/5-1', N),
	    insert_ht(N, G, A)
	;   true
	).
get_occurrence(A, B, F, H) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, G, _), !,
	E=F,
	G=H.
get_occurrence(A, B, _, _) :-
	chr_error(internal, 'get_occurrence: missing occurrence ~w:~w\n', [A, B]).
get_occurrence_from_id(E, G, A, B) :-
	'$via1_multi_hash_occurrence/5-34'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, F, H, _, _, _), !,
	E=F,
	G=H.
get_occurrence_from_id(_, _, _, _) :-
	chr_error(internal, 'get_occurrence_from_id: missing occurrence ~w:~w\n', []).
max_occurrence(A, B) :-
	'max_occurrence/2__0'(A, B, _).
'max_occurrence/2__0'(A, E, _) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, D),
	D>=E, !.
'max_occurrence/2__0'(A, C, D) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B), !,
	'max_occurrence/2__0__0'(B, A, C, D).
'max_occurrence/2__0__0'([], A, B, C) :-
	'max_occurrence/2__1'(A, B, C).
'max_occurrence/2__0__0'([A|G], C, D, H) :-
	(   A=suspension(_, active, _, B, E),
	    B==C,
	    D>=E
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', F),
	    delete_ht(F, C, A),
	    'max_occurrence/2__0__0'(G, C, D, H)
	;   'max_occurrence/2__0__0'(G, C, D, H)
	).
'max_occurrence/2__0'(A, B, C) :-
	'max_occurrence/2__1'(A, B, C).
'max_occurrence/2__1'(A, C, B) :-
	'$via1_multi_hash_stored_complete/3-1'(A, E), !,
	B=suspension(D, not_stored_yet, t, A, C),
	'chr gen_id'(D),
	'max_occurrence/2__1__0'(E, A, C, B).
'max_occurrence/2__1__0'([], A, B, C) :-
	'max_occurrence/2__2'(A, B, C).
'max_occurrence/2__1__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, B, F, D),
	    B==C,
	    D=0,
	    '$via1_multi_hash_occurrence/5-1'(C, E)
	->  'max_occurrence/2__1__1'(E, F, A, G, C, H, I)
	;   'max_occurrence/2__1__0'(G, C, H, I)
	).
'max_occurrence/2__1__1'([], _, _, A, B, C, D) :-
	'max_occurrence/2__1__0'(A, B, C, D).
'max_occurrence/2__1__1'([A|F], G, H, I, C, J, K) :-
	(   A=suspension(_, active, _, _, B, _, D, _, _),
	    B==C,
	    '$via1_multi_hash_occurrence/5-3'(D, E)
	->  'max_occurrence/2__1__2'(E, D, A, F, G, H, I, C, J, K)
	;   'max_occurrence/2__1__1'(F, G, H, I, C, J, K)
	).
'max_occurrence/2__1__2'([], _, _, A, B, C, D, E, F, G) :-
	'max_occurrence/2__1__1'(A, B, C, D, E, F, G).
'max_occurrence/2__1__2'([A|N], D, B, O, H, E, P, L, I, F) :-
	(   A=suspension(_, active, _, _, _, _, C, M, _),
	    A\==B,
	    C==D,
	    G=t(195, A, B, E, F),
	    '$novel_production'(A, G),
	    '$novel_production'(B, G),
	    '$novel_production'(E, G),
	    '$novel_production'(F, G),
	    H=<I
	->  '$extend_history'(F, G),
	    arg(2, F, J),
	    setarg(2, F, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', K),
		insert_ht(K, L, F)
	    ;   true
	    ),
	    passive(D, M),
	    (   F=suspension(_, active, _, _, _)
	    ->  setarg(2, F, inactive),
		'max_occurrence/2__1__2'(N, D, B, O, H, E, P, L, I, F)
	    ;   true
	    )
	;   'max_occurrence/2__1__2'(N, D, B, O, H, E, P, L, I, F)
	).
'max_occurrence/2__1'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, B, C),
	'chr gen_id'(D),
	'max_occurrence/2__2'(B, C, A).
'max_occurrence/2__2'(D, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:max_occurrence/2-1', C),
	    insert_ht(C, D, A)
	;   true
	).
get_max_occurrence(A, D) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, E), !,
	D=E.
get_max_occurrence(A, _) :-
	chr_error(internal, 'get_max_occurrence: missing max occurrence for ~w\n', [A]).
allocation_occurrence(A, B) :-
	'allocation_occurrence/2__0'(A, B, _).
'allocation_occurrence/2__0'(A, B, _) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, F, _),
	'$via1_multi_hash_passive/2-12'(k(E, F), G),
	'chr sbag_member'(H, G),
	H=suspension(_, active, _, _, _), !,
	I is B+1,
	allocation_occurrence(A, I).
'allocation_occurrence/2__0'(A, B, _) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, I, _),
	'$via1_multi_hash_rule/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, H),
	\+is_stored_in_guard(A, E),
	H=pragma(_, ids(J, _), _, _, _),
	member(I, J), !,
	K is B+1,
	allocation_occurrence(A, K).
'allocation_occurrence/2__0'(A, B, _) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, _, _),
	'$via1_multi_hash_rule/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, H),
	H=pragma(rule([_|_], _, _, _), _, _, _, _),
	\+is_observed(A, B), !,
	I is B+1,
	allocation_occurrence(A, I).
'allocation_occurrence/2__0'(A, B, _) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, _, _),
	'$via1_multi_hash_rule/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, K),
	'$via1_multi_hash_least_occurrence/2-1'(E, H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, J),
	J=[],
	K=pragma(rule([], _, _, _), _, _, _, _),
	\+is_observed(A, B), !,
	L is B+1,
	allocation_occurrence(A, L).
'allocation_occurrence/2__0'(A, C, B) :-
	'$via1_multi_hash_occurrence/5-1'(A, E), !,
	B=suspension(D, not_stored_yet, A, C),
	'chr gen_id'(D),
	'allocation_occurrence/2__0__0'(E, A, C, B).
'allocation_occurrence/2__0__0'([], A, B, C) :-
	'allocation_occurrence/2__1'(A, B, C).
'allocation_occurrence/2__0__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, _, B, F, D, G, _),
	    B==C,
	    '$via1_multi_hash_least_occurrence/2-1'(D, E)
	->  'allocation_occurrence/2__0__1'(E, F, D, G, A, H, C, I, J)
	;   'allocation_occurrence/2__0__0'(H, C, I, J)
	).
'allocation_occurrence/2__0__1'([], _, _, _, _, A, B, C, D) :-
	'allocation_occurrence/2__0__0'(A, B, C, D).
'allocation_occurrence/2__0__1'([A|R], H, C, F, S, T, K, G, M) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[E|Q],
	    E==F,
	    G>=H,
	    ground(C),
	    '$via1_multi_hash_rule/2-1'(C, I),
	    'chr sbag_member'(J, I),
	    J=suspension(_, active, _, _, _, _),
	    \+may_trigger(K)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', L),
	    delete_ht(L, C, A),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', O),
		insert_ht(O, K, M),
		nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', P),
		insert_ht(P, k(K, G), M)
	    ;   true
	    ),
	    least_occurrence(C, Q),
	    (   M=suspension(_, active, _, _)
	    ->  setarg(2, M, inactive),
		'allocation_occurrence/2__0__1'(R, H, C, F, S, T, K, G, M)
	    ;   true
	    )
	;   'allocation_occurrence/2__0__1'(R, H, C, F, S, T, K, G, M)
	).
'allocation_occurrence/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, B, C),
	'chr gen_id'(D),
	'allocation_occurrence/2__1'(B, C, A).
'allocation_occurrence/2__1'(A, C, D) :-
	'$via1_multi_hash_functional_dependency/4-1'(A, B), !,
	'allocation_occurrence/2__1__0'(B, A, C, D).
'allocation_occurrence/2__1__0'([], A, B, C) :-
	'allocation_occurrence/2__2'(A, B, C).
'allocation_occurrence/2__1__0'([A|Q], C, G, K) :-
	(   A=suspension(_, active, B, D, O, P),
	    B==C,
	    D>1,
	    ground(C),
	    ground(D),
	    '$via1_multi_hash_occurrence/5-13'(k(C, D), E),
	    'chr sbag_member'(F, E),
	    F=suspension(_, active, _, _, _, H, _, _, _),
	    G>H
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-1', I),
	    delete_ht(I, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-12', J),
	    delete_ht(J, k(C, D), A),
	    arg(2, K, L),
	    setarg(2, K, active),
	    (   L==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', M),
		insert_ht(M, C, K),
		nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', N),
		insert_ht(N, k(C, G), K)
	    ;   true
	    ),
	    functional_dependency(C, 1, O, P),
	    (   K=suspension(_, active, _, _)
	    ->  setarg(2, K, inactive),
		'allocation_occurrence/2__1__0'(Q, C, G, K)
	    ;   true
	    )
	;   'allocation_occurrence/2__1__0'(Q, C, G, K)
	).
'allocation_occurrence/2__1'(A, B, C) :-
	'allocation_occurrence/2__2'(A, B, C).
'allocation_occurrence/2__2'(D, F, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', E),
	    insert_ht(E, k(D, F), A)
	;   true
	).
get_allocation_occurrence(A, D) :-
	'$via1_multi_hash_allocation_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_allocation_occurrence(_, A) :-
	chr_pp_flag(late_allocation, off),
	A=0.
rule(A, B) :-
	'rule/2__0'(A, B, _).
'rule/2__0'(A, C, B) :-
	'$via1_multi_hash_occurrence/5-3'(A, E), !,
	B=suspension(D, not_stored_yet, t, _, A, C),
	'chr gen_id'(D),
	'rule/2__0__0'(E, A, C, B).
'rule/2__0__0'([], A, B, C) :-
	'rule/2__1'(A, B, C).
'rule/2__0__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, _, D, E, B, G, _),
	    B==C,
	    '$via1_multi_hash_allocation_occurrence/2-12'(k(D, E), F)
	->  'rule/2__0__1'(F, D, E, G, A, H, C, I, J)
	;   'rule/2__0__0'(H, C, I, J)
	).
'rule/2__0__1'([], _, _, _, _, A, B, C, D) :-
	'rule/2__0__0'(A, B, C, D).
'rule/2__0__1'([A|S], C, E, H, T, U, F, G, L) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    \+is_stored_in_guard(C, F),
	    G=pragma(_, ids(I, _), _, _, _),
	    member(H, I)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', K),
	    delete_ht(K, k(C, E), A),
	    arg(2, L, M),
	    setarg(2, L, active),
	    (   M==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', N),
		O=[L|N],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', O),
		(   N=[P|_]
		->  setarg(4, P, O)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', Q),
		insert_ht(Q, F, L)
	    ;   true
	    ),
	    R is E+1,
	    allocation_occurrence(C, R),
	    (   L=suspension(_, active, _, _, _, _)
	    ->  setarg(2, L, inactive),
		'rule/2__0__1'(S, C, E, H, T, U, F, G, L)
	    ;   true
	    )
	;   'rule/2__0__1'(S, C, E, H, T, U, F, G, L)
	).
'rule/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, _, B, C),
	'chr gen_id'(D),
	'rule/2__1'(B, C, A).
'rule/2__1'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'rule/2__1__0'(B, A, C, D).
'rule/2__1__0'([], A, B, C) :-
	'rule/2__2'(A, B, C).
'rule/2__1__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, _, D, E, B, _, _),
	    B==C,
	    '$via1_multi_hash_allocation_occurrence/2-12'(k(D, E), F)
	->  'rule/2__1__1'(F, D, E, A, G, C, H, I)
	;   'rule/2__1__0'(G, C, H, I)
	).
'rule/2__1__1'([], _, _, _, A, B, C, D) :-
	'rule/2__1__0'(A, B, C, D).
'rule/2__1__1'([A|Q], C, E, R, S, O, F, I) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    F=pragma(rule([_|_], _, _, _), _, _, _, _),
	    \+is_observed(C, E)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', G),
	    delete_ht(G, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', H),
	    delete_ht(H, k(C, E), A),
	    arg(2, I, J),
	    setarg(2, I, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', K),
		L=[I|K],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', L),
		(   K=[M|_]
		->  setarg(4, M, L)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', N),
		insert_ht(N, O, I)
	    ;   true
	    ),
	    P is E+1,
	    allocation_occurrence(C, P),
	    (   I=suspension(_, active, _, _, _, _)
	    ->  setarg(2, I, inactive),
		'rule/2__1__1'(Q, C, E, R, S, O, F, I)
	    ;   true
	    )
	;   'rule/2__1__1'(Q, C, E, R, S, O, F, I)
	).
'rule/2__1'(A, B, C) :-
	'rule/2__2'(A, B, C).
'rule/2__2'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'rule/2__2__0'(B, A, C, D).
'rule/2__2__0'([], A, B, C) :-
	'rule/2__3'(A, B, C).
'rule/2__2__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, _, E, F, B, _, _),
	    B==C,
	    '$via1_multi_hash_least_occurrence/2-1'(C, D)
	->  'rule/2__2__1'(D, E, F, A, G, C, H, I)
	;   'rule/2__2__0'(G, C, H, I)
	).
'rule/2__2__1'([], _, _, _, A, B, C, D) :-
	'rule/2__2__0'(A, B, C, D).
'rule/2__2__1'([A|H], E, F, I, J, C, K, L) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[],
	    '$via1_multi_hash_allocation_occurrence/2-12'(k(E, F), G)
	->  'rule/2__2__2'(G, A, H, E, F, I, J, C, K, L)
	;   'rule/2__2__1'(H, E, F, I, J, C, K, L)
	).
'rule/2__2__2'([], _, A, B, C, D, E, F, G, H) :-
	'rule/2__2__1'(A, B, C, D, E, F, G, H).
'rule/2__2__2'([A|Q], R, S, C, E, T, U, O, F, I) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    F=pragma(rule([], _, _, _), _, _, _, _),
	    \+is_observed(C, E)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', G),
	    delete_ht(G, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', H),
	    delete_ht(H, k(C, E), A),
	    arg(2, I, J),
	    setarg(2, I, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', K),
		L=[I|K],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', L),
		(   K=[M|_]
		->  setarg(4, M, L)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', N),
		insert_ht(N, O, I)
	    ;   true
	    ),
	    P is E+1,
	    allocation_occurrence(C, P),
	    (   I=suspension(_, active, _, _, _, _)
	    ->  setarg(2, I, inactive),
		'rule/2__2__2'(Q, R, S, C, E, T, U, O, F, I)
	    ;   true
	    )
	;   'rule/2__2__2'(Q, R, S, C, E, T, U, O, F, I)
	).
'rule/2__2'(A, B, C) :-
	'rule/2__3'(A, B, C).
'rule/2__3'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'rule/2__3__0'(B, A, C, D).
'rule/2__3__0'([], A, B, C) :-
	'rule/2__4'(A, B, C).
'rule/2__3__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, _, D, F, B, G, _),
	    B==C,
	    '$via1_multi_hash_allocation_occurrence/2-1'(D, E)
	->  'rule/2__3__1'(E, D, F, G, A, H, C, I, J)
	;   'rule/2__3__0'(H, C, I, J)
	).
'rule/2__3__1'([], _, _, _, _, A, B, C, D) :-
	'rule/2__3__0'(A, B, C, D).
'rule/2__3__1'([A|G], C, H, I, J, K, D, L, M) :-
	(   A=suspension(_, active, B, F),
	    B==C,
	    '$via1_multi_hash_least_occurrence/2-1'(D, E)
	->  'rule/2__3__2'(E, F, A, G, C, H, I, J, K, D, L, M)
	;   'rule/2__3__1'(G, C, H, I, J, K, D, L, M)
	).
'rule/2__3__2'([], _, _, A, B, C, D, E, F, G, H, I) :-
	'rule/2__3__1'(A, B, C, D, E, F, G, H, I).
'rule/2__3__2'([A|R], G, S, T, I, H, F, U, V, C, W, K) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[E|Q],
	    E==F,
	    G>=H,
	    \+may_trigger(I)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', J),
	    delete_ht(J, C, A),
	    arg(2, K, L),
	    setarg(2, K, active),
	    (   L==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', M),
		N=[K|M],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', N),
		(   M=[O|_]
		->  setarg(4, O, N)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', P),
		insert_ht(P, C, K)
	    ;   true
	    ),
	    least_occurrence(C, Q),
	    (   K=suspension(_, active, _, _, _, _)
	    ->  setarg(2, K, inactive),
		'rule/2__3__2'(R, G, S, T, I, H, F, U, V, C, W, K)
	    ;   true
	    )
	;   'rule/2__3__2'(R, G, S, T, I, H, F, U, V, C, W, K)
	).
'rule/2__3'(A, B, C) :-
	'rule/2__4'(A, B, C).
'rule/2__4'(A, C, D) :-
	'$via1_multi_hash_least_occurrence/2-1'(A, B), !,
	'rule/2__4__0'(B, A, C, D).
'rule/2__4__0'([], A, B, C) :-
	'rule/2__5'(A, B, C).
'rule/2__4__0'([A|P], C, Q, I) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[E|O],
	    ground(C),
	    ground(E),
	    '$via1_multi_hash_passive/2-12'(k(C, E), F),
	    'chr sbag_member'(G, F),
	    G=suspension(_, active, _, _, _)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', H),
	    delete_ht(H, C, A),
	    arg(2, I, J),
	    setarg(2, I, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', K),
		L=[I|K],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', L),
		(   K=[M|_]
		->  setarg(4, M, L)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', N),
		insert_ht(N, C, I)
	    ;   true
	    ),
	    least_occurrence(C, O),
	    (   I=suspension(_, active, _, _, _, _)
	    ->  setarg(2, I, inactive),
		'rule/2__4__0'(P, C, Q, I)
	    ;   true
	    )
	;   'rule/2__4__0'(P, C, Q, I)
	).
'rule/2__4'(A, B, C) :-
	'rule/2__5'(A, B, C).
'rule/2__5'(H, A, B) :-
	A=pragma(rule([], _, _, _), ids([], I), _, _, _), !,
	arg(2, B, C),
	setarg(2, B, active),
	(   C==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', D),
	    E=[B|D],
	    b_setval('$chr_store_global_ground_chr_translate:rule/2', E),
	    (   D=[F|_]
	    ->  setarg(4, F, E)
	    ;   true
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', G),
	    insert_ht(G, H, B)
	;   true
	),
	least_occurrence(H, I),
	(   B=suspension(_, active, _, _, _, _)
	->  setarg(2, B, inactive),
	    'rule/2__6'(H, A, B)
	;   true
	).
'rule/2__5'(A, B, C) :-
	'rule/2__6'(A, B, C).
'rule/2__6'(A, C, D) :-
	'$via1_multi_hash_prev_guard_list/7-2'(A, B), !,
	'rule/2__6__0'(B, A, C, D).
'rule/2__6__0'([], A, B, C) :-
	'rule/2__7'(A, B, C).
'rule/2__6__0'([A|H1], C, D, N) :-
	(   A=suspension(_, active, _, M, B, I, E1, Y, W, X),
	    B==C,
	    D=pragma(rule(E, F, V, _), _, _, _, C),
	    E\==[],
	    append(E, F, G),
	    make_head_matchings_explicit(G, H, U),
	    setof(J, chr_translate:head_subset(H, I, J), T)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', K),
	    delete_ht(K, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', L),
	    delete_ht(L, M, A),
	    arg(2, N, O),
	    setarg(2, N, active),
	    (   O==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', P),
		Q=[N|P],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', Q),
		(   P=[R|_]
		->  setarg(4, R, Q)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', S),
		insert_ht(S, C, N)
	    ;   true
	    ),
	    compute_derived_info(T, U, H, G, V, W, I, X, Z, B1),
	    append(Y, Z, A1),
	    normalize_conj_list(A1, F1),
	    append(B1, X, C1),
	    normalize_conj_list(C1, G1),
	    D1 is C-1,
	    prev_guard_list(M, D1, I, E1, F1, W, G1),
	    (   N=suspension(_, active, _, _, _, _)
	    ->  setarg(2, N, inactive),
		'rule/2__6__0'(H1, C, D, N)
	    ;   true
	    )
	;   'rule/2__6__0'(H1, C, D, N)
	).
'rule/2__6'(A, B, C) :-
	'rule/2__7'(A, B, C).
'rule/2__7'(A, E, O) :-
	'$via1_multi_hash_prev_guard_list/7-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, D, B1, F, H, G, _),
	D=0,
	E=pragma(rule(V, W, F, I), Y, Z, A1, A),
	F\==true,
	append(G, H, J),
	simplify_guard(F, I, J, K, X),
	F\==K, !,
	setarg(2, C, removed),
	arg(5, C, M),
	nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', L),
	delete_ht(L, M, C),
	nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', N),
	delete_ht(N, A, C),
	(   var(O)
	->  true
	;   arg(2, O, P),
	    setarg(2, O, removed),
	    (   P==not_stored_yet
	    ->  true
	    ;   arg(4, O, Q),
		(   var(Q)
		->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', R),
		    R=[_|S],
		    b_setval('$chr_store_global_ground_chr_translate:rule/2', S),
		    (   S=[T|_]
		    ->  setarg(4, T, _)
		    ;   true
		    )
		;   Q=[_, _|S],
		    setarg(2, Q, S),
		    (   S=[T|_]
		    ->  setarg(4, T, Q)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', U),
		delete_ht(U, A, O)
	    )
	),
	rule(A, pragma(rule(V, W, K, X), Y, Z, A1, A)),
	prev_guard_list(A, 0, B1, K, H, G, []).
'rule/2__7'(A, C, D) :-
	'$via1_multi_hash_prev_guard_list/7-1'(A, B), !,
	'rule/2__7__0'(B, A, C, D).
'rule/2__7__0'([], A, B, C) :-
	'rule/2__8'(A, B, C).
'rule/2__7__0'([A|S], C, E, M) :-
	(   A=suspension(_, active, _, B, D, _, F, H, G, _),
	    B==C,
	    D=0,
	    chr_pp_flag(check_impossible_rules, on),
	    E=pragma(rule(_, _, F, _), _, _, _, C),
	    append(G, H, I),
	    guard_entailment:entails_guard(I, fail)
	->  setarg(2, A, removed),
	    arg(5, A, K),
	    nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', J),
	    delete_ht(J, K, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', L),
	    delete_ht(L, C, A),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', O),
		P=[M|O],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', P),
		(   O=[Q|_]
		->  setarg(4, Q, P)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', R),
		insert_ht(R, C, M)
	    ;   true
	    ),
	    chr_warning(weird_program, 'Heads will never match in ~@.\n\tThis rule will never fire!\n', [format_rule(E)]),
	    set_all_passive(C),
	    (   M=suspension(_, active, _, _, _, _)
	    ->  setarg(2, M, inactive),
		'rule/2__7__0'(S, C, E, M)
	    ;   true
	    )
	;   'rule/2__7__0'(S, C, E, M)
	).
'rule/2__7'(A, B, C) :-
	'rule/2__8'(A, B, C).
'rule/2__8'(A, E, B1) :-
	'$via1_multi_hash_prev_guard_list/7-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, D, M, F, H, G, _),
	D=0,
	E=pragma(rule(K, L, F, I), Y, Z, A1, A),
	simplify_heads(G, H, F, I, J, S),
	J\==[],
	extract_arguments(K, N),
	extract_arguments(L, O),
	extract_arguments(M, P),
	replace_some_heads(N, O, P, J, Q, R, F, I, T),
	substitute_arguments(K, Q, V),
	substitute_arguments(L, R, W),
	append(S, T, U),
	list2conj(U, X),
	I1=pragma(rule(V, W, F, (X, I)), Y, Z, A1, A),
	(   K\==V
	;   L\==W
	), !,
	(   var(B1)
	->  true
	;   arg(2, B1, C1),
	    setarg(2, B1, removed),
	    (   C1==not_stored_yet
	    ->  true
	    ;   arg(4, B1, D1),
		(   var(D1)
		->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', E1),
		    E1=[_|F1],
		    b_setval('$chr_store_global_ground_chr_translate:rule/2', F1),
		    (   F1=[G1|_]
		    ->  setarg(4, G1, _)
		    ;   true
		    )
		;   D1=[_, _|F1],
		    setarg(2, D1, F1),
		    (   F1=[G1|_]
		    ->  setarg(4, G1, D1)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', H1),
		delete_ht(H1, A, B1)
	    )
	),
	rule(A, I1).
'rule/2__8'(A, C, D) :-
	'$via1_multi_hash_prev_guard_list/7-1'(A, B), !,
	'rule/2__8__0'(B, A, C, D).
'rule/2__8__0'([], A, B, C) :-
	'rule/2__9'(A, B, C).
'rule/2__8__0'([A|O], C, G, E) :-
	(   A=suspension(_, active, _, B, D, _, H, _, _, _),
	    B==C,
	    D=0,
	    F=t(133, A, E),
	    '$novel_production'(A, F),
	    '$novel_production'(E, F),
	    chr_pp_flag(check_impossible_rules, on),
	    G=pragma(rule(_, _, H, _), _, _, _, C),
	    conj2list(H, I),
	    guard_entailment:entails_guard(I, fail)
	->  '$extend_history'(E, F),
	    arg(2, E, J),
	    setarg(2, E, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', K),
		L=[E|K],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', L),
		(   K=[M|_]
		->  setarg(4, M, L)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', N),
		insert_ht(N, C, E)
	    ;   true
	    ),
	    chr_warning(weird_program, 'Guard will always fail in ~@.\n\tThis rule will never fire!\n', [format_rule(G)]),
	    set_all_passive(C),
	    (   E=suspension(_, active, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'rule/2__8__0'(O, C, G, E)
	    ;   true
	    )
	;   'rule/2__8__0'(O, C, G, E)
	).
'rule/2__8'(A, B, C) :-
	'rule/2__9'(A, B, C).
'rule/2__9'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'rule/2__9__0'(B, A, C, D).
'rule/2__9__0'([], A, B, C) :-
	'rule/2__10'(A, B, C).
'rule/2__9__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, _, E, F, B, _, _),
	    B==C,
	    '$via1_multi_hash_prev_guard_list/7-1'(C, D)
	->  'rule/2__9__1'(D, E, F, A, G, C, H, I)
	;   'rule/2__9__0'(G, C, H, I)
	).
'rule/2__9__1'([], _, _, _, A, B, C, D) :-
	'rule/2__9__0'(A, B, C, D).
'rule/2__9__1'([A|G], E, H, I, J, C, K, L) :-
	(   A=suspension(_, active, _, B, D, _, _, _, _, _),
	    B==C,
	    D=0,
	    '$via1_multi_hash_occurrence/5-13'(k(E, C), F)
	->  'rule/2__9__2'(F, A, G, E, H, I, J, C, K, L)
	;   'rule/2__9__1'(G, E, H, I, J, C, K, L)
	).
'rule/2__9__2'([], _, A, B, C, D, E, F, G, H) :-
	'rule/2__9__1'(A, B, C, D, E, F, G, H).
'rule/2__9__2'([A|J], K, L, D, M, B, N, F, O, P) :-
	(   A=suspension(_, active, _, _, C, H, E, I, _),
	    A\==B,
	    C==D,
	    E==F,
	    nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', G)
	->  'rule/2__9__3'(G, H, I, A, J, K, L, D, M, B, N, F, O, P)
	;   'rule/2__9__2'(J, K, L, D, M, B, N, F, O, P)
	).
'rule/2__9__3'([], _, _, _, A, B, C, D, E, F, G, H, I, J) :-
	'rule/2__9__2'(A, B, C, D, E, F, G, H, I, J).
'rule/2__9__3'([A|T], B, S, U, V, W, X, G, C, Y, Z, E, D, M) :-
	(   A=suspension(_, active, _, H),
	    B<C,
	    chr_pp_flag(occurrence_subsumption, on),
	    D=pragma(rule(F, _, _, _), _, _, _, E),
	    F\==[],
	    \+memberchk_eq(G, H)
	->  setarg(2, A, removed),
	    arg(3, A, I),
	    (   var(I)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', J),
		J=[_|K],
		b_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', K),
		(   K=[L|_]
		->  setarg(3, L, _)
		;   true
		)
	    ;   I=[_, _|K],
		setarg(2, I, K),
		(   K=[L|_]
		->  setarg(3, L, I)
		;   true
		)
	    ),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', O),
		P=[M|O],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', P),
		(   O=[Q|_]
		->  setarg(4, Q, P)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', R),
		insert_ht(R, E, M)
	    ;   true
	    ),
	    first_occ_in_rule(E, G, B, S),
	    multiple_occ_constraints_checked([G|H]),
	    (   M=suspension(_, active, _, _, _, _)
	    ->  setarg(2, M, inactive),
		'rule/2__9__3'(T, B, S, U, V, W, X, G, C, Y, Z, E, D, M)
	    ;   true
	    )
	;   'rule/2__9__3'(T, B, S, U, V, W, X, G, C, Y, Z, E, D, M)
	).
'rule/2__9'(A, B, C) :-
	'rule/2__10'(A, B, C).
'rule/2__10'(B, C, D) :-
	nb_getval('$chr_store_global_ground_chr_translate:static_type_check/0', A), !,
	'rule/2__10__0'(A, B, C, D).
'rule/2__10__0'([], A, B, C) :-
	'rule/2__11'(A, B, C).
'rule/2__10__0'([A|Y], I, J, B) :-
	(   A=suspension(_, active, _, _),
	    C=t(162, B, A),
	    '$novel_production'(B, C),
	    '$novel_production'(A, C)
	->  '$extend_history'(B, C),
	    arg(2, B, D),
	    setarg(2, B, active),
	    (   D==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', E),
		F=[B|E],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', F),
		(   E=[G|_]
		->  setarg(4, G, F)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', H),
		insert_ht(H, I, B)
	    ;   true
	    ),
	    copy_term_nat(J, K),
	    K=pragma(rule(L, M, _, N), ids(_, _), _, _, _),
	    (   catch((static_type_check_heads(L), static_type_check_heads(M), conj2list(N, O), static_type_check_body(O)), type_error(P), (P=invalid_functor(Q, R, S)->chr_error(type_error, 'Invalid functor in ~@ of ~@:\n\t\tfound `~w\',\n\t\texpected type `~w\'!\n', [chr_translate:format_src(Q), format_rule(J), R, S]);P=type_clash(T, V, X, U, W)->chr_error(type_error, 'Type clash for variable ~w in ~@:\n\t\texpected type ~w in ~@\n\t\texpected type ~w in ~@\n', [T, format_rule(J), U, chr_translate:format_src(V), W, chr_translate:format_src(X)]))),
		fail
	    ;   true
	    ),
	    (   B=suspension(_, active, _, _, _, _)
	    ->  setarg(2, B, inactive),
		'rule/2__10__0'(Y, I, J, B)
	    ;   true
	    )
	;   'rule/2__10__0'(Y, I, J, B)
	).
'rule/2__10'(A, B, C) :-
	'rule/2__11'(A, B, C).
'rule/2__11'(A, C, D) :-
	'$via1_multi_hash_passive/2-1'(A, B), !,
	'rule/2__11__0'(B, A, C, D).
'rule/2__11__0'([], A, B, C) :-
	'rule/2__12'(A, B, C).
'rule/2__11__0'([A|P], C, F, D) :-
	(   A=suspension(_, active, _, B, G),
	    B==C,
	    E=t(196, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E),
	    F=pragma(rule(_, _, _, _), ids([G|M], N), _, _, C)
	->  '$extend_history'(D, E),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', I),
		J=[D|I],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', L),
		insert_ht(L, C, D)
	    ;   true
	    ),
	    append(M, N, O),
	    check_all_passive(C, O),
	    (   D=suspension(_, active, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'rule/2__11__0'(P, C, F, D)
	    ;   true
	    )
	;   'rule/2__11__0'(P, C, F, D)
	).
'rule/2__11'(A, B, C) :-
	'rule/2__12'(A, B, C).
'rule/2__12'(A, C, D) :-
	'$via1_multi_hash_passive/2-1'(A, B), !,
	'rule/2__12__0'(B, A, C, D).
'rule/2__12__0'([], A, B, C) :-
	'rule/2__13'(A, B, C).
'rule/2__12__0'([A|N], C, F, D) :-
	(   A=suspension(_, active, _, B, G),
	    B==C,
	    E=t(197, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E),
	    F=pragma(rule(_, _, _, _), ids([], [G|M]), _, _, C)
	->  '$extend_history'(D, E),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', I),
		J=[D|I],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', L),
		insert_ht(L, C, D)
	    ;   true
	    ),
	    check_all_passive(C, M),
	    (   D=suspension(_, active, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'rule/2__12__0'(N, C, F, D)
	    ;   true
	    )
	;   'rule/2__12__0'(N, C, F, D)
	).
'rule/2__12'(A, B, C) :-
	'rule/2__13'(A, B, C).
'rule/2__13'(A, C, D) :-
	'$via1_multi_hash_check_all_passive/2-1'(A, B), !,
	'rule/2__13__0'(B, A, C, D).
'rule/2__13__0'([], A, B, C) :-
	'rule/2__14'(A, B, C).
'rule/2__13__0'([A|M], C, L, F) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=[]
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:check_all_passive/2-1', E),
	    delete_ht(E, C, A),
	    arg(2, F, G),
	    setarg(2, F, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', H),
		I=[F|H],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', I),
		(   H=[J|_]
		->  setarg(4, J, I)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', K),
		insert_ht(K, C, F)
	    ;   true
	    ),
	    chr_warning(weird_program, 'All heads passive in ~@.\n\tThis rule never fires. Please check your program.\n', [format_rule(L)]),
	    (   F=suspension(_, active, _, _, _, _)
	    ->  setarg(2, F, inactive),
		'rule/2__13__0'(M, C, L, F)
	    ;   true
	    )
	;   'rule/2__13__0'(M, C, L, F)
	).
'rule/2__13'(A, B, C) :-
	'rule/2__14'(A, B, C).
'rule/2__14'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'rule/2__14__0'(B, A, C, D).
'rule/2__14__0'([], A, B, C) :-
	'rule/2__15'(A, B, C).
'rule/2__14__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, _, E, _, B, F, G),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', D)
	->  'rule/2__14__1'(D, E, F, G, A, H, C, I, J)
	;   'rule/2__14__0'(H, C, I, J)
	).
'rule/2__14__1'([], _, _, _, _, A, B, C, D) :-
	'rule/2__14__0'(A, B, C, D).
'rule/2__14__1'([A|D], B, E, F, G, H, I, J, K) :-
	(   A=suspension(_, active, _, _),
	    '$via1_multi_hash_constraint_mode/2-1'(B, C)
	->  'rule/2__14__2'(C, A, D, B, E, F, G, H, I, J, K)
	;   'rule/2__14__1'(D, B, E, F, G, H, I, J, K)
	).
'rule/2__14__2'([], _, A, B, C, D, E, F, G, H, I) :-
	'rule/2__14__1'(A, B, C, D, E, F, G, H, I).
'rule/2__14__2'([A|X], D, Y, C, O, P, E, Z, M, N, F) :-
	(   A=suspension(_, active, _, _, B, U),
	    B==C,
	    G=t(273, D, E, F, A),
	    '$novel_production'(D, G),
	    '$novel_production'(E, G),
	    '$novel_production'(F, G),
	    '$novel_production'(A, G)
	->  '$extend_history'(F, G),
	    arg(2, F, H),
	    setarg(2, F, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', I),
		J=[F|I],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', L),
		insert_ht(L, M, F)
	    ;   true
	    ),
	    N=pragma(rule(Q, W, S, _), _, _, _, _),
	    (   is_passive(M, O)
	    ->  true
	    ;   P==simplification
	    ->  select(R, Q, _),
		R=..[_|T],
		term_variables(S, V),
		partial_wake_args(T, U, V, C)
	    ;   select(R, W, _),
		R=..[_|T],
		term_variables(S, V),
		partial_wake_args(T, U, V, C)
	    ),
	    (   F=suspension(_, active, _, _, _, _)
	    ->  setarg(2, F, inactive),
		'rule/2__14__2'(X, D, Y, C, O, P, E, Z, M, N, F)
	    ;   true
	    )
	;   'rule/2__14__2'(X, D, Y, C, O, P, E, Z, M, N, F)
	).
'rule/2__14'(A, B, C) :-
	'rule/2__15'(A, B, C).
'rule/2__15'(G, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:rule/2', D),
	    (   C=[E|_]
	    ->  setarg(4, E, D)
	    ;   true
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', F),
	    insert_ht(F, G, A)
	;   true
	).
get_rule(A, D) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, E), !,
	D=E.
get_rule(_, _) :-
	fail.
least_occurrence(A, B) :-
	'least_occurrence/2__0'(A, B, _).
'least_occurrence/2__0'(A, [], B) :-
	'$via1_multi_hash_occurrence/5-3'(A, D), !,
	B=suspension(C, not_stored_yet, A, []),
	'chr gen_id'(C),
	'least_occurrence/2__0__0'(D, A, [], B).
'least_occurrence/2__0__0'([], A, B, C) :-
	'least_occurrence/2__1'(A, B, C).
'least_occurrence/2__0__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, _, E, F, B, _, _),
	    B==C,
	    '$via1_multi_hash_rule/2-1'(C, D)
	->  'least_occurrence/2__0__1'(D, E, F, A, G, C, H, I)
	;   'least_occurrence/2__0__0'(G, C, H, I)
	).
'least_occurrence/2__0__1'([], _, _, _, A, B, C, D) :-
	'least_occurrence/2__0__0'(A, B, C, D).
'least_occurrence/2__0__1'([A|H], D, E, I, J, C, K, L) :-
	(   A=suspension(_, active, _, _, B, G),
	    B==C,
	    '$via1_multi_hash_allocation_occurrence/2-12'(k(D, E), F)
	->  'least_occurrence/2__0__2'(F, G, A, H, D, E, I, J, C, K, L)
	;   'least_occurrence/2__0__1'(H, D, E, I, J, C, K, L)
	).
'least_occurrence/2__0__2'([], _, _, A, B, C, D, E, F, G, H) :-
	'least_occurrence/2__0__1'(A, B, C, D, E, F, G, H).
'least_occurrence/2__0__2'([A|N], F, O, P, C, E, Q, R, L, S, I) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D==E,
	    F=pragma(rule([], _, _, _), _, _, _, _),
	    \+is_observed(C, E)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-1', G),
	    delete_ht(G, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:allocation_occurrence/2-12', H),
	    delete_ht(H, k(C, E), A),
	    arg(2, I, J),
	    setarg(2, I, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', K),
		insert_ht(K, L, I)
	    ;   true
	    ),
	    M is E+1,
	    allocation_occurrence(C, M),
	    (   I=suspension(_, active, _, _)
	    ->  setarg(2, I, inactive),
		'least_occurrence/2__0__2'(N, F, O, P, C, E, Q, R, L, S, I)
	    ;   true
	    )
	;   'least_occurrence/2__0__2'(N, F, O, P, C, E, Q, R, L, S, I)
	).
'least_occurrence/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, B, C),
	'chr gen_id'(D),
	'least_occurrence/2__1'(B, C, A).
'least_occurrence/2__1'(A, [B|O], L) :-
	'$via1_multi_hash_occurrence/5-34'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, E, I, _, _, _),
	'$via1_multi_hash_allocation_occurrence/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, H),
	H>=I,
	'$via1_multi_hash_rule/2-1'(A, J),
	'chr sbag_member'(K, J),
	K=suspension(_, active, _, _, _, _),
	\+may_trigger(E), !,
	(   var(L)
	->  true
	;   arg(2, L, M),
	    setarg(2, L, removed),
	    (   M==not_stored_yet
	    ->  true
	    ;   nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', N),
		delete_ht(N, A, L)
	    )
	),
	least_occurrence(A, O).
'least_occurrence/2__1'(A, [B|J], G) :-
	'$via1_multi_hash_passive/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _),
	'$via1_multi_hash_rule/2-1'(A, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, _, _), !,
	(   var(G)
	->  true
	;   arg(2, G, H),
	    setarg(2, G, removed),
	    (   H==not_stored_yet
	    ->  true
	    ;   nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', I),
		delete_ht(I, A, G)
	    )
	),
	least_occurrence(A, J).
'least_occurrence/2__1'(D, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:least_occurrence/2-1', C),
	    insert_ht(C, D, A)
	;   true
	).
is_least_occurrence(A) :-
	'$via1_multi_hash_least_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, D),
	D=[], !.
is_least_occurrence(_) :-
	fail.
constraint_index(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_index/2-2', D),
	insert_ht(D, B, E),
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_index/2-1', F),
	insert_ht(F, A, E).
get_constraint_index(A, D) :-
	'$via1_multi_hash_constraint_index/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_constraint_index(_, _) :-
	fail.
get_indexed_constraint(A, D) :-
	'$via1_multi_hash_constraint_index/2-2'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, E, _), !,
	D=E.
get_indexed_constraint(_, _) :-
	fail.
max_constraint_index(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:max_constraint_index/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:max_constraint_index/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
get_max_constraint_index(C) :-
	nb_getval('$chr_store_global_ground_chr_translate:max_constraint_index/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, D), !,
	C=D.
get_max_constraint_index(0).
identifier_size(_) :-
	nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _), !.
identifier_size(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', A), !,
	'identifier_size/1__0__0'(A, B).
'identifier_size/1__0__0'([], A) :-
	'identifier_size/1__1'(A).
'identifier_size/1__0__0'([A|F], G) :-
	(   A=suspension(_, active, _, _)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:identifier_size/1', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    'identifier_size/1__0__0'(F, G)
	;   'identifier_size/1__0__0'(F, G)
	).
identifier_size(A) :-
	'identifier_size/1__1'(A).
'identifier_size/1__1'(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:identifier_size/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
get_identifier_size(C) :-
	nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, D), !,
	C=D.
get_identifier_size(1).
identifier_index(A, B, _) :-
	'$via1_multi_hash_identifier_index/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !.
identifier_index(A, B, D) :-
	'$via1_multi_hash_identifier_index/3-12'(k(A, B), C), !,
	'identifier_index/3__0__0'(C, A, B, D).
'identifier_index/3__0__0'([], A, B, C) :-
	'identifier_index/3__1'(A, B, C).
'identifier_index/3__0__0'([A|G], C, E, H) :-
	(   A=suspension(_, active, B, D, _),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:identifier_index/3-12', F),
	    delete_ht(F, k(C, E), A),
	    'identifier_index/3__0__0'(G, C, E, H)
	;   'identifier_index/3__0__0'(G, C, E, H)
	).
identifier_index(A, B, C) :-
	'identifier_index/3__1'(A, B, C).
'identifier_index/3__1'(A, B, C) :-
	F=suspension(D, active, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_multi_hash_chr_translate:identifier_index/3-12', E),
	insert_ht(E, k(A, B), F).
get_identifier_index(A, B, E) :-
	'$via1_multi_hash_identifier_index/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, F), !,
	E=F.
get_identifier_index(H, I, K) :-
	nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, G), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:identifier_size/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:identifier_size/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	J is G+1,
	identifier_index(H, I, J),
	identifier_size(J),
	K=J.
get_identifier_index(A, B, C) :-
	identifier_index(A, B, 2),
	identifier_size(2),
	C=2.
type_indexed_identifier_size(A, _) :-
	'$via1_multi_hash_type_indexed_identifier_size/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _), !.
type_indexed_identifier_size(A, C) :-
	'$via1_multi_hash_type_indexed_identifier_size/2-1'(A, B), !,
	'type_indexed_identifier_size/2__0__0'(B, A, C).
'type_indexed_identifier_size/2__0__0'([], A, B) :-
	'type_indexed_identifier_size/2__1'(A, B).
'type_indexed_identifier_size/2__0__0'([A|E], C, F) :-
	(   A=suspension(_, active, B, _),
	    B==C
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1', D),
	    delete_ht(D, C, A),
	    'type_indexed_identifier_size/2__0__0'(E, C, F)
	;   'type_indexed_identifier_size/2__0__0'(E, C, F)
	).
type_indexed_identifier_size(A, B) :-
	'type_indexed_identifier_size/2__1'(A, B).
'type_indexed_identifier_size/2__1'(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1', D),
	insert_ht(D, A, E).
get_type_indexed_identifier_size(A, D) :-
	'$via1_multi_hash_type_indexed_identifier_size/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_type_indexed_identifier_size(_, 1).
type_indexed_identifier_index(_, A, B, _) :-
	'$via1_multi_hash_type_indexed_identifier_index/4-23'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _), !.
type_indexed_identifier_index(D, A, B, E) :-
	'$via1_multi_hash_type_indexed_identifier_index/4-23'(k(A, B), C), !,
	'type_indexed_identifier_index/4__0__0'(C, D, A, B, E).
'type_indexed_identifier_index/4__0__0'([], A, B, C, D) :-
	'type_indexed_identifier_index/4__1'(A, B, C, D).
'type_indexed_identifier_index/4__0__0'([A|I], J, C, E, K) :-
	(   A=suspension(_, active, G, B, D, _),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-123', F),
	    delete_ht(F, k(G, C, E), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-23', H),
	    delete_ht(H, k(C, E), A),
	    'type_indexed_identifier_index/4__0__0'(I, J, C, E, K)
	;   'type_indexed_identifier_index/4__0__0'(I, J, C, E, K)
	).
type_indexed_identifier_index(A, B, C, D) :-
	'type_indexed_identifier_index/4__1'(A, B, C, D).
'type_indexed_identifier_index/4__1'(A, B, C, D) :-
	G=suspension(E, active, A, B, C, D),
	'chr gen_id'(E),
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-123', F),
	insert_ht(F, k(A, B, C), G),
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_index/4-23', H),
	insert_ht(H, k(B, C), G).
get_type_indexed_identifier_index(A, B, C, F) :-
	'$via1_multi_hash_type_indexed_identifier_index/4-123'(k(A, B, C), D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, _, G), !,
	F=G.
get_type_indexed_identifier_index(A, F, G, I) :-
	'$via1_multi_hash_type_indexed_identifier_size/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:type_indexed_identifier_size/2-1', D),
	delete_ht(D, A, C),
	H is E+1,
	type_indexed_identifier_index(A, F, G, H),
	type_indexed_identifier_size(A, H),
	I=H.
get_type_indexed_identifier_index(A, B, C, D) :-
	type_indexed_identifier_index(A, B, C, 2),
	type_indexed_identifier_size(A, 2),
	D=2.
no_history(A) :-
	D=suspension(B, active, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_multi_hash_chr_translate:no_history/1-1', C),
	insert_ht(C, A, D).
has_no_history(A) :-
	'$via1_multi_hash_no_history/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
has_no_history(_) :-
	fail.
history(A, B, C) :-
	F=suspension(D, active, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_multi_hash_chr_translate:history/3-1', E),
	insert_ht(E, A, F).
named_history(A, D, F) :-
	ground(A),
	'$via1_multi_hash_history/3-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E, G), !,
	D=E,
	F=G.
named_history(_, _, _) :-
	fail.
indexing_spec(A, E) :-
	'$via1_multi_hash_indexing_spec/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, F), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:indexing_spec/2-1', D),
	delete_ht(D, A, C),
	append(E, F, G),
	indexing_spec(A, G).
indexing_spec(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:indexing_spec/2-1', D),
	insert_ht(D, A, E).
get_indexing_spec(A, D) :-
	'$via1_multi_hash_indexing_spec/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_indexing_spec(_, []).
observation_analysis(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:rule/2', A), !,
	'observation_analysis/1__0__0'(A, B).
'observation_analysis/1__0__0'([], A) :-
	'observation_analysis/1__1'(A).
'observation_analysis/1__0__0'([A|G], E) :-
	(   A=suspension(_, active, _, _, C, B)
	->  B=pragma(rule(_, _, D, F), _, _, _, _),
	    (   chr_pp_flag(store_in_guards, on)
	    ->  observation_analysis(C, D, guard, E)
	    ;   true
	    ),
	    observation_analysis(C, F, body, E),
	    'observation_analysis/1__0__0'(G, E)
	;   'observation_analysis/1__0__0'(G, E)
	).
observation_analysis(A) :-
	'observation_analysis/1__1'(A).
'observation_analysis/1__1'(_).
spawns(A, B, C) :-
	'spawns/3__0'(A, B, C, _).
'spawns/3__0'(A, B, C, _) :-
	'$via1_multi_hash_spawns/3-123'(k(A, B, C), D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, _, _, _), !.
'spawns/3__0'(A, body, B, _) :-
	'$via1_multi_hash_spawns/3-13'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, _),
	E=guard, !.
'spawns/3__0'(A, guard, B, D) :-
	'$via1_multi_hash_spawns/3-13'(k(A, B), C), !,
	'spawns/3__0__0'(C, A, guard, B, D).
'spawns/3__0__0'([], A, B, C, D) :-
	'spawns/3__1'(A, B, C, D).
'spawns/3__0__0'([A|R], C, S, F, T) :-
	(   A=suspension(_, active, _, _, B, D, E),
	    B==C,
	    D=body,
	    E==F
	->  setarg(2, A, removed),
	    arg(4, A, G),
	    (   var(G)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', H),
		H=[_|I],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', I),
		(   I=[J|_]
		->  setarg(4, J, _)
		;   true
		)
	    ;   G=[_, _|I],
		setarg(2, G, I),
		(   I=[J|_]
		->  setarg(4, J, G)
		;   true
		)
	    ),
	    arg(6, A, L),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', K),
	    delete_ht(K, k(C, L), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', M),
	    delete_ht(M, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', N),
	    delete_ht(N, F, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', O),
	    delete_ht(O, k(C, F), A),
	    arg(6, A, Q),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', P),
	    delete_ht(P, k(C, Q, F), A),
	    'spawns/3__0__0'(R, C, S, F, T)
	;   'spawns/3__0__0'(R, C, S, F, T)
	).
'spawns/3__0'(A, B, C, D) :-
	'spawns/3__1'(A, B, C, D).
'spawns/3__1'(A, B, N, E) :-
	'$via1_multi_hash_spawns_all/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !,
	(   var(E)
	->  true
	;   arg(2, E, F),
	    setarg(2, E, removed),
	    (   F==not_stored_yet
	    ->  true
	    ;   arg(4, E, G),
		(   var(G)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', H),
		    H=[_|I],
		    b_setval('$chr_store_global_ground_chr_translate:spawns/3', I),
		    (   I=[J|_]
		    ->  setarg(4, J, _)
		    ;   true
		    )
		;   G=[_, _|I],
		    setarg(2, G, I),
		    (   I=[J|_]
		    ->  setarg(4, J, G)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', K),
		delete_ht(K, k(A, B), E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', L),
		delete_ht(L, A, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', M),
		delete_ht(M, N, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', O),
		delete_ht(O, k(A, N), E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', P),
		delete_ht(P, k(A, B, N), E)
	    )
	).
'spawns/3__1'(A, body, O, E) :-
	'$via1_multi_hash_spawns_all/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, D),
	D=guard, !,
	(   var(E)
	->  true
	;   arg(2, E, F),
	    setarg(2, E, removed),
	    (   F==not_stored_yet
	    ->  true
	    ;   arg(4, E, G),
		(   var(G)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', H),
		    H=[_|I],
		    b_setval('$chr_store_global_ground_chr_translate:spawns/3', I),
		    (   I=[J|_]
		    ->  setarg(4, J, _)
		    ;   true
		    )
		;   G=[_, _|I],
		    setarg(2, G, I),
		    (   I=[J|_]
		    ->  setarg(4, J, G)
		    ;   true
		    )
		),
		arg(6, E, L),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', K),
		delete_ht(K, k(A, L), E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', M),
		delete_ht(M, A, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', N),
		delete_ht(N, O, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', P),
		delete_ht(P, k(A, O), E),
		arg(6, E, R),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', Q),
		delete_ht(Q, k(A, R, O), E)
	    )
	).
'spawns/3__1'(A, B, E, F) :-
	'$via1_multi_hash_spawns_all_triggers/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _),
	may_trigger(E), !,
	(   var(F)
	->  true
	;   arg(2, F, G),
	    setarg(2, F, removed),
	    (   G==not_stored_yet
	    ->  true
	    ;   arg(4, F, H),
		(   var(H)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', I),
		    I=[_|J],
		    b_setval('$chr_store_global_ground_chr_translate:spawns/3', J),
		    (   J=[K|_]
		    ->  setarg(4, K, _)
		    ;   true
		    )
		;   H=[_, _|J],
		    setarg(2, H, J),
		    (   J=[K|_]
		    ->  setarg(4, K, H)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', L),
		delete_ht(L, k(A, B), F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', M),
		delete_ht(M, A, F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', N),
		delete_ht(N, E, F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', O),
		delete_ht(O, k(A, E), F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', P),
		delete_ht(P, k(A, B, E), F)
	    )
	).
'spawns/3__1'(A, body, E, F) :-
	'$via1_multi_hash_spawns_all_triggers/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D),
	D=guard,
	may_trigger(E), !,
	(   var(F)
	->  true
	;   arg(2, F, G),
	    setarg(2, F, removed),
	    (   G==not_stored_yet
	    ->  true
	    ;   arg(4, F, H),
		(   var(H)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', I),
		    I=[_|J],
		    b_setval('$chr_store_global_ground_chr_translate:spawns/3', J),
		    (   J=[K|_]
		    ->  setarg(4, K, _)
		    ;   true
		    )
		;   H=[_, _|J],
		    setarg(2, H, J),
		    (   J=[K|_]
		    ->  setarg(4, K, H)
		    ;   true
		    )
		),
		arg(6, F, M),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', L),
		delete_ht(L, k(A, M), F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', N),
		delete_ht(N, A, F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', O),
		delete_ht(O, E, F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', P),
		delete_ht(P, k(A, E), F),
		arg(6, F, R),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', Q),
		delete_ht(Q, k(A, R, E), F)
	    )
	).
'spawns/3__1'(O, P, A, H) :-
	'$via1_multi_hash_occurrence/5-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, _, D, G, _),
	'$via1_multi_hash_spawns_all/2-1'(D, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _),
	\+is_passive(D, G), !,
	(   var(H)
	->  true
	;   arg(2, H, I),
	    setarg(2, H, removed),
	    (   I==not_stored_yet
	    ->  true
	    ;   arg(4, H, J),
		(   var(J)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', K),
		    K=[_|L],
		    b_setval('$chr_store_global_ground_chr_translate:spawns/3', L),
		    (   L=[M|_]
		    ->  setarg(4, M, _)
		    ;   true
		    )
		;   J=[_, _|L],
		    setarg(2, J, L),
		    (   L=[M|_]
		    ->  setarg(4, M, J)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', N),
		delete_ht(N, k(O, P), H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', Q),
		delete_ht(Q, O, H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', R),
		delete_ht(R, A, H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', S),
		delete_ht(S, k(O, A), H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', T),
		delete_ht(T, k(O, P, A), H)
	    )
	),
	spawns_all(O, P).
'spawns/3__1'(O, P, A, H) :-
	'$via1_multi_hash_occurrence/5-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, _, D, G, _),
	'$via1_multi_hash_spawns_all_triggers/2-1'(D, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, _, _),
	\+is_passive(D, G), !,
	(   var(H)
	->  true
	;   arg(2, H, I),
	    setarg(2, H, removed),
	    (   I==not_stored_yet
	    ->  true
	    ;   arg(4, H, J),
		(   var(J)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', K),
		    K=[_|L],
		    b_setval('$chr_store_global_ground_chr_translate:spawns/3', L),
		    (   L=[M|_]
		    ->  setarg(4, M, _)
		    ;   true
		    )
		;   J=[_, _|L],
		    setarg(2, J, L),
		    (   L=[M|_]
		    ->  setarg(4, M, J)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', N),
		delete_ht(N, k(O, P), H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', Q),
		delete_ht(Q, O, H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', R),
		delete_ht(R, A, H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', S),
		delete_ht(S, k(O, A), H),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', T),
		delete_ht(T, k(O, P, A), H)
	    )
	),
	spawns_all_triggers(O, P).
'spawns/3__1'(A, C, D, B) :-
	'$via1_multi_hash_occurrence/5-3'(A, F), !,
	B=suspension(E, not_stored_yet, t, _, A, C, D),
	'chr gen_id'(E),
	'spawns/3__1__0'(F, A, C, D, B).
'spawns/3__1__0'([], A, B, C, D) :-
	'spawns/3__2'(A, B, C, D).
'spawns/3__1__0'([A|G], C, H, I, J) :-
	(   A=suspension(_, active, _, _, D, _, B, F, _),
	    B==C,
	    '$via1_multi_hash_spawns/3-3'(D, E)
	->  'spawns/3__1__1'(E, D, F, A, G, C, H, I, J)
	;   'spawns/3__1__0'(G, C, H, I, J)
	).
'spawns/3__1__1'([], _, _, _, A, B, C, D, E) :-
	'spawns/3__1__0'(A, B, C, D, E).
'spawns/3__1__1'([A|V], C, J, E, W, H, P, I, D) :-
	(   A=suspension(_, active, _, _, G, U, B),
	    B==C,
	    F=t(105, D, E, A),
	    '$novel_production'(D, F),
	    '$novel_production'(A, F),
	    G\==H,
	    C\==I,
	    \+is_passive(H, J)
	->  '$extend_history'(D, F),
	    arg(2, D, K),
	    setarg(2, D, active),
	    (   K==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', L),
		M=[D|L],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', M),
		(   L=[N|_]
		->  setarg(4, N, M)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', O),
		insert_ht(O, k(H, P), D),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', Q),
		insert_ht(Q, H, D),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', R),
		insert_ht(R, I, D),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', S),
		insert_ht(S, k(H, I), D),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', T),
		insert_ht(T, k(H, P, I), D)
	    ;   true
	    ),
	    spawns(G, U, I),
	    (   D=suspension(_, active, _, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'spawns/3__1__1'(V, C, J, E, W, H, P, I, D)
	    ;   true
	    )
	;   'spawns/3__1__1'(V, C, J, E, W, H, P, I, D)
	).
'spawns/3__1'(B, C, D, A) :-
	A=suspension(E, not_stored_yet, t, _, B, C, D),
	'chr gen_id'(E),
	'spawns/3__2'(B, C, D, A).
'spawns/3__2'(C, D, A, E) :-
	'$via1_multi_hash_occurrence/5-1'(A, B), !,
	'spawns/3__2__0'(B, C, D, A, E).
'spawns/3__2__0'([], A, B, C, D) :-
	'spawns/3__3'(A, B, C, D).
'spawns/3__2__0'([A|G], H, I, C, J) :-
	(   A=suspension(_, active, _, _, B, _, D, F, _),
	    B==C,
	    '$via1_multi_hash_spawns/3-1'(D, E)
	->  'spawns/3__2__1'(E, D, F, A, G, H, I, C, J)
	;   'spawns/3__2__0'(G, H, I, C, J)
	).
'spawns/3__2__1'([], _, _, _, A, B, C, D, E) :-
	'spawns/3__2__0'(A, B, C, D, E).
'spawns/3__2__1'([A|U], C, J, D, V, G, P, H, E) :-
	(   A=suspension(_, active, _, _, B, _, I),
	    B==C,
	    F=t(105, A, D, E),
	    '$novel_production'(A, F),
	    '$novel_production'(E, F),
	    G\==C,
	    H\==I,
	    \+is_passive(C, J)
	->  '$extend_history'(E, F),
	    arg(2, E, K),
	    setarg(2, E, active),
	    (   K==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', L),
		M=[E|L],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', M),
		(   L=[N|_]
		->  setarg(4, N, M)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', O),
		insert_ht(O, k(G, P), E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', Q),
		insert_ht(Q, G, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', R),
		insert_ht(R, H, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', S),
		insert_ht(S, k(G, H), E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', T),
		insert_ht(T, k(G, P, H), E)
	    ;   true
	    ),
	    spawns(G, P, I),
	    (   E=suspension(_, active, _, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'spawns/3__2__1'(U, C, J, D, V, G, P, H, E)
	    ;   true
	    )
	;   'spawns/3__2__1'(U, C, J, D, V, G, P, H, E)
	).
'spawns/3__2'(A, B, C, D) :-
	'spawns/3__3'(A, B, C, D).
'spawns/3__3'(A, C, D, E) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'spawns/3__3__0'(B, A, C, D, E).
'spawns/3__3__0'([], A, B, C, D) :-
	'spawns/3__4'(A, B, C, D).
'spawns/3__3__0'([A|G], C, H, I, J) :-
	(   A=suspension(_, active, _, _, E, _, B, F, _),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', D)
	->  'spawns/3__3__1'(D, E, F, A, G, C, H, I, J)
	;   'spawns/3__3__0'(G, C, H, I, J)
	).
'spawns/3__3__1'([], _, _, _, A, B, C, D, E) :-
	'spawns/3__3__0'(A, B, C, D, E).
'spawns/3__3__1'([A|U], G, F, C, V, E, N, H, B) :-
	(   A=suspension(_, active, _, _, S, T),
	    D=t(106, B, C, A),
	    '$novel_production'(B, D),
	    '$novel_production'(A, D),
	    \+is_passive(E, F),
	    may_trigger(G),
	    \+may_trigger(H)
	->  '$extend_history'(B, D),
	    arg(2, B, I),
	    setarg(2, B, active),
	    (   I==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', J),
		K=[B|J],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', K),
		(   J=[L|_]
		->  setarg(4, L, K)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', M),
		insert_ht(M, k(E, N), B),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', O),
		insert_ht(O, E, B),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', P),
		insert_ht(P, H, B),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', Q),
		insert_ht(Q, k(E, H), B),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', R),
		insert_ht(R, k(E, N, H), B)
	    ;   true
	    ),
	    spawns(S, T, H),
	    (   B=suspension(_, active, _, _, _, _, _)
	    ->  setarg(2, B, inactive),
		'spawns/3__3__1'(U, G, F, C, V, E, N, H, B)
	    ;   true
	    )
	;   'spawns/3__3__1'(U, G, F, C, V, E, N, H, B)
	).
'spawns/3__3'(A, B, C, D) :-
	'spawns/3__4'(A, B, C, D).
'spawns/3__4'(G, H, K, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:spawns/3', D),
	    (   C=[E|_]
	    ->  setarg(4, E, D)
	    ;   true
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', F),
	    insert_ht(F, k(G, H), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', I),
	    insert_ht(I, G, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', J),
	    insert_ht(J, K, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', L),
	    insert_ht(L, k(G, K), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', M),
	    insert_ht(M, k(G, H, K), A)
	;   true
	).
spawns_all(A, B) :-
	'spawns_all/2__0'(A, B, _).
'spawns_all/2__0'(A, B, _) :-
	'$via1_multi_hash_spawns_all/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
'spawns_all/2__0'(A, body, _) :-
	'$via1_multi_hash_spawns_all/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, D),
	D=guard, !.
'spawns_all/2__0'(A, guard, C) :-
	'$via1_multi_hash_spawns_all/2-1'(A, B), !,
	'spawns_all/2__0__0'(B, A, guard, C).
'spawns_all/2__0__0'([], A, B, C) :-
	'spawns_all/2__1'(A, B, C).
'spawns_all/2__0__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, B, D),
	    B==C,
	    D=body
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', E),
	    delete_ht(E, C, A),
	    arg(4, A, G),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-12', F),
	    delete_ht(F, k(C, G), A),
	    'spawns_all/2__0__0'(H, C, I, J)
	;   'spawns_all/2__0__0'(H, C, I, J)
	).
'spawns_all/2__0'(A, B, C) :-
	'spawns_all/2__1'(A, B, C).
'spawns_all/2__1'(A, B, D) :-
	'$via1_multi_hash_spawns/3-12'(k(A, B), C), !,
	'spawns_all/2__1__0'(C, A, B, D).
'spawns_all/2__1__0'([], A, B, C) :-
	'spawns_all/2__2'(A, B, C).
'spawns_all/2__1__0'([A|P], C, E, Q) :-
	(   A=suspension(_, active, _, _, B, D, M),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    arg(4, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', H),
		(   H=[I|_]
		->  setarg(4, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(4, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', J),
	    delete_ht(J, k(C, E), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', K),
	    delete_ht(K, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', L),
	    delete_ht(L, M, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', N),
	    delete_ht(N, k(C, M), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', O),
	    delete_ht(O, k(C, E, M), A),
	    'spawns_all/2__1__0'(P, C, E, Q)
	;   'spawns_all/2__1__0'(P, C, E, Q)
	).
'spawns_all/2__1'(A, B, C) :-
	'spawns_all/2__2'(A, B, C).
'spawns_all/2__2'(A, guard, C) :-
	'$via1_multi_hash_spawns/3-1'(A, B), !,
	'spawns_all/2__2__0'(B, A, guard, C).
'spawns_all/2__2__0'([], A, B, C) :-
	'spawns_all/2__3'(A, B, C).
'spawns_all/2__2__0'([A|Q], C, R, S) :-
	(   A=suspension(_, active, _, _, B, D, M),
	    B==C,
	    D=body
	->  setarg(2, A, removed),
	    arg(4, A, E),
	    (   var(E)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', F),
		F=[_|G],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', G),
		(   G=[H|_]
		->  setarg(4, H, _)
		;   true
		)
	    ;   E=[_, _|G],
		setarg(2, E, G),
		(   G=[H|_]
		->  setarg(4, H, E)
		;   true
		)
	    ),
	    arg(6, A, J),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', I),
	    delete_ht(I, k(C, J), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', K),
	    delete_ht(K, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', L),
	    delete_ht(L, M, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', N),
	    delete_ht(N, k(C, M), A),
	    arg(6, A, P),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', O),
	    delete_ht(O, k(C, P, M), A),
	    'spawns_all/2__2__0'(Q, C, R, S)
	;   'spawns_all/2__2__0'(Q, C, R, S)
	).
'spawns_all/2__2'(A, B, C) :-
	'spawns_all/2__3'(A, B, C).
'spawns_all/2__3'(A, B, D) :-
	'$via1_multi_hash_spawns_all_triggers/2-12'(k(A, B), C), !,
	'spawns_all/2__3__0'(C, A, B, D).
'spawns_all/2__3__0'([], A, B, C) :-
	'spawns_all/2__4'(A, B, C).
'spawns_all/2__3__0'([A|L], C, E, M) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    arg(4, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', H),
		(   H=[I|_]
		->  setarg(4, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(4, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', K),
	    delete_ht(K, k(C, E), A),
	    'spawns_all/2__3__0'(L, C, E, M)
	;   'spawns_all/2__3__0'(L, C, E, M)
	).
'spawns_all/2__3'(A, B, C) :-
	'spawns_all/2__4'(A, B, C).
'spawns_all/2__4'(A, guard, C) :-
	'$via1_multi_hash_spawns_all_triggers/2-1'(A, B), !,
	'spawns_all/2__4__0'(B, A, guard, C).
'spawns_all/2__4__0'([], A, B, C) :-
	'spawns_all/2__5'(A, B, C).
'spawns_all/2__4__0'([A|L], C, M, N) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D=body
	->  setarg(2, A, removed),
	    arg(4, A, E),
	    (   var(E)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', F),
		F=[_|G],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', G),
		(   G=[H|_]
		->  setarg(4, H, _)
		;   true
		)
	    ;   E=[_, _|G],
		setarg(2, E, G),
		(   G=[H|_]
		->  setarg(4, H, E)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', I),
	    delete_ht(I, C, A),
	    arg(6, A, K),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', J),
	    delete_ht(J, k(C, K), A),
	    'spawns_all/2__4__0'(L, C, M, N)
	;   'spawns_all/2__4__0'(L, C, M, N)
	).
'spawns_all/2__4'(A, B, C) :-
	'spawns_all/2__5'(A, B, C).
'spawns_all/2__5'(A, C, B) :-
	'$via1_multi_hash_occurrence/5-3'(A, E), !,
	B=suspension(D, not_stored_yet, A, C),
	'chr gen_id'(D),
	'spawns_all/2__5__0'(E, A, C, B).
'spawns_all/2__5__0'([], A, B, C) :-
	'spawns_all/2__6'(A, B, C).
'spawns_all/2__5__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, _, D, _, B, F, _),
	    B==C,
	    '$via1_multi_hash_spawns/3-3'(D, E)
	->  'spawns_all/2__5__1'(E, D, F, A, G, C, H, I)
	;   'spawns_all/2__5__0'(G, C, H, I)
	).
'spawns_all/2__5__1'([], _, _, _, A, B, C, D) :-
	'spawns_all/2__5__0'(A, B, C, D).
'spawns_all/2__5__1'([A|V], C, E, W, X, D, U, Q) :-
	(   A=suspension(_, active, _, _, K, L, B),
	    B==C,
	    \+is_passive(D, E)
	->  setarg(2, A, removed),
	    arg(4, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', H),
		(   H=[I|_]
		->  setarg(4, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(4, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', J),
	    delete_ht(J, k(K, L), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', M),
	    delete_ht(M, K, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', N),
	    delete_ht(N, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', O),
	    delete_ht(O, k(K, C), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', P),
	    delete_ht(P, k(K, L, C), A),
	    arg(2, Q, R),
	    setarg(2, Q, active),
	    (   R==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', S),
		insert_ht(S, D, Q),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-12', T),
		insert_ht(T, k(D, U), Q)
	    ;   true
	    ),
	    spawns_all(K, L),
	    (   Q=suspension(_, active, _, _)
	    ->  setarg(2, Q, inactive),
		'spawns_all/2__5__1'(V, C, E, W, X, D, U, Q)
	    ;   true
	    )
	;   'spawns_all/2__5__1'(V, C, E, W, X, D, U, Q)
	).
'spawns_all/2__5'(B, C, A) :-
	A=suspension(D, not_stored_yet, B, C),
	'chr gen_id'(D),
	'spawns_all/2__6'(B, C, A).
'spawns_all/2__6'(A, C, D) :-
	'$via1_multi_hash_occurrence/5-3'(A, B), !,
	'spawns_all/2__6__0'(B, A, C, D).
'spawns_all/2__6__0'([], A, B, C) :-
	'spawns_all/2__7'(A, B, C).
'spawns_all/2__6__0'([A|K], C, J, F) :-
	(   A=suspension(_, active, _, _, E, _, B, D, _),
	    B==C,
	    \+ \+spawns_all_triggers_implies_spawns_all,
	    \+is_passive(C, D),
	    may_trigger(E)
	->  arg(2, F, G),
	    setarg(2, F, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', H),
		insert_ht(H, C, F),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-12', I),
		insert_ht(I, k(C, J), F)
	    ;   true
	    ),
	    spawns_all_triggers_implies_spawns_all,
	    (   F=suspension(_, active, _, _)
	    ->  setarg(2, F, inactive),
		'spawns_all/2__6__0'(K, C, J, F)
	    ;   true
	    )
	;   'spawns_all/2__6__0'(K, C, J, F)
	).
'spawns_all/2__6'(A, B, C) :-
	'spawns_all/2__7'(A, B, C).
'spawns_all/2__7'(D, F, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-1', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all/2-12', E),
	    insert_ht(E, k(D, F), A)
	;   true
	).
spawns_all_triggers(A, B) :-
	'spawns_all_triggers/2__0'(A, B, _).
'spawns_all_triggers/2__0'(A, B, _) :-
	'$via1_multi_hash_spawns_all_triggers/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _), !.
'spawns_all_triggers/2__0'(A, body, _) :-
	'$via1_multi_hash_spawns_all_triggers/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D),
	D=guard, !.
'spawns_all_triggers/2__0'(A, guard, C) :-
	'$via1_multi_hash_spawns_all_triggers/2-1'(A, B), !,
	'spawns_all_triggers/2__0__0'(B, A, guard, C).
'spawns_all_triggers/2__0__0'([], A, B, C) :-
	'spawns_all_triggers/2__1'(A, B, C).
'spawns_all_triggers/2__0__0'([A|L], C, M, N) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D=body
	->  setarg(2, A, removed),
	    arg(4, A, E),
	    (   var(E)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', F),
		F=[_|G],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', G),
		(   G=[H|_]
		->  setarg(4, H, _)
		;   true
		)
	    ;   E=[_, _|G],
		setarg(2, E, G),
		(   G=[H|_]
		->  setarg(4, H, E)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', I),
	    delete_ht(I, C, A),
	    arg(6, A, K),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', J),
	    delete_ht(J, k(C, K), A),
	    'spawns_all_triggers/2__0__0'(L, C, M, N)
	;   'spawns_all_triggers/2__0__0'(L, C, M, N)
	).
'spawns_all_triggers/2__0'(A, B, C) :-
	'spawns_all_triggers/2__1'(A, B, C).
'spawns_all_triggers/2__1'(A, B, E) :-
	'$via1_multi_hash_spawns_all/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !,
	(   var(E)
	->  true
	;   arg(2, E, F),
	    setarg(2, E, removed),
	    (   F==not_stored_yet
	    ->  true
	    ;   arg(4, E, G),
		(   var(G)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', H),
		    H=[_|I],
		    b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', I),
		    (   I=[J|_]
		    ->  setarg(4, J, _)
		    ;   true
		    )
		;   G=[_, _|I],
		    setarg(2, G, I),
		    (   I=[J|_]
		    ->  setarg(4, J, G)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', K),
		delete_ht(K, A, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', L),
		delete_ht(L, k(A, B), E)
	    )
	).
'spawns_all_triggers/2__1'(A, body, E) :-
	'$via1_multi_hash_spawns_all/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, D),
	D=guard, !,
	(   var(E)
	->  true
	;   arg(2, E, F),
	    setarg(2, E, removed),
	    (   F==not_stored_yet
	    ->  true
	    ;   arg(4, E, G),
		(   var(G)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', H),
		    H=[_|I],
		    b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', I),
		    (   I=[J|_]
		    ->  setarg(4, J, _)
		    ;   true
		    )
		;   G=[_, _|I],
		    setarg(2, G, I),
		    (   I=[J|_]
		    ->  setarg(4, J, G)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', K),
		delete_ht(K, A, E),
		arg(6, E, M),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', L),
		delete_ht(L, k(A, M), E)
	    )
	).
'spawns_all_triggers/2__1'(A, B, D) :-
	'$via1_multi_hash_spawns/3-12'(k(A, B), C), !,
	'spawns_all_triggers/2__1__0'(C, A, B, D).
'spawns_all_triggers/2__1__0'([], A, B, C) :-
	'spawns_all_triggers/2__2'(A, B, C).
'spawns_all_triggers/2__1__0'([A|P], C, E, Q) :-
	(   A=suspension(_, active, _, _, B, D, F),
	    B==C,
	    D==E,
	    may_trigger(F)
	->  setarg(2, A, removed),
	    arg(4, A, G),
	    (   var(G)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', H),
		H=[_|I],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', I),
		(   I=[J|_]
		->  setarg(4, J, _)
		;   true
		)
	    ;   G=[_, _|I],
		setarg(2, G, I),
		(   I=[J|_]
		->  setarg(4, J, G)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', K),
	    delete_ht(K, k(C, E), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', L),
	    delete_ht(L, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', M),
	    delete_ht(M, F, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', N),
	    delete_ht(N, k(C, F), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', O),
	    delete_ht(O, k(C, E, F), A),
	    'spawns_all_triggers/2__1__0'(P, C, E, Q)
	;   'spawns_all_triggers/2__1__0'(P, C, E, Q)
	).
'spawns_all_triggers/2__1'(A, B, C) :-
	'spawns_all_triggers/2__2'(A, B, C).
'spawns_all_triggers/2__2'(A, guard, C) :-
	'$via1_multi_hash_spawns/3-1'(A, B), !,
	'spawns_all_triggers/2__2__0'(B, A, guard, C).
'spawns_all_triggers/2__2__0'([], A, B, C) :-
	'spawns_all_triggers/2__3'(A, B, C).
'spawns_all_triggers/2__2__0'([A|Q], C, R, S) :-
	(   A=suspension(_, active, _, _, B, D, E),
	    B==C,
	    D=body,
	    may_trigger(E)
	->  setarg(2, A, removed),
	    arg(4, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', H),
		(   H=[I|_]
		->  setarg(4, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(4, I, F)
		;   true
		)
	    ),
	    arg(6, A, K),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', J),
	    delete_ht(J, k(C, K), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', L),
	    delete_ht(L, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', M),
	    delete_ht(M, E, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', N),
	    delete_ht(N, k(C, E), A),
	    arg(6, A, P),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', O),
	    delete_ht(O, k(C, P, E), A),
	    'spawns_all_triggers/2__2__0'(Q, C, R, S)
	;   'spawns_all_triggers/2__2__0'(Q, C, R, S)
	).
'spawns_all_triggers/2__2'(A, B, C) :-
	'spawns_all_triggers/2__3'(A, B, C).
'spawns_all_triggers/2__3'(J, L, C) :-
	nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !,
	(   var(C)
	->  true
	;   arg(2, C, D),
	    setarg(2, C, removed),
	    (   D==not_stored_yet
	    ->  true
	    ;   arg(4, C, E),
		(   var(E)
		->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', F),
		    F=[_|G],
		    b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', G),
		    (   G=[H|_]
		    ->  setarg(4, H, _)
		    ;   true
		    )
		;   E=[_, _|G],
		    setarg(2, E, G),
		    (   G=[H|_]
		    ->  setarg(4, H, E)
		    ;   true
		    )
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', I),
		delete_ht(I, J, C),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', K),
		delete_ht(K, k(J, L), C)
	    )
	),
	spawns_all(J, L).
'spawns_all_triggers/2__3'(A, C, B) :-
	'$via1_multi_hash_occurrence/5-3'(A, E), !,
	B=suspension(D, not_stored_yet, t, _, A, C),
	'chr gen_id'(D),
	'spawns_all_triggers/2__3__0'(E, A, C, B).
'spawns_all_triggers/2__3__0'([], A, B, C) :-
	'spawns_all_triggers/2__4'(A, B, C).
'spawns_all_triggers/2__3__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, _, D, _, B, F, _),
	    B==C,
	    '$via1_multi_hash_spawns/3-3'(D, E)
	->  'spawns_all_triggers/2__3__1'(E, D, F, A, G, C, H, I)
	;   'spawns_all_triggers/2__3__0'(G, C, H, I)
	).
'spawns_all_triggers/2__3__1'([], _, _, _, A, B, C, D) :-
	'spawns_all_triggers/2__3__0'(A, B, C, D).
'spawns_all_triggers/2__3__1'([A|Y], C, E, Z, A1, D, X, Q) :-
	(   A=suspension(_, active, _, _, K, L, B),
	    B==C,
	    \+is_passive(D, E)
	->  setarg(2, A, removed),
	    arg(4, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns/3', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:spawns/3', H),
		(   H=[I|_]
		->  setarg(4, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(4, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-12', J),
	    delete_ht(J, k(K, L), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-1', M),
	    delete_ht(M, K, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-3', N),
	    delete_ht(N, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-13', O),
	    delete_ht(O, k(K, C), A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns/3-123', P),
	    delete_ht(P, k(K, L, C), A),
	    arg(2, Q, R),
	    setarg(2, Q, active),
	    (   R==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', S),
		T=[Q|S],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', T),
		(   S=[U|_]
		->  setarg(4, U, T)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', V),
		insert_ht(V, D, Q),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', W),
		insert_ht(W, k(D, X), Q)
	    ;   true
	    ),
	    spawns_all_triggers(K, L),
	    (   Q=suspension(_, active, _, _, _, _)
	    ->  setarg(2, Q, inactive),
		'spawns_all_triggers/2__3__1'(Y, C, E, Z, A1, D, X, Q)
	    ;   true
	    )
	;   'spawns_all_triggers/2__3__1'(Y, C, E, Z, A1, D, X, Q)
	).
'spawns_all_triggers/2__3'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, _, B, C),
	'chr gen_id'(D),
	'spawns_all_triggers/2__4'(B, C, A).
'spawns_all_triggers/2__4'(B, C, D) :-
	nb_getval('$chr_store_global_ground_chr_translate:spawns/3', A), !,
	'spawns_all_triggers/2__4__0'(A, B, C, D).
'spawns_all_triggers/2__4__0'([], A, B, C) :-
	'spawns_all_triggers/2__5'(A, B, C).
'spawns_all_triggers/2__4__0'([A|E], F, G, H) :-
	(   A=suspension(_, active, _, _, B, _, D),
	    '$via1_multi_hash_occurrence/5-3'(B, C)
	->  'spawns_all_triggers/2__4__1'(C, B, D, A, E, F, G, H)
	;   'spawns_all_triggers/2__4__0'(E, F, G, H)
	).
'spawns_all_triggers/2__4__1'([], _, _, _, A, B, C, D) :-
	'spawns_all_triggers/2__4__0'(A, B, C, D).
'spawns_all_triggers/2__4__1'([A|R], C, I, D, S, O, Q, E) :-
	(   A=suspension(_, active, _, _, H, _, B, G, _),
	    B==C,
	    F=t(106, D, A, E),
	    '$novel_production'(D, F),
	    '$novel_production'(E, F),
	    \+is_passive(C, G),
	    may_trigger(H),
	    \+may_trigger(I)
	->  '$extend_history'(E, F),
	    arg(2, E, J),
	    setarg(2, E, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', K),
		L=[E|K],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', L),
		(   K=[M|_]
		->  setarg(4, M, L)
		;   true
		),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', N),
		insert_ht(N, O, E),
		nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', P),
		insert_ht(P, k(O, Q), E)
	    ;   true
	    ),
	    spawns(O, Q, I),
	    (   E=suspension(_, active, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'spawns_all_triggers/2__4__1'(R, C, I, D, S, O, Q, E)
	    ;   true
	    )
	;   'spawns_all_triggers/2__4__1'(R, C, I, D, S, O, Q, E)
	).
'spawns_all_triggers/2__4'(A, B, C) :-
	'spawns_all_triggers/2__5'(A, B, C).
'spawns_all_triggers/2__5'(G, I, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', D),
	    (   C=[E|_]
	    ->  setarg(4, E, D)
	    ;   true
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', F),
	    insert_ht(F, G, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', H),
	    insert_ht(H, k(G, I), A)
	;   true
	).
spawns_all_triggers_implies_spawns_all :-
	'spawns_all_triggers_implies_spawns_all/0__0'(_).
'spawns_all_triggers_implies_spawns_all/0__0'(_) :-
	nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	fail.
'spawns_all_triggers_implies_spawns_all/0__0'(A) :-
	nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', C), !,
	A=suspension(B, not_stored_yet, _),
	'chr gen_id'(B),
	'spawns_all_triggers_implies_spawns_all/0__0__0'(C, A).
'spawns_all_triggers_implies_spawns_all/0__0__0'([], A) :-
	'spawns_all_triggers_implies_spawns_all/0__1'(A).
'spawns_all_triggers_implies_spawns_all/0__0__0'([A|O], J) :-
	(   A=suspension(_, active, _, _, G, I)
	->  setarg(2, A, removed),
	    arg(4, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers/2', D),
		(   D=[E|_]
		->  setarg(4, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(4, E, B)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-1', F),
	    delete_ht(F, G, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:spawns_all_triggers/2-12', H),
	    delete_ht(H, k(G, I), A),
	    arg(2, J, K),
	    setarg(2, J, active),
	    (   K==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', L),
		M=[J|L],
		b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', M),
		(   L=[N|_]
		->  setarg(3, N, M)
		;   true
		)
	    ;   true
	    ),
	    spawns_all(G, I),
	    (   J=suspension(_, active, _)
	    ->  setarg(2, J, inactive),
		'spawns_all_triggers_implies_spawns_all/0__0__0'(O, J)
	    ;   true
	    )
	;   'spawns_all_triggers_implies_spawns_all/0__0__0'(O, J)
	).
'spawns_all_triggers_implies_spawns_all/0__0'(A) :-
	A=suspension(B, not_stored_yet, _),
	'chr gen_id'(B),
	'spawns_all_triggers_implies_spawns_all/0__1'(A).
'spawns_all_triggers_implies_spawns_all/0__1'(A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:spawns_all_triggers_implies_spawns_all/0', D),
	    (   C=[E|_]
	    ->  setarg(3, E, D)
	    ;   true
	    )
	;   true
	).
all_spawned(A, _) :-
	'$via1_multi_hash_spawns_all/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, D),
	D=guard, !.
all_spawned(A, B) :-
	'$via1_multi_hash_spawns_all/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
all_spawned(_, _) :-
	fail.
is_observed(A, B, F) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, _, _), !,
	do_is_observed(A, E, F).
is_observed(_, _, _) :-
	throw('this cannot happen?').
do_is_observed(A, G, K) :-
	'$via1_multi_hash_occurrence/5-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, _, D, _, _),
	'$via1_multi_hash_occurrence/5-3'(D, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, _, _, _, J, _),
	F\==C,
	'$via1_multi_hash_spawns_all/2-1'(G, H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, L),
	\+is_passive(D, J), !,
	K=L.
do_is_observed(A, G, L) :-
	'$via1_multi_hash_occurrence/5-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, _, D, _, _),
	'$via1_multi_hash_occurrence/5-3'(D, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, H, _, _, K, _),
	F\==C,
	'$via1_multi_hash_spawns/3-13'(k(G, H), I),
	'chr sbag_member'(J, I),
	J=suspension(_, active, _, _, _, M, _),
	\+is_passive(D, K), !,
	L=M.
do_is_observed(A, G, L) :-
	'$via1_multi_hash_occurrence/5-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, _, D, _, _),
	'$via1_multi_hash_occurrence/5-3'(D, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, K, _, _, J, _),
	F\==C,
	'$via1_multi_hash_spawns_all_triggers/2-1'(G, H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, _, _, M),
	\+is_passive(D, J),
	may_trigger(K), !,
	L=M.
do_is_observed(_, _, _) :-
	chr_pp_flag(observation_analysis, off).
generate_indexed_variables_body(D/E, G, H, I) :-
	nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _, C, J),
	C=D/E, !,
	get_indexing_spec(D/E, F),
	(   chr_pp_flag(term_indexing, on)
	->  spectermvars(F, G, D, E, H, I)
	;   get_constraint_type_det(D/E, K),
	    create_indexed_variables_body(G, J, K, I, 1, D/E, L, M),
	    (   L==empty
	    ->  H=true,
		I=[]
	    ;   M==0
	    ->  (   G=[N]
		->  true
		;   N=..[term|G]
		),
		H=term_variables(N, I)
	    ;   L=H
	    )
	).
generate_indexed_variables_body(A, _, _, _) :-
	chr_error(internal, 'generate_indexed_variables_body: missing mode info for ~w.\n', [A]).
module_initializer(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:module_initializer/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:module_initializer/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
module_initializers(G) :-
	nb_getval('$chr_store_global_ground_chr_translate:module_initializer/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, H), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:module_initializer/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:module_initializer/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	G= (H, I),
	module_initializers(I).
module_initializers(true).
prolog_global_variable(A) :-
	'$via1_multi_hash_prolog_global_variable/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _), !.
prolog_global_variable(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	),
	nb_getval('$chr_store_multi_hash_chr_translate:prolog_global_variable/1-1', G),
	insert_ht(G, A, C).
prolog_global_variables(I) :-
	nb_getval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, H), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:prolog_global_variable/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	nb_getval('$chr_store_multi_hash_chr_translate:prolog_global_variable/1-1', G),
	delete_ht(G, H, B),
	I=[H|J],
	prolog_global_variables(J).
prolog_global_variables([]).
prev_guard_list(A, B, C, D, E, F, G) :-
	'prev_guard_list/7__0'(A, B, C, D, E, F, G, _).
'prev_guard_list/7__0'(U, A, I, W, P, N, O, _) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D),
	D=pragma(rule(E, F, M, _), _, _, _, A),
	E\==[],
	append(E, F, G),
	make_head_matchings_explicit(G, H, L),
	setof(J, chr_translate:head_subset(H, I, J), K), !,
	compute_derived_info(K, L, H, G, M, N, I, O, Q, S),
	append(P, Q, R),
	normalize_conj_list(R, X),
	append(S, O, T),
	normalize_conj_list(T, Y),
	V is A-1,
	prev_guard_list(U, V, I, W, X, N, Y).
'prev_guard_list/7__0'(B, A, D, E, F, G, H, _) :-
	A>0, !,
	C is A-1,
	prev_guard_list(B, C, D, E, F, G, H).
'prev_guard_list/7__0'(H, 0, B, I, F, K, A, _) :-
	A\==[], !,
	head_types_modes_condition(A, B, C),
	conj2list(C, E),
	term_variables(B, D),
	append([chr_pp_headvariables(D)|E], F, G),
	normalize_conj_list(G, J),
	prev_guard_list(H, 0, B, I, J, K, []).
'prev_guard_list/7__0'(A, 0, V, E, G, F, _, _) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D),
	D=pragma(rule(P, Q, E, H), S, T, U, A),
	E\==true,
	append(F, G, I),
	simplify_guard(E, H, I, J, R),
	E\==J, !,
	setarg(2, C, removed),
	arg(4, C, K),
	(   var(K)
	->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_ground_chr_translate:rule/2', M),
	    (   M=[N|_]
	    ->  setarg(4, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(4, N, K)
	    ;   true
	    )
	),
	nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', O),
	delete_ht(O, A, C),
	rule(A, pragma(rule(P, Q, J, R), S, T, U, A)),
	prev_guard_list(A, 0, V, J, G, F, []).
'prev_guard_list/7__0'(A, 0, _, E, G, F, _, _) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D),
	chr_pp_flag(check_impossible_rules, on),
	D=pragma(rule(_, _, E, _), _, _, _, A),
	append(F, G, H),
	guard_entailment:entails_guard(H, fail), !,
	chr_warning(weird_program, 'Heads will never match in ~@.\n\tThis rule will never fire!\n', [format_rule(D)]),
	set_all_passive(A).
'prev_guard_list/7__0'(A, 0, C, D, E, F, G, B) :-
	'$via1_multi_hash_rule/2-1'(A, I), !,
	B=suspension(H, not_stored_yet, t, A, 0, C, D, E, F, G),
	'chr gen_id'(H),
	'prev_guard_list/7__0__0'(I, A, 0, C, D, E, F, G, B).
'prev_guard_list/7__0__0'([], A, B, C, D, E, F, G, H) :-
	'prev_guard_list/7__1'(A, B, C, D, E, F, G, H).
'prev_guard_list/7__0__0'([A|L1], C, I1, L, E, G, F, M1, F1) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D=pragma(rule(J, K, E, H), X, Y, Z, C),
	    simplify_heads(F, G, E, H, I, R),
	    I\==[],
	    extract_arguments(J, M),
	    extract_arguments(K, N),
	    extract_arguments(L, O),
	    replace_some_heads(M, N, O, I, P, Q, E, H, S),
	    substitute_arguments(J, P, U),
	    substitute_arguments(K, Q, V),
	    append(R, S, T),
	    list2conj(T, W),
	    K1=pragma(rule(U, V, E, (W, H)), X, Y, Z, C),
	    (   J\==U
	    ;   K\==V
	    )
	->  setarg(2, A, removed),
	    arg(4, A, A1),
	    (   var(A1)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:rule/2', B1),
		B1=[_|C1],
		b_setval('$chr_store_global_ground_chr_translate:rule/2', C1),
		(   C1=[D1|_]
		->  setarg(4, D1, _)
		;   true
		)
	    ;   A1=[_, _|C1],
		setarg(2, A1, C1),
		(   C1=[D1|_]
		->  setarg(4, D1, A1)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:rule/2-1', E1),
	    delete_ht(E1, C, A),
	    arg(2, F1, G1),
	    setarg(2, F1, active),
	    (   G1==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', H1),
		insert_ht(H1, I1, F1),
		nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', J1),
		insert_ht(J1, C, F1)
	    ;   true
	    ),
	    rule(C, K1),
	    (   F1=suspension(_, active, _, _, _, _, _, _, _, _)
	    ->  setarg(2, F1, inactive),
		'prev_guard_list/7__0__0'(L1, C, I1, L, E, G, F, M1, F1)
	    ;   true
	    )
	;   'prev_guard_list/7__0__0'(L1, C, I1, L, E, G, F, M1, F1)
	).
'prev_guard_list/7__0'(B, C, D, E, F, G, H, A) :-
	A=suspension(I, not_stored_yet, t, B, C, D, E, F, G, H),
	'chr gen_id'(I),
	'prev_guard_list/7__1'(B, C, D, E, F, G, H, A).
'prev_guard_list/7__1'(A, 0, C, D, E, F, G, H) :-
	'$via1_multi_hash_rule/2-1'(A, B), !,
	'prev_guard_list/7__1__0'(B, A, 0, C, D, E, F, G, H).
'prev_guard_list/7__1__0'([], A, B, C, D, E, F, G, H) :-
	'prev_guard_list/7__2'(A, B, C, D, E, F, G, H).
'prev_guard_list/7__1__0'([A|M], C, K, N, G, O, P, Q, D) :-
	(   A=suspension(_, active, _, _, B, F),
	    B==C,
	    E=t(133, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E),
	    chr_pp_flag(check_impossible_rules, on),
	    F=pragma(rule(_, _, G, _), _, _, _, C),
	    conj2list(G, H),
	    guard_entailment:entails_guard(H, fail)
	->  '$extend_history'(D, E),
	    arg(2, D, I),
	    setarg(2, D, active),
	    (   I==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', J),
		insert_ht(J, K, D),
		nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', L),
		insert_ht(L, C, D)
	    ;   true
	    ),
	    chr_warning(weird_program, 'Guard will always fail in ~@.\n\tThis rule will never fire!\n', [format_rule(F)]),
	    set_all_passive(C),
	    (   D=suspension(_, active, _, _, _, _, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'prev_guard_list/7__1__0'(M, C, K, N, G, O, P, Q, D)
	    ;   true
	    )
	;   'prev_guard_list/7__1__0'(M, C, K, N, G, O, P, Q, D)
	).
'prev_guard_list/7__1'(A, B, C, D, E, F, G, H) :-
	'prev_guard_list/7__2'(A, B, C, D, E, F, G, H).
'prev_guard_list/7__2'(A, 0, C, D, E, F, G, H) :-
	'$via1_multi_hash_rule/2-1'(A, B), !,
	'prev_guard_list/7__2__0'(B, A, 0, C, D, E, F, G, H).
'prev_guard_list/7__2__0'([], A, B, C, D, E, F, G, H) :-
	'prev_guard_list/7__3'(A, B, C, D, E, F, G, H).
'prev_guard_list/7__2__0'([A|F], C, G, H, I, J, K, L, M) :-
	(   A=suspension(_, active, _, _, B, E),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', D)
	->  'prev_guard_list/7__2__1'(D, E, A, F, C, G, H, I, J, K, L, M)
	;   'prev_guard_list/7__2__0'(F, C, G, H, I, J, K, L, M)
	).
'prev_guard_list/7__2__1'([], _, _, A, B, C, D, E, F, G, H, I) :-
	'prev_guard_list/7__2__0'(A, B, C, D, E, F, G, H, I).
'prev_guard_list/7__2__1'([A|W], J, X, Y, B, T, Z, A1, B1, C1, D1, Q) :-
	(   A=suspension(_, active, _, L),
	    ground(B),
	    '$via1_multi_hash_occurrence/5-3'(B, C),
	    'chr sbag_member'(D, C),
	    D=suspension(_, active, _, _, E, H, _, V, _),
	    ground(B),
	    '$via1_multi_hash_occurrence/5-13'(k(E, B), F),
	    'chr sbag_member'(G, F),
	    G=suspension(_, active, _, _, _, I, _, _, _),
	    G\==D,
	    H<I,
	    chr_pp_flag(occurrence_subsumption, on),
	    J=pragma(rule(K, _, _, _), _, _, _, B),
	    K\==[],
	    \+memberchk_eq(E, L)
	->  setarg(2, A, removed),
	    arg(3, A, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', N),
		N=[_|O],
		b_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    arg(2, Q, R),
	    setarg(2, Q, active),
	    (   R==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', S),
		insert_ht(S, T, Q),
		nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', U),
		insert_ht(U, B, Q)
	    ;   true
	    ),
	    first_occ_in_rule(B, E, H, V),
	    multiple_occ_constraints_checked([E|L]),
	    (   Q=suspension(_, active, _, _, _, _, _, _, _, _)
	    ->  setarg(2, Q, inactive),
		'prev_guard_list/7__2__1'(W, J, X, Y, B, T, Z, A1, B1, C1, D1, Q)
	    ;   true
	    )
	;   'prev_guard_list/7__2__1'(W, J, X, Y, B, T, Z, A1, B1, C1, D1, Q)
	).
'prev_guard_list/7__2'(A, B, C, D, E, F, G, H) :-
	'prev_guard_list/7__3'(A, B, C, D, E, F, G, H).
'prev_guard_list/7__3'(L, 0, _, _, _, _, _, G) :-
	nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	(   var(G)
	->  true
	;   arg(2, G, H),
	    setarg(2, G, removed),
	    (   H==not_stored_yet
	    ->  true
	    ;   arg(5, G, J),
		nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', I),
		delete_ht(I, J, G),
		nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', K),
		delete_ht(K, L, G)
	    )
	).
'prev_guard_list/7__3'(F, D, _, _, _, _, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', E),
	    insert_ht(E, F, A)
	;   true
	).
simplify_guards(A) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D), !,
	D=pragma(rule(E, F, H, _), _, _, _, A),
	append(E, F, G),
	make_head_matchings_explicit_not_negated(G, J, K),
	multiple_occ_constraints_checked([]),
	apply_guard_wrt_term(G, H, L),
	I is A-1,
	prev_guard_list(A, I, J, H, [], K, [L]),
	M is A+1,
	simplify_guards(M).
simplify_guards(_).
set_all_passive(A) :-
	'set_all_passive/1__0'(A, _).
'set_all_passive/1__0'(A, B) :-
	'$via1_multi_hash_occurrence/5-3'(A, D), !,
	B=suspension(C, not_stored_yet, t, A),
	'chr gen_id'(C),
	'set_all_passive/1__0__0'(D, A, B).
'set_all_passive/1__0__0'([], A, B) :-
	'set_all_passive/1__1'(A, B).
'set_all_passive/1__0__0'([A|I], C, D) :-
	(   A=suspension(_, active, _, _, _, _, B, H, _),
	    B==C,
	    E=t(131, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:set_all_passive/1-1', G),
		insert_ht(G, C, D)
	    ;   true
	    ),
	    passive(C, H),
	    (   D=suspension(_, active, _, _)
	    ->  setarg(2, D, inactive),
		'set_all_passive/1__0__0'(I, C, D)
	    ;   true
	    )
	;   'set_all_passive/1__0__0'(I, C, D)
	).
'set_all_passive/1__0'(B, A) :-
	A=suspension(C, not_stored_yet, t, B),
	'chr gen_id'(C),
	'set_all_passive/1__1'(B, A).
'set_all_passive/1__1'(D, A) :-
	(   var(A)
	->  true
	;   arg(2, A, B),
	    setarg(2, A, removed),
	    (   B==not_stored_yet
	    ->  true
	    ;   nb_getval('$chr_store_multi_hash_chr_translate:set_all_passive/1-1', C),
		delete_ht(C, D, A)
	    )
	).
first_occ_in_rule(B, A, F, _) :-
	'$via1_multi_hash_occurrence/5-13'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, _, G, _),
	E<F, !,
	first_occ_in_rule(B, A, E, G).
first_occ_in_rule(D, A, E, F) :-
	A=B/C,
	functor(G, B, C),
	next_occ_in_rule(D, A, E, F, [], G).
next_occ_in_rule(B, A, I, J, _, K) :-
	'$via1_multi_hash_occurrence/5-13'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, H, _, E, _),
	'$via1_multi_hash_passive/2-12'(k(B, E), F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _),
	H is I+1, !,
	next_occ_in_rule(B, A, H, J, _, K).
next_occ_in_rule(A, E, K, R, W, S) :-
	'$via1_multi_hash_prev_guard_list/7-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, D, Q, M, X, T, _),
	D=0,
	'$via1_multi_hash_occurrence/5-13'(k(E, A), F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, J, _, V, _),
	'$via1_multi_hash_rule/2-1'(A, H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, _, _, L),
	J is K+1,
	L=pragma(rule(N, O, M, _), ids(_, _), _, _, A), !,
	append(N, O, P),
	add_failing_occ(L, P, Q, R, U, S, T, E, Z),
	(   U==[chr_pp_void_info]
	->  next_occ_in_rule(A, E, J, V, W, S)
	;   append(U, W, D1),
	    add_failing_occ(L, P, Q, V, L1, S, T, E, A1),
	    copy_term(X, Y),
	    variable_replacement(X, Y, C1),
	    copy_with_variable_replacement(X, E1, Z),
	    copy_with_variable_replacement(X, B1, A1),
	    copy_with_variable_replacement(B1, G1, C1),
	    append(D1, E1, F1),
	    append(F1, G1, I1),
	    copy_with_variable_replacement(T, J1, Z),
	    copy_with_variable_replacement(T, H1, A1),
	    append(H1, I1, K1),
	    append([chr_pp_active_constraint(S)|J1], K1, M1),
	    list2conj(L1, N1),
	    copy_term((D1, I1, M1, N1, S), (_, _, O1, P1, _)),
	    (   N1\=chr_pp_void_info
	    ->  (   guard_entailment:entails_guard(O1, P1)
		->  passive(A, V)
		;   true
		)
	    ;   true
	    ), !,
	    next_occ_in_rule(A, E, J, V, D1, S)
	).
next_occ_in_rule(_, _, _, _, _, _).
multiple_occ_constraints_checked(P) :-
	nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _, G, J, C, Q, _),
	'$via1_multi_hash_prev_guard_list/7-1'(C, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, F, _, _, _, _, _),
	F=0,
	'$via1_multi_hash_occurrence/5-13'(k(G, C), H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, _, _, K, _, _, _),
	I\==B,
	J<K,
	'$via1_multi_hash_rule/2-1'(C, L),
	'chr sbag_member'(M, L),
	M=suspension(_, active, _, _, _, N),
	chr_pp_flag(occurrence_subsumption, on),
	N=pragma(rule(O, _, _, _), _, _, _, C),
	O\==[],
	\+memberchk_eq(G, P), !,
	first_occ_in_rule(C, G, J, Q),
	multiple_occ_constraints_checked([G|P]).
multiple_occ_constraints_checked(_) :-
	'$via1_multi_hash_prev_guard_list/7-2'(0, A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, F, _, _, _, _, _, _), !,
	setarg(2, B, removed),
	arg(5, B, D),
	nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-2', C),
	delete_ht(C, D, B),
	nb_getval('$chr_store_multi_hash_chr_translate:prev_guard_list/7-1', E),
	delete_ht(E, F, B).
multiple_occ_constraints_checked(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:multiple_occ_constraints_checked/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
type_definition(A, B) :-
	'type_definition/2__0'(A, B, _).
'type_definition/2__0'(E, _, P) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, F, _),
	functor(E, G, H),
	functor(F, G, H), !,
	D=suspension(_, _, _, _, _, I, J),
	setarg(2, D, removed),
	term_variables(term(I, J), O),
	arg(5, D, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:type_definition/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:type_definition/2', M),
	    (   M=[N|_]
	    ->  setarg(5, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(5, N, K)
	    ;   true
	    )
	),
	'detach_type_definition/2'(O, D),
	(   var(P)
	->  true
	;   P=suspension(_, Q, _, _, _, R, S),
	    setarg(2, P, removed),
	    (   Q==not_stored_yet
	    ->  T=[]
	    ;   term_variables(term(R, S), T),
		arg(5, P, U),
		(   var(U)
		->  nb_getval('$chr_store_global_list_chr_translate:type_definition/2', V),
		    V=[_|W],
		    b_setval('$chr_store_global_list_chr_translate:type_definition/2', W),
		    (   W=[X|_]
		    ->  setarg(5, X, _)
		    ;   true
		    )
		;   U=[_, _|W],
		    setarg(2, U, W),
		    (   W=[X|_]
		    ->  setarg(5, X, U)
		    ;   true
		    )
		),
		'detach_type_definition/2'(T, P)
	    )
	),
	chr_error(type_error, 'Multiple definitions for type: ~w/~w.\n', [G, H]).
'type_definition/2__0'(F, _, P) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, _),
	functor(E, G, H),
	functor(F, G, H), !,
	D=suspension(_, _, _, _, _, I, J),
	setarg(2, D, removed),
	term_variables(term(I, J), O),
	arg(5, D, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:type_definition/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:type_definition/2', M),
	    (   M=[N|_]
	    ->  setarg(5, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(5, N, K)
	    ;   true
	    )
	),
	'detach_type_definition/2'(O, D),
	(   var(P)
	->  true
	;   P=suspension(_, Q, _, _, _, R, S),
	    setarg(2, P, removed),
	    (   Q==not_stored_yet
	    ->  T=[]
	    ;   term_variables(term(R, S), T),
		arg(5, P, U),
		(   var(U)
		->  nb_getval('$chr_store_global_list_chr_translate:type_definition/2', V),
		    V=[_|W],
		    b_setval('$chr_store_global_list_chr_translate:type_definition/2', W),
		    (   W=[X|_]
		    ->  setarg(5, X, _)
		    ;   true
		    )
		;   U=[_, _|W],
		    setarg(2, U, W),
		    (   W=[X|_]
		    ->  setarg(5, X, U)
		    ;   true
		    )
		),
		'detach_type_definition/2'(T, P)
	    )
	),
	chr_error(type_error, 'Multiple definitions for type: ~w/~w.\n', [G, H]).
'type_definition/2__0'(E, _, P) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, F, _),
	functor(E, G, H),
	functor(F, G, H), !,
	D=suspension(_, _, _, _, _, I, J),
	setarg(2, D, removed),
	term_variables(term(I, J), O),
	arg(5, D, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:type_alias/2', M),
	    (   M=[N|_]
	    ->  setarg(5, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(5, N, K)
	    ;   true
	    )
	),
	'detach_type_alias/2'(O, D),
	(   var(P)
	->  true
	;   P=suspension(_, Q, _, _, _, R, S),
	    setarg(2, P, removed),
	    (   Q==not_stored_yet
	    ->  T=[]
	    ;   term_variables(term(R, S), T),
		arg(5, P, U),
		(   var(U)
		->  nb_getval('$chr_store_global_list_chr_translate:type_definition/2', V),
		    V=[_|W],
		    b_setval('$chr_store_global_list_chr_translate:type_definition/2', W),
		    (   W=[X|_]
		    ->  setarg(5, X, _)
		    ;   true
		    )
		;   U=[_, _|W],
		    setarg(2, U, W),
		    (   W=[X|_]
		    ->  setarg(5, X, U)
		    ;   true
		    )
		),
		'detach_type_definition/2'(T, P)
	    )
	),
	chr_error(type_error, 'Multiple definitions for type, once in a type definition and once as a type alias: ~w/~w.\n', [G, H]).
'type_definition/2__0'(E, F, D) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, _, C, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', C)
	), !,
	(   var(D)
	->  D=suspension(G, not_stored_yet, t, 0, _, E, F),
	    'chr gen_id'(G)
	;   true
	),
	'type_definition/2__0__0'(C, E, F, D).
'type_definition/2__0__0'([], A, B, C) :-
	'type_definition/2__1'(A, B, C).
'type_definition/2__0__0'([A|W], B, X, L) :-
	(   A=suspension(_, active, _, C, V),
	    nonvar(B),
	    functor(B, D, E),
	    functor(C, D, E)
	->  A=suspension(_, _, _, F, _),
	    setarg(2, A, removed),
	    term_variables(F, K),
	    arg(3, A, G),
	    (   var(G)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', H),
		H=[_|I],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', I),
		(   I=[J|_]
		->  setarg(3, J, _)
		;   true
		)
	    ;   G=[_, _|I],
		setarg(2, G, I),
		(   I=[J|_]
		->  setarg(3, J, G)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(K, A),
	    arg(2, L, O),
	    setarg(2, L, active),
	    arg(4, L, M),
	    N is M+1,
	    setarg(4, L, N),
	    (   O==not_stored_yet
	    ->  L=suspension(_, _, _, _, _, P, Q),
		term_variables(term(P, Q), U),
		nb_getval('$chr_store_global_list_chr_translate:type_definition/2', R),
		S=[L|R],
		b_setval('$chr_store_global_list_chr_translate:type_definition/2', S),
		(   R=[T|_]
		->  setarg(5, T, S)
		;   true
		),
		'attach_type_definition/2'(U, L)
	    ;   true
	    ),
	    V=C,
	    (   L=suspension(_, active, _, N, _, _, _)
	    ->  setarg(2, L, inactive),
		'type_definition/2__0__0'(W, B, X, L)
	    ;   true
	    )
	;   'type_definition/2__0__0'(W, B, X, L)
	).
'type_definition/2__0'(B, C, A) :-
	(   var(A)
	->  A=suspension(D, not_stored_yet, t, 0, _, B, C),
	    'chr gen_id'(D)
	;   true
	),
	'type_definition/2__1'(B, C, A).
'type_definition/2__1'(B, C, D) :-
	nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', A), !,
	'type_definition/2__1__0'(A, B, C, D).
'type_definition/2__1__0'([], A, B, C) :-
	'type_definition/2__2'(A, B, C).
'type_definition/2__1__0'([A|R], M, N, B) :-
	(   A=suspension(_, active, _, _),
	    C=t(184, B, A),
	    '$novel_production'(B, C),
	    '$novel_production'(A, C)
	->  '$extend_history'(B, C),
	    arg(2, B, F),
	    setarg(2, B, active),
	    arg(4, B, D),
	    E is D+1,
	    setarg(4, B, E),
	    (   F==not_stored_yet
	    ->  B=suspension(_, _, _, _, _, G, H),
		term_variables(term(G, H), L),
		nb_getval('$chr_store_global_list_chr_translate:type_definition/2', I),
		J=[B|I],
		b_setval('$chr_store_global_list_chr_translate:type_definition/2', J),
		(   I=[K|_]
		->  setarg(5, K, J)
		;   true
		),
		'attach_type_definition/2'(L, B)
	    ;   true
	    ),
	    copy_term_nat(M-N, O-P),
	    maplist(dynamic_type_check_clause(O), P, Q),
	    dynamic_type_check_clauses(Q),
	    (   B=suspension(_, active, _, E, _, _, _)
	    ->  setarg(2, B, inactive),
		'type_definition/2__1__0'(R, M, N, B)
	    ;   true
	    )
	;   'type_definition/2__1__0'(R, M, N, B)
	).
'type_definition/2__1'(A, B, C) :-
	'type_definition/2__2'(A, B, C).
'type_definition/2__2'(D, E, F) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, _, _, _, _, C)
	;   nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', C)
	), !,
	'type_definition/2__2__0'(C, D, E, F).
'type_definition/2__2__0'([], A, B, C) :-
	'type_definition/2__3'(A, B, C).
'type_definition/2__2__0'([A|X], C, V, L) :-
	(   A=suspension(_, active, _, B),
	    functor(B, D, E),
	    functor(C, D, E)
	->  A=suspension(_, _, _, F),
	    setarg(2, A, removed),
	    term_variables(F, K),
	    arg(3, A, G),
	    (   var(G)
	    ->  nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', H),
		H=[_|I],
		b_setval('$chr_store_global_list_chr_translate:atomic_type/1', I),
		(   I=[J|_]
		->  setarg(3, J, _)
		;   true
		)
	    ;   G=[_, _|I],
		setarg(2, G, I),
		(   I=[J|_]
		->  setarg(3, J, G)
		;   true
		)
	    ),
	    'detach_atomic_type/1'(K, A),
	    arg(2, L, O),
	    setarg(2, L, active),
	    arg(4, L, M),
	    N is M+1,
	    setarg(4, L, N),
	    (   O==not_stored_yet
	    ->  L=suspension(_, _, _, _, _, P, Q),
		term_variables(term(P, Q), U),
		nb_getval('$chr_store_global_list_chr_translate:type_definition/2', R),
		S=[L|R],
		b_setval('$chr_store_global_list_chr_translate:type_definition/2', S),
		(   R=[T|_]
		->  setarg(5, T, S)
		;   true
		),
		'attach_type_definition/2'(U, L)
	    ;   true
	    ),
	    forall(member(W, V), atomic(W)),
	    (   L=suspension(_, active, _, N, _, _, _)
	    ->  setarg(2, L, inactive),
		'type_definition/2__2__0'(X, C, V, L)
	    ;   true
	    )
	;   'type_definition/2__2__0'(X, C, V, L)
	).
'type_definition/2__2'(A, B, C) :-
	'type_definition/2__3'(A, B, C).
'type_definition/2__3'(_, _, A) :-
	arg(2, A, D),
	setarg(2, A, active),
	arg(4, A, B),
	C is B+1,
	setarg(4, A, C),
	(   D==not_stored_yet
	->  A=suspension(_, _, _, _, _, E, F),
	    term_variables(term(E, F), J),
	    nb_getval('$chr_store_global_list_chr_translate:type_definition/2', G),
	    H=[A|G],
	    b_setval('$chr_store_global_list_chr_translate:type_definition/2', H),
	    (   G=[I|_]
	    ->  setarg(5, I, H)
	    ;   true
	    ),
	    'attach_type_definition/2'(J, A)
	;   true
	).
type_alias(A, B) :-
	'type_alias/2__0'(A, B, _).
'type_alias/2__0'(B, A, G) :-
	nonvar(A),
	nonvar(B),
	functor(B, C, D),
	functor(A, C, D),
	copy_term((B, A), (F, E)),
	oneway_unification(E, F), !,
	(   var(G)
	->  true
	;   G=suspension(_, H, _, _, _, I, J),
	    setarg(2, G, removed),
	    (   H==not_stored_yet
	    ->  K=[]
	    ;   term_variables(term(I, J), K),
		arg(5, G, L),
		(   var(L)
		->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', M),
		    M=[_|N],
		    b_setval('$chr_store_global_list_chr_translate:type_alias/2', N),
		    (   N=[O|_]
		    ->  setarg(5, O, _)
		    ;   true
		    )
		;   L=[_, _|N],
		    setarg(2, L, N),
		    (   N=[O|_]
		    ->  setarg(5, O, L)
		    ;   true
		    )
		),
		'detach_type_alias/2'(K, G)
	    )
	),
	chr_error(type_error, 'Cyclic alias definition: "~w".\n', [B==A]).
'type_alias/2__0'(A, A1, P) :-
	nonvar(A),
	(   'chr newvia'([], B)
	->  get_attr(B, chr_translate, C),
	    C=v(_, _, D, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', D)
	),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, _, F, B1),
	nonvar(F),
	functor(A, G, H),
	functor(F, G, H),
	\+A\=F, !,
	E=suspension(_, _, _, _, _, I, J),
	setarg(2, E, removed),
	term_variables(term(I, J), O),
	arg(5, E, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:type_alias/2', M),
	    (   M=[N|_]
	    ->  setarg(5, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(5, N, K)
	    ;   true
	    )
	),
	'detach_type_alias/2'(O, E),
	(   var(P)
	->  true
	;   P=suspension(_, Q, _, _, _, R, S),
	    setarg(2, P, removed),
	    (   Q==not_stored_yet
	    ->  T=[]
	    ;   term_variables(term(R, S), T),
		arg(5, P, U),
		(   var(U)
		->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', V),
		    V=[_|W],
		    b_setval('$chr_store_global_list_chr_translate:type_alias/2', W),
		    (   W=[X|_]
		    ->  setarg(5, X, _)
		    ;   true
		    )
		;   U=[_, _|W],
		    setarg(2, U, W),
		    (   W=[X|_]
		    ->  setarg(5, X, U)
		    ;   true
		    )
		),
		'detach_type_alias/2'(T, P)
	    )
	),
	copy_term_nat(A, Y),
	copy_term_nat(F, Z),
	Y=Z,
	chr_error(type_error, 'Ambiguous type aliases: you have defined \n\t`~w\'\n\t`~w\'\n\tresulting in two definitions for "~w".\n', [A==A1, F==B1, Y]).
'type_alias/2__0'(A, B1, P) :-
	nonvar(A),
	(   'chr newvia'([], B)
	->  get_attr(B, chr_translate, C),
	    C=v(_, _, D, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', D)
	),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, _, F, A1),
	nonvar(F),
	functor(F, G, H),
	functor(A, G, H),
	\+F\=A, !,
	E=suspension(_, _, _, _, _, I, J),
	setarg(2, E, removed),
	term_variables(term(I, J), O),
	arg(5, E, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:type_alias/2', M),
	    (   M=[N|_]
	    ->  setarg(5, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(5, N, K)
	    ;   true
	    )
	),
	'detach_type_alias/2'(O, E),
	(   var(P)
	->  true
	;   P=suspension(_, Q, _, _, _, R, S),
	    setarg(2, P, removed),
	    (   Q==not_stored_yet
	    ->  T=[]
	    ;   term_variables(term(R, S), T),
		arg(5, P, U),
		(   var(U)
		->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', V),
		    V=[_|W],
		    b_setval('$chr_store_global_list_chr_translate:type_alias/2', W),
		    (   W=[X|_]
		    ->  setarg(5, X, _)
		    ;   true
		    )
		;   U=[_, _|W],
		    setarg(2, U, W),
		    (   W=[X|_]
		    ->  setarg(5, X, U)
		    ;   true
		    )
		),
		'detach_type_alias/2'(T, P)
	    )
	),
	copy_term_nat(F, Y),
	copy_term_nat(A, Z),
	Y=Z,
	chr_error(type_error, 'Ambiguous type aliases: you have defined \n\t`~w\'\n\t`~w\'\n\tresulting in two definitions for "~w".\n', [F==A1, A==B1, Y]).
'type_alias/2__0'(I, A, M) :-
	nonvar(A),
	(   'chr newvia'([], B)
	->  get_attr(B, chr_translate, C),
	    C=v(_, _, D, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', D)
	),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, _, F, J),
	nonvar(F),
	functor(F, G, H),
	functor(A, G, H),
	copy_term_nat((I, A, F, J), (V, K, L, W)),
	oneway_unification(K, L), !,
	(   var(M)
	->  true
	;   M=suspension(_, N, _, _, _, O, P),
	    setarg(2, M, removed),
	    (   N==not_stored_yet
	    ->  Q=[]
	    ;   term_variables(term(O, P), Q),
		arg(5, M, R),
		(   var(R)
		->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', S),
		    S=[_|T],
		    b_setval('$chr_store_global_list_chr_translate:type_alias/2', T),
		    (   T=[U|_]
		    ->  setarg(5, U, _)
		    ;   true
		    )
		;   R=[_, _|T],
		    setarg(2, R, T),
		    (   T=[U|_]
		    ->  setarg(5, U, R)
		    ;   true
		    )
		),
		'detach_type_alias/2'(Q, M)
	    )
	),
	chr_info(type_information, 'Inferring `~w\' from `~w\' and `~w\'.\n', [V==W, I==A, F==J]),
	type_alias(V, W).
'type_alias/2__0'(E, F, D) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	), !,
	(   var(D)
	->  D=suspension(G, not_stored_yet, t, 0, _, E, F),
	    'chr gen_id'(G)
	;   true
	),
	'type_alias/2__0__0'(C, E, F, D).
'type_alias/2__0__0'([], A, B, C) :-
	'type_alias/2__1'(A, B, C).
'type_alias/2__0__0'([A|C1], C, G, Q) :-
	(   A=suspension(_, active, _, _, _, F, B),
	    nonvar(B),
	    nonvar(C),
	    functor(C, D, E),
	    functor(B, D, E),
	    copy_term_nat((F, B, C, G), (A1, H, I, B1)),
	    oneway_unification(H, I)
	->  A=suspension(_, _, _, _, _, J, K),
	    setarg(2, A, removed),
	    term_variables(term(J, K), P),
	    arg(5, A, L),
	    (   var(L)
	    ->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', M),
		M=[_|N],
		b_setval('$chr_store_global_list_chr_translate:type_alias/2', N),
		(   N=[O|_]
		->  setarg(5, O, _)
		;   true
		)
	    ;   L=[_, _|N],
		setarg(2, L, N),
		(   N=[O|_]
		->  setarg(5, O, L)
		;   true
		)
	    ),
	    'detach_type_alias/2'(P, A),
	    arg(2, Q, T),
	    setarg(2, Q, active),
	    arg(4, Q, R),
	    S is R+1,
	    setarg(4, Q, S),
	    (   T==not_stored_yet
	    ->  Q=suspension(_, _, _, _, _, U, V),
		term_variables(term(U, V), Z),
		nb_getval('$chr_store_global_list_chr_translate:type_alias/2', W),
		X=[Q|W],
		b_setval('$chr_store_global_list_chr_translate:type_alias/2', X),
		(   W=[Y|_]
		->  setarg(5, Y, X)
		;   true
		),
		'attach_type_alias/2'(Z, Q)
	    ;   true
	    ),
	    chr_info(type_information, 'Inferring `~w\' from `~w\' and `~w\'.\n', [A1==B1, F==B, C==G]),
	    type_alias(A1, B1),
	    (   Q=suspension(_, active, _, S, _, _, _)
	    ->  setarg(2, Q, inactive),
		'type_alias/2__0__0'(C1, C, G, Q)
	    ;   true
	    )
	;   'type_alias/2__0__0'(C1, C, G, Q)
	).
'type_alias/2__0'(B, C, A) :-
	(   var(A)
	->  A=suspension(D, not_stored_yet, t, 0, _, B, C),
	    'chr gen_id'(D)
	;   true
	),
	'type_alias/2__1'(B, C, A).
'type_alias/2__1'(F, _, P) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, _),
	functor(E, G, H),
	functor(F, G, H), !,
	D=suspension(_, _, _, _, _, I, J),
	setarg(2, D, removed),
	term_variables(term(I, J), O),
	arg(5, D, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:type_definition/2', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:type_definition/2', M),
	    (   M=[N|_]
	    ->  setarg(5, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(5, N, K)
	    ;   true
	    )
	),
	'detach_type_definition/2'(O, D),
	(   var(P)
	->  true
	;   P=suspension(_, Q, _, _, _, R, S),
	    setarg(2, P, removed),
	    (   Q==not_stored_yet
	    ->  T=[]
	    ;   term_variables(term(R, S), T),
		arg(5, P, U),
		(   var(U)
		->  nb_getval('$chr_store_global_list_chr_translate:type_alias/2', V),
		    V=[_|W],
		    b_setval('$chr_store_global_list_chr_translate:type_alias/2', W),
		    (   W=[X|_]
		    ->  setarg(5, X, _)
		    ;   true
		    )
		;   U=[_, _|W],
		    setarg(2, U, W),
		    (   W=[X|_]
		    ->  setarg(5, X, U)
		    ;   true
		    )
		),
		'detach_type_alias/2'(T, P)
	    )
	),
	chr_error(type_error, 'Multiple definitions for type, once in a type definition and once as a type alias: ~w/~w.\n', [G, H]).
'type_alias/2__1'(D, E, F) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, _, C, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', C)
	), !,
	'type_alias/2__1__0'(C, D, E, F).
'type_alias/2__1__0'([], A, B, C) :-
	'type_alias/2__2'(A, B, C).
'type_alias/2__1__0'([A|Z], B, F, N) :-
	(   A=suspension(_, active, _, C, Y),
	    nonvar(B),
	    functor(B, D, E),
	    functor(C, D, E),
	    copy_term_nat((B, F), (G, X)),
	    C=G
	->  A=suspension(_, _, _, H, _),
	    setarg(2, A, removed),
	    term_variables(H, M),
	    arg(3, A, I),
	    (   var(I)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', J),
		J=[_|K],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', K),
		(   K=[L|_]
		->  setarg(3, L, _)
		;   true
		)
	    ;   I=[_, _|K],
		setarg(2, I, K),
		(   K=[L|_]
		->  setarg(3, L, I)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(M, A),
	    arg(2, N, Q),
	    setarg(2, N, active),
	    arg(4, N, O),
	    P is O+1,
	    setarg(4, N, P),
	    (   Q==not_stored_yet
	    ->  N=suspension(_, _, _, _, _, R, S),
		term_variables(term(R, S), W),
		nb_getval('$chr_store_global_list_chr_translate:type_alias/2', T),
		U=[N|T],
		b_setval('$chr_store_global_list_chr_translate:type_alias/2', U),
		(   T=[V|_]
		->  setarg(5, V, U)
		;   true
		),
		'attach_type_alias/2'(W, N)
	    ;   true
	    ),
	    unalias_type(X, Y),
	    (   N=suspension(_, active, _, P, _, _, _)
	    ->  setarg(2, N, inactive),
		'type_alias/2__1__0'(Z, B, F, N)
	    ;   true
	    )
	;   'type_alias/2__1__0'(Z, B, F, N)
	).
'type_alias/2__1'(A, B, C) :-
	'type_alias/2__2'(A, B, C).
'type_alias/2__2'(D, E, F) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, _, _, C, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', C)
	), !,
	'type_alias/2__2__0'(C, D, E, F).
'type_alias/2__2__0'([], A, B, C) :-
	'type_alias/2__3'(A, B, C).
'type_alias/2__2__0'([A|B1], B, X, N) :-
	(   A=suspension(_, active, _, Y, Z, C),
	    functor(B, D, E),
	    functor(C, D, E)
	->  A=suspension(_, _, _, _, F, G),
	    setarg(2, A, removed),
	    M=[F|H],
	    term_variables(G, H),
	    arg(3, A, I),
	    (   var(I)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', J),
		J=[_|K],
		b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', K),
		(   K=[L|_]
		->  setarg(3, L, _)
		;   true
		)
	    ;   I=[_, _|K],
		setarg(2, I, K),
		(   K=[L|_]
		->  setarg(3, L, I)
		;   true
		)
	    ),
	    'detach_static_type_check_var/3'(M, A),
	    arg(2, N, Q),
	    setarg(2, N, active),
	    arg(4, N, O),
	    P is O+1,
	    setarg(4, N, P),
	    (   Q==not_stored_yet
	    ->  N=suspension(_, _, _, _, _, R, S),
		term_variables(term(R, S), W),
		nb_getval('$chr_store_global_list_chr_translate:type_alias/2', T),
		U=[N|T],
		b_setval('$chr_store_global_list_chr_translate:type_alias/2', U),
		(   T=[V|_]
		->  setarg(5, V, U)
		;   true
		),
		'attach_type_alias/2'(W, N)
	    ;   true
	    ),
	    copy_term_nat(B-X, C-A1),
	    static_type_check_var(Y, Z, A1),
	    (   N=suspension(_, active, _, P, _, _, _)
	    ->  setarg(2, N, inactive),
		'type_alias/2__2__0'(B1, B, X, N)
	    ;   true
	    )
	;   'type_alias/2__2__0'(B1, B, X, N)
	).
'type_alias/2__2'(A, B, C) :-
	'type_alias/2__3'(A, B, C).
'type_alias/2__3'(B, C, D) :-
	nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', A), !,
	'type_alias/2__3__0'(A, B, C, D).
'type_alias/2__3__0'([], A, B, C) :-
	'type_alias/2__4'(A, B, C).
'type_alias/2__3__0'([A|R], M, N, B) :-
	(   A=suspension(_, active, _, _),
	    C=t(185, B, A),
	    '$novel_production'(B, C),
	    '$novel_production'(A, C)
	->  '$extend_history'(B, C),
	    arg(2, B, F),
	    setarg(2, B, active),
	    arg(4, B, D),
	    E is D+1,
	    setarg(4, B, E),
	    (   F==not_stored_yet
	    ->  B=suspension(_, _, _, _, _, G, H),
		term_variables(term(G, H), L),
		nb_getval('$chr_store_global_list_chr_translate:type_alias/2', I),
		J=[B|I],
		b_setval('$chr_store_global_list_chr_translate:type_alias/2', J),
		(   I=[K|_]
		->  setarg(5, K, J)
		;   true
		),
		'attach_type_alias/2'(L, B)
	    ;   true
	    ),
	    copy_term_nat(M-N, O-P),
	    dynamic_type_check_alias_clause(O, P, Q),
	    dynamic_type_check_clauses([Q]),
	    (   B=suspension(_, active, _, E, _, _, _)
	    ->  setarg(2, B, inactive),
		'type_alias/2__3__0'(R, M, N, B)
	    ;   true
	    )
	;   'type_alias/2__3__0'(R, M, N, B)
	).
'type_alias/2__3'(A, B, C) :-
	'type_alias/2__4'(A, B, C).
'type_alias/2__4'(D, E, F) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, _, _, _, _, C)
	;   nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', C)
	), !,
	'type_alias/2__4__0'(C, D, E, F).
'type_alias/2__4__0'([], A, B, C) :-
	'type_alias/2__5'(A, B, C).
'type_alias/2__4__0'([A|X], C, V, L) :-
	(   A=suspension(_, active, _, B),
	    functor(B, D, E),
	    functor(C, D, E)
	->  A=suspension(_, _, _, F),
	    setarg(2, A, removed),
	    term_variables(F, K),
	    arg(3, A, G),
	    (   var(G)
	    ->  nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', H),
		H=[_|I],
		b_setval('$chr_store_global_list_chr_translate:atomic_type/1', I),
		(   I=[J|_]
		->  setarg(3, J, _)
		;   true
		)
	    ;   G=[_, _|I],
		setarg(2, G, I),
		(   I=[J|_]
		->  setarg(3, J, G)
		;   true
		)
	    ),
	    'detach_atomic_type/1'(K, A),
	    arg(2, L, O),
	    setarg(2, L, active),
	    arg(4, L, M),
	    N is M+1,
	    setarg(4, L, N),
	    (   O==not_stored_yet
	    ->  L=suspension(_, _, _, _, _, P, Q),
		term_variables(term(P, Q), U),
		nb_getval('$chr_store_global_list_chr_translate:type_alias/2', R),
		S=[L|R],
		b_setval('$chr_store_global_list_chr_translate:type_alias/2', S),
		(   R=[T|_]
		->  setarg(5, T, S)
		;   true
		),
		'attach_type_alias/2'(U, L)
	    ;   true
	    ),
	    atomic(V),
	    copy_term_nat(C-V, B-W),
	    atomic_type(W),
	    (   L=suspension(_, active, _, N, _, _, _)
	    ->  setarg(2, L, inactive),
		'type_alias/2__4__0'(X, C, V, L)
	    ;   true
	    )
	;   'type_alias/2__4__0'(X, C, V, L)
	).
'type_alias/2__4'(A, B, C) :-
	'type_alias/2__5'(A, B, C).
'type_alias/2__5'(_, _, A) :-
	arg(2, A, D),
	setarg(2, A, active),
	arg(4, A, B),
	C is B+1,
	setarg(4, A, C),
	(   D==not_stored_yet
	->  A=suspension(_, _, _, _, _, E, F),
	    term_variables(term(E, F), J),
	    nb_getval('$chr_store_global_list_chr_translate:type_alias/2', G),
	    H=[A|G],
	    b_setval('$chr_store_global_list_chr_translate:type_alias/2', H),
	    (   G=[I|_]
	    ->  setarg(5, I, H)
	    ;   true
	    ),
	    'attach_type_alias/2'(J, A)
	;   true
	).
constraint_type(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:constraint_type/2-1', D),
	insert_ht(D, A, E).
get_type_definition(A, _) :-
	\+ground(A), !,
	chr_error(type_error, 'Non-ground type in constraint definition: "~w".\n', [A]).
get_type_definition(F, L) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, I),
	nonvar(E),
	functor(E, G, H),
	functor(F, G, H),
	copy_term_nat((E, I), (J, K)),
	J=F, !,
	(   get_type_definition(K, L)
	->  true
	;   chr_error(type_error, 'Could not find type definition for "~w" (accessed via alias "~w").\n', [K, J]),
	    fail
	).
get_type_definition(F, K) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, I),
	nonvar(E),
	functor(E, G, H),
	functor(F, G, H),
	copy_term_nat((E, I), (J, L)),
	J=F, !,
	K=L.
get_type_definition(A, B) :-
	atomic_builtin_type(A, _, _), !,
	B=[A].
get_type_definition(A, B) :-
	compound_builtin_type(A, _, _), !,
	B=[A].
get_type_definition(_, _) :-
	fail.
get_constraint_type(A, D) :-
	'$via1_multi_hash_constraint_type/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
get_constraint_type(_, _) :-
	fail.
unalias_type(A, B) :-
	'unalias_type/2__0'(A, B, _).
'unalias_type/2__0'(A, I, B) :-
	var(A), !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, C, _),
	    setarg(2, B, removed),
	    term_variables(C, H),
	    arg(3, B, D),
	    (   var(D)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', E),
		E=[_|F],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', F),
		(   F=[G|_]
		->  setarg(3, G, _)
		;   true
		)
	    ;   D=[_, _|F],
		setarg(2, D, F),
		(   F=[G|_]
		->  setarg(3, G, D)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(H, B)
	),
	I=A.
'unalias_type/2__0'(F, S, K) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, I),
	nonvar(E),
	functor(E, G, H),
	functor(F, G, H),
	copy_term_nat((E, I), (J, R)),
	F=J, !,
	(   var(K)
	->  true
	;   K=suspension(_, _, _, L, _),
	    setarg(2, K, removed),
	    term_variables(L, Q),
	    arg(3, K, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(Q, K)
	),
	unalias_type(R, S).
'unalias_type/2__0'(F, P, I) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, _),
	nonvar(E),
	functor(E, G, H),
	functor(F, G, H), !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, J, _),
	    setarg(2, I, removed),
	    term_variables(J, O),
	    arg(3, I, K),
	    (   var(K)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', L),
		L=[_|M],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', M),
		(   M=[N|_]
		->  setarg(3, N, _)
		;   true
		)
	    ;   K=[_, _|M],
		setarg(2, K, M),
		(   M=[N|_]
		->  setarg(3, N, K)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(O, I)
	),
	P=F.
'unalias_type/2__0'(A, I, B) :-
	atomic_builtin_type(A, _, _), !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, C, _),
	    setarg(2, B, removed),
	    term_variables(C, H),
	    arg(3, B, D),
	    (   var(D)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', E),
		E=[_|F],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', F),
		(   F=[G|_]
		->  setarg(3, G, _)
		;   true
		)
	    ;   D=[_, _|F],
		setarg(2, D, F),
		(   F=[G|_]
		->  setarg(3, G, D)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(H, B)
	),
	I=A.
'unalias_type/2__0'(A, I, B) :-
	compound_builtin_type(A, _, _), !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, C, _),
	    setarg(2, B, removed),
	    term_variables(C, H),
	    arg(3, B, D),
	    (   var(D)
	    ->  nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', E),
		E=[_|F],
		b_setval('$chr_store_global_list_chr_translate:unalias_type/2', F),
		(   F=[G|_]
		->  setarg(3, G, _)
		;   true
		)
	    ;   D=[_, _|F],
		setarg(2, D, F),
		(   F=[G|_]
		->  setarg(3, G, D)
		;   true
		)
	    ),
	    'detach_unalias_type/2'(H, B)
	),
	I=A.
'unalias_type/2__0'(B, C, A) :-
	(   var(A)
	->  A=suspension(D, active, _, B, C),
	    term_variables(B, H),
	    'chr gen_id'(D),
	    nb_getval('$chr_store_global_list_chr_translate:unalias_type/2', E),
	    F=[A|E],
	    b_setval('$chr_store_global_list_chr_translate:unalias_type/2', F),
	    (   E=[G|_]
	    ->  setarg(3, G, F)
	    ;   true
	    ),
	    'attach_unalias_type/2'(H, A)
	;   setarg(2, A, active)
	).
types_modes_condition([], [], A) :- !,
	A=true.
types_modes_condition([D|O], [K|P], G) :-
	nb_getval('$chr_store_global_ground_chr_translate:constraint_mode/2', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _, C, H),
	C=E/F,
	functor(D, E, F), !,
	D=..[_|I],
	G= (J, N, Q),
	modes_condition(H, I, J),
	get_constraint_type_det(E/F, L),
	K=..[_|M],
	types_condition(L, I, M, H, N),
	types_modes_condition(O, P, Q).
types_modes_condition([A|_], _, _) :- !,
	functor(A, B, C),
	chr_error(internal, 'Mode information missing for ~w.\n', [B/C]).
types_modes_condition(A, B, C) :-
	E=suspension(D, active, _, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_global_ground_chr_translate:types_modes_condition/3', F),
	G=[E|F],
	b_setval('$chr_store_global_ground_chr_translate:types_modes_condition/3', G),
	(   F=[H|_]
	->  setarg(3, H, G)
	;   true
	).
static_type_check :-
	'static_type_check/0__0'(_).
'static_type_check/0__0'(A) :-
	nb_getval('$chr_store_global_ground_chr_translate:rule/2', C), !,
	A=suspension(B, not_stored_yet, t, _),
	'chr gen_id'(B),
	'static_type_check/0__0__0'(C, A).
'static_type_check/0__0__0'([], A) :-
	'static_type_check/0__1'(A).
'static_type_check/0__0__0'([A|W], B) :-
	(   A=suspension(_, active, _, _, _, H),
	    C=t(162, A, B),
	    '$novel_production'(A, C),
	    '$novel_production'(B, C)
	->  '$extend_history'(B, C),
	    arg(2, B, D),
	    setarg(2, B, active),
	    (   D==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:static_type_check/0', E),
		F=[B|E],
		b_setval('$chr_store_global_ground_chr_translate:static_type_check/0', F),
		(   E=[G|_]
		->  setarg(4, G, F)
		;   true
		)
	    ;   true
	    ),
	    copy_term_nat(H, I),
	    I=pragma(rule(J, K, _, L), ids(_, _), _, _, _),
	    (   catch((static_type_check_heads(J), static_type_check_heads(K), conj2list(L, M), static_type_check_body(M)), type_error(N), (N=invalid_functor(O, P, Q)->chr_error(type_error, 'Invalid functor in ~@ of ~@:\n\t\tfound `~w\',\n\t\texpected type `~w\'!\n', [chr_translate:format_src(O), format_rule(H), P, Q]);N=type_clash(R, T, V, S, U)->chr_error(type_error, 'Type clash for variable ~w in ~@:\n\t\texpected type ~w in ~@\n\t\texpected type ~w in ~@\n', [R, format_rule(H), S, chr_translate:format_src(T), U, chr_translate:format_src(V)]))),
		fail
	    ;   true
	    ),
	    (   B=suspension(_, active, _, _)
	    ->  setarg(2, B, inactive),
		'static_type_check/0__0__0'(W, B)
	    ;   true
	    )
	;   'static_type_check/0__0__0'(W, B)
	).
'static_type_check/0__0'(A) :-
	A=suspension(B, not_stored_yet, t, _),
	'chr gen_id'(B),
	'static_type_check/0__1'(A).
'static_type_check/0__1'(A) :-
	(   var(A)
	->  true
	;   arg(2, A, B),
	    setarg(2, A, removed),
	    (   B==not_stored_yet
	    ->  true
	    ;   arg(4, A, C),
		(   var(C)
		->  nb_getval('$chr_store_global_ground_chr_translate:static_type_check/0', D),
		    D=[_|E],
		    b_setval('$chr_store_global_ground_chr_translate:static_type_check/0', E),
		    (   E=[F|_]
		    ->  setarg(4, F, _)
		    ;   true
		    )
		;   C=[_, _|E],
		    setarg(2, C, E),
		    (   E=[F|_]
		    ->  setarg(4, F, C)
		    ;   true
		    )
		)
	    )
	).
static_type_check_term(B, A, C) :-
	var(A), !,
	static_type_check_var(B, A, C).
static_type_check_term(D, B, A) :-
	atomic_builtin_type(A, B, C), !,
	(   call(C)
	->  true
	;   throw(type_error(invalid_functor(D, B, A)))
	).
static_type_check_term(D, B, A) :-
	compound_builtin_type(A, B, C), !,
	(   call(C)
	->  true
	;   throw(type_error(invalid_functor(D, B, A)))
	).
static_type_check_term(J, K, E) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, F, I),
	functor(E, G, H),
	functor(F, G, H), !,
	copy_term_nat(F-I, E-L),
	static_type_check_term(J, K, L).
static_type_check_term(O, J, E) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, F, I),
	functor(E, G, H),
	functor(F, G, H), !,
	copy_term_nat(F-I, E-K),
	functor(J, M, N),
	(   member(L, K),
	    functor(L, M, N)
	->  J=..[_|P],
	    L=..[_|Q],
	    maplist(static_type_check_term(O), P, Q)
	;   throw(type_error(invalid_functor(O, J, E)))
	).
static_type_check_term(C, B, A) :-
	chr_error(internal, 'Undefined type ~w while type checking term ~w in ~@.\n', [A, B, chr_translate:format_src(C)]).
static_type_check_var(A, B, C) :-
	'static_type_check_var/3__0'(A, B, C, _).
'static_type_check_var/3__0'(S, T, F, I) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, E, R),
	functor(E, G, H),
	functor(F, G, H), !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    Q=[J|L],
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_type_check_var/3'(Q, I)
	),
	copy_term_nat(E-R, F-U),
	static_type_check_var(S, T, U).
'static_type_check_var/3__0'(K, L, A, B) :-
	atomic_builtin_type(A, _, _), !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, _, C, D),
	    setarg(2, B, removed),
	    J=[C|E],
	    term_variables(D, E),
	    arg(3, B, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', G),
		G=[_|H],
		b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', H),
		(   H=[I|_]
		->  setarg(3, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(3, I, F)
		;   true
		)
	    ),
	    'detach_static_type_check_var/3'(J, B)
	),
	static_atomic_builtin_type_check_var(K, L, A).
'static_type_check_var/3__0'(_, _, A, B) :-
	compound_builtin_type(A, _, _), !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, _, C, D),
	    setarg(2, B, removed),
	    J=[C|E],
	    term_variables(D, E),
	    arg(3, B, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', G),
		G=[_|H],
		b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', H),
		(   H=[I|_]
		->  setarg(3, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(3, I, F)
		;   true
		)
	    ),
	    'detach_static_type_check_var/3'(J, B)
	).
'static_type_check_var/3__0'(Y, A, F, P) :-
	get_attr(A, chr_translate, B),
	B=v(_, _, _, _, C, _, _),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, Z, E, G),
	E==A,
	F\==G, !,
	D=suspension(_, _, _, _, H, I),
	setarg(2, D, removed),
	O=[H|J],
	term_variables(I, J),
	arg(3, D, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', M),
	    (   M=[N|_]
	    ->  setarg(3, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(3, N, K)
	    ;   true
	    )
	),
	'detach_static_type_check_var/3'(O, D),
	(   var(P)
	->  true
	;   P=suspension(_, _, _, _, Q, R),
	    setarg(2, P, removed),
	    X=[Q|S],
	    term_variables(R, S),
	    arg(3, P, T),
	    (   var(T)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', U),
		U=[_|V],
		b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', V),
		(   V=[W|_]
		->  setarg(3, W, _)
		;   true
		)
	    ;   T=[_, _|V],
		setarg(2, T, V),
		(   V=[W|_]
		->  setarg(3, W, T)
		;   true
		)
	    ),
	    'detach_static_type_check_var/3'(X, P)
	),
	throw(type_error(type_clash(A, Y, Z, F, G))).
'static_type_check_var/3__0'(Z, A, G, P) :-
	get_attr(A, chr_translate, B),
	B=v(_, _, _, _, C, _, _),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, Y, E, F),
	E==A,
	F\==G, !,
	D=suspension(_, _, _, _, H, I),
	setarg(2, D, removed),
	O=[H|J],
	term_variables(I, J),
	arg(3, D, K),
	(   var(K)
	->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', L),
	    L=[_|M],
	    b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', M),
	    (   M=[N|_]
	    ->  setarg(3, N, _)
	    ;   true
	    )
	;   K=[_, _|M],
	    setarg(2, K, M),
	    (   M=[N|_]
	    ->  setarg(3, N, K)
	    ;   true
	    )
	),
	'detach_static_type_check_var/3'(O, D),
	(   var(P)
	->  true
	;   P=suspension(_, _, _, _, Q, R),
	    setarg(2, P, removed),
	    X=[Q|S],
	    term_variables(R, S),
	    arg(3, P, T),
	    (   var(T)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', U),
		U=[_|V],
		b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', V),
		(   V=[W|_]
		->  setarg(3, W, _)
		;   true
		)
	    ;   T=[_, _|V],
		setarg(2, T, V),
		(   V=[W|_]
		->  setarg(3, W, T)
		;   true
		)
	    ),
	    'detach_static_type_check_var/3'(X, P)
	),
	throw(type_error(type_clash(A, Y, Z, F, G))).
'static_type_check_var/3__0'(B, C, D, A) :-
	(   var(A)
	->  A=suspension(F, active, _, B, C, D),
	    J=[C|E],
	    term_variables(D, E),
	    'chr gen_id'(F),
	    nb_getval('$chr_store_global_list_chr_translate:static_type_check_var/3', G),
	    H=[A|G],
	    b_setval('$chr_store_global_list_chr_translate:static_type_check_var/3', H),
	    (   G=[I|_]
	    ->  setarg(3, I, H)
	    ;   true
	    ),
	    'attach_static_type_check_var/3'(J, A)
	;   setarg(2, A, active)
	).
static_atomic_builtin_type_check_var(A, B, C) :-
	'static_atomic_builtin_type_check_var/3__0'(A, B, C, _).
'static_atomic_builtin_type_check_var/3__0'(_, _, A, B) :-
	A==any, !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, _, C, D),
	    setarg(2, B, removed),
	    term_variables(C, J, E),
	    term_variables(D, E),
	    arg(3, B, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', G),
		G=[_|H],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', H),
		(   H=[I|_]
		->  setarg(3, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(3, I, F)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(J, B)
	).
'static_atomic_builtin_type_check_var/3__0'(_, A, B, I) :-
	(   'chr newvia_2'(A, B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==A,
	H==B, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__0'(F, A, B, G) :-
	(   'chr newvia_2'(A, B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__0__0'(E, F, A, B, G).
'static_atomic_builtin_type_check_var/3__0__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__1'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__0__0'([A|N], O, C, E, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==E
	->  A=suspension(_, _, _, _, F, G),
	    setarg(2, A, removed),
	    term_variables(F, M, H),
	    term_variables(G, H),
	    arg(3, A, I),
	    (   var(I)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		J=[_|K],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', K),
		(   K=[L|_]
		->  setarg(3, L, _)
		;   true
		)
	    ;   I=[_, _|K],
		setarg(2, I, K),
		(   K=[L|_]
		->  setarg(3, L, I)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(M, A),
	    'static_atomic_builtin_type_check_var/3__0__0'(N, O, C, E, P)
	;   'static_atomic_builtin_type_check_var/3__0__0'(N, O, C, E, P)
	).
'static_atomic_builtin_type_check_var/3__0'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__1'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__1'(_, B, A, I) :-
	A==number,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==float, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__1'(F, B, A, G) :-
	A==float,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__1__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__1__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__2'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__1__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==number
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__1__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__1__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__1'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__2'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__2'(_, B, A, I) :-
	A==number,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==int, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__2'(F, B, A, G) :-
	A==int,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__2__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__2__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__3'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__2__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==number
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__2__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__2__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__2'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__3'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__3'(_, B, A, I) :-
	A==number,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==natural, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__3'(F, B, A, G) :-
	A==natural,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__3__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__3__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__4'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__3__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==number
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__3__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__3__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__3'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__4'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__4'(_, B, A, I) :-
	A==number,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==dense_int, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__4'(F, B, A, G) :-
	A==dense_int,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__4__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__4__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__5'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__4__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==number
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__4__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__4__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__4'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__5'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__5'(_, B, A, I) :-
	A==int,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==natural, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__5'(F, B, A, G) :-
	A==natural,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__5__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__5__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__6'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__5__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==int
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__5__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__5__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__5'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__6'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__6'(_, B, A, I) :-
	A==int,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==dense_int, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__6'(F, B, A, G) :-
	A==dense_int,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__6__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__6__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__7'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__6__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==int
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__6__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__6__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__6'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__7'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__7'(_, B, A, I) :-
	A==natural,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, H),
	G==B,
	H==dense_int, !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, _, J, K),
	    setarg(2, I, removed),
	    term_variables(J, Q, L),
	    term_variables(K, L),
	    arg(3, I, M),
	    (   var(M)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', N),
		N=[_|O],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', O),
		(   O=[P|_]
		->  setarg(3, P, _)
		;   true
		)
	    ;   M=[_, _|O],
		setarg(2, M, O),
		(   O=[P|_]
		->  setarg(3, P, M)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(Q, I)
	).
'static_atomic_builtin_type_check_var/3__7'(F, B, A, G) :-
	A==dense_int,
	(   'chr newvia_1'(B, C)
	->  get_attr(C, chr_translate, D),
	    D=v(_, _, _, _, _, E, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', E)
	), !,
	'static_atomic_builtin_type_check_var/3__7__0'(E, F, B, A, G).
'static_atomic_builtin_type_check_var/3__7__0'([], A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__8'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__7__0'([A|M], N, C, O, P) :-
	(   A=suspension(_, active, _, _, B, D),
	    B==C,
	    D==natural
	->  A=suspension(_, _, _, _, E, F),
	    setarg(2, A, removed),
	    term_variables(E, L, G),
	    term_variables(F, G),
	    arg(3, A, H),
	    (   var(H)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', I),
		I=[_|J],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', J),
		(   J=[K|_]
		->  setarg(3, K, _)
		;   true
		)
	    ;   H=[_, _|J],
		setarg(2, H, J),
		(   J=[K|_]
		->  setarg(3, K, H)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(L, A),
	    'static_atomic_builtin_type_check_var/3__7__0'(M, N, C, O, P)
	;   'static_atomic_builtin_type_check_var/3__7__0'(M, N, C, O, P)
	).
'static_atomic_builtin_type_check_var/3__7'(A, B, C, D) :-
	'static_atomic_builtin_type_check_var/3__8'(A, B, C, D).
'static_atomic_builtin_type_check_var/3__8'(X, A, Z, O) :-
	(   'chr newvia_1'(A, B)
	->  get_attr(B, chr_translate, C),
	    C=v(_, _, _, _, _, D, _)
	;   nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', D)
	),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, Y, F, A1),
	F==A, !,
	E=suspension(_, _, _, _, G, H),
	setarg(2, E, removed),
	term_variables(G, N, I),
	term_variables(H, I),
	arg(3, E, J),
	(   var(J)
	->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', K),
	    K=[_|L],
	    b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', L),
	    (   L=[M|_]
	    ->  setarg(3, M, _)
	    ;   true
	    )
	;   J=[_, _|L],
	    setarg(2, J, L),
	    (   L=[M|_]
	    ->  setarg(3, M, J)
	    ;   true
	    )
	),
	'detach_static_atomic_builtin_type_check_var/3'(N, E),
	(   var(O)
	->  true
	;   O=suspension(_, _, _, _, P, Q),
	    setarg(2, O, removed),
	    term_variables(P, W, R),
	    term_variables(Q, R),
	    arg(3, O, S),
	    (   var(S)
	    ->  nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', T),
		T=[_|U],
		b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', U),
		(   U=[V|_]
		->  setarg(3, V, _)
		;   true
		)
	    ;   S=[_, _|U],
		setarg(2, S, U),
		(   U=[V|_]
		->  setarg(3, V, S)
		;   true
		)
	    ),
	    'detach_static_atomic_builtin_type_check_var/3'(W, O)
	),
	throw(type_error(type_clash(A, X, Y, Z, A1))).
'static_atomic_builtin_type_check_var/3__8'(B, C, D, A) :-
	(   var(A)
	->  A=suspension(F, active, _, B, C, D),
	    term_variables(C, J, E),
	    term_variables(D, E),
	    'chr gen_id'(F),
	    nb_getval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', G),
	    H=[A|G],
	    b_setval('$chr_store_global_list_chr_translate:static_atomic_builtin_type_check_var/3', H),
	    (   G=[I|_]
	    ->  setarg(3, I, H)
	    ;   true
	    ),
	    'attach_static_atomic_builtin_type_check_var/3'(J, A)
	;   setarg(2, A, active)
	).
dynamic_type_check :-
	'dynamic_type_check/0__0'(_).
'dynamic_type_check/0__0'(D) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	), !,
	D=suspension(E, not_stored_yet, t, _),
	'chr gen_id'(E),
	'dynamic_type_check/0__0__0'(C, D).
'dynamic_type_check/0__0__0'([], A) :-
	'dynamic_type_check/0__1'(A).
'dynamic_type_check/0__0__0'([A|M], B) :-
	(   A=suspension(_, active, _, _, _, H, I),
	    C=t(184, A, B),
	    '$novel_production'(A, C),
	    '$novel_production'(B, C)
	->  '$extend_history'(B, C),
	    arg(2, B, D),
	    setarg(2, B, active),
	    (   D==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', E),
		F=[B|E],
		b_setval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', F),
		(   E=[G|_]
		->  setarg(4, G, F)
		;   true
		)
	    ;   true
	    ),
	    copy_term_nat(H-I, J-K),
	    maplist(dynamic_type_check_clause(J), K, L),
	    dynamic_type_check_clauses(L),
	    (   B=suspension(_, active, _, _)
	    ->  setarg(2, B, inactive),
		'dynamic_type_check/0__0__0'(M, B)
	    ;   true
	    )
	;   'dynamic_type_check/0__0__0'(M, B)
	).
'dynamic_type_check/0__0'(A) :-
	A=suspension(B, not_stored_yet, t, _),
	'chr gen_id'(B),
	'dynamic_type_check/0__1'(A).
'dynamic_type_check/0__1'(D) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	), !,
	'dynamic_type_check/0__1__0'(C, D).
'dynamic_type_check/0__1__0'([], A) :-
	'dynamic_type_check/0__2'(A).
'dynamic_type_check/0__1__0'([A|M], B) :-
	(   A=suspension(_, active, _, _, _, H, I),
	    C=t(185, A, B),
	    '$novel_production'(A, C),
	    '$novel_production'(B, C)
	->  '$extend_history'(B, C),
	    arg(2, B, D),
	    setarg(2, B, active),
	    (   D==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', E),
		F=[B|E],
		b_setval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', F),
		(   E=[G|_]
		->  setarg(4, G, F)
		;   true
		)
	    ;   true
	    ),
	    copy_term_nat(H-I, J-K),
	    dynamic_type_check_alias_clause(J, K, L),
	    dynamic_type_check_clauses([L]),
	    (   B=suspension(_, active, _, _)
	    ->  setarg(2, B, inactive),
		'dynamic_type_check/0__1__0'(M, B)
	    ;   true
	    )
	;   'dynamic_type_check/0__1__0'(M, B)
	).
'dynamic_type_check/0__1'(A) :-
	'dynamic_type_check/0__2'(A).
'dynamic_type_check/0__2'(A) :-
	(   var(A)
	->  true
	;   arg(2, A, B),
	    setarg(2, A, removed),
	    (   B==not_stored_yet
	    ->  true
	    ;   arg(4, A, C),
		(   var(C)
		->  nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', D),
		    D=[_|E],
		    b_setval('$chr_store_global_ground_chr_translate:dynamic_type_check/0', E),
		    (   E=[F|_]
		    ->  setarg(4, F, _)
		    ;   true
		    )
		;   C=[_, _|E],
		    setarg(2, C, E),
		    (   E=[F|_]
		    ->  setarg(4, F, C)
		    ;   true
		    )
		)
	    )
	),
	findall(('$dynamic_type_check'(G, H):-I), (atomic_builtin_type(G, H, I);compound_builtin_type(G, H, I)), J),
	dynamic_type_check_clauses(J).
dynamic_type_check_clauses(G) :-
	nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, H), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	append(G, H, I),
	dynamic_type_check_clauses(I).
dynamic_type_check_clauses(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
get_dynamic_type_check_clauses(G) :-
	nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, H), !,
	setarg(2, B, removed),
	arg(3, B, C),
	(   var(C)
	->  nb_getval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', D),
	    D=[_|E],
	    b_setval('$chr_store_global_ground_chr_translate:dynamic_type_check_clauses/1', E),
	    (   E=[F|_]
	    ->  setarg(3, F, _)
	    ;   true
	    )
	;   C=[_, _|E],
	    setarg(2, C, E),
	    (   E=[F|_]
	    ->  setarg(3, F, C)
	    ;   true
	    )
	),
	G=H.
get_dynamic_type_check_clauses([]).
atomic_type(A) :-
	'atomic_type/1__0'(A, _).
'atomic_type/1__0'(A, B) :-
	atomic_builtin_type(A, _, _), !,
	(   var(B)
	->  true
	;   B=suspension(_, _, _, C),
	    setarg(2, B, removed),
	    term_variables(C, H),
	    arg(3, B, D),
	    (   var(D)
	    ->  nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', E),
		E=[_|F],
		b_setval('$chr_store_global_list_chr_translate:atomic_type/1', F),
		(   F=[G|_]
		->  setarg(3, G, _)
		;   true
		)
	    ;   D=[_, _|F],
		setarg(2, D, F),
		(   F=[G|_]
		->  setarg(3, G, D)
		;   true
		)
	    ),
	    'detach_atomic_type/1'(H, B)
	),
	A\==any.
'atomic_type/1__0'(E, I) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, C, _, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_definition/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, F, P),
	functor(E, G, H),
	functor(F, G, H), !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, J),
	    setarg(2, I, removed),
	    term_variables(J, O),
	    arg(3, I, K),
	    (   var(K)
	    ->  nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', L),
		L=[_|M],
		b_setval('$chr_store_global_list_chr_translate:atomic_type/1', M),
		(   M=[N|_]
		->  setarg(3, N, _)
		;   true
		)
	    ;   K=[_, _|M],
		setarg(2, K, M),
		(   M=[N|_]
		->  setarg(3, N, K)
		;   true
		)
	    ),
	    'detach_atomic_type/1'(O, I)
	),
	forall(member(Q, P), atomic(Q)).
'atomic_type/1__0'(E, I) :-
	(   'chr newvia'([], A)
	->  get_attr(A, chr_translate, B),
	    B=v(_, _, C, _, _, _, _)
	;   nb_getval('$chr_store_global_list_chr_translate:type_alias/2', C)
	),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, F, P),
	functor(E, G, H),
	functor(F, G, H), !,
	(   var(I)
	->  true
	;   I=suspension(_, _, _, J),
	    setarg(2, I, removed),
	    term_variables(J, O),
	    arg(3, I, K),
	    (   var(K)
	    ->  nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', L),
		L=[_|M],
		b_setval('$chr_store_global_list_chr_translate:atomic_type/1', M),
		(   M=[N|_]
		->  setarg(3, N, _)
		;   true
		)
	    ;   K=[_, _|M],
		setarg(2, K, M),
		(   M=[N|_]
		->  setarg(3, N, K)
		;   true
		)
	    ),
	    'detach_atomic_type/1'(O, I)
	),
	atomic(P),
	copy_term_nat(F-P, E-Q),
	atomic_type(Q).
'atomic_type/1__0'(B, A) :-
	(   var(A)
	->  A=suspension(C, active, _, B),
	    term_variables(B, G),
	    'chr gen_id'(C),
	    nb_getval('$chr_store_global_list_chr_translate:atomic_type/1', D),
	    E=[A|D],
	    b_setval('$chr_store_global_list_chr_translate:atomic_type/1', E),
	    (   D=[F|_]
	    ->  setarg(3, F, E)
	    ;   true
	    ),
	    'attach_atomic_type/1'(G, A)
	;   setarg(2, A, active)
	).
stored(A, B, yes) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, H, I, _),
	'$via1_multi_hash_stored_complete/3-1'(A, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, M),
	B<G,
	'$via1_multi_hash_passive/2-12'(k(H, I), J),
	'chr sbag_member'(K, J),
	K=suspension(_, active, _, _, _), !,
	setarg(2, F, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', L),
	delete_ht(L, A, F),
	N is M-1,
	stored(A, B, maybe),
	stored_complete(A, G, N).
stored(A, B, yes) :-
	'$via1_multi_hash_ai_not_observed/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _),
	'$via1_multi_hash_stored_complete/3-1'(A, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _, G, I),
	B<G, !,
	setarg(2, F, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', H),
	delete_ht(H, A, F),
	J is I-1,
	stored(A, B, maybe),
	stored_complete(A, G, J).
stored(A, B, C) :-
	F=suspension(D, active, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', E),
	insert_ht(E, A, F),
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', G),
	insert_ht(G, k(A, B), F).
stored_completing(A, B, F) :-
	ground(A),
	ground(B),
	'$via1_multi_hash_stored/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, E),
	E=yes, !,
	G is B+1,
	H is F+1,
	stored_completing(A, G, H).
stored_completing(A, B, G) :-
	ground(A),
	ground(B),
	'$via1_multi_hash_stored/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, E),
	E=maybe, !,
	F is B+1,
	stored_completing(A, F, G).
stored_completing(A, B, F) :-
	ground(A),
	ground(B),
	'$via1_multi_hash_stored/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, E),
	E=no, !,
	stored_complete(A, B, F).
stored_completing(A, B, C) :-
	stored_complete(A, B, C).
stored_complete(A, B, C) :-
	'stored_complete/3__0'(A, B, C, _).
'stored_complete/3__0'(A, E, O, _) :-
	'$via1_multi_hash_occurrence/5-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D, F, G, _),
	D<E,
	'$via1_multi_hash_passive/2-12'(k(F, G), H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, _, _),
	'$via1_multi_hash_stored/3-12'(k(A, D), J),
	'chr sbag_member'(K, J),
	K=suspension(_, active, _, _, L),
	L=yes, !,
	setarg(2, K, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', M),
	delete_ht(M, A, K),
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', N),
	delete_ht(N, k(A, D), K),
	P is O-1,
	stored(A, D, maybe),
	stored_complete(A, E, P).
'stored_complete/3__0'(A, F, K, _) :-
	'$via1_multi_hash_stored/3-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E, D),
	D=yes,
	E<F,
	'$via1_multi_hash_ai_not_observed/2-12'(k(A, E), G),
	'chr sbag_member'(H, G),
	H=suspension(_, active, _, _), !,
	setarg(2, C, removed),
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', I),
	delete_ht(I, A, C),
	nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', J),
	delete_ht(J, k(A, E), C),
	L is K-1,
	stored(A, E, maybe),
	stored_complete(A, F, L).
'stored_complete/3__0'(A, C, 0, B) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, E), !,
	B=suspension(D, not_stored_yet, t, A, C, 0),
	'chr gen_id'(D),
	'stored_complete/3__0__0'(E, A, C, 0, B).
'stored_complete/3__0__0'([], A, B, C, D) :-
	'stored_complete/3__1'(A, B, C, D).
'stored_complete/3__0__0'([A|F], C, G, H, I) :-
	(   A=suspension(_, active, _, B, E),
	    B==C,
	    '$via1_multi_hash_occurrence/5-1'(C, D)
	->  'stored_complete/3__0__1'(D, E, A, F, C, G, H, I)
	;   'stored_complete/3__0__0'(F, C, G, H, I)
	).
'stored_complete/3__0__1'([], _, _, A, B, C, D, E) :-
	'stored_complete/3__0__0'(A, B, C, D, E).
'stored_complete/3__0__1'([A|F], G, H, I, C, J, K, L) :-
	(   A=suspension(_, active, _, _, B, _, D, _, _),
	    B==C,
	    '$via1_multi_hash_occurrence/5-3'(D, E)
	->  'stored_complete/3__0__2'(E, D, A, F, G, H, I, C, J, K, L)
	;   'stored_complete/3__0__1'(F, G, H, I, C, J, K, L)
	).
'stored_complete/3__0__2'([], _, _, A, B, C, D, E, F, G, H) :-
	'stored_complete/3__0__1'(A, B, C, D, E, F, G, H).
'stored_complete/3__0__2'([A|N], D, B, O, I, F, P, L, H, Q, E) :-
	(   A=suspension(_, active, _, _, _, _, C, M, _),
	    A\==B,
	    C==D,
	    G=t(195, A, B, E, F),
	    '$novel_production'(A, G),
	    '$novel_production'(B, G),
	    '$novel_production'(E, G),
	    '$novel_production'(F, G),
	    H=<I
	->  '$extend_history'(E, G),
	    arg(2, E, J),
	    setarg(2, E, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', K),
		insert_ht(K, L, E)
	    ;   true
	    ),
	    passive(D, M),
	    (   E=suspension(_, active, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'stored_complete/3__0__2'(N, D, B, O, I, F, P, L, H, Q, E)
	    ;   true
	    )
	;   'stored_complete/3__0__2'(N, D, B, O, I, F, P, L, H, Q, E)
	).
'stored_complete/3__0'(B, C, D, A) :-
	A=suspension(E, not_stored_yet, t, B, C, D),
	'chr gen_id'(E),
	'stored_complete/3__1'(B, C, D, A).
'stored_complete/3__1'(A, C, D, E) :-
	'$via1_multi_hash_occurrence/5-1'(A, B), !,
	'stored_complete/3__1__0'(B, A, C, D, E).
'stored_complete/3__1__0'([], A, B, C, D) :-
	'stored_complete/3__2'(A, B, C, D).
'stored_complete/3__1__0'([A|L], C, G, M, D) :-
	(   A=suspension(_, active, _, _, B, F, J, K, _),
	    B==C,
	    E=t(204, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E),
	    F>G
	->  '$extend_history'(D, E),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', I),
		insert_ht(I, C, D)
	    ;   true
	    ),
	    passive(J, K),
	    (   D=suspension(_, active, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'stored_complete/3__1__0'(L, C, G, M, D)
	    ;   true
	    )
	;   'stored_complete/3__1__0'(L, C, G, M, D)
	).
'stored_complete/3__1'(A, B, C, D) :-
	'stored_complete/3__2'(A, B, C, D).
'stored_complete/3__2'(D, _, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', C),
	    insert_ht(C, D, A)
	;   true
	).
is_stored(A) :-
	ground(A),
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, H),
	ground(A),
	'$via1_multi_hash_stored_complete/3-1'(A, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, G, F),
	F=0,
	G=<H, !,
	fail.
is_stored(_).
is_finally_stored(A) :-
	ground(A),
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, G),
	ground(A),
	'$via1_multi_hash_stored_complete/3-1'(A, D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, _, F, _),
	F=<G, !,
	fail.
is_finally_stored(_).
check_all_passive(A, [B|E]) :-
	'$via1_multi_hash_passive/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !,
	check_all_passive(A, E).
check_all_passive(A, []) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, D), !,
	chr_warning(weird_program, 'All heads passive in ~@.\n\tThis rule never fires. Please check your program.\n', [format_rule(D)]).
check_all_passive(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:check_all_passive/2-1', D),
	insert_ht(D, A, E).
constraints_code1([], A, B) :- !,
	A=B.
constraints_code1([A|C], B, E) :- !,
	constraint_code(A, B, D),
	constraints_code1(C, D, E).
constraints_code1(A, B, C) :-
	E=suspension(D, active, _, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_global_ground_chr_translate:constraints_code1/3', F),
	G=[E|F],
	b_setval('$chr_store_global_ground_chr_translate:constraints_code1/3', G),
	(   F=[H|_]
	->  setarg(3, H, G)
	;   true
	).
constraint_code(A, D, J) :-
	(   (   chr_pp_flag(debugable, on)
	    ;   is_stored(A),
		(   has_active_occurrence(A)
		;   chr_pp_flag(late_allocation, off)
		),
		(   may_trigger(A)
		;   get_allocation_occurrence(A, C),
		    get_max_occurrence(A, B),
		    B>=C
		)
	    )
	->  constraint_prelude(A, E),
	    D=[E|F]
	;   D=F
	),
	G=[0],
	occurrences_code(A, 1, G, H, F, I),
	gen_cond_attach_clause(A, H, I, J).
has_active_occurrence(A) :-
	has_active_occurrence(A, 1).
has_active_occurrence(A, D) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, E),
	D>E, !,
	fail.
has_active_occurrence(A, B) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, F, _),
	'$via1_multi_hash_passive/2-12'(k(E, F), G),
	'chr sbag_member'(H, G),
	H=suspension(_, active, _, _, _), !,
	I is B+1,
	has_active_occurrence(A, I).
has_active_occurrence(_, _).
use_auxiliary_predicate(A) :-
	'$via1_multi_hash_use_auxiliary_predicate/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
use_auxiliary_predicate(A) :-
	D=suspension(B, active, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/1-1', C),
	insert_ht(C, A, D).
use_auxiliary_predicate(A, B) :-
	'$via1_multi_hash_use_auxiliary_predicate/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
use_auxiliary_predicate(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-1', D),
	insert_ht(D, A, E),
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_predicate/2-12', F),
	insert_ht(F, k(A, B), E).
is_used_auxiliary_predicate(A) :-
	'$via1_multi_hash_use_auxiliary_predicate/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
is_used_auxiliary_predicate(A) :-
	'$via1_multi_hash_use_auxiliary_predicate/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _), !.
is_used_auxiliary_predicate(_) :-
	fail.
is_used_auxiliary_predicate(A, _) :-
	'$via1_multi_hash_use_auxiliary_predicate/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
is_used_auxiliary_predicate(A, B) :-
	'$via1_multi_hash_use_auxiliary_predicate/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
is_used_auxiliary_predicate(_, _) :-
	fail.
use_auxiliary_module(A) :-
	'$via1_multi_hash_use_auxiliary_module/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
use_auxiliary_module(A) :-
	D=suspension(B, active, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_multi_hash_chr_translate:use_auxiliary_module/1-1', C),
	insert_ht(C, A, D).
is_used_auxiliary_module(A) :-
	'$via1_multi_hash_use_auxiliary_module/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
is_used_auxiliary_module(_) :-
	fail.
occurrences_code(A, D, G, F, H, I) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, E),
	D>E, !,
	F=G,
	H=I.
occurrences_code(A, B, C, G, D, I) :-
	occurrence_code(A, B, C, F, D, H),
	E is B+1,
	occurrences_code(A, E, F, G, H, I).
occurrence_code(A, B, J, I, K, L) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, F, _),
	'$via1_multi_hash_passive/2-12'(k(E, F), G),
	'chr sbag_member'(H, G),
	H=suspension(_, active, _, _, _), !,
	(   named_history(E, _, _)
	->  does_use_history(A, B)
	;   true
	),
	I=J,
	K=L.
occurrence_code(A, B, M, L, Q, R) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, I, _),
	'$via1_multi_hash_rule/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, H), !,
	H=pragma(rule(K, T, _, _), ids(J, S), _, _, _),
	(   select2(I, N, J, K, P, O)
	->  L=M,
	    head1_code(N, I, O, P, H, A, B, M, Q, R)
	;   select2(I, U, S, T, W, V)
	->  head2_code(U, I, V, W, H, A, B, M, Q, X),
	    inc_id(M, L),
	    (   unconditional_occurrence(A, B)
	    ->  X=R
	    ;   gen_alloc_inc_clause(A, B, M, X, R)
	    )
	).
occurrence_code(A, B, _, _, _, _) :-
	chr_error(internal, 'occurrence_code/6: missing information to compile ~w:~w\n', [A, B]).
functional_dependency(B, A, I, J) :-
	A>1,
	'$via1_multi_hash_occurrence/5-13'(k(B, A), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, H, _, _, _),
	'$via1_multi_hash_allocation_occurrence/2-1'(B, E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, G),
	G>H, !,
	functional_dependency(B, 1, I, J).
functional_dependency(A, B, C, D) :-
	G=suspension(E, active, A, B, C, D),
	'chr gen_id'(E),
	nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-1', F),
	insert_ht(F, A, G),
	nb_getval('$chr_store_multi_hash_chr_translate:functional_dependency/4-12', H),
	insert_ht(H, k(A, B), G).
get_functional_dependency(A, D, F, H) :-
	'$via1_multi_hash_functional_dependency/4-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E, G, I),
	D>=E, !,
	F=G,
	H=I.
get_functional_dependency(_, _, _, _) :-
	fail.
initial_call_pattern(A) :-
	'initial_call_pattern/1__0'(A, _).
'initial_call_pattern/1__0'(A, _) :-
	'$via1_multi_hash_initial_call_pattern/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _), !.
'initial_call_pattern/1__0'(B, A) :-
	A=suspension(C, active, t, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:initial_call_pattern/1-1', D),
	insert_ht(D, B, A),
	call_pattern(B),
	(   A=suspension(_, active, _, _)
	->  setarg(2, A, inactive),
	    'initial_call_pattern/1__1'(B, A)
	;   true
	).
'initial_call_pattern/1__1'(A, C) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, B), !,
	'initial_call_pattern/1__1__0'(B, A, C).
'initial_call_pattern/1__1__0'([], A, B) :-
	'initial_call_pattern/1__2'(A, B).
'initial_call_pattern/1__1__0'([A|F], C, G) :-
	(   A=suspension(_, active, _, B, E),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', D)
	->  'initial_call_pattern/1__1__1'(D, E, A, F, C, G)
	;   'initial_call_pattern/1__1__0'(F, C, G)
	).
'initial_call_pattern/1__1__1'([], _, _, A, B, C) :-
	'initial_call_pattern/1__1__0'(A, B, C).
'initial_call_pattern/1__1__1'([A|G], F, C, H, I, B) :-
	(   A=suspension(_, active, _, E),
	    D=t(247, B, C, A),
	    '$novel_production'(B, D),
	    '$novel_production'(C, D)
	->  '$extend_history'(B, D),
	    setarg(2, B, active),
	    ai_observation_schedule_new_calls(E, F),
	    (   B=suspension(_, active, _, _)
	    ->  setarg(2, B, inactive),
		'initial_call_pattern/1__1__1'(G, F, C, H, I, B)
	    ;   true
	    )
	;   'initial_call_pattern/1__1__1'(G, F, C, H, I, B)
	).
'initial_call_pattern/1__1'(A, B) :-
	'initial_call_pattern/1__2'(A, B).
'initial_call_pattern/1__2'(_, A) :-
	setarg(2, A, active).
call_pattern(A) :-
	'call_pattern/1__0'(A, _).
'call_pattern/1__0'(A, _) :-
	'$via1_multi_hash_call_pattern/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
'call_pattern/1__0'(B, A) :-
	A=suspension(C, active, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:call_pattern/1-1', D),
	insert_ht(D, B, A),
	call_pattern_worker(B),
	(   A=suspension(_, active, _)
	->  setarg(2, A, inactive),
	    'call_pattern/1__1'(B, A)
	;   true
	).
'call_pattern/1__1'(_, A) :-
	setarg(2, A, active).
call_pattern_worker(odom([], A)) :- !,
	final_answer_pattern(odom([], A), odom([], A)).
call_pattern_worker(odom([A|C], B)) :- !,
	D=odom(A, B),
	depends_on_goal(odom([A|C], B), D),
	call_pattern(D).
call_pattern_worker(odom(builtin, A)) :- !,
	ord_empty(B),
	final_answer_pattern(odom(builtin, A), odom([], B)).
call_pattern_worker(odom(occ(A, D), F)) :-
	'$via1_multi_hash_max_occurrence/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, E),
	D>E, !,
	final_answer_pattern(odom(occ(A, D), F), odom([], F)).
call_pattern_worker(odom(A, B)) :-
	A=_/_, !,
	C=odom(occ(A, 1), B),
	call_pattern(C),
	depends_on(odom(A, B), C).
call_pattern_worker(odom(occ(A, B), H)) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, F, _),
	is_passive(E, F), !,
	G is B+1,
	I=odom(occ(A, G), H),
	call_pattern(I),
	final_answer_pattern(odom(occ(A, B), H), odom([], H)),
	depends_on(odom(occ(A, B), H), I).
call_pattern_worker(odom(occ(A, B), H)) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, F, G, E),
	E=simplification, !,
	\+is_passive(F, G),
	ai_observation_memo_simplification_rest_heads(A, B, I),
	ai_observation_observe_set(H, I, K),
	ai_observation_memo_abstract_goal(F, J),
	call_pattern(odom(J, K)),
	L is B+1,
	M=odom(occ(A, L), H),
	call_pattern(M),
	depends_on_as(odom(occ(A, B), H), odom(J, K), M),
	final_answer_pattern(odom(occ(A, B), H), odom([], H)).
call_pattern_worker(odom(occ(A, B), H)) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, F, G, E),
	E=propagation, !,
	\+is_passive(F, G),
	ai_observation_memo_propagation_rest_heads(A, B, I),
	ai_observation_observe_set(H, I, J),
	ord_add_element(J, A, L),
	ai_observation_memo_abstract_goal(F, K),
	call_pattern(odom(K, L)),
	(   ord_memberchk(A, J)
	->  M=no
	;   M=yes
	),
	N is B+1,
	O=odom(occ(A, N), H),
	call_pattern(O),
	depends_on_ap(odom(occ(A, B), H), odom(K, L), O, M).
call_pattern_worker(A) :-
	chr_error(internal, 'AI observation analysis: unexpected abstract state ~w\n', [A]).
final_answer_pattern(A, B) :-
	'final_answer_pattern/2__0'(A, B, _).
'final_answer_pattern/2__0'(A, D, _) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, E),
	ai_observation_leq(D, E), !.
'final_answer_pattern/2__0'(A, C, D) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, B), !,
	'final_answer_pattern/2__0__0'(B, A, C, D).
'final_answer_pattern/2__0__0'([], A, B, C) :-
	'final_answer_pattern/2__1'(A, B, C).
'final_answer_pattern/2__0__0'([A|G], C, E, H) :-
	(   A=suspension(_, active, _, B, D),
	    B==C,
	    ai_observation_leq(D, E)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', F),
	    delete_ht(F, C, A),
	    'final_answer_pattern/2__0__0'(G, C, E, H)
	;   'final_answer_pattern/2__0__0'(G, C, E, H)
	).
'final_answer_pattern/2__0'(A, B, C) :-
	'final_answer_pattern/2__1'(A, B, C).
'final_answer_pattern/2__1'(A, C, B) :-
	'$via1_multi_hash_initial_call_pattern/1-1'(A, E), !,
	B=suspension(D, not_stored_yet, t, A, C),
	'chr gen_id'(D),
	'final_answer_pattern/2__1__0'(E, A, C, B).
'final_answer_pattern/2__1__0'([], A, B, C) :-
	'final_answer_pattern/2__2'(A, B, C).
'final_answer_pattern/2__1__0'([A|E], C, F, G) :-
	(   A=suspension(_, active, _, B),
	    B==C,
	    nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', D)
	->  'final_answer_pattern/2__1__1'(D, A, E, C, F, G)
	;   'final_answer_pattern/2__1__0'(E, C, F, G)
	).
'final_answer_pattern/2__1__1'([], _, A, B, C, D) :-
	'final_answer_pattern/2__1__0'(A, B, C, D).
'final_answer_pattern/2__1__1'([A|J], B, K, G, I, C) :-
	(   A=suspension(_, active, _, H),
	    D=t(247, B, C, A),
	    '$novel_production'(B, D),
	    '$novel_production'(C, D)
	->  '$extend_history'(C, D),
	    arg(2, C, E),
	    setarg(2, C, active),
	    (   E==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', F),
		insert_ht(F, G, C)
	    ;   true
	    ),
	    ai_observation_schedule_new_calls(H, I),
	    (   C=suspension(_, active, _, _, _)
	    ->  setarg(2, C, inactive),
		'final_answer_pattern/2__1__1'(J, B, K, G, I, C)
	    ;   true
	    )
	;   'final_answer_pattern/2__1__1'(J, B, K, G, I, C)
	).
'final_answer_pattern/2__1'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, B, C),
	'chr gen_id'(D),
	'final_answer_pattern/2__2'(B, C, A).
'final_answer_pattern/2__2'(A, C, D) :-
	'$via1_multi_hash_depends_on/2-2'(A, B), !,
	'final_answer_pattern/2__2__0'(B, A, C, D).
'final_answer_pattern/2__2__0'([], A, B, C) :-
	'final_answer_pattern/2__3'(A, B, C).
'final_answer_pattern/2__2__0'([A|J], C, I, D) :-
	(   A=suspension(_, active, _, H, B),
	    B==C,
	    E=t(249, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', G),
		insert_ht(G, C, D)
	    ;   true
	    ),
	    final_answer_pattern(H, I),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'final_answer_pattern/2__2__0'(J, C, I, D)
	    ;   true
	    )
	;   'final_answer_pattern/2__2__0'(J, C, I, D)
	).
'final_answer_pattern/2__2'(A, B, C) :-
	'final_answer_pattern/2__3'(A, B, C).
'final_answer_pattern/2__3'(A, C, D) :-
	'$via1_multi_hash_depends_on_goal/2-2'(A, B), !,
	'final_answer_pattern/2__3__0'(B, A, C, D).
'final_answer_pattern/2__3__0'([], A, B, C) :-
	'final_answer_pattern/2__4'(A, B, C).
'final_answer_pattern/2__3__0'([A|F], C, G, H) :-
	(   A=suspension(_, active, _, D, B),
	    B==C,
	    '$via1_multi_hash_depends_on/2-1'(D, E)
	->  'final_answer_pattern/2__3__1'(E, D, A, F, C, G, H)
	;   'final_answer_pattern/2__3__0'(F, C, G, H)
	).
'final_answer_pattern/2__3__1'([], _, _, A, B, C, D) :-
	'final_answer_pattern/2__3__0'(A, B, C, D).
'final_answer_pattern/2__3__1'([A|G], C, H, I, J, K, L) :-
	(   A=suspension(_, active, _, B, F),
	    B==C
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-1', D),
	    delete_ht(D, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-2', E),
	    delete_ht(E, F, A),
	    'final_answer_pattern/2__3__1'(G, C, H, I, J, K, L)
	;   'final_answer_pattern/2__3__1'(G, C, H, I, J, K, L)
	).
'final_answer_pattern/2__3'(A, B, C) :-
	'final_answer_pattern/2__4'(A, B, C).
'final_answer_pattern/2__4'(A, C, D) :-
	'$via1_multi_hash_depends_on_goal/2-2'(A, B), !,
	'final_answer_pattern/2__4__0'(B, A, C, D).
'final_answer_pattern/2__4__0'([], A, B, C) :-
	'final_answer_pattern/2__5'(A, B, C).
'final_answer_pattern/2__4__0'([A|M], C, I, D) :-
	(   A=suspension(_, active, _, H, B),
	    B==C,
	    E=t(254, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', G),
		insert_ht(G, C, D)
	    ;   true
	    ),
	    H=odom([_|J], _),
	    I=odom([], K),
	    L=odom(J, K),
	    call_pattern(L),
	    depends_on(H, L),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'final_answer_pattern/2__4__0'(M, C, I, D)
	    ;   true
	    )
	;   'final_answer_pattern/2__4__0'(M, C, I, D)
	).
'final_answer_pattern/2__4'(A, B, C) :-
	'final_answer_pattern/2__5'(A, B, C).
'final_answer_pattern/2__5'(A, C, D) :-
	'$via1_multi_hash_depends_on_as/3-2'(A, B), !,
	'final_answer_pattern/2__5__0'(B, A, C, D).
'final_answer_pattern/2__5__0'([], A, B, C) :-
	'final_answer_pattern/2__6'(A, B, C).
'final_answer_pattern/2__5__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, F, B, D),
	    B==C,
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E)
	->  'final_answer_pattern/2__5__1'(E, F, D, A, G, C, H, I)
	;   'final_answer_pattern/2__5__0'(G, C, H, I)
	).
'final_answer_pattern/2__5__1'([], _, _, _, A, B, C, D) :-
	'final_answer_pattern/2__5__0'(A, B, C, D).
'final_answer_pattern/2__5__1'([A|N], L, C, D, O, I, J, E) :-
	(   A=suspension(_, active, _, B, K),
	    B==C,
	    F=t(260, D, E, A),
	    '$novel_production'(D, F),
	    '$novel_production'(E, F),
	    '$novel_production'(A, F)
	->  '$extend_history'(E, F),
	    arg(2, E, G),
	    setarg(2, E, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', H),
		insert_ht(H, I, E)
	    ;   true
	    ),
	    ai_observation_lub(J, K, M),
	    final_answer_pattern(L, M),
	    (   E=suspension(_, active, _, _, _)
	    ->  setarg(2, E, inactive),
		'final_answer_pattern/2__5__1'(N, L, C, D, O, I, J, E)
	    ;   true
	    )
	;   'final_answer_pattern/2__5__1'(N, L, C, D, O, I, J, E)
	).
'final_answer_pattern/2__5'(A, B, C) :-
	'final_answer_pattern/2__6'(A, B, C).
'final_answer_pattern/2__6'(A, C, D) :-
	'$via1_multi_hash_depends_on_as/3-3'(A, B), !,
	'final_answer_pattern/2__6__0'(B, A, C, D).
'final_answer_pattern/2__6__0'([], A, B, C) :-
	'final_answer_pattern/2__7'(A, B, C).
'final_answer_pattern/2__6__0'([A|G], C, H, I) :-
	(   A=suspension(_, active, _, F, D, B),
	    B==C,
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E)
	->  'final_answer_pattern/2__6__1'(E, F, D, A, G, C, H, I)
	;   'final_answer_pattern/2__6__0'(G, C, H, I)
	).
'final_answer_pattern/2__6__1'([], _, _, _, A, B, C, D) :-
	'final_answer_pattern/2__6__0'(A, B, C, D).
'final_answer_pattern/2__6__1'([A|N], L, C, D, O, I, K, E) :-
	(   A=suspension(_, active, _, B, J),
	    B==C,
	    F=t(260, D, A, E),
	    '$novel_production'(D, F),
	    '$novel_production'(A, F),
	    '$novel_production'(E, F)
	->  '$extend_history'(E, F),
	    arg(2, E, G),
	    setarg(2, E, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', H),
		insert_ht(H, I, E)
	    ;   true
	    ),
	    ai_observation_lub(J, K, M),
	    final_answer_pattern(L, M),
	    (   E=suspension(_, active, _, _, _)
	    ->  setarg(2, E, inactive),
		'final_answer_pattern/2__6__1'(N, L, C, D, O, I, K, E)
	    ;   true
	    )
	;   'final_answer_pattern/2__6__1'(N, L, C, D, O, I, K, E)
	).
'final_answer_pattern/2__6'(A, B, C) :-
	'final_answer_pattern/2__7'(A, B, C).
'final_answer_pattern/2__7'(A, C, D) :-
	'$via1_multi_hash_depends_on_ap/4-3'(A, B), !,
	'final_answer_pattern/2__7__0'(B, A, C, D).
'final_answer_pattern/2__7__0'([], A, B, C) :-
	'final_answer_pattern/2__8'(A, B, C).
'final_answer_pattern/2__7__0'([A|J], C, I, D) :-
	(   A=suspension(_, active, _, H, _, B, _),
	    B==C,
	    E=t(268, A, D),
	    '$novel_production'(A, E),
	    '$novel_production'(D, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', G),
		insert_ht(G, C, D)
	    ;   true
	    ),
	    final_answer_pattern(H, I),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'final_answer_pattern/2__7__0'(J, C, I, D)
	    ;   true
	    )
	;   'final_answer_pattern/2__7__0'(J, C, I, D)
	).
'final_answer_pattern/2__7'(A, B, C) :-
	'final_answer_pattern/2__8'(A, B, C).
'final_answer_pattern/2__8'(A, C, D) :-
	'$via1_multi_hash_depends_on_ap/4-2'(A, B), !,
	'final_answer_pattern/2__8__0'(B, A, C, D).
'final_answer_pattern/2__8__0'([], A, B, C) :-
	'final_answer_pattern/2__9'(A, B, C).
'final_answer_pattern/2__8__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, F, B, D, G),
	    B==C,
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E)
	->  'final_answer_pattern/2__8__1'(E, F, D, G, A, H, C, I, J)
	;   'final_answer_pattern/2__8__0'(H, C, I, J)
	).
'final_answer_pattern/2__8__1'([], _, _, _, _, A, B, C, D) :-
	'final_answer_pattern/2__8__0'(A, B, C, D).
'final_answer_pattern/2__8__1'([A|T], J, C, N, D, U, I, K, E) :-
	(   A=suspension(_, active, _, B, R),
	    B==C,
	    F=t(269, D, E, A),
	    '$novel_production'(D, F),
	    '$novel_production'(E, F),
	    '$novel_production'(A, F)
	->  '$extend_history'(E, F),
	    arg(2, E, G),
	    setarg(2, E, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', H),
		insert_ht(H, I, E)
	    ;   true
	    ),
	    J=odom(occ(L, M), _),
	    (   ai_observation_is_observed(K, L)
	    ->  ai_observed_internal(L, M)
	    ;   ai_not_observed_internal(L, M)
	    ),
	    (   N==yes
	    ->  K=odom([], O),
		ord_del_element(O, L, P),
		Q=odom([], P)
	    ;   Q=K
	    ),
	    ai_observation_lub(Q, R, S),
	    final_answer_pattern(J, S),
	    (   E=suspension(_, active, _, _, _)
	    ->  setarg(2, E, inactive),
		'final_answer_pattern/2__8__1'(T, J, C, N, D, U, I, K, E)
	    ;   true
	    )
	;   'final_answer_pattern/2__8__1'(T, J, C, N, D, U, I, K, E)
	).
'final_answer_pattern/2__8'(A, B, C) :-
	'final_answer_pattern/2__9'(A, B, C).
'final_answer_pattern/2__9'(A, C, D) :-
	'$via1_multi_hash_depends_on_ap/4-3'(A, B), !,
	'final_answer_pattern/2__9__0'(B, A, C, D).
'final_answer_pattern/2__9__0'([], A, B, C) :-
	'final_answer_pattern/2__10'(A, B, C).
'final_answer_pattern/2__9__0'([A|H], C, I, J) :-
	(   A=suspension(_, active, _, F, D, B, G),
	    B==C,
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E)
	->  'final_answer_pattern/2__9__1'(E, F, D, G, A, H, C, I, J)
	;   'final_answer_pattern/2__9__0'(H, C, I, J)
	).
'final_answer_pattern/2__9__1'([], _, _, _, _, A, B, C, D) :-
	'final_answer_pattern/2__9__0'(A, B, C, D).
'final_answer_pattern/2__9__1'([A|T], J, C, N, D, U, I, R, E) :-
	(   A=suspension(_, active, _, B, K),
	    B==C,
	    F=t(269, D, A, E),
	    '$novel_production'(D, F),
	    '$novel_production'(A, F),
	    '$novel_production'(E, F)
	->  '$extend_history'(E, F),
	    arg(2, E, G),
	    setarg(2, E, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', H),
		insert_ht(H, I, E)
	    ;   true
	    ),
	    J=odom(occ(L, M), _),
	    (   ai_observation_is_observed(K, L)
	    ->  ai_observed_internal(L, M)
	    ;   ai_not_observed_internal(L, M)
	    ),
	    (   N==yes
	    ->  K=odom([], O),
		ord_del_element(O, L, P),
		Q=odom([], P)
	    ;   Q=K
	    ),
	    ai_observation_lub(Q, R, S),
	    final_answer_pattern(J, S),
	    (   E=suspension(_, active, _, _, _)
	    ->  setarg(2, E, inactive),
		'final_answer_pattern/2__9__1'(T, J, C, N, D, U, I, R, E)
	    ;   true
	    )
	;   'final_answer_pattern/2__9__1'(T, J, C, N, D, U, I, R, E)
	).
'final_answer_pattern/2__9'(A, B, C) :-
	'final_answer_pattern/2__10'(A, B, C).
'final_answer_pattern/2__10'(D, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:final_answer_pattern/2-1', C),
	    insert_ht(C, D, A)
	;   true
	).
abstract_constraints(_) :-
	nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _, _), !.
abstract_constraints(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', A), !,
	'abstract_constraints/1__0__0'(A, B).
'abstract_constraints/1__0__0'([], A) :-
	'abstract_constraints/1__1'(A).
'abstract_constraints/1__0__0'([A|F], G) :-
	(   A=suspension(_, active, _, _)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:abstract_constraints/1', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    'abstract_constraints/1__0__0'(F, G)
	;   'abstract_constraints/1__0__0'(F, G)
	).
abstract_constraints(A) :-
	'abstract_constraints/1__1'(A).
'abstract_constraints/1__1'(A) :-
	C=suspension(B, active, _, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', D),
	E=[C|D],
	b_setval('$chr_store_global_ground_chr_translate:abstract_constraints/1', E),
	(   D=[F|_]
	->  setarg(3, F, E)
	;   true
	).
depends_on(A, B) :-
	'depends_on/2__0'(A, B, _).
'depends_on/2__0'(C, A, B) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, E), !,
	B=suspension(D, not_stored_yet, t, C, A),
	'chr gen_id'(D),
	'depends_on/2__0__0'(E, C, A, B).
'depends_on/2__0__0'([], A, B, C) :-
	'depends_on/2__1'(A, B, C).
'depends_on/2__0__0'([A|K], H, C, D) :-
	(   A=suspension(_, active, _, B, J),
	    B==C,
	    E=t(249, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-1', G),
		insert_ht(G, H, D),
		nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-2', I),
		insert_ht(I, C, D)
	    ;   true
	    ),
	    final_answer_pattern(H, J),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'depends_on/2__0__0'(K, H, C, D)
	    ;   true
	    )
	;   'depends_on/2__0__0'(K, H, C, D)
	).
'depends_on/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, B, C),
	'chr gen_id'(D),
	'depends_on/2__1'(B, C, A).
'depends_on/2__1'(D, F, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-1', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-2', E),
	    insert_ht(E, F, A)
	;   true
	).
depends_on_ap(A, B, C, D) :-
	'depends_on_ap/4__0'(A, B, C, D, _).
'depends_on_ap/4__0'(C, D, A, E, B) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, G), !,
	B=suspension(F, not_stored_yet, t, C, D, A, E),
	'chr gen_id'(F),
	'depends_on_ap/4__0__0'(G, C, D, A, E, B).
'depends_on_ap/4__0__0'([], A, B, C, D, E) :-
	'depends_on_ap/4__1'(A, B, C, D, E).
'depends_on_ap/4__0__0'([A|L], J, H, C, M, D) :-
	(   A=suspension(_, active, _, B, K),
	    B==C,
	    E=t(268, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2', G),
		insert_ht(G, H, D),
		nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-3', I),
		insert_ht(I, C, D)
	    ;   true
	    ),
	    final_answer_pattern(J, K),
	    (   D=suspension(_, active, _, _, _, _, _)
	    ->  setarg(2, D, inactive),
		'depends_on_ap/4__0__0'(L, J, H, C, M, D)
	    ;   true
	    )
	;   'depends_on_ap/4__0__0'(L, J, H, C, M, D)
	).
'depends_on_ap/4__0'(B, C, D, E, A) :-
	A=suspension(F, not_stored_yet, t, B, C, D, E),
	'chr gen_id'(F),
	'depends_on_ap/4__1'(B, C, D, E, A).
'depends_on_ap/4__1'(C, A, D, E, F) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, B), !,
	'depends_on_ap/4__1__0'(B, C, A, D, E, F).
'depends_on_ap/4__1__0'([], A, B, C, D, E) :-
	'depends_on_ap/4__2'(A, B, C, D, E).
'depends_on_ap/4__1__0'([A|G], H, C, D, I, J) :-
	(   A=suspension(_, active, _, B, F),
	    B==C,
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E)
	->  'depends_on_ap/4__1__1'(E, F, A, G, H, C, D, I, J)
	;   'depends_on_ap/4__1__0'(G, H, C, D, I, J)
	).
'depends_on_ap/4__1__1'([], _, _, A, B, C, D, E, F) :-
	'depends_on_ap/4__1__0'(A, B, C, D, E, F).
'depends_on_ap/4__1__1'([A|U], L, B, V, K, I, D, O, E) :-
	(   A=suspension(_, active, _, C, S),
	    A\==B,
	    C==D,
	    F=t(269, E, B, A),
	    '$novel_production'(E, F),
	    '$novel_production'(B, F),
	    '$novel_production'(A, F)
	->  '$extend_history'(E, F),
	    arg(2, E, G),
	    setarg(2, E, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2', H),
		insert_ht(H, I, E),
		nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-3', J),
		insert_ht(J, D, E)
	    ;   true
	    ),
	    K=odom(occ(M, N), _),
	    (   ai_observation_is_observed(L, M)
	    ->  ai_observed_internal(M, N)
	    ;   ai_not_observed_internal(M, N)
	    ),
	    (   O==yes
	    ->  L=odom([], P),
		ord_del_element(P, M, Q),
		R=odom([], Q)
	    ;   R=L
	    ),
	    ai_observation_lub(R, S, T),
	    final_answer_pattern(K, T),
	    (   E=suspension(_, active, _, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'depends_on_ap/4__1__1'(U, L, B, V, K, I, D, O, E)
	    ;   true
	    )
	;   'depends_on_ap/4__1__1'(U, L, B, V, K, I, D, O, E)
	).
'depends_on_ap/4__1'(A, B, C, D, E) :-
	'depends_on_ap/4__2'(A, B, C, D, E).
'depends_on_ap/4__2'(_, D, F, _, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-2', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on_ap/4-3', E),
	    insert_ht(E, F, A)
	;   true
	).
depends_on_goal(A, B) :-
	'depends_on_goal/2__0'(A, B, _).
'depends_on_goal/2__0'(A, C, D) :-
	'$via1_multi_hash_depends_on/2-1'(A, B), !,
	'depends_on_goal/2__0__0'(B, A, C, D).
'depends_on_goal/2__0__0'([], A, B, C) :-
	'depends_on_goal/2__1'(A, B, C).
'depends_on_goal/2__0__0'([A|J], C, D, K) :-
	(   A=suspension(_, active, _, B, I),
	    B==C,
	    ground(D),
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E),
	    'chr sbag_member'(F, E),
	    F=suspension(_, active, _, _, _)
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-1', G),
	    delete_ht(G, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on/2-2', H),
	    delete_ht(H, I, A),
	    'depends_on_goal/2__0__0'(J, C, D, K)
	;   'depends_on_goal/2__0__0'(J, C, D, K)
	).
'depends_on_goal/2__0'(A, B, C) :-
	'depends_on_goal/2__1'(A, B, C).
'depends_on_goal/2__1'(C, A, B) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, E), !,
	B=suspension(D, not_stored_yet, t, C, A),
	'chr gen_id'(D),
	'depends_on_goal/2__1__0'(E, C, A, B).
'depends_on_goal/2__1__0'([], A, B, C) :-
	'depends_on_goal/2__2'(A, B, C).
'depends_on_goal/2__1__0'([A|M], H, C, D) :-
	(   A=suspension(_, active, _, B, I),
	    B==C,
	    E=t(254, D, A),
	    '$novel_production'(D, E),
	    '$novel_production'(A, E)
	->  '$extend_history'(D, E),
	    arg(2, D, F),
	    setarg(2, D, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_goal/2-2', G),
		insert_ht(G, C, D)
	    ;   true
	    ),
	    H=odom([_|J], _),
	    I=odom([], K),
	    L=odom(J, K),
	    call_pattern(L),
	    depends_on(H, L),
	    (   D=suspension(_, active, _, _, _)
	    ->  setarg(2, D, inactive),
		'depends_on_goal/2__1__0'(M, H, C, D)
	    ;   true
	    )
	;   'depends_on_goal/2__1__0'(M, H, C, D)
	).
'depends_on_goal/2__1'(B, C, A) :-
	A=suspension(D, not_stored_yet, t, B, C),
	'chr gen_id'(D),
	'depends_on_goal/2__2'(B, C, A).
'depends_on_goal/2__2'(_, D, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_goal/2-2', C),
	    insert_ht(C, D, A)
	;   true
	).
ai_observed_internal(A, B) :-
	'$via1_multi_hash_ai_not_observed_internal/2-12'(k(A, B), C), !,
	'ai_observed_internal/2__0__0'(C, A, B).
'ai_observed_internal/2__0__0'([], A, B) :-
	'ai_observed_internal/2__1'(A, B).
'ai_observed_internal/2__0__0'([A|K], C, E) :-
	(   A=suspension(_, active, _, B, D),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    arg(3, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', H),
		(   H=[I|_]
		->  setarg(3, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(3, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed_internal/2-12', J),
	    delete_ht(J, k(C, E), A),
	    'ai_observed_internal/2__0__0'(K, C, E)
	;   'ai_observed_internal/2__0__0'(K, C, E)
	).
ai_observed_internal(A, B) :-
	'ai_observed_internal/2__1'(A, B).
'ai_observed_internal/2__1'(A, B) :-
	'$via1_multi_hash_ai_observed_internal/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !.
'ai_observed_internal/2__1'(_, _) :-
	nb_getval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !.
'ai_observed_internal/2__1'(A, B) :-
	D=suspension(C, active, _, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', E),
	F=[D|E],
	b_setval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', F),
	(   E=[G|_]
	->  setarg(3, G, F)
	;   true
	),
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observed_internal/2-12', H),
	insert_ht(H, k(A, B), D).
ai_not_observed_internal(A, B) :-
	'$via1_multi_hash_ai_observed_internal/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !.
ai_not_observed_internal(A, B) :-
	'$via1_multi_hash_ai_not_observed_internal/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _), !.
ai_not_observed_internal(C, D) :-
	nb_getval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !,
	ai_not_observed(C, D).
ai_not_observed_internal(A, B) :-
	D=suspension(C, active, _, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', E),
	F=[D|E],
	b_setval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', F),
	(   E=[G|_]
	->  setarg(3, G, F)
	;   true
	),
	nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed_internal/2-12', H),
	insert_ht(H, k(A, B), D).
ai_not_observed(A, B) :-
	'ai_not_observed/2__0'(A, B, _).
'ai_not_observed/2__0'(A, B, C) :-
	'$via1_multi_hash_stored/3-12'(k(A, B), E), !,
	C=suspension(D, not_stored_yet, A, B),
	'chr gen_id'(D),
	'ai_not_observed/2__0__0'(E, A, B, C).
'ai_not_observed/2__0__0'([], A, B, C) :-
	'ai_not_observed/2__1'(A, B, C).
'ai_not_observed/2__0__0'([A|R], C, E, M) :-
	(   A=suspension(_, active, B, D, F),
	    B==C,
	    D==E,
	    F=yes,
	    ground(C),
	    '$via1_multi_hash_stored_complete/3-1'(C, G),
	    'chr sbag_member'(H, G),
	    H=suspension(_, active, _, _, I, P),
	    E<I
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored/3-1', J),
	    delete_ht(J, C, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored/3-12', K),
	    delete_ht(K, k(C, E), A),
	    setarg(2, H, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:stored_complete/3-1', L),
	    delete_ht(L, C, H),
	    arg(2, M, N),
	    setarg(2, M, active),
	    (   N==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed/2-12', O),
		insert_ht(O, k(C, E), M)
	    ;   true
	    ),
	    Q is P-1,
	    stored(C, E, maybe),
	    stored_complete(C, I, Q),
	    (   M=suspension(_, active, _, _)
	    ->  setarg(2, M, inactive),
		'ai_not_observed/2__0__0'(R, C, E, M)
	    ;   true
	    )
	;   'ai_not_observed/2__0__0'(R, C, E, M)
	).
'ai_not_observed/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, B, C),
	'chr gen_id'(D),
	'ai_not_observed/2__1'(B, C, A).
'ai_not_observed/2__1'(D, E, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed/2-12', C),
	    insert_ht(C, k(D, E), A)
	;   true
	).
ai_is_observed(A, B) :-
	'$via1_multi_hash_ai_not_observed/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !,
	fail.
ai_is_observed(_, _).
depends_on_as(A, B, C) :-
	'depends_on_as/3__0'(A, B, C, _).
'depends_on_as/3__0'(C, A, D, B) :-
	'$via1_multi_hash_final_answer_pattern/2-1'(A, F), !,
	B=suspension(E, not_stored_yet, t, C, A, D),
	'chr gen_id'(E),
	'depends_on_as/3__0__0'(F, C, A, D, B).
'depends_on_as/3__0__0'([], A, B, C, D) :-
	'depends_on_as/3__1'(A, B, C, D).
'depends_on_as/3__0__0'([A|G], H, C, D, I) :-
	(   A=suspension(_, active, _, B, F),
	    B==C,
	    '$via1_multi_hash_final_answer_pattern/2-1'(D, E)
	->  'depends_on_as/3__0__1'(E, F, A, G, H, C, D, I)
	;   'depends_on_as/3__0__0'(G, H, C, D, I)
	).
'depends_on_as/3__0__1'([], _, _, A, B, C, D, E) :-
	'depends_on_as/3__0__0'(A, B, C, D, E).
'depends_on_as/3__0__1'([A|O], K, B, P, M, J, D, E) :-
	(   A=suspension(_, active, _, C, L),
	    A\==B,
	    C==D,
	    F=t(260, E, B, A),
	    '$novel_production'(E, F),
	    '$novel_production'(B, F),
	    '$novel_production'(A, F)
	->  '$extend_history'(E, F),
	    arg(2, E, G),
	    setarg(2, E, active),
	    (   G==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-3', H),
		insert_ht(H, D, E),
		nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-2', I),
		insert_ht(I, J, E)
	    ;   true
	    ),
	    ai_observation_lub(K, L, N),
	    final_answer_pattern(M, N),
	    (   E=suspension(_, active, _, _, _, _)
	    ->  setarg(2, E, inactive),
		'depends_on_as/3__0__1'(O, K, B, P, M, J, D, E)
	    ;   true
	    )
	;   'depends_on_as/3__0__1'(O, K, B, P, M, J, D, E)
	).
'depends_on_as/3__0'(B, C, D, A) :-
	A=suspension(E, not_stored_yet, t, B, C, D),
	'chr gen_id'(E),
	'depends_on_as/3__1'(B, C, D, A).
'depends_on_as/3__1'(_, F, D, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-3', C),
	    insert_ht(C, D, A),
	    nb_getval('$chr_store_multi_hash_chr_translate:depends_on_as/3-2', E),
	    insert_ht(E, F, A)
	;   true
	).
ai_observation_gather_results :-
	'ai_observation_gather_results/0__0'(_).
'ai_observation_gather_results/0__0'(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', A), !,
	'ai_observation_gather_results/0__0__0'(A, B).
'ai_observation_gather_results/0__0__0'([], A) :-
	'ai_observation_gather_results/0__1'(A).
'ai_observation_gather_results/0__0__0'([A|I], J) :-
	(   A=suspension(_, active, _, G, H)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:ai_observed_internal/2', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:ai_observed_internal/2-12', F),
	    delete_ht(F, k(G, H), A),
	    'ai_observation_gather_results/0__0__0'(I, J)
	;   'ai_observation_gather_results/0__0__0'(I, J)
	).
'ai_observation_gather_results/0__0'(A) :-
	'ai_observation_gather_results/0__1'(A).
'ai_observation_gather_results/0__1'(A) :-
	nb_getval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', C), !,
	A=suspension(B, not_stored_yet, _),
	'chr gen_id'(B),
	'ai_observation_gather_results/0__1__0'(C, A).
'ai_observation_gather_results/0__1__0'([], A) :-
	'ai_observation_gather_results/0__2'(A).
'ai_observation_gather_results/0__1__0'([A|N], I) :-
	(   A=suspension(_, active, _, G, H)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:ai_not_observed_internal/2', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:ai_not_observed_internal/2-12', F),
	    delete_ht(F, k(G, H), A),
	    arg(2, I, J),
	    setarg(2, I, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', K),
		L=[I|K],
		b_setval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', L),
		(   K=[M|_]
		->  setarg(3, M, L)
		;   true
		)
	    ;   true
	    ),
	    ai_not_observed(G, H),
	    (   I=suspension(_, active, _)
	    ->  setarg(2, I, inactive),
		'ai_observation_gather_results/0__1__0'(N, I)
	    ;   true
	    )
	;   'ai_observation_gather_results/0__1__0'(N, I)
	).
'ai_observation_gather_results/0__1'(A) :-
	A=suspension(B, not_stored_yet, _),
	'chr gen_id'(B),
	'ai_observation_gather_results/0__2'(A).
'ai_observation_gather_results/0__2'(A) :-
	(   var(A)
	->  true
	;   arg(2, A, B),
	    setarg(2, A, removed),
	    (   B==not_stored_yet
	    ->  true
	    ;   arg(3, A, C),
		(   var(C)
		->  nb_getval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', D),
		    D=[_|E],
		    b_setval('$chr_store_global_ground_chr_translate:ai_observation_gather_results/0', E),
		    (   E=[F|_]
		    ->  setarg(3, F, _)
		    ;   true
		    )
		;   C=[_, _|E],
		    setarg(2, C, E),
		    (   E=[F|_]
		    ->  setarg(3, F, C)
		    ;   true
		    )
		)
	    )
	).
ai_observation_memo_simplification_rest_heads(A, B, E) :-
	'$via1_multi_hash_ai_observation_memoed_simplification_rest_heads/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, F), !,
	E=F.
ai_observation_memo_simplification_rest_heads(A, B, T) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, K, _),
	'$via1_multi_hash_rule/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, J),
	nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, O), !,
	J=pragma(rule(M, P, _, _), ids(L, _), _, _, _),
	once(select2(K, _, L, M, _, N)),
	ai_observation_abstract_constraints(N, O, Q),
	ai_observation_abstract_constraints(P, O, R),
	append(Q, R, S),
	sort(S, T),
	ai_observation_memoed_simplification_rest_heads(A, B, T).
ai_observation_memo_simplification_rest_heads(_, _, _) :-
	fail.
ai_observation_memoed_simplification_rest_heads(A, B, C) :-
	F=suspension(D, active, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_simplification_rest_heads/3-12', E),
	insert_ht(E, k(A, B), F).
ai_observation_memo_propagation_rest_heads(A, B, E) :-
	'$via1_multi_hash_ai_observation_memoed_propagation_rest_heads/3-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, F), !,
	E=F.
ai_observation_memo_propagation_rest_heads(A, B, T) :-
	'$via1_multi_hash_occurrence/5-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _, _, _, E, K, _),
	'$via1_multi_hash_rule/2-1'(E, F),
	'chr sbag_member'(G, F),
	G=suspension(_, active, _, _, _, J),
	nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', H),
	'chr sbag_member'(I, H),
	I=suspension(_, active, _, O), !,
	J=pragma(rule(P, M, _, _), ids(_, L), _, _, _),
	once(select2(K, _, L, M, _, N)),
	ai_observation_abstract_constraints(N, O, Q),
	ai_observation_abstract_constraints(P, O, R),
	append(Q, R, S),
	sort(S, T),
	ai_observation_memoed_propagation_rest_heads(A, B, T).
ai_observation_memo_propagation_rest_heads(_, _, _) :-
	fail.
ai_observation_memoed_propagation_rest_heads(A, B, C) :-
	F=suspension(D, active, A, B, C),
	'chr gen_id'(D),
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_propagation_rest_heads/3-12', E),
	insert_ht(E, k(A, B), F).
ai_observation_memoed_abstract_goal(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:ai_observation_memoed_abstract_goal/2-1', D),
	insert_ht(D, A, E).
ai_observation_memo_abstract_goal(A, D) :-
	'$via1_multi_hash_ai_observation_memoed_abstract_goal/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, E), !,
	D=E.
ai_observation_memo_abstract_goal(A, L) :-
	'$via1_multi_hash_rule/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _, _, F),
	nb_getval('$chr_store_global_ground_chr_translate:abstract_constraints/1', D),
	'chr sbag_member'(E, D),
	E=suspension(_, active, _, K), !,
	F=pragma(rule(G, H, I, J), _, _, _, _),
	ai_observation_abstract_goal_(G, H, I, J, K, M),
	L=M,
	ai_observation_memoed_abstract_goal(A, M).
ai_observation_memo_abstract_goal(A, B) :-
	D=suspension(C, active, _, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_global_ground_chr_translate:ai_observation_memo_abstract_goal/2', E),
	F=[D|E],
	b_setval('$chr_store_global_ground_chr_translate:ai_observation_memo_abstract_goal/2', F),
	(   E=[G|_]
	->  setarg(3, G, F)
	;   true
	).
partial_wake_analysis :-
	'partial_wake_analysis/0__0'(_).
'partial_wake_analysis/0__0'(A) :-
	nb_getval('$chr_store_global_ground_chr_translate:occurrence/5', C), !,
	A=suspension(B, not_stored_yet, t, _),
	'chr gen_id'(B),
	'partial_wake_analysis/0__0__0'(C, A).
'partial_wake_analysis/0__0__0'([], A) :-
	'partial_wake_analysis/0__1'(A).
'partial_wake_analysis/0__0__0'([A|G], H) :-
	(   A=suspension(_, active, _, _, D, _, B, E, F),
	    '$via1_multi_hash_rule/2-1'(B, C)
	->  'partial_wake_analysis/0__0__1'(C, D, B, E, F, A, G, H)
	;   'partial_wake_analysis/0__0__0'(G, H)
	).
'partial_wake_analysis/0__0__1'([], _, _, _, _, _, A, B) :-
	'partial_wake_analysis/0__0__0'(A, B).
'partial_wake_analysis/0__0__1'([A|G], D, C, H, I, J, K, L) :-
	(   A=suspension(_, active, _, _, B, F),
	    B==C,
	    '$via1_multi_hash_constraint_mode/2-1'(D, E)
	->  'partial_wake_analysis/0__0__2'(E, F, A, G, D, C, H, I, J, K, L)
	;   'partial_wake_analysis/0__0__1'(G, D, C, H, I, J, K, L)
	).
'partial_wake_analysis/0__0__2'([], _, _, A, B, C, D, E, F, G, H) :-
	'partial_wake_analysis/0__0__1'(A, B, C, D, E, F, G, H).
'partial_wake_analysis/0__0__2'([A|W], L, F, X, C, M, N, O, E, Y, D) :-
	(   A=suspension(_, active, _, _, B, T),
	    B==C,
	    G=t(273, D, E, F, A),
	    '$novel_production'(D, G),
	    '$novel_production'(E, G),
	    '$novel_production'(F, G),
	    '$novel_production'(A, G)
	->  '$extend_history'(D, G),
	    arg(2, D, H),
	    setarg(2, D, active),
	    (   H==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', I),
		J=[D|I],
		b_setval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', J),
		(   I=[K|_]
		->  setarg(4, K, J)
		;   true
		)
	    ;   true
	    ),
	    L=pragma(rule(P, V, R, _), _, _, _, _),
	    (   is_passive(M, N)
	    ->  true
	    ;   O==simplification
	    ->  select(Q, P, _),
		Q=..[_|S],
		term_variables(R, U),
		partial_wake_args(S, T, U, C)
	    ;   select(Q, V, _),
		Q=..[_|S],
		term_variables(R, U),
		partial_wake_args(S, T, U, C)
	    ),
	    (   D=suspension(_, active, _, _)
	    ->  setarg(2, D, inactive),
		'partial_wake_analysis/0__0__2'(W, L, F, X, C, M, N, O, E, Y, D)
	    ;   true
	    )
	;   'partial_wake_analysis/0__0__2'(W, L, F, X, C, M, N, O, E, Y, D)
	).
'partial_wake_analysis/0__0'(A) :-
	A=suspension(B, not_stored_yet, t, _),
	'chr gen_id'(B),
	'partial_wake_analysis/0__1'(A).
'partial_wake_analysis/0__1'(A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:partial_wake_analysis/0', D),
	    (   C=[E|_]
	    ->  setarg(4, E, D)
	    ;   true
	    )
	;   true
	).
no_partial_wake(A) :-
	'$via1_multi_hash_no_partial_wake/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !.
no_partial_wake(A) :-
	D=suspension(B, active, A),
	'chr gen_id'(B),
	nb_getval('$chr_store_multi_hash_chr_translate:no_partial_wake/1-1', C),
	insert_ht(C, A, D).
wakes_partially(A) :-
	'$via1_multi_hash_no_partial_wake/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !,
	fail.
wakes_partially(_).
phase_end(A) :-
	'phase_end/1__0'(A, _).
'phase_end/1__0'(A, B) :-
	'$via1_multi_hash_delay_phase_end/2-1'(A, D), !,
	B=suspension(C, not_stored_yet, A),
	'chr gen_id'(C),
	'phase_end/1__0__0'(D, A, B).
'phase_end/1__0__0'([], A, B) :-
	'phase_end/1__1'(A, B).
'phase_end/1__0__0'([A|I], C, E) :-
	(   A=suspension(_, active, B, H),
	    B==C
	->  setarg(2, A, removed),
	    nb_getval('$chr_store_multi_hash_chr_translate:delay_phase_end/2-1', D),
	    delete_ht(D, C, A),
	    arg(2, E, F),
	    setarg(2, E, active),
	    (   F==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:phase_end/1-1', G),
		insert_ht(G, C, E)
	    ;   true
	    ),
	    call(H),
	    (   E=suspension(_, active, _)
	    ->  setarg(2, E, inactive),
		'phase_end/1__0__0'(I, C, E)
	    ;   true
	    )
	;   'phase_end/1__0__0'(I, C, E)
	).
'phase_end/1__0'(B, A) :-
	A=suspension(C, not_stored_yet, B),
	'chr gen_id'(C),
	'phase_end/1__1'(B, A).
'phase_end/1__1'(D, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:phase_end/1-1', C),
	    insert_ht(C, D, A)
	;   true
	).
delay_phase_end(A, D) :-
	'$via1_multi_hash_phase_end/1-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _), !,
	call(D).
delay_phase_end(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:delay_phase_end/2-1', D),
	insert_ht(D, A, E).
does_use_history(A, B) :-
	'$via1_multi_hash_does_use_history/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
does_use_history(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:does_use_history/2-1', D),
	insert_ht(D, A, E),
	nb_getval('$chr_store_multi_hash_chr_translate:does_use_history/2-12', F),
	insert_ht(F, k(A, B), E).
uses_history(A) :-
	'$via1_multi_hash_does_use_history/2-1'(A, B),
	'chr sbag_member'(C, B),
	C=suspension(_, active, _, _), !.
uses_history(_) :-
	fail.
novel_production_call(A, B, F, E) :-
	'$via1_multi_hash_does_use_history/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !,
	E=F.
novel_production_call(_, _, _, true).
does_use_field(A, B) :-
	'$via1_multi_hash_does_use_field/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
does_use_field(A, B) :-
	E=suspension(C, active, A, B),
	'chr gen_id'(C),
	nb_getval('$chr_store_multi_hash_chr_translate:does_use_field/2-12', D),
	insert_ht(D, k(A, B), E).
uses_field(A, B) :-
	'$via1_multi_hash_does_use_field/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
uses_field(_, _) :-
	fail.
uses_state(A, B) :-
	'uses_state/2__0'(A, B, _).
'uses_state/2__0'(A, B, _) :-
	'$via1_multi_hash_uses_state/2-12'(k(A, B), C),
	'chr sbag_member'(D, C),
	D=suspension(_, active, _, _), !.
'uses_state/2__0'(B, C, A) :-
	nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', E), !,
	A=suspension(D, not_stored_yet, B, C),
	'chr gen_id'(D),
	'uses_state/2__0__0'(E, B, C, A).
'uses_state/2__0__0'([], A, B, C) :-
	'uses_state/2__1'(A, B, C).
'uses_state/2__0__0'([A|E], B, C, F) :-
	(   A=suspension(_, active, _),
	    '$via1_multi_hash_if_used_state/5-12'(k(B, C), D)
	->  'uses_state/2__0__1'(D, A, E, B, C, F)
	;   'uses_state/2__0__0'(E, B, C, F)
	).
'uses_state/2__0__1'([], _, A, B, C, D) :-
	'uses_state/2__0__0'(A, B, C, D).
'uses_state/2__0__1'([A|P], Q, R, C, E, K) :-
	(   A=suspension(_, active, _, B, D, O, _, N),
	    B==C,
	    D==E
	->  setarg(2, A, removed),
	    arg(3, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:if_used_state/5', H),
		(   H=[I|_]
		->  setarg(3, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(3, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:if_used_state/5-12', J),
	    delete_ht(J, k(C, E), A),
	    arg(2, K, L),
	    setarg(2, K, active),
	    (   L==not_stored_yet
	    ->  nb_getval('$chr_store_multi_hash_chr_translate:uses_state/2-12', M),
		insert_ht(M, k(C, E), K)
	    ;   true
	    ),
	    N=O,
	    (   K=suspension(_, active, _, _)
	    ->  setarg(2, K, inactive),
		'uses_state/2__0__1'(P, Q, R, C, E, K)
	    ;   true
	    )
	;   'uses_state/2__0__1'(P, Q, R, C, E, K)
	).
'uses_state/2__0'(B, C, A) :-
	A=suspension(D, not_stored_yet, B, C),
	'chr gen_id'(D),
	'uses_state/2__1'(B, C, A).
'uses_state/2__1'(D, E, A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_multi_hash_chr_translate:uses_state/2-12', C),
	    insert_ht(C, k(D, E), A)
	;   true
	).
if_used_state(C, D, H, _, G) :-
	nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _),
	'$via1_multi_hash_uses_state/2-12'(k(C, D), E),
	'chr sbag_member'(F, E),
	F=suspension(_, active, _, _), !,
	G=H.
if_used_state(_, _, _, D, C) :-
	nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', A),
	'chr sbag_member'(B, A),
	B=suspension(_, active, _), !,
	C=D.
if_used_state(A, B, C, D, E) :-
	G=suspension(F, active, _, A, B, C, D, E),
	'chr gen_id'(F),
	nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', H),
	I=[G|H],
	b_setval('$chr_store_global_ground_chr_translate:if_used_state/5', I),
	(   H=[J|_]
	->  setarg(3, J, I)
	;   true
	),
	nb_getval('$chr_store_multi_hash_chr_translate:if_used_state/5-12', K),
	insert_ht(K, k(A, B), G).
used_states_known :-
	'used_states_known/0__0'(_).
'used_states_known/0__0'(A) :-
	nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', C), !,
	A=suspension(B, not_stored_yet, _),
	'chr gen_id'(B),
	'used_states_known/0__0__0'(C, A).
'used_states_known/0__0__0'([], A) :-
	'used_states_known/0__1'(A).
'used_states_known/0__0__0'([A|R], K) :-
	(   A=suspension(_, active, _, B, C, Q, _, P),
	    ground(B),
	    ground(C),
	    '$via1_multi_hash_uses_state/2-12'(k(B, C), D),
	    'chr sbag_member'(E, D),
	    E=suspension(_, active, _, _)
	->  setarg(2, A, removed),
	    arg(3, A, F),
	    (   var(F)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', G),
		G=[_|H],
		b_setval('$chr_store_global_ground_chr_translate:if_used_state/5', H),
		(   H=[I|_]
		->  setarg(3, I, _)
		;   true
		)
	    ;   F=[_, _|H],
		setarg(2, F, H),
		(   H=[I|_]
		->  setarg(3, I, F)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:if_used_state/5-12', J),
	    delete_ht(J, k(B, C), A),
	    arg(2, K, L),
	    setarg(2, K, active),
	    (   L==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', M),
		N=[K|M],
		b_setval('$chr_store_global_ground_chr_translate:used_states_known/0', N),
		(   M=[O|_]
		->  setarg(3, O, N)
		;   true
		)
	    ;   true
	    ),
	    P=Q,
	    (   K=suspension(_, active, _)
	    ->  setarg(2, K, inactive),
		'used_states_known/0__0__0'(R, K)
	    ;   true
	    )
	;   'used_states_known/0__0__0'(R, K)
	).
'used_states_known/0__0'(A) :-
	A=suspension(B, not_stored_yet, _),
	'chr gen_id'(B),
	'used_states_known/0__1'(A).
'used_states_known/0__1'(B) :-
	nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', A), !,
	'used_states_known/0__1__0'(A, B).
'used_states_known/0__1__0'([], A) :-
	'used_states_known/0__2'(A).
'used_states_known/0__1__0'([A|P], I) :-
	(   A=suspension(_, active, _, G, H, _, O, N)
	->  setarg(2, A, removed),
	    arg(3, A, B),
	    (   var(B)
	    ->  nb_getval('$chr_store_global_ground_chr_translate:if_used_state/5', C),
		C=[_|D],
		b_setval('$chr_store_global_ground_chr_translate:if_used_state/5', D),
		(   D=[E|_]
		->  setarg(3, E, _)
		;   true
		)
	    ;   B=[_, _|D],
		setarg(2, B, D),
		(   D=[E|_]
		->  setarg(3, E, B)
		;   true
		)
	    ),
	    nb_getval('$chr_store_multi_hash_chr_translate:if_used_state/5-12', F),
	    delete_ht(F, k(G, H), A),
	    arg(2, I, J),
	    setarg(2, I, active),
	    (   J==not_stored_yet
	    ->  nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', K),
		L=[I|K],
		b_setval('$chr_store_global_ground_chr_translate:used_states_known/0', L),
		(   K=[M|_]
		->  setarg(3, M, L)
		;   true
		)
	    ;   true
	    ),
	    N=O,
	    (   I=suspension(_, active, _)
	    ->  setarg(2, I, inactive),
		'used_states_known/0__1__0'(P, I)
	    ;   true
	    )
	;   'used_states_known/0__1__0'(P, I)
	).
'used_states_known/0__1'(A) :-
	'used_states_known/0__2'(A).
'used_states_known/0__2'(A) :-
	arg(2, A, B),
	setarg(2, A, active),
	(   B==not_stored_yet
	->  nb_getval('$chr_store_global_ground_chr_translate:used_states_known/0', C),
	    D=[A|C],
	    b_setval('$chr_store_global_ground_chr_translate:used_states_known/0', D),
	    (   C=[E|_]
	    ->  setarg(3, E, D)
	    ;   true
	    )
	;   true
	).
end_of_file.
