#
# DO NOT MODIFY!!!!
# This file is automatically generated by racc 1.4.5
# from racc grammer file "grammar.ra".
#

require 'racc/parser'


require 'puppet'
require 'puppet/util/loadedfile'
require 'puppet/parser/lexer'
require 'puppet/parser/ast'
#require 'puppet/parser/interpreter'

module Puppet
    class ParseError < Puppet::Error; end

    class ImportError < Racc::ParseError; end
end

Puppet[:typecheck] = true
Puppet[:paramcheck] = true


module Puppet

  module Parser

    class Parser < Racc::Parser

module_eval <<'..end grammar.ra modeval..id2ea020a302', 'grammar.ra', 606
require 'puppet/parser/functions'

attr_reader :file, :interp
attr_accessor :files

# Add context to a message; useful for error messages and such.
def addcontext(message, obj = nil)
    obj ||= @lexer

    message += " on line %s" % obj.line
    if file = obj.file
        message += " in file %s" % file
    end

    return message
end

# Create an AST array out of all of the args
def aryfy(*args)
    if args[0].instance_of?(AST::ASTArray)
        result = args.shift
        args.each { |arg|
            result.push arg
        }
    else
        result = ast AST::ASTArray, :children => args
    end

    return result
end

# Create an AST object, and automatically add the file and line information if
# available.
def ast(klass, hash = nil)
    hash ||= {}
    unless hash.include?(:line)
        hash[:line] = @lexer.line
    end

    unless hash.include?(:file)
        if file = @lexer.file
            hash[:file] = file
        end
    end

    return klass.new(hash)
end

# Raise a Parse error.
def error(message)
    except = Puppet::ParseError.new(message)
    except.line = @lexer.line
    if @lexer.file
        except.file = @lexer.file
    end

    raise except
end

def file=(file)
    unless FileTest.exists?(file)
        unless file =~ /\.pp$/
            file = file + ".pp"
        end
        unless FileTest.exists?(file)
            raise Puppet::Error, "Could not find file %s" % file
        end
    end
    if @files.detect { |f| f.file == file }
        raise Puppet::ImportError.new("Import loop detected")
    else
        @files << Puppet::Util::LoadedFile.new(file)
        @lexer.file = file
    end
end

# Import our files.
def import(file)
    if Puppet[:ignoreimport]
        return AST::ASTArray.new(:children => [])
    end
    # use a path relative to the file doing the importing
    if @lexer.file
        dir = @lexer.file.sub(%r{[^/]+$},'').sub(/\/$/, '')
    else
        dir = "."
    end
    if dir == ""
        dir = "."
    end
    result = ast AST::ASTArray

    # We can't interpolate at this point since we don't have any
    # scopes set up. Warn the user if they use a variable reference
    pat = file
    if pat.index("$")
        Puppet.warning(
           "The import of #{pat} contains a variable reference;" +
           " variables are not interpolated for imports " +
           "in file #{@lexer.file} at line #{@lexer.line}"
        )
    end
    files = Puppet::Module::find_manifests(pat, dir)
    if files.size == 0
        raise Puppet::ImportError.new("No file(s) found for import " +
                                      "of '#{pat}'")
    end

    files.collect { |file|
        parser = Puppet::Parser::Parser.new(interp)
        parser.files = self.files
        Puppet.debug("importing '%s'" % file)

        unless file =~ /^#{File::SEPARATOR}/
            file = File.join(dir, file)
        end
        begin
            parser.file = file
        rescue Puppet::ImportError
            Puppet.warning(
                "Importing %s would result in an import loop" %
                    File.join(dir, file)
            )
            next
        end

        # This will normally add code to the 'main' class.
        parser.parse
    }
end

def initialize(interpreter)
    @interp = interpreter
    initvars()
end

# Initialize or reset all of our variables.
def initvars
    @lexer = Puppet::Parser::Lexer.new()
    @files = []
end

# The fully qualifed name, with the full namespace.
def fqname(name)
    [@lexer.namespace, name].join("::").sub(/^::/, '')
end

def on_error(token,value,stack)
    #on '%s' at '%s' in\n'%s'" % [token,value,stack]
    #error = "line %s: parse error after '%s'" %
    #    [@lexer.line,@lexer.last]
    error = "Syntax error at '%s'" % [value]

    except = Puppet::ParseError.new(error)
    except.line = @lexer.line
    if @lexer.file
        except.file = @lexer.file
    end

    raise except
end

# how should I do error handling here?
def parse(string = nil)
    if string
        self.string = string
    end
    begin
        main = yyparse(@lexer,:scan)
    rescue Racc::ParseError => except
        error = Puppet::ParseError.new(except)
        error.line = @lexer.line
        error.file = @lexer.file
        error.set_backtrace except.backtrace
        raise error
    rescue Puppet::ParseError => except
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue Puppet::Error => except
        # and this is a framework error
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue Puppet::DevError => except
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue => except
        error = Puppet::DevError.new(except.message)
        error.line = @lexer.line
        error.file = @lexer.file
        error.set_backtrace except.backtrace
        raise error
    end
    if main
        # Store the results as the top-level class.
        interp.newclass("", :code => main)
        return main
    end
ensure
    @lexer.clear
end

# See if any of the files have changed.
def reparse?
    if file = @files.detect { |file| file.changed?  }
        return file.stamp
    else
        return false
    end
end

def string=(string)
    @lexer.string = string
end

# Make emacs happy
# Local Variables:
# mode: ruby
# End:

# $Id: parser.rb 2393 2007-04-19 18:34:03Z luke $

..end grammar.ra modeval..id2ea020a302

##### racc 1.4.5 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 51, :_reduce_1,
 1, 51, :_reduce_none,
 1, 52, :_reduce_none,
 2, 52, :_reduce_4,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 4, 62, :_reduce_17,
 3, 62, :_reduce_18,
 2, 62, :_reduce_19,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 68, :_reduce_none,
 3, 68, :_reduce_23,
 1, 70, :_reduce_none,
 1, 70, :_reduce_none,
 1, 70, :_reduce_none,
 1, 70, :_reduce_27,
 1, 69, :_reduce_none,
 3, 69, :_reduce_29,
 5, 55, :_reduce_30,
 5, 55, :_reduce_31,
 5, 55, :_reduce_32,
 5, 66, :_reduce_33,
 2, 56, :_reduce_34,
 1, 80, :_reduce_35,
 2, 80, :_reduce_36,
 2, 57, :_reduce_37,
 1, 81, :_reduce_none,
 1, 81, :_reduce_none,
 3, 82, :_reduce_40,
 3, 82, :_reduce_41,
 1, 83, :_reduce_none,
 1, 83, :_reduce_none,
 3, 83, :_reduce_44,
 1, 84, :_reduce_none,
 3, 84, :_reduce_46,
 1, 85, :_reduce_none,
 1, 85, :_reduce_none,
 3, 86, :_reduce_49,
 3, 86, :_reduce_50,
 1, 87, :_reduce_none,
 1, 87, :_reduce_none,
 4, 89, :_reduce_53,
 1, 76, :_reduce_none,
 3, 76, :_reduce_55,
 0, 77, :_reduce_none,
 1, 77, :_reduce_none,
 1, 71, :_reduce_58,
 1, 91, :_reduce_59,
 1, 90, :_reduce_none,
 1, 90, :_reduce_none,
 1, 90, :_reduce_none,
 1, 90, :_reduce_none,
 1, 90, :_reduce_none,
 1, 90, :_reduce_none,
 3, 58, :_reduce_66,
 0, 78, :_reduce_67,
 1, 78, :_reduce_68,
 3, 78, :_reduce_69,
 3, 95, :_reduce_70,
 1, 96, :_reduce_none,
 3, 96, :_reduce_72,
 1, 88, :_reduce_none,
 1, 88, :_reduce_none,
 1, 88, :_reduce_none,
 1, 88, :_reduce_none,
 1, 88, :_reduce_none,
 1, 88, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 1, 94, :_reduce_none,
 4, 99, :_reduce_88,
 3, 99, :_reduce_89,
 1, 73, :_reduce_90,
 1, 73, :_reduce_91,
 1, 98, :_reduce_92,
 4, 74, :_reduce_93,
 4, 74, :_reduce_94,
 6, 60, :_reduce_95,
 0, 101, :_reduce_none,
 4, 101, :_reduce_97,
 1, 100, :_reduce_none,
 5, 59, :_reduce_99,
 1, 102, :_reduce_none,
 2, 102, :_reduce_101,
 5, 103, :_reduce_102,
 4, 103, :_reduce_103,
 1, 104, :_reduce_none,
 3, 104, :_reduce_105,
 3, 92, :_reduce_106,
 1, 106, :_reduce_none,
 4, 106, :_reduce_108,
 1, 108, :_reduce_none,
 3, 108, :_reduce_110,
 3, 107, :_reduce_111,
 1, 105, :_reduce_none,
 1, 105, :_reduce_none,
 1, 105, :_reduce_none,
 1, 105, :_reduce_none,
 1, 105, :_reduce_none,
 1, 105, :_reduce_none,
 1, 105, :_reduce_118,
 1, 109, :_reduce_119,
 3, 109, :_reduce_120,
 2, 61, :_reduce_121,
 6, 63, :_reduce_122,
 5, 63, :_reduce_123,
 6, 64, :_reduce_124,
 5, 64, :_reduce_125,
 6, 65, :_reduce_126,
 5, 65, :_reduce_127,
 1, 75, :_reduce_none,
 1, 75, :_reduce_none,
 1, 112, :_reduce_none,
 3, 112, :_reduce_131,
 1, 114, :_reduce_none,
 1, 114, :_reduce_none,
 1, 114, :_reduce_none,
 0, 53, :_reduce_135,
 0, 115, :_reduce_136,
 1, 110, :_reduce_none,
 3, 110, :_reduce_138,
 3, 110, :_reduce_139,
 1, 116, :_reduce_none,
 3, 116, :_reduce_141,
 3, 117, :_reduce_142,
 1, 117, :_reduce_143,
 3, 117, :_reduce_144,
 1, 117, :_reduce_145,
 1, 113, :_reduce_none,
 2, 113, :_reduce_147,
 1, 111, :_reduce_none,
 2, 111, :_reduce_149,
 1, 118, :_reduce_none,
 1, 118, :_reduce_none,
 1, 119, :_reduce_none,
 1, 119, :_reduce_none,
 1, 72, :_reduce_154,
 3, 93, :_reduce_155,
 2, 93, :_reduce_156,
 1, 97, :_reduce_none,
 1, 97, :_reduce_none,
 0, 79, :_reduce_none,
 1, 79, :_reduce_160 ]

racc_reduce_n = 161

racc_shift_n = 263

racc_action_table = [
    49,    51,    53,    41,  -128,    51,    53,    51,    53,    51,
    53,   188,    58,    96,    49,   110,    58,    63,    51,    53,
    46,    43,    58,    33,   116,   170,   156,   107,   217,    88,
     4,    45,   163,    74,   116,    45,    55,    45,    93,    45,
    98,   191,    55,    47,    98,    44,   192,    47,    45,    47,
    36,    47,    65,    69,   153,   154,    75,    63,    51,    53,
    33,   233,   187,    63,    51,    53,   113,     4,    79,    63,
    51,    53,    80,    74,   232,    63,    51,    53,   187,    74,
   158,    63,    51,    53,    38,    74,   196,    39,    45,   157,
   191,    74,    65,    69,    45,   192,    75,    74,    65,    69,
    45,   187,    75,   198,    65,    69,    45,  -113,    75,  -112,
    65,    69,    45,   185,    75,    97,    65,    69,    51,    53,
    75,    63,    51,    53,  -115,   205,    45,    63,    51,    53,
  -114,    98,   200,    63,    51,    53,  -112,    74,  -113,    63,
    51,    53,   117,    74,  -115,    63,    51,    53,   112,    74,
   153,   154,    45,   167,   247,    74,    65,    69,    45,  -116,
    75,   140,    65,    69,    45,    49,    75,    79,    65,    69,
    45,    49,    75,  -114,    65,    69,    45,   116,    75,   241,
    65,   174,    33,   218,    75,    63,    51,    53,   224,     4,
    18,    63,    51,    53,   111,   223,   110,    36,    51,    53,
    15,    74,    21,    25,    79,     1,     5,   140,     8,   225,
    13,   121,    17,   140,    26,   161,    45,     4,   240,   228,
    65,    69,    45,   160,    75,   230,    65,   137,    45,    18,
    75,    38,    65,   174,    39,   147,    75,   234,   148,    15,
   231,    21,    25,    97,     1,     5,  -117,     8,    18,    13,
    80,    17,   236,    26,    45,   121,     4,   238,    15,    98,
    21,    25,   262,     1,     5,   118,     8,    91,    13,   188,
    17,    97,    26,    18,   166,     4,  -113,    33,   167,   169,
   144,   253,    45,    15,     4,    21,    25,    98,     1,     5,
    97,     8,    18,    13,  -112,    17,  -115,    26,    51,    53,
     4,    45,    15,  -114,    21,    25,    98,     1,     5,  -117,
     8,   243,    13,   140,    17,    87,    26,   150,   258,     4,
    51,    53,   159,   248,   222,   123,   153,   154,    45,    18,
    51,    53,    65,   174,    84,   140,    75,    51,    53,    15,
   143,    21,    25,   121,     1,     5,    81,     8,   187,    13,
    45,    17,   140,    26,    65,   174,     4,   261,    75,   255,
   256,   126,  -160,   121,   124,    32,   229,    45,    18,   nil,
   nil,    65,   174,   nil,   nil,    75,   215,   nil,    15,   nil,
    21,    25,   nil,     1,     5,   nil,     8,    18,    13,   nil,
    17,   nil,    26,    51,    53,     4,   nil,    15,   nil,    21,
    25,   nil,     1,     5,   nil,     8,   nil,    13,   140,    17,
   nil,    26,   nil,   nil,     4,    51,    53,    51,    53,   nil,
   177,   nil,   nil,    45,   nil,   nil,   nil,    65,   174,   nil,
   140,    75,   140,   203,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    18,    45,   nil,    45,   nil,    65,
   174,    65,   174,    75,    15,    75,    21,    25,   201,     1,
     5,   nil,     8,   nil,    13,   nil,    17,   nil,    26,    18,
   nil,     4,   nil,    51,    53,   nil,   nil,   nil,   nil,    15,
   nil,    21,    25,   nil,     1,     5,   nil,     8,   140,    13,
   nil,    17,   nil,    26,   nil,   nil,     4,   nil,   nil,   nil,
    18,   nil,   nil,    45,   nil,   nil,   nil,    65,   174,   nil,
    15,    75,    21,    25,   nil,     1,     5,   nil,     8,    18,
    13,   nil,    17,   nil,    26,   nil,   nil,     4,   nil,    15,
   nil,    21,    25,   nil,     1,     5,   nil,     8,    18,    13,
   nil,    17,   nil,    26,   nil,   nil,     4,   nil,    15,   nil,
    21,    25,   nil,     1,     5,   nil,     8,    18,    13,   nil,
    17,   nil,    26,   nil,   nil,     4,   nil,    15,   nil,    21,
    25,   nil,     1,     5,   nil,     8,   nil,    13,   nil,    17,
   nil,    26,   nil,   nil,     4 ]

racc_action_check = [
    13,    13,    13,     9,    13,   116,   116,    46,    46,   110,
   110,   137,   111,    35,    69,   171,    13,    17,    17,    17,
    13,    11,    46,     9,   137,   116,   101,    46,   171,    27,
     9,    13,   111,    17,    69,   116,    13,    46,    35,   110,
   116,   126,    46,    13,   110,    11,   126,   116,    17,    46,
     8,   110,    17,    17,   101,   101,    17,    49,    49,    49,
    25,   194,   125,    63,    63,    63,    63,    25,    18,    15,
    15,    15,    18,    49,   194,   168,   168,   168,   120,    63,
   105,    79,    79,    79,     8,    15,   127,     8,    49,   105,
   233,   168,    49,    49,    63,   233,    49,    79,    63,    63,
    15,   131,    63,   132,    15,    15,   168,   133,    15,   136,
   168,   168,    79,   119,   168,    44,    79,    79,    21,    21,
    79,   188,   188,   188,   138,   152,    44,   230,   230,   230,
   139,    44,   142,   229,   229,   229,    68,   188,    64,    32,
    32,    32,    70,   230,    72,   200,   200,   200,    62,   229,
   152,   152,   188,   220,   220,    32,   188,   188,   230,    61,
   188,   200,   230,   230,   229,   163,   230,    58,   229,   229,
    32,    55,   229,    73,    32,    32,   200,   174,    32,   204,
   200,   200,     5,   176,   200,   218,   218,   218,   183,     5,
   204,    88,    88,    88,    52,   183,    50,    96,   224,   224,
   204,   218,   204,   204,    74,   204,   204,    88,   204,   186,
   204,   187,   204,   224,   204,   109,   218,   204,   202,   190,
   218,   218,    88,   108,   218,   192,    88,    88,   224,   202,
    88,    96,   224,   224,    96,    93,   224,   196,    93,   202,
   193,   202,   202,   155,   202,   202,    77,   202,   196,   202,
    41,   202,   197,   202,   155,   198,   202,   199,   196,   155,
   196,   196,   260,   196,   196,    78,   196,    34,   196,   121,
   196,    97,   196,   260,   115,   196,   208,    91,   115,   115,
    91,   235,    97,   260,    91,   260,   260,    97,   260,   260,
    43,   260,   235,   260,   210,   260,   211,   260,   246,   246,
   260,    43,   235,   212,   235,   235,    43,   235,   235,   213,
   235,   215,   235,   246,   235,    26,   235,    94,   248,   235,
   181,   181,   106,   223,   181,    81,   106,   106,   246,   248,
   124,   124,   246,   246,    22,   181,   246,   177,   177,   248,
    90,   248,   248,    80,   248,   248,    20,   248,   237,   248,
   181,   248,   177,   248,   181,   181,   248,   259,   181,   243,
   245,    86,   247,    84,    83,     1,   191,   177,   259,   nil,
   nil,   177,   177,   nil,   nil,   177,   165,   nil,   259,   nil,
   259,   259,   nil,   259,   259,   nil,   259,   165,   259,   nil,
   259,   nil,   259,   118,   118,   259,   nil,   165,   nil,   165,
   165,   nil,   165,   165,   nil,   165,   nil,   165,   118,   165,
   nil,   165,   nil,   nil,   165,   157,   157,   117,   117,   nil,
   117,   nil,   nil,   118,   nil,   nil,   nil,   118,   118,   nil,
   157,   118,   117,   150,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   150,   157,   nil,   117,   nil,   157,
   157,   117,   117,   157,   150,   117,   150,   150,   143,   150,
   150,   nil,   150,   nil,   150,   nil,   150,   nil,   150,   143,
   nil,   150,   nil,   158,   158,   nil,   nil,   nil,   nil,   143,
   nil,   143,   143,   nil,   143,   143,   nil,   143,   158,   143,
   nil,   143,   nil,   143,   nil,   nil,   143,   nil,   nil,   nil,
   112,   nil,   nil,   158,   nil,   nil,   nil,   158,   158,   nil,
   112,   158,   112,   112,   nil,   112,   112,   nil,   112,   255,
   112,   nil,   112,   nil,   112,   nil,   nil,   112,   nil,   255,
   nil,   255,   255,   nil,   255,   255,   nil,   255,    24,   255,
   nil,   255,   nil,   255,   nil,   nil,   255,   nil,    24,   nil,
    24,    24,   nil,    24,    24,   nil,    24,     0,    24,   nil,
    24,   nil,    24,   nil,   nil,    24,   nil,     0,   nil,     0,
     0,   nil,     0,     0,   nil,     0,   nil,     0,   nil,     0,
   nil,     0,   nil,   nil,     0 ]

racc_action_pointer = [
   539,   352,   nil,   nil,   nil,   144,   nil,   nil,    46,   -15,
   nil,     2,   nil,    -2,   nil,    67,   nil,    15,    66,   nil,
   346,   115,   328,   nil,   520,    22,   273,    23,   nil,   nil,
   nil,   nil,   137,   nil,   232,     3,   nil,   nil,   nil,   nil,
   nil,   244,   nil,   268,    93,   nil,     4,   nil,   nil,    55,
   186,   nil,   184,   nil,   nil,   169,   nil,   nil,   165,   nil,
   nil,   138,   142,    61,   117,   nil,   nil,   nil,   115,    12,
   121,   nil,   123,   152,   202,   nil,   nil,   225,   259,    79,
   305,   325,   nil,   354,   325,   nil,   339,   nil,   189,   nil,
   334,   239,   nil,   197,   311,   nil,   193,   249,   nil,   nil,
   nil,     6,   nil,   nil,   nil,    65,   278,   nil,   200,   210,
     6,    -6,   482,   nil,   nil,   269,     2,   414,   390,   108,
    68,   260,   nil,   nil,   327,    52,     8,    80,   nil,   nil,
   nil,    91,    86,    86,   nil,   nil,    88,     2,   103,   109,
   nil,   nil,    93,   451,   nil,   nil,   nil,   nil,   nil,   nil,
   426,   nil,   102,   nil,   nil,   221,   nil,   412,   470,   nil,
   nil,   nil,   nil,   163,   nil,   369,   nil,   nil,    73,   nil,
   nil,     5,   nil,   nil,   155,   nil,   174,   334,   nil,   nil,
   nil,   317,   nil,   178,   nil,   nil,   202,   173,   119,   nil,
   212,   353,   212,   217,    51,   nil,   230,   245,   217,   250,
   143,   nil,   211,   nil,   172,   nil,   nil,   nil,   255,   nil,
   273,   275,   282,   288,   nil,   282,   nil,   nil,   183,   nil,
   144,   nil,   nil,   317,   195,   nil,   nil,   nil,   nil,   131,
   125,   nil,   nil,    57,   nil,   274,   nil,   338,   nil,   nil,
   nil,   nil,   nil,   353,   nil,   353,   295,   355,   311,   nil,
   nil,   nil,   nil,   nil,   nil,   501,   nil,   nil,   nil,   350,
   255,   nil,   nil ]

racc_action_default = [
  -135,  -161,   -16,    -5,  -129,  -161,    -6,    -7,  -161,  -161,
    -8,  -161,    -9,   -39,   -10,  -161,   -11,  -161,   -38,   -12,
  -161,  -161,  -161,   -13,    -1,  -161,   -35,  -161,   -14,    -2,
   -15,    -3,  -161,  -128,  -135,  -135,  -133,  -130,  -132,  -134,
   -34,  -161,   -37,  -135,  -135,  -154,  -161,   -27,   -19,  -161,
   -20,   -90,   -21,   -91,   -22,   -58,   -24,   -25,  -161,   -26,
   -28,   -87,  -161,  -161,   -81,   -92,   -83,   -85,   -80,   -58,
  -161,   -98,   -84,   -79,   -59,  -118,   -86,   -82,  -161,  -161,
   -67,  -161,  -119,  -121,   -67,    -4,  -135,   -36,   -67,   -66,
  -161,  -161,  -148,  -161,  -161,  -146,  -161,  -135,   -58,   -52,
   -51,  -161,   -43,   -45,   -42,  -161,  -161,   -18,  -161,  -161,
  -161,  -161,  -161,  -156,   -71,  -161,  -161,  -161,  -161,  -161,
  -159,  -161,   -68,   263,  -161,  -159,  -136,  -161,  -137,  -116,
   -54,  -159,  -161,   -62,   -63,   -65,   -61,   -58,   -64,   -60,
   -59,  -117,   -56,  -161,  -153,  -152,  -149,  -150,  -151,  -147,
  -161,  -131,  -161,   -48,   -47,  -161,   -41,  -161,  -161,   -40,
   -17,   -93,   -23,  -161,   -29,  -161,  -155,  -157,  -161,  -158,
   -89,  -161,  -113,  -112,   -58,  -115,  -161,  -161,  -114,  -106,
  -107,  -161,  -100,  -161,  -104,   -94,  -161,  -160,  -161,  -120,
  -161,  -145,  -143,  -161,  -161,  -140,  -161,  -161,   -67,  -161,
   -57,  -125,  -161,  -127,  -161,   -46,   -44,   -49,   -75,   -77,
   -74,   -78,   -73,   -76,   -50,   -96,   -72,   -88,  -161,  -109,
  -159,  -101,   -99,  -161,  -161,   -32,   -69,   -70,   -33,  -161,
  -161,  -138,  -139,  -161,  -123,  -161,   -31,  -159,   -30,   -55,
  -124,  -126,   -95,  -161,  -111,  -161,  -161,  -158,  -161,  -105,
  -144,  -142,  -141,  -122,   -53,  -161,  -108,  -110,  -103,  -161,
  -161,  -102,   -97 ]

racc_goto_table = [
    24,    85,    59,    60,    37,    76,   180,    76,   135,   120,
    82,   182,    57,   125,    71,    20,    78,   131,   195,   176,
   184,   115,    76,   186,   130,   129,    48,    56,   190,   207,
   214,    89,   226,   168,   197,    59,    60,   101,   106,    76,
   206,    42,   100,   100,    62,    57,   242,   181,   109,   199,
   142,   179,   141,    76,   129,   129,   162,    99,    99,   108,
    56,   220,   114,    29,    83,    34,   219,   127,    90,    76,
    35,    94,   171,   193,   221,   194,    40,   139,   119,   176,
   149,   141,   141,   184,   146,    86,   nil,   138,   nil,   nil,
   134,   152,   151,   nil,   129,   129,   100,    92,    95,    59,
   nil,   164,   136,   nil,   133,    59,   178,   178,   nil,    57,
   nil,    99,   165,   189,   129,    57,   175,   175,   129,   nil,
   135,   213,   213,   245,    56,   252,   249,   237,   nil,   nil,
    56,   173,   173,   172,   172,   257,   239,   129,   246,   nil,
   254,   141,    85,   202,   nil,   141,   212,   212,   176,   128,
   204,   145,   nil,   nil,   100,   nil,   211,   211,    76,   209,
   209,   129,   nil,   nil,   141,   nil,   178,   216,   nil,    99,
   178,   210,   210,   208,   208,   nil,   175,   nil,    76,    85,
   175,    85,   nil,   129,   nil,   nil,   nil,   227,   141,   139,
   nil,   173,   nil,   172,   nil,   173,   235,   172,   nil,   138,
   nil,   nil,   134,   nil,   nil,   nil,   nil,   nil,    76,   nil,
   141,   nil,    85,   178,   136,   nil,   133,   244,   nil,    76,
    76,   nil,   nil,   175,   nil,   nil,   nil,   nil,   250,   251,
   nil,   nil,   nil,   nil,   nil,   178,    85,    85,   173,   nil,
   172,   nil,   nil,   nil,   nil,   175,   nil,   nil,   259,   nil,
   nil,   nil,   nil,   nil,   nil,   260,   nil,   nil,   nil,   nil,
   173,   nil,   172 ]

racc_goto_check = [
     2,     4,    23,    24,    64,    24,    57,    24,    43,    28,
    23,    53,    22,    28,    44,     1,    44,    28,    67,    55,
    55,    46,    24,    29,    39,    49,    17,    21,    29,    38,
    38,    44,    45,    47,    29,    23,    24,    33,    33,    24,
    34,    32,    22,    22,    50,    22,    51,    52,    44,    27,
    26,    56,    48,    24,    49,    49,    20,    21,    21,    17,
    21,    58,    44,     3,    59,    25,    57,    60,    61,    24,
    62,    63,    18,    65,    53,    66,     5,    23,    44,    55,
    68,    48,    48,    55,    69,    25,   nil,    22,   nil,   nil,
    42,    33,    64,   nil,    49,    49,    22,     3,     3,    23,
   nil,    24,    21,   nil,    41,    23,    23,    23,   nil,    22,
   nil,    21,     2,    23,    49,    22,    22,    22,    49,   nil,
    43,    48,    48,    29,    21,    67,    55,    28,   nil,   nil,
    21,    21,    21,    41,    41,    57,    39,    49,    47,   nil,
    29,    48,     4,     2,   nil,    48,    23,    23,    55,     3,
     2,    25,   nil,   nil,    22,   nil,    22,    22,    24,    42,
    42,    49,   nil,   nil,    48,   nil,    23,    44,   nil,    21,
    23,    21,    21,    41,    41,   nil,    22,   nil,    24,     4,
    22,     4,   nil,    49,   nil,   nil,   nil,    44,    48,    23,
   nil,    21,   nil,    41,   nil,    21,     2,    41,   nil,    22,
   nil,   nil,    42,   nil,   nil,   nil,   nil,   nil,    24,   nil,
    48,   nil,     4,    23,    21,   nil,    41,    44,   nil,    24,
    24,   nil,   nil,    22,   nil,   nil,   nil,   nil,    44,    44,
   nil,   nil,   nil,   nil,   nil,    23,     4,     4,    21,   nil,
    41,   nil,   nil,   nil,   nil,    22,   nil,   nil,     2,   nil,
   nil,   nil,   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,
    21,   nil,    41 ]

racc_goto_pointer = [
   nil,    15,     0,    63,   -23,    67,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    13,   -44,   nil,
   -54,    14,    -1,   -11,   -10,    60,   -38,   -93,   -71,   -97,
   nil,   nil,    30,    -6,  -115,   nil,   nil,   nil,  -128,   -64,
   nil,    16,     2,   -80,    -1,  -155,   -42,   -82,   -36,   -63,
    29,  -169,   -71,  -107,   nil,   -98,   -66,  -111,  -116,    43,
   -19,    34,    62,    36,    -4,   -53,   -51,  -108,   -13,    -7 ]

racc_goto_default = [
   nil,   nil,   nil,   104,    31,     3,     6,     7,    10,    12,
    14,    16,    19,    23,    28,    30,     2,   nil,    50,    52,
    54,    68,    72,    73,    22,    27,   nil,   nil,   nil,   nil,
     9,    11,   nil,   nil,   102,   155,   103,   105,   nil,   nil,
   132,    64,    66,    67,   nil,   122,   nil,   nil,    77,    61,
   nil,   nil,   nil,   nil,   183,    70,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :LBRACK => 2,
 :DQTEXT => 3,
 :SQTEXT => 4,
 :RBRACK => 5,
 :LBRACE => 6,
 :RBRACE => 7,
 :SYMBOL => 8,
 :FARROW => 9,
 :COMMA => 10,
 :TRUE => 11,
 :FALSE => 12,
 :EQUALS => 13,
 :LESSEQUAL => 14,
 :NOTEQUAL => 15,
 :DOT => 16,
 :COLON => 17,
 :TYPE => 18,
 :LLCOLLECT => 19,
 :RRCOLLECT => 20,
 :QMARK => 21,
 :LPAREN => 22,
 :RPAREN => 23,
 :ISEQUAL => 24,
 :GREATEREQUAL => 25,
 :GREATERTHAN => 26,
 :LESSTHAN => 27,
 :IF => 28,
 :ELSE => 29,
 :IMPORT => 30,
 :DEFINE => 31,
 :ELSIF => 32,
 :VARIABLE => 33,
 :CLASS => 34,
 :INHERITS => 35,
 :NODE => 36,
 :BOOLEAN => 37,
 :NAME => 38,
 :SEMIC => 39,
 :CASE => 40,
 :DEFAULT => 41,
 :AT => 42,
 :LCOLLECT => 43,
 :RCOLLECT => 44,
 :CLASSNAME => 45,
 :CLASSREF => 46,
 :NOT => 47,
 :OR => 48,
 :AND => 49 }

racc_use_result_var = true

racc_nt_base = 50

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'LBRACK',
'DQTEXT',
'SQTEXT',
'RBRACK',
'LBRACE',
'RBRACE',
'SYMBOL',
'FARROW',
'COMMA',
'TRUE',
'FALSE',
'EQUALS',
'LESSEQUAL',
'NOTEQUAL',
'DOT',
'COLON',
'TYPE',
'LLCOLLECT',
'RRCOLLECT',
'QMARK',
'LPAREN',
'RPAREN',
'ISEQUAL',
'GREATEREQUAL',
'GREATERTHAN',
'LESSTHAN',
'IF',
'ELSE',
'IMPORT',
'DEFINE',
'ELSIF',
'VARIABLE',
'CLASS',
'INHERITS',
'NODE',
'BOOLEAN',
'NAME',
'SEMIC',
'CASE',
'DEFAULT',
'AT',
'LCOLLECT',
'RCOLLECT',
'CLASSNAME',
'CLASSREF',
'NOT',
'OR',
'AND',
'$start',
'program',
'statements',
'nil',
'statement',
'resource',
'virtualresource',
'collection',
'assignment',
'casestatement',
'ifstatement',
'import',
'fstatement',
'definition',
'hostclass',
'nodedef',
'resourceoverride',
'funcvalues',
'namestrings',
'resourcerefs',
'namestring',
'name',
'variable',
'quotedtext',
'resourceref',
'fqname',
'resourceinstances',
'endsemi',
'params',
'endcomma',
'at',
'collectname',
'collectrhand',
'collstatements',
'collstatement',
'colljoin',
'collexpr',
'colllval',
'simplervalue',
'resourceinst',
'resourcename',
'type',
'selector',
'array',
'rvalue',
'param',
'rvalues',
'comma',
'boolean',
'funcrvalue',
'iftest',
'else',
'caseopts',
'caseopt',
'casevalues',
'selectlhand',
'svalues',
'selectval',
'sintvalues',
'qtexts',
'argumentlist',
'classparent',
'hostnames',
'nodeparent',
'hostname',
'nothing',
'arguments',
'argument',
'nameordefault',
'fqnameordefault']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'grammar.ra', 33
  def _reduce_1( val, _values, result )
    if val[0]
        # Make sure we always return an array.
        if val[0].is_a?(AST::ASTArray)
            if val[0].children.empty?
                result = nil
            else
                result = val[0]
            end
        else
            result = aryfy(val[0])
        end
    else
        result = nil
    end
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'grammar.ra', 49
  def _reduce_4( val, _values, result )
    if val[0] and val[1]
        if val[0].instance_of?(AST::ASTArray)
            val[0].push(val[1])
            result = val[0]
        else
            result = ast AST::ASTArray, :children => [val[0],val[1]]
        end
    elsif obj = (val[0] || val[1])
        result = obj
    else result = nil
    end
   result
  end
.,.,

 # reduce 5 omitted

 # reduce 6 omitted

 # reduce 7 omitted

 # reduce 8 omitted

 # reduce 9 omitted

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 # reduce 15 omitted

 # reduce 16 omitted

module_eval <<'.,.,', 'grammar.ra', 71
  def _reduce_17( val, _values, result )
    args = aryfy(val[2])
    result = ast AST::Function,
        :name => val[0],
        :arguments => args,
        :ftype => :statement
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 77
  def _reduce_18( val, _values, result )
    result = ast AST::Function,
        :name => val[0],
        :arguments => AST::ASTArray.new({}),
        :ftype => :statement
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 84
  def _reduce_19( val, _values, result )
    args = aryfy(val[1])
    result = ast AST::Function,
        :name => val[0],
        :arguments => args,
        :ftype => :statement
   result
  end
.,.,

 # reduce 20 omitted

 # reduce 21 omitted

 # reduce 22 omitted

module_eval <<'.,.,', 'grammar.ra', 94
  def _reduce_23( val, _values, result )
    result = aryfy(val[0], val[2])
    result.line = @lexer.line
    result.file = @lexer.file
   result
  end
.,.,

 # reduce 24 omitted

 # reduce 25 omitted

 # reduce 26 omitted

module_eval <<'.,.,', 'grammar.ra', 101
  def _reduce_27( val, _values, result )
                    result = ast AST::Name, :value => val[0]
   result
  end
.,.,

 # reduce 28 omitted

module_eval <<'.,.,', 'grammar.ra', 112
  def _reduce_29( val, _values, result )
    unless val[0].is_a?(AST::ASTArray)
        val[0] = aryfy(val[0])
    end

    val[0].push(val[2])

    result = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 133
  def _reduce_30( val, _values, result )
    array = val[2]
    if array.instance_of?(AST::ResourceInst)
        array = [array]
    end
    result = ast AST::ASTArray

    # this iterates across each specified resourceinstance
    array.each { |instance|
        unless instance.instance_of?(AST::ResourceInst)
            raise Puppet::Dev, "Got something that isn't an instance"
        end
        # now, i need to somehow differentiate between those things with
        # arrays in their names, and normal things
        result.push ast(AST::ResourceDef,
            :type => val[0],
            :title => instance[0],
            :params => instance[1])
    }
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 136
  def _reduce_31( val, _values, result )
    # This is a deprecated syntax.
    error "All resource specifications require names"
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 139
  def _reduce_32( val, _values, result )
    # a defaults setting for a type
    result = ast(AST::ResourceDefaults, :type => val[0], :params => val[2])
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 144
  def _reduce_33( val, _values, result )
    result = ast AST::ResourceOverride, :object => val[0], :params => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 171
  def _reduce_34( val, _values, result )
    type = val[0]

    if type == :exported and ! Puppet[:storeconfigs]
        error "You cannot collect without storeconfigs being set"
    end

    if val[1].is_a? AST::ResourceDefaults
        error "Defaults are not virtualizable"
    end

    method = type.to_s + "="

    # Just mark our resources as exported and pass them through.
    if val[1].instance_of?(AST::ASTArray)
        val[1].each do |obj|
            obj.send(method, true)
        end
    else
        val[1].send(method, true)
    end

    result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 172
  def _reduce_35( val, _values, result )
 result = :virtual
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 173
  def _reduce_36( val, _values, result )
 result = :exported
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 196
  def _reduce_37( val, _values, result )
    if val[0] =~ /^[a-z]/
        Puppet.warning addcontext("Collection names must now be capitalized")
    end
    type = val[0].downcase
    args = {:type => type}

    if val[1].is_a?(AST::CollExpr)
        args[:query] = val[1]
        args[:query].type = type
        args[:form] = args[:query].form
    else
        args[:form] = val[1]
    end
    if args[:form] == :exported and ! Puppet[:storeconfigs]
        error "You cannot collect exported resources without storeconfigs being set"
    end
    result = ast AST::Collection, args
   result
  end
.,.,

 # reduce 38 omitted

 # reduce 39 omitted

module_eval <<'.,.,', 'grammar.ra', 207
  def _reduce_40( val, _values, result )
    if val[1]
        result = val[1]
        result.form = :virtual
    else
        result = :virtual
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 215
  def _reduce_41( val, _values, result )
    if val[1]
        result = val[1]
        result.form = :exported
    else
        result = :exported
    end
   result
  end
.,.,

 # reduce 42 omitted

 # reduce 43 omitted

module_eval <<'.,.,', 'grammar.ra', 223
  def _reduce_44( val, _values, result )
    result = ast AST::CollExpr, :test1 => val[0], :oper => val[1], :test2 => val[2]
   result
  end
.,.,

 # reduce 45 omitted

module_eval <<'.,.,', 'grammar.ra', 229
  def _reduce_46( val, _values, result )
    result = val[1]
    result.parens = true
   result
  end
.,.,

 # reduce 47 omitted

 # reduce 48 omitted

module_eval <<'.,.,', 'grammar.ra', 237
  def _reduce_49( val, _values, result )
    result = ast AST::CollExpr, :test1 => val[0], :oper => val[1], :test2 => val[2]
    #result = ast AST::CollExpr
    #result.push *val
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 242
  def _reduce_50( val, _values, result )
    result = ast AST::CollExpr, :test1 => val[0], :oper => val[1], :test2 => val[2]
    #result = ast AST::CollExpr
    #result.push *val
   result
  end
.,.,

 # reduce 51 omitted

 # reduce 52 omitted

module_eval <<'.,.,', 'grammar.ra', 249
  def _reduce_53( val, _values, result )
    result = ast AST::ResourceInst, :children => [val[0],val[2]]
   result
  end
.,.,

 # reduce 54 omitted

module_eval <<'.,.,', 'grammar.ra', 259
  def _reduce_55( val, _values, result )
    if val[0].instance_of?(AST::ResourceInst)
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    else
        val[0].push val[2]
        result = val[0]
    end
   result
  end
.,.,

 # reduce 56 omitted

 # reduce 57 omitted

module_eval <<'.,.,', 'grammar.ra', 266
  def _reduce_58( val, _values, result )
    result = ast AST::Name, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 270
  def _reduce_59( val, _values, result )
    result = ast AST::Type, :value => val[0]
   result
  end
.,.,

 # reduce 60 omitted

 # reduce 61 omitted

 # reduce 62 omitted

 # reduce 63 omitted

 # reduce 64 omitted

 # reduce 65 omitted

module_eval <<'.,.,', 'grammar.ra', 286
  def _reduce_66( val, _values, result )
    if val[0] =~ /::/
        raise Puppet::ParseError, "Cannot assign to variables in other namespaces"
    end
    # this is distinct from referencing a variable
    variable = ast AST::Name, :value => val[0]
    result = ast AST::VarDef, :name => variable, :value => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 291
  def _reduce_67( val, _values, result )
    result = ast AST::ASTArray
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 291
  def _reduce_68( val, _values, result )
 result = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 300
  def _reduce_69( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 304
  def _reduce_70( val, _values, result )
    result = ast AST::ResourceParam, :param => val[0], :value => val[2]
   result
  end
.,.,

 # reduce 71 omitted

module_eval <<'.,.,', 'grammar.ra', 313
  def _reduce_72( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        result = val[0].push(val[2])
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

 # reduce 73 omitted

 # reduce 74 omitted

 # reduce 75 omitted

 # reduce 76 omitted

 # reduce 77 omitted

 # reduce 78 omitted

 # reduce 79 omitted

 # reduce 80 omitted

 # reduce 81 omitted

 # reduce 82 omitted

 # reduce 83 omitted

 # reduce 84 omitted

 # reduce 85 omitted

 # reduce 86 omitted

 # reduce 87 omitted

module_eval <<'.,.,', 'grammar.ra', 339
  def _reduce_88( val, _values, result )
    args = aryfy(val[2])
    result = ast AST::Function,
        :name => val[0],
        :arguments => args,
        :ftype => :rvalue
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 344
  def _reduce_89( val, _values, result )
    result = ast AST::Function,
        :name => val[0],
        :arguments => AST::ASTArray.new({}),
        :ftype => :rvalue
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 348
  def _reduce_90( val, _values, result )
    result = ast AST::String, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 350
  def _reduce_91( val, _values, result )
    result = ast AST::FlatString, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 354
  def _reduce_92( val, _values, result )
    result = ast AST::Boolean, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 359
  def _reduce_93( val, _values, result )
    Puppet.warning addcontext("Deprecation notice:  Resource references should now be capitalized")
    result = ast AST::ResourceRef, :type => val[0], :title => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 361
  def _reduce_94( val, _values, result )
    result = ast AST::ResourceRef, :type => val[0], :title => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 374
  def _reduce_95( val, _values, result )
    args = {
        :test => val[1],
        :statements => val[3]
    }

    if val[5]
        args[:else] = val[5]
    end

    result = ast AST::IfStatement, args
   result
  end
.,.,

 # reduce 96 omitted

module_eval <<'.,.,', 'grammar.ra', 379
  def _reduce_97( val, _values, result )
    result = ast AST::Else, :statements => val[2]
   result
  end
.,.,

 # reduce 98 omitted

module_eval <<'.,.,', 'grammar.ra', 391
  def _reduce_99( val, _values, result )
    options = val[3]
    unless options.instance_of?(AST::ASTArray)
        options = ast AST::ASTArray, :children => [val[3]]
    end
    result = ast AST::CaseStatement, :test => val[1], :options => options
   result
  end
.,.,

 # reduce 100 omitted

module_eval <<'.,.,', 'grammar.ra', 401
  def _reduce_101( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push val[1]
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0], val[1]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 405
  def _reduce_102( val, _values, result )
    result = ast AST::CaseOpt, :value => val[0], :statements => val[3]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 410
  def _reduce_103( val, _values, result )
    result = ast(AST::CaseOpt,
        :value => val[0],
        :statements => ast(AST::ASTArray)
    )
   result
  end
.,.,

 # reduce 104 omitted

module_eval <<'.,.,', 'grammar.ra', 420
  def _reduce_105( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 424
  def _reduce_106( val, _values, result )
    result = ast AST::Selector, :param => val[0], :values => val[2]
   result
  end
.,.,

 # reduce 107 omitted

module_eval <<'.,.,', 'grammar.ra', 426
  def _reduce_108( val, _values, result )
 result = val[1]
   result
  end
.,.,

 # reduce 109 omitted

module_eval <<'.,.,', 'grammar.ra', 437
  def _reduce_110( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 441
  def _reduce_111( val, _values, result )
    result = ast AST::ResourceParam, :param => val[0], :value => val[2]
   result
  end
.,.,

 # reduce 112 omitted

 # reduce 113 omitted

 # reduce 114 omitted

 # reduce 115 omitted

 # reduce 116 omitted

 # reduce 117 omitted

module_eval <<'.,.,', 'grammar.ra', 451
  def _reduce_118( val, _values, result )
    result = ast AST::Default, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 453
  def _reduce_119( val, _values, result )
 result = [val[0].value]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 457
  def _reduce_120( val, _values, result )
    results = val[0] << val[2].value
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 465
  def _reduce_121( val, _values, result )
    val[1].each do |file|
        import(file)
    end

    result = AST::ASTArray.new(:children => [])
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 475
  def _reduce_122( val, _values, result )
    interp.newdefine fqname(val[1]), :arguments => val[2], :code => val[4]
    @lexer.indefine = false
    result = nil

#}           | DEFINE NAME argumentlist parent LBRACE RBRACE {
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 479
  def _reduce_123( val, _values, result )
    interp.newdefine fqname(val[1]), :arguments => val[2]
    @lexer.indefine = false
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 487
  def _reduce_124( val, _values, result )
    # Our class gets defined in the parent namespace, not our own.
    @lexer.namepop
    interp.newclass fqname(val[1]), :code => val[4], :parent => val[2]
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 492
  def _reduce_125( val, _values, result )
    # Our class gets defined in the parent namespace, not our own.
    @lexer.namepop
    interp.newclass fqname(val[1]), :parent => val[2]
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 497
  def _reduce_126( val, _values, result )
    interp.newnode val[1], :parent => val[2], :code => val[4]
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 500
  def _reduce_127( val, _values, result )
    interp.newnode val[1], :parent => val[2]
    result = nil
   result
  end
.,.,

 # reduce 128 omitted

 # reduce 129 omitted

 # reduce 130 omitted

module_eval <<'.,.,', 'grammar.ra', 512
  def _reduce_131( val, _values, result )
    result = val[0]
    result = [result] unless result.is_a?(Array)
    result << val[2]
   result
  end
.,.,

 # reduce 132 omitted

 # reduce 133 omitted

 # reduce 134 omitted

module_eval <<'.,.,', 'grammar.ra', 520
  def _reduce_135( val, _values, result )
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 524
  def _reduce_136( val, _values, result )
    result = ast AST::ASTArray, :children => []
   result
  end
.,.,

 # reduce 137 omitted

module_eval <<'.,.,', 'grammar.ra', 529
  def _reduce_138( val, _values, result )
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 533
  def _reduce_139( val, _values, result )
    result = val[1]
    result = [result] unless result[0].is_a?(Array)
   result
  end
.,.,

 # reduce 140 omitted

module_eval <<'.,.,', 'grammar.ra', 540
  def _reduce_141( val, _values, result )
    result = val[0]
    result = [result] unless result[0].is_a?(Array)
    result << val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 545
  def _reduce_142( val, _values, result )
    Puppet.warning addcontext("Deprecation notice: must now include '$' in prototype")
    result = [val[0], val[2]]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 549
  def _reduce_143( val, _values, result )
    Puppet.warning addcontext("Deprecation notice: must now include '$' in prototype")
    result = [val[0]]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 551
  def _reduce_144( val, _values, result )
    result = [val[0], val[2]]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 553
  def _reduce_145( val, _values, result )
    result = [val[0]]
   result
  end
.,.,

 # reduce 146 omitted

module_eval <<'.,.,', 'grammar.ra', 558
  def _reduce_147( val, _values, result )
    result = val[1]
   result
  end
.,.,

 # reduce 148 omitted

module_eval <<'.,.,', 'grammar.ra', 563
  def _reduce_149( val, _values, result )
    result = val[1]
   result
  end
.,.,

 # reduce 150 omitted

 # reduce 151 omitted

 # reduce 152 omitted

 # reduce 153 omitted

module_eval <<'.,.,', 'grammar.ra', 570
  def _reduce_154( val, _values, result )
    result = ast AST::Variable, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 578
  def _reduce_155( val, _values, result )
    if val[1].instance_of?(AST::ASTArray)
        result = val[1]
    else
        result = ast AST::ASTArray, :children => [val[1]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 580
  def _reduce_156( val, _values, result )
    result = ast AST::ASTArray
   result
  end
.,.,

 # reduce 157 omitted

 # reduce 158 omitted

 # reduce 159 omitted

module_eval <<'.,.,', 'grammar.ra', 585
  def _reduce_160( val, _values, result )
 result = nil
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

    end   # class Parser

  end   # module Parser

end   # module Puppet
