// I18N constants

// Translation Note
// 1. translate the left  side of fontname, font size and formatblock
// 2. translate the right side of tooltips

HTMLArea.I18N = {
	fontname: {
		"Arial":           'arial,helvetica,sans-serif',
		"Courier New":     'courier new,courier,monospace',
		"Georgia":         'georgia,times new roman,times,serif',
		"Tahoma":          'tahoma,arial,helvetica,sans-serif',
		"Times New Roman": 'times new roman,times,serif',
		"Verdana":         'verdana,arial,helvetica,sans-serif',
		"impact":          'impact',
		"WingDings":       'wingdings'
	},

	fontsize: {
		"1 (8 pt)":  "1",
		"2 (10 pt)": "2",
		"3 (12 pt)": "3",
		"4 (14 pt)": "4",
		"5 (18 pt)": "5",
		"6 (24 pt)": "6",
		"7 (36 pt)": "7"
	},

	formatblock: {
		"ͧ 1": "h1",
		"ͧ 2": "h2",
		"ͧ 3": "h3",
		"ͧ 4": "h4",
		"ͧ 5": "h5",
		"ͧ 6": "h6",
		"": "p",
		"": "address",
		"ҧ": "pre"
	},

	tooltips: {
		bold:           "˹",
		italic:         "§",
		underline:      "մ",
		strikethrough:  "մҧ",
		subscript:      "",
		superscript:    "¡",
		justifyleft:    "ѴԴ",
		justifycenter:  "Ѵ觡ҧ",
		justifyright:   "ѴԴ",
		justifyfull:    "Ѵ",
		insertorderedlist:    "¡ẺŢ",
		insertunorderedlist:  "¡ẺյŢ",
		outdent:        "˹͡",
		indent:         "˹",
		forecolor:      "յѡ",
		hilitecolor:    "վѧ",
		inserthorizontalrule: "鹢ҧǹ͹",
		createlink:     "á",
		insertimage:    "áٻ",
		insertsound:    "á§",
		inserttable:    "áҧ",
		htmlmode:       "ʴ HTML",
		popupeditor:    "¾鹷",
		about:          "ǡѺ䢹",
		showhelp:       "Ը",
		textindicator:  "ٻẺѨغѹ",
		undo:           "¡ԡش",
		redo:           "ǹش",
		cut:            "Ѵǹ͡",
		copy:           "ǹ͡",
		paste:          "ҧͤ"
	},

	buttons: {
		"ok":           "ŧ",
		"cancel":       "¡ԡ"
	},

	msg: {
		"Path":         "鹷ҧ",
		"TEXT_MODE":    "ѧẺ TEXT MODE.  [<>] ͡ѺẺ WYSIWIG"
	}
};
