/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Popup {
    public void show() {
    }

    public void hide() {
    }

    protected Popup(Component component, Component component2, int n, int n2) {
        if (component2 == null) {
            throw new IllegalArgumentException();
        }
    }

    protected Popup() {
    }

    static class LightweightPopup
    extends Popup {
        Component owner;
        Component contents;
        int x;
        int y;
        private JPanel panel;
        private JLayeredPane layeredPane;

        public void show() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new FlowLayout(0, 0, 0));
            }
            this.panel.add(this.contents);
            this.panel.setSize(this.contents.getSize());
            Point point = this.layeredPane.getLocationOnScreen();
            this.panel.setLocation(this.x - point.x, this.y - point.y);
            this.layeredPane.add((Component)this.panel, JLayeredPane.POPUP_LAYER);
            this.panel.repaint();
        }

        public void hide() {
            Rectangle rectangle = this.panel.getBounds();
            this.layeredPane.remove(this.panel);
            this.layeredPane.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public LightweightPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
            JLayeredPane jLayeredPane;
            this.owner = component;
            this.contents = component2;
            this.x = n;
            this.y = n2;
            JRootPane jRootPane = SwingUtilities.getRootPane(component);
            this.layeredPane = jLayeredPane = jRootPane.getLayeredPane();
        }
    }

    static class JWindowPopup
    extends Popup {
        JWindow window;
        private Component contents;

        public void show() {
            this.window.setSize(this.contents.getSize());
            this.window.show();
        }

        public void hide() {
            this.window.dispose();
        }

        public JWindowPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
            this.contents = component2;
            this.window = new JWindow(SwingUtilities.getWindowAncestor(component));
            this.window.getContentPane().add(component2);
            this.window.setLocation(n, n2);
            this.window.setFocusableWindowState(false);
        }
    }
}

