/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    private static final long serialVersionUID = 4657624909838017887L;
    static final String WAS_ICON_ONCE_PROPERTY = "wasIconOnce";
    private int currentDragMode;
    private transient Rectangle dragCache;
    private transient Container pane;
    private transient Rectangle[] iconRects;

    public void openFrame(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getParent();
        if (container == null) {
            container = jInternalFrame.getDesktopIcon().getParent();
        }
        if (container == null) {
            return;
        }
        container.remove(jInternalFrame.getDesktopIcon());
        container.add(jInternalFrame);
        jInternalFrame.setVisible(true);
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getParent();
        jInternalFrame.doDefaultCloseAction();
        if (container != null) {
            if (jInternalFrame.isIcon()) {
                container.remove(jInternalFrame.getDesktopIcon());
            } else {
                container.remove(jInternalFrame);
            }
            container.repaint();
        }
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isIcon()) {
            return;
        }
        jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
        Container container = jInternalFrame.getParent();
        if (container != null) {
            Rectangle rectangle = container.getBounds();
            Insets insets = container.getInsets();
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        }
        if (container instanceof JDesktopPane) {
            ((JDesktopPane)container).setSelectedFrame(jInternalFrame);
        } else {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle = jInternalFrame.getNormalBounds();
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane != null) {
            jDesktopPane.setSelectedFrame(jInternalFrame);
        } else {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (jDesktopPane != null && jDesktopPane.getSelectedFrame() == jInternalFrame) {
            jDesktopPane.setSelectedFrame(null);
        } else {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        Container container = jInternalFrame.getParent();
        if (!this.wasIcon(jInternalFrame)) {
            rectangle = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(rectangle);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        if (container != null) {
            if (jDesktopIcon != null) {
                container.add(jDesktopIcon);
                jDesktopIcon.setVisible(true);
            }
            rectangle = jInternalFrame.getBounds();
            container.remove(jInternalFrame);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        this.removeIconFor(jInternalFrame);
        container.add(jInternalFrame);
        jInternalFrame.setVisible(true);
        if (!jInternalFrame.isSelected()) {
            JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(jInternalFrame);
            } else {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
        container.invalidate();
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane != null) {
            jDesktopPane.setSelectedFrame(jInternalFrame);
        } else {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        jInternalFrame.toFront();
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane != null) {
            if (jDesktopPane.getSelectedFrame() == jInternalFrame) {
                jDesktopPane.setSelectedFrame(null);
            }
        } else {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void beginDraggingFrame(JComponent jComponent) {
        this.pane = jComponent instanceof JInternalFrame.JDesktopIcon ? ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().getDesktopPane() : ((JInternalFrame)jComponent).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = jComponent.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? 0 : ((JDesktopPane)this.pane).getDragMode();
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        if (this.currentDragMode != 1) {
            Rectangle rectangle = jComponent.getBounds();
            if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                jComponent.setBounds(n, n2, rectangle.width, rectangle.height);
            } else {
                this.setBoundsForFrame((JInternalFrame)jComponent, n, n2, rectangle.width, rectangle.height);
            }
        }
    }

    public void endDraggingFrame(JComponent jComponent) {
        if (this.currentDragMode == 1) {
            this.setBoundsForFrame((JInternalFrame)jComponent, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
        }
        jComponent.repaint();
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
        this.pane = ((JInternalFrame)jComponent).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = jComponent.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? 0 : ((JDesktopPane)this.pane).getDragMode();
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.dragCache.setBounds(n, n2, n3, n4);
        if (this.currentDragMode != 1) {
            this.setBoundsForFrame(jComponent, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
        }
    }

    public void endResizingFrame(JComponent jComponent) {
        if (this.currentDragMode == 1) {
            this.setBoundsForFrame((JInternalFrame)jComponent, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
        }
        jComponent.repaint();
    }

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        jComponent.setBounds(n, n2, n3, n4);
        jComponent.revalidate();
        if (jComponent.getParent() != null) {
            jComponent.getParent().repaint();
        } else {
            jComponent.repaint();
        }
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        if (container != null && jDesktopIcon != null) {
            Rectangle rectangle = jDesktopIcon.getBounds();
            container.remove(jDesktopIcon);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane == null) {
            return jInternalFrame.getDesktopIcon().getBounds();
        }
        Rectangle rectangle = jDesktopPane.getBounds();
        Insets insets = jDesktopPane.getInsets();
        Dimension dimension = jInternalFrame.getDesktopIcon().getPreferredSize();
        Component[] componentArray = jDesktopPane.getComponents();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof JInternalFrame.JDesktopIcon || componentArray[n2] instanceof JInternalFrame && ((JInternalFrame)componentArray[n2]).getWasIcon() && componentArray[n2] != jInternalFrame) {
                ++n;
            }
            ++n2;
        }
        this.iconRects = new Rectangle[n];
        n2 = 0;
        n3 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof JInternalFrame.JDesktopIcon) {
                this.iconRects[--n] = componentArray[n2].getBounds();
            } else if (componentArray[n2] instanceof JInternalFrame && ((JInternalFrame)componentArray[n2]).getWasIcon() && componentArray[n2] != jInternalFrame) {
                this.iconRects[--n] = ((JInternalFrame)componentArray[n2]).getDesktopIcon().getBounds();
            }
            ++n2;
        }
        n2 = insets.left;
        n3 = rectangle.height - insets.bottom - dimension.height;
        Rectangle rectangle2 = new Rectangle(n2, n3, dimension.width, dimension.height);
        boolean bl = true;
        while (this.iconRects.length > 0) {
            bl = true;
            int n4 = 0;
            while (n4 < this.iconRects.length) {
                if (this.iconRects[n4] != null && this.iconRects[n4].intersects(rectangle2)) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                return rectangle2;
            }
            if ((n2 += dimension.width) + dimension.width > rectangle.width - insets.right) {
                n2 = insets.left;
                n3 -= dimension.height;
            }
            rectangle2.setBounds(n2, n3, dimension.width, dimension.height);
        }
        return rectangle2;
    }

    protected void setPreviousBounds(JInternalFrame jInternalFrame, Rectangle rectangle) {
        jInternalFrame.setNormalBounds(rectangle);
    }

    protected Rectangle getPreviousBounds(JInternalFrame jInternalFrame) {
        return jInternalFrame.getNormalBounds();
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl) {
        jInternalFrame.setWasIcon(bl, WAS_ICON_ONCE_PROPERTY);
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getWasIcon();
    }

    private final /* synthetic */ void this() {
        this.currentDragMode = 0;
        this.dragCache = new Rectangle();
    }

    public DefaultDesktopManager() {
        this.this();
    }
}

