/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DataFormatException;
import java.util.zip.InflaterHuffmanTree;
import java.util.zip.StreamManipulator;

class InflaterDynHeader {
    private static final int LNUM = 0;
    private static final int DNUM = 1;
    private static final int BLNUM = 2;
    private static final int BLLENS = 3;
    private static final int LENS = 4;
    private static final int REPS = 5;
    private static final int[] repMin = new int[]{3, 3, 11};
    private static final int[] repBits = new int[]{2, 3, 7};
    private static final int[] BL_ORDER;
    private byte[] blLens;
    private byte[] litdistLens;
    private InflaterHuffmanTree blTree;
    private int mode;
    private int lnum;
    private int dnum;
    private int blnum;
    private int num;
    private int repSymbol;
    private byte lastLen;
    private int ptr;

    /*
     * Unable to fully structure code
     */
    public boolean decode(StreamManipulator var1_1) throws DataFormatException {
        while (true) {
            switch (this.mode) {
                case 0: {
                    this.lnum = var1_1.peekBits(5);
                    if (this.lnum < 0) {
                        return false;
                    }
                    this.lnum += 257;
                    var1_1.dropBits(5);
                    this.mode = 1;
                }
                case 1: {
                    this.dnum = var1_1.peekBits(5);
                    if (this.dnum < 0) {
                        return false;
                    }
                    ++this.dnum;
                    var1_1.dropBits(5);
                    this.num = this.lnum + this.dnum;
                    this.litdistLens = new byte[this.num];
                    this.mode = 2;
                }
                case 2: {
                    this.blnum = var1_1.peekBits(4);
                    if (this.blnum < 0) {
                        return false;
                    }
                    this.blnum += 4;
                    var1_1.dropBits(4);
                    this.blLens = new byte[19];
                    this.ptr = 0;
                    this.mode = 3;
                }
                case 3: {
                    while (this.ptr < this.blnum) {
                        var2_2 = var1_1.peekBits(3);
                        if (var2_2 < 0) {
                            return false;
                        }
                        var1_1.dropBits(3);
                        this.blLens[InflaterDynHeader.BL_ORDER[this.ptr]] = (byte)var2_2;
                        ++this.ptr;
                    }
                    this.blTree = new InflaterHuffmanTree(this.blLens);
                    this.blLens = null;
                    this.ptr = 0;
                    this.mode = 4;
                }
                case 4: {
                    while (((var2_2 = this.blTree.getSymbol(var1_1)) & -16) == 0) {
                        this.litdistLens[this.ptr++] = this.lastLen = (byte)var2_2;
                        if (this.ptr != this.num) continue;
                        return true;
                    }
                    if (var2_2 < 0) {
                        return false;
                    }
                    if (var2_2 >= 17) {
                        this.lastLen = 0;
                    } else if (this.ptr == 0) {
                        throw new DataFormatException();
                    }
                    this.repSymbol = var2_2 - 16;
                    this.mode = 5;
                }
                case 5: {
                    var2_2 = InflaterDynHeader.repBits[this.repSymbol];
                    var3_3 = var1_1.peekBits(var2_2);
                    if (var3_3 < 0) {
                        return false;
                    }
                    var1_1.dropBits(var2_2);
                    if (this.ptr + (var3_3 += InflaterDynHeader.repMin[this.repSymbol]) <= this.num) ** GOTO lbl64
                    throw new DataFormatException();
lbl-1000:
                    // 1 sources

                    {
                        this.litdistLens[this.ptr++] = this.lastLen;
lbl64:
                        // 2 sources

                        ** while (var3_3-- > 0)
                    }
lbl65:
                    // 1 sources

                    if (this.ptr == this.num) {
                        return true;
                    }
                    this.mode = 4;
                    break;
                }
            }
        }
    }

    public InflaterHuffmanTree buildLitLenTree() throws DataFormatException {
        byte[] byArray = new byte[this.lnum];
        System.arraycopy(this.litdistLens, 0, byArray, 0, this.lnum);
        return new InflaterHuffmanTree(byArray);
    }

    public InflaterHuffmanTree buildDistTree() throws DataFormatException {
        byte[] byArray = new byte[this.dnum];
        System.arraycopy(this.litdistLens, this.lnum, byArray, 0, this.dnum);
        return new InflaterHuffmanTree(byArray);
    }

    static {
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        BL_ORDER = nArray;
    }
}

