/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X509CRLSelector
implements CRLSelector,
Cloneable {
    private static final String CRL_NUMBER_ID = "2.5.29.20";
    private List issuerNames;
    private BigInteger maxCrlNumber;
    private BigInteger minCrlNumber;
    private Date date;
    private X509Certificate cert;
    static /* synthetic */ Class class$java$security$cert$X509CRLSelector;

    public void addIssuerName(byte[] byArray) throws IOException {
        X500Principal x500Principal = null;
        try {
            x500Principal = new X500Principal(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("malformed name");
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        if (this.issuerNames == null) {
            this.issuerNames = new LinkedList();
        }
        this.issuerNames.add(x500Principal);
    }

    public void addIssuerName(String string) throws IOException {
        X500Principal x500Principal = null;
        try {
            x500Principal = new X500Principal(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("malformed name: " + string);
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        if (this.issuerNames == null) {
            this.issuerNames = new LinkedList();
        }
        this.issuerNames.add(x500Principal);
    }

    public void setIssuerNames(Collection collection) throws IOException {
        if (collection == null) {
            this.issuerNames = null;
            return;
        }
        ArrayList arrayList = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof X500Principal) {
                arrayList.add(object);
                continue;
            }
            if (object instanceof String) {
                try {
                    arrayList.add(new X500Principal((String)object));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IOException iOException = new IOException("malformed name: " + object);
                    iOException.initCause(illegalArgumentException);
                    throw iOException;
                }
            }
            if (object instanceof byte[]) {
                try {
                    arrayList.add(new X500Principal((byte[])object));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IOException iOException = new IOException("malformed name");
                    iOException.initCause(illegalArgumentException);
                    throw iOException;
                }
            }
            if (object instanceof InputStream) {
                try {
                    arrayList.add(new X500Principal((InputStream)object));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IOException iOException = new IOException("malformed name");
                    iOException.initCause(illegalArgumentException);
                    throw iOException;
                }
            }
            throw new IOException("not a valid name: " + (object != null ? object.getClass().getName() : "null"));
        }
        this.issuerNames = arrayList;
    }

    public Collection getIssuerNames() {
        if (this.issuerNames != null) {
            return Collections.unmodifiableList(this.issuerNames);
        }
        return null;
    }

    public BigInteger getMaxCRL() {
        return this.maxCrlNumber;
    }

    public BigInteger getMinCRL() {
        return this.minCrlNumber;
    }

    public void setMaxCRLNumber(BigInteger bigInteger) {
        this.maxCrlNumber = bigInteger;
    }

    public void setMinCRLNumber(BigInteger bigInteger) {
        this.minCrlNumber = bigInteger;
    }

    public Date getDateAndTime() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDateAndTime(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public X509Certificate getCertificateChecking() {
        return this.cert;
    }

    public void setCertificateChecking(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public String toString() {
        Class clazz = class$java$security$cert$X509CRLSelector;
        if (clazz == null) {
            clazz = class$java$security$cert$X509CRLSelector = X509CRLSelector.class("[Ljava.security.cert.X509CRLSelector;", false);
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        String string = SystemProperties.getProperty("line.separator");
        String string2 = ";" + string;
        stringBuffer.append(" {").append(string);
        if (this.issuerNames != null) {
            stringBuffer.append("  issuer names = ").append(this.issuerNames).append(string2);
        }
        if (this.maxCrlNumber != null) {
            stringBuffer.append("  max CRL = ").append(this.maxCrlNumber).append(string2);
        }
        if (this.minCrlNumber != null) {
            stringBuffer.append("  min CRL = ").append(this.minCrlNumber).append(string2);
        }
        if (this.date != null) {
            stringBuffer.append("  date = ").append(this.date).append(string2);
        }
        if (this.cert != null) {
            stringBuffer.append("  certificate = ").append(this.cert).append(string2);
        }
        stringBuffer.append("}").append(string);
        return stringBuffer.toString();
    }

    public boolean match(CRL cRL) {
        DERValue dERValue;
        byte[] byArray;
        if (!(cRL instanceof X509CRL)) {
            return false;
        }
        X509CRL x509CRL = (X509CRL)cRL;
        if (this.issuerNames != null && !this.issuerNames.contains(x509CRL.getIssuerX500Principal())) {
            return false;
        }
        BigInteger bigInteger = null;
        if (this.maxCrlNumber != null) {
            byArray = x509CRL.getExtensionValue(CRL_NUMBER_ID);
            if (byArray == null) {
                return false;
            }
            try {
                dERValue = DERReader.read(byArray);
                if (!(dERValue.getValue() instanceof BigInteger)) {
                    return false;
                }
                bigInteger = (BigInteger)dERValue.getValue();
            }
            catch (IOException iOException) {
                return false;
            }
            if (this.maxCrlNumber.compareTo(bigInteger) < 0) {
                return false;
            }
        }
        if (this.minCrlNumber != null) {
            if (bigInteger == null) {
                byArray = x509CRL.getExtensionValue(CRL_NUMBER_ID);
                if (byArray == null) {
                    return false;
                }
                try {
                    dERValue = DERReader.read(byArray);
                    if (!(dERValue.getValue() instanceof BigInteger)) {
                        return false;
                    }
                    bigInteger = (BigInteger)dERValue.getValue();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            if (this.minCrlNumber.compareTo(bigInteger) > 0) {
                return false;
            }
        }
        return this.date == null || this.date.compareTo(x509CRL.getThisUpdate()) >= 0 && this.date.compareTo(x509CRL.getNextUpdate()) <= 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

