/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.IntBufferImpl;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    int[] backing_buffer;

    public static IntBuffer allocate(int n) {
        return new IntBufferImpl(n);
    }

    public static final IntBuffer wrap(int[] nArray, int n, int n2) {
        return new IntBufferImpl(nArray, 0, nArray.length, n + n2, n, -1, false);
    }

    public static final IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public IntBuffer get(int[] nArray, int n, int n2) {
        IntBuffer.checkArraySize(nArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(intBuffer.remaining());
        if (intBuffer.remaining() > 0) {
            int[] nArray = new int[intBuffer.remaining()];
            intBuffer.get(nArray);
            this.put(nArray);
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        IntBuffer.checkArraySize(nArray.length, n, n2);
        this.checkForOverflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            this.put(nArray[n3]);
            ++n3;
        }
        return this;
    }

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final int[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        int n3 = this.position() + 1;
        while (n3 < this.limit()) {
            n += (this.get(n3) + 30) * (n2 *= 31);
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof IntBuffer) {
            boolean bl = false;
            if (this.compareTo(object) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object object) {
        IntBuffer intBuffer = (IntBuffer)object;
        int n = Math.min(this.remaining(), intBuffer.remaining());
        int n2 = this.position();
        int n3 = intBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6;
            if ((n6 = this.get(n2++)) != (n5 = intBuffer.get(n3++))) {
                if (n6 < n5) {
                    return -1;
                }
                return 1;
            }
            ++n4;
        }
        return this.remaining() - intBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();

    IntBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }
}

