/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    Dimension maxSize;
    private boolean backCleared;
    boolean focusCycleRoot;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;
    static /* synthetic */ Class class$java$awt$event$ContainerListener;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n >= 0 && n < this.ncomponents) {
                return this.component[n];
            }
            throw new ArrayIndexOutOfBoundsException("no such component");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            if (this.ncomponents > 0) {
                System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            }
            return componentArray;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object[] objectArray;
            if (n > this.ncomponents || n < 0 && n != -1 || component instanceof Window || component instanceof Container && ((Container)component).isAncestorOf(this)) {
                throw new IllegalArgumentException();
            }
            if (component.parent != null) {
                component.parent.remove(component);
            }
            component.parent = this;
            if (this.peer != null) {
                component.addNotify();
                if (component.isLightweight()) {
                    this.enableEvents(component.eventMask);
                    if (!this.isLightweight()) {
                        this.enableEvents(8192L);
                    }
                }
            }
            component.invalidate();
            if (this.component == null) {
                this.component = new Component[4];
            }
            if (this.ncomponents >= this.component.length) {
                int n2 = this.component.length * 2;
                objectArray = new Component[n2];
                System.arraycopy(this.component, 0, objectArray, 0, this.ncomponents);
                this.component = objectArray;
            }
            if (n == -1) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                this.component[n] = component;
                ++this.ncomponents;
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                    layoutManager2.addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                } else {
                    this.layoutMgr.addLayoutComponent("", component);
                }
            }
            ContainerEvent containerEvent = new ContainerEvent(this, 300, component);
            objectArray = this.getContainerListeners();
            int n3 = 0;
            while (n3 < objectArray.length) {
                objectArray[n3].componentAdded(containerEvent);
                ++n3;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.component[n];
            ComponentListener[] componentListenerArray = component.getComponentListeners();
            int n2 = 0;
            while (true) {
                if (n2 >= componentListenerArray.length) {
                    component.removeNotify();
                    System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
                    this.component[--this.ncomponents] = null;
                    this.invalidate();
                    if (this.layoutMgr != null) {
                        this.layoutMgr.removeLayoutComponent(component);
                    }
                    component.parent = null;
                    if (this.isShowing()) {
                        ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                        this.getToolkit().getSystemEventQueue().postEvent(containerEvent);
                    }
                    return;
                }
                component.removeComponentListener(componentListenerArray[n2]);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            while (n < this.ncomponents) {
                if (this.component[n] == component) {
                    this.remove(n);
                    break;
                }
                ++n;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (this.ncomponents > 0) {
                this.remove(0);
            }
            return;
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        this.invalidate();
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.isValid() && this.peer != null) {
                this.validateTree();
            }
            return;
        }
    }

    void invalidateTree() {
        super.invalidate();
        int n = 0;
        while (n < this.ncomponents) {
            Component component = this.component[n];
            component.invalidate();
            if (component instanceof Container) {
                ((Container)component).invalidateTree();
            }
            ++n;
        }
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
    }

    protected void validateTree() {
        Component component;
        if (this.valid) {
            return;
        }
        ContainerPeer containerPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            containerPeer = (ContainerPeer)this.peer;
            containerPeer.beginValidate();
        }
        int n = 0;
        while (n < this.ncomponents) {
            component = this.component[n];
            if (component.getPeer() == null) {
                component.addNotify();
            }
            ++n;
        }
        this.doLayout();
        n = 0;
        while (n < this.ncomponents) {
            component = this.component[n];
            if (!component.isValid()) {
                if (component instanceof Container) {
                    ((Container)component).validateTree();
                } else {
                    this.component[n].validate();
                }
            }
            ++n;
        }
        this.valid = true;
        if (containerPeer != null) {
            containerPeer.endValidate();
        }
    }

    public void setFont(Font font) {
        if (font != null && (this.font == null || !this.font.equals(font)) || font == null) {
            super.setFont(font);
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dimension preferredSize() {
        Object object = treeLock;
        synchronized (object) {
            if (this.valid && this.prefSize != null) {
                return new Dimension(this.prefSize);
            }
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager == null) {
                return super.preferredSize();
            }
            Dimension dimension = layoutManager.preferredLayoutSize(this);
            if (this.valid) {
                this.prefSize = dimension;
            }
            return new Dimension(dimension);
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.valid && this.minSize != null) {
            return new Dimension(this.minSize);
        }
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null) {
            this.minSize = layoutManager.minimumLayoutSize(this);
            return this.minSize;
        }
        return super.minimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.valid && this.maxSize != null) {
            return new Dimension(this.maxSize);
        }
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            this.maxSize = layoutManager2.maximumLayoutSize(this);
            return this.maxSize;
        }
        return super.getMaximumSize();
    }

    public float getAlignmentX() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            f = layoutManager2.getLayoutAlignmentX(this);
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    public float getAlignmentY() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            f = layoutManager2.getLayoutAlignmentY(this);
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    public void paint(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.visitChildren(graphics, GfxPaintVisitor.INSTANCE, this.backCleared ^ true);
        this.backCleared = false;
    }

    public void update(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            this.backCleared = true;
        }
        this.paint(graphics);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        this.visitChildren(graphics, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics graphics) {
        this.paint(graphics);
        this.visitChildren(graphics, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics graphics) {
        super.paint(graphics);
        this.visitChildren(graphics, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        Class clazz = class$java$awt$event$ContainerListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ContainerListener = Container.class("[Ljava.awt.event.ContainerListener;", false);
        }
        return (ContainerListener[])AWTEventMulticaster.getListeners(this.containerListener, clazz);
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$ContainerListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$ContainerListener = Container.class("[Ljava.awt.event.ContainerListener;", false);
        }
        if (clazz == clazz2) {
            return this.getContainerListeners();
        }
        return super.getListeners(clazz);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener == null) {
            return;
        }
        switch (containerEvent.id) {
            case 300: {
                this.containerListener.componentAdded(containerEvent);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(containerEvent);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliverEvent(Event event) {
        if (this.handleEvent(event)) return;
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = this.getParent();
            if (container == null) return;
            ((Component)container).deliverEvent(event);
            return;
        }
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component locate(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3;
            int n4;
            Component component;
            if (!this.contains(n, n2)) {
                return null;
            }
            int n5 = 0;
            while (n5 < this.ncomponents) {
                component = this.component[n5];
                n4 = n - component.x;
                n3 = n2 - component.y;
                if (component.contains(n4, n3) && !component.isLightweight()) {
                    return component;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < this.ncomponents) {
                component = this.component[n5];
                n4 = n - component.x;
                n3 = n2 - component.y;
                if (component.contains(n4, n3) && component.isLightweight()) {
                    return component;
                }
                ++n5;
            }
            return this;
        }
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * Exception decompiling
     */
    public Component findComponentAt(int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [4 : 13->168)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyContainerChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            while (true) {
                if (n >= this.ncomponents) {
                    super.removeNotify();
                    return;
                }
                this.component[n].removeNotify();
                ++n;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isAncestorOf(Component var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [3 : 13->38)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String paramString() {
        if (this.layoutMgr == null) {
            return super.paramString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.paramString());
        stringBuffer.append(",layout=");
        stringBuffer.append(this.layoutMgr.getClass().getName());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void list(PrintStream printStream, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(printStream, n);
            int n2 = 0;
            while (n2 < this.ncomponents) {
                this.component[n2].list(printStream, n + 2);
                ++n2;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void list(PrintWriter printWriter, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(printWriter, n);
            int n2 = 0;
            while (n2 < this.ncomponents) {
                this.component[n2].list(printWriter, n + 2);
                ++n2;
            }
            return;
        }
    }

    public void setFocusTraversalKeys(int n, Set set) {
        String string;
        Set set2;
        Set set3;
        Object object;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        if (set == null) {
            object = this.getParent();
            while (object != null) {
                if (((Container)object).areFocusTraversalKeysSet(n)) {
                    set = ((Container)object).getFocusTraversalKeys(n);
                    break;
                }
                object = ((Component)object).getParent();
            }
            if (set == null) {
                set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
            }
        }
        switch (n) {
            case 0: {
                object = this.getFocusTraversalKeys(1);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                string = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                object = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                string = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                object = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(3);
                string = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                object = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(2);
                string = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator iterator = set.iterator();
        while (--n2 >= 0) {
            Object object2 = iterator.next();
            if (object2 instanceof AWTKeyStroke && !object.contains(object2) && !set3.contains(object2) && !set2.contains(object2) && ((AWTKeyStroke)object2).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[4];
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        this.firePropertyChange(string, this.focusTraversalKeys[n], set);
        this.focusTraversalKeys[n] = set;
    }

    public Set getFocusTraversalKeys(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        Set set = null;
        if (this.focusTraversalKeys != null) {
            set = this.focusTraversalKeys[n];
        }
        if (set == null && this.parent != null) {
            set = this.parent.getFocusTraversalKeys(n);
        }
        return set == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n) : set;
    }

    public boolean areFocusTraversalKeysSet(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        if (this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusCycleRoot(Container container) {
        if (this == container && this.isFocusCycleRoot()) {
            return true;
        }
        Container container2 = this.getFocusCycleRootAncestor();
        return container == container2;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this.focusTraversalPolicy = focusTraversalPolicy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container container = this.getFocusCycleRootAncestor();
            if (container != this) {
                return container.getFocusTraversalPolicy();
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return keyboardFocusManager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        boolean bl = false;
        if (this.focusTraversalPolicy == null) {
            bl = true;
        }
        return bl;
    }

    public void setFocusCycleRoot(boolean bl) {
        this.focusCycleRoot = bl;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.downFocusCycle(this);
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void setComponentZOrder(Component component, int n) {
        if (component == null) {
            throw new NullPointerException("comp must not be null");
        }
        if (component instanceof Container && ((Container)component).isAncestorOf(this)) {
            throw new IllegalArgumentException("comp must not be an ancestor of this");
        }
        if (component instanceof Window) {
            throw new IllegalArgumentException("comp must not be a Window");
        }
        if (component == this) {
            throw new IllegalArgumentException("cannot add component to itself");
        }
        if (component.getParent() != this) {
            throw new AssertionError((Object)"Reparenting is not implemented yet");
        }
        int n2 = this.getComponentZOrder(component);
        if (n2 < n) {
            System.arraycopy(this.component, n2 + 1, this.component, n2, n - n2);
        } else {
            System.arraycopy(this.component, n, this.component, n + 1, n2 - n);
        }
        this.component[n] = component;
    }

    public final int getComponentZOrder(Component component) {
        int n = -1;
        if (this.component != null) {
            int n2 = 0;
            while (n2 < this.component.length) {
                if (this.component[n2] == component) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void visitChildren(Graphics graphics, GfxVisitor gfxVisitor, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents - 1;
            while (n >= 0) {
                boolean bl2;
                Component component = this.component[n];
                boolean bl3 = false;
                if (component.isVisible() && (component.isLightweight() || !bl)) {
                    bl3 = true;
                }
                if (bl2 = bl3) {
                    this.visitChild(graphics, gfxVisitor, component);
                }
                --n;
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void visitChild(Graphics graphics, GfxVisitor gfxVisitor, Component component) {
        Rectangle rectangle = component.getBounds();
        if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
            return;
        }
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            gfxVisitor.visit(component, graphics2);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            graphics2.dispose();
            throw throwable;
        }
        {
            Object var7_8 = null;
            graphics2.dispose();
            return;
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        boolean bl = LightweightDispatcher.getInstance().dispatchEvent(aWTEvent);
        if (!bl) {
            if (aWTEvent.id <= 301 && aWTEvent.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
                this.processEvent(aWTEvent);
            } else {
                super.dispatchEventImpl(aWTEvent);
            }
        }
    }

    boolean eventTypeEnabled(int n) {
        if (n <= 301 && n >= 300) {
            boolean bl = false;
            if (this.containerListener != null || (this.eventMask & (long)2) != 0L) {
                bl = true;
            }
            return bl;
        }
        return super.eventTypeEnabled(n);
    }

    /*
     * Exception decompiling
     */
    Component findNextFocusComponent(Component var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [4 : 13->202)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents;
            while (--n >= 0) {
                this.component[n].addNotify();
                if (!this.component[n].isLightweight()) continue;
                this.enableEvents(this.component[n].eventMask);
                if (this.peer == null || this.isLightweight()) continue;
                this.enableEvents(8192L);
            }
            return;
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        while (string != null) {
            Object object = objectInputStream.readObject();
            if ("containerL".equals(string)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(string)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            string = (String)objectInputStream.readObject();
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paint(graphics);
        }

        GfxPaintVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.print(graphics);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paintAll(graphics);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.printAll(graphics);
        }

        GfxPrintAllVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getAccessibleChildrenCount() {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                int n = 0;
                int n2 = 0;
                if (Container.this.component != null) {
                    n2 = Container.this.component.length;
                }
                int n3 = n2;
                while (--n3 >= 0) {
                    if (!(Container.this.component[n3] instanceof Accessible)) continue;
                    ++n;
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Accessible getAccessibleChild(int n) {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                if (Container.this.component == null) {
                    return null;
                }
                int n2 = -1;
                while (n >= 0 && ++n2 < Container.this.component.length) {
                    if (!(Container.this.component[n2] instanceof Accessible)) continue;
                    --n;
                }
                if (n < 0) {
                    return (Accessible)((Object)Container.this.component[n2]);
                }
                return null;
            }
        }

        public Accessible getAccessibleAt(Point point) {
            Component component = Container.this.getComponentAt(point.x, point.y);
            return component != Container.this && component instanceof Accessible ? (Accessible)((Object)component) : null;
        }

        private final /* synthetic */ void this() {
            this.accessibleContainerHandler = new AccessibleContainerHandler();
        }

        protected AccessibleAWTContainer() {
            this.this();
            Container.this.addContainerListener(this.accessibleContainerHandler);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleContainerHandler
        implements ContainerListener {
            public void componentAdded(ContainerEvent containerEvent) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, containerEvent.getChild());
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", containerEvent.getChild(), null);
            }

            protected AccessibleContainerHandler() {
            }
        }
    }
}

