/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -7644114512714619750L;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    static final Object treeLock = new String("AWT_TREE_LOCK");
    private static transient boolean incrementalDraw = Boolean.getBoolean("awt.image.incrementalDraw");
    private static transient Long redrawRate = Long.getLong("awt.image.redrawrate");
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean ignoreRepaint;
    boolean visible;
    boolean enabled;
    boolean valid;
    DropTarget dropTarget;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    boolean focusable;
    int isFocusTraversableOverridden;
    Set[] focusTraversalKeys;
    boolean focusTraversalKeysEnabled;
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly;
    long eventMask;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion;
    AccessibleContext accessibleContext;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentOrientation orientation;
    transient GraphicsConfiguration graphicsConfig;
    transient BufferStrategy bufferStrategy;
    private transient FocusEvent pendingFocusRequest;
    static /* synthetic */ Class class$java$awt$event$ComponentListener;
    static /* synthetic */ Class class$java$awt$event$FocusListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyBoundsListener;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;
    static /* synthetic */ Class class$java$awt$event$MouseWheelListener;
    static /* synthetic */ Class class$java$awt$event$InputMethodListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.nameExplicitlySet = true;
        this.name = string;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public void setDropTarget(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getGraphicsConfigurationImpl();
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        Toolkit toolkit;
        if (this.peer != null && (toolkit = this.peer.getToolkit()) != null) {
            return toolkit;
        }
        if (this.parent != null) {
            return this.parent.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDisplayable() {
        boolean bl = false;
        if (this.peer != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (!this.visible || this.peer == null) {
            return false;
        }
        boolean bl = false;
        if (this.parent != null) {
            bl = this.parent.isShowing();
        }
        return bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable() {
        this.enabled = true;
        if (this.peer != null) {
            this.peer.setEnabled(true);
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        this.enabled = false;
        if (this.peer != null) {
            this.peer.setEnabled(false);
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean bl) {
        this.eventMask = bl ? (this.eventMask |= 0x1000L) : (this.eventMask &= 0xFFFFFFFFFFFFEFFFL);
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if (!this.isVisible()) {
            Container container;
            this.visible = true;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null) {
                componentPeer.show();
            }
            if (this.isShowing() && this.isLightweight()) {
                this.repaint();
            }
            if ((container = this.parent) != null) {
                container.invalidate();
            }
            ComponentEvent componentEvent = new ComponentEvent(this, 102);
            this.getToolkit().getSystemEventQueue().postEvent(componentEvent);
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this.isVisible()) {
            Container container;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null) {
                componentPeer.setVisible(false);
            }
            boolean bl = this.isShowing();
            this.visible = false;
            if (bl) {
                this.repaint();
            }
            if ((container = this.parent) != null) {
                container.invalidate();
            }
            ComponentEvent componentEvent = new ComponentEvent(this, 103);
            this.getToolkit().getSystemEventQueue().postEvent(componentEvent);
        }
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent == null ? null : this.parent.getForeground();
    }

    public void setForeground(Color color) {
        if (this.peer != null) {
            this.peer.setForeground(color);
        }
        Color color2 = this.foreground;
        this.foreground = color;
        this.firePropertyChange("foreground", color2, color);
    }

    public boolean isForegroundSet() {
        boolean bl = false;
        if (this.foreground != null) {
            bl = true;
        }
        return bl;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return this.parent == null ? null : this.parent.getBackground();
    }

    public void setBackground(Color color) {
        if (color != null && color.equals(this.background)) {
            return;
        }
        Color color2 = this.background;
        this.background = color;
        if (this.peer != null && color != null) {
            this.peer.setBackground(color);
        }
        this.firePropertyChange("background", color2, color);
    }

    public boolean isBackgroundSet() {
        boolean bl = false;
        if (this.background != null) {
            bl = true;
        }
        return bl;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getFont();
        }
        if (this.peer != null) {
            return this.peer.getGraphics().getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        if (font != null && (this.font == null || !this.font.equals(font)) || font == null) {
            Font font2 = this.font;
            this.font = font;
            if (this.peer != null) {
                this.peer.setFont(this.font);
            }
            this.firePropertyChange("font", font2, font);
            this.invalidate();
        }
    }

    public boolean isFontSet() {
        boolean bl = false;
        if (this.font != null) {
            bl = true;
        }
        return bl;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: can't determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        this.firePropertyChange("locale", locale2, locale);
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        return graphicsConfiguration != null ? graphicsConfiguration.getColorModel() : this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component " + this.getClass().getName() + " not showing");
        }
        return this.peer.getLocationOnScreen();
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(Dimension dimension) {
        this.resize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Serializable serializable;
        Rectangle rectangle2;
        int n5 = this.x;
        int n6 = this.y;
        int n7 = this.width;
        int n8 = this.height;
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        this.invalidate();
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.peer != null) {
            this.peer.setBounds(n, n2, n3, n4);
        }
        if (this.isLightweight() && this.isShowing() && this.parent != null && !(rectangle2 = ((Rectangle)(serializable = new Rectangle(n5, n6, n7, n8))).union(rectangle = new Rectangle(n, n2, n3, n4))).isEmpty()) {
            this.parent.repaint(0L, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        if (this.isShowing() && (n5 != n || n6 != n2)) {
            serializable = new ComponentEvent(this, 100);
            this.getToolkit().getSystemEventQueue().postEvent((AWTEvent)serializable);
        }
        if (this.isShowing() && (n7 != n3 || n8 != n4)) {
            serializable = new ComponentEvent(this, 101);
            this.getToolkit().getSystemEventQueue().postEvent((AWTEvent)serializable);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.x;
        rectangle.y = this.y;
        rectangle.width = this.width;
        rectangle.height = this.height;
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.width = this.width;
        dimension.height = this.height;
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.x = this.x;
        point.y = this.y;
        return point;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isLightweight() {
        return this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.prefSize == null) {
            this.prefSize = this.peer == null ? this.minimumSize() : this.peer.getPreferredSize();
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.minSize == null) {
            this.minSize = this.peer != null ? this.peer.getMinimumSize() : new Dimension(this.width, this.height);
        }
        return this.minSize;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    public void validate() {
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
        this.prefSize = null;
        this.minSize = null;
        if (this.parent != null && this.parent.isValid()) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        if (this.peer != null) {
            Graphics graphics = this.peer.getGraphics();
            if (graphics == null && this.parent != null) {
                graphics = this.parent.getGraphics();
                Rectangle rectangle = this.getBounds();
                graphics.setClip(rectangle);
                graphics.translate(rectangle.x, rectangle.y);
                return graphics;
            }
            graphics.setFont(this.font);
            return graphics;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.peer == null ? this.getToolkit().getFontMetrics(font) : this.peer.getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        if (this.peer != null) {
            this.peer.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent != null ? this.parent.getCursor() : Cursor.getDefaultCursor();
    }

    public boolean isCursorSet() {
        boolean bl = false;
        if (this.cursor != null) {
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        if (this.isLightweight() || this.getParent() == null) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                graphics.clearRect(0, 0, this.width, this.height);
            } else {
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.paint(graphics);
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        ComponentPeer componentPeer;
        if (this.isShowing() && (componentPeer = this.peer) != null) {
            componentPeer.repaint(l, n, n2, n3, n4);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        this.paintAll(graphics);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.repaint();
        } else if ((n & 8) != 0 && incrementalDraw) {
            if (redrawRate != null) {
                long l = redrawRate;
                if (l < 0L) {
                    l = 0L;
                }
                this.repaint(l);
            } else {
                this.repaint(100L);
            }
        }
        boolean bl = false;
        if ((n & 0xE0) == 0) {
            bl = true;
        }
        return bl;
    }

    public Image createImage(ImageProducer imageProducer) {
        if (this.peer != null) {
            return this.peer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        Image image = null;
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.isLightweight() && this.parent != null) {
                image = this.parent.createImage(n, n2);
            } else if (this.peer != null) {
                image = this.peer.createImage(n, n2);
            }
        }
        return image;
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        return graphicsConfiguration == null ? null : graphicsConfiguration.createCompatibleVolatileImage(n, n2);
    }

    public VolatileImage createVolatileImage(int n, int n2, ImageCapabilities imageCapabilities) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        return graphicsConfiguration == null ? null : graphicsConfiguration.createCompatibleVolatileImage(n, n2, imageCapabilities);
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.peer != null) {
            return this.peer.prepareImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.peer != null) {
            return this.peer.checkImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public void setIgnoreRepaint(boolean bl) {
        this.ignoreRepaint = bl;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean inside(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n2 >= 0 && n < this.width && n2 < this.height) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component locate(int n, int n2) {
        return this.contains(n, n2) ? this : null;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        Event event = Component.translateEvent(aWTEvent);
        if (event != null) {
            this.postEvent(event);
        }
        this.dispatchEventImpl(aWTEvent);
    }

    public boolean postEvent(Event event) {
        boolean bl = this.handleEvent(event);
        if (!bl && this.getParent() != null) {
            bl = this.getParent().postEvent(event);
        }
        return bl;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        if (this.componentListener != null) {
            this.enableEvents(1L);
        }
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        Class clazz = class$java$awt$event$ComponentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ComponentListener = Component.class("[Ljava.awt.event.ComponentListener;", false);
        }
        return (ComponentListener[])AWTEventMulticaster.getListeners(this.componentListener, clazz);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        if (this.focusListener != null) {
            this.enableEvents(4);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized FocusListener[] getFocusListeners() {
        Class clazz = class$java$awt$event$FocusListener;
        if (clazz == null) {
            clazz = class$java$awt$event$FocusListener = Component.class("[Ljava.awt.event.FocusListener;", false);
        }
        return (FocusListener[])AWTEventMulticaster.getListeners(this.focusListener, clazz);
    }

    public synchronized void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, hierarchyListener);
        if (this.hierarchyListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, hierarchyListener);
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        Class clazz = class$java$awt$event$HierarchyListener;
        if (clazz == null) {
            clazz = class$java$awt$event$HierarchyListener = Component.class("[Ljava.awt.event.HierarchyListener;", false);
        }
        return (HierarchyListener[])AWTEventMulticaster.getListeners(this.hierarchyListener, clazz);
    }

    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, hierarchyBoundsListener);
        if (this.hierarchyBoundsListener != null) {
            this.enableEvents(65536L);
        }
    }

    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, hierarchyBoundsListener);
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        Class clazz = class$java$awt$event$HierarchyBoundsListener;
        if (clazz == null) {
            clazz = class$java$awt$event$HierarchyBoundsListener = Component.class("[Ljava.awt.event.HierarchyBoundsListener;", false);
        }
        return (HierarchyBoundsListener[])AWTEventMulticaster.getListeners(this.hierarchyBoundsListener, clazz);
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        if (this.keyListener != null) {
            this.enableEvents(8L);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized KeyListener[] getKeyListeners() {
        Class clazz = class$java$awt$event$KeyListener;
        if (clazz == null) {
            clazz = class$java$awt$event$KeyListener = Component.class("[Ljava.awt.event.KeyListener;", false);
        }
        return (KeyListener[])AWTEventMulticaster.getListeners(this.keyListener, clazz);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        if (this.mouseListener != null) {
            this.enableEvents(16L);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        Class clazz = class$java$awt$event$MouseListener;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseListener = Component.class("[Ljava.awt.event.MouseListener;", false);
        }
        return (MouseListener[])AWTEventMulticaster.getListeners(this.mouseListener, clazz);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        if (this.mouseMotionListener != null) {
            this.enableEvents(32L);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        Class clazz = class$java$awt$event$MouseMotionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseMotionListener = Component.class("[Ljava.awt.event.MouseMotionListener;", false);
        }
        return (MouseMotionListener[])AWTEventMulticaster.getListeners(this.mouseMotionListener, clazz);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, mouseWheelListener);
        if (this.mouseWheelListener != null) {
            this.enableEvents(131072L);
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, mouseWheelListener);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        Class clazz = class$java$awt$event$MouseWheelListener;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseWheelListener = Component.class("[Ljava.awt.event.MouseWheelListener;", false);
        }
        return (MouseWheelListener[])AWTEventMulticaster.getListeners(this.mouseWheelListener, clazz);
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        if (this.inputMethodListener != null) {
            this.enableEvents(2048L);
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = Component.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        return (InputMethodListener[])AWTEventMulticaster.getListeners(this.inputMethodListener, clazz);
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$ComponentListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$ComponentListener = Component.class("[Ljava.awt.event.ComponentListener;", false);
        }
        if (clazz == clazz2) {
            return this.getComponentListeners();
        }
        Class clazz3 = class$java$awt$event$FocusListener;
        if (clazz3 == null) {
            clazz3 = class$java$awt$event$FocusListener = Component.class("[Ljava.awt.event.FocusListener;", false);
        }
        if (clazz == clazz3) {
            return this.getFocusListeners();
        }
        Class clazz4 = class$java$awt$event$HierarchyListener;
        if (clazz4 == null) {
            clazz4 = class$java$awt$event$HierarchyListener = Component.class("[Ljava.awt.event.HierarchyListener;", false);
        }
        if (clazz == clazz4) {
            return this.getHierarchyListeners();
        }
        Class clazz5 = class$java$awt$event$HierarchyBoundsListener;
        if (clazz5 == null) {
            clazz5 = class$java$awt$event$HierarchyBoundsListener = Component.class("[Ljava.awt.event.HierarchyBoundsListener;", false);
        }
        if (clazz == clazz5) {
            return this.getHierarchyBoundsListeners();
        }
        Class clazz6 = class$java$awt$event$KeyListener;
        if (clazz6 == null) {
            clazz6 = class$java$awt$event$KeyListener = Component.class("[Ljava.awt.event.KeyListener;", false);
        }
        if (clazz == clazz6) {
            return this.getKeyListeners();
        }
        Class clazz7 = class$java$awt$event$MouseListener;
        if (clazz7 == null) {
            clazz7 = class$java$awt$event$MouseListener = Component.class("[Ljava.awt.event.MouseListener;", false);
        }
        if (clazz == clazz7) {
            return this.getMouseListeners();
        }
        Class clazz8 = class$java$awt$event$MouseMotionListener;
        if (clazz8 == null) {
            clazz8 = class$java$awt$event$MouseMotionListener = Component.class("[Ljava.awt.event.MouseMotionListener;", false);
        }
        if (clazz == clazz8) {
            return this.getMouseMotionListeners();
        }
        Class clazz9 = class$java$awt$event$MouseWheelListener;
        if (clazz9 == null) {
            clazz9 = class$java$awt$event$MouseWheelListener = Component.class("[Ljava.awt.event.MouseWheelListener;", false);
        }
        if (clazz == clazz9) {
            return this.getMouseWheelListeners();
        }
        Class clazz10 = class$java$awt$event$InputMethodListener;
        if (clazz10 == null) {
            clazz10 = class$java$awt$event$InputMethodListener = Component.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        if (clazz == clazz10) {
            return this.getInputMethodListeners();
        }
        Class clazz11 = class$java$beans$PropertyChangeListener;
        if (clazz11 == null) {
            clazz11 = class$java$beans$PropertyChangeListener = Component.class("[Ljava.beans.PropertyChangeListener;", false);
        }
        if (clazz == clazz11) {
            return this.getPropertyChangeListeners();
        }
        return (EventListener[])Array.newInstance(clazz, 0);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        return this.parent == null ? null : this.parent.getInputContext();
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        if (this.isLightweight() && this.parent != null) {
            this.parent.enableEvents(l);
        } else if (this.peer != null) {
            this.peer.setEventMask(this.eventMask);
        }
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ -1L;
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        switch (aWTEvent.id) {
            case 503: 
            case 506: {
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                return this.coalescePaintEvents((PaintEvent)aWTEvent, (PaintEvent)aWTEvent2);
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseWheelEvent) {
            this.processMouseWheelEvent((MouseWheelEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            if (aWTEvent.id == 503 || aWTEvent.id == 506) {
                this.processMouseMotionEvent((MouseEvent)aWTEvent);
            } else {
                this.processMouseEvent((MouseEvent)aWTEvent);
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof HierarchyEvent) {
            if (aWTEvent.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)aWTEvent);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.componentListener == null) {
            return;
        }
        switch (componentEvent.id) {
            case 103: {
                this.componentListener.componentHidden(componentEvent);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(componentEvent);
                break;
            }
            case 101: {
                this.componentListener.componentResized(componentEvent);
                break;
            }
            case 102: {
                this.componentListener.componentShown(componentEvent);
                break;
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener == null) {
            return;
        }
        switch (focusEvent.id) {
            case 1004: {
                this.focusListener.focusGained(focusEvent);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(focusEvent);
                break;
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener == null) {
            return;
        }
        switch (keyEvent.id) {
            case 401: {
                this.keyListener.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(keyEvent);
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener == null) {
            return;
        }
        switch (mouseEvent.id) {
            case 500: {
                this.mouseListener.mouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this.mouseListener.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(mouseEvent);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(mouseEvent);
                break;
            }
        }
        mouseEvent.consume();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (mouseEvent.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(mouseEvent);
                break;
            }
        }
        mouseEvent.consume();
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.mouseWheelListener != null && mouseWheelEvent.id == 507) {
            this.mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
            mouseWheelEvent.consume();
        }
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (inputMethodEvent.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(inputMethodEvent);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(inputMethodEvent);
                break;
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (hierarchyEvent.id == 1400) {
            this.hierarchyListener.hierarchyChanged(hierarchyEvent);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (hierarchyEvent.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(hierarchyEvent);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(hierarchyEvent);
                break;
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        } else if (this.parent != null && this.parent.isLightweight()) {
            new HeavyweightInLightweightListener(this.parent);
        }
        this.peer.setEventMask(this.eventMask);
    }

    public void removeNotify() {
        ComponentPeer componentPeer = this.peer;
        this.peer = null;
        if (componentPeer != null) {
            componentPeer.hide();
            componentPeer.dispose();
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        boolean bl = false;
        if (this.enabled && this.visible && (this.peer == null || this.isLightweight() || this.peer.isFocusTraversable())) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean bl) {
        this.firePropertyChange("focusable", this.focusable, bl);
        this.focusable = bl;
        this.isFocusTraversableOverridden = 1;
    }

    public void setFocusTraversalKeys(int n, Set set) {
        String string;
        Set set2;
        Object object;
        if (set == null) {
            object = this.getParent();
            while (object != null) {
                if (((Container)object).areFocusTraversalKeysSet(n)) {
                    set = ((Container)object).getFocusTraversalKeys(n);
                    break;
                }
                object = ((Component)object).getParent();
            }
            if (set == null) {
                set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
            }
        }
        switch (n) {
            case 0: {
                object = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(2);
                string = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                object = this.getFocusTraversalKeys(0);
                set2 = this.getFocusTraversalKeys(2);
                string = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                object = this.getFocusTraversalKeys(0);
                set2 = this.getFocusTraversalKeys(1);
                string = "upCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator iterator = set.iterator();
        while (--n2 >= 0) {
            Object object2 = iterator.next();
            if (object2 instanceof AWTKeyStroke && !object.contains(object2) && !set2.contains(object2) && ((AWTKeyStroke)object2).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[3];
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        this.firePropertyChange(string, this.focusTraversalKeys[n], set);
        this.focusTraversalKeys[n] = set;
    }

    public Set getFocusTraversalKeys(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        Set set = null;
        if (this.focusTraversalKeys != null) {
            set = this.focusTraversalKeys[n];
        }
        if (set == null && this.parent != null) {
            set = this.parent.getFocusTraversalKeys(n);
        }
        return set == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n) : set;
    }

    public boolean areFocusTraversalKeysSet(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        if (this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null) {
            bl = true;
        }
        return bl;
    }

    public void setFocusTraversalKeysEnabled(boolean bl) {
        this.firePropertyChange("focusTraversalKeysEnabled", this.focusTraversalKeysEnabled, bl);
        this.focusTraversalKeysEnabled = bl;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestFocus() {
        block12: {
            if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block12;
            Object object = this.getTreeLock();
            synchronized (object) {
                block13: {
                    block11: {
                        Container container = this instanceof Container ? (Container)this : this.getParent();
                        Container container2 = container;
                        while (container2 != null && !(container2 instanceof Window)) {
                            container2 = container2.getParent();
                        }
                        if (container2 == null) {
                            return;
                        }
                        Window window = (Window)container2;
                        if (!window.isFocusableWindow()) break block13;
                        if (this.peer != null && !this.isLightweight()) {
                            this.peer.requestFocus();
                        } else {
                            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                            EventQueue eventQueue2 = eventQueue;
                            synchronized (eventQueue2) {
                                block10: {
                                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                    Component component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                    if (component == null) break block10;
                                    eventQueue.postEvent(new FocusEvent(component, 1005, false, this));
                                    eventQueue.postEvent(new FocusEvent(this, 1004, false, component));
                                    break block11;
                                }
                                eventQueue.postEvent(new FocusEvent(this, 1004, false));
                            }
                        }
                    }
                    break block12;
                }
                this.pendingFocusRequest = new FocusEvent(this, 1004);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean requestFocus(boolean bl) {
        block9: {
            if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block9;
            Object object = this.getTreeLock();
            synchronized (object) {
                block8: {
                    Container container = this.getParent();
                    while (true) {
                        if (container == null || container instanceof Window) {
                            Window window = (Window)container;
                            if (!window.isFocusableWindow()) break block8;
                            if (this.peer == null || this.isLightweight()) break;
                            this.peer.requestFocus();
                            break block9;
                        }
                        container = container.getParent();
                    }
                    EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    EventQueue eventQueue2 = eventQueue;
                    synchronized (eventQueue2) {
                        block11: {
                            block10: {
                                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                if (component == null) break block10;
                                eventQueue.postEvent(new FocusEvent(component, 1005, bl, this));
                                eventQueue.postEvent(new FocusEvent(this, 1004, bl, component));
                                break block11;
                            }
                            eventQueue.postEvent(new FocusEvent(this, 1004, bl));
                        }
                        break block9;
                    }
                }
                this.pendingFocusRequest = new FocusEvent(this, 1004, bl);
            }
        }
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean requestFocusInWindow(boolean var1_1) {
        block10: {
            block11: {
                var2_2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                var3_3 = var2_2.getFocusedWindow();
                if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block11;
                if (var3_3 == null) break block10;
                var4_4 = this.getTreeLock();
                synchronized (var4_4) {
                    var7_5 = this.getParent();
                    if (true) ** GOTO lbl16
                }
            }
            return false;
            {
                block12: {
                    do {
                        var7_5 = var7_5.getParent();
lbl16:
                        // 2 sources

                    } while (var7_5 != null && !(var7_5 instanceof Window));
                    var8_6 = (Window)var7_5;
                    if (var3_3 != var8_6) {
                        return false;
                    }
                    if (this.peer == null || this.isLightweight() || this instanceof Window) break block12;
                    this.peer.requestFocus();
                    break block10;
                }
                var9_7 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                var10_8 = var9_7;
                synchronized (var10_8) {
                    block9: {
                        var13_9 = var2_2.getGlobalPermanentFocusOwner();
                        if (var13_9 == null) break block9;
                        var9_7.postEvent(new FocusEvent(var13_9, 1005, var1_1, this));
                        var9_7.postEvent(new FocusEvent(this, 1004, var1_1, var13_9));
                        break block10;
                    }
                    var9_7.postEvent(new FocusEvent(this, 1004, var1_1));
                }
            }
        }
        return true;
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public Container getFocusCycleRootAncestor() {
        if (this instanceof Window && ((Container)this).isFocusCycleRoot()) {
            return (Container)this;
        }
        Container container = this.getParent();
        while (container != null && !container.isFocusCycleRoot()) {
            container = container.getParent();
        }
        return container;
    }

    public boolean isFocusCycleRoot(Container container) {
        boolean bl = false;
        if (container == this.getFocusCycleRootAncestor()) {
            bl = true;
        }
        return bl;
    }

    public void nextFocus() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.focusNextComponent(this);
    }

    public void transferFocusBackward() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.focusPreviousComponent(this);
    }

    public void transferFocusUpCycle() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.upFocusCycle(this);
    }

    public boolean hasFocus() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        boolean bl = false;
        if (this == component) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusOwner() {
        return this.hasFocus();
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.add(popupMenu);
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        popupMenu.parent = this;
        if (this.peer != null) {
            popupMenu.addNotify();
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        if (this.popups != null) {
            this.popups.remove(menuComponent);
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        if (string != null) {
            stringBuffer.append(string).append(",");
        }
        stringBuffer.append(this.x).append(",").append(this.y).append(",").append(this.width).append("x").append(this.height);
        if (!this.isValid()) {
            stringBuffer.append(",invalid");
        }
        if (!this.isVisible()) {
            stringBuffer.append(",invisible");
        }
        if (!this.isEnabled()) {
            stringBuffer.append(",disabled");
        }
        if (!this.isOpaque()) {
            stringBuffer.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            stringBuffer.append(",doublebuffered");
        }
        if (this.parent == null) {
            stringBuffer.append(",parent=null");
        } else {
            stringBuffer.append(",parent=").append(this.parent.getName());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.paramString() + ']';
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print(' ');
            ++n2;
        }
        printStream.println(this.toString());
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, bl, bl2);
        }
    }

    protected void firePropertyChange(String string, int n, int n2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, n, n2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public void firePropertyChange(String string, char c, char c2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public void firePropertyChange(String string, short s, short s2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public void firePropertyChange(String string, long l, long l2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public void firePropertyChange(String string, float f, float f2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public void firePropertyChange(String string, double d, double d2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
        ComponentOrientation componentOrientation2 = this.orientation;
        this.orientation = componentOrientation;
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
    }

    public ComponentOrientation getComponentOrientation() {
        return this.orientation;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        this.setComponentOrientation(componentOrientation);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    String generateName() {
        return null;
    }

    final void setPeer(ComponentPeer componentPeer) {
        this.peer = componentPeer;
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.peer != null && (graphicsConfiguration = this.peer.getGraphicsConfiguration()) != null) {
            return graphicsConfiguration;
        }
        if (this.parent != null) {
            return this.parent.getGraphicsConfiguration();
        }
        return null;
    }

    static Event translateEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        Event event = null;
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            long l = inputEvent.getWhen();
            int n = 0;
            int n2 = aWTEvent.getID();
            int n3 = 0;
            int n4 = inputEvent.getModifiersEx();
            if ((n4 & 0x800) != 0) {
                n3 |= 4;
            } else if ((n4 & 0x1000) != 0) {
                n3 |= 8;
            }
            if ((n4 & 0x40) != 0) {
                n3 |= 1;
            }
            if ((n4 & 0x80) != 0) {
                n3 |= 2;
            }
            if ((n4 & 0x100) != 0) {
                n3 |= 4;
            }
            if ((n4 & 0x200) != 0) {
                n3 |= 8;
            }
            if (aWTEvent instanceof MouseEvent) {
                if (n2 == 501) {
                    n = 501;
                } else if (n2 == 502) {
                    n = 502;
                } else if (n2 == 503) {
                    n = 503;
                } else if (n2 == 506) {
                    n = 506;
                } else if (n2 == 504) {
                    n = 504;
                } else if (n2 == 505) {
                    n = 505;
                } else {
                    return null;
                }
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                event = new Event(object, l, n, mouseEvent.getX(), mouseEvent.getY(), 0, n3);
            } else if (aWTEvent instanceof KeyEvent) {
                if (n2 == 401) {
                    n = 401;
                } else if (aWTEvent.getID() == 402) {
                    n = 402;
                } else {
                    return null;
                }
                int n5 = 0;
                int n6 = ((KeyEvent)aWTEvent).getKeyCode();
                switch (n6) {
                    case 8: {
                        n5 = 8;
                        break;
                    }
                    case 20: {
                        n5 = 1022;
                        break;
                    }
                    case 127: {
                        n5 = 127;
                        break;
                    }
                    case 40: 
                    case 225: {
                        n5 = 1005;
                        break;
                    }
                    case 35: {
                        n5 = 1001;
                        break;
                    }
                    case 10: {
                        n5 = 10;
                        break;
                    }
                    case 27: {
                        n5 = 27;
                        break;
                    }
                    case 112: {
                        n5 = 1008;
                        break;
                    }
                    case 121: {
                        n5 = 1017;
                        break;
                    }
                    case 122: {
                        n5 = 1018;
                        break;
                    }
                    case 123: {
                        n5 = 1019;
                        break;
                    }
                    case 113: {
                        n5 = 1009;
                        break;
                    }
                    case 114: {
                        n5 = 1010;
                        break;
                    }
                    case 115: {
                        n5 = 1011;
                        break;
                    }
                    case 116: {
                        n5 = 1012;
                        break;
                    }
                    case 117: {
                        n5 = 1013;
                        break;
                    }
                    case 118: {
                        n5 = 1014;
                        break;
                    }
                    case 119: {
                        n5 = 1015;
                        break;
                    }
                    case 120: {
                        n5 = 1016;
                        break;
                    }
                    case 36: {
                        n5 = 1000;
                        break;
                    }
                    case 155: {
                        n5 = 1025;
                        break;
                    }
                    case 37: 
                    case 226: {
                        n5 = 1006;
                        break;
                    }
                    case 144: {
                        n5 = 1023;
                        break;
                    }
                    case 19: {
                        n5 = 1024;
                        break;
                    }
                    case 34: {
                        n5 = 1003;
                        break;
                    }
                    case 33: {
                        n5 = 1002;
                        break;
                    }
                    case 154: {
                        n5 = 1020;
                        break;
                    }
                    case 39: 
                    case 227: {
                        n5 = 1007;
                        break;
                    }
                    case 145: {
                        n5 = 1021;
                        break;
                    }
                    case 9: {
                        n5 = 9;
                        break;
                    }
                    case 38: 
                    case 224: {
                        n5 = 1004;
                        break;
                    }
                    default: {
                        n5 = n6;
                    }
                }
                event = new Event(object, l, n, 0, 0, n5, n3);
            }
        } else if (aWTEvent instanceof AdjustmentEvent) {
            AdjustmentEvent adjustmentEvent = (AdjustmentEvent)aWTEvent;
            int n = adjustmentEvent.getAdjustmentType();
            int n7 = n == 3 ? 603 : (n == 4 ? 604 : (n == 5 ? 605 : (n == 2 ? 601 : (n == 1 ? 602 : n))));
            event = new Event(object, n7, new Integer(adjustmentEvent.getValue()));
        } else if (aWTEvent instanceof ActionEvent) {
            event = new Event(object, 1001, ((ActionEvent)aWTEvent).getActionCommand());
        }
        return event;
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        boolean bl;
        Toolkit.getDefaultToolkit().globalDispatchEvent(aWTEvent);
        boolean bl2 = false;
        if (aWTEvent instanceof FocusEvent && ((FocusEvent)aWTEvent).getComponent() == ((FocusEvent)aWTEvent).getOppositeComponent()) {
            bl2 = bl = true;
        }
        if (this.eventTypeEnabled(aWTEvent.id)) {
            if (!Thread.holdsLock(aWTEvent)) {
                switch (aWTEvent.id) {
                    case 207: 
                    case 208: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 1004: 
                    case 1005: {
                        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(aWTEvent)) {
                            return;
                        }
                    }
                    case 501: {
                        if (!this.isLightweight()) break;
                        this.requestFocus();
                        break;
                    }
                }
            }
            if (aWTEvent.id != 800 && aWTEvent.id != 801 && !bl) {
                this.processEvent(aWTEvent);
            }
        }
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
    }

    boolean eventTypeEnabled(int n) {
        if (n > 1999) {
            return true;
        }
        switch (n) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                boolean bl = false;
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 400: 
            case 401: 
            case 402: {
                boolean bl = false;
                if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                boolean bl = false;
                if (this.mouseListener != null || (this.eventMask & 0x10L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 503: 
            case 506: {
                boolean bl = false;
                if (this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 507: {
                boolean bl = false;
                if (this.mouseWheelListener != null || (this.eventMask & 0x20000L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 1004: 
            case 1005: {
                boolean bl = false;
                if (this.focusListener != null || (this.eventMask & (long)4) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 1100: 
            case 1101: {
                boolean bl = false;
                if (this.inputMethodListener != null || (this.eventMask & 0x800L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 800: 
            case 801: {
                boolean bl = false;
                if ((this.eventMask & 0x2000L) != 0L) {
                    bl = true;
                }
                return bl;
            }
        }
        return false;
    }

    private final PaintEvent coalescePaintEvents(PaintEvent paintEvent, PaintEvent paintEvent2) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        Rectangle rectangle2 = paintEvent2.getUpdateRect();
        Rectangle rectangle3 = rectangle.union(rectangle2);
        paintEvent2.setUpdateRect(rectangle3);
        return paintEvent2;
    }

    Component findNextFocusComponent(Component component) {
        return null;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        while (string != null) {
            Object object = objectInputStream.readObject();
            if ("componentL".equals(string)) {
                this.addComponentListener((ComponentListener)object);
            } else if ("focusL".equals(string)) {
                this.addFocusListener((FocusListener)object);
            } else if ("keyL".equals(string)) {
                this.addKeyListener((KeyListener)object);
            } else if ("mouseL".equals(string)) {
                this.addMouseListener((MouseListener)object);
            } else if ("mouseMotionL".equals(string)) {
                this.addMouseMotionListener((MouseMotionListener)object);
            } else if ("inputMethodL".equals(string)) {
                this.addInputMethodListener((InputMethodListener)object);
            } else if ("hierarchyL".equals(string)) {
                this.addHierarchyListener((HierarchyListener)object);
            } else if ("hierarchyBoundsL".equals(string)) {
                this.addHierarchyBoundsListener((HierarchyBoundsListener)object);
            } else if ("mouseWheelL".equals(string)) {
                this.addMouseWheelListener((MouseWheelListener)object);
            }
            string = (String)objectInputStream.readObject();
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "componentL", this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, "focusL", this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, "keyL", this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, "mouseL", this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, "mouseMotionL", this.mouseMotionListener);
        AWTEventMulticaster.save(objectOutputStream, "inputMethodL", this.inputMethodListener);
        AWTEventMulticaster.save(objectOutputStream, "hierarchyL", this.hierarchyListener);
        AWTEventMulticaster.save(objectOutputStream, "hierarchyBoundsL", this.hierarchyBoundsListener);
        AWTEventMulticaster.save(objectOutputStream, "mouseWheelL", this.mouseWheelListener);
        objectOutputStream.writeObject(null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.locale = Locale.getDefault();
        this.visible = true;
        this.enabled = true;
        this.focusable = true;
        this.focusTraversalKeysEnabled = true;
        this.eventMask = 4096L;
        this.componentSerializedDataVersion = 4;
        this.orientation = ComponentOrientation.UNKNOWN;
        this.pendingFocusRequest = null;
    }

    protected Component() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HeavyweightInLightweightListener
    implements ComponentListener {
        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (Component.this.peer != null) {
                Component.this.peer.setBounds(Component.this.x, Component.this.y, Component.this.width, Component.this.height);
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (Component.this.isShowing()) {
                Component.this.peer.show();
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (!Component.this.isShowing()) {
                Component.this.peer.hide();
            }
        }

        public HeavyweightInLightweightListener(Container container) {
            container.addComponentListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FlipBufferStrategy
    extends BufferStrategy {
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;
        private int width;
        private int height;

        protected void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
            if (n <= 1) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: numBuffers must be greater than one.");
            }
            if (!bufferCapabilities.isPageFlipping()) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: flipping must be a specified capability.");
            }
            Component.this.peer.createBuffers(n, bufferCapabilities);
        }

        protected Image getBackBuffer() {
            return Component.this.peer.getBackBuffer();
        }

        protected void flip(BufferCapabilities.FlipContents flipContents) {
            Component.this.peer.flip(flipContents);
        }

        protected void destroyBuffers() {
            Component.this.peer.destroyBuffers();
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.drawVBuffer.getGraphics();
        }

        protected void revalidate() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            if (this.drawVBuffer.validate(graphicsConfiguration) == 2) {
                this.drawVBuffer = Component.this.peer.createVolatileImage(this.width, this.height);
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            if (this.drawVBuffer.contentsLost()) {
                this.validatedContents = false;
                return true;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int n = this.drawVBuffer.validate(graphicsConfiguration);
            boolean bl = false;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                return false;
            }
            this.validatedContents = true;
            return bl;
        }

        public void show() {
            this.flip(this.caps.getFlipContents());
        }

        protected FlipBufferStrategy(int n, BufferCapabilities bufferCapabilities) throws AWTException {
            this.caps = bufferCapabilities;
            this.width = Component.this.getWidth();
            this.height = Component.this.getHeight();
            if (n > 1) {
                this.createBuffers(n, bufferCapabilities);
            } else {
                this.drawVBuffer = Component.this.peer.createVolatileImage(this.width, this.height);
                this.drawBuffer = this.drawVBuffer;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class BltBufferStrategy
    extends BufferStrategy {
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;
        private VolatileImage frontBuffer;

        protected void createBackBuffers(int n) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.backBuffers = new VolatileImage[n];
            int n2 = 0;
            while (n2 < n) {
                this.backBuffers[n2] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
                ++n2;
            }
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.backBuffers[0].getGraphics();
        }

        public void show() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Component.this.getGraphics().drawImage(this.backBuffers[this.backBuffers.length - 1], this.width, this.height, null);
            BufferCapabilities.FlipContents flipContents = this.getCapabilities().getFlipContents();
            int n = this.backBuffers.length - 1;
            while (n > 0) {
                this.backBuffers[n] = this.backBuffers[n - 1];
                --n;
            }
            if (flipContents == BufferCapabilities.FlipContents.UNDEFINED) {
                this.backBuffers[0] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
            }
            if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
                this.backBuffers[0] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
                this.backBuffers[0].getGraphics().clearRect(0, 0, this.width, this.height);
            }
            if (flipContents == BufferCapabilities.FlipContents.COPIED) {
                this.backBuffers[0] = this.backBuffers[this.backBuffers.length - 1];
            }
        }

        protected void revalidate() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int n = 0;
            while (n < this.backBuffers.length) {
                int n2 = this.backBuffers[n].validate(graphicsConfiguration);
                if (n2 == 2) {
                    this.backBuffers[n] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
                }
                ++n;
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            int n = 0;
            while (n < this.backBuffers.length) {
                if (this.backBuffers[n].contentsLost()) {
                    this.validatedContents = false;
                    return true;
                }
                ++n;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            boolean bl = false;
            int n = 0;
            while (n < this.backBuffers.length) {
                int n2 = this.backBuffers[n].validate(graphicsConfiguration);
                if (n2 == 1) {
                    bl = true;
                } else if (n2 == 2) {
                    return false;
                }
                ++n;
            }
            this.validatedContents = true;
            return bl;
        }

        protected BltBufferStrategy(int n, BufferCapabilities bufferCapabilities) {
            this.caps = bufferCapabilities;
            this.createBackBuffers(n - 1);
            this.width = Component.this.getWidth();
            this.height = Component.this.getHeight();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        private static final long serialVersionUID = 642321655757800191L;
        protected ComponentListener accessibleAWTComponentHandler;
        protected FocusListener accessibleAWTFocusHandler;

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            Component.this.addPropertyChangeListener(propertyChangeListener);
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            Component.this.removePropertyChangeListener(propertyChangeListener);
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public String getAccessibleName() {
            return this.accessibleName == null ? Component.this.getName() : this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (Component.this.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (Component.this.isFocusable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (Component.this.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (Component.this.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            if (Component.this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (Component.this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null) {
                Container container = Component.this.getParent();
                this.accessibleParent = container instanceof Accessible ? (Accessible)((Object)container) : null;
            }
            return this.accessibleParent;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() == null) {
                return -1;
            }
            AccessibleContext accessibleContext = ((Component)((Object)this.accessibleParent)).getAccessibleContext();
            if (accessibleContext == null) {
                return -1;
            }
            int n = accessibleContext.getAccessibleChildrenCount();
            while (--n >= 0) {
                if (accessibleContext.getAccessibleChild(n) != Component.this) continue;
                return n;
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() {
            return Component.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Component.this.getBackground();
        }

        public void setBackground(Color color) {
            Component.this.setBackground(color);
        }

        public Color getForeground() {
            return Component.this.getForeground();
        }

        public void setForeground(Color color) {
            Component.this.setForeground(color);
        }

        public Cursor getCursor() {
            return Component.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Component.this.setCursor(cursor);
        }

        public Font getFont() {
            return Component.this.getFont();
        }

        public void setFont(Font font) {
            Component.this.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return Component.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            Component.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean bl) {
            Component.this.setVisible(bl);
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(Point point) {
            return Component.this.contains(point.x, point.y);
        }

        public Point getLocationOnScreen() {
            return Component.this.isShowing() ? Component.this.getLocationOnScreen() : null;
        }

        public Point getLocation() {
            return Component.this.isShowing() ? Component.this.getLocation() : null;
        }

        public void setLocation(Point point) {
            Component.this.setLocation(point.x, point.y);
        }

        public Rectangle getBounds() {
            return Component.this.isShowing() ? Component.this.getBounds() : null;
        }

        public void setBounds(Rectangle rectangle) {
            Component.this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Dimension getSize() {
            return Component.this.isShowing() ? Component.this.getSize() : null;
        }

        public void setSize(Dimension dimension) {
            Component.this.setSize(dimension.width, dimension.height);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusTraversable();
        }

        public void requestFocus() {
            Component.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            Component.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            Component.this.removeFocusListener(focusListener);
        }

        private final /* synthetic */ void this() {
            this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler();
            this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler();
        }

        protected AccessibleAWTComponent() {
            this.this();
            Component.this.addComponentListener(this.accessibleAWTComponentHandler);
            Component.this.addFocusListener(this.accessibleAWTFocusHandler);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            protected AccessibleAWTComponentHandler() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            public void focusGained(FocusEvent focusEvent) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent focusEvent) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }

            protected AccessibleAWTFocusHandler() {
            }
        }
    }
}

