/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DateTimeType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void checkValue(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            block37: {
                char c;
                block36: {
                    c = string.charAt(n4);
                    if (c != '-' || n4 != 0) break block36;
                    ++n3;
                    break block37;
                }
                if (c >= '0' && c <= '9') break block37;
                switch (n2) {
                    case 0: {
                        if (c != '-') throw new DatatypeException(n4, "invalid dateTime value");
                        String string2 = string.substring(n3, n4);
                        if ("0000".equals(string2) || string2.length() < 4) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 1;
                        n3 = n4 + 1;
                        break;
                    }
                    case 1: {
                        if (c != '-') throw new DatatypeException(n4, "invalid dateTime value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 2;
                        n3 = n4 + 1;
                        break;
                    }
                    case 2: {
                        if (c != 'T') throw new DatatypeException(n4, "invalid dateTime value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 3;
                        n3 = n4 + 1;
                        break;
                    }
                    case 3: {
                        if (c != ':') throw new DatatypeException(n4, "invalid dateTime value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 4;
                        n3 = n4 + 1;
                        break;
                    }
                    case 4: {
                        if (c != ':') throw new DatatypeException(n4, "invalid dateTime value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 5;
                        n3 = n4 + 1;
                        break;
                    }
                    case 5: {
                        if (c == '.') {
                            if (n4 - n3 != 2) {
                                throw new DatatypeException(n4, "invalid dateTime value");
                            }
                            n2 = 6;
                            n3 = n4 + 1;
                            break;
                        }
                        if (c != ' ') throw new DatatypeException(n4, "invalid dateTime value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 7;
                        n3 = n4 + 1;
                        break;
                    }
                    case 6: {
                        if (c != ' ') throw new DatatypeException(n4, "invalid dateTime value");
                        n2 = 7;
                        n3 = n4 + 1;
                        break;
                    }
                    case 7: {
                        if (n3 == n4) {
                            if (c == '+' || c == '-') break;
                            if (c == 'Z') {
                                n2 = 9;
                                n3 = n4 + 1;
                                break;
                            }
                        }
                        if (c != ':') throw new DatatypeException(n4, "invalid dateTime value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid dateTime value");
                        }
                        n2 = 8;
                        n3 = n4 + 1;
                        break;
                    }
                    default: {
                        throw new DatatypeException(n4, "invalid dateTime value");
                    }
                }
            }
            ++n4;
        }
        switch (n2) {
            case 5: {
                if (n - n3 == 2) return;
                throw new DatatypeException(n, "invalid dateTime value");
            }
            case 6: {
                return;
            }
            case 8: {
                if (n - n3 == 2) return;
                throw new DatatypeException(n, "invalid dateTime value");
            }
            case 9: {
                return;
            }
            default: {
                throw new DatatypeException(n, "invalid dateTime value");
            }
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            int n4;
            int n5 = 0;
            while (n5 < n) {
                n4 = string.charAt(n5);
                if (n4 == 45 && n5 == 0) {
                    ++n3;
                } else if (n4 < 48 || n4 > 57) {
                    switch (n2) {
                        case 0: {
                            if (n4 != 45) break;
                            gregorianCalendar.set(1, Integer.parseInt(string.substring(0, n5)));
                            n2 = 1;
                            n3 = n5 + 1;
                            break;
                        }
                        case 1: {
                            if (n4 != 45) break;
                            gregorianCalendar.set(2, Integer.parseInt(string.substring(n3, n5)));
                            n2 = 2;
                            n3 = n5 + 1;
                            break;
                        }
                        case 2: {
                            if (n4 != 84) break;
                            gregorianCalendar.set(5, Integer.parseInt(string.substring(n3, n5)));
                            n2 = 3;
                            n3 = n5 + 1;
                            break;
                        }
                        case 3: {
                            if (n4 != 58) break;
                            gregorianCalendar.set(10, Integer.parseInt(string.substring(n3, n5)));
                            n2 = 4;
                            n3 = n5 + 1;
                            break;
                        }
                        case 4: {
                            if (n4 != 58) break;
                            gregorianCalendar.set(12, Integer.parseInt(string.substring(n3, n5)));
                            n2 = 5;
                            n3 = n5 + 1;
                            break;
                        }
                        case 5: {
                            if (n4 != 32) break;
                            float f = Float.parseFloat(string.substring(n3, n5));
                            gregorianCalendar.set(13, (int)f);
                            n2 = 7;
                            n3 = n5 + 1;
                            break;
                        }
                    }
                }
                ++n5;
            }
            if (n - n3 > 0 && n2 == 7) {
                String string2 = string.substring(n - n3);
                n4 = string2.indexOf(58);
                if (n4 == -1) {
                    TimeZone timeZone;
                    if ("Z".equals(string2)) {
                        string2 = "UTC";
                    }
                    if ((timeZone = TimeZone.getTimeZone(string2)) == null) {
                        return null;
                    }
                    gregorianCalendar.set(15, timeZone.getRawOffset());
                } else {
                    String string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    int n6 = Integer.parseInt(string3) * 360000;
                    n6 = n6 < 0 ? (n6 -= Integer.parseInt(string4) * 60000) : (n6 += Integer.parseInt(string4) * 60000);
                    gregorianCalendar.set(15, n6);
                }
            }
            return gregorianCalendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    DateTimeType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), TypeLibrary.ANY_SIMPLE_TYPE);
    }
}

