/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.Registry;
import gnu.javax.crypto.key.dh.DHKeyPairRawCodec;
import gnu.javax.crypto.key.dh.DHKeyPairX509Codec;
import gnu.javax.crypto.key.dh.GnuDHKey;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;

public class GnuDHPublicKey
extends GnuDHKey
implements DHPublicKey {
    private BigInteger y;

    public static GnuDHPublicKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_DH_PUBLIC_KEY[0]) {
            try {
                return (GnuDHPublicKey)new DHKeyPairRawCodec().decodePublicKey(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (GnuDHPublicKey)new DHKeyPairX509Codec().decodePublicKey(byArray);
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new DHKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            case 2: {
                byArray = new DHKeyPairX509Codec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + n);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DHPublicKey)) {
            return false;
        }
        DHPublicKey dHPublicKey = (DHPublicKey)object;
        boolean bl = false;
        if (super.equals(dHPublicKey) && this.y.equals(dHPublicKey.getY())) {
            bl = true;
        }
        return bl;
    }

    public GnuDHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(1, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public GnuDHPublicKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(n == 4 ? 2 : n, bigInteger, bigInteger2, bigInteger3);
        this.y = bigInteger4;
    }
}

