/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StackFrameCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        boolean bl = true;
        try {
            switch (by) {
                case 1: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeThisObject(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executePopFrames(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Stack Frame Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId.getObject();
        VMFrame vMFrame = VMVirtualMachine.getFrame(thread, byteBuffer);
        int n = byteBuffer.getInt();
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            Object object = vMFrame.getValue(n3);
            Value.writeTaggedValue(dataOutputStream, object);
            ++n2;
        }
    }

    private final void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId.getObject();
        VMFrame vMFrame = VMVirtualMachine.getFrame(thread, byteBuffer);
        int n = byteBuffer.getInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteBuffer.getInt();
            Object object = Value.getObj(byteBuffer);
            vMFrame.setValue(n3, object);
            ++n2;
        }
    }

    private final void executeThisObject(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId.getObject();
        VMFrame vMFrame = VMVirtualMachine.getFrame(thread, byteBuffer);
        Object object = vMFrame.getObject();
        Value.writeTaggedValue(dataOutputStream, object);
    }

    private final void executePopFrames(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command PopFrames not implemented.");
    }
}

