/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Util {
    private String bootclasspath;
    private String classpath = System.getProperty("java.class.path");
    private String userclasspath;

    public InputStream findClass(String string) throws ClassNotFoundException {
        InputStream inputStream = null;
        String string2 = this.getFileNameFromClassName(string);
        if (this.userclasspath != null) {
            String string3 = this.getSearchPath();
            inputStream = this.findClass(string2, string3);
        } else {
            inputStream = this.findFile(string2);
            if (inputStream == null) {
                String string4 = this.getSearchPath();
                inputStream = this.findClass(string2, string4);
            }
        }
        if (inputStream != null) {
            return inputStream;
        }
        throw new ClassNotFoundException(string + " not found");
    }

    private final InputStream findClass(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            Closeable closeable;
            String string3 = stringTokenizer.nextToken();
            File file = new File(string3);
            if (file.exists() && file.isDirectory()) {
                if (!(file = new File(file, string)).exists()) continue;
                try {
                    closeable = new FileInputStream(file);
                    return new BufferedInputStream((InputStream)closeable);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
            }
            if (!file.exists() || !file.isFile()) continue;
            try {
                closeable = new ZipFile(file);
                ZipEntry zipEntry = ((ZipFile)closeable).getEntry(string);
                if (zipEntry == null) continue;
                return ((ZipFile)closeable).getInputStream(zipEntry);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private final InputStream findFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                return new BufferedInputStream(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    private final String getFileNameFromClassName(String string) {
        File file = new File(string);
        if (file.exists()) {
            return string;
        }
        String string2 = string.replace('.', '/');
        string2 = string2 + ".class";
        return string2;
    }

    public void setClasspath(String string) {
        this.userclasspath = string;
    }

    public String getSearchPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.userclasspath != null) {
            stringBuffer.append(this.userclasspath);
        } else {
            if (this.bootclasspath != null) {
                stringBuffer.append(this.bootclasspath);
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(this.classpath);
        }
        return stringBuffer.toString();
    }

    public Util() {
        this.bootclasspath = System.getProperty("sun.boot.class.path");
    }
}

