// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLITEM_H
#define _GTKMM_TOOLITEM_H


#include <glibmm.h>

/* $Id: toolitem.hg,v 1.14 2006/04/12 11:11:25 murrayc Exp $ */

/* box.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>
#include <gtkmm/tooltips.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToolItem GtkToolItem;
typedef struct _GtkToolItemClass GtkToolItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ToolItem_Class; } // namespace Gtk
namespace Gtk
{

/** 
 *
 * @ingroup Widgets
 */

class ToolItem : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ToolItem CppObjectType;
  typedef ToolItem_Class CppClassType;
  typedef GtkToolItem BaseObjectType;
  typedef GtkToolItemClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ToolItem();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ToolItem_Class;
  static CppClassType toolitem_class_;

  // noncopyable
  ToolItem(const ToolItem&);
  ToolItem& operator=(const ToolItem&);

protected:
  explicit ToolItem(const Glib::ConstructParams& construct_params);
  explicit ToolItem(GtkToolItem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkToolItem*       gobj()       { return reinterpret_cast<GtkToolItem*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkToolItem* gobj() const { return reinterpret_cast<GtkToolItem*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_create_menu_proxy();
  virtual void on_toolbar_reconfigured();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  ToolItem();

  
  /** Sets whether @a tool_item  is to be allocated the same size as other
   * homogeneous items. The effect is that all homogeneous items will have
   * the same width as the widest of the items.
   * 
   * @newin2p4
   * @param homogeneous Whether @a tool_item  is the same size as other homogeneous items.
   */
  void set_homogeneous(bool homogeneous = true);
  
  /** Return value: <tt>true</tt> if the item is the same size as other homogeneous
   * @return <tt>true</tt> if the item is the same size as other homogeneous
   * item.s
   * 
   * @newin2p4.
   */
  bool get_homogeneous() const;

  
  /** Sets whether @a tool_item  is allocated extra space when there
   * is more room on the toolbar then needed for the items. The
   * effect is that the item gets bigger when the toolbar gets bigger
   * and smaller when the toolbar gets smaller.
   * 
   * @newin2p4
   * @param expand Whether @a tool_item  is allocated extra space.
   */
  void set_expand(bool expand = true);
  
  /** Return value: <tt>true</tt> if @a tool_item  is allocated extra space.
   * @return <tt>true</tt> if @a tool_item  is allocated extra space.
   * 
   * @newin2p4.
   */
  bool get_expand() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets the Gtk::Tooltips object to be used for @a tool_item , the
   * text to be displayed as tooltip on the item and the private text
   * to be used. See Gtk::Tooltips::set_tip().
   * 
   * @newin2p4
   * 
   * Deprecated: 2.12: Use set_tooltip_text() instead.
   * @deprecated Use set_tooltip_text() or set_tooltip_markup() instead
   * @param tooltips The Gtk::Tooltips object to be used.
   * @param tip_text Text to be used as tooltip text for @a tool_item .
   * @param tip_private Text to be used as private tooltip text.
   */
  void set_tooltip(Tooltips& tooltips, const Glib::ustring& tip_text, const Glib::ustring& tip_private = Glib::ustring());
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets the text to be displayed as tooltip on the item.
   * See Gtk::Widget::set_tooltip_text().
   * 
   * @newin2p12
   * @param text Text to be used as tooltip for @a tool_item .
   */
  void set_tooltip_text(const Glib::ustring& text);
  
  /** Sets the markup text to be displayed as tooltip on the item.
   * See Gtk::Widget::set_tooltip_markup().
   * 
   * @newin2p12
   * @param markup Markup text to be used as tooltip for @a tool_item .
   */
  void set_tooltip_markup(const Glib::ustring& markup);
  
  
  /** Sets whether @a tool_item  has a drag window. When <tt>true</tt> the
   * toolitem can be used as a drag source through gtk_drag_source_set().
   * When @a tool_item  has a drag window it will intercept all events,
   * even those that would otherwise be sent to a child of @a tool_item .
   * 
   * @newin2p4
   * @param use_drag_window Whether @a tool_item  has a drag window.
   */
  void set_use_drag_window(bool use_drag_window = true);
  
  /** Return value: <tt>true</tt> if @a tool_item  uses a drag window.
   * @return <tt>true</tt> if @a tool_item  uses a drag window.
   * 
   * @newin2p4.
   */
  bool get_use_drag_window() const;

  
  /** Sets whether @a tool_item  is visible when the toolbar is docked horizontally.
   * 
   * @newin2p4
   * @param visible_horizontal Whether @a tool_item  is visible when in horizontal mode.
   */
  void set_visible_horizontal(bool visible_horizontal = true);
  
  /** Return value: <tt>true</tt> if @a tool_item  is visible on toolbars that are
   * @return <tt>true</tt> if @a tool_item  is visible on toolbars that are
   * docked horizontally.
   * 
   * @newin2p4.
   */
  bool get_visible_horizontal() const;

  
  /** Sets whether @a tool_item  is visible when the toolbar is docked
   * vertically. Some tool items, such as text entries, are too wide to be
   * useful on a vertically docked toolbar. If @a visible_vertical  is <tt>false</tt>
   *  @a tool_item  will not appear on toolbars that are docked vertically.
   * 
   * @newin2p4
   * @param visible_vertical Whether @a tool_item  is visible when the toolbar
   * is in vertical mode.
   */
  void set_visible_vertical(bool visible_vertical = true);
  
  /** Return value: Whether @a tool_item  is visible when the toolbar is docked vertically
   * @return Whether @a tool_item  is visible when the toolbar is docked vertically
   * 
   * @newin2p4.
   */
  bool get_visible_vertical() const;

  
  /** Return value: <tt>true</tt> if @a tool_item  is considered important.
   * @return <tt>true</tt> if @a tool_item  is considered important.
   * 
   * @newin2p4.
   */
  bool get_is_important() const;
  
  /** Sets whether @a tool_item  should be considered important. The Gtk::ToolButton
   * class uses this property to determine whether to show or hide its label
   * when the toolbar style is Gtk::TOOLBAR_BOTH_HORIZ. The result is that
   * only tool buttons with the "is_important" property set have labels, an
   * effect known as "priority text"
   * 
   * @newin2p4
   * @param is_important Whether the tool item should be considered important.
   */
  void set_is_important(bool is_important = true);

  
  /** Return value: a Gtk::IconSize indicating the icon size used for @a tool_item 
   * @return A Gtk::IconSize indicating the icon size used for @a tool_item 
   * 
   * @newin2p4.
   */
  IconSize get_icon_size () const;
  
  /** Return value: a Gtk::Orientation indicating the orientation
   * @return A Gtk::Orientation indicating the orientation
   * used for @a tool_item 
   * 
   * @newin2p4.
   */
  Orientation get_orientation() const;
  
  /** Return value: A Gtk::ToolbarStyle indicating the toolbar style used
   * @return A Gtk::ToolbarStyle indicating the toolbar style used
   * for @a tool_item .
   * 
   * @newin2p4.
   */
  ToolbarStyle get_toolbar_style() const;
  
  /** Return value: a Gtk::ReliefStyle indicating the relief style used
   * @return A Gtk::ReliefStyle indicating the relief style used
   * for @a tool_item .
   * 
   * @newin2p4.
   */
  ReliefStyle get_relief_style() const;

  
  /** Return value: The Gtk::MenuItem that is going to appear in the
   * @return The Gtk::MenuItem that is going to appear in the
   * overflow menu for @a tool_item .
   * 
   * @newin2p4.
   */
  Widget* retrieve_proxy_menu_item();
  
  /** Return value: The Gtk::MenuItem that is going to appear in the
   * @return The Gtk::MenuItem that is going to appear in the
   * overflow menu for @a tool_item .
   * 
   * @newin2p4.
   */
  const Widget* retrieve_proxy_menu_item() const;
  
  /** If @a menu_item_id  matches the string passed to
   * set_proxy_menu_item() return the corresponding Gtk::MenuItem.
   * 
   * Custom subclasses of Gtk::ToolItem should use this function to update
   * their menu item when the Gtk::ToolItem changes. That the
   *  @a menu_item_id &lt;!-- --&gt;s must match ensures that a Gtk::ToolItem will not
   * inadvertently change a menu item that they did not create.
   * @param menu_item_id A string used to identify the menu item.
   * @return The Gtk::MenuItem passed to
   * set_proxy_menu_item(), if the @a menu_item_id &lt;!-- --&gt;s match.
   * 
   * @newin2p4.
   */
  Widget* get_proxy_menu_item(const Glib::ustring& menu_item_id);
  
  /** If @a menu_item_id  matches the string passed to
   * set_proxy_menu_item() return the corresponding Gtk::MenuItem.
   * 
   * Custom subclasses of Gtk::ToolItem should use this function to update
   * their menu item when the Gtk::ToolItem changes. That the
   *  @a menu_item_id &lt;!-- --&gt;s must match ensures that a Gtk::ToolItem will not
   * inadvertently change a menu item that they did not create.
   * @param menu_item_id A string used to identify the menu item.
   * @return The Gtk::MenuItem passed to
   * set_proxy_menu_item(), if the @a menu_item_id &lt;!-- --&gt;s match.
   * 
   * @newin2p4.
   */
  const Widget* get_proxy_menu_item(const Glib::ustring& menu_item_id) const;
  
  /** Sets the Gtk::MenuItem used in the toolbar overflow menu. The
   *  @a menu_item_id  is used to identify the caller of this function and
   * should also be used with get_proxy_menu_item().
   * 
   * @newin2p4
   * @param menu_item_id A string used to identify @a menu_item .
   * @param menu_item A Gtk::MenuItem to be used in the overflow menu.
   */
  void set_proxy_menu_item(const Glib::ustring& menu_item_id, Widget& menu_item);

  
  /** Calling this function signals to the toolbar that the
   * overflow menu item for @a tool_item  has changed. If the
   * overflow menu is visible when this function it called,
   * the menu will be rebuilt.
   * 
   * The function must be called when the tool item
   * changes what it will do in response to the "create_menu_proxy"
   * signal.
   * 
   * @newin2p6
   */
  void rebuild_menu();
  
  //TODO: This suggests calling set_proxy_menu_item() with NULL. but the function asserts against that.
  /** This signal is emitted when the toolbar needs information from @tool_item
   * about whether the item should appear in the toolbar overflow menu. In
   * response the tool item should either
   * <itemizedlist>
   * <listitem> call set_proxy_menu_item() with a NULL
   * pointer and return true to indicate that the item should not appear
   * in the overflow menu
   * </listitem>
   * <listitem> call set_proxy_menu_item() with a new menu
   * item and return true, or 
   * </listitem>
   * <listitem> return false to indicate that the signal was not
   * handled by the item. This means that
   * the item will not appear in the overflow menu unless a later handler
   * installs a menu item.
   * </listitem>
   * </itemizedlist>
   *
   * The toolbar may cache the result of this signal. When the tool item changes
   * how it will respond to this signal it must call rebuild_menu()
   * to invalidate the cache and ensure that the toolbar rebuilds its overflow
   * menu.
   *
   * @result true if the signal was handled, false if not
   *
   * @par Prototype:
   * <tt>bool on_my_%create_menu_proxy()</tt>
   */

  Glib::SignalProxy0< bool > signal_create_menu_proxy();

  
  /** This signal is emitted when some property of the toolbar that the
   * item is a child of changes. For custom subclasses of ToolItem,
   * the default handler of this signal use the functions
   * <itemizedlist>
   * <listitem>Toolbar::get_orientation()</listitem>
   * <listitem>Toolbar::get_style()</listitem>
   * <listitem>Toolbar::get_icon_size()</listitem>
   * <listitem>Toolbar::get_relief_style()</listitem>
   * </itemizedlist>
   * to find out what the toolbar should look like and change
   * themselves accordingly.
   *
   * @par Prototype:
   * <tt>void on_my_%toolbar_reconfigured()</tt>
   */

  Glib::SignalProxy0< void > signal_toolbar_reconfigured();


  //We use no_default_handler for this, because we can not add a new vfunc to 2.5 without breaking ABI.

  #ifndef GTKMM_DISABLE_DEPRECATED
  //Note that we can ifdef this out, only because it doesn't affect class size, because we use no_default_handler:
  /** This signal is emitted when the toolitem's tooltip changes.
   * Application developers can use gtk_tool_item_set_tooltip() to
   * set the item's tooltip.
   * @deprecated: Use the new Gtk::Tooltip API. This signal will now never be emitted.
   *
   * @param tooltips the Tooltips
   * @param tip_text the tooltip text
   * @param tip_private the tooltip private text
   * @result true if the signal was handled, false if not.
   */
  Glib::SignalProxy3< bool,Tooltips*,const Glib::ustring&,const Glib::ustring& > signal_set_tooltip();
  //_WRAP_SIGNAL(bool set_tooltip(Tooltips* tooltips, const Glib::ustring& tip_text, const Glib::ustring& tip_private), set_tooltip, no_default_handler, deprecated) //TODO: Implement deprecated for _WRAP_SIGNAL() to avoid hand-coding this:
  #endif //GTKMM_DISABLE_DEPRECATED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_horizontal() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_horizontal() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a vertical orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_vertical() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a vertical orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_vertical() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is considered important. When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_is_important() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is considered important. When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_important() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ToolItem
   */
  Gtk::ToolItem* wrap(GtkToolItem* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TOOLITEM_H */

