/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.utils;

import java.awt.geom.Point2D;

public abstract class MathExtensions {
    public static double sgn(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double abs(Point2D.Double double_) {
        return Math.sqrt(MathExtensions.getTransposed(double_, double_));
    }

    public static double abs(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static double angleBetween(Point2D.Double double_, Point2D.Double double_2) {
        double d;
        double d2;
        double d3 = MathExtensions.getTransposed(double_, double_2);
        double d4 = d3 / ((d2 = Math.sqrt(MathExtensions.getTransposed(double_, double_))) * (d = Math.sqrt(MathExtensions.getTransposed(double_2, double_2))));
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        if (d4 < -1.0) {
            d4 = -1.0;
        }
        return Math.acos(d4);
    }

    public static double getTransposed(Point2D.Double double_, Point2D.Double double_2) {
        return double_.getX() * double_2.getX() + double_.getY() * double_2.getY();
    }

    public static double getEuclideanDistance(Point2D.Double double_, Point2D.Double double_2) {
        return Math.sqrt((double_.x - double_2.x) * (double_.x - double_2.x) + (double_.y - double_2.y) * (double_.y - double_2.y));
    }

    public static Point2D.Double getNormalizedVector(Point2D.Double double_) {
        double d = MathExtensions.abs(double_);
        return new Point2D.Double(double_.x / d, double_.y / d);
    }
}

