/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.util.ServerInfo;

public class StandardEngine
extends ContainerBase
implements Engine {
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private String mapperClass = "org.apache.catalina.core.StandardEngineMapper";
    private Service service = null;
    private DefaultContext defaultContext;
    private String jvmRouteId;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host.toLowerCase();
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    public void setJvmRoute(String routeId) {
        this.log("setJvmRoute=" + routeId);
        this.jvmRouteId = routeId;
    }

    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String mapperClass) {
        String oldMapperClass = this.mapperClass;
        this.mapperClass = mapperClass;
        this.support.firePropertyChange("mapperClass", oldMapperClass, this.mapperClass);
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void installDefaultContext(Context context) {
        if (this.defaultContext != null && this.defaultContext instanceof StandardDefaultContext) {
            ((StandardDefaultContext)this.defaultContext).installDefaultContext(context);
        }
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    public String getInfo() {
        return info;
    }

    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    public void start() throws LifecycleException {
        System.out.println(ServerInfo.getServerInfo());
        super.start();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void addDefaultMapper(String mapperClass) {
        super.addDefaultMapper(this.mapperClass);
    }
}

