# telepathy-butterfly - an MSN connection manager for Telepathy
#
# Copyright (C) 2006 Ali Sabil <ali.sabil@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import telepathy
import time
import pymsn

class MsnTextConversation(telepathy.server.ChannelTypeText, \
        telepathy.server.ChannelInterfaceGroup):

    def __init__(self, conn, invitee, server=None, key="", session=""):
        self._recv_id = 0
        telepathy.server.ChannelTypeText.__init__(self, conn, None)
        telepathy.server.ChannelInterfaceGroup.__init__(self)
        self.GroupFlagsChanged(telepathy.CHANNEL_GROUP_FLAG_CAN_ADD, 0)
        #HACK: problem with metaclasses, waiting for pymsn to be fixed
        self.switchboard_client = pymsn.Conversation(conn, invitee, server, key, session)
        self.switchboard_client.on_message_received = self.on_message_received
        self.switchboard_client.on_user_joined = self.on_user_joined
        self.switchboard_client.on_user_left = self.on_user_left

    def on_message_received(self, switchboard, message):
        id = self._recv_id
        timestamp = int(time.time())
        sender = self._conn._get_handle_for_contact(message.passport)
        type = telepathy.CHANNEL_TEXT_MESSAGE_TYPE_NORMAL
        text = unicode(message.body, message.content_type[1])

        self.Received(id, timestamp, sender, type, 0, text)
        self._recv_id += 1

    def on_user_joined(self, switchboard, contact):
        print "user joined : ", contact.get_property("passport")
        user_handle = self._conn._get_handle_for_contact(contact.get_property("passport"))
        self.MembersChanged('', [user_handle], [], [], [],
                user_handle, telepathy.CHANNEL_GROUP_CHANGE_REASON_INVITED)

    def on_user_left(self, switchboard, contact):
        if len(switchboard.users) == 1: # last user is sticky
            return
        user_handle = self._conn._get_handle_for_contact(contact.get_property("passport"))
        self.MembersChanged('', [], [user_handle], [], [],
                user_handle, telepathy.CHANNEL_GROUP_CHANGE_REASON_NONE)

    def Send(self, message_type, text):
        if message_type != telepathy.CHANNEL_TEXT_MESSAGE_TYPE_NORMAL:
            raise telepathy.NotImplemented('only the normal message type is currently supported')
        self.switchboard_client.send_text_message(text)
        self.Sent(int(time.time()), message_type, text) #:TODO: handle this better, making use of ack

    def Close(self):
        self.switchboard_client.leave_conversation()
        telepathy.server.ChannelTypeText.Close(self)
