'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.8/tcllib-1.8/modules/doctools/doctoc_fmt.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2003-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "doctoc_fmt" n 1.0 doctools "Documentation tools"
.BS
.SH "NAME"
doctoc_fmt \- Specification of a simple Tcl Markup Language for Tables of Contents
.SH "SYNOPSIS"
\fBcomment\fR \fItext\fR
.sp
\fBinclude\fR \fIfilename\fR
.sp
\fBvset\fR \fIvarname\fR \fIvalue\fR
.sp
\fBvset\fR \fIvarname\fR
.sp
\fBlb\fR
.sp
\fBrb\fR
.sp
\fBtoc_begin\fR \fItext\fR \fItitle\fR
.sp
\fBtoc_end\fR
.sp
\fBdivision_start\fR \fItext\fR ?\fIsymfile\fR?
.sp
\fBdivision_end\fR
.sp
\fBitem\fR \fIfile\fR \fItext\fR \fIdesc\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This document specifies version 1 of a text format for tables of
contents. The name of this format is \fIdoctoc\fR and it provides all
the necessary commands to write a table of contents for a group of
documents.
It is intended to complement both the \fIdoctools\fR format for
writing documentation and the \fIdocidx\fR format for writing keyword
indices.
The formal specifications for these two formats can be found in the
companion documents \fIdoctools_fmt\fR and \fIdocidx_fmt\fR.
A third companion document describes the package
\fBdoctools::toc\fR, which provides commands for the processing of
text in \fIdoctoc\fR format.
.PP
Like for the formats \fIdoctools\fR and \fIdocidx\fR a generic
framework for the conversion of \fIdoctoc\fR to any number of
different output formats is provided.
This framework is provided by the package \fBdoctools::toc\fR.
.PP
Anyone who wishes to write a toc formatting engine which plugs into
this framework has to read the document \fIdoctoc_api\fR. This is the
formal specification of the API between the framework and its engines.
.SH "FORMAT SPECIFICATION"
.SS "OVERVIEW"
While \fIdoctools\fR is similar to LaTeX \fIdoctoc\fR is only
superficially so. Input written in this format consists of a series of
markup commands, which may be separated by whitespace. Other text is
not allowed. The best comparison would be to imagine a LaTeX document
with all regular text removed.
.PP
The format used to mark commands is different from LaTeX however. All
text between matching pairs of [ and ] is a command, possibly
with arguments. Note that both brackets have to be on the same line
for a command to be recognized.
.SS "GRAMMAR"
The overall syntax of a table of contents is best captured in a formal
context-free grammar. Our notation for the grammar is EBNF. Strings
will stand for markup commands, however their arguments (if they have
any) are not part of the grammar. Our grammar contains lexical
elements as well.
.PP
First we specify the whitespace at the lexical level, which also
includes comments.
.PP
.nf

    COMMENT  ::= "comment"
    WHITE    ::= { '\\n' | '\\t' | ' ' | '\\r' | COMMENT }

.fi
.PP
Then we define rules for all the keywords. Here we introduce our
knowledge that all commands can be separated by whitespace, and also
that the inclusion of other files may happen essentially everywhere,
like the definition of document variables. The content of any included
file has to fit into the including file according to the location in
the grammar the inclusion is at.
.PP
.nf

    BEGIN     ::= "toc_begin"      WHITE DEFUN
    END       ::= "toc_end"        WHITE
    DIV_START ::= "division_start" WHITE DEFUN
    DIV_END   ::= "division_end"   WHITE DEFUN
    ITEM      ::= "item"           WHITE DEFUN

    INCLUDE  ::= "include"         WHITE
    VSET     ::= "vset"            WHITE

    DEFUN    ::= { INCLUDE | VSET }

.fi
.PP
At last we can specify the whole table of contents.
.PP
.nf

    TOC      ::= DEFUN BEGIN CONTENTS END

    CONTENTS ::= (ITEMS | SECTIONS)
    ITEMS    ::= ITEM { ITEM }
    SECTIONS ::= SECTION { SECTION }
    SECTION  ::= DIV_START CONTENTS DIV_END

.fi
.SS "COMMANDS"
Here we specify the commands used in the grammar. Some commands
specified here were not used in the grammar at all. The usage of these
commands is confined to the arguments of other commands.
.TP
\fBcomment\fR \fItext\fR
This command declares that the argument \fItext\fR is a comment.
.TP
\fBinclude\fR \fIfilename\fR
This command loads the contents of the file \fIfilename\fR for
processing at its own place.
.TP
\fBvset\fR \fIvarname\fR \fIvalue\fR
This form of the command sets the document variable \fIvarname\fR to
the specified \fIvalue\fR. It does not generate output. It is this
form the grammar is refering to.
.TP
\fBvset\fR \fIvarname\fR
This form of the command returns the value associated with the
document variable \fIvarname\fR. This form is not used by the grammar
and restricted to usage in the arguments of other commands.
.TP
\fBlb\fR
This command adds a left bracket to the output. Its usage is
restricted to the arguments of other commands.
.TP
\fBrb\fR
This command adds a right bracket to the output. Its usage is
restricted to the arguments of other commands.
.TP
\fBtoc_begin\fR \fItext\fR \fItitle\fR
This is the command to start a table of contents.
.sp
The \fItext\fR argument provides a label for the whole group of
documents the index refers to. Often this is the name of the package
(or extension) the documents belong to.
The \fItitle\fR argument provides the overall title text for the index.
.TP
\fBtoc_end\fR
This is the command to close a table of contents.
.TP
\fBdivision_start\fR \fItext\fR ?\fIsymfile\fR?
This command opens a section in the table of contents.  Its
counterpart is \fBdivision_end\fR. Together they allow a user to give
a table of contents additional structure.
.sp
The title of the new section is provided by the argument \fItext\fR.
.sp
If the symbolic filename \fIsymfile\fR is present then the section
title should link to the referenced document, if links are supported
by the output format.
.TP
\fBdivision_end\fR
This command closes a section. See \fBdivision_start\fR above for the
detailed explanation.
.TP
\fBitem\fR \fIfile\fR \fItext\fR \fIdesc\fR
This command adds an individual element to the table of contents. Each
such element refers to a document. The document is specified through
the symbolic name \fIfile\fR. The \fItext\fR argument is used to label
the reference, whereas the \fIdesc\fR provides a short descriptive
text of that document.
.sp
The symbolic names are used to preserve the convertibility of this
format to any output format. The actual name of the file will be
inserted by the chosen formatting engine when converting the
input. This will be based on a mapping from symbolic to actual names
given to the engine.
.SH "NOTES"
It is possible to generate a table of contents in \fIdoctoc\fR format
automatically from a collection of documents in \fIdoctools\fR
format. All is needed is a special doctools formatting engine which
extracts the relevant metadata and some glue code to convert this data
to \fIdoctoc\fR.
.PP
The application \fBdtplite\fR is an example for this.
.SH "EXAMPLE"
The example is a table of contents for all manpages in the module
\fIbase64\fR.
.PP
.nf

[toc_begin Base64 {Table Of Contents}]
    [item base64.man   base64   {Procedures to encode and decode base64}
    [item uuencode.man uuencode {encode/decoding a binary file}]
    [item yencode.man  yencode  {encode/decoding a binary file}]
[toc_end]

.fi
.SH "SEE ALSO"
doctoc_api, doctoc_fmt, doctools::toc, doctools_fmt
.SH "KEYWORDS"
HTML, LaTeX, TMML, doctoc, documentation, generic markup, keywords, markup, nroff, table of contents, toc
.SH "COPYRIGHT"
.nf
Copyright (c) 2003-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi