'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.8/tcllib-1.8/modules/math/bigfloat.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004-2005 Stephane Arnold <stephanearnold at yahoo dot fr>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::bigfloat" n 1.2 math "Tcl Math Library"
.BS
.SH "NAME"
math::bigfloat \- Arbitrary precision floating-point numbers
.SH "SYNOPSIS"
package require \fBTcl  ?8.4?\fR
.sp
package require \fBmath::bignum  ?3.0?\fR
.sp
package require \fBmath::bigfloat  ?1.2?\fR
.sp
\fBfromstr\fR \fIstring\fR ?\fItrailingZeros\fR?
.sp
\fBfromstr\fR -base \fIradix\fR \fIstring\fR
.sp
\fBtostr\fR \fInumber\fR
.sp
\fBfromdouble\fR \fIdouble\fR ?\fIdecimals\fR?
.sp
\fBtodouble\fR \fInumber\fR
.sp
\fBisInt\fR \fInumber\fR
.sp
\fBisFloat\fR \fInumber\fR
.sp
\fBint2float\fR \fIinteger\fR ?\fIdecimals\fR?
.sp
\fBadd\fR \fIx\fR \fIy\fR
.sp
\fBsub\fR \fIx\fR \fIy\fR
.sp
\fBmul\fR \fIx\fR \fIy\fR
.sp
\fBdiv\fR \fIx\fR \fIy\fR
.sp
\fBmod\fR \fIx\fR \fIy\fR
.sp
\fBabs\fR \fIx\fR
.sp
\fBopp\fR \fIx\fR
.sp
\fBpow\fR \fIx\fR \fIn\fR
.sp
\fBiszero\fR \fIx\fR
.sp
\fBequal\fR \fIx\fR \fIy\fR
.sp
\fBcompare\fR \fIx\fR \fIy\fR
.sp
\fBsqrt\fR \fIx\fR
.sp
\fBlog\fR \fIx\fR
.sp
\fBexp\fR \fIx\fR
.sp
\fBcos\fR \fIx\fR
.sp
\fBsin\fR \fIx\fR
.sp
\fBtan\fR \fIx\fR
.sp
\fBcotan\fR \fIx\fR
.sp
\fBacos\fR \fIx\fR
.sp
\fBasin\fR \fIx\fR
.sp
\fBatan\fR \fIx\fR
.sp
\fBcosh\fR \fIx\fR
.sp
\fBsinh\fR \fIx\fR
.sp
\fBtanh\fR \fIx\fR
.sp
\fBpi\fR \fIn\fR
.sp
\fBrad2deg\fR \fIradians\fR
.sp
\fBdeg2rad\fR \fIdegrees\fR
.sp
\fBround\fR \fIx\fR
.sp
\fBceil\fR \fIx\fR
.sp
\fBfloor\fR \fIx\fR
.sp
.BE
.SH "DESCRIPTION"
The bigfloat package provides arbitrary precision floating-point math
capabilities to the Tcl language.
By convention, we will talk about the numbers treated in this library as :
.IP \(bu
BigFloat for floating-point numbers of arbitrary length
.IP \(bu
BigInt for arbitrary length signed integers (a.k.a. bignums)
BigFloats are internally represented at Tcl lists: this
package provides a set of procedures operating against
the internal representation in order to :
.IP \(bu
perform math operations on either BigFloats or BigInts.
.IP \(bu
convert BigFloats and BigInts from the internal representation to a string, and vice versa.
.SH "INTRODUCTION"
.TP
\fBfromstr\fR \fIstring\fR ?\fItrailingZeros\fR?
Converts \fIstring\fR into a BigFloat, or a BigInt. Its precision
is at least the number of digits provided by \fIstring\fR.
If the \fIstring\fR contains only digits and eventually a minus sign, it is considered as
an integer.
.sp
\fItrailingZeros\fR - the number of zeros to append at the end of the floating-point number
to get more precision from the \fIstring\fR. When applied on an integer, it throws an error.
.TP
\fBfromstr\fR -base \fIradix\fR \fIstring\fR
Converts \fIstring\fR representing an integer in the base \fIradix\fR, to a BigInt.
.nf

set x [fromstr -1.000000]
set y [fromstr 2000e30]
# x and y are BigFloats : the first string contained a dot, and the second an e sign
set m [fromstr 1000]
set n [fromstr -39]
# m and n are BigInts because the original string contained neither a dot nor an e sign
# negative BigInts are supported
set octalNumber [fromstr -base 8 377]
# the result is 377 in octal, so it is equal to 255

.fi
.sp
The \fIstring\fR's last digit is considered by the procedure to be true at +/-1.
For instance, the Pi constant is irrational, so as you feed in the string "3.1415"
it may be considered as a number in the interval [3.1414 , 3.1416].
This is why we call such mathematics \fIinterval computations\fR.
For example, 0.1 belongs to the interval [0.0, 0.2],
and 1.00 to the interval [0.99,1.01].So, when you mean 1.0, you may have to write 1.000000 to get enough precision.
If you encounter problems with precision, I recommend you read \fBPRECISION\fR.
.sp
For example :
.nf

set x [fromstr 1.0000000000]
# the next line does the same, but smarter
set y [fromstr 1. 10]
# the next line set a BigInt equal to 1
set n [fromstr 1]
# the next line raises an error : a single argument is required
# for strings to BigInts conversions
set n [fromstr 1 10]
# the next line is correct
set n [fromstr 1[string repeat 0 10]]

.fi
.TP
\fBtostr\fR \fInumber\fR
Returns a string form of a BigFloat, in which all digits are exacts,
or the string form of a BigInt if \fInumber\fR is not a BigFloat.
There is an issue with number equal to zero
(see section \fBPRECISION\fR) : even if the precision about 0 is
more than one digit, it will always be displayed as the '\fI0\fR' string.
.TP
\fBfromdouble\fR \fIdouble\fR ?\fIdecimals\fR?
Converts a double (a simple floating-point value) to a BigFloat, with
exactly \fIdecimals\fR digits.  Without the \fIdecimals\fR argument,
it behaves like \fIfromstr\fR.
.nf

tostr [fromstr 1.111 4]
# returns : 1.111000 (3 zeroes)
tostr [fromdouble 1.111 4]
# returns : 1.111

.fi
.TP
\fBtodouble\fR \fInumber\fR
Returns a double, that may be used in \fIexpr\fR,
from a BigFloat.
.TP
\fBisInt\fR \fInumber\fR
Returns 1 if \fInumber\fR is a BigInt, 0 otherwise.
.TP
\fBisFloat\fR \fInumber\fR
Returns 1 if \fInumber\fR is a BigFloat, 0 otherwise.
.TP
\fBint2float\fR \fIinteger\fR ?\fIdecimals\fR?
Converts a BigInt to a BigFloat with \fIdecimals\fR trailing zeroes.
When converting back to string, one decimal is lost.
That is why the default, and minimal, number of \fIdecimals\fR is 1.
.SH "ARITHMETICS"
.TP
\fBadd\fR \fIx\fR \fIy\fR
.TP
\fBsub\fR \fIx\fR \fIy\fR
.TP
\fBmul\fR \fIx\fR \fIy\fR
Return the sum, difference and product of \fIx\fR by \fIy\fR.
\fIx\fR - may be either a BigFloat or a BigInt
\fIy\fR - may be either a BigFloat or a BigInt
.TP
\fBdiv\fR \fIx\fR \fIy\fR
.TP
\fBmod\fR \fIx\fR \fIy\fR
Return the quotient and the rest of \fIx\fR divided by \fIy\fR.
Each argument (\fIx\fR and \fIy\fR) can be either a BigFloat or a BigInt,
but you cannot divide a BigInt by a BigFloat
Divide by zero throws an error.
.TP
\fBabs\fR \fIx\fR
Returns the absolute value of \fIx\fR
.TP
\fBopp\fR \fIx\fR
Returns the opposite of \fIx\fR
.TP
\fBpow\fR \fIx\fR \fIn\fR
Returns \fIx\fR taken to the \fIn\fRth power.
It only works if \fIn\fR is a BigInt.
\fIx\fR might be a BigFloat or a BigInt.
.SH "COMPARISONS"
.TP
\fBiszero\fR \fIx\fR
Returns 1 if \fIx\fR is :
.RS
.IP \(bu
a BigFloat close enough to zero to raise "divide by zero".
.IP \(bu
a BigInt equal to 0.
.RE
.TP
\fBequal\fR \fIx\fR \fIy\fR
Returns 1 if \fIx\fR and \fIy\fR are equal, 0 elsewhere.
.TP
\fBcompare\fR \fIx\fR \fIy\fR
Returns 0 if both BigFloat arguments are equal,
1 if \fIx\fR is greater than \fIy\fR,
and -1 if \fIx\fR is lower than \fIy\fR.
You might compare two BigFloats or two BigInts, but not a BigInt to a BigFloat.
.SH "ANALYSIS"
.TP
\fBsqrt\fR \fIx\fR
.TP
\fBlog\fR \fIx\fR
.TP
\fBexp\fR \fIx\fR
.TP
\fBcos\fR \fIx\fR
.TP
\fBsin\fR \fIx\fR
.TP
\fBtan\fR \fIx\fR
.TP
\fBcotan\fR \fIx\fR
.TP
\fBacos\fR \fIx\fR
.TP
\fBasin\fR \fIx\fR
.TP
\fBatan\fR \fIx\fR
.TP
\fBcosh\fR \fIx\fR
.TP
\fBsinh\fR \fIx\fR
.TP
\fBtanh\fR \fIx\fR
The above functions return, respectively, the following :
square root, logarithm, exponential, cosine, sine,
tangent, cotangent, arc cosine, arc sine, arc tangent, hyperbolic
cosine, hyperbolic sine, hyperbolic tangent, of a BigFloat named \fIx\fR.
.TP
\fBpi\fR \fIn\fR
Returns a BigFloat representing the Pi constant with \fIn\fR digits after the dot.
\fIn\fR may be either a simple string, or a BigInt.
.TP
\fBrad2deg\fR \fIradians\fR
.TP
\fBdeg2rad\fR \fIdegrees\fR
\fIradians\fR - angle expressed in radians (BigFloat)
.sp
\fIdegrees\fR - angle expressed in degrees (BigFloat)
.sp
Convert an angle from radians to degrees, and \fIvice versa\fR.
.SH "ROUNDING"
.TP
\fBround\fR \fIx\fR
.TP
\fBceil\fR \fIx\fR
.TP
\fBfloor\fR \fIx\fR
The above functions return the \fIx\fR BigFloat,
rounded like with the same mathematical function in \fIexpr\fR,
but returns a BigInt.
.SH "PRECISION"
Now you may ask this question : What precision am I going to get
after calling add, sub, mul or div?
When you set a number from the string representation, say
.nf

set a [fromstr 1.230]
# $a is internally 1.230 +/- d.10^-3
# 'd' is a number in the [1,2[ range
set a [fromstr 1.000]
# 'a' has a relative uncertainty in the range : ]0.1%,0.2%]
# because 1*10^-3/1.000=0.1%, and 2*10^-3/1.000=0.2%

.fi
The uncertainty of the sum, or the difference, of two numbers, is the sum of the uncertainty
of each number.
.nf

set a [fromstr 1.230]
set b [fromstr 2.340]
puts [tostr [add $a $b]]
# the result is : 3.57 and the last digit of the sum is known with an uncertainty in the
# range [2*10^-3,4*10^-3[

.fi
But when operating a BigInt to a BigFloat (add, substract,etc.), the relative uncertainty
of the result is unchanged. So it is likely to keep integers as BigInt and not to
convert them to BigFloats.
.PP
For multiplication and division, the relative uncertainties of the product
or the quotient, is the sum of the relative uncertainties of the operands.
.PP
Take care about the fact that if a number contains 0 in its uncertainty interval,
it is always considered as if it was 0.
.nf

set num [fromstr 4.00]
set denom [fromstr 0.1];# $denom is 0, because [0.0,0.2] contains 0
puts [tostr $denom];# prints "0" on the screen
set quotient [div $num $denom];# throws an error : divide by zero
set oppn [opp $num]
set oppd [opp $denom]
puts [compare $num $oppn];#prints 1
puts [compare $denom $oppd];#prints 0 !

.fi
.PP
For most analysis functions (cosinus, square root, logarithm, etc.), determining the precision
of the result is difficult.
It seems however that in many cases, the loss of precision in the result
is of one or two digits.
There are some exceptions : for example,
.nf

tostr [exp [fromstr 100.0 10]]
# returns : 2.688117142e+43 which has only 10 digits of precision, although the entry
# has 13 digits of precision.

.fi
.PP
How do conversions work with precision ?
.IP \(bu
When a number is converted from string, the internal representation keep the uncertainty
as 1 to the exponent of the last digit.
.IP \(bu
During computations, the uncertainty of each result is kept on two digits, eventually shifted and rounded when it is more than two digits long.
.IP \(bu
When converting back to string, the digits that are printed are all digits except the two last digits,
because the last digits are subject to uncertainty.
Uncertainties are kept in the internal representation of the number ; it is likely to use
\fItostr\fR only for outputting data (on the screen or in a file),
and never call \fIfromstr\fR with the result of \fItostr\fR.
It is better to always keep operands in their internal representation.
.SH "NAMESPACES AND OTHER PACKAGES"
You might import public commands with the following :
.nf

namespace import ::math::bigfloat::*

.fi
If you matter much about avoiding names conflicts, I considere it should be resolved by the following :
.nf

# the math::bignum package is required by the following statement
package require math::bigfloat
proc bigfloat {subcmd args} {
    uplevel 1 [concat ::math::bigfloat::$subcmd $args]
}
set a [bigfloat sub [bigfloat fromstr 2.000] [bigfloat fromstr 0.530]]
puts [bigfloat tostr $a]

.fi
.SH "EXAMPLES"
Guess what happens when you are doing some astronomy. Here is an example :
.nf

# convert acurrate angles with a millisecond-rated accuracy
proc degree-angle {degrees minutes seconds milliseconds} {
    set result [fromstr 0]
    set div [fromstr 1]
    foreach factor {1 1000 60 60} var [list $milliseconds $seconds $minutes $degrees] {
        # we convert each entry var into milliseconds
        set factor [fromstr $factor]
        set div [mul $div $factor]
        set result [add $result [mul [fromstr $var] $div]]
    }
    return [div [int2float $result] $div]
}
# load the package
package require math::bigfloat
namespace import ::math::bigfloat::*
# work with angles : a standard formula for navigation (taking bearings)
set angle1 [deg2rad [degree-angle 20 30 40   0]]
set angle2 [deg2rad [degree-angle 21  0 50 500]]
set opposite3 [deg2rad [degree-angle 51  0 50 500]]
set sinProduct [mul [sin $angle1] [sin $angle2]]
set cosProduct [mul [cos $angle1] [cos $angle2]]
set angle3 [asin [add [mul $sinProduct [cos $opposite3]] $cosProduct]]
puts "angle3 : [tostr [rad2deg $angle3]]"

.fi
.SH "KEYWORDS"
floating-point, math, multiprecision, tcl
.SH "COPYRIGHT"
.nf
Copyright (c) 2004-2005 Stephane Arnold <stephanearnold at yahoo dot fr>

.fi