Gem::Specification.new do |s|
  s.name = %q{icalendar}
  s.version = "1.0.1"

  s.specification_version = 1 if s.respond_to? :specification_version=

  s.required_rubygems_version = nil if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeff Rose"]
  s.autorequire = %q{icalendar}
  s.cert_chain = nil
  s.date = %q{2007-10-14}
  s.description = %q{Implements the iCalendar specification (RFC-2445) in Ruby.  This allows for the generation and parsing of .ics files, which are used by a variety of calendaring applications.}
  s.email = %q{rosejn@gmail.com}
  s.extra_rdoc_files = ["README", "COPYING", "GPL"]
  s.files = ["test/component", "test/parameter_test.rb", "test/interactive.rb", "test/coverage", "test/component_test.rb", "test/fixtures", "test/read_write.rb", "test/calendar_test.rb", "test/parser_test.rb", "test/conversions_test.rb", "test/component/event_test.rb", "test/component/todo_test.rb", "test/fixtures/simplecal.ics", "test/fixtures/folding.ics", "test/fixtures/single_event.ics", "test/fixtures/life.ics", "lib/icalendar", "lib/hash_attrs.rb", "lib/icalendar.rb", "lib/meta.rb", "lib/icalendar/component", "lib/icalendar/conversions.rb", "lib/icalendar/parameter.rb", "lib/icalendar/component.rb", "lib/icalendar/helpers.rb", "lib/icalendar/parser.rb", "lib/icalendar/calendar.rb", "lib/icalendar/base.rb", "lib/icalendar/component/alarm.rb", "lib/icalendar/component/event.rb", "lib/icalendar/component/freebusy.rb", "lib/icalendar/component/journal.rb", "lib/icalendar/component/timezone.rb", "lib/icalendar/component/todo.rb", "docs/api", "docs/rfcs", "docs/rfcs/itip_notes.txt", "docs/rfcs/rfc2425.pdf", "docs/rfcs/rfc2426.pdf", "docs/rfcs/rfc2445.pdf", "docs/rfcs/rfc2446.pdf", "docs/rfcs/rfc2447.pdf", "docs/rfcs/rfc3283.txt", "examples/single_event.ics", "examples/create_cal.rb", "examples/parse_cal.rb", "Rakefile", "README", "COPYING", "GPL"]
  s.has_rdoc = true
  s.homepage = %q{http://icalendar.rubyforge.org/}
  s.rdoc_options = ["--main", "README"]
  s.require_paths = ["lib"]
  s.required_ruby_version = Gem::Requirement.new("> 0.0.0")
  s.rubygems_version = %q{1.0.1}
  s.summary = %q{A ruby implementation of the iCalendar specification (RFC-2445).}
end
