/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    static final long serialVersionUID = 2762574228534679611L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    protected Scriptable prototype;
    protected Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private static Hashtable exclusionList = null;
    private transient Slot[] slots;
    private int count;
    private transient Slot lastAccess = REMOVED;
    private static final Class ContextClass = Context.class;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$FunctionObject;

    public abstract String getClassName();

    public boolean has(String string, Scriptable scriptable) {
        Slot slot = this.lastAccess;
        if (string != slot.stringKey || slot.wasDeleted != 0) {
            slot = this.getSlot(string, string.hashCode());
            if (slot == null) {
                return false;
            }
            slot.stringKey = string;
            this.lastAccess = slot;
        }
        return true;
    }

    public boolean has(int n, Scriptable scriptable) {
        return this.getSlot(null, n) != null;
    }

    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.lastAccess;
        if (string != slot.stringKey || slot.wasDeleted != 0) {
            slot = this.getSlot(string, string.hashCode());
            if (slot == null) {
                return Scriptable.NOT_FOUND;
            }
            slot.stringKey = string;
            this.lastAccess = slot;
        }
        if ((slot.flags & 1) != 0) {
            return this.getByGetter((GetterSlot)slot, scriptable);
        }
        return slot.value;
    }

    private Object getByGetter(GetterSlot getterSlot, Scriptable scriptable) {
        try {
            if (getterSlot.delegateTo == null) {
                Class<?> clazz = getterSlot.getter.getDeclaringClass();
                while (!clazz.isInstance(scriptable)) {
                    if ((scriptable = scriptable.getPrototype()) != null) continue;
                    scriptable = this;
                    break;
                }
                return getterSlot.getter.invoke((Object)scriptable, ScriptRuntime.emptyArgs);
            }
            Object[] objectArray = new Object[]{this};
            return getterSlot.getter.invoke(getterSlot.delegateTo, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
    }

    public Object get(int n, Scriptable scriptable) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        Slot slot = this.lastAccess;
        if ((string != slot.stringKey || slot.wasDeleted != 0) && (slot = this.getSlot(string, n = string.hashCode())) == null) {
            if (scriptable != this) {
                scriptable.put(string, scriptable, object);
                return;
            }
            slot = this.getSlotToSet(string, n);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            this.setBySetter((GetterSlot)slot, scriptable, object);
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBySetter(GetterSlot getterSlot, Scriptable scriptable, Object object) {
        Object object2;
        Object[] objectArray;
        Object object3;
        Serializable serializable;
        Context context = Context.getContext();
        Class<?>[] classArray = getterSlot.setter.getParameterTypes();
        Class<?> clazz = classArray[classArray.length - 1];
        Object object4 = FunctionObject.convertArg(context, scriptable, object, clazz);
        if (getterSlot.delegateTo == null) {
            serializable = getterSlot.setter.getDeclaringClass();
            while (!serializable.isInstance(scriptable)) {
                if ((scriptable = scriptable.getPrototype()) != null) continue;
                scriptable = this;
                break;
            }
            object3 = scriptable;
            objectArray = new Object[]{object4};
        } else {
            object3 = getterSlot.delegateTo;
            objectArray = new Object[]{this, object4};
        }
        try {
            object2 = getterSlot.setter.invoke(object3, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        if (getterSlot.setterReturnsValue) {
            serializable = new Slot();
            ((Slot)serializable).intKey = getterSlot.intKey;
            ((Slot)serializable).stringKey = getterSlot.stringKey;
            ((Slot)serializable).attributes = getterSlot.attributes;
            ((Slot)serializable).value = object2;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int n = ScriptableObject.getSlotPosition(this.slots, getterSlot.stringKey, getterSlot.intKey);
                if (n >= 0 && this.slots[n] == getterSlot) {
                    this.slots[n] = serializable;
                }
            }
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            if (scriptable != this) {
                scriptable.put(n, scriptable, object);
                return;
            }
            slot = this.getSlotToSet(null, n);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void delete(String string) {
        this.removeSlot(string, string.hashCode());
    }

    public void delete(int n) {
        this.removeSlot(null, n);
    }

    public int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        Slot slot = this.getSlot(string, string.hashCode());
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public int getAttributes(int n, Scriptable scriptable) throws PropertyException {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        n &= 7;
        Slot slot = this.getSlot(string, string.hashCode());
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)n;
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) throws PropertyException {
        n2 &= 7;
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)n2;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class clazz) {
        Context context = null;
        try {
            for (int i = 0; i < 2; ++i) {
                Object object;
                Object object2;
                Object object3;
                if (clazz == ScriptRuntime.StringClass ? i == 0 : i == 1) {
                    object3 = ScriptableObject.getProperty((Scriptable)this, "toString");
                    if (!(object3 instanceof Function)) continue;
                    object2 = (Function)object3;
                    if (context == null) {
                        context = Context.getContext();
                    }
                    object = object2.call(context, object2.getParentScope(), this, ScriptRuntime.emptyArgs);
                } else {
                    if (clazz == null) {
                        object3 = "undefined";
                    } else if (clazz == ScriptRuntime.StringClass) {
                        object3 = "string";
                    } else if (clazz == ScriptRuntime.ScriptableClass) {
                        object3 = "object";
                    } else if (clazz == ScriptRuntime.FunctionClass) {
                        object3 = "function";
                    } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                        object3 = "boolean";
                    } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                        object3 = "number";
                    } else {
                        throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                    }
                    object2 = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                    if (!(object2 instanceof Function)) continue;
                    Function function = (Function)object2;
                    Object[] objectArray = new Object[]{object3};
                    if (context == null) {
                        context = Context.getContext();
                    }
                    object = function.call(context, function.getParentScope(), this, objectArray);
                }
                if (!(object == null || object != Undefined.instance && object instanceof Scriptable && clazz != (class$org$mozilla$javascript$Scriptable == null ? ScriptableObject.class$("org.mozilla.javascript.Scriptable") : class$org$mozilla$javascript$Scriptable) && clazz != (class$org$mozilla$javascript$Function == null ? ScriptableObject.class$("org.mozilla.javascript.Function") : class$org$mozilla$javascript$Function))) {
                    return object;
                }
                if (!(object instanceof NativeJavaObject) || !((object3 = ((Wrapper)object).unwrap()) instanceof String)) continue;
                return object3;
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        String string = clazz == null ? "undefined" : clazz.toString();
        throw NativeGlobal.typeError1("msg.default.value", string, this);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public static void defineClass(Scriptable scriptable, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scriptable, clazz, false);
    }

    public static void defineClass(Scriptable scriptable, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        FunctionObject functionObject;
        Object object;
        Object object2;
        Constructor<?>[] constructorArray;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            constructorArray = methodArray[i];
            if (!constructorArray.getName().equals("init")) continue;
            object2 = constructorArray.getParameterTypes();
            if (((Class<?>[])object2).length == 3 && object2[0] == ContextClass && object2[1] == ScriptRuntime.ScriptableClass && object2[2] == Boolean.TYPE && Modifier.isStatic(constructorArray.getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                constructorArray.invoke(null, objectArray);
                return;
            }
            if (((Class<?>[])object2).length != 1 || object2[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(constructorArray.getModifiers())) continue;
            Object[] objectArray = new Object[]{scriptable};
            constructorArray.invoke(null, objectArray);
            return;
        }
        Hashtable hashtable = ScriptableObject.getExclusionList();
        constructorArray = clazz.getConstructors();
        object2 = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != 0) continue;
            object2 = constructorArray[i];
            break;
        }
        if (object2 == null) {
            throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
        }
        Scriptable scriptable2 = (Scriptable)object2.newInstance(ScriptRuntime.emptyArgs);
        scriptable2.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String string = scriptable2.getClassName();
        boolean bl2 = false;
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "jsConstructor");
        Executable executable = null;
        if (methodArray2 != null) {
            if (methodArray2.length > 1) {
                throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", methodArray2[0], methodArray2[1]));
            }
            executable = methodArray2[0];
            bl2 = true;
        }
        for (int i = 0; i < methodArray.length; ++i) {
            object = methodArray[i].getName();
            String string2 = null;
            if (!((String)object).startsWith("js")) {
                string2 = null;
            } else if (((String)object).startsWith("js_")) {
                string2 = "js_";
            } else if (((String)object).startsWith("jsFunction_")) {
                string2 = "jsFunction_";
            } else if (((String)object).startsWith("jsStaticFunction_")) {
                string2 = "jsStaticFunction_";
            } else if (((String)object).startsWith("jsProperty_")) {
                string2 = "jsProperty_";
            } else if (((String)object).startsWith("jsGet_")) {
                string2 = "jsGet_";
            } else if (((String)object).startsWith("jsSet_")) {
                string2 = "jsSet_";
            }
            if (string2 != null) {
                bl2 = true;
                object = ((String)object).substring(string2.length());
            }
            if (!((String)object).equals(string)) continue;
            if (executable != null) {
                throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", executable, methodArray[i]));
            }
            executable = methodArray[i];
        }
        if (executable == null) {
            if (constructorArray.length == 1) {
                executable = constructorArray[0];
            } else if (constructorArray.length == 2) {
                if (constructorArray[0].getParameterTypes().length == 0) {
                    executable = constructorArray[1];
                } else if (constructorArray[1].getParameterTypes().length == 0) {
                    executable = constructorArray[0];
                }
            }
            if (executable == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
            }
        }
        if ((functionObject = new FunctionObject(string, executable, scriptable)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", executable.getName());
        }
        functionObject.addAsConstructor(scriptable, scriptable2);
        if (!bl2 && hashtable == null) {
            hashtable = ScriptableObject.getExclusionList();
        }
        object = null;
        for (int i = 0; i < methodArray.length; ++i) {
            Object object3;
            Object object4;
            Object object5;
            if (!bl2 && methodArray[i].getDeclaringClass() != clazz) continue;
            String string3 = methodArray[i].getName();
            if (string3.equals("finishInit") && ((Class<?>[])(object5 = methodArray[i].getParameterTypes())).length == 3 && object5[0] == ScriptRuntime.ScriptableClass && object5[1] == (class$org$mozilla$javascript$FunctionObject == null ? ScriptableObject.class$("org.mozilla.javascript.FunctionObject") : class$org$mozilla$javascript$FunctionObject) && object5[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(methodArray[i].getModifiers())) {
                object = methodArray[i];
                continue;
            }
            if (string3.indexOf(36) != -1 || string3.equals("jsConstructor")) continue;
            object5 = null;
            if (bl2) {
                if (string3.startsWith("js_")) {
                    object5 = "js_";
                } else if (string3.startsWith("jsFunction_")) {
                    object5 = "jsFunction_";
                } else if (string3.startsWith("jsStaticFunction_")) {
                    object5 = "jsStaticFunction_";
                    if (!Modifier.isStatic(methodArray[i].getModifiers())) {
                        throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                    }
                } else if (string3.startsWith("jsProperty_")) {
                    object5 = "jsProperty_";
                } else if (string3.startsWith("jsGet_")) {
                    object5 = "jsGet_";
                } else {
                    if (!string3.startsWith("jsSet_")) continue;
                    object5 = "jsSet_";
                }
                string3 = string3.substring(((String)object5).length());
            } else if (hashtable.get(string3) != null) continue;
            if (methodArray[i] == executable || object5 != null && ((String)object5).equals("jsSet_")) continue;
            if (object5 != null && ((String)object5).equals("jsGet_")) {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), string3);
                }
                object4 = FunctionObject.findMethods(clazz, "jsSet_" + string3);
                if (object4 != null && ((Method[])object4).length != 1) {
                    throw PropertyException.withMessage2("msg.no.overload", string3, clazz.getName());
                }
                int n = 6 | (object4 != null ? 0 : 1);
                object3 = object4 == null ? null : object4[0];
                ((ScriptableObject)scriptable2).defineProperty(string3, null, methodArray[i], (Method)object3, n);
                continue;
            }
            if (!(!string3.startsWith("get") && !string3.startsWith("set") || string3.length() <= 3 || bl2 && (((String)object5).equals("jsFunction_") || ((String)object5).equals("jsStaticFunction_")))) {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), string3);
                }
                if (string3.startsWith("set")) continue;
                object4 = new StringBuffer();
                char c = string3.charAt(3);
                ((StringBuffer)object4).append(Character.toLowerCase(c));
                if (string3.length() > 4) {
                    ((StringBuffer)object4).append(string3.substring(4));
                }
                object3 = ((StringBuffer)object4).toString();
                ((StringBuffer)object4).setCharAt(0, c);
                ((StringBuffer)object4).insert(0, "set");
                String string4 = ((StringBuffer)object4).toString();
                Method[] methodArray3 = FunctionObject.findMethods(clazz, bl2 ? "js_" + string4 : string4);
                if (methodArray3 != null && methodArray3.length != 1) {
                    throw PropertyException.withMessage2("msg.no.overload", string3, clazz.getName());
                }
                if (methodArray3 == null && bl2) {
                    methodArray3 = FunctionObject.findMethods(clazz, "jsProperty_" + string4);
                }
                int n = 6 | (methodArray3 != null ? 0 : 1);
                Method method = methodArray3 == null ? null : methodArray3[0];
                ((ScriptableObject)scriptable2).defineProperty((String)object3, null, methodArray[i], method, n);
                continue;
            }
            object4 = new FunctionObject(string3, methodArray[i], scriptable2);
            if (((FunctionObject)object4).isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", executable.getName());
            }
            Scriptable scriptable3 = object5 == "jsStaticFunction_" ? functionObject : scriptable2;
            ScriptableObject.defineProperty(scriptable3, string3, object4, 2);
            if (!bl) continue;
            ((ScriptableObject)object4).sealObject();
            ((IdScriptable)object4).addPropertyAttribute(1);
        }
        if (object != null) {
            Object[] objectArray = new Object[]{scriptable, functionObject, scriptable2};
            ((Method)object).invoke(null, objectArray);
        }
        if (bl) {
            functionObject.sealObject();
            functionObject.addPropertyAttribute(1);
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
                ((ScriptableObject)scriptable2).addPropertyAttribute(1);
            }
        }
    }

    public void defineProperty(String string, Object object, int n) {
        this.put(string, (Scriptable)this, object);
        try {
            this.setAttributes(string, (Scriptable)this, n);
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException("Cannot create property");
        }
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        ScriptableObject scriptableObject;
        try {
            scriptableObject = (ScriptableObject)scriptable;
        }
        catch (ClassCastException classCastException) {
            scriptable.put(string, scriptable, object);
            return;
        }
        scriptableObject.defineProperty(string, object, n);
    }

    public void defineProperty(String string, Class clazz, int n) throws PropertyException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        String string2 = stringBuffer.toString();
        Method[] methodArray = FunctionObject.findMethods(clazz, "get" + string2);
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "set" + string2);
        if (methodArray2 == null) {
            n |= 1;
        }
        if (methodArray.length != 1 || methodArray2 != null && methodArray2.length != 1) {
            throw PropertyException.withMessage2("msg.no.overload", string, clazz.getName());
        }
        this.defineProperty(string, null, methodArray[0], methodArray2 == null ? null : methodArray2[0], n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) throws PropertyException {
        Class<?>[] classArray;
        int n2 = 1;
        if (object == null && Modifier.isStatic(method.getModifiers())) {
            object = HAS_STATIC_ACCESSORS;
        }
        if ((classArray = method.getParameterTypes()).length != 0) {
            if (classArray.length != 1 || classArray[0] != ScriptableObject.class) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", method.toString());
            }
        } else if (object != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", method.toString());
        }
        if (method2 != null) {
            n2 |= 2;
            if (object == HAS_STATIC_ACCESSORS != Modifier.isStatic(method2.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            classArray = method2.getParameterTypes();
            if (classArray.length == 2) {
                if (classArray[0] != ScriptableObject.class) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (object == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", method2.toString());
                }
            } else if (classArray.length == 1) {
                if (object != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", method2.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
        }
        GetterSlot getterSlot = new GetterSlot();
        getterSlot.delegateTo = object;
        getterSlot.getter = method;
        getterSlot.setter = method2;
        getterSlot.setterReturnsValue = method2 != null && method2.getReturnType() != Void.TYPE;
        getterSlot.value = null;
        getterSlot.attributes = (short)n;
        getterSlot.flags = (byte)n2;
        Slot slot = this.addSlot(string, string.hashCode(), getterSlot);
        if (slot != getterSlot) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] stringArray, Class clazz, int n) throws PropertyException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Method[] methodArray = FunctionObject.findMethods(clazz, string);
            if (methodArray == null) {
                throw PropertyException.withMessage2("msg.method.not.found", string, clazz.getName());
            }
            if (methodArray.length > 1) {
                throw PropertyException.withMessage2("msg.no.overload", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, methodArray[0], this);
            this.defineProperty(string, functionObject, n);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object == NOT_FOUND || !(object instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable2 = (Scriptable)object;
        if (!scriptable2.has("prototype", scriptable2)) {
            return null;
        }
        Object object2 = scriptable2.get("prototype", scriptable2);
        if (!(object2 instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)object2;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        while ((scriptable2 = (scriptable = scriptable2).getParentScope()) != null) {
        }
        return scriptable;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.getBase(scriptable, string);
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.getBase(scriptable, n);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        ObjToIntMap objToIntMap = new ObjToIntMap();
        while (scriptable != null) {
            Object[] objectArray = scriptable.getIds();
            for (int i = 0; i < objectArray.length; ++i) {
                objToIntMap.put(objectArray[i], 0);
            }
            scriptable = scriptable.getPrototype();
        }
        return objToIntMap.getKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) throws JavaScriptException {
        Context context = Context.enter();
        try {
            Object object = ScriptableObject.getProperty(scriptable, string);
            if (object == NOT_FOUND) {
                object = string;
            }
            Object object2 = ScriptRuntime.call(context, object, scriptable, objectArray, ScriptableObject.getTopLevelScope(scriptable));
            return object2;
        }
        finally {
            Context.exit();
        }
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable.has(string, scriptable2) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable.has(n, scriptable2) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    synchronized void addPropertyAttribute(int n) {
        if (this.slots == null) {
            return;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            Slot slot = this.slots[i];
            if (slot == null || slot == REMOVED) continue;
            slot.attributes = (short)(slot.attributes | n);
        }
    }

    private Slot getSlot(String string, int n) {
        Slot[] slotArray = this.slots;
        int n2 = ScriptableObject.getSlotPosition(slotArray, string, n);
        return n2 < 0 ? null : slotArray[n2];
    }

    private static int getSlotPosition(Slot[] slotArray, String string, int n) {
        if (slotArray != null) {
            Slot slot;
            int n2;
            int n3 = n2 = (n & Integer.MAX_VALUE) % slotArray.length;
            while ((slot = slotArray[n3]) != null) {
                if (slot != REMOVED && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                    return n3;
                }
                if (++n3 == slotArray.length) {
                    n3 = 0;
                }
                if (n3 != n2) continue;
            }
        }
        return -1;
    }

    private Slot getSlotToSet(String string, int n) {
        Slot[] slotArray = this.slots;
        if (slotArray == null) {
            return this.addSlot(string, n, null);
        }
        int n2 = (n & Integer.MAX_VALUE) % slotArray.length;
        boolean bl = false;
        int n3 = n2;
        do {
            Slot slot;
            if ((slot = slotArray[n3]) == null) {
                return this.addSlot(string, n, null);
            }
            if (slot == REMOVED) {
                bl = true;
            } else if (slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return slot;
            }
            if (++n3 != slotArray.length) continue;
            n3 = 0;
        } while (n3 != n2);
        if (!bl) {
            Context.codeBug();
        }
        return this.addSlot(string, n, null);
    }

    private synchronized Slot addSlot(String string, int n, Slot slot) {
        if (this.count < 0) {
            throw Context.reportRuntimeError0("msg.add.sealed");
        }
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        return this.addSlotImpl(string, n, slot);
    }

    private Slot addSlotImpl(String string, int n, Slot slot) {
        int n2;
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot2;
            if ((slot2 = this.slots[n3]) == null || slot2 == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.addSlotImpl(string, n, slot);
                }
                slot2 = slot == null ? new Slot() : slot;
                slot2.stringKey = string;
                slot2.intKey = n;
                this.slots[n3] = slot2;
                ++this.count;
                return slot2;
            }
            if (slot2.intKey == n && (slot2.stringKey == string || string != null && string.equals(slot2.stringKey))) {
                return slot2;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        Context.codeBug();
        return null;
    }

    private synchronized void removeSlot(String string, int n) {
        if (this.count < 0) {
            throw Context.reportRuntimeError0("msg.remove.sealed");
        }
        int n2 = ScriptableObject.getSlotPosition(this.slots, string, n);
        if (n2 >= 0) {
            Slot slot = this.slots[n2];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                this.slots[n2] = REMOVED;
                --this.count;
                if (slot == this.lastAccess) {
                    this.lastAccess = REMOVED;
                }
            }
        }
    }

    private void grow() {
        Slot[] slotArray = new Slot[this.slots.length * 2 + 1];
        for (int i = this.slots.length - 1; i >= 0; --i) {
            Slot slot = this.slots[i];
            if (slot == null || slot == REMOVED) continue;
            int n = (slot.intKey & Integer.MAX_VALUE) % slotArray.length;
            while (slotArray[n] != null) {
                if (++n != slotArray.length) continue;
                n = 0;
            }
            slotArray[n] = slot;
        }
        this.slots = slotArray;
    }

    private static Hashtable getExclusionList() {
        if (exclusionList != null) {
            return exclusionList;
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>(17);
        Method[] methodArray = ScriptRuntime.FunctionClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            hashtable.put(methodArray[i].getName(), Boolean.TRUE);
        }
        exclusionList = hashtable;
        return hashtable;
    }

    Object[] getIds(boolean bl) {
        Slot[] slotArray = this.slots;
        Object[] objectArray = ScriptRuntime.emptyArgs;
        if (slotArray == null) {
            return objectArray;
        }
        int n = 0;
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            if (slot == null || slot == REMOVED || !bl && (slot.attributes & 2) != 0) continue;
            if (n == 0) {
                objectArray = new Object[slotArray.length - i];
            }
            objectArray[n++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Slot[] slotArray;
        objectOutputStream.defaultWriteObject();
        int n = this.count;
        if (n < 0) {
            n = -1 - this.count;
        }
        if ((slotArray = this.slots) == null) {
            if (n != 0) {
                Context.codeBug();
            }
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(slotArray.length);
            int n2 = 0;
            while (n != 0) {
                Slot slot = slotArray[n2];
                if (slot != null && slot != REMOVED) {
                    --n;
                    objectOutputStream.writeObject(slot);
                }
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lastAccess = REMOVED;
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.slots = new Slot[n];
            int n2 = this.count;
            boolean bl = false;
            if (n2 < 0) {
                n2 = -1 - n2;
                bl = true;
            }
            this.count = 0;
            for (int i = 0; i != n2; ++i) {
                Slot slot = (Slot)objectInputStream.readObject();
                this.addSlotImpl(slot.stringKey, slot.intKey, slot);
            }
            if (bl) {
                this.count = -1 - this.count;
            }
        }
    }

    static class GetterSlot
    extends Slot
    implements Serializable {
        Object delegateTo;
        transient Method getter;
        transient Method setter;
        boolean setterReturnsValue;

        GetterSlot() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            FunctionObject.writeMember(objectOutputStream, this.getter);
            FunctionObject.writeMember(objectOutputStream, this.setter);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.getter = (Method)FunctionObject.readMember(objectInputStream);
            this.setter = (Method)FunctionObject.readMember(objectInputStream);
        }
    }

    private static class Slot
    implements Serializable {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        static final long serialVersionUID = -2158009919774350004L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }
    }
}

