/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMPFieldNode;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMRFieldNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CMFieldChildren
extends Children.Keys
implements PropertyChangeListener {
    private final EntityMethodController controller;
    private final Entity model;
    private final EjbJar ejbJar;
    private final FileObject ddFile;

    public CMFieldChildren(EntityMethodController controller, Entity model, EjbJar jar, FileObject ddFile) {
        this.model = model;
        this.controller = controller;
        this.ejbJar = jar;
        this.ddFile = ddFile;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.ejbJar.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CMFieldChildren.this.controller.getBeanClass() == null) {
                    CMFieldChildren.this.setKeys(Collections.EMPTY_LIST);
                } else {
                    List keys = CMFieldChildren.this.getCmrFields(CMFieldChildren.this.model.getEjbName());
                    CmpField[] cmpFields = CMFieldChildren.this.model.getCmpField();
                    Arrays.sort(cmpFields, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String s1 = ((CmpField)o1).getFieldName();
                            String s2 = ((CmpField)o2).getFieldName();
                            if (s1 == null) {
                                s1 = "";
                            }
                            if (s2 == null) {
                                s2 = "";
                            }
                            return s1.compareTo(s2);
                        }
                    });
                    keys.addAll(Arrays.asList(cmpFields));
                    CMFieldChildren.this.setKeys(keys);
                }
            }
        });
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
        this.ejbJar.removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        Node[] nodes = null;
        if (key instanceof CmpField) {
            CmpField field = (CmpField)key;
            CMPFieldNode n = new CMPFieldNode(field, this.controller, this.ddFile);
            nodes = new Node[]{n};
        } else if (key instanceof CmrField) {
            CmrField field = (CmrField)key;
            CMRFieldNode n = new CMRFieldNode(field, this.controller, this.ddFile);
            nodes = new Node[]{n};
        }
        return nodes;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.updateKeys();
    }

    private CmrField getCmrField(EjbRelationshipRole role, String ejbName) {
        return role != null && role.getRelationshipRoleSource() != null && ejbName.equals(role.getRelationshipRoleSource().getEjbName()) && role.getCmrField() != null ? role.getCmrField() : null;
    }

    private void getFields(String ejbName, List l) {
        EjbRelation[] relations;
        Relationships r = this.ejbJar.getSingleRelationships();
        if (r != null && (relations = r.getEjbRelation()) != null) {
            for (int i = 0; i < relations.length; ++i) {
                CmrField f = this.getCmrField(relations[i].getEjbRelationshipRole(), ejbName);
                if (f != null) {
                    l.add(f);
                }
                if ((f = this.getCmrField(relations[i].getEjbRelationshipRole2(), ejbName)) == null) continue;
                l.add(f);
            }
        }
    }

    private List getCmrFields(String ejbName) {
        LinkedList l = new LinkedList();
        this.getFields(ejbName + "", l);
        return l;
    }
}

