/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.patterns;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EjbGenerationUtil;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class ServiceLocatorWizard
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private WizardDescriptor wiz;
    private static final String[] STEPS = new String[]{NbBundle.getMessage(ServiceLocatorWizard.class, (String)"LBL_SpecifyName")};

    public String name() {
        return NbBundle.getMessage(ServiceLocatorWizard.class, (String)"LBL_MessageServiceLocatorWizardTitle");
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        this.panels = new WizardDescriptor.Panel[]{JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups)};
        Utils.mergeSteps(this.wiz, this.panels, STEPS);
    }

    public Set instantiate() throws IOException {
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String clsName = Templates.getTargetName((WizardDescriptor)this.wiz);
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)pkg);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, clsName);
        String pkgName = EjbGenerationUtil.getSelectedPackageName(pkg, project);
        String fullName = (pkgName.length() > 0 ? pkgName + '.' : "") + clsName;
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)project.getLookup().lookup(EnterpriseReferenceContainer.class);
        if (erc != null) {
            erc.setServiceLocatorName(fullName);
        }
        FileObject createdFile = dobj.getPrimaryFile();
        return Collections.singleton(createdFile);
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }
}

