/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;

public abstract class EjbMethodController {
    public static EjbMethodController create(Feature feature) {
        JavaClass jc = JMIUtils.getDeclaringClass((Feature)feature);
        return EjbMethodController.createFromClass(jc);
    }

    public static EjbMethodController createFromClass(JavaClass jc) {
        FileObject fo = JavaModel.getFileObject((Resource)jc.getResource());
        ClassPath cp = Util.getFullClasspath((FileObject)fo);
        assert (cp != null) : "Cannot find ClassPath for " + String.valueOf(fo);
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)fo);
        if (ejbModule == null) {
            return null;
        }
        DDProvider provider = DDProvider.getDefault();
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = null;
        AbstractMethodController controller = null;
        try {
            ejbJar = provider.getMergedDDRoot(ejbModule.getMetadataUnit());
            EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
            if (beans != null) {
                Session s = (Session)beans.findBeanByName("Session", "EjbClass", jc.getName());
                if (s != null) {
                    controller = new SessionMethodController(s, cp);
                    if (!((EjbMethodController)controller).hasLocal() && !((EjbMethodController)controller).hasRemote()) {
                        controller = null;
                    }
                } else {
                    Entity e = (Entity)beans.findBeanByName("Entity", "EjbClass", jc.getName());
                    if (e != null) {
                        controller = new EntityMethodController(e, cp, ejbJar);
                    }
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return controller;
    }

    public abstract List getImplementation(Method var1);

    public abstract Method getPrimaryImplementation(Method var1);

    public abstract boolean hasJavaImplementation(Method var1);

    public abstract boolean hasJavaImplementation(MethodType var1);

    public abstract Method getInterface(Method var1, boolean var2);

    public abstract boolean hasMethodInInterface(Method var1, MethodType var2, boolean var3);

    public abstract MethodType getMethodTypeFromInterface(Method var1);

    public abstract MethodType getMethodTypeFromImpl(Method var1);

    public abstract JavaClass getBeanClass();

    public abstract String getLocal();

    public abstract String getRemote();

    public abstract Collection getLocalInterfaces();

    public abstract Collection getRemoteInterfaces();

    public abstract boolean hasLocal();

    public abstract boolean hasRemote();

    public void addEjbQl(Method clientView, String ejbql, FileObject dd) throws IOException {
        assert (false) : "ejbql not supported for this bean type";
    }

    public String createDefaultQL(MethodType mt) {
        return null;
    }

    public abstract void createAndAddInterface(Method var1, boolean var2);

    public abstract void createAndAddImpl(Method var1);

    public abstract void delete(Method var1, boolean var2);

    public abstract boolean supportsMethodType(int var1);

    public abstract void createAndAdd(Method var1, boolean var2, boolean var3);
}

