/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import javax.jmi.reflect.JmiException;
import javax.swing.Action;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternProperties;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public abstract class PatternNode
extends AbstractNode
implements IconBases,
PatternProperties,
PropertyChangeListener {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"mode"};
    private static final SystemAction[] DEFAULT_ACTIONS = new SystemAction[]{SystemAction.get((Class)DeleteAction.class), SystemAction.get((Class)RenameAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    protected Pattern pattern;
    protected boolean writeable;

    public PatternNode(Pattern pattern, Children children, boolean writeable) {
        super(children);
        this.pattern = pattern;
        this.writeable = writeable;
        this.setIconBase(this.resolveIconBase());
        this.setActions(DEFAULT_ACTIONS);
        this.pattern.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pattern));
        this.displayFormat = null;
    }

    public String getShortDescription() {
        return super.getShortDescription();
    }

    protected abstract String resolveIconBase();

    public Action getPreferredAction() {
        return SystemAction.get((Class)OpenAction.class);
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public boolean canRename() {
        return this.writeable;
    }

    public boolean canDestroy() {
        return this.writeable;
    }

    public Transferable clipboardCopy() throws IOException {
        return super.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.writeable) {
            throw new IOException();
        }
        return super.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.writeable;
    }

    public void setActions(SystemAction[] actions) {
        this.systemActions = actions;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie c = super.getCookie(type);
        if (c == null) {
            c = this.pattern.getCookie(type);
        }
        return c;
    }

    public boolean equals(Object o) {
        return o instanceof PatternNode && this.pattern.equals(((PatternNode)o).pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String name) {
        try {
            JMIUtils.beginTrans(true);
            boolean rollback = true;
            try {
                this.pattern.patternAnalyser.setIgnore(true);
                this.setPatternName(name);
                rollback = false;
            }
            finally {
                this.pattern.patternAnalyser.setIgnore(false);
                JMIUtils.endTrans(rollback);
            }
            this.superSetName(name);
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public final void superSetName(String name) {
        super.setName(name);
    }

    protected abstract void setPatternName(String var1) throws JmiException;

    protected Node.Property createNameProperty(boolean canW) {
        return new PatternPropertySupport("name", String.class, canW){

            public Object getValue() {
                return PatternNode.this.pattern.getName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                String str = (String)val;
                try {
                    JMIUtils.beginTrans(true);
                    boolean rollback = true;
                    try {
                        PatternNode.this.pattern.patternAnalyser.setIgnore(true);
                        PatternNode.this.setPatternName(str);
                        rollback = false;
                    }
                    finally {
                        PatternNode.this.pattern.patternAnalyser.setIgnore(false);
                        JMIUtils.endTrans(rollback);
                    }
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException();
                }
                PatternNode.this.superSetName(str);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        try {
            JMIUtils.beginTrans(true);
            boolean rollback = true;
            try {
                this.pattern.destroy();
                rollback = false;
            }
            finally {
                JMIUtils.endTrans(rollback);
            }
        }
        catch (JmiException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        super.destroy();
    }

    protected static String getFormattedMethodName(Method method) {
        String name = null;
        Format fmt = SourceNodes.createElementFormat((String)"{n} ({p})");
        try {
            if (method != null) {
                name = fmt.format(method);
            }
        }
        catch (IllegalArgumentException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        return name != null ? name : PatternNode.getString("LAB_NoMethod");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setIconBase(this.resolveIconBase());
        this.superSetName(this.pattern.getName());
        this.firePropertyChange(null, null, null);
    }

    static String getString(String key) {
        return NbBundle.getBundle((String)"org.netbeans.modules.beans.Bundle").getString(key);
    }

    static abstract class PatternPropertySupport
    extends PropertySupport {
        public PatternPropertySupport(String name, Class type, boolean canW) {
            super(name, type, PatternNode.getString("PROP_" + name), PatternNode.getString("HINT_" + name), true, canW);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(PatternNode.getString("MSG_Cannot_Write"));
            }
        }
    }
}

