/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public final class ClassLoadUnloadBreakpoint
extends JPDABreakpoint {
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_CLASS_LOADED = 1;
    public static final int TYPE_CLASS_UNLOADED = 2;
    public static final int TYPE_CLASS_LOADED_UNLOADED = 3;
    private int type = 1;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];

    private ClassLoadUnloadBreakpoint() {
    }

    public static ClassLoadUnloadBreakpoint create(String classNameFilter, boolean isExclusionFilter, int breakpointType) {
        ClassLoadUnloadBreakpoint b = new ClassLoadUnloadBreakpoint();
        if (isExclusionFilter) {
            b.setClassExclusionFilters(new String[]{classNameFilter});
        } else {
            b.setClassFilters(new String[]{classNameFilter});
        }
        b.setBreakpointType(breakpointType);
        return b;
    }

    public static ClassLoadUnloadBreakpoint create(int breakpointType) {
        ClassLoadUnloadBreakpoint b = new ClassLoadUnloadBreakpoint();
        b.setBreakpointType(breakpointType);
        return b;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public void setBreakpointType(int type) {
        if (type == this.type) {
            return;
        }
        if ((type & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, new Integer(old), new Integer(type));
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] classFilters) {
        if (classFilters == this.classFilters) {
            return;
        }
        String[] old = this.classFilters;
        this.classFilters = classFilters;
        this.firePropertyChange(PROP_CLASS_FILTERS, old, classFilters);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] classExclusionFilters) {
        if (classExclusionFilters == this.classExclusionFilters) {
            return;
        }
        String[] old = this.classExclusionFilters;
        this.classExclusionFilters = classExclusionFilters;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, old, classExclusionFilters);
    }

    public String toString() {
        return "ClassLoadUnloadBreakpoint " + this.classFilters;
    }
}

