/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class AttachingDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-AttachingDICookie";
    private AttachingConnector attachingConnector;
    private Map args;

    private AttachingDICookie(AttachingConnector attachingConnector, Map args) {
        this.attachingConnector = attachingConnector;
        this.args = args;
    }

    public static AttachingDICookie create(AttachingConnector attachingConnector, Map args) {
        return new AttachingDICookie(attachingConnector, args);
    }

    public static AttachingDICookie create(String hostName, int portNumber) {
        return new AttachingDICookie(AttachingDICookie.findAttachingConnector("socket"), AttachingDICookie.getArgs(AttachingDICookie.findAttachingConnector("socket"), hostName, portNumber));
    }

    public static AttachingDICookie create(String name) {
        return new AttachingDICookie(AttachingDICookie.findAttachingConnector("shmem"), AttachingDICookie.getArgs(AttachingDICookie.findAttachingConnector("shmem"), name));
    }

    public AttachingConnector getAttachingConnector() {
        return this.attachingConnector;
    }

    public Map getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument a = (Connector.Argument)this.args.get("port");
        if (a == null) {
            return -1;
        }
        String pn = a.value();
        if (pn == null) {
            return -1;
        }
        return Integer.parseInt(pn);
    }

    public String getHostName() {
        Connector.Argument a = (Connector.Argument)this.args.get("hostname");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    public String getSharedMemoryName() {
        Connector.Argument a = (Connector.Argument)this.args.get("name");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        return this.attachingConnector.attach(this.args);
    }

    private static Map getArgs(AttachingConnector attachingConnector, String hostName, int portNumber) {
        Map<String, Connector.Argument> args = attachingConnector.defaultArguments();
        args.get("hostname").setValue(hostName);
        args.get("port").setValue("" + portNumber);
        return args;
    }

    private static Map getArgs(AttachingConnector attachingConnector, String name) {
        Map<String, Connector.Argument> args = attachingConnector.defaultArguments();
        args.get("name").setValue(name);
        return args;
    }

    private static AttachingConnector findAttachingConnector(String s) {
        Iterator<AttachingConnector> iter = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        while (iter.hasNext()) {
            AttachingConnector ac = iter.next();
            if (ac.transport() == null || ac.transport().name().toLowerCase().indexOf(s) <= -1) continue;
            return ac;
        }
        return null;
    }
}

