/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.StatusLine;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.MenuBar;
import org.openide.awt.StatusLineElementProvider;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    private Component desktop;
    private JPanel desktopPanel;
    private static JPanel innerIconsPanel;
    private boolean inited;
    private static Lookup.Result result;
    private static final String ICON_SMALL = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_BIG = "org/netbeans/core/startup/frame32.gif";
    private static final String BUILD_NUMBER;
    private static final String TITLE_NO_PROJECT;
    private static final Format FORMAT_PROJECT;
    private Image waitingForPaintDummyImage;
    private Graphics waitingForPaintDummyGraphic;
    boolean isOlderJDK = System.getProperty("java.version").startsWith("1.5");
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void setRootPane(JRootPane root) {
        super.setRootPane(root);
        if (root != null) {
            HelpCtx.setHelpIDString((JComponent)root, (String)new HelpCtx(MainWindow.class).getHelpID());
        }
        root.setOpaque(true);
        if (Utilities.isWindows()) {
            JPanel c = new JPanel(){

                public void setVisible(boolean flag) {
                    if (flag != this.isVisible()) {
                        super.setVisible(flag);
                    }
                }
            };
            c.setName(root.getName() + ".nbGlassPane");
            c.setVisible(false);
            ((JPanel)c).setOpaque(false);
            root.setGlassPane(c);
        }
    }

    public void initializeComponents() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.setIconImage(MainWindow.createIDEImage());
        this.initListeners();
        this.setDefaultCloseOperation(0);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)MainWindow.class).getString("ACSD_MainWindow"));
        this.setJMenuBar(MainWindow.createMenuBar());
        if (!Constants.NO_TOOLBARS) {
            JComponent tb = MainWindow.getToolbarComponent();
            this.getContentPane().add((Component)tb, "North");
        }
        if (!Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            JComponent status;
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                status = new StatusLine();
                ((JLabel)status).setText(" ");
                status.setPreferredSize(new Dimension(0, status.getPreferredSize().height));
                status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                JPanel statusLinePanel = new JPanel(new BorderLayout());
                int magicConstant = 0;
                if (Utilities.getOperatingSystem() == 4096) {
                    magicConstant = 12;
                }
                statusLinePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, magicConstant), statusLinePanel.getBorder()));
                statusLinePanel.add((Component)new JSeparator(), "North");
                statusLinePanel.add((Component)status, "Center");
                MainWindow.decoratePanel(statusLinePanel);
                statusLinePanel.setName("statusLine");
                this.getContentPane().add((Component)statusLinePanel, "South");
            } else {
                status = MainWindow.getCustomStatusLine();
                if (status != null) {
                    this.getContentPane().add((Component)status, "South");
                }
            }
        }
        this.desktopPanel = new JPanel();
        this.desktopPanel.setBorder(MainWindow.getDesktopBorder());
        this.desktopPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.desktopPanel, "Center");
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MenuElement[] elems = MenuSelectionManager.defaultManager().getSelectedPath();
                if (elems != null && elems.length > 0 && elems[0] == MainWindow.this.getJMenuBar() && !MainWindow.this.isActive()) {
                    MainWindow.this.toFront();
                }
            }
        });
    }

    private static void decoratePanel(JPanel panel) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Must run in AWT queue.");
        }
        if (innerIconsPanel != null) {
            panel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = MainWindow.getStatusLineElements(panel)) != null) {
            panel.add((Component)innerIconsPanel, "East");
        }
    }

    static JPanel getStatusLineElements(JPanel panel) {
        Collection c;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(panel));
        }
        if ((c = result.allInstances()) == null || c.isEmpty()) {
            return null;
        }
        Iterator it = c.iterator();
        JPanel icons = new JPanel(new FlowLayout(2, 0, 0));
        icons.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        boolean some = false;
        while (it.hasNext()) {
            Object o = it.next();
            if (!$assertionsDisabled && !(o instanceof StatusLineElementProvider)) {
                throw new AssertionError();
            }
            Component comp = ((StatusLineElementProvider)o).getStatusLineElement();
            if (comp == null) continue;
            some = true;
            icons.add(comp);
        }
        return some ? icons : null;
    }

    private static Border getDesktopBorder() {
        Border b = (Border)UIManager.get("nb.desktop.splitpane.border");
        if (b != null) {
            return b;
        }
        return new EmptyBorder(1, 1, 1, 1);
    }

    static Image createIDEImage() {
        return Utilities.loadImage((String)(Utilities.isLargeFrameIcons() ? ICON_BIG : ICON_SMALL), (boolean)true);
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LifecycleManager.getDefault().exit();
            }

            public void windowActivated(WindowEvent evt) {
                RegistryImpl.cancelMenu(MainWindow.this);
            }
        });
    }

    private static JMenuBar createMenuBar() {
        JMenuBar menu = MainWindow.getCustomMenuBar();
        if (menu == null) {
            menu = new MenuBar(null);
        }
        menu.setBorderPainted(false);
        if (menu instanceof MenuBar) {
            ((MenuBar)menu).waitFinished();
        }
        if (Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                StatusLine status = new StatusLine();
                JSeparator sep = new JSeparator(1);
                Dimension d = sep.getPreferredSize();
                d.width += 6;
                sep.setPreferredSize(d);
                JPanel statusLinePanel = new JPanel(new BorderLayout());
                statusLinePanel.add((Component)sep, "West");
                statusLinePanel.add((Component)status, "Center");
                MainWindow.decoratePanel(statusLinePanel);
                statusLinePanel.setName("statusLine");
                menu.add(statusLinePanel);
            } else {
                JComponent status = MainWindow.getCustomStatusLine();
                if (status != null) {
                    menu.add(status);
                }
            }
        }
        return menu;
    }

    private static JMenuBar getCustomMenuBar() {
        try {
            DataObject dobj;
            InstanceCookie ic;
            String fileName = Constants.CUSTOM_MENU_BAR_PATH;
            if (fileName == null) {
                return null;
            }
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(fileName);
            if (fo != null && (ic = (InstanceCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(InstanceCookie.class)) != null) {
                return (JMenuBar)ic.instanceCreate();
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    private static JComponent getCustomStatusLine() {
        try {
            DataObject dobj;
            InstanceCookie ic;
            String fileName = Constants.CUSTOM_STATUS_LINE_PATH;
            if (fileName == null) {
                return null;
            }
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(fileName);
            if (fo != null && (ic = (InstanceCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(InstanceCookie.class)) != null) {
                return (JComponent)ic.instanceCreate();
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    private static JComponent getToolbarComponent() {
        ToolbarPool tp = ToolbarPool.getDefault();
        tp.waitFinished();
        return tp;
    }

    private void initializeBounds() {
        Rectangle bounds = WindowManagerImpl.getInstance().getEditorAreaState() == 0 ? WindowManagerImpl.getInstance().getMainWindowBoundsJoined() : WindowManagerImpl.getInstance().getMainWindowBoundsSeparated();
        if (!bounds.isEmpty()) {
            this.setBounds(bounds);
        }
    }

    public void setBounds(Rectangle rect) {
        Rectangle bounds = rect;
        if (bounds != null && bounds.height < this.getPreferredSize().height) {
            bounds = new Rectangle(bounds.x, bounds.y, bounds.width, this.getPreferredSize().height);
        }
        super.setBounds(bounds);
    }

    public void prepareWindow() {
        this.initializeBounds();
    }

    public void setDesktop(Component comp) {
        if (this.desktop == comp) {
            if (this.desktop != null && !Arrays.asList(this.desktopPanel.getComponents()).contains(this.desktop)) {
                this.desktopPanel.add(this.desktop, "Center");
            }
            return;
        }
        if (this.desktop != null) {
            this.desktopPanel.remove(this.desktop);
        }
        this.desktop = comp;
        if (this.desktop != null) {
            this.desktopPanel.add(this.desktop, "Center");
        }
        this.invalidate();
        this.validate();
        if (this.isOlderJDK && !System.getProperty("os.name").startsWith("Windows")) {
            this.releaseWaitingForPaintDummyGraphic();
        }
        this.repaint();
    }

    public Component getDesktop() {
        return this.desktop;
    }

    public boolean hasDesktop() {
        return this.desktop != null;
    }

    public Rectangle getPureMainWindowBounds() {
        Rectangle bounds = this.getBounds();
        if (this.desktop != null) {
            Dimension desktopSize = this.desktop.getSize();
            bounds.height -= desktopSize.height;
        }
        return bounds;
    }

    public void setProjectName(String projectName) {
        this.updateTitle(projectName);
    }

    private void updateTitle(String projectName) {
        if (projectName == null) {
            this.setTitle(TITLE_NO_PROJECT);
        } else {
            this.setTitle(FORMAT_PROJECT.format(new Object[]{BUILD_NUMBER, projectName}));
        }
    }

    public void setVisible(boolean flag) {
        if (flag && this.isOlderJDK) {
            this.waitingForPaintDummyImage = new BufferedImage(1, 1, 1);
            this.waitingForPaintDummyGraphic = this.waitingForPaintDummyImage.getGraphics();
        }
        super.setVisible(flag);
    }

    public void paint(Graphics g) {
        if (this.waitingForPaintDummyGraphic != null) {
            this.releaseWaitingForPaintDummyGraphic();
            g = this.getGraphics();
        }
        super.paint(g);
    }

    public Graphics getGraphics() {
        if (this.waitingForPaintDummyGraphic != null) {
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event == null || event.getID() != 800 && event.getSource() != this) {
                return this.waitingForPaintDummyGraphic;
            }
            this.releaseWaitingForPaintDummyGraphic();
        }
        return super.getGraphics();
    }

    private void releaseWaitingForPaintDummyGraphic() {
        if (this.waitingForPaintDummyGraphic != null) {
            this.waitingForPaintDummyGraphic.dispose();
            this.waitingForPaintDummyGraphic = null;
            this.waitingForPaintDummyImage = null;
        }
    }

    static {
        $assertionsDisabled = !MainWindow.class.desiredAssertionStatus();
        BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
        TITLE_NO_PROJECT = NbBundle.getMessage((Class)MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)BUILD_NUMBER);
        FORMAT_PROJECT = new MessageFormat(NbBundle.getMessage((Class)MainWindow.class, (String)"CTL_MainWindow_Title"));
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel decoratingPanel) {
            this.decoratingPanel = decoratingPanel;
        }

        public void resultChanged(LookupEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.decoratePanel(StatusLineElementsListener.this.decoratingPanel);
                }
            });
        }
    }
}

