/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.dnd.EnhancedDragPainter;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;

public final class DropTargetGlassPane
extends JPanel
implements DropTargetListener {
    private final Observer observer;
    private final Informer informer;
    private WindowDnDManager windowDragAndDrop;
    private static boolean isHardwareDoubleBuffer = false;
    private Point location;
    private TopComponentDroppable droppable;
    private static final boolean DEBUG = Debug.isLoggable(DropTargetGlassPane.class);
    private Point dragLocation = null;
    private boolean guidedPaint = false;
    private DragRepaintManager dragRepaintManager = null;
    private static final Color FILL_COLOR = new Color(200, 200, 200, 120);
    private static final Rectangle scratch = new Rectangle();

    public DropTargetGlassPane(WindowDnDManager wdnd) {
        this.observer = wdnd;
        this.informer = wdnd;
        this.windowDragAndDrop = wdnd;
        isHardwareDoubleBuffer = !RepaintManager.currentManager(this).isDoubleBufferingEnabled();
        this.setOpaque(false);
    }

    public void initialize() {
        if (this.isVisible()) {
            this.revalidate();
        } else {
            this.setVisible(true);
        }
    }

    public void uninitialize() {
        if (this.location != null) {
            this.dragFinished();
        }
        this.setVisible(false);
    }

    void dragOver(Point location, TopComponentDroppable droppable) {
        this.droppable = droppable;
        if (this.dragRepaintManager == null) {
            this.setDragRepaintManager(new DragRepaintManager(this));
        }
        this.setDragLocation(location);
    }

    private void setDragLocation(Point p) {
        Point old = this.dragLocation;
        this.dragLocation = p;
        if (p != null && p.equals(old)) {
            return;
        }
        if (p == null) {
            return;
        }
        if (this.droppable != null) {
            Component c = this.droppable.getDropComponent();
            Shape s = this.droppable.getIndicationForLocation(SwingUtilities.convertPoint(this, p, c));
            EnhancedDragPainter painter = null;
            if (this.droppable instanceof EnhancedDragPainter) {
                painter = (EnhancedDragPainter)((Object)this.droppable);
            }
            this.dragRepaintManager.setShapeAndTarget(s, c, painter);
        } else {
            this.dragRepaintManager.eraseLastIndication(null);
        }
    }

    private void dragExited() {
        this.clear();
    }

    private void setGuidedPaint(boolean val) {
        this.guidedPaint = val;
    }

    private boolean isGuidedPaint() {
        return this.guidedPaint;
    }

    public void clearIndications() {
        this.clear();
    }

    private void dragActionChanged(Point location) {
        this.setDragLocation(location);
    }

    private void dragFinished() {
        this.clear();
        this.setDragRepaintManager(null);
    }

    private void setDragRepaintManager(DragRepaintManager drm) {
        this.dragRepaintManager = drm;
    }

    private void clear() {
        this.droppable = null;
        if (this.dragRepaintManager != null) {
            this.dragRepaintManager.setShapeAndTarget(null, null, null);
        }
        this.setDragLocation(null);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isGuidedPaint() && this.dragRepaintManager != null) {
            this.dragRepaintManager.paintCurrentIndication((Graphics2D)g);
        }
    }

    public void dragEnter(DropTargetDragEvent evt) {
        int dropAction;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragEnter");
        }
        if ((dropAction = evt.getDropAction()) == 0) {
            dropAction = 2;
        }
        if ((dropAction & 3) > 0) {
            evt.acceptDrag(dropAction);
        } else {
            evt.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent evt) {
        Component c;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragExit");
        }
        if ((c = evt.getDropTargetContext().getComponent()) == this) {
            this.dragExited();
        }
    }

    public void dragOver(DropTargetDragEvent evt) {
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragOver");
        }
        if (this.dragRepaintManager == null) {
            this.setDragRepaintManager(new DragRepaintManager(this));
        }
        this.observer.setLastDropTarget(this);
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
        int dropAction;
        boolean acceptDrag;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dropActionChanged");
        }
        if (acceptDrag = (dropAction = evt.getDropAction()) == 2 || dropAction == 1 && this.informer.isCopyOperationPossible()) {
            evt.acceptDrag(dropAction);
        } else {
            evt.rejectDrag();
        }
        Component c = evt.getDropTargetContext().getComponent();
        if (c == this) {
            this.dragActionChanged(acceptDrag ? evt.getLocation() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent evt) {
        int dropAction;
        Component c;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("drop");
        }
        if ((c = evt.getDropTargetContext().getComponent()) == this) {
            this.dragFinished();
        }
        if ((dropAction = evt.getDropAction()) != 2 && dropAction != 1) {
            evt.rejectDrop();
            return;
        }
        evt.acceptDrop(dropAction);
        boolean success = false;
        try {
            Point location = evt.getLocation();
            SwingUtilities.convertPointToScreen(location, c);
            if (WindowDnDManager.isAroundCenterPanel(location)) {
                return;
            }
            success = this.windowDragAndDrop.tryPerformDrop(this.informer.getController(), this.informer.getFloatingFrames(), location, dropAction, evt.getTransferable());
        }
        finally {
            this.observer.setDropSuccess(success);
            evt.dropComplete(false);
        }
    }

    private static void debugLog(String message) {
        Debug.log(DropTargetGlassPane.class, message);
    }

    private static class DragRepaintManager {
        private Shape shape = null;
        private Component lastDropComponent;
        private EnhancedDragPainter lastEnhanced;
        DropTargetGlassPane pane;
        private Graphics2D g = null;

        public DragRepaintManager(DropTargetGlassPane pane) {
            this.pane = pane;
            if (isHardwareDoubleBuffer && !Boolean.getBoolean("nb.winsys.mac.no.double.buffer")) {
                RepaintManager.currentManager(pane).setDoubleBufferingEnabled(true);
            }
        }

        protected void finalize() {
            if (this.g != null) {
                this.g.dispose();
            }
            if (isHardwareDoubleBuffer && !Boolean.getBoolean("nb.winsys.mac.no.double.buffer")) {
                RepaintManager.currentManager(this.pane).setDoubleBufferingEnabled(false);
            }
        }

        private Graphics2D getGraphics() {
            if (this.g == null) {
                this.g = (Graphics2D)this.pane.getGraphics();
            }
            return this.g;
        }

        public void clear() {
            this.lastDropComponent = null;
            this.lastEnhanced = null;
        }

        public void setShapeAndTarget(Shape s, Component c, EnhancedDragPainter enh) {
            Shape old = this.shape;
            if (old != null && s != null) {
                if (!this.shape.equals(s)) {
                    this.shape = s;
                    this.shapeChange(old, this.shape, c, enh);
                }
            } else if (old == null != (s == null)) {
                this.shape = s;
                this.shapeChange(old, s, c, enh);
            }
        }

        public void paintCurrentIndication(Graphics2D g) {
            if (this.shape != null) {
                this.paintShapeOnGlassPane(this.shape, g);
            }
        }

        public void eraseLastIndication(Graphics2D g) {
            if (this.shape == null) {
                return;
            }
            this.eraseShape(g);
        }

        private void shapeChange(Shape old, Shape nue, Component c, EnhancedDragPainter enhanced) {
            if (old != null) {
                this.eraseShape(this.g);
            }
            this.lastDropComponent = c;
            this.lastEnhanced = enhanced;
            if (nue != null) {
                this.paintShapeOnGlassPane(nue, this.g);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eraseShape(Graphics2D g) {
            if (g == null) {
                g = this.getGraphics();
            }
            if (g == null) {
                return;
            }
            this.pane.setGuidedPaint(true);
            try {
                JRootPane toPaint = ((JComponent)this.lastDropComponent).getRootPane();
                toPaint.paint(g);
                g.setClip(null);
            }
            finally {
                this.pane.setGuidedPaint(false);
            }
            if (isHardwareDoubleBuffer) {
                Toolkit.getDefaultToolkit().sync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintShapeOnGlassPane(Shape s, Graphics2D g) {
            if (g == null) {
                g = this.getGraphics();
            }
            if (g == null) {
                return;
            }
            this.pane.setGuidedPaint(true);
            try {
                JComponent toPaint = (JComponent)this.lastDropComponent;
                if (this.lastEnhanced != null) {
                    this.lastEnhanced.additionalDragPaint(g);
                }
                Shape clip = this.getClipForIndication(s, true, this.lastDropComponent);
                g.setClip(clip);
                this.paintShape(s, g);
                g.setClip(null);
            }
            finally {
                this.pane.setGuidedPaint(false);
            }
            if (isHardwareDoubleBuffer) {
                Toolkit.getDefaultToolkit().sync();
            }
        }

        private void paintShape(Shape s, Graphics2D g) {
            Color fillColor;
            Color oldColor = g.getColor();
            Stroke oldStroke = g.getStroke();
            Paint oldPaint = g.getPaint();
            g.setColor(Color.red);
            g.setStroke(this.createIndicationStroke());
            g.setPaint(this.createPaint());
            Color color = fillColor = Constants.SWITCH_DROP_INDICATION_FADE ? FILL_COLOR : null;
            if (s instanceof Rectangle) {
                this.drawIndicationRectangle(g, (Rectangle)s, this.lastDropComponent, fillColor);
            } else if (s instanceof GeneralPath) {
                this.drawIndicationGeneralPath(g, (GeneralPath)s, this.lastDropComponent, fillColor);
            } else if (s instanceof Polygon) {
                this.drawIndicationPolygon(g, (Polygon)s, this.lastDropComponent, fillColor);
            }
            g.setColor(oldColor);
            g.setStroke(oldStroke);
            g.setPaint(oldPaint);
        }

        private Stroke createIndicationStroke() {
            return new BasicStroke(3.0f);
        }

        private Shape getClipForIndication(Shape indication, boolean translate, Component target) {
            Shape clip;
            if (indication instanceof Rectangle) {
                scratch.setBounds((Rectangle)indication);
                scratch.x -= 3;
                scratch.y -= 3;
                scratch.width += 6;
                scratch.height += 6;
                Area a = new Area(scratch);
                scratch.setBounds((Rectangle)indication);
                scratch.x += 4;
                scratch.y += 4;
                scratch.width -= 8;
                scratch.height -= 8;
                a.subtract(new Area(scratch));
                if (translate) {
                    Point p = new Point(0, 0);
                    p = SwingUtilities.convertPoint(this.lastDropComponent, p, this.pane);
                    AffineTransform at = AffineTransform.getTranslateInstance(p.x, p.y);
                    a.transform(at);
                }
                clip = a;
            } else {
                if (indication instanceof Polygon) {
                    if (translate) {
                        indication = this.getTransformedPath((Polygon)indication, target);
                    }
                } else if (indication instanceof GeneralPath) {
                    if (translate) {
                        indication = this.getTransformedPath((GeneralPath)indication, target);
                    }
                } else {
                    return null;
                }
                clip = new BasicStroke(5.0f).createStrokedShape(indication);
            }
            return clip;
        }

        private Polygon getTransformedPath(Polygon path, Component source) {
            EqualPolygon result = new EqualPolygon(path.xpoints, path.ypoints, path.npoints);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(source, point, this.pane);
            result.translate(point.x, point.y);
            return result;
        }

        private GeneralPath getTransformedPath(GeneralPath path, Component source) {
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(source, point, this.pane);
            path = (GeneralPath)path.clone();
            path.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)point.x, (double)point.y));
            return path;
        }

        private void drawIndicationPolygon(Graphics2D g, Polygon p, Component source, Color fillColor) {
            if (g == null) {
                g = this.getGraphics();
            }
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(source, point, this.pane);
            p = new EqualPolygon(p.xpoints, p.ypoints, p.npoints);
            p.translate(point.x, point.y);
            g.drawPolygon(p);
            if (fillColor != null) {
                g.setColor(fillColor);
                g.fillPolygon(p);
            }
        }

        private void drawIndicationRectangle(Graphics2D g, Rectangle r, Component source, Color fillColor) {
            if (g == null) {
                g = this.getGraphics();
            }
            r = SwingUtilities.convertRectangle(source, r, this.pane);
            g.drawRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
            if (fillColor != null) {
                g.setColor(fillColor);
                g.fillRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
            }
        }

        private void drawIndicationGeneralPath(Graphics2D g, GeneralPath path, Component source, Color fillColor) {
            if (g == null) {
                g = this.getGraphics();
            }
            path = this.getTransformedPath(path, source);
            g.draw(path);
            if (fillColor != null) {
                g.setColor(fillColor);
                g.fill(path);
            }
        }

        private TexturePaint createPaint() {
            BufferedImage image = new BufferedImage(2, 2, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(new Color(255, 90, 0));
            g2.fillRect(0, 0, 1, 1);
            g2.fillRect(1, 1, 1, 1);
            g2.setColor(new Color(255, 90, 0, 0));
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            g2.fillRect(1, 0, 1, 1);
            g2.fillRect(0, 1, 1, 1);
            return new TexturePaint(image, new Rectangle(0, 0, 2, 2));
        }
    }

    static interface Informer {
        public boolean isCopyOperationPossible();

        public Controller getController();

        public Set getFloatingFrames();
    }

    static interface Observer {
        public void setDropSuccess(boolean var1);

        public void setLastDropTarget(DropTargetGlassPane var1);
    }
}

