/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.NbSheet;
import org.netbeans.core.windows.services.FileSelector;
import org.netbeans.core.windows.services.NbPresenter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NodeOperationImpl
extends NodeOperation {
    static /* synthetic */ Class class$org$netbeans$core$windows$services$NodeOperationImpl;

    public void explore(final Node n) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                NonPersistentExplorerTab et = new NonPersistentExplorerTab();
                et.setRootContext(n);
                et.adjustComponentPersistence();
                Mode target = WindowManager.getDefault().findMode("explorer");
                if (target != null) {
                    target.dockInto((TopComponent)et);
                }
                et.open();
                et.requestActive();
            }
        });
    }

    public boolean customize(Node n) {
        final Component customizer = n.getCustomizer();
        if (customizer == null) {
            return false;
        }
        return (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                if (customizer instanceof NbPresenter) {
                    ((NbPresenter)customizer).pack();
                    ((NbPresenter)customizer).show();
                    return Boolean.TRUE;
                }
                if (customizer instanceof Window) {
                    ((Window)customizer).pack();
                    customizer.setVisible(true);
                    return Boolean.TRUE;
                }
                HelpFwdPanel p = null;
                p = customizer instanceof ExplorerManager.Provider ? new ExplorerProviderFwd(customizer, (ExplorerManager.Provider)customizer) : new HelpFwdPanel(customizer);
                p.setLayout(new BorderLayout());
                p.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$services$NodeOperationImpl == null ? (class$org$netbeans$core$windows$services$NodeOperationImpl = NodeOperationImpl.class$("org.netbeans.core.windows.services.NodeOperationImpl")) : class$org$netbeans$core$windows$services$NodeOperationImpl), (String)"CTL_Customizer_dialog_title"));
                if (customizer.getClass().getName().startsWith("org.netbeans.modules.xml.catalog")) {
                    p.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                }
                p.add(customizer, "Center");
                DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage((Class)(class$org$netbeans$core$windows$services$NodeOperationImpl == null ? (class$org$netbeans$core$windows$services$NodeOperationImpl = NodeOperationImpl.class$("org.netbeans.core.windows.services.NodeOperationImpl")) : class$org$netbeans$core$windows$services$NodeOperationImpl), (String)"CTL_Customizer_dialog_title"));
                dd.setOptions(new Object[]{DialogDescriptor.CLOSED_OPTION});
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                dialog.pack();
                dialog.show();
                return Boolean.TRUE;
            }
        });
    }

    public void showProperties(Node n) {
        NbSheet s = new NbSheet();
        Node[] nds = new Node[]{n};
        s.setNodes(nds);
        NodeOperationImpl.openProperties((TopComponent)s, nds);
    }

    public void showProperties(Node[] nodes) {
        NbSheet s = new NbSheet();
        s.setNodes(nodes);
        NodeOperationImpl.openProperties((TopComponent)s, nodes);
    }

    public Node[] select(String title, String rootTitle, Node root, NodeAcceptor acceptor, Component top) throws UserCancelException {
        FileSelector selector = new FileSelector(rootTitle, root, acceptor, top);
        DialogDescriptor dd = new DialogDescriptor((Object)selector, title, true, selector.getOptions(), selector.getSelectOption(), 0, HelpCtx.DEFAULT_HELP, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret != selector.getSelectOption()) {
            throw new UserCancelException();
        }
        return selector.getNodes();
    }

    private static void openProperties(final TopComponent tc, final Node[] nds) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean modal = NbPresenter.currentModalDialog != null;
                Dialog dlg = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)tc, tc.getName(), modal, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null));
                SheetNodesListener listener = new SheetNodesListener(dlg, tc);
                listener.attach(nds);
                dlg.show();
            }
        });
    }

    private static class SheetNodesListener
    extends NodeAdapter
    implements PropertyChangeListener {
        private Dialog dialog;
        private Set listenerSet;
        private TopComponent tc;

        SheetNodesListener(Dialog dialog, TopComponent tc) {
            this.dialog = dialog;
            this.tc = tc;
            tc.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if ("name".equals(pce.getPropertyName())) {
                this.dialog.setTitle((String)pce.getNewValue());
            }
        }

        public void attach(Node[] nodes) {
            this.listenerSet = new HashSet(nodes.length * 2);
            for (int i = 0; i < nodes.length; ++i) {
                this.listenerSet.add(nodes[i]);
                nodes[i].addNodeListener((NodeListener)this);
            }
        }

        public void nodeDestroyed(NodeEvent ev) {
            Node destroyedNode = ev.getNode();
            destroyedNode.removeNodeListener((NodeListener)this);
            this.listenerSet.remove(destroyedNode);
            if (this.listenerSet.isEmpty()) {
                this.tc.removePropertyChangeListener((PropertyChangeListener)this);
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        SheetNodesListener.this.dialog.hide();
                        SheetNodesListener.this.dialog.dispose();
                        SheetNodesListener.this.dialog = null;
                    }
                });
            }
        }
    }

    private static class NonPersistentExplorerTab
    extends NbMainExplorer.ExplorerTab {
        private NonPersistentExplorerTab() {
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "NonPersistentExplorerTab";
        }
    }

    private static final class ExplorerProviderFwd
    extends HelpFwdPanel
    implements ExplorerManager.Provider {
        private ExplorerManager.Provider explProvider;

        private ExplorerProviderFwd(Component innerComp, ExplorerManager.Provider explProvider) {
            super(innerComp);
            this.explProvider = explProvider;
        }

        public ExplorerManager getExplorerManager() {
            return this.explProvider.getExplorerManager();
        }
    }

    private static class HelpFwdPanel
    extends JPanel
    implements HelpCtx.Provider {
        private Component innerComp;
        private boolean active = false;

        private HelpFwdPanel(Component innerComp) {
            this.innerComp = innerComp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HelpCtx getHelpCtx() {
            try {
                if (this.active) {
                    HelpCtx helpCtx = null;
                    return helpCtx;
                }
                this.active = true;
                HelpCtx helpCtx = HelpCtx.findHelp((Component)this.innerComp);
                return helpCtx;
            }
            finally {
                this.active = false;
            }
        }
    }
}

