/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.config.ConfigSupportImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationSupport {
    public abstract void setMappingInfo(DeploymentConfiguration var1, OriginalCMPMapping[] var2);

    public abstract void ensureResourceDefined(DeploymentConfiguration var1, DDBean var2);

    public void ensureResourceDefined(DeploymentConfiguration config, DDBean bean, String jndiName) {
    }

    public abstract String getWebContextRoot(DeploymentConfiguration var1, DeployableObject var2) throws ConfigurationException;

    public abstract void setWebContextRoot(DeploymentConfiguration var1, DeployableObject var2, String var3) throws ConfigurationException;

    public abstract void initConfiguration(DeploymentConfiguration var1, File[] var2, File var3, boolean var4) throws ConfigurationException;

    public abstract void disposeConfiguration(DeploymentConfiguration var1);

    public static final void requestCreateConfiguration(FileObject fo, String serverID) throws ConfigurationException {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            throw new ConfigurationException("File " + FileUtil.toFile((FileObject)fo).getAbsolutePath() + " is not part of any project");
        }
        Lookup l = project.getLookup();
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)l.lookup(J2eeModuleProvider.class);
        if (moduleProvider == null) {
            throw new ConfigurationException("Project " + project + " does not provide J2eeModuleProvider in its lookup");
        }
        Server server = ServerRegistry.getInstance().getServer(serverID);
        ConfigSupportImpl conf = (ConfigSupportImpl)moduleProvider.getConfigSupport();
        conf.createDeploymentConfiguration(server);
    }

    public abstract void updateResourceDir(DeploymentConfiguration var1, File var2);

    public Set<Datasource> getDatasources(DeploymentConfiguration config) {
        return Collections.emptySet();
    }

    public boolean isDatasourceCreationSupported() {
        return false;
    }

    public Datasource createDatasource(DeploymentConfiguration config, String jndiName, String url, String username, String password, String driver) throws OperationUnsupportedException, ConfigurationException, DatasourceAlreadyExistsException {
        throw new OperationUnsupportedException("");
    }
}

