/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerStringConverter
extends DOMConvertor {
    private static final String E_SERVER_STRING = "server-string";
    private static final String E_TARGET = "target";
    private static final String A_PLUGIN = "plugin";
    private static final String A_URL = "url";
    private static final String A_NAME = "name";
    private static final String PUBLIC_ID = "-//org_netbeans_modules_j2ee//DTD ServerString 1.0//EN";
    private static final String SYSTEM_ID = "nbres:/org/netbeans/modules/j2ee/deployment/impl/server-string.dtd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeServerInstance(ServerString instance, String destDir, String destFile) {
        FileLock lock = null;
        Writer writer = null;
        try {
            FileObject dir = Repository.getDefault().getDefaultFileSystem().findResource(destDir);
            FileObject fo = FileUtil.createData((FileObject)dir, (String)destFile);
            lock = fo.lock();
            writer = new OutputStreamWriter(fo.getOutputStream(lock));
            ServerStringConverter.create().write(writer, (Object)instance);
            boolean bl = true;
            return bl;
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerString readServerInstance(String fromDir, String fromFile) {
        Reader reader = null;
        try {
            FileObject dir = Repository.getDefault().getDefaultFileSystem().findResource(fromDir);
            if (dir == null) {
                ServerString serverString = null;
                return serverString;
            }
            FileObject fo = dir.getFileObject(fromFile);
            if (fo == null) {
                ServerString e = null;
                return e;
            }
            reader = new InputStreamReader(fo.getInputStream());
            ServerString e = (ServerString)ServerStringConverter.create().read(reader);
            return e;
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            ServerString serverString = null;
            return serverString;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    public static DOMConvertor create() {
        return new ServerStringConverter();
    }

    protected ServerStringConverter() {
        super(PUBLIC_ID, SYSTEM_ID, E_SERVER_STRING);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        NodeList targetElements = element.getElementsByTagName(E_TARGET);
        String[] targets = new String[targetElements.getLength()];
        for (int i = 0; i < targets.length; ++i) {
            Element te = (Element)targetElements.item(i);
            targets[i] = te.getAttribute(A_NAME);
            if (targets[i] != null) continue;
            throw new IOException(NbBundle.getMessage(ServerStringConverter.class, (String)"MSG_ServerStringParseError", (Object)E_TARGET));
        }
        String plugin = element.getAttribute(A_PLUGIN);
        if (plugin == null) {
            throw new IOException(NbBundle.getMessage(ServerStringConverter.class, (String)"MSG_ServerStringParseError", (Object)A_PLUGIN));
        }
        String url = element.getAttribute(A_URL);
        return new ServerString(plugin, url, targets);
    }

    public void registerSaver(Object inst, Saver s) {
    }

    public void unregisterSaver(Object inst, Saver s) {
    }

    protected void writeElement(Document doc, Element element, Object obj) throws IOException, DOMException {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof ServerString)) {
            throw new DOMException(9, NbBundle.getMessage(ServerStringConverter.class, (String)"MSG_NotSupportedObject", obj.getClass()));
        }
        ServerString ss = (ServerString)obj;
        if (ss.getPlugin() == null) {
            throw new IOException(NbBundle.getMessage(ServerStringConverter.class, (String)"MSG_BadServerString", (Object)ss));
        }
        String[] targets = ss.getTargets();
        if (targets == null) {
            targets = new String[]{};
        }
        for (int i = 0; i < targets.length; ++i) {
            Element targetElement = doc.createElement(E_TARGET);
            targetElement.setAttribute(A_NAME, targets[i]);
            element.appendChild(targetElement);
        }
        String url = ss.getUrl();
        if (url == null) {
            url = "";
        }
        element.setAttribute(A_URL, url);
        element.setAttribute(A_PLUGIN, ss.getPlugin());
    }
}

