/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.netbeans.modules.tasklist.client.SuggestionPriority;

public final class TaskTag
implements Externalizable {
    static final long serialVersionUID = 1L;
    private String token = null;
    private SuggestionPriority priority = SuggestionPriority.MEDIUM;

    public TaskTag() {
    }

    public TaskTag(String token, SuggestionPriority priority) {
        this.token = token;
        this.priority = priority;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void setPriority(SuggestionPriority priority) {
        this.priority = priority;
    }

    public SuggestionPriority getPriority() {
        return this.priority;
    }

    public String toString() {
        return "TaskTag[\"" + this.token + "\", " + this.priority + "]";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int ver = objectInput.read();
        this.token = (String)objectInput.readObject();
        int prioNum = (Integer)objectInput.readObject();
        switch (prioNum) {
            case 1: {
                this.priority = SuggestionPriority.HIGH;
                break;
            }
            case 2: {
                this.priority = SuggestionPriority.MEDIUM_HIGH;
                break;
            }
            case 3: {
                this.priority = SuggestionPriority.MEDIUM;
                break;
            }
            case 4: {
                this.priority = SuggestionPriority.MEDIUM_LOW;
                break;
            }
            case 5: {
                this.priority = SuggestionPriority.LOW;
                break;
            }
            default: {
                this.priority = SuggestionPriority.MEDIUM;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.write(1);
        objectOutput.writeObject(this.token);
        objectOutput.writeObject(new Integer(this.priority.intValue()));
    }
}

