/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

final class JavadocQuery
implements JavadocForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavadocQuery(AntProjectHelper helper, PropertyEvaluator eval, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.eval = eval;
        this.aux = aux;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        Element data = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (data != null) {
            Iterator cus = Util.findSubElements((Element)data).iterator();
            while (cus.hasNext()) {
                Element cu = (Element)cus.next();
                if (!$assertionsDisabled && !cu.getLocalName().equals("compilation-unit")) {
                    throw new AssertionError(cu);
                }
                boolean rightCU = false;
                Iterator builtTos = Util.findSubElements((Element)cu).iterator();
                while (builtTos.hasNext()) {
                    Element builtTo = (Element)builtTos.next();
                    if (!builtTo.getLocalName().equals("built-to")) continue;
                    String rawtext = Util.findText((Element)builtTo);
                    if (!$assertionsDisabled && rawtext == null) {
                        throw new AssertionError();
                    }
                    String evaltext = this.eval.evaluate(rawtext);
                    if (evaltext == null || !this.evalTextToURL(evaltext).equals(binaryRoot)) continue;
                    rightCU = true;
                    break;
                }
                if (!rightCU) continue;
                ArrayList<URL> resultURLs = new ArrayList<URL>();
                Iterator javadocTos = Util.findSubElements((Element)cu).iterator();
                while (javadocTos.hasNext()) {
                    Element javadocTo = (Element)javadocTos.next();
                    if (!javadocTo.getLocalName().equals("javadoc-built-to")) continue;
                    String rawtext = Util.findText((Element)javadocTo);
                    if (!$assertionsDisabled && rawtext == null) {
                        throw new AssertionError();
                    }
                    String evaltext = this.eval.evaluate(rawtext);
                    if (evaltext == null) continue;
                    resultURLs.add(this.evalTextToURL(evaltext));
                }
                return new FixedResult(resultURLs);
            }
        }
        return null;
    }

    private URL evalTextToURL(String evaltext) {
        URL u;
        File location = this.helper.resolveFile(evaltext);
        try {
            u = location.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        if (FileUtil.isArchiveFile((URL)u)) {
            return FileUtil.getArchiveRoot((URL)u);
        }
        String us = u.toExternalForm();
        if (us.endsWith("/")) {
            return u;
        }
        try {
            return new URL(us + '/');
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        $assertionsDisabled = !JavadocQuery.class.desiredAssertionStatus();
    }

    private static final class FixedResult
    implements JavadocForBinaryQuery.Result {
        private final List urls;

        public FixedResult(List urls) {
            this.urls = urls;
        }

        public URL[] getRoots() {
            return this.urls.toArray(new URL[this.urls.size()]);
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

