/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class IntrospectedInfo
implements Serializable {
    private static IntrospectedInfo defaults = null;
    private static boolean defaultsInited = false;
    private static boolean defaultsEverInited = false;
    private static final long serialVersionUID = -2290064038236292995L;
    private Map clazzes = Collections.synchronizedMap(new HashMap());
    private Map namedefs = new HashMap();
    private transient Set listeners = new HashSet(5);
    private transient Set tonotify = new HashSet(5);
    private transient ChangeListener antBridgeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent ev) {
            IntrospectedInfo.this.clearDefs();
            IntrospectedInfo.this.fireStateChanged();
        }
    };
    private transient ChangeListener holder;
    private static IntrospectedInfo merged;

    public static synchronized IntrospectedInfo getDefaults() {
        if (defaults == null) {
            defaults = new IntrospectedInfo();
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Class clazz = IntrospectedInfo.class;
        synchronized (clazz) {
            if (!defaultsInited && this == defaults) {
                AntModule.err.log("IntrospectedInfo.getDefaults: loading...");
                defaultsInited = true;
                this.loadDefaults(!defaultsEverInited);
                defaultsEverInited = true;
            }
        }
    }

    private void clearDefs() {
        this.clazzes.clear();
        this.namedefs.clear();
        defaultsInited = false;
    }

    private void loadDefaults(boolean listen) {
        ClassLoader cl = AntBridge.getMainClassLoader();
        InputStream taskDefaults = cl.getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties");
        if (taskDefaults != null) {
            try {
                defaults.load(taskDefaults, "task", cl);
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not load default taskdefs");
                AntModule.err.notify((Throwable)ioe);
            }
        } else {
            AntModule.err.log("Could not open default taskdefs");
        }
        InputStream typeDefaults = cl.getResourceAsStream("org/apache/tools/ant/types/defaults.properties");
        if (typeDefaults != null) {
            try {
                defaults.load(typeDefaults, "type", cl);
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not load default typedefs");
                AntModule.err.notify((Throwable)ioe);
            }
        } else {
            AntModule.err.log("Could not open default typedefs");
        }
        defaults.loadNetBeansSpecificDefinitions();
        if (listen) {
            AntBridge.addChangeListener(WeakListeners.change((ChangeListener)this.antBridgeListener, (Object)AntBridge.class));
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.defaults=" + defaults);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.listeners = new HashSet(5);
        this.tonotify = new HashSet(5);
        ObjectInputStream.GetField fields = is.readFields();
        this.clazzes = (Map)fields.get("clazzes", null);
        this.namedefs = (Map)fields.get("namedefs", null);
        if (this.namedefs == null) {
            AntModule.err.log("#15739: reading old version of IntrospectedInfo");
            this.namedefs = new HashMap();
            Object tasks_ = fields.get("tasks", null);
            if (tasks_ == null) {
                throw new NullPointerException();
            }
            if (!(tasks_ instanceof Map)) {
                throw new ClassCastException(tasks_.toString());
            }
            this.namedefs.put("task", tasks_);
            Map types = (Map)fields.get("types", null);
            if (types == null) {
                throw new NullPointerException();
            }
            this.namedefs.put("type", types);
        }
        Iterator it = this.namedefs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            Iterator it2 = value.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                String key2 = (String)entry2.getKey();
                String value2 = (String)entry2.getValue();
            }
        }
        Iterator it2 = this.clazzes.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry2 = it2.next();
            String key2 = (String)entry2.getKey();
            IntrospectedClass value2 = (IntrospectedClass)entry2.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.fireStateChanged");
        }
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            if (this.tonotify.isEmpty()) {
                RequestProcessor.getDefault().post((Runnable)new ChangeTask());
            }
            this.tonotify.addAll(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDefs(String kind) {
        this.init();
        Map map = this.namedefs;
        synchronized (map) {
            Map m = (Map)this.namedefs.get(kind);
            if (m != null) {
                return Collections.unmodifiableMap(m);
            }
            return Collections.EMPTY_MAP;
        }
    }

    private IntrospectedClass getData(String clazz) throws IllegalArgumentException {
        IntrospectedClass data = (IntrospectedClass)this.clazzes.get(clazz);
        if (data == null) {
            throw new IllegalArgumentException("Unknown class: " + clazz);
        }
        return data;
    }

    public boolean isKnown(String clazz) {
        this.init();
        return this.clazzes.get(clazz) != null;
    }

    public boolean supportsText(String clazz) throws IllegalArgumentException {
        this.init();
        return this.getData((String)clazz).supportsText;
    }

    public Map getAttributes(String clazz) throws IllegalArgumentException {
        this.init();
        Map map = this.getData((String)clazz).attrs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public Map getElements(String clazz) throws IllegalArgumentException {
        this.init();
        Map map = this.getData((String)clazz).subs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public String[] getTags(String clazz) throws IllegalArgumentException {
        this.init();
        return this.getData((String)clazz).enumTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream is, String kind, ClassLoader cl) throws IOException {
        Properties p = new Properties();
        try {
            p.load(is);
        }
        finally {
            is.close();
        }
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String name = (String)entry.getKey();
            if (kind.equals("type") && name.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            String clazzname = (String)entry.getValue();
            try {
                Class<?> clazz = cl.loadClass(clazzname);
                this.register(name, clazz, kind, false);
            }
            catch (ClassNotFoundException cnfe) {
                AntModule.err.log("IntrospectedInfo: skipping " + clazzname + ": " + cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                AntModule.err.log("IntrospectedInfo: skipping " + clazzname + ": " + ncdfe);
            }
            catch (LinkageError e) {
                IOException ioe = new IOException("Could not load class " + clazzname + ": " + e);
                AntModule.err.annotate((Throwable)ioe, (Throwable)e);
                throw ioe;
            }
            catch (RuntimeException e) {
                IOException ioe = new IOException("Could not load class " + clazzname + ": " + e);
                AntModule.err.annotate((Throwable)ioe, (Throwable)e);
                throw ioe;
            }
        }
    }

    private void loadNetBeansSpecificDefinitions() {
        this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsNoNamespace());
        if (AntBridge.getInterface().isAnt16()) {
            this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsWithNamespace());
        }
    }

    private void loadNetBeansSpecificDefinitions0(Map defsByKind) {
        Iterator kindIt = defsByKind.entrySet().iterator();
        while (kindIt.hasNext()) {
            Map.Entry kindE = kindIt.next();
            String kind = (String)kindE.getKey();
            Map defs = (Map)kindE.getValue();
            Iterator defsIt = defs.entrySet().iterator();
            while (defsIt.hasNext()) {
                Map.Entry defsE = defsIt.next();
                String name = (String)defsE.getKey();
                Class clazz = (Class)defsE.getValue();
                this.register(name, clazz, kind);
            }
        }
    }

    public synchronized void register(String name, Class clazz, String kind) {
        this.register(name, clazz, kind, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String name, Class clazz, String kind, boolean fire) {
        this.init();
        Map map = this.namedefs;
        synchronized (map) {
            HashMap<String, String> m = (HashMap<String, String>)this.namedefs.get(kind);
            if (m == null) {
                m = new HashMap<String, String>();
                this.namedefs.put(kind, m);
            }
            m.put(name, clazz.getName());
        }
        boolean changed = this.analyze(clazz, null, false);
        if (changed && fire) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String name, String kind) {
        this.init();
        Map map = this.namedefs;
        synchronized (map) {
            Map m = (Map)this.namedefs.get(kind);
            if (m != null) {
                m.remove(name);
            }
        }
        this.fireStateChanged();
    }

    private boolean analyze(Class clazz, Set skipReanalysis, boolean isAttrType) {
        String n = clazz.getName();
        if (IntrospectedInfo.getDefaults().isKnown(n)) {
            return false;
        }
        if ((skipReanalysis == null || !skipReanalysis.add(clazz)) && this.isKnown(n)) {
            return false;
        }
        IntrospectedClass info = new IntrospectedClass();
        if (isAttrType) {
            String[] enumTags = AntBridge.getInterface().getEnumeratedValues(clazz);
            if (enumTags != null) {
                info.enumTags = enumTags;
                return !info.equals(this.clazzes.put(clazz.getName(), info));
            }
            return this.clazzes.remove(clazz.getName()) != null;
        }
        IntrospectionHelperProxy helper = AntBridge.getInterface().getIntrospectionHelper(clazz);
        info.supportsText = helper.supportsCharacters();
        Enumeration e = helper.getAttributes();
        HashSet<Class> nueAttrTypeClazzes = new HashSet<Class>();
        if (e.hasMoreElements()) {
            info.attrs = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    Class attrType = helper.getAttributeType(name);
                    String type = attrType.getName();
                    if (IntrospectedInfo.hasSuperclass(clazz, "org.apache.tools.ant.Task") && (name.equals("location") && type.equals("org.apache.tools.ant.Location") || name.equals("taskname") && type.equals("java.lang.String") || name.equals("description") && type.equals("java.lang.String"))) continue;
                    info.attrs.put(name, type);
                    nueAttrTypeClazzes.add(attrType);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify(1, (Throwable)re);
                }
            }
        } else {
            info.attrs = null;
        }
        HashSet<Class> nueClazzes = new HashSet<Class>();
        e = helper.getNestedElements();
        if (e.hasMoreElements()) {
            info.subs = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    Class subclazz = helper.getElementType(name);
                    info.subs.put(name, subclazz.getName());
                    nueClazzes.add(subclazz);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify(1, (Throwable)re);
                }
            }
        } else {
            info.subs = null;
        }
        boolean changed = !info.equals(this.clazzes.put(clazz.getName(), info));
        Iterator it = nueClazzes.iterator();
        while (it.hasNext()) {
            changed |= this.analyze((Class)it.next(), skipReanalysis, false);
        }
        it = nueAttrTypeClazzes.iterator();
        while (it.hasNext()) {
            changed |= this.analyze((Class)it.next(), skipReanalysis, true);
        }
        return changed;
    }

    private static boolean hasSuperclass(Class subclass, String superclass) {
        for (Class c = subclass; c != null; c = c.getSuperclass()) {
            if (!c.getName().equals(superclass)) continue;
            return true;
        }
        return false;
    }

    public void scanProject(Map defs) {
        this.init();
        Iterator it = defs.entrySet().iterator();
        HashSet skipReanalysis = new HashSet();
        boolean changed = false;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            changed |= this.scanMap((Map)e.getValue(), (String)e.getKey(), skipReanalysis);
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.scanProject: " + this);
        }
        if (changed) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanMap(Map m, String kind, Set skipReanalysis) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            if (kind.equals("type") && name.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            Class clazz = (Class)entry.getValue();
            HashMap<String, String> registry = (HashMap<String, String>)this.namedefs.get(kind);
            if (registry == null) {
                registry = new HashMap<String, String>();
                this.namedefs.put(kind, registry);
            }
            IntrospectedInfo introspectedInfo = this;
            synchronized (introspectedInfo) {
                Map defaults = IntrospectedInfo.getDefaults().getDefs(kind);
                if (defaults.get(name) == null) {
                    changed |= !clazz.getName().equals(registry.put(name, clazz.getName()));
                }
                if (!IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
                    try {
                        changed |= this.analyze(clazz, skipReanalysis, false);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        AntModule.err.log("Skipping " + clazz.getName() + ": " + ncdfe);
                    }
                    catch (LinkageError e) {
                        AntModule.err.annotate((Throwable)e, 1, "Cannot scan class " + clazz.getName(), null, null, null);
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
            }
        }
        return changed;
    }

    public String toString() {
        return "IntrospectedInfo[namedefs=" + this.namedefs + ",clazzes=" + this.clazzes + "]";
    }

    private static IntrospectedInfo merge(IntrospectedInfo[] proxied) {
        ChangeListener l;
        final IntrospectedInfo ii = new IntrospectedInfo();
        ii.holder = l = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                IntrospectedInfo ii2 = (IntrospectedInfo)ev.getSource();
                ii2.init();
                ii.clazzes.putAll(ii2.clazzes);
                Iterator it = ii2.namedefs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    String kind = (String)e.getKey();
                    Map entries = (Map)e.getValue();
                    if (ii.namedefs.containsKey(kind)) {
                        ((Map)ii.namedefs.get(kind)).putAll(entries);
                        continue;
                    }
                    ii.namedefs.put(kind, new HashMap(entries));
                }
                ii.fireStateChanged();
            }
        };
        for (int i = 0; i < proxied.length; ++i) {
            proxied[i].addChangeListener(WeakListeners.change((ChangeListener)l, (Object)proxied[i]));
            l.stateChanged(new ChangeEvent(proxied[i]));
        }
        return ii;
    }

    public static synchronized IntrospectedInfo getKnownInfo() {
        if (merged == null) {
            merged = IntrospectedInfo.merge(new IntrospectedInfo[]{IntrospectedInfo.getDefaults(), AntSettings.getDefault().getCustomDefs()});
        }
        return merged;
    }

    private static final class IntrospectedClass
    implements Serializable {
        private static final long serialVersionUID = 4039297397834774403L;
        public boolean supportsText;
        public Map attrs;
        public Map subs;
        public String[] enumTags;

        private IntrospectedClass() {
        }

        public String toString() {
            String tags = this.enumTags != null ? Arrays.asList((Object[])this.enumTags).toString() : "null";
            return "IntrospectedClass[text=" + this.supportsText + ",attrs=" + this.attrs + ",subs=" + this.subs + ",enumTags=" + tags + "]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntrospectedClass)) {
                return false;
            }
            IntrospectedClass other = (IntrospectedClass)o;
            return this.supportsText == other.supportsText && Utilities.compareObjects((Object)this.attrs, (Object)other.attrs) && Utilities.compareObjects((Object)this.subs, (Object)other.subs) && Utilities.compareObjects((Object)this.enumTags, (Object)other.enumTags);
        }
    }

    private class ChangeTask
    implements Runnable {
        private ChangeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ChangeListener[] listeners2;
            Set set = IntrospectedInfo.this.listeners;
            synchronized (set) {
                if (IntrospectedInfo.this.tonotify.isEmpty()) {
                    return;
                }
                listeners2 = IntrospectedInfo.this.tonotify.toArray(new ChangeListener[IntrospectedInfo.this.tonotify.size()]);
                IntrospectedInfo.this.tonotify.clear();
            }
            ChangeEvent ev = new ChangeEvent(IntrospectedInfo.this);
            for (int i = 0; i < listeners2.length; ++i) {
                listeners2[i].stateChanged(ev);
            }
        }
    }
}

