/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.maplocator;

import com.sun.j2ee.blueprints.ui.maplocator.GeoCoder;
import com.sun.j2ee.blueprints.ui.maplocator.MapLocatorComponent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class MapLocatorRenderer
extends Renderer {
    static int nextId = 0;
    private static final String RENDERED_SCRIPT_KEY = "bpcatalog-ajax-script-maplocator";
    private static final String PROXY_HOST = "com.sun.faces.proxyHost";
    private static final String PROXY_PORT = "com.sun.faces.proxyPort";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        String proxyHost = context.getExternalContext().getInitParameter(PROXY_HOST);
        String proxyPort = context.getExternalContext().getInitParameter(PROXY_PORT);
        String clientId = component.getClientId(context);
        MapLocatorComponent mapLocator = (MapLocatorComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        String style = mapLocator.getStyle();
        if (null != style) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (null != (styleClass = mapLocator.getStyleClass())) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderScriptOnce(writer, component, context);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String idScript = "g_map_id = \"" + clientId + "\";";
        idScript = idScript + "g_search_id = \"searchId\";";
        idScript = idScript + "g_message_id = \"msgId\";";
        idScript = idScript + "g_select_id = \"selectId\";";
        writer.writeText((Object)idScript, null);
        writer.endElement("script");
        writer.write("\n");
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String srcInfo = "http://maps.google.com/maps?file=api&v=1&key=" + mapLocator.getKey();
        writer.writeAttribute("src", (Object)srcInfo, null);
        writer.endElement("script");
        writer.write("\n");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)"searchId", null);
        writer.endElement("div");
        writer.write("\n");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)"msgId", null);
        writer.endElement("div");
        writer.write("\n");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)"selectId", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.endElement("div");
        writer.write("\n");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, null);
        String styleInfo = "width: " + mapLocator.getWidth() + "px; height: " + mapLocator.getHeight() + "px";
        writer.writeAttribute("style", (Object)styleInfo, null);
        writer.endElement("div");
        writer.write("\n");
        Object location = mapLocator.getLocation();
        String locationStr = null;
        Object[] locationArray = null;
        String result = null;
        if (location != null) {
            if (location instanceof String && (locationStr = (String)location) != null) {
                try {
                    result = GeoCoder.locate(proxyHost, proxyPort, locationStr);
                    writer.startElement("script", component);
                    writer.writeAttribute("type", (Object)"text/javascript", null);
                    String initialLocation = "g_initial_location = '" + result + "';";
                    writer.writeText((Object)initialLocation, null);
                    writer.endElement("script");
                    writer.write("\n");
                }
                catch (IOException ioe) {
                    writer.startElement("script", component);
                    writer.writeAttribute("type", (Object)"text/javascript", null);
                    String msg = "g_message = '" + ioe.getMessage() + "';";
                    writer.writeText((Object)msg, null);
                    writer.endElement("script");
                    writer.write("\n");
                }
            }
            if (location instanceof List) {
                locationArray = ((List)location).toArray();
                String currentResult = null;
                for (int i = 0; i < Array.getLength(locationArray); ++i) {
                    try {
                        currentResult = GeoCoder.locate(proxyHost, proxyPort, (String)Array.get(locationArray, i));
                    }
                    catch (IOException ioe) {
                        writer.startElement("script", component);
                        writer.writeAttribute("type", (Object)"text/javascript", null);
                        String msg = "g_message = '" + ioe.getMessage() + "';";
                        writer.writeText((Object)msg, null);
                        writer.endElement("script");
                        writer.write("\n");
                        return;
                    }
                    if (i == 0) {
                        writer.startElement("script", component);
                        writer.writeAttribute("type", (Object)"text/javascript", null);
                    }
                    String initialLocations = "g_initial_locations[" + i + "] = " + "'" + currentResult + "';";
                    writer.writeText((Object)initialLocations, null);
                    if (i != Array.getLength(locationArray) - 1) continue;
                    writer.endElement("script");
                    writer.write("\n");
                }
            }
        }
        writer.endElement("div");
        writer.write("\n");
    }

    private void renderScriptOnce(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean scriptRendered = (Boolean)requestMap.get(RENDERED_SCRIPT_KEY);
        if (scriptRendered == Boolean.TRUE) {
            return;
        }
        requestMap.put(RENDERED_SCRIPT_KEY, Boolean.TRUE);
        writer.write("\n");
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String ssrc = "faces/ajax-maplocator-script.js";
        writer.writeAttribute("src", (Object)ssrc, null);
        writer.endElement("script");
        writer.write("\n");
        writer.startElement("body", component);
        writer.writeAttribute("onload", (Object)"load()", null);
        writer.endElement("body");
        writer.write("\n");
        writer.write("\n");
    }
}

