/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.DefaultItem;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.Item;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.openide.ErrorManager;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;

public class DefaultCategory
implements Category,
NodeListener {
    private Node categoryNode;
    private ArrayList categoryListeners = new ArrayList(3);
    private Item[] items;

    public DefaultCategory(Node categoryNode) {
        this.categoryNode = categoryNode;
        this.categoryNode.addNodeListener((NodeListener)this);
        this.categoryNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DefaultCategory.this.notifyListeners();
            }
        });
    }

    public Image getIcon(int type) {
        return this.categoryNode.getIcon(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryListener(CategoryListener listener) {
        ArrayList arrayList = this.categoryListeners;
        synchronized (arrayList) {
            this.categoryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategoryListener(CategoryListener listener) {
        ArrayList arrayList = this.categoryListeners;
        synchronized (arrayList) {
            this.categoryListeners.remove(listener);
        }
    }

    public Action[] getActions() {
        return this.categoryNode.getActions(false);
    }

    public String getShortDescription() {
        return this.categoryNode.getShortDescription();
    }

    public Item[] getItems() {
        if (null == this.items) {
            Node[] children = this.categoryNode.getChildren().getNodes(DefaultModel.canBlock());
            this.items = new Item[children.length];
            for (int i = 0; i < children.length; ++i) {
                this.items[i] = new DefaultItem(children[i]);
            }
        }
        return this.items;
    }

    public String getName() {
        return this.categoryNode.getName();
    }

    public String getDisplayName() {
        return this.categoryNode.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        CategoryListener[] listeners;
        ArrayList arrayList = this.categoryListeners;
        synchronized (arrayList) {
            listeners = new CategoryListener[this.categoryListeners.size()];
            listeners = (CategoryListener[])this.categoryListeners.toArray((Object[])listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].categoryModified(this);
        }
    }

    public void childrenAdded(NodeMemberEvent ev) {
        this.items = null;
        this.notifyListeners();
    }

    public void childrenRemoved(NodeMemberEvent ev) {
        this.items = null;
        this.notifyListeners();
    }

    public void childrenReordered(NodeReorderEvent ev) {
        this.items = null;
        this.notifyListeners();
    }

    public void nodeDestroyed(NodeEvent ev) {
        this.categoryNode.removeNodeListener((NodeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("displayName".equals(evt.getPropertyName())) {
            this.notifyListeners();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultCategory)) {
            return false;
        }
        return this.categoryNode.equals((Object)((DefaultCategory)obj).categoryNode);
    }

    public Transferable getTransferable() {
        try {
            return this.categoryNode.drag();
        }
        catch (IOException ioE) {
            ErrorManager.getDefault().notify(1, (Throwable)ioE);
            return null;
        }
    }

    public Lookup getLookup() {
        return this.categoryNode.getLookup();
    }

    private int itemToIndex(Item item) {
        Index order;
        if (null == item) {
            return -1;
        }
        Node node = (Node)item.getLookup().lookup(Node.class);
        if (null != node && null != (order = (Index)this.categoryNode.getCookie(Index.class))) {
            return order.indexOf(node);
        }
        return -1;
    }

    public boolean dragOver(DropTargetDragEvent e) {
        DragAndDropHandler handler = this.getDragAndDropHandler();
        return handler.canDrop(this.getLookup(), e.getCurrentDataFlavors(), e.getDropAction());
    }

    public boolean dropItem(Transferable dropItem, int dndAction, Item target, boolean dropBefore) {
        int targetIndex = this.itemToIndex(target);
        if (!dropBefore) {
            ++targetIndex;
        }
        DragAndDropHandler handler = this.getDragAndDropHandler();
        boolean res = handler.doDrop(this.getLookup(), dropItem, dndAction, targetIndex);
        this.items = null;
        return res;
    }

    private DragAndDropHandler getDragAndDropHandler() {
        return (DragAndDropHandler)this.categoryNode.getLookup().lookup(DragAndDropHandler.class);
    }

    public String toString() {
        return this.categoryNode.getDisplayName();
    }
}

