/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Action;
import org.netbeans.modules.palette.ItemNode;
import org.netbeans.modules.palette.Utils;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

class CategoryNode
extends FilterNode {
    static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    static final String CAT_NAME = "categoryName";
    private Action[] actions;
    static /* synthetic */ Class class$org$netbeans$spi$palette$PaletteFilter;

    CategoryNode(Node originalNode, Lookup lkp) {
        this(originalNode, new InstanceContent(), lkp);
    }

    private CategoryNode(Node originalNode, InstanceContent content, Lookup lkp) {
        super(originalNode, (org.openide.nodes.Children)new Children(originalNode, lkp), (Lookup)new ProxyLookup(new Lookup[]{lkp, new AbstractLookup((AbstractLookup.Content)content), originalNode.getLookup()}));
        DataFolder folder = (DataFolder)originalNode.getCookie(DataFolder.class);
        if (null != folder) {
            content.add((Object)new DataFolder.Index(folder, (Node)this));
            FileObject fob = folder.getPrimaryFile();
            Object catName = fob.getAttribute(CAT_NAME);
            if (catName instanceof String) {
                this.setName((String)catName, false);
            }
        }
        content.add((Object)this);
    }

    public String getDisplayName() {
        Node origNode;
        DataObject dobj;
        DataShadow shadow;
        String retValue = super.getDisplayName();
        if (null != retValue && retValue.indexOf("\u2192") > 0 && null != (shadow = (DataShadow)this.getCookie(DataShadow.class)) && null != (dobj = shadow.getOriginal()) && null != (origNode = dobj.getNodeDelegate()) && null != origNode.getDisplayName()) {
            retValue = origNode.getDisplayName();
        }
        return retValue;
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public void setName(String name, boolean rename) {
        if (rename) {
            if (!CategoryNode.checkCategoryName(this.getParentNode(), name, (Node)this)) {
                return;
            }
            try {
                DataFolder folder = (DataFolder)this.getCookie(DataFolder.class);
                if (null != folder) {
                    FileObject fo = folder.getPrimaryFile();
                    String folderName = CategoryNode.convertCategoryToFolderName(fo.getParent(), name, fo.getName());
                    fo.setAttribute(CAT_NAME, null);
                    folder.rename(folderName);
                    if (!folderName.equals(name)) {
                        fo.setAttribute(CAT_NAME, (Object)name);
                    }
                }
            }
            catch (IOException ex) {
                IllegalArgumentException e = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
                throw e;
            }
        }
        super.setName(name);
    }

    public String getShortDescription() {
        return this.getDisplayName();
    }

    public Action[] getActions(boolean context) {
        PaletteActions customActions;
        if (this.actions == null) {
            this.actions = new Action[]{new Utils.PasteItemAction((Node)this), null, new Utils.NewCategoryAction(this.getParentNode()), null, new Utils.DeleteCategoryAction((Node)this), new Utils.RenameCategoryAction((Node)this), null, new Utils.SortItemsAction((Node)this), null, new Utils.SortCategoriesAction(this.getParentNode()), null, new Utils.RefreshPaletteAction()};
        }
        if (null != (customActions = (PaletteActions)this.getParentNode().getLookup().lookup(PaletteActions.class))) {
            return Utils.mergeActions(this.actions, customActions.getCustomCategoryActions(this.getLookup()));
        }
        return this.actions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    public boolean canDestroy() {
        return !Utils.isReadonly(this.getOriginal());
    }

    public HelpCtx getHelpCtx() {
        String helpId;
        HelpCtx retValue = super.getHelpCtx();
        if ((null == retValue || HelpCtx.DEFAULT_HELP.equals((Object)retValue)) && null != (helpId = Utils.getHelpId((Node)this))) {
            retValue = new HelpCtx(helpId);
        }
        return retValue;
    }

    static boolean checkCategoryName(Node parentNode, String name, Node namedNode) {
        boolean invalid = false;
        if (name == null || "".equals(name)) {
            invalid = true;
        } else {
            int n = name.length();
            for (int i = 0; i < n; ++i) {
                char ch = name.charAt(i);
                if (ch == '.' || ch == ' ' && i + 1 == n) {
                    invalid = true;
                    break;
                }
                if (ch != ' ') break;
            }
        }
        if (invalid) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(Utils.getBundleString("ERR_InvalidName"), name), 1));
            return false;
        }
        Node[] nodes = parentNode.getChildren().getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!name.equals(nodes[i].getName()) || nodes[i] == namedNode) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(Utils.getBundleString("FMT_CategoryExists"), name), 1));
            return false;
        }
        return true;
    }

    static String convertCategoryToFolderName(FileObject paletteFO, String name, String currentName) {
        int i;
        if (name == null || "".equals(name)) {
            return null;
        }
        int n = name.length();
        StringBuffer nameBuff = new StringBuffer(n);
        char ch = name.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            nameBuff.append(ch);
            i = 1;
        } else {
            nameBuff.append('_');
            i = 0;
        }
        while (i < n) {
            ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                nameBuff.append(ch);
            }
            ++i;
        }
        String fName = nameBuff.toString();
        if ("_".equals(fName)) {
            fName = "Category";
        }
        if (fName.equals(currentName)) {
            return fName;
        }
        String freeName = null;
        boolean nameOK = false;
        i = 0;
        while (!nameOK) {
            String string = freeName = i > 0 ? fName + "_" + i : fName;
            if (Utilities.isWindows()) {
                nameOK = true;
                Enumeration en = paletteFO.getChildren(false);
                while (en.hasMoreElements()) {
                    FileObject fo = (FileObject)en.nextElement();
                    String fn = fo.getName();
                    String fe = fo.getExt();
                    if (fe != null && !"".equals(fe) || !fn.equalsIgnoreCase(freeName)) continue;
                    nameOK = false;
                    break;
                }
            } else {
                nameOK = paletteFO.getFileObject(freeName) == null;
            }
            ++i;
        }
        return freeName;
    }

    private static class Children
    extends FilterNode.Children {
        private Lookup lkp;
        private PaletteFilter filter;

        public Children(Node original, Lookup lkp) {
            super(original);
            this.lkp = lkp;
            this.filter = (PaletteFilter)lkp.lookup(class$org$netbeans$spi$palette$PaletteFilter == null ? (class$org$netbeans$spi$palette$PaletteFilter = CategoryNode.class$("org.netbeans.spi.palette.PaletteFilter")) : class$org$netbeans$spi$palette$PaletteFilter);
        }

        protected Node copyNode(Node node) {
            return new ItemNode(node);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            if (null == this.filter || this.filter.isValidItem(n.getLookup())) {
                return new Node[]{this.copyNode(n)};
            }
            return null;
        }

        public void resultChanged(LookupEvent ev) {
            Object[] nodes = this.original.getChildren().getNodes();
            this.setKeys(Collections.EMPTY_LIST);
            this.setKeys(nodes);
        }
    }
}

