/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.ProxyLookup;

final class NbEditorToolBar
extends JToolBar
implements SettingsChangeListener {
    private static final boolean debugSort;
    private static final String TOOLBARS_FOLDER_NAME = "Toolbars";
    private static final String DEFAULT_TOOLBAR_NAME = "Default";
    static final String BASE_MIME_TYPE = "text/base";
    private static final Insets BUTTON_INSETS;
    FileChangeListener moduleRegListener;
    private static final Runnable returnFocusRunnable;
    private static final ActionListener sharedActionListener;
    private static final MouseListener sharedMouseListener;
    private Reference componentRef;
    private boolean presentersAdded;
    private boolean addListener = true;
    private static final String NOOP_ACTION_KEY = "noop-action-key";
    private static final Action NOOP_ACTION;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$javax$swing$JSeparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    NbEditorToolBar(JTextComponent component) {
        this.componentRef = new WeakReference<JTextComponent>(component);
        this.setFloatable(false);
        this.addMouseListener(sharedMouseListener);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        this.installModulesInstallationListener();
        this.installNoOpActionMappings();
    }

    private void installNoOpActionMappings() {
        int i;
        InputMap im = this.getInputMap(1);
        KeyStroke[] keys = this.findEditorKeys("cut-to-clipboard", KeyStroke.getKeyStroke(88, 2));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        keys = this.findEditorKeys("copy-to-clipboard", KeyStroke.getKeyStroke(67, 2));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        keys = this.findEditorKeys("delete-next", KeyStroke.getKeyStroke(127, 0));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        keys = this.findEditorKeys("paste-from-clipboard", KeyStroke.getKeyStroke(86, 2));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        this.getActionMap().put(NOOP_ACTION_KEY, NOOP_ACTION);
    }

    private void installModulesInstallationListener() {
        this.moduleRegListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (AllOptionsFolder.getDefault().isToolbarVisible()) {
                            NbEditorToolBar.this.checkPresentersRemoved();
                            NbEditorToolBar.this.checkPresentersAdded();
                        }
                    }
                };
                Utilities.runInEventDispatchThread((Runnable)r);
            }
        };
        FileObject moduleRegistry = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
        if (moduleRegistry != null) {
            moduleRegistry.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.moduleRegListener, (Object)moduleRegistry));
        }
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    public String getName() {
        return "editorToolbar";
    }

    public void setUI(ToolBarUI ui) {
        this.addListener = false;
        super.setUI(ui);
        this.addListener = true;
    }

    public synchronized void addMouseListener(MouseListener l) {
        if (this.addListener) {
            super.addMouseListener(l);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (this.addListener) {
            super.addMouseMotionListener(l);
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        final boolean visible = NbEditorToolBar.isToolBarVisible();
        JTextComponent c = this.getComponent();
        final boolean keyBindingsChanged = evt != null && "key-bindings".equals(evt.getSettingName()) && c != null && evt.getKitClass() == Utilities.getKitClass((JTextComponent)c);
        Runnable r = new Runnable(){

            public void run() {
                if (visible) {
                    NbEditorToolBar.this.checkPresentersAdded();
                    if (keyBindingsChanged) {
                        NbEditorToolBar.this.installNoOpActionMappings();
                        int componentCount = NbEditorToolBar.this.getComponentCount();
                        Map keybsMap = NbEditorToolBar.this.getKeyBindingMap();
                        Component[] comps = NbEditorToolBar.this.getComponents();
                        for (int i = 0; i < comps.length; ++i) {
                            MultiKeyBinding mkb;
                            int index;
                            String actionName;
                            JButton button;
                            Action action;
                            Component comp = comps[i];
                            if (!(comp instanceof JButton) || (action = (button = (JButton)comp).getAction()) == null || (actionName = (String)action.getValue("Name")) == null) continue;
                            String tooltipText = button.getToolTipText();
                            if (tooltipText != null && (index = tooltipText.indexOf("(")) > 0) {
                                tooltipText = tooltipText.substring(0, index - 1);
                            }
                            if ((mkb = (MultiKeyBinding)keybsMap.get(actionName)) != null) {
                                button.setToolTipText(tooltipText + " (" + NbEditorToolBar.getMnemonic(mkb) + ")");
                                continue;
                            }
                            button.setToolTipText(tooltipText);
                        }
                    }
                } else {
                    NbEditorToolBar.this.checkPresentersRemoved();
                }
                NbEditorToolBar.this.setVisible(visible);
            }
        };
        Utilities.runInEventDispatchThread((Runnable)r);
    }

    private void checkPresentersAdded() {
        if (!this.presentersAdded) {
            this.presentersAdded = true;
            DataFolder baseFolder = NbEditorToolBar.getToolBarFolder(BASE_MIME_TYPE, false);
            DataFolder mimeFolder = NbEditorToolBar.getToolBarFolder(this.getMimeType(), false);
            this.addPresenters(baseFolder, mimeFolder);
        }
    }

    private void checkPresentersRemoved() {
        this.presentersAdded = false;
        this.removeAll();
    }

    private static DataFolder getToolBarFolder(String type, boolean forceCreate) {
        String toolbarFolderPath = "Editors/" + type + "/" + TOOLBARS_FOLDER_NAME + "/" + DEFAULT_TOOLBAR_NAME;
        DataFolder toolbarFolder = null;
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(toolbarFolderPath);
        if (f != null) {
            try {
                DataObject dob = DataObject.find((FileObject)f);
                toolbarFolder = (DataFolder)dob.getCookie(DataFolder.class);
            }
            catch (DataObjectNotFoundException e) {}
        } else if (forceCreate) {
            try {
                FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)toolbarFolderPath);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }
        return toolbarFolder;
    }

    private static boolean isToolBarVisible() {
        return AllOptionsFolder.getDefault().isToolbarVisible();
    }

    private String getMimeType() {
        JTextComponent c = this.getComponent();
        BaseKit kit = c != null ? Utilities.getKit((JTextComponent)c) : null;
        String mimeType = kit != null ? kit.getContentType() : null;
        return mimeType;
    }

    private static String getMnemonic(MultiKeyBinding binding) {
        StringBuffer sb = new StringBuffer();
        if (binding.keys != null) {
            for (int i = 0; i < binding.keys.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(NbEditorToolBar.getKeyMnemonic(binding.keys[i]));
            }
        } else {
            sb.append(NbEditorToolBar.getKeyMnemonic(binding.key));
        }
        return sb.toString();
    }

    private static String getKeyMnemonic(KeyStroke key) {
        int i;
        String sk = org.openide.util.Utilities.keyToString((KeyStroke)key);
        StringBuffer sb = new StringBuffer();
        int mods = key.getModifiers();
        if ((mods & 2) != 0) {
            sb.append("Ctrl+");
        }
        if ((mods & 8) != 0) {
            sb.append("Alt+");
        }
        if ((mods & 1) != 0) {
            sb.append("Shift+");
        }
        if ((mods & 4) != 0) {
            sb.append("Meta+");
        }
        if ((i = sk.indexOf(45)) != -1) {
            sk = sk.substring(i + 1);
        }
        sb.append(sk);
        return sb.toString();
    }

    private Map getKeyBindingMap() {
        HashMap<String, MultiKeyBinding> retMap = new HashMap<String, MultiKeyBinding>();
        List keybList = this.getKeyBindingList();
        Iterator it = keybList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof MultiKeyBinding)) continue;
            MultiKeyBinding keyb = (MultiKeyBinding)obj;
            retMap.put(keyb.actionName, keyb);
        }
        return retMap;
    }

    private List getKeyBindingList() {
        JTextComponent c;
        BaseKit kit;
        List gkbl;
        ArrayList keyBindingsList = new ArrayList();
        AllOptionsFolder aof = AllOptionsFolder.getDefault();
        if (aof != null && (gkbl = aof.getKeyBindingList()) != null) {
            keyBindingsList.addAll(gkbl);
        }
        BaseKit baseKit = kit = (c = this.getComponent()) != null ? Utilities.getKit((JTextComponent)c) : null;
        if (kit instanceof BaseKit) {
            List kbl;
            BaseKit baseKit2 = kit;
            BaseOptions options = BaseOptions.getOptions(kit.getClass());
            if (options != null && (kbl = options.getKeyBindingList()) != null) {
                keyBindingsList.addAll(kbl);
            }
        }
        return keyBindingsList;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.componentRef.get();
    }

    private void addPresenters(DataFolder baseFolder, DataFolder mimeFolder) {
        BaseKit kit;
        List keyBindingsList = this.getKeyBindingList();
        JTextComponent c = this.getComponent();
        BaseKit baseKit = kit = c != null ? Utilities.getKit((JTextComponent)c) : null;
        if (kit instanceof BaseKit) {
            BaseKit baseKit2 = kit;
            Iterator it = NbEditorToolBar.getToolbarObjects(baseFolder, mimeFolder).iterator();
            while (it.hasNext()) {
                DataObject dob = (DataObject)it.next();
                InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbEditorToolBar.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic != null) {
                    try {
                        if ((class$javax$swing$JSeparator == null ? NbEditorToolBar.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(ic.instanceClass())) {
                            this.addSeparator();
                            continue;
                        }
                        Lookup actionContext = null;
                        Object obj = ic.instanceCreate();
                        if (obj instanceof ContextAwareAction) {
                            Action contextAware;
                            if (actionContext == null) {
                                actionContext = this.createActionContext();
                            }
                            Action action = contextAware = actionContext == null ? null : ((ContextAwareAction)obj).createContextAwareInstance(actionContext);
                            if (contextAware instanceof Presenter.Toolbar || contextAware instanceof Component) {
                                obj = contextAware;
                            }
                        }
                        if (obj instanceof Presenter.Toolbar) {
                            Component tbp = ((Presenter.Toolbar)obj).getToolbarPresenter();
                            this.add(tbp);
                            if (!(tbp instanceof AbstractButton)) continue;
                            this.processButton((AbstractButton)tbp);
                            continue;
                        }
                        if (!(obj instanceof Component)) continue;
                        this.add((Component)obj);
                        if (!(obj instanceof AbstractButton)) continue;
                        this.processButton((AbstractButton)obj);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    continue;
                }
                String actionName = dob.getName();
                Action a = baseKit2.getActionByName(actionName);
                if (a == null) continue;
                Object icon = a.getValue("SmallIcon");
                if (icon == null) {
                    Image img;
                    String resourceId = (String)a.getValue("IconResource");
                    if (resourceId == null) {
                        resourceId = "org/netbeans/modules/editor/resources/default.gif";
                    }
                    if ((img = org.openide.util.Utilities.loadImage((String)resourceId)) != null) {
                        a.putValue("SmallIcon", new ImageIcon(img));
                    }
                }
                JButton button = this.add(a);
                Iterator kbIt = keyBindingsList.iterator();
                while (kbIt.hasNext()) {
                    Object o = kbIt.next();
                    if (!(o instanceof MultiKeyBinding)) continue;
                    MultiKeyBinding binding = (MultiKeyBinding)o;
                    if (!actionName.equals(binding.actionName)) continue;
                    button.setToolTipText(button.getToolTipText() + " (" + NbEditorToolBar.getMnemonic(binding) + ")");
                    break;
                }
                this.processButton(button);
            }
        }
    }

    Lookup createActionContext() {
        DataObject dobj;
        JTextComponent c = this.getComponent();
        Lookup nodeLookup = null;
        DataObject dataObject = dobj = c != null ? NbEditorUtilities.getDataObject(c.getDocument()) : null;
        if (dobj != null) {
            nodeLookup = dobj.getNodeDelegate().getLookup();
        }
        Lookup ancestorLookup = null;
        for (Container comp = c; comp != null; comp = comp.getParent()) {
            Lookup lookup;
            if (!(comp instanceof Lookup.Provider) || (lookup = ((Lookup.Provider)comp).getLookup()) == null) continue;
            ancestorLookup = lookup;
            break;
        }
        if (nodeLookup == null) {
            return ancestorLookup;
        }
        if (ancestorLookup == null) {
            return nodeLookup;
        }
        if (!($assertionsDisabled || nodeLookup != null && ancestorLookup != null)) {
            throw new AssertionError();
        }
        Node node = (Node)nodeLookup.lookup(Node.class);
        boolean ancestorLookupContainsNode = ancestorLookup.lookup(new Lookup.Template(Node.class)).allInstances().contains(node);
        if (ancestorLookupContainsNode) {
            return ancestorLookup;
        }
        return new ProxyLookup(new Lookup[]{nodeLookup, ancestorLookup});
    }

    private void processButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.addActionListener(sharedActionListener);
        button.setMargin(BUTTON_INSETS);
        if (button instanceof JButton) {
            button.addMouseListener(sharedMouseListener);
        }
        button.setFocusable(false);
    }

    static List getToolbarObjects(DataFolder baseFolder, DataFolder mimeFolder) {
        HashMap name2dob = new HashMap();
        HashMap edges = new HashMap();
        if (baseFolder != null) {
            NbEditorToolBar.addDataObjects(name2dob, baseFolder.getChildren());
        }
        if (mimeFolder != null) {
            NbEditorToolBar.addDataObjects(name2dob, mimeFolder.getChildren());
        }
        if (baseFolder != null) {
            NbEditorToolBar.addEdges(edges, name2dob, baseFolder);
        }
        if (mimeFolder != null) {
            NbEditorToolBar.addEdges(edges, name2dob, mimeFolder);
        }
        try {
            return org.openide.util.Utilities.topologicalSort(name2dob.values(), edges);
        }
        catch (TopologicalSortException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return ex.partialSort();
        }
    }

    private static void addDataObjects(Map name2dob, DataObject[] addDobs) {
        int addDobsLength = addDobs.length;
        for (int i = 0; i < addDobsLength; ++i) {
            DataObject dob = addDobs[i];
            String dobName = dob.getPrimaryFile().getNameExt();
            name2dob.put(dobName, dob);
        }
    }

    private static void addEdges(Map edges, Map name2dob, DataFolder toolbarFolder) {
        FileObject primaryFile = toolbarFolder.getPrimaryFile();
        Enumeration e = primaryFile.getAttributes();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            int slashIndex = name.indexOf("/");
            if (slashIndex == -1 || !((value = primaryFile.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            String name1 = name.substring(0, slashIndex);
            String name2 = name.substring(slashIndex + 1);
            if (debugSort) {
                System.err.println("SORT-PAIR: [" + name1 + ", " + name2 + "]");
            }
            DataObject dob = (DataObject)name2dob.get(name1);
            DataObject target = (DataObject)name2dob.get(name2);
            if (dob == null || target == null) continue;
            Collection<DataObject> targetVertices = (List<DataObject>)edges.get(dob);
            if (targetVertices == null) {
                targetVertices = Collections.singletonList(target);
                edges.put(dob, targetVertices);
                continue;
            }
            if (targetVertices.size() == 1) {
                targetVertices = new HashSet<DataObject>(targetVertices);
                targetVertices.add(target);
                edges.put(dob, targetVertices);
                continue;
            }
            targetVertices.add(target);
        }
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        JTextComponent comp = this.getComponent();
        if (editorActionName != null && comp != null) {
            Action a;
            EditorKit kit;
            TextUI ui = comp.getUI();
            Keymap km = comp.getKeymap();
            if (ui != null && km != null && (kit = ui.getEditorKit(comp)) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null) {
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    ret = keys;
                } else {
                    MultiKeymap km2 = ((BaseKit)kit).getKeymap();
                    KeyStroke[] keys2 = km2.getKeyStrokesForAction(a);
                    if (keys2 != null && keys2.length > 0) {
                        ret = keys2;
                    }
                }
            }
        }
        return ret;
    }

    static {
        $assertionsDisabled = !NbEditorToolBar.class.desiredAssertionStatus();
        debugSort = Boolean.getBoolean("netbeans.debug.editor.toolbar.sort");
        BUTTON_INSETS = new Insets(2, 1, 0, 1);
        returnFocusRunnable = new Runnable(){

            public void run() {
                JTextComponent c = Utilities.getLastActiveComponent();
                if (c != null) {
                    ((Component)c).requestFocus();
                }
            }
        };
        sharedActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(returnFocusRunnable);
            }
        };
        sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                JButton button;
                if (evt.getSource() instanceof JButton && (button = (JButton)evt.getSource()).isEnabled()) {
                    button.setContentAreaFilled(true);
                    button.setBorderPainted(true);
                }
            }

            public void mouseExited(MouseEvent evt) {
                if (evt.getSource() instanceof JButton) {
                    JButton button = (JButton)evt.getSource();
                    button.setContentAreaFilled(false);
                    button.setBorderPainted(false);
                }
            }

            protected void showPopup(MouseEvent evt) {
            }
        };
        NOOP_ACTION = new NoOpAction();
    }

    private static final class NoOpAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }
    }
}

